using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class LiveTemplateModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public ISource<RdLiveTemplateInitialData> ExecuteTemplate { get { return _ExecuteTemplate; }}
    [NotNull] public RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> RequestLookupItems { get { return _RequestLookupItems; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdLiveTemplateInitialData> _ExecuteTemplate;
    [NotNull] private readonly RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> _RequestLookupItems;
    
    //primary constructor
    private LiveTemplateModel(
      [NotNull] RdSignal<RdLiveTemplateInitialData> executeTemplate,
      [NotNull] RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup> requestLookupItems
    )
    {
      if (executeTemplate == null) throw new ArgumentNullException("executeTemplate");
      if (requestLookupItems == null) throw new ArgumentNullException("requestLookupItems");
      
      _ExecuteTemplate = executeTemplate;
      _RequestLookupItems = requestLookupItems;
      BindableChildren.Add(new KeyValuePair<string, object>("executeTemplate", _ExecuteTemplate));
      BindableChildren.Add(new KeyValuePair<string, object>("requestLookupItems", _RequestLookupItems));
    }
    //secondary constructor
    internal LiveTemplateModel (
    ) : this (
      new RdSignal<RdLiveTemplateInitialData>(RdLiveTemplateInitialData.Read, RdLiveTemplateInitialData.Write),
      new RdEndpoint<RdLiveTemplateSnapshot, RdLiveTemplateLookup>(RdLiveTemplateSnapshot.Read, RdLiveTemplateSnapshot.Write, RdLiveTemplateLookup.Read, RdLiveTemplateLookup.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -6678828505976186127L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdLiveTemplateMacro.Read, RdLiveTemplateMacro.Write);
      serializers.Register(RdLiveTemplateVariable.Read, RdLiveTemplateVariable.Write);
      serializers.Register(RdLiveTemplateInitialData.Read, RdLiveTemplateInitialData.Write);
      serializers.Register(RdLiveTemplateSnapshot.Read, RdLiveTemplateSnapshot.Write);
      serializers.Register(RdLiveTemplateLookup.Read, RdLiveTemplateLookup.Write);
      serializers.Register(RdLiveTemplateMacroArg.Read, RdLiveTemplateMacroArg.Write);
      serializers.Register(RdLiveTemplateVariableRange.Read, RdLiveTemplateVariableRange.Write);
      serializers.Register(RdLiveTemplateLookupItem.Read, RdLiveTemplateLookupItem.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LiveTemplateModel (");
      using (printer.IndentCookie()) {
        printer.Print("executeTemplate = "); _ExecuteTemplate.PrintEx(printer); printer.Println();
        printer.Print("requestLookupItems = "); _RequestLookupItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionLiveTemplateModelEx
   {
    public static LiveTemplateModel GetLiveTemplateHost(this Solution solution)
    {
      return solution.GetOrCreateExtension("liveTemplateModel", () => new LiveTemplateModel());
    }
  }
  
  
  public class RdLiveTemplateInitialData : IPrintable, IEquatable<RdLiveTemplateInitialData> {
    //fields
    //public fields
    [NotNull] public TextControlId TextControl {get; private set;}
    [NotNull] public List<RdLiveTemplateVariable> Variables {get; private set;}
    public int EndOffset {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateInitialData(
      [NotNull] TextControlId textControl,
      [NotNull] List<RdLiveTemplateVariable> variables,
      int endOffset
    )
    {
      if (textControl == null) throw new ArgumentNullException("textControl");
      if (variables == null) throw new ArgumentNullException("variables");
      
      TextControl = textControl;
      Variables = variables;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateInitialData> Read = (ctx, reader) => 
    {
      var textControl = TextControlId.Read(ctx, reader);
      var variables = ReadRdLiveTemplateVariableList(ctx, reader);
      var endOffset = reader.ReadInt();
      return new RdLiveTemplateInitialData(textControl, variables, endOffset);
    };
    public static CtxReadDelegate<List<RdLiveTemplateVariable>> ReadRdLiveTemplateVariableList = RdLiveTemplateVariable.Read.List();
    
    public static CtxWriteDelegate<RdLiveTemplateInitialData> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.TextControl);
      WriteRdLiveTemplateVariableList(ctx, writer, value.Variables);
      writer.Write(value.EndOffset);
    };
    public static CtxWriteDelegate<List<RdLiveTemplateVariable>> WriteRdLiveTemplateVariableList = RdLiveTemplateVariable.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateInitialData) obj);
    }
    public bool Equals(RdLiveTemplateInitialData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControl, other.TextControl) && Variables.SequenceEqual(other.Variables) && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextControl.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Variables);
        hash = hash * 31 + EndOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateInitialData (");
      using (printer.IndentCookie()) {
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("variables = "); Variables.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateLookup : IPrintable, IEquatable<RdLiveTemplateLookup> {
    //fields
    //public fields
    [NotNull] public List<RdLiveTemplateLookupItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateLookup(
      [NotNull] List<RdLiveTemplateLookupItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateLookup> Read = (ctx, reader) => 
    {
      var items = ReadRdLiveTemplateLookupItemList(ctx, reader);
      return new RdLiveTemplateLookup(items);
    };
    public static CtxReadDelegate<List<RdLiveTemplateLookupItem>> ReadRdLiveTemplateLookupItemList = RdLiveTemplateLookupItem.Read.List();
    
    public static CtxWriteDelegate<RdLiveTemplateLookup> Write = (ctx, writer, value) => 
    {
      WriteRdLiveTemplateLookupItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdLiveTemplateLookupItem>> WriteRdLiveTemplateLookupItemList = RdLiveTemplateLookupItem.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateLookup) obj);
    }
    public bool Equals(RdLiveTemplateLookup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateLookup (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateLookupItem : IPrintable, IEquatable<RdLiveTemplateLookupItem> {
    //fields
    //public fields
    [NotNull] public string DisplayName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateLookupItem(
      [NotNull] string displayName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      
      DisplayName = displayName;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateLookupItem> Read = (ctx, reader) => 
    {
      var displayName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new RdLiveTemplateLookupItem(displayName, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdLiveTemplateLookupItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.DisplayName);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateLookupItem) obj);
    }
    public bool Equals(RdLiveTemplateLookupItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return DisplayName == other.DisplayName && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DisplayName.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateLookupItem (");
      using (printer.IndentCookie()) {
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateMacro : IPrintable, IEquatable<RdLiveTemplateMacro> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public List<RdLiveTemplateMacroArg> Args {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateMacro(
      [NotNull] string name,
      [NotNull] List<RdLiveTemplateMacroArg> args
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (args == null) throw new ArgumentNullException("args");
      
      Name = name;
      Args = args;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateMacro> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var args = ReadRdLiveTemplateMacroArgList(ctx, reader);
      return new RdLiveTemplateMacro(name, args);
    };
    public static CtxReadDelegate<List<RdLiveTemplateMacroArg>> ReadRdLiveTemplateMacroArgList = RdLiveTemplateMacroArg.Read.List();
    
    public static CtxWriteDelegate<RdLiveTemplateMacro> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteRdLiveTemplateMacroArgList(ctx, writer, value.Args);
    };
    public static CtxWriteDelegate<List<RdLiveTemplateMacroArg>> WriteRdLiveTemplateMacroArgList = RdLiveTemplateMacroArg.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateMacro) obj);
    }
    public bool Equals(RdLiveTemplateMacro other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Args.SequenceEqual(other.Args);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Args);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateMacro (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("args = "); Args.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateMacroArg : IPrintable, IEquatable<RdLiveTemplateMacroArg> {
    //fields
    //public fields
    [NotNull] public string Type {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateMacroArg(
      [NotNull] string type,
      [NotNull] string value
    )
    {
      if (type == null) throw new ArgumentNullException("type");
      if (value == null) throw new ArgumentNullException("value");
      
      Type = type;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateMacroArg> Read = (ctx, reader) => 
    {
      var type = reader.ReadString();
      var value = reader.ReadString();
      return new RdLiveTemplateMacroArg(type, value);
    };
    
    public static CtxWriteDelegate<RdLiveTemplateMacroArg> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Type);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateMacroArg) obj);
    }
    public bool Equals(RdLiveTemplateMacroArg other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Type == other.Type && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Type.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateMacroArg (");
      using (printer.IndentCookie()) {
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateSnapshot : IPrintable, IEquatable<RdLiveTemplateSnapshot> {
    //fields
    //public fields
    [NotNull] public TextControlId TextControl {get; private set;}
    public int CaretOffset {get; private set;}
    [NotNull] public List<RdLiveTemplateVariable> Variables {get; private set;}
    public int CurrentVariable {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateSnapshot(
      [NotNull] TextControlId textControl,
      int caretOffset,
      [NotNull] List<RdLiveTemplateVariable> variables,
      int currentVariable
    )
    {
      if (textControl == null) throw new ArgumentNullException("textControl");
      if (variables == null) throw new ArgumentNullException("variables");
      
      TextControl = textControl;
      CaretOffset = caretOffset;
      Variables = variables;
      CurrentVariable = currentVariable;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateSnapshot> Read = (ctx, reader) => 
    {
      var textControl = TextControlId.Read(ctx, reader);
      var caretOffset = reader.ReadInt();
      var variables = ReadRdLiveTemplateVariableList(ctx, reader);
      var currentVariable = reader.ReadInt();
      return new RdLiveTemplateSnapshot(textControl, caretOffset, variables, currentVariable);
    };
    public static CtxReadDelegate<List<RdLiveTemplateVariable>> ReadRdLiveTemplateVariableList = RdLiveTemplateVariable.Read.List();
    
    public static CtxWriteDelegate<RdLiveTemplateSnapshot> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.TextControl);
      writer.Write(value.CaretOffset);
      WriteRdLiveTemplateVariableList(ctx, writer, value.Variables);
      writer.Write(value.CurrentVariable);
    };
    public static CtxWriteDelegate<List<RdLiveTemplateVariable>> WriteRdLiveTemplateVariableList = RdLiveTemplateVariable.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateSnapshot) obj);
    }
    public bool Equals(RdLiveTemplateSnapshot other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControl, other.TextControl) && CaretOffset == other.CaretOffset && Variables.SequenceEqual(other.Variables) && CurrentVariable == other.CurrentVariable;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextControl.GetHashCode();
        hash = hash * 31 + CaretOffset.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Variables);
        hash = hash * 31 + CurrentVariable.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
        printer.Print("caretOffset = "); CaretOffset.PrintEx(printer); printer.Println();
        printer.Print("variables = "); Variables.PrintEx(printer); printer.Println();
        printer.Print("currentVariable = "); CurrentVariable.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateVariable : IPrintable, IEquatable<RdLiveTemplateVariable> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string CurrentValue {get; private set;}
    public bool IsStopAt {get; private set;}
    [NotNull] public List<RdLiveTemplateVariableRange> Ranges {get; private set;}
    [NotNull] public RdLiveTemplateMacro Macro {get; private set;}
    [NotNull] public List<string> LookupItems {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateVariable(
      [NotNull] string name,
      [NotNull] string currentValue,
      bool isStopAt,
      [NotNull] List<RdLiveTemplateVariableRange> ranges,
      [NotNull] RdLiveTemplateMacro macro,
      [NotNull] List<string> lookupItems
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (currentValue == null) throw new ArgumentNullException("currentValue");
      if (ranges == null) throw new ArgumentNullException("ranges");
      if (macro == null) throw new ArgumentNullException("macro");
      if (lookupItems == null) throw new ArgumentNullException("lookupItems");
      
      Name = name;
      CurrentValue = currentValue;
      IsStopAt = isStopAt;
      Ranges = ranges;
      Macro = macro;
      LookupItems = lookupItems;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateVariable> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var currentValue = reader.ReadString();
      var isStopAt = reader.ReadBool();
      var ranges = ReadRdLiveTemplateVariableRangeList(ctx, reader);
      var macro = RdLiveTemplateMacro.Read(ctx, reader);
      var lookupItems = ReadStringList(ctx, reader);
      return new RdLiveTemplateVariable(name, currentValue, isStopAt, ranges, macro, lookupItems);
    };
    public static CtxReadDelegate<List<RdLiveTemplateVariableRange>> ReadRdLiveTemplateVariableRangeList = RdLiveTemplateVariableRange.Read.List();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdLiveTemplateVariable> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.CurrentValue);
      writer.Write(value.IsStopAt);
      WriteRdLiveTemplateVariableRangeList(ctx, writer, value.Ranges);
      RdLiveTemplateMacro.Write(ctx, writer, value.Macro);
      WriteStringList(ctx, writer, value.LookupItems);
    };
    public static CtxWriteDelegate<List<RdLiveTemplateVariableRange>> WriteRdLiveTemplateVariableRangeList = RdLiveTemplateVariableRange.Write.List();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateVariable) obj);
    }
    public bool Equals(RdLiveTemplateVariable other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && CurrentValue == other.CurrentValue && IsStopAt == other.IsStopAt && Ranges.SequenceEqual(other.Ranges) && Equals(Macro, other.Macro) && LookupItems.SequenceEqual(other.LookupItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + CurrentValue.GetHashCode();
        hash = hash * 31 + IsStopAt.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Ranges);
        hash = hash * 31 + Macro.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(LookupItems);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateVariable (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("currentValue = "); CurrentValue.PrintEx(printer); printer.Println();
        printer.Print("isStopAt = "); IsStopAt.PrintEx(printer); printer.Println();
        printer.Print("ranges = "); Ranges.PrintEx(printer); printer.Println();
        printer.Print("macro = "); Macro.PrintEx(printer); printer.Println();
        printer.Print("lookupItems = "); LookupItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLiveTemplateVariableRange : IPrintable, IEquatable<RdLiveTemplateVariableRange> {
    //fields
    //public fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //private fields
    //primary constructor
    public RdLiveTemplateVariableRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLiveTemplateVariableRange> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new RdLiveTemplateVariableRange(startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<RdLiveTemplateVariableRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLiveTemplateVariableRange) obj);
    }
    public bool Equals(RdLiveTemplateVariableRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLiveTemplateVariableRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
