using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class MarkupPreviewModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> Ready { get { return _Ready; }}
    [NotNull] public IViewableMap<string, MarkupPreview> AvailablePreviews { get { return _AvailablePreviews; }}
    [NotNull] public IRdProperty<string> ActivePreviewId { get { return _ActivePreviewId; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Ready;
    [NotNull] private readonly RdMap<string, MarkupPreview> _AvailablePreviews;
    [NotNull] private readonly RdProperty<string> _ActivePreviewId;
    
    //primary constructor
    private MarkupPreviewModel(
      [NotNull] RdSignal<RdVoid> ready,
      [NotNull] RdMap<string, MarkupPreview> availablePreviews,
      [NotNull] RdProperty<string> activePreviewId
    )
    {
      if (ready == null) throw new ArgumentNullException("ready");
      if (availablePreviews == null) throw new ArgumentNullException("availablePreviews");
      if (activePreviewId == null) throw new ArgumentNullException("activePreviewId");
      
      _Ready = ready;
      _AvailablePreviews = availablePreviews;
      _ActivePreviewId = activePreviewId;
      _ActivePreviewId.OptimizeNested = true;
      _ActivePreviewId.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("ready", _Ready));
      BindableChildren.Add(new KeyValuePair<string, object>("availablePreviews", _AvailablePreviews));
      BindableChildren.Add(new KeyValuePair<string, object>("activePreviewId", _ActivePreviewId));
    }
    //secondary constructor
    private MarkupPreviewModel (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdMap<string, MarkupPreview>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, MarkupPreview.Read, MarkupPreview.Write),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    
    protected override long SerializationHash => -5598678795071794222L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(MarkupPreviewImage.Read, MarkupPreviewImage.Write);
      serializers.RegisterEnum<MarkupPreviewState>();
      serializers.Register(MarkupPreview.Read, MarkupPreview.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public MarkupPreviewModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupPreviewModel (");
      using (printer.IndentCookie()) {
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("availablePreviews = "); _AvailablePreviews.PrintEx(printer); printer.Println();
        printer.Print("activePreviewId = "); _ActivePreviewId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MarkupPreview : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string PresentableName {get; private set;}
    [NotNull] public IRdProperty<MarkupPreviewImage> PreviewImage { get { return _PreviewImage; }}
    [NotNull] public IRdProperty<string> StatusMessage { get { return _StatusMessage; }}
    [NotNull] public IRdProperty<string> StatusDetails { get { return _StatusDetails; }}
    [NotNull] public IRdProperty<MarkupPreviewState> Status { get { return _Status; }}
    
    //private fields
    [NotNull] private readonly RdProperty<MarkupPreviewImage> _PreviewImage;
    [NotNull] private readonly RdProperty<string> _StatusMessage;
    [NotNull] private readonly RdProperty<string> _StatusDetails;
    [NotNull] private readonly RdProperty<MarkupPreviewState> _Status;
    
    //primary constructor
    private MarkupPreview(
      [NotNull] string id,
      [NotNull] string presentableName,
      [NotNull] RdProperty<MarkupPreviewImage> previewImage,
      [NotNull] RdProperty<string> statusMessage,
      [NotNull] RdProperty<string> statusDetails,
      [NotNull] RdProperty<MarkupPreviewState> status
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (presentableName == null) throw new ArgumentNullException("presentableName");
      if (previewImage == null) throw new ArgumentNullException("previewImage");
      if (statusMessage == null) throw new ArgumentNullException("statusMessage");
      if (statusDetails == null) throw new ArgumentNullException("statusDetails");
      if (status == null) throw new ArgumentNullException("status");
      
      Id = id;
      PresentableName = presentableName;
      _PreviewImage = previewImage;
      _StatusMessage = statusMessage;
      _StatusDetails = statusDetails;
      _Status = status;
      _StatusMessage.OptimizeNested = true;
      _StatusDetails.OptimizeNested = true;
      _Status.OptimizeNested = true;
      _PreviewImage.ValueCanBeNull = true;
      _StatusMessage.ValueCanBeNull = true;
      _StatusDetails.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("previewImage", _PreviewImage));
      BindableChildren.Add(new KeyValuePair<string, object>("statusMessage", _StatusMessage));
      BindableChildren.Add(new KeyValuePair<string, object>("statusDetails", _StatusDetails));
      BindableChildren.Add(new KeyValuePair<string, object>("status", _Status));
    }
    //secondary constructor
    public MarkupPreview (
      [NotNull] string id,
      [NotNull] string presentableName
    ) : this (
      id,
      presentableName,
      new RdProperty<MarkupPreviewImage>(ReadMarkupPreviewImageNullable, WriteMarkupPreviewImageNullable),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<MarkupPreviewState>(ReadMarkupPreviewState, WriteMarkupPreviewState)
    ) {}
    //statics
    
    public static CtxReadDelegate<MarkupPreview> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadString();
      var presentableName = reader.ReadString();
      var previewImage = RdProperty<MarkupPreviewImage>.Read(ctx, reader, ReadMarkupPreviewImageNullable, WriteMarkupPreviewImageNullable);
      var statusMessage = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var statusDetails = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var status = RdProperty<MarkupPreviewState>.Read(ctx, reader, ReadMarkupPreviewState, WriteMarkupPreviewState);
      return new MarkupPreview(id, presentableName, previewImage, statusMessage, statusDetails, status).WithId(_id);
    };
    public static CtxReadDelegate<MarkupPreviewImage> ReadMarkupPreviewImageNullable = MarkupPreviewImage.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<MarkupPreviewState> ReadMarkupPreviewState = new CtxReadDelegate<MarkupPreviewState>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<MarkupPreviewState>);
    
    public static CtxWriteDelegate<MarkupPreview> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.PresentableName);
      RdProperty<MarkupPreviewImage>.Write(ctx, writer, value._PreviewImage);
      RdProperty<string>.Write(ctx, writer, value._StatusMessage);
      RdProperty<string>.Write(ctx, writer, value._StatusDetails);
      RdProperty<MarkupPreviewState>.Write(ctx, writer, value._Status);
    };
    public static CtxWriteDelegate<MarkupPreviewImage> WriteMarkupPreviewImageNullable = MarkupPreviewImage.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<MarkupPreviewState> WriteMarkupPreviewState = new CtxWriteDelegate<MarkupPreviewState>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<MarkupPreviewState>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupPreview (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("presentableName = "); PresentableName.PrintEx(printer); printer.Println();
        printer.Print("previewImage = "); _PreviewImage.PrintEx(printer); printer.Println();
        printer.Print("statusMessage = "); _StatusMessage.PrintEx(printer); printer.Println();
        printer.Print("statusDetails = "); _StatusDetails.PrintEx(printer); printer.Println();
        printer.Print("status = "); _Status.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MarkupPreviewImage : RdBindableBase {
    //fields
    //public fields
    [CanBeNull] public List<byte> Bytes {get; private set;}
    public double Height {get; private set;}
    public double Width {get; private set;}
    
    //private fields
    //primary constructor
    public MarkupPreviewImage(
      [CanBeNull] List<byte> bytes,
      double height,
      double width
    )
    {
      Bytes = bytes;
      Height = height;
      Width = width;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MarkupPreviewImage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var bytes = ReadByteListNullable(ctx, reader);
      var height = reader.ReadDouble();
      var width = reader.ReadDouble();
      return new MarkupPreviewImage(bytes, height, width).WithId(_id);
    };
    public static CtxReadDelegate<List<byte>> ReadByteListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadByte.List().NullableClass();
    
    public static CtxWriteDelegate<MarkupPreviewImage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteByteListNullable(ctx, writer, value.Bytes);
      writer.Write(value.Height);
      writer.Write(value.Width);
    };
    public static CtxWriteDelegate<List<byte>> WriteByteListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteByte.List().NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupPreviewImage (");
      using (printer.IndentCookie()) {
        printer.Print("bytes = "); Bytes.PrintEx(printer); printer.Println();
        printer.Print("height = "); Height.PrintEx(printer); printer.Println();
        printer.Print("width = "); Width.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MarkupPreviewState {
    Processing,
    Success,
    NotSupported,
    Error
  }
}
