using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.TestFramework
{
  
  
  [JetBrains.Application.ShellComponent]
  public class MockBackendModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<TestCommand, RdVoid> ExecuteCommand { get { return _ExecuteCommand; }}
    [NotNull] public RdEndpoint<RestoreXamarinComponentsCommand, RestoreResult> RestoreXamarinComponents { get { return _RestoreXamarinComponents; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.TestFramework.Primitives> Primitives { get { return _Primitives; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<TestCommand, RdVoid> _ExecuteCommand;
    [NotNull] private readonly RdEndpoint<RestoreXamarinComponentsCommand, RestoreResult> _RestoreXamarinComponents;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.TestFramework.Primitives> _Primitives;
    
    //primary constructor
    private MockBackendModel(
      [NotNull] RdEndpoint<TestCommand, RdVoid> executeCommand,
      [NotNull] RdEndpoint<RestoreXamarinComponentsCommand, RestoreResult> restoreXamarinComponents,
      [NotNull] RdProperty<JetBrains.Rider.Model.TestFramework.Primitives> primitives
    )
    {
      if (executeCommand == null) throw new ArgumentNullException("executeCommand");
      if (restoreXamarinComponents == null) throw new ArgumentNullException("restoreXamarinComponents");
      if (primitives == null) throw new ArgumentNullException("primitives");
      
      _ExecuteCommand = executeCommand;
      _RestoreXamarinComponents = restoreXamarinComponents;
      _Primitives = primitives;
      BindableChildren.Add(new KeyValuePair<string, object>("executeCommand", _ExecuteCommand));
      BindableChildren.Add(new KeyValuePair<string, object>("restoreXamarinComponents", _RestoreXamarinComponents));
      BindableChildren.Add(new KeyValuePair<string, object>("primitives", _Primitives));
    }
    //secondary constructor
    private MockBackendModel (
    ) : this (
      new RdEndpoint<TestCommand, RdVoid>(TestCommand.Read, TestCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RestoreXamarinComponentsCommand, RestoreResult>(RestoreXamarinComponentsCommand.Read, RestoreXamarinComponentsCommand.Write, RestoreResult.Read, RestoreResult.Write),
      new RdProperty<JetBrains.Rider.Model.TestFramework.Primitives>(JetBrains.Rider.Model.TestFramework.Primitives.Read, JetBrains.Rider.Model.TestFramework.Primitives.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -6729482722080253200L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(JetBrains.Rider.Model.TestFramework.Primitives.Read, JetBrains.Rider.Model.TestFramework.Primitives.Write);
      serializers.RegisterEnum<BackendActivitiesKind>();
      serializers.Register(TestCommand.Read, TestCommand.Write);
      serializers.Register(RestoreXamarinComponentsCommand.Read, RestoreXamarinComponentsCommand.Write);
      serializers.Register(RestoreResult.Read, RestoreResult.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public MockBackendModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MockBackendModel (");
      using (printer.IndentCookie()) {
        printer.Print("executeCommand = "); _ExecuteCommand.PrintEx(printer); printer.Println();
        printer.Print("restoreXamarinComponents = "); _RestoreXamarinComponents.PrintEx(printer); printer.Println();
        printer.Print("primitives = "); _Primitives.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BackendActivitiesKind {
    InsertTextInFocusedTextControl,
    ChangeFocusedTextControlAndCaret
  }
  
  
  public class Primitives : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISink<bool> InBool { get { return _InBool; }}
    [NotNull] public ISink<short> InShort { get { return _InShort; }}
    [NotNull] public ISink<int> InInt { get { return _InInt; }}
    [NotNull] public ISink<long> InLong { get { return _InLong; }}
    [NotNull] public ISink<float> InFloat { get { return _InFloat; }}
    [NotNull] public ISink<double> InDouble { get { return _InDouble; }}
    [NotNull] public ISink<char> InChar { get { return _InChar; }}
    [NotNull] public ISink<string> InString { get { return _InString; }}
    [NotNull] public ISink<byte[]> InByteArray { get { return _InByteArray; }}
    [NotNull] public ISink<Guid> InGuid { get { return _InGuid; }}
    [NotNull] public ISink<DateTime> InDateTime { get { return _InDateTime; }}
    [NotNull] public ISink<Uri> InUri { get { return _InUri; }}
    [NotNull] public ISink<RdId> InRdId { get { return _InRdId; }}
    [NotNull] public ISource<bool> OutBool { get { return _OutBool; }}
    [NotNull] public ISource<short> OutShort { get { return _OutShort; }}
    [NotNull] public ISource<int> OutInt { get { return _OutInt; }}
    [NotNull] public ISource<long> OutLong { get { return _OutLong; }}
    [NotNull] public ISource<float> OutFloat { get { return _OutFloat; }}
    [NotNull] public ISource<double> OutDouble { get { return _OutDouble; }}
    [NotNull] public ISource<char> OutChar { get { return _OutChar; }}
    [NotNull] public ISource<string> OutString { get { return _OutString; }}
    [NotNull] public ISource<byte[]> OutByteArray { get { return _OutByteArray; }}
    [NotNull] public ISource<Guid> OutGuid { get { return _OutGuid; }}
    [NotNull] public ISource<DateTime> OutDateTime { get { return _OutDateTime; }}
    [NotNull] public ISource<Uri> OutUri { get { return _OutUri; }}
    [NotNull] public ISource<RdId> OutRdId { get { return _OutRdId; }}
    [NotNull] public IRdProperty<string> OutAll { get { return _OutAll; }}
    
    //private fields
    [NotNull] private readonly RdSignal<bool> _InBool;
    [NotNull] private readonly RdSignal<short> _InShort;
    [NotNull] private readonly RdSignal<int> _InInt;
    [NotNull] private readonly RdSignal<long> _InLong;
    [NotNull] private readonly RdSignal<float> _InFloat;
    [NotNull] private readonly RdSignal<double> _InDouble;
    [NotNull] private readonly RdSignal<char> _InChar;
    [NotNull] private readonly RdSignal<string> _InString;
    [NotNull] private readonly RdSignal<byte[]> _InByteArray;
    [NotNull] private readonly RdSignal<Guid> _InGuid;
    [NotNull] private readonly RdSignal<DateTime> _InDateTime;
    [NotNull] private readonly RdSignal<Uri> _InUri;
    [NotNull] private readonly RdSignal<RdId> _InRdId;
    [NotNull] private readonly RdSignal<bool> _OutBool;
    [NotNull] private readonly RdSignal<short> _OutShort;
    [NotNull] private readonly RdSignal<int> _OutInt;
    [NotNull] private readonly RdSignal<long> _OutLong;
    [NotNull] private readonly RdSignal<float> _OutFloat;
    [NotNull] private readonly RdSignal<double> _OutDouble;
    [NotNull] private readonly RdSignal<char> _OutChar;
    [NotNull] private readonly RdSignal<string> _OutString;
    [NotNull] private readonly RdSignal<byte[]> _OutByteArray;
    [NotNull] private readonly RdSignal<Guid> _OutGuid;
    [NotNull] private readonly RdSignal<DateTime> _OutDateTime;
    [NotNull] private readonly RdSignal<Uri> _OutUri;
    [NotNull] private readonly RdSignal<RdId> _OutRdId;
    [NotNull] private readonly RdProperty<string> _OutAll;
    
    //primary constructor
    private Primitives(
      [NotNull] RdSignal<bool> inBool,
      [NotNull] RdSignal<short> inShort,
      [NotNull] RdSignal<int> inInt,
      [NotNull] RdSignal<long> inLong,
      [NotNull] RdSignal<float> inFloat,
      [NotNull] RdSignal<double> inDouble,
      [NotNull] RdSignal<char> inChar,
      [NotNull] RdSignal<string> inString,
      [NotNull] RdSignal<byte[]> inByteArray,
      [NotNull] RdSignal<Guid> inGuid,
      [NotNull] RdSignal<DateTime> inDateTime,
      [NotNull] RdSignal<Uri> inUri,
      [NotNull] RdSignal<RdId> inRdId,
      [NotNull] RdSignal<bool> outBool,
      [NotNull] RdSignal<short> outShort,
      [NotNull] RdSignal<int> outInt,
      [NotNull] RdSignal<long> outLong,
      [NotNull] RdSignal<float> outFloat,
      [NotNull] RdSignal<double> outDouble,
      [NotNull] RdSignal<char> outChar,
      [NotNull] RdSignal<string> outString,
      [NotNull] RdSignal<byte[]> outByteArray,
      [NotNull] RdSignal<Guid> outGuid,
      [NotNull] RdSignal<DateTime> outDateTime,
      [NotNull] RdSignal<Uri> outUri,
      [NotNull] RdSignal<RdId> outRdId,
      [NotNull] RdProperty<string> outAll
    )
    {
      if (inBool == null) throw new ArgumentNullException("inBool");
      if (inShort == null) throw new ArgumentNullException("inShort");
      if (inInt == null) throw new ArgumentNullException("inInt");
      if (inLong == null) throw new ArgumentNullException("inLong");
      if (inFloat == null) throw new ArgumentNullException("inFloat");
      if (inDouble == null) throw new ArgumentNullException("inDouble");
      if (inChar == null) throw new ArgumentNullException("inChar");
      if (inString == null) throw new ArgumentNullException("inString");
      if (inByteArray == null) throw new ArgumentNullException("inByteArray");
      if (inGuid == null) throw new ArgumentNullException("inGuid");
      if (inDateTime == null) throw new ArgumentNullException("inDateTime");
      if (inUri == null) throw new ArgumentNullException("inUri");
      if (inRdId == null) throw new ArgumentNullException("inRdId");
      if (outBool == null) throw new ArgumentNullException("outBool");
      if (outShort == null) throw new ArgumentNullException("outShort");
      if (outInt == null) throw new ArgumentNullException("outInt");
      if (outLong == null) throw new ArgumentNullException("outLong");
      if (outFloat == null) throw new ArgumentNullException("outFloat");
      if (outDouble == null) throw new ArgumentNullException("outDouble");
      if (outChar == null) throw new ArgumentNullException("outChar");
      if (outString == null) throw new ArgumentNullException("outString");
      if (outByteArray == null) throw new ArgumentNullException("outByteArray");
      if (outGuid == null) throw new ArgumentNullException("outGuid");
      if (outDateTime == null) throw new ArgumentNullException("outDateTime");
      if (outUri == null) throw new ArgumentNullException("outUri");
      if (outRdId == null) throw new ArgumentNullException("outRdId");
      if (outAll == null) throw new ArgumentNullException("outAll");
      
      _InBool = inBool;
      _InShort = inShort;
      _InInt = inInt;
      _InLong = inLong;
      _InFloat = inFloat;
      _InDouble = inDouble;
      _InChar = inChar;
      _InString = inString;
      _InByteArray = inByteArray;
      _InGuid = inGuid;
      _InDateTime = inDateTime;
      _InUri = inUri;
      _InRdId = inRdId;
      _OutBool = outBool;
      _OutShort = outShort;
      _OutInt = outInt;
      _OutLong = outLong;
      _OutFloat = outFloat;
      _OutDouble = outDouble;
      _OutChar = outChar;
      _OutString = outString;
      _OutByteArray = outByteArray;
      _OutGuid = outGuid;
      _OutDateTime = outDateTime;
      _OutUri = outUri;
      _OutRdId = outRdId;
      _OutAll = outAll;
      _OutAll.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("inBool", _InBool));
      BindableChildren.Add(new KeyValuePair<string, object>("inShort", _InShort));
      BindableChildren.Add(new KeyValuePair<string, object>("inInt", _InInt));
      BindableChildren.Add(new KeyValuePair<string, object>("inLong", _InLong));
      BindableChildren.Add(new KeyValuePair<string, object>("inFloat", _InFloat));
      BindableChildren.Add(new KeyValuePair<string, object>("inDouble", _InDouble));
      BindableChildren.Add(new KeyValuePair<string, object>("inChar", _InChar));
      BindableChildren.Add(new KeyValuePair<string, object>("inString", _InString));
      BindableChildren.Add(new KeyValuePair<string, object>("inByteArray", _InByteArray));
      BindableChildren.Add(new KeyValuePair<string, object>("inGuid", _InGuid));
      BindableChildren.Add(new KeyValuePair<string, object>("inDateTime", _InDateTime));
      BindableChildren.Add(new KeyValuePair<string, object>("inUri", _InUri));
      BindableChildren.Add(new KeyValuePair<string, object>("inRdId", _InRdId));
      BindableChildren.Add(new KeyValuePair<string, object>("outBool", _OutBool));
      BindableChildren.Add(new KeyValuePair<string, object>("outShort", _OutShort));
      BindableChildren.Add(new KeyValuePair<string, object>("outInt", _OutInt));
      BindableChildren.Add(new KeyValuePair<string, object>("outLong", _OutLong));
      BindableChildren.Add(new KeyValuePair<string, object>("outFloat", _OutFloat));
      BindableChildren.Add(new KeyValuePair<string, object>("outDouble", _OutDouble));
      BindableChildren.Add(new KeyValuePair<string, object>("outChar", _OutChar));
      BindableChildren.Add(new KeyValuePair<string, object>("outString", _OutString));
      BindableChildren.Add(new KeyValuePair<string, object>("outByteArray", _OutByteArray));
      BindableChildren.Add(new KeyValuePair<string, object>("outGuid", _OutGuid));
      BindableChildren.Add(new KeyValuePair<string, object>("outDateTime", _OutDateTime));
      BindableChildren.Add(new KeyValuePair<string, object>("outUri", _OutUri));
      BindableChildren.Add(new KeyValuePair<string, object>("outRdId", _OutRdId));
      BindableChildren.Add(new KeyValuePair<string, object>("outAll", _OutAll));
    }
    //secondary constructor
    public Primitives (
    ) : this (
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<short>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadShort, JetBrains.Platform.RdFramework.Impl.Serializers.WriteShort),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<long>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong),
      new RdSignal<float>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadFloat, JetBrains.Platform.RdFramework.Impl.Serializers.WriteFloat),
      new RdSignal<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble),
      new RdSignal<char>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<byte[]>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadByteArray, JetBrains.Platform.RdFramework.Impl.Serializers.WriteByteArray),
      new RdSignal<Guid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid),
      new RdSignal<DateTime>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDateTime, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDateTime),
      new RdSignal<Uri>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri, JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri),
      new RdSignal<RdId>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadRdId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteRdId),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<short>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadShort, JetBrains.Platform.RdFramework.Impl.Serializers.WriteShort),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<long>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong),
      new RdSignal<float>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadFloat, JetBrains.Platform.RdFramework.Impl.Serializers.WriteFloat),
      new RdSignal<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble),
      new RdSignal<char>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<byte[]>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadByteArray, JetBrains.Platform.RdFramework.Impl.Serializers.WriteByteArray),
      new RdSignal<Guid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid),
      new RdSignal<DateTime>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDateTime, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDateTime),
      new RdSignal<Uri>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri, JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri),
      new RdSignal<RdId>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadRdId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteRdId),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<Primitives> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var inBool = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var inShort = RdSignal<short>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadShort, JetBrains.Platform.RdFramework.Impl.Serializers.WriteShort);
      var inInt = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var inLong = RdSignal<long>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong);
      var inFloat = RdSignal<float>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadFloat, JetBrains.Platform.RdFramework.Impl.Serializers.WriteFloat);
      var inDouble = RdSignal<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      var inChar = RdSignal<char>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar);
      var inString = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var inByteArray = RdSignal<byte[]>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadByteArray, JetBrains.Platform.RdFramework.Impl.Serializers.WriteByteArray);
      var inGuid = RdSignal<Guid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid);
      var inDateTime = RdSignal<DateTime>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDateTime, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDateTime);
      var inUri = RdSignal<Uri>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri, JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri);
      var inRdId = RdSignal<RdId>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadRdId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteRdId);
      var outBool = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var outShort = RdSignal<short>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadShort, JetBrains.Platform.RdFramework.Impl.Serializers.WriteShort);
      var outInt = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var outLong = RdSignal<long>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong);
      var outFloat = RdSignal<float>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadFloat, JetBrains.Platform.RdFramework.Impl.Serializers.WriteFloat);
      var outDouble = RdSignal<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      var outChar = RdSignal<char>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar);
      var outString = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var outByteArray = RdSignal<byte[]>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadByteArray, JetBrains.Platform.RdFramework.Impl.Serializers.WriteByteArray);
      var outGuid = RdSignal<Guid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid);
      var outDateTime = RdSignal<DateTime>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDateTime, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDateTime);
      var outUri = RdSignal<Uri>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadUri, JetBrains.Platform.RdFramework.Impl.Serializers.WriteUri);
      var outRdId = RdSignal<RdId>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadRdId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteRdId);
      var outAll = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new Primitives(inBool, inShort, inInt, inLong, inFloat, inDouble, inChar, inString, inByteArray, inGuid, inDateTime, inUri, inRdId, outBool, outShort, outInt, outLong, outFloat, outDouble, outChar, outString, outByteArray, outGuid, outDateTime, outUri, outRdId, outAll).WithId(_id);
    };
    
    public static CtxWriteDelegate<Primitives> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<bool>.Write(ctx, writer, value._InBool);
      RdSignal<short>.Write(ctx, writer, value._InShort);
      RdSignal<int>.Write(ctx, writer, value._InInt);
      RdSignal<long>.Write(ctx, writer, value._InLong);
      RdSignal<float>.Write(ctx, writer, value._InFloat);
      RdSignal<double>.Write(ctx, writer, value._InDouble);
      RdSignal<char>.Write(ctx, writer, value._InChar);
      RdSignal<string>.Write(ctx, writer, value._InString);
      RdSignal<byte[]>.Write(ctx, writer, value._InByteArray);
      RdSignal<Guid>.Write(ctx, writer, value._InGuid);
      RdSignal<DateTime>.Write(ctx, writer, value._InDateTime);
      RdSignal<Uri>.Write(ctx, writer, value._InUri);
      RdSignal<RdId>.Write(ctx, writer, value._InRdId);
      RdSignal<bool>.Write(ctx, writer, value._OutBool);
      RdSignal<short>.Write(ctx, writer, value._OutShort);
      RdSignal<int>.Write(ctx, writer, value._OutInt);
      RdSignal<long>.Write(ctx, writer, value._OutLong);
      RdSignal<float>.Write(ctx, writer, value._OutFloat);
      RdSignal<double>.Write(ctx, writer, value._OutDouble);
      RdSignal<char>.Write(ctx, writer, value._OutChar);
      RdSignal<string>.Write(ctx, writer, value._OutString);
      RdSignal<byte[]>.Write(ctx, writer, value._OutByteArray);
      RdSignal<Guid>.Write(ctx, writer, value._OutGuid);
      RdSignal<DateTime>.Write(ctx, writer, value._OutDateTime);
      RdSignal<Uri>.Write(ctx, writer, value._OutUri);
      RdSignal<RdId>.Write(ctx, writer, value._OutRdId);
      RdProperty<string>.Write(ctx, writer, value._OutAll);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Primitives (");
      using (printer.IndentCookie()) {
        printer.Print("inBool = "); _InBool.PrintEx(printer); printer.Println();
        printer.Print("inShort = "); _InShort.PrintEx(printer); printer.Println();
        printer.Print("inInt = "); _InInt.PrintEx(printer); printer.Println();
        printer.Print("inLong = "); _InLong.PrintEx(printer); printer.Println();
        printer.Print("inFloat = "); _InFloat.PrintEx(printer); printer.Println();
        printer.Print("inDouble = "); _InDouble.PrintEx(printer); printer.Println();
        printer.Print("inChar = "); _InChar.PrintEx(printer); printer.Println();
        printer.Print("inString = "); _InString.PrintEx(printer); printer.Println();
        printer.Print("inByteArray = "); _InByteArray.PrintEx(printer); printer.Println();
        printer.Print("inGuid = "); _InGuid.PrintEx(printer); printer.Println();
        printer.Print("inDateTime = "); _InDateTime.PrintEx(printer); printer.Println();
        printer.Print("inUri = "); _InUri.PrintEx(printer); printer.Println();
        printer.Print("inRdId = "); _InRdId.PrintEx(printer); printer.Println();
        printer.Print("outBool = "); _OutBool.PrintEx(printer); printer.Println();
        printer.Print("outShort = "); _OutShort.PrintEx(printer); printer.Println();
        printer.Print("outInt = "); _OutInt.PrintEx(printer); printer.Println();
        printer.Print("outLong = "); _OutLong.PrintEx(printer); printer.Println();
        printer.Print("outFloat = "); _OutFloat.PrintEx(printer); printer.Println();
        printer.Print("outDouble = "); _OutDouble.PrintEx(printer); printer.Println();
        printer.Print("outChar = "); _OutChar.PrintEx(printer); printer.Println();
        printer.Print("outString = "); _OutString.PrintEx(printer); printer.Println();
        printer.Print("outByteArray = "); _OutByteArray.PrintEx(printer); printer.Println();
        printer.Print("outGuid = "); _OutGuid.PrintEx(printer); printer.Println();
        printer.Print("outDateTime = "); _OutDateTime.PrintEx(printer); printer.Println();
        printer.Print("outUri = "); _OutUri.PrintEx(printer); printer.Println();
        printer.Print("outRdId = "); _OutRdId.PrintEx(printer); printer.Println();
        printer.Print("outAll = "); _OutAll.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RestoreResult : IPrintable, IEquatable<RestoreResult> {
    //fields
    //public fields
    public bool Value {get; private set;}
    [NotNull] public string Reason {get; private set;}
    
    //private fields
    //primary constructor
    public RestoreResult(
      bool value,
      [NotNull] string reason
    )
    {
      if (reason == null) throw new ArgumentNullException("reason");
      
      Value = value;
      Reason = reason;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RestoreResult> Read = (ctx, reader) => 
    {
      var value = reader.ReadBool();
      var reason = reader.ReadString();
      return new RestoreResult(value, reason);
    };
    
    public static CtxWriteDelegate<RestoreResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
      writer.Write(value.Reason);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RestoreResult) obj);
    }
    public bool Equals(RestoreResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value && Reason == other.Reason;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        hash = hash * 31 + Reason.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RestoreResult (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
        printer.Print("reason = "); Reason.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RestoreXamarinComponentsCommand : IPrintable, IEquatable<RestoreXamarinComponentsCommand> {
    //fields
    //public fields
    [NotNull] public string SolutionFile {get; private set;}
    [NotNull] public string Login {get; private set;}
    [NotNull] public string Pass {get; private set;}
    public int TimeoutMs {get; private set;}
    
    //private fields
    //primary constructor
    public RestoreXamarinComponentsCommand(
      [NotNull] string solutionFile,
      [NotNull] string login,
      [NotNull] string pass,
      int timeoutMs
    )
    {
      if (solutionFile == null) throw new ArgumentNullException("solutionFile");
      if (login == null) throw new ArgumentNullException("login");
      if (pass == null) throw new ArgumentNullException("pass");
      
      SolutionFile = solutionFile;
      Login = login;
      Pass = pass;
      TimeoutMs = timeoutMs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RestoreXamarinComponentsCommand> Read = (ctx, reader) => 
    {
      var solutionFile = reader.ReadString();
      var login = reader.ReadString();
      var pass = reader.ReadString();
      var timeoutMs = reader.ReadInt();
      return new RestoreXamarinComponentsCommand(solutionFile, login, pass, timeoutMs);
    };
    
    public static CtxWriteDelegate<RestoreXamarinComponentsCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFile);
      writer.Write(value.Login);
      writer.Write(value.Pass);
      writer.Write(value.TimeoutMs);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RestoreXamarinComponentsCommand) obj);
    }
    public bool Equals(RestoreXamarinComponentsCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionFile == other.SolutionFile && Login == other.Login && Pass == other.Pass && TimeoutMs == other.TimeoutMs;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SolutionFile.GetHashCode();
        hash = hash * 31 + Login.GetHashCode();
        hash = hash * 31 + Pass.GetHashCode();
        hash = hash * 31 + TimeoutMs.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RestoreXamarinComponentsCommand (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFile = "); SolutionFile.PrintEx(printer); printer.Println();
        printer.Print("login = "); Login.PrintEx(printer); printer.Println();
        printer.Print("pass = "); Pass.PrintEx(printer); printer.Println();
        printer.Print("timeoutMs = "); TimeoutMs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TestCommand : IPrintable, IEquatable<TestCommand> {
    //fields
    //public fields
    public BackendActivitiesKind Kind {get; private set;}
    [CanBeNull] public string Text {get; private set;}
    [CanBeNull] public int? Number {get; private set;}
    
    //private fields
    //primary constructor
    public TestCommand(
      BackendActivitiesKind kind,
      [CanBeNull] string text,
      [CanBeNull] int? number
    )
    {
      Kind = kind;
      Text = text;
      Number = number;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TestCommand> Read = (ctx, reader) => 
    {
      var kind = (BackendActivitiesKind)reader.ReadInt();
      var text = ReadStringNullable(ctx, reader);
      var number = ReadIntNullable(ctx, reader);
      return new TestCommand(kind, text, number);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<TestCommand> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Text);
      WriteIntNullable(ctx, writer, value.Number);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TestCommand) obj);
    }
    public bool Equals(TestCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Text, other.Text) && Equals(Number, other.Number);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + (Text != null ?Text.GetHashCode() : 0);
        hash = hash * 31 + (Number != null ?Number.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TestCommand (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("number = "); Number.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
