using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class OptionsUtils : RdExtBase {
    //fields
    //public fields
    [NotNull] public ISource<SettingsLayer> Open { get { return _Open; }}
    [NotNull] public ISource<string> OpenPage { get { return _OpenPage; }}
    
    //private fields
    [NotNull] private readonly RdSignal<SettingsLayer> _Open;
    [NotNull] private readonly RdSignal<string> _OpenPage;
    
    //primary constructor
    private OptionsUtils(
      [NotNull] RdSignal<SettingsLayer> open,
      [NotNull] RdSignal<string> openPage
    )
    {
      if (open == null) throw new ArgumentNullException("open");
      if (openPage == null) throw new ArgumentNullException("openPage");
      
      _Open = open;
      _OpenPage = openPage;
      _Open.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("open", _Open));
      BindableChildren.Add(new KeyValuePair<string, object>("openPage", _OpenPage));
    }
    //secondary constructor
    private OptionsUtils (
    ) : this (
      new RdSignal<SettingsLayer>(ReadSettingsLayerNullable, WriteSettingsLayerNullable),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<SettingsLayer> ReadSettingsLayerNullable = SettingsLayer.Read.NullableClass();
    
    public static CtxWriteDelegate<SettingsLayer> WriteSettingsLayerNullable = SettingsLayer.Write.NullableClass();
    
    protected override long SerializationHash => -4576304871461941009L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public OptionsUtils(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("OptionsUtils (");
      using (printer.IndentCookie()) {
        printer.Print("open = "); _Open.PrintEx(printer); printer.Println();
        printer.Print("openPage = "); _OpenPage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
