using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class ProjectTemplatesModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdProjectTemplateSession> Session { get { return _Session; }}
    [NotNull] public RdEndpoint<RdExpandSolutionFileCommand, RdVoid> ExpandSolutionFile { get { return _ExpandSolutionFile; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdProjectTemplateSession> _Session;
    [NotNull] private readonly RdEndpoint<RdExpandSolutionFileCommand, RdVoid> _ExpandSolutionFile;
    
    //primary constructor
    private ProjectTemplatesModel(
      [NotNull] RdProperty<RdProjectTemplateSession> session,
      [NotNull] RdEndpoint<RdExpandSolutionFileCommand, RdVoid> expandSolutionFile
    )
    {
      if (session == null) throw new ArgumentNullException("session");
      if (expandSolutionFile == null) throw new ArgumentNullException("expandSolutionFile");
      
      _Session = session;
      _ExpandSolutionFile = expandSolutionFile;
      _Session.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("session", _Session));
      BindableChildren.Add(new KeyValuePair<string, object>("expandSolutionFile", _ExpandSolutionFile));
    }
    //secondary constructor
    private ProjectTemplatesModel (
    ) : this (
      new RdProperty<RdProjectTemplateSession>(ReadRdProjectTemplateSessionNullable, WriteRdProjectTemplateSessionNullable),
      new RdEndpoint<RdExpandSolutionFileCommand, RdVoid>(RdExpandSolutionFileCommand.Read, RdExpandSolutionFileCommand.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateSession> ReadRdProjectTemplateSessionNullable = RdProjectTemplateSession.Read.NullableClass();
    
    public static CtxWriteDelegate<RdProjectTemplateSession> WriteRdProjectTemplateSessionNullable = RdProjectTemplateSession.Write.NullableClass();
    
    protected override long SerializationHash => 60245093967705087L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdStringPair.Read, RdStringPair.Write);
      serializers.Register(RdProjectTemplate.Read, RdProjectTemplate.Write);
      serializers.Register(RdProjectTemplateGroupOption.Read, RdProjectTemplateGroupOption.Write);
      serializers.Register(RdProjectTemplateGroupParameter.Read, RdProjectTemplateGroupParameter.Write);
      serializers.Register(RdProjectTemplateTextParameter.Read, RdProjectTemplateTextParameter.Write);
      serializers.Register(RdProjectTemplateInvalidParameter.Read, RdProjectTemplateInvalidParameter.Write);
      serializers.Register(RdNoDotNetCoreMessage.Read, RdNoDotNetCoreMessage.Write);
      serializers.Register(RdProjectTemplateCategory.Read, RdProjectTemplateCategory.Write);
      serializers.Register(RdProjectTemplatePlatform.Read, RdProjectTemplatePlatform.Write);
      serializers.Register(RdExpandProjectTemplateCommand.Read, RdExpandProjectTemplateCommand.Write);
      serializers.Register(RdExpandProjectTemplateInfo.Read, RdExpandProjectTemplateInfo.Write);
      serializers.Register(RdExpandProjectTemplateResult.Read, RdExpandProjectTemplateResult.Write);
      serializers.Register(RdExpandSolutionFileCommand.Read, RdExpandSolutionFileCommand.Write);
      serializers.Register(RdProjectTemplateSource.Read, RdProjectTemplateSource.Write);
      serializers.Register(RdProjectTemplateSession.Read, RdProjectTemplateSession.Write);
      serializers.RegisterEnum<RdTextParameterStyle>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public ProjectTemplatesModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ProjectTemplatesModel (");
      using (printer.IndentCookie()) {
        printer.Print("session = "); _Session.PrintEx(printer); printer.Println();
        printer.Print("expandSolutionFile = "); _ExpandSolutionFile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandProjectTemplateCommand : IPrintable, IEquatable<RdExpandProjectTemplateCommand> {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Location {get; private set;}
    [NotNull] public string RelativeSolutionPath {get; private set;}
    [NotNull] public List<RdStringPair> Parameters {get; private set;}
    
    //private fields
    //primary constructor
    public RdExpandProjectTemplateCommand(
      [NotNull] string id,
      [NotNull] string name,
      [NotNull] string location,
      [NotNull] string relativeSolutionPath,
      [NotNull] List<RdStringPair> parameters
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (name == null) throw new ArgumentNullException("name");
      if (location == null) throw new ArgumentNullException("location");
      if (relativeSolutionPath == null) throw new ArgumentNullException("relativeSolutionPath");
      if (parameters == null) throw new ArgumentNullException("parameters");
      
      Id = id;
      Name = name;
      Location = location;
      RelativeSolutionPath = relativeSolutionPath;
      Parameters = parameters;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdExpandProjectTemplateCommand> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var name = reader.ReadString();
      var location = reader.ReadString();
      var relativeSolutionPath = reader.ReadString();
      var parameters = ReadRdStringPairList(ctx, reader);
      return new RdExpandProjectTemplateCommand(id, name, location, relativeSolutionPath, parameters);
    };
    public static CtxReadDelegate<List<RdStringPair>> ReadRdStringPairList = RdStringPair.Read.List();
    
    public static CtxWriteDelegate<RdExpandProjectTemplateCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.Name);
      writer.Write(value.Location);
      writer.Write(value.RelativeSolutionPath);
      WriteRdStringPairList(ctx, writer, value.Parameters);
    };
    public static CtxWriteDelegate<List<RdStringPair>> WriteRdStringPairList = RdStringPair.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExpandProjectTemplateCommand) obj);
    }
    public bool Equals(RdExpandProjectTemplateCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Name == other.Name && Location == other.Location && RelativeSolutionPath == other.RelativeSolutionPath && Parameters.SequenceEqual(other.Parameters);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        hash = hash * 31 + RelativeSolutionPath.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Parameters);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandProjectTemplateCommand (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
        printer.Print("relativeSolutionPath = "); RelativeSolutionPath.PrintEx(printer); printer.Println();
        printer.Print("parameters = "); Parameters.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandProjectTemplateInfo : IPrintable, IEquatable<RdExpandProjectTemplateInfo> {
    //fields
    //public fields
    [NotNull] public List<string> ProjectFiles {get; private set;}
    [NotNull] public List<RdFileToOpen> FilesToOpen {get; private set;}
    public bool Restore {get; private set;}
    
    //private fields
    //primary constructor
    public RdExpandProjectTemplateInfo(
      [NotNull] List<string> projectFiles,
      [NotNull] List<RdFileToOpen> filesToOpen,
      bool restore
    )
    {
      if (projectFiles == null) throw new ArgumentNullException("projectFiles");
      if (filesToOpen == null) throw new ArgumentNullException("filesToOpen");
      
      ProjectFiles = projectFiles;
      FilesToOpen = filesToOpen;
      Restore = restore;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdExpandProjectTemplateInfo> Read = (ctx, reader) => 
    {
      var projectFiles = ReadStringList(ctx, reader);
      var filesToOpen = ReadRdFileToOpenList(ctx, reader);
      var restore = reader.ReadBool();
      return new RdExpandProjectTemplateInfo(projectFiles, filesToOpen, restore);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<RdFileToOpen>> ReadRdFileToOpenList = RdFileToOpen.Read.List();
    
    public static CtxWriteDelegate<RdExpandProjectTemplateInfo> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.ProjectFiles);
      WriteRdFileToOpenList(ctx, writer, value.FilesToOpen);
      writer.Write(value.Restore);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<RdFileToOpen>> WriteRdFileToOpenList = RdFileToOpen.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExpandProjectTemplateInfo) obj);
    }
    public bool Equals(RdExpandProjectTemplateInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectFiles.SequenceEqual(other.ProjectFiles) && FilesToOpen.SequenceEqual(other.FilesToOpen) && Restore == other.Restore;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ProjectFiles);
        hash = hash * 31 + Collections.GetHashCode(FilesToOpen);
        hash = hash * 31 + Restore.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandProjectTemplateInfo (");
      using (printer.IndentCookie()) {
        printer.Print("projectFiles = "); ProjectFiles.PrintEx(printer); printer.Println();
        printer.Print("filesToOpen = "); FilesToOpen.PrintEx(printer); printer.Println();
        printer.Print("restore = "); Restore.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandProjectTemplateResult : IPrintable, IEquatable<RdExpandProjectTemplateResult> {
    //fields
    //public fields
    [CanBeNull] public RdExpandProjectTemplateInfo Info {get; private set;}
    [CanBeNull] public string ErrorMessage {get; private set;}
    
    //private fields
    //primary constructor
    public RdExpandProjectTemplateResult(
      [CanBeNull] RdExpandProjectTemplateInfo info,
      [CanBeNull] string errorMessage
    )
    {
      Info = info;
      ErrorMessage = errorMessage;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdExpandProjectTemplateResult> Read = (ctx, reader) => 
    {
      var info = ReadRdExpandProjectTemplateInfoNullable(ctx, reader);
      var errorMessage = ReadStringNullable(ctx, reader);
      return new RdExpandProjectTemplateResult(info, errorMessage);
    };
    public static CtxReadDelegate<RdExpandProjectTemplateInfo> ReadRdExpandProjectTemplateInfoNullable = RdExpandProjectTemplateInfo.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdExpandProjectTemplateResult> Write = (ctx, writer, value) => 
    {
      WriteRdExpandProjectTemplateInfoNullable(ctx, writer, value.Info);
      WriteStringNullable(ctx, writer, value.ErrorMessage);
    };
    public static CtxWriteDelegate<RdExpandProjectTemplateInfo> WriteRdExpandProjectTemplateInfoNullable = RdExpandProjectTemplateInfo.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExpandProjectTemplateResult) obj);
    }
    public bool Equals(RdExpandProjectTemplateResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Info, other.Info) && Equals(ErrorMessage, other.ErrorMessage);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Info != null ?Info.GetHashCode() : 0);
        hash = hash * 31 + (ErrorMessage != null ?ErrorMessage.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandProjectTemplateResult (");
      using (printer.IndentCookie()) {
        printer.Print("info = "); Info.PrintEx(printer); printer.Println();
        printer.Print("errorMessage = "); ErrorMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExpandSolutionFileCommand : IPrintable, IEquatable<RdExpandSolutionFileCommand> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Location {get; private set;}
    [NotNull] public List<string> ProjectFiles {get; private set;}
    
    //private fields
    //primary constructor
    public RdExpandSolutionFileCommand(
      [NotNull] string name,
      [NotNull] string location,
      [NotNull] List<string> projectFiles
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (location == null) throw new ArgumentNullException("location");
      if (projectFiles == null) throw new ArgumentNullException("projectFiles");
      
      Name = name;
      Location = location;
      ProjectFiles = projectFiles;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdExpandSolutionFileCommand> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var location = reader.ReadString();
      var projectFiles = ReadStringList(ctx, reader);
      return new RdExpandSolutionFileCommand(name, location, projectFiles);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdExpandSolutionFileCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.Location);
      WriteStringList(ctx, writer, value.ProjectFiles);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExpandSolutionFileCommand) obj);
    }
    public bool Equals(RdExpandSolutionFileCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Location == other.Location && ProjectFiles.SequenceEqual(other.ProjectFiles);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Location.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ProjectFiles);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExpandSolutionFileCommand (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
        printer.Print("projectFiles = "); ProjectFiles.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdNoDotNetCoreMessage : RdProjectTemplateContent
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdNoDotNetCoreMessage> Read = (ctx, reader) => 
    {
      return new RdNoDotNetCoreMessage();
    };
    
    public static new CtxWriteDelegate<RdNoDotNetCoreMessage> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdNoDotNetCoreMessage) obj);
    }
    public bool Equals(RdNoDotNetCoreMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdNoDotNetCoreMessage (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplate : RdProjectTemplateContent
   {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string DefaultName {get; private set;}
    public bool HasManyProjects {get; private set;}
    [NotNull] public List<RdStringPair> Diagnostic {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplate(
      [NotNull] string id,
      [NotNull] string defaultName,
      bool hasManyProjects,
      [NotNull] List<RdStringPair> diagnostic
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (defaultName == null) throw new ArgumentNullException("defaultName");
      if (diagnostic == null) throw new ArgumentNullException("diagnostic");
      
      Id = id;
      DefaultName = defaultName;
      HasManyProjects = hasManyProjects;
      Diagnostic = diagnostic;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectTemplate> Read = (ctx, reader) => 
    {
      var id = reader.ReadString();
      var defaultName = reader.ReadString();
      var hasManyProjects = reader.ReadBool();
      var diagnostic = ReadRdStringPairList(ctx, reader);
      return new RdProjectTemplate(id, defaultName, hasManyProjects, diagnostic);
    };
    public static CtxReadDelegate<List<RdStringPair>> ReadRdStringPairList = RdStringPair.Read.List();
    
    public static new CtxWriteDelegate<RdProjectTemplate> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.DefaultName);
      writer.Write(value.HasManyProjects);
      WriteRdStringPairList(ctx, writer, value.Diagnostic);
    };
    public static CtxWriteDelegate<List<RdStringPair>> WriteRdStringPairList = RdStringPair.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplate) obj);
    }
    public bool Equals(RdProjectTemplate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && DefaultName == other.DefaultName && HasManyProjects == other.HasManyProjects && Diagnostic.SequenceEqual(other.Diagnostic);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + DefaultName.GetHashCode();
        hash = hash * 31 + HasManyProjects.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Diagnostic);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplate (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("defaultName = "); DefaultName.PrintEx(printer); printer.Println();
        printer.Print("hasManyProjects = "); HasManyProjects.PrintEx(printer); printer.Println();
        printer.Print("diagnostic = "); Diagnostic.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateCategory : IPrintable, IEquatable<RdProjectTemplateCategory> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public RdProjectTemplateContent Content {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateCategory(
      [NotNull] string name,
      [NotNull] RdProjectTemplateContent content
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (content == null) throw new ArgumentNullException("content");
      
      Name = name;
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateCategory> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var content = RdProjectTemplateContent.Read(ctx, reader);
      return new RdProjectTemplateCategory(name, content);
    };
    
    public static CtxWriteDelegate<RdProjectTemplateCategory> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      RdProjectTemplateContent.Write(ctx, writer, value.Content);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateCategory) obj);
    }
    public bool Equals(RdProjectTemplateCategory other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(Content, other.Content);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Content.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateCategory (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdProjectTemplateContent {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateContent> Read = Polymorphic<RdProjectTemplateContent>.ReadAbstract(RdProjectTemplateContent_Unknown.Read);
    
    public static CtxWriteDelegate<RdProjectTemplateContent> Write = Polymorphic<RdProjectTemplateContent>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdProjectTemplateContent_Unknown : RdProjectTemplateContent
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectTemplateContent_Unknown> Read = (ctx, reader) => 
    {
      return new RdProjectTemplateContent_Unknown();
    };
    
    public static new CtxWriteDelegate<RdProjectTemplateContent_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateContent_Unknown) obj);
    }
    public bool Equals(RdProjectTemplateContent_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateContent_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateGroupOption : IPrintable, IEquatable<RdProjectTemplateGroupOption> {
    //fields
    //public fields
    [NotNull] public string Option {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    [NotNull] public RdProjectTemplateContent Item {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateGroupOption(
      [NotNull] string option,
      [NotNull] string presentation,
      [NotNull] RdProjectTemplateContent item
    )
    {
      if (option == null) throw new ArgumentNullException("option");
      if (presentation == null) throw new ArgumentNullException("presentation");
      if (item == null) throw new ArgumentNullException("item");
      
      Option = option;
      Presentation = presentation;
      Item = item;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateGroupOption> Read = (ctx, reader) => 
    {
      var option = reader.ReadString();
      var presentation = reader.ReadString();
      var item = RdProjectTemplateContent.Read(ctx, reader);
      return new RdProjectTemplateGroupOption(option, presentation, item);
    };
    
    public static CtxWriteDelegate<RdProjectTemplateGroupOption> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Option);
      writer.Write(value.Presentation);
      RdProjectTemplateContent.Write(ctx, writer, value.Item);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateGroupOption) obj);
    }
    public bool Equals(RdProjectTemplateGroupOption other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Option == other.Option && Presentation == other.Presentation && Equals(Item, other.Item);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Option.GetHashCode();
        hash = hash * 31 + Presentation.GetHashCode();
        hash = hash * 31 + Item.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateGroupOption (");
      using (printer.IndentCookie()) {
        printer.Print("option = "); Option.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
        printer.Print("item = "); Item.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateGroupParameter : RdProjectTemplateContent
   {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public string DefaultValue {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    [NotNull] public List<RdProjectTemplateGroupOption> Options {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateGroupParameter(
      [NotNull] string name,
      [CanBeNull] string defaultValue,
      [CanBeNull] string tooltip,
      [NotNull] List<RdProjectTemplateGroupOption> options
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (options == null) throw new ArgumentNullException("options");
      
      Name = name;
      DefaultValue = defaultValue;
      Tooltip = tooltip;
      Options = options;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectTemplateGroupParameter> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var defaultValue = ReadStringNullable(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var options = ReadRdProjectTemplateGroupOptionList(ctx, reader);
      return new RdProjectTemplateGroupParameter(name, defaultValue, tooltip, options);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<List<RdProjectTemplateGroupOption>> ReadRdProjectTemplateGroupOptionList = RdProjectTemplateGroupOption.Read.List();
    
    public static new CtxWriteDelegate<RdProjectTemplateGroupParameter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteStringNullable(ctx, writer, value.DefaultValue);
      WriteStringNullable(ctx, writer, value.Tooltip);
      WriteRdProjectTemplateGroupOptionList(ctx, writer, value.Options);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<List<RdProjectTemplateGroupOption>> WriteRdProjectTemplateGroupOptionList = RdProjectTemplateGroupOption.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateGroupParameter) obj);
    }
    public bool Equals(RdProjectTemplateGroupParameter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(DefaultValue, other.DefaultValue) && Equals(Tooltip, other.Tooltip) && Options.SequenceEqual(other.Options);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (DefaultValue != null ?DefaultValue.GetHashCode() : 0);
        hash = hash * 31 + (Tooltip != null ?Tooltip.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Options);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateGroupParameter (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("defaultValue = "); DefaultValue.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateInvalidParameter : RdProjectTemplateContent
   {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Message {get; private set;}
    [CanBeNull] public string Link {get; private set;}
    [CanBeNull] public string LineMessage {get; private set;}
    [CanBeNull] public string LineMessageAdditions {get; private set;}
    [NotNull] public RdProjectTemplateContent NextItem {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateInvalidParameter(
      [NotNull] string name,
      [NotNull] string message,
      [CanBeNull] string link,
      [CanBeNull] string lineMessage,
      [CanBeNull] string lineMessageAdditions,
      [NotNull] RdProjectTemplateContent nextItem
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (message == null) throw new ArgumentNullException("message");
      if (nextItem == null) throw new ArgumentNullException("nextItem");
      
      Name = name;
      Message = message;
      Link = link;
      LineMessage = lineMessage;
      LineMessageAdditions = lineMessageAdditions;
      NextItem = nextItem;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectTemplateInvalidParameter> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var message = reader.ReadString();
      var link = ReadStringNullable(ctx, reader);
      var lineMessage = ReadStringNullable(ctx, reader);
      var lineMessageAdditions = ReadStringNullable(ctx, reader);
      var nextItem = RdProjectTemplateContent.Read(ctx, reader);
      return new RdProjectTemplateInvalidParameter(name, message, link, lineMessage, lineMessageAdditions, nextItem);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdProjectTemplateInvalidParameter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.Message);
      WriteStringNullable(ctx, writer, value.Link);
      WriteStringNullable(ctx, writer, value.LineMessage);
      WriteStringNullable(ctx, writer, value.LineMessageAdditions);
      RdProjectTemplateContent.Write(ctx, writer, value.NextItem);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateInvalidParameter) obj);
    }
    public bool Equals(RdProjectTemplateInvalidParameter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Message == other.Message && Equals(Link, other.Link) && Equals(LineMessage, other.LineMessage) && Equals(LineMessageAdditions, other.LineMessageAdditions) && Equals(NextItem, other.NextItem);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        hash = hash * 31 + (Link != null ?Link.GetHashCode() : 0);
        hash = hash * 31 + (LineMessage != null ?LineMessage.GetHashCode() : 0);
        hash = hash * 31 + (LineMessageAdditions != null ?LineMessageAdditions.GetHashCode() : 0);
        hash = hash * 31 + NextItem.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateInvalidParameter (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("link = "); Link.PrintEx(printer); printer.Println();
        printer.Print("lineMessage = "); LineMessage.PrintEx(printer); printer.Println();
        printer.Print("lineMessageAdditions = "); LineMessageAdditions.PrintEx(printer); printer.Println();
        printer.Print("nextItem = "); NextItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplatePlatform : IPrintable, IEquatable<RdProjectTemplatePlatform> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public List<RdProjectTemplateCategory> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplatePlatform(
      [NotNull] string name,
      [NotNull] List<RdProjectTemplateCategory> items
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (items == null) throw new ArgumentNullException("items");
      
      Name = name;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectTemplatePlatform> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var items = ReadRdProjectTemplateCategoryList(ctx, reader);
      return new RdProjectTemplatePlatform(name, items);
    };
    public static CtxReadDelegate<List<RdProjectTemplateCategory>> ReadRdProjectTemplateCategoryList = RdProjectTemplateCategory.Read.List();
    
    public static CtxWriteDelegate<RdProjectTemplatePlatform> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteRdProjectTemplateCategoryList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdProjectTemplateCategory>> WriteRdProjectTemplateCategoryList = RdProjectTemplateCategory.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplatePlatform) obj);
    }
    public bool Equals(RdProjectTemplatePlatform other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplatePlatform (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<RdProjectTemplateSource> TemplateSources {get; private set;}
    [NotNull] public IRdProperty<List<RdProjectTemplatePlatform>> Templates { get { return _Templates; }}
    [NotNull] public RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult> ExpandProjectTemplate { get { return _ExpandProjectTemplate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<RdProjectTemplatePlatform>> _Templates;
    [NotNull] private readonly RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult> _ExpandProjectTemplate;
    
    //primary constructor
    private RdProjectTemplateSession(
      [NotNull] List<RdProjectTemplateSource> templateSources,
      [NotNull] RdProperty<List<RdProjectTemplatePlatform>> templates,
      [NotNull] RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult> expandProjectTemplate
    )
    {
      if (templateSources == null) throw new ArgumentNullException("templateSources");
      if (templates == null) throw new ArgumentNullException("templates");
      if (expandProjectTemplate == null) throw new ArgumentNullException("expandProjectTemplate");
      
      TemplateSources = templateSources;
      _Templates = templates;
      _ExpandProjectTemplate = expandProjectTemplate;
      _Templates.OptimizeNested = true;
      _Templates.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("templates", _Templates));
      BindableChildren.Add(new KeyValuePair<string, object>("expandProjectTemplate", _ExpandProjectTemplate));
    }
    //secondary constructor
    public RdProjectTemplateSession (
      [NotNull] List<RdProjectTemplateSource> templateSources
    ) : this (
      templateSources,
      new RdProperty<List<RdProjectTemplatePlatform>>(ReadRdProjectTemplatePlatformListNullable, WriteRdProjectTemplatePlatformListNullable),
      new RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult>(RdExpandProjectTemplateCommand.Read, RdExpandProjectTemplateCommand.Write, RdExpandProjectTemplateResult.Read, RdExpandProjectTemplateResult.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var templateSources = ReadRdProjectTemplateSourceList(ctx, reader);
      var templates = RdProperty<List<RdProjectTemplatePlatform>>.Read(ctx, reader, ReadRdProjectTemplatePlatformListNullable, WriteRdProjectTemplatePlatformListNullable);
      var expandProjectTemplate = RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult>.Read(ctx, reader, RdExpandProjectTemplateCommand.Read, RdExpandProjectTemplateCommand.Write, RdExpandProjectTemplateResult.Read, RdExpandProjectTemplateResult.Write);
      return new RdProjectTemplateSession(templateSources, templates, expandProjectTemplate).WithId(_id);
    };
    public static CtxReadDelegate<List<RdProjectTemplateSource>> ReadRdProjectTemplateSourceList = RdProjectTemplateSource.Read.List();
    public static CtxReadDelegate<List<RdProjectTemplatePlatform>> ReadRdProjectTemplatePlatformListNullable = RdProjectTemplatePlatform.Read.List().NullableClass();
    
    public static CtxWriteDelegate<RdProjectTemplateSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRdProjectTemplateSourceList(ctx, writer, value.TemplateSources);
      RdProperty<List<RdProjectTemplatePlatform>>.Write(ctx, writer, value._Templates);
      RdEndpoint<RdExpandProjectTemplateCommand, RdExpandProjectTemplateResult>.Write(ctx, writer, value._ExpandProjectTemplate);
    };
    public static CtxWriteDelegate<List<RdProjectTemplateSource>> WriteRdProjectTemplateSourceList = RdProjectTemplateSource.Write.List();
    public static CtxWriteDelegate<List<RdProjectTemplatePlatform>> WriteRdProjectTemplatePlatformListNullable = RdProjectTemplatePlatform.Write.List().NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateSession (");
      using (printer.IndentCookie()) {
        printer.Print("templateSources = "); TemplateSources.PrintEx(printer); printer.Println();
        printer.Print("templates = "); _Templates.PrintEx(printer); printer.Println();
        printer.Print("expandProjectTemplate = "); _ExpandProjectTemplate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateSource : IPrintable, IEquatable<RdProjectTemplateSource> {
    //fields
    //public fields
    [NotNull] public string Location {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateSource(
      [NotNull] string location
    )
    {
      if (location == null) throw new ArgumentNullException("location");
      
      Location = location;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdProjectTemplateSource> Read = (ctx, reader) => 
    {
      var location = reader.ReadString();
      return new RdProjectTemplateSource(location);
    };
    
    public static CtxWriteDelegate<RdProjectTemplateSource> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Location);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateSource) obj);
    }
    public bool Equals(RdProjectTemplateSource other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Location == other.Location;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Location.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateSource (");
      using (printer.IndentCookie()) {
        printer.Print("location = "); Location.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdProjectTemplateTextParameter : RdProjectTemplateContent
   {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [CanBeNull] public string DefaultValue {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    public RdTextParameterStyle Style {get; private set;}
    [NotNull] public RdProjectTemplateContent NextItem {get; private set;}
    
    //private fields
    //primary constructor
    public RdProjectTemplateTextParameter(
      [NotNull] string name,
      [CanBeNull] string defaultValue,
      [CanBeNull] string tooltip,
      RdTextParameterStyle style,
      [NotNull] RdProjectTemplateContent nextItem
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (nextItem == null) throw new ArgumentNullException("nextItem");
      
      Name = name;
      DefaultValue = defaultValue;
      Tooltip = tooltip;
      Style = style;
      NextItem = nextItem;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdProjectTemplateTextParameter> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var defaultValue = ReadStringNullable(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var style = (RdTextParameterStyle)reader.ReadInt();
      var nextItem = RdProjectTemplateContent.Read(ctx, reader);
      return new RdProjectTemplateTextParameter(name, defaultValue, tooltip, style, nextItem);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<RdProjectTemplateTextParameter> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      WriteStringNullable(ctx, writer, value.DefaultValue);
      WriteStringNullable(ctx, writer, value.Tooltip);
      writer.Write((int)value.Style);
      RdProjectTemplateContent.Write(ctx, writer, value.NextItem);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdProjectTemplateTextParameter) obj);
    }
    public bool Equals(RdProjectTemplateTextParameter other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Equals(DefaultValue, other.DefaultValue) && Equals(Tooltip, other.Tooltip) && Style == other.Style && Equals(NextItem, other.NextItem);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + (DefaultValue != null ?DefaultValue.GetHashCode() : 0);
        hash = hash * 31 + (Tooltip != null ?Tooltip.GetHashCode() : 0);
        hash = hash * 31 + (int) Style;
        hash = hash * 31 + NextItem.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectTemplateTextParameter (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("defaultValue = "); DefaultValue.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("style = "); Style.PrintEx(printer); printer.Println();
        printer.Print("nextItem = "); NextItem.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdStringPair : IPrintable, IEquatable<RdStringPair> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public RdStringPair(
      [NotNull] string name,
      [NotNull] string value
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (value == null) throw new ArgumentNullException("value");
      
      Name = name;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdStringPair> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var value = reader.ReadString();
      return new RdStringPair(name, value);
    };
    
    public static CtxWriteDelegate<RdStringPair> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdStringPair) obj);
    }
    public bool Equals(RdStringPair other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdStringPair (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdTextParameterStyle {
    FileChooser
  }
}
