using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class PsiElementRangeProvider : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> GetElementRange { get { return _GetElementRange; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> _GetElementRange;
    
    //primary constructor
    private PsiElementRangeProvider(
      [NotNull] RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult> getElementRange
    )
    {
      if (getElementRange == null) throw new ArgumentNullException("getElementRange");
      
      _GetElementRange = getElementRange;
      _GetElementRange.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getElementRange", _GetElementRange));
    }
    //secondary constructor
    internal PsiElementRangeProvider (
    ) : this (
      new RdEndpoint<HyperlinkHighlightingArgs, HyperlinkHighlightingResult>(HyperlinkHighlightingArgs.Read, HyperlinkHighlightingArgs.Write, ReadHyperlinkHighlightingResultNullable, WriteHyperlinkHighlightingResultNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingResult> ReadHyperlinkHighlightingResultNullable = HyperlinkHighlightingResult.Read.NullableClass();
    
    public static CtxWriteDelegate<HyperlinkHighlightingResult> WriteHyperlinkHighlightingResultNullable = HyperlinkHighlightingResult.Write.NullableClass();
    
    protected override long SerializationHash => 6007824380720179369L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RiderBrowseMode>();
      serializers.Register(HyperlinkHighlightingArgs.Read, HyperlinkHighlightingArgs.Write);
      serializers.Register(HyperlinkHighlightingResult.Read, HyperlinkHighlightingResult.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PsiElementRangeProvider (");
      using (printer.IndentCookie()) {
        printer.Print("getElementRange = "); _GetElementRange.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionPsiElementRangeProviderEx
   {
    public static PsiElementRangeProvider GetPsiElementRangeProvider(this Solution solution)
    {
      return solution.GetOrCreateExtension("psiElementRangeProvider", () => new PsiElementRangeProvider());
    }
  }
  
  
  public class HyperlinkHighlightingArgs : IPrintable, IEquatable<HyperlinkHighlightingArgs> {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    public int Offset {get; private set;}
    public RiderBrowseMode Mode {get; private set;}
    
    //private fields
    //primary constructor
    public HyperlinkHighlightingArgs(
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId,
      int offset,
      RiderBrowseMode mode
    )
    {
      if (textControlId == null) throw new ArgumentNullException("textControlId");
      
      TextControlId = textControlId;
      Offset = offset;
      Mode = mode;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingArgs> Read = (ctx, reader) => 
    {
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      var offset = reader.ReadInt();
      var mode = (RiderBrowseMode)reader.ReadInt();
      return new HyperlinkHighlightingArgs(textControlId, offset, mode);
    };
    
    public static CtxWriteDelegate<HyperlinkHighlightingArgs> Write = (ctx, writer, value) => 
    {
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
      writer.Write(value.Offset);
      writer.Write((int)value.Mode);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HyperlinkHighlightingArgs) obj);
    }
    public bool Equals(HyperlinkHighlightingArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextControlId, other.TextControlId) && Offset == other.Offset && Mode == other.Mode;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextControlId.GetHashCode();
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + (int) Mode;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HyperlinkHighlightingArgs (");
      using (printer.IndentCookie()) {
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("mode = "); Mode.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HyperlinkHighlightingResult : IPrintable, IEquatable<HyperlinkHighlightingResult> {
    //fields
    //public fields
    [NotNull] public RdTextRange TextRange {get; private set;}
    [NotNull] public string DocInfo {get; private set;}
    
    //private fields
    //primary constructor
    public HyperlinkHighlightingResult(
      [NotNull] RdTextRange textRange,
      [NotNull] string docInfo
    )
    {
      if (textRange == null) throw new ArgumentNullException("textRange");
      if (docInfo == null) throw new ArgumentNullException("docInfo");
      
      TextRange = textRange;
      DocInfo = docInfo;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HyperlinkHighlightingResult> Read = (ctx, reader) => 
    {
      var textRange = RdTextRange.Read(ctx, reader);
      var docInfo = reader.ReadString();
      return new HyperlinkHighlightingResult(textRange, docInfo);
    };
    
    public static CtxWriteDelegate<HyperlinkHighlightingResult> Write = (ctx, writer, value) => 
    {
      RdTextRange.Write(ctx, writer, value.TextRange);
      writer.Write(value.DocInfo);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HyperlinkHighlightingResult) obj);
    }
    public bool Equals(HyperlinkHighlightingResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(TextRange, other.TextRange) && DocInfo == other.DocInfo;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TextRange.GetHashCode();
        hash = hash * 31 + DocInfo.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HyperlinkHighlightingResult (");
      using (printer.IndentCookie()) {
        printer.Print("textRange = "); TextRange.PrintEx(printer); printer.Println();
        printer.Print("docInfo = "); DocInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RiderBrowseMode {
    None,
    Declaration,
    TypeDeclaration,
    Implementation
  }
}
