using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class PublishableProjectsModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<Guid, PublishableProjectModel> PublishableProjects { get { return _PublishableProjects; }}
    
    //private fields
    [NotNull] private readonly RdMap<Guid, PublishableProjectModel> _PublishableProjects;
    
    //primary constructor
    private PublishableProjectsModel(
      [NotNull] RdMap<Guid, PublishableProjectModel> publishableProjects
    )
    {
      if (publishableProjects == null) throw new ArgumentNullException("publishableProjects");
      
      _PublishableProjects = publishableProjects;
      BindableChildren.Add(new KeyValuePair<string, object>("publishableProjects", _PublishableProjects));
    }
    //secondary constructor
    internal PublishableProjectsModel (
    ) : this (
      new RdMap<Guid, PublishableProjectModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid, PublishableProjectModel.Read, PublishableProjectModel.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -2965761639908322910L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(PublishableProjectModel.Read, PublishableProjectModel.Write);
      serializers.Register(PublishXmlModel.Read, PublishXmlModel.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PublishableProjectsModel (");
      using (printer.IndentCookie()) {
        printer.Print("publishableProjects = "); _PublishableProjects.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionPublishableProjectsModelEx
   {
    public static PublishableProjectsModel GetPublishableProjectsModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("publishableProjectsModel", () => new PublishableProjectsModel());
    }
  }
  
  
  public class PublishXmlModel : IPrintable, IEquatable<PublishXmlModel> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    public bool RequiresElevation {get; private set;}
    public bool MissingTargets {get; private set;}
    [NotNull] public string PublishMethod {get; private set;}
    public bool RequiresCredentials {get; private set;}
    [CanBeNull] public string UserName {get; private set;}
    
    //private fields
    //primary constructor
    public PublishXmlModel(
      [NotNull] string name,
      bool requiresElevation,
      bool missingTargets,
      [NotNull] string publishMethod,
      bool requiresCredentials,
      [CanBeNull] string userName
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      if (publishMethod == null) throw new ArgumentNullException("publishMethod");
      
      Name = name;
      RequiresElevation = requiresElevation;
      MissingTargets = missingTargets;
      PublishMethod = publishMethod;
      RequiresCredentials = requiresCredentials;
      UserName = userName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PublishXmlModel> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var requiresElevation = reader.ReadBool();
      var missingTargets = reader.ReadBool();
      var publishMethod = reader.ReadString();
      var requiresCredentials = reader.ReadBool();
      var userName = ReadStringNullable(ctx, reader);
      return new PublishXmlModel(name, requiresElevation, missingTargets, publishMethod, requiresCredentials, userName);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<PublishXmlModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.RequiresElevation);
      writer.Write(value.MissingTargets);
      writer.Write(value.PublishMethod);
      writer.Write(value.RequiresCredentials);
      WriteStringNullable(ctx, writer, value.UserName);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PublishXmlModel) obj);
    }
    public bool Equals(PublishXmlModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && RequiresElevation == other.RequiresElevation && MissingTargets == other.MissingTargets && PublishMethod == other.PublishMethod && RequiresCredentials == other.RequiresCredentials && Equals(UserName, other.UserName);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + RequiresElevation.GetHashCode();
        hash = hash * 31 + MissingTargets.GetHashCode();
        hash = hash * 31 + PublishMethod.GetHashCode();
        hash = hash * 31 + RequiresCredentials.GetHashCode();
        hash = hash * 31 + (UserName != null ?UserName.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PublishXmlModel (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("requiresElevation = "); RequiresElevation.PrintEx(printer); printer.Println();
        printer.Print("missingTargets = "); MissingTargets.PrintEx(printer); printer.Println();
        printer.Print("publishMethod = "); PublishMethod.PrintEx(printer); printer.Println();
        printer.Print("requiresCredentials = "); RequiresCredentials.PrintEx(printer); printer.Println();
        printer.Print("userName = "); UserName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PublishableProjectModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ProjectName {get; private set;}
    public int ProjectModelId {get; private set;}
    [NotNull] public string ProjectFilePath {get; private set;}
    public bool IsDotNetCore {get; private set;}
    public bool IsWeb {get; private set;}
    [NotNull] public List<PublishXmlModel> PubXmls {get; private set;}
    
    //private fields
    //primary constructor
    public PublishableProjectModel(
      [NotNull] string projectName,
      int projectModelId,
      [NotNull] string projectFilePath,
      bool isDotNetCore,
      bool isWeb,
      [NotNull] List<PublishXmlModel> pubXmls
    )
    {
      if (projectName == null) throw new ArgumentNullException("projectName");
      if (projectFilePath == null) throw new ArgumentNullException("projectFilePath");
      if (pubXmls == null) throw new ArgumentNullException("pubXmls");
      
      ProjectName = projectName;
      ProjectModelId = projectModelId;
      ProjectFilePath = projectFilePath;
      IsDotNetCore = isDotNetCore;
      IsWeb = isWeb;
      PubXmls = pubXmls;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PublishableProjectModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projectName = reader.ReadString();
      var projectModelId = reader.ReadInt();
      var projectFilePath = reader.ReadString();
      var isDotNetCore = reader.ReadBool();
      var isWeb = reader.ReadBool();
      var pubXmls = ReadPublishXmlModelList(ctx, reader);
      return new PublishableProjectModel(projectName, projectModelId, projectFilePath, isDotNetCore, isWeb, pubXmls).WithId(_id);
    };
    public static CtxReadDelegate<List<PublishXmlModel>> ReadPublishXmlModelList = PublishXmlModel.Read.List();
    
    public static CtxWriteDelegate<PublishableProjectModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ProjectName);
      writer.Write(value.ProjectModelId);
      writer.Write(value.ProjectFilePath);
      writer.Write(value.IsDotNetCore);
      writer.Write(value.IsWeb);
      WritePublishXmlModelList(ctx, writer, value.PubXmls);
    };
    public static CtxWriteDelegate<List<PublishXmlModel>> WritePublishXmlModelList = PublishXmlModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PublishableProjectModel (");
      using (printer.IndentCookie()) {
        printer.Print("projectName = "); ProjectName.PrintEx(printer); printer.Println();
        printer.Print("projectModelId = "); ProjectModelId.PrintEx(printer); printer.Println();
        printer.Print("projectFilePath = "); ProjectFilePath.PrintEx(printer); printer.Println();
        printer.Print("isDotNetCore = "); IsDotNetCore.PrintEx(printer); printer.Println();
        printer.Print("isWeb = "); IsWeb.PrintEx(printer); printer.Println();
        printer.Print("pubXmls = "); PubXmls.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
