using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class RdActionExecutionContextHost : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, RdCancelableProgress> ProgressState { get { return _ProgressState; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, RdCancelableProgress> _ProgressState;
    
    //primary constructor
    private RdActionExecutionContextHost(
      [NotNull] RdMap<int, RdCancelableProgress> progressState
    )
    {
      if (progressState == null) throw new ArgumentNullException("progressState");
      
      _ProgressState = progressState;
      BindableChildren.Add(new KeyValuePair<string, object>("progressState", _ProgressState));
    }
    //secondary constructor
    private RdActionExecutionContextHost (
    ) : this (
      new RdMap<int, RdCancelableProgress>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, RdCancelableProgress.Read, RdCancelableProgress.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 3641477630517780360L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdCancelableProgress.Read, RdCancelableProgress.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public RdActionExecutionContextHost(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdActionExecutionContextHost (");
      using (printer.IndentCookie()) {
        printer.Print("progressState = "); _ProgressState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCancelableProgress : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string TaskName {get; private set;}
    public bool IsCancelable {get; private set;}
    [NotNull] public ISource<double> Fraction { get { return _Fraction; }}
    [NotNull] public ISource<string> Text { get { return _Text; }}
    [NotNull] public IAsyncSink<RdVoid> Cancel { get { return _Cancel; }}
    
    //private fields
    [NotNull] private readonly RdSignal<double> _Fraction;
    [NotNull] private readonly RdSignal<string> _Text;
    [NotNull] private readonly RdSignal<RdVoid> _Cancel;
    
    //primary constructor
    private RdCancelableProgress(
      [NotNull] string taskName,
      bool isCancelable,
      [NotNull] RdSignal<double> fraction,
      [NotNull] RdSignal<string> text,
      [NotNull] RdSignal<RdVoid> cancel
    )
    {
      if (taskName == null) throw new ArgumentNullException("taskName");
      if (fraction == null) throw new ArgumentNullException("fraction");
      if (text == null) throw new ArgumentNullException("text");
      if (cancel == null) throw new ArgumentNullException("cancel");
      
      TaskName = taskName;
      IsCancelable = isCancelable;
      _Fraction = fraction;
      _Text = text;
      _Cancel = cancel;
      _Fraction.Async = true;
      _Text.Async = true;
      _Cancel.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("fraction", _Fraction));
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("cancel", _Cancel));
    }
    //secondary constructor
    public RdCancelableProgress (
      [NotNull] string taskName,
      bool isCancelable
    ) : this (
      taskName,
      isCancelable,
      new RdSignal<double>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCancelableProgress> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var taskName = reader.ReadString();
      var isCancelable = reader.ReadBool();
      var fraction = RdSignal<double>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadDouble, JetBrains.Platform.RdFramework.Impl.Serializers.WriteDouble);
      var text = RdSignal<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var cancel = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdCancelableProgress(taskName, isCancelable, fraction, text, cancel).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCancelableProgress> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.TaskName);
      writer.Write(value.IsCancelable);
      RdSignal<double>.Write(ctx, writer, value._Fraction);
      RdSignal<string>.Write(ctx, writer, value._Text);
      RdSignal<RdVoid>.Write(ctx, writer, value._Cancel);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCancelableProgress (");
      using (printer.IndentCookie()) {
        printer.Print("taskName = "); TaskName.PrintEx(printer); printer.Println();
        printer.Print("isCancelable = "); IsCancelable.PrintEx(printer); printer.Println();
        printer.Print("fraction = "); _Fraction.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
