using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class RdEnsureWritableHandlerModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdCall<string, bool> IsWritable { get { return _IsWritable; }}
    [NotNull] public IRdCall<MakeWritableRequest, MakeWritableResponse> MakeWritable { get { return _MakeWritable; }}
    [NotNull] public ISink<string> IsWritableChanged { get { return _IsWritableChanged; }}
    
    //private fields
    [NotNull] private readonly RdCall<string, bool> _IsWritable;
    [NotNull] private readonly RdCall<MakeWritableRequest, MakeWritableResponse> _MakeWritable;
    [NotNull] private readonly RdSignal<string> _IsWritableChanged;
    
    //primary constructor
    private RdEnsureWritableHandlerModel(
      [NotNull] RdCall<string, bool> isWritable,
      [NotNull] RdCall<MakeWritableRequest, MakeWritableResponse> makeWritable,
      [NotNull] RdSignal<string> isWritableChanged
    )
    {
      if (isWritable == null) throw new ArgumentNullException("isWritable");
      if (makeWritable == null) throw new ArgumentNullException("makeWritable");
      if (isWritableChanged == null) throw new ArgumentNullException("isWritableChanged");
      
      _IsWritable = isWritable;
      _MakeWritable = makeWritable;
      _IsWritableChanged = isWritableChanged;
      BindableChildren.Add(new KeyValuePair<string, object>("isWritable", _IsWritable));
      BindableChildren.Add(new KeyValuePair<string, object>("makeWritable", _MakeWritable));
      BindableChildren.Add(new KeyValuePair<string, object>("isWritableChanged", _IsWritableChanged));
    }
    //secondary constructor
    private RdEnsureWritableHandlerModel (
    ) : this (
      new RdCall<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdCall<MakeWritableRequest, MakeWritableResponse>(MakeWritableRequest.Read, MakeWritableRequest.Write, MakeWritableResponse.Read, MakeWritableResponse.Write),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 2296606246085016222L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public RdEnsureWritableHandlerModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEnsureWritableHandlerModel (");
      using (printer.IndentCookie()) {
        printer.Print("isWritable = "); _IsWritable.PrintEx(printer); printer.Println();
        printer.Print("makeWritable = "); _MakeWritable.PrintEx(printer); printer.Println();
        printer.Print("isWritableChanged = "); _IsWritableChanged.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
