using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class RdProjectModelSinks : RdExtBase {
    //fields
    //public fields
    [NotNull] public ISource<string> MSBuildFileChanged { get { return _MSBuildFileChanged; }}
    [NotNull] public ISource<string> NetCoreProjectChanged { get { return _NetCoreProjectChanged; }}
    
    //private fields
    [NotNull] private readonly RdSignal<string> _MSBuildFileChanged;
    [NotNull] private readonly RdSignal<string> _NetCoreProjectChanged;
    
    //primary constructor
    private RdProjectModelSinks(
      [NotNull] RdSignal<string> mSBuildFileChanged,
      [NotNull] RdSignal<string> netCoreProjectChanged
    )
    {
      if (mSBuildFileChanged == null) throw new ArgumentNullException("mSBuildFileChanged");
      if (netCoreProjectChanged == null) throw new ArgumentNullException("netCoreProjectChanged");
      
      _MSBuildFileChanged = mSBuildFileChanged;
      _NetCoreProjectChanged = netCoreProjectChanged;
      BindableChildren.Add(new KeyValuePair<string, object>("mSBuildFileChanged", _MSBuildFileChanged));
      BindableChildren.Add(new KeyValuePair<string, object>("netCoreProjectChanged", _NetCoreProjectChanged));
    }
    //secondary constructor
    internal RdProjectModelSinks (
    ) : this (
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -5252116770975009401L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdProjectModelSinks (");
      using (printer.IndentCookie()) {
        printer.Print("mSBuildFileChanged = "); _MSBuildFileChanged.PrintEx(printer); printer.Println();
        printer.Print("netCoreProjectChanged = "); _NetCoreProjectChanged.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionRdProjectModelSinksEx
   {
    public static RdProjectModelSinks GetRdProjectModelSinks(this Solution solution)
    {
      return solution.GetOrCreateExtension("rdProjectModelSinks", () => new RdProjectModelSinks());
    }
  }
}
