using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Refactorings
{
  
  
  [JetBrains.Application.ShellComponent]
  public class RefactoringInteractionModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<RefactoringInteraction> CurrentRefactoring { get { return _CurrentRefactoring; }}
    [NotNull] public IViewableMap<int, PullToolSessionModel> PullToolSessions { get { return _PullToolSessions; }}
    [NotNull] public IRdSignal<RdVoid> TerminatePullToolSessions { get { return _TerminatePullToolSessions; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RefactoringInteraction> _CurrentRefactoring;
    [NotNull] private readonly RdMap<int, PullToolSessionModel> _PullToolSessions;
    [NotNull] private readonly RdSignal<RdVoid> _TerminatePullToolSessions;
    
    //primary constructor
    private RefactoringInteractionModel(
      [NotNull] RdProperty<RefactoringInteraction> currentRefactoring,
      [NotNull] RdMap<int, PullToolSessionModel> pullToolSessions,
      [NotNull] RdSignal<RdVoid> terminatePullToolSessions
    )
    {
      if (currentRefactoring == null) throw new ArgumentNullException("currentRefactoring");
      if (pullToolSessions == null) throw new ArgumentNullException("pullToolSessions");
      if (terminatePullToolSessions == null) throw new ArgumentNullException("terminatePullToolSessions");
      
      _CurrentRefactoring = currentRefactoring;
      _PullToolSessions = pullToolSessions;
      _TerminatePullToolSessions = terminatePullToolSessions;
      _CurrentRefactoring.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("currentRefactoring", _CurrentRefactoring));
      BindableChildren.Add(new KeyValuePair<string, object>("pullToolSessions", _PullToolSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("terminatePullToolSessions", _TerminatePullToolSessions));
    }
    //secondary constructor
    private RefactoringInteractionModel (
    ) : this (
      new RdProperty<RefactoringInteraction>(ReadRefactoringInteractionNullable, WriteRefactoringInteractionNullable),
      new RdMap<int, PullToolSessionModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, PullToolSessionModel.Read, PullToolSessionModel.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RefactoringInteraction> ReadRefactoringInteractionNullable = RefactoringInteraction.Read.NullableClass();
    
    public static CtxWriteDelegate<RefactoringInteraction> WriteRefactoringInteractionNullable = RefactoringInteraction.Write.NullableClass();
    
    protected override long SerializationHash => 1612741253368062624L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(MessageBoxOK.Read, MessageBoxOK.Write);
      serializers.RegisterEnum<CheckboxState>();
      serializers.Register(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      serializers.Register(RefactoringCompletionItem.Read, RefactoringCompletionItem.Write);
      serializers.Register(RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      serializers.Register(RefactoringListViewModel.Read, RefactoringListViewModel.Write);
      serializers.Register(RdPropertyToRadioViewModel.Read, RdPropertyToRadioViewModel.Write);
      serializers.Register(TextWithIconModel.Read, TextWithIconModel.Write);
      serializers.Register(RdSignalViewModel.Read, RdSignalViewModel.Write);
      serializers.Register(RdCheckBoxViewModel.Read, RdCheckBoxViewModel.Write);
      serializers.Register(RdEditableTextViewModel.Read, RdEditableTextViewModel.Write);
      serializers.Register(RdReadOnlyTextViewModel.Read, RdReadOnlyTextViewModel.Write);
      serializers.Register(RdTextViewModelWithCustomText.Read, RdTextViewModelWithCustomText.Write);
      serializers.Register(RdPreviewElement.Read, RdPreviewElement.Write);
      serializers.Register(RdParameterElement.Read, RdParameterElement.Write);
      serializers.Register(RdRefactoringsViewModelElement.Read, RdRefactoringsViewModelElement.Write);
      serializers.Register(RdCodePreviewPresentation.Read, RdCodePreviewPresentation.Write);
      serializers.Register(RdListViewModelElementWithChildren.Read, RdListViewModelElementWithChildren.Write);
      serializers.Register(RdDeclaredElementViewModelElement.Read, RdDeclaredElementViewModelElement.Write);
      serializers.Register(RdEnumValuesModel.Read, RdEnumValuesModel.Write);
      serializers.Register(RdSelectionCollection.Read, RdSelectionCollection.Write);
      serializers.Register(BeRefactoringsPage.Read, BeRefactoringsPage.Write);
      serializers.Register(BeUsagesPanel.Read, BeUsagesPanel.Write);
      serializers.Register(ConflictsPageModel.Read, ConflictsPageModel.Write);
      serializers.Register(ConflictsMovePageModel.Read, ConflictsMovePageModel.Write);
      serializers.Register(TextOccurrencesPageModel.Read, TextOccurrencesPageModel.Write);
      serializers.Register(RelatedElementsPageModel.Read, RelatedElementsPageModel.Write);
      serializers.Register(WizardForm.Read, WizardForm.Write);
      serializers.Register(RefactoringInteraction.Read, RefactoringInteraction.Write);
      serializers.Register(InlineMethodPageModel.Read, InlineMethodPageModel.Write);
      serializers.Register(InlineParameterInvocationsModel.Read, InlineParameterInvocationsModel.Write);
      serializers.Register(RdInvertBooleanPresentation.Read, RdInvertBooleanPresentation.Write);
      serializers.Register(InlineParameterRdModel.Read, InlineParameterRdModel.Write);
      serializers.Register(SafeDeleteInheritorsPageModel.Read, SafeDeleteInheritorsPageModel.Write);
      serializers.Register(SafeDeleteDeleteFilesModel.Read, SafeDeleteDeleteFilesModel.Write);
      serializers.Register(SafeDeleteReplaceTypeUsagesModel.Read, SafeDeleteReplaceTypeUsagesModel.Write);
      serializers.Register(SafeDeleteOverridableMemberModel.Read, SafeDeleteOverridableMemberModel.Write);
      serializers.Register(SafeDeleteReferenceUsagesModel.Read, SafeDeleteReferenceUsagesModel.Write);
      serializers.Register(RdInlineParameterPresentation.Read, RdInlineParameterPresentation.Write);
      serializers.Register(BulkRenameModel.Read, BulkRenameModel.Write);
      serializers.Register(IntroduceParameterModel.Read, IntroduceParameterModel.Write);
      serializers.Register(ExtractInterfaceMemberModel.Read, ExtractInterfaceMemberModel.Write);
      serializers.Register(ExtractInterfaceSuperclassModel.Read, ExtractInterfaceSuperclassModel.Write);
      serializers.Register(PullUpMembersModel.Read, PullUpMembersModel.Write);
      serializers.Register(PushDownMembersModel.Read, PushDownMembersModel.Write);
      serializers.Register(SelectTypePartModel.Read, SelectTypePartModel.Write);
      serializers.Register(UseBaseTypeModel.Read, UseBaseTypeModel.Write);
      serializers.Register(RdTransformParametersPresentation.Read, RdTransformParametersPresentation.Write);
      serializers.Register(RdAdjustNamespacesViewModel.Read, RdAdjustNamespacesViewModel.Write);
      serializers.Register(RdMoveStaticViewModel.Read, RdMoveStaticViewModel.Write);
      serializers.Register(RdMoveToFolderViewModel.Read, RdMoveToFolderViewModel.Write);
      serializers.Register(RdMoveTypeToOuterViewModel.Read, RdMoveTypeToOuterViewModel.Write);
      serializers.Register(RdMoveToNamespaceViewModel.Read, RdMoveToNamespaceViewModel.Write);
      serializers.Register(RdUseBaseTypeViewModel.Read, RdUseBaseTypeViewModel.Write);
      serializers.Register(RdRenameFileViewModel.Read, RdRenameFileViewModel.Write);
      serializers.Register(RdIntroduceParameterViewModel.Read, RdIntroduceParameterViewModel.Write);
      serializers.Register(RdConflictsViewModel.Read, RdConflictsViewModel.Write);
      serializers.Register(RdFixAccessRightsViewModel.Read, RdFixAccessRightsViewModel.Write);
      serializers.Register(RdSafeDeleteFolderViewModel.Read, RdSafeDeleteFolderViewModel.Write);
      serializers.Register(RdExtractParentViewModel.Read, RdExtractParentViewModel.Write);
      serializers.Register(RdMoveIntoFileViewModel.Read, RdMoveIntoFileViewModel.Write);
      serializers.Register(RdRenameNamespaceViewModel.Read, RdRenameNamespaceViewModel.Write);
      serializers.Register(RdMoveUpDownViewModel.Read, RdMoveUpDownViewModel.Write);
      serializers.Register(MoveToNamespaceModel.Read, MoveToNamespaceModel.Write);
      serializers.Register(MoveToFolderModel.Read, MoveToFolderModel.Write);
      serializers.Register(MoveFileRemoveEmptyFileModel.Read, MoveFileRemoveEmptyFileModel.Write);
      serializers.Register(MoveStaticMemberModel.Read, MoveStaticMemberModel.Write);
      serializers.Register(ApplyChangeSignatureModel.Read, ApplyChangeSignatureModel.Write);
      serializers.Register(TypeSuggestionsModel.Read, TypeSuggestionsModel.Write);
      serializers.Register(AdjustNamespacesModel.Read, AdjustNamespacesModel.Write);
      serializers.Register(MoveIntoMatchingFilesModel.Read, MoveIntoMatchingFilesModel.Write);
      serializers.Register(EmptyPage.Read, EmptyPage.Write);
      serializers.Register(FeelLucky.Read, FeelLucky.Write);
      serializers.Register(PullToolSessionModel.Read, PullToolSessionModel.Write);
      serializers.Register(ConflictList.Read, ConflictList.Write);
      serializers.Register(LinkInfo.Read, LinkInfo.Write);
      serializers.Register(Conflict.Read, Conflict.Write);
      serializers.Register(MoveConflictModel.Read, MoveConflictModel.Write);
      serializers.Register(RelatedElementsPageModelNode.Read, RelatedElementsPageModelNode.Write);
      serializers.Register(InlineParameterParameterModel.Read, InlineParameterParameterModel.Write);
      serializers.Register(InlineParameterNewParameterList.Read, InlineParameterNewParameterList.Write);
      serializers.RegisterEnum<SafeDeleteReplaceTypeUsagesEnum>();
      serializers.RegisterEnum<SafeDeleteOverridableMemberEnum>();
      serializers.Register(IntroduceParameterElementModel.Read, IntroduceParameterElementModel.Write);
      serializers.Register(ExtractInterfaceSingleMemberModel.Read, ExtractInterfaceSingleMemberModel.Write);
      serializers.Register(PullUpTreeElementModel.Read, PullUpTreeElementModel.Write);
      serializers.Register(PushDownSingleMemberModel.Read, PushDownSingleMemberModel.Write);
      serializers.Register(MoveToFolderTreeElement.Read, MoveToFolderTreeElement.Write);
      serializers.RegisterEnum<MoveStaticMemberVisibility>();
      serializers.Register(MoveStaticMemberMemberModel.Read, MoveStaticMemberMemberModel.Write);
      serializers.Register(ChangeSignatureItem.Read, ChangeSignatureItem.Write);
      serializers.Register(ChangeSignatureArrows.Read, ChangeSignatureArrows.Write);
      serializers.Register(TypeSuggestionsElementModel.Read, TypeSuggestionsElementModel.Write);
      serializers.Register(AdjustNamespacesModelElement.Read, AdjustNamespacesModelElement.Write);
      serializers.Register(PullToolSessionNode.Read, PullToolSessionNode.Write);
      serializers.Register(ConflictTextFragment.Read, ConflictTextFragment.Write);
      serializers.RegisterEnum<ChangeSignatureState>();
      serializers.Register(PullToolSessionNodeChildren.Read, PullToolSessionNodeChildren.Write);
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public RefactoringInteractionModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("currentRefactoring = "); _CurrentRefactoring.PrintEx(printer); printer.Println();
        printer.Print("pullToolSessions = "); _PullToolSessions.PrintEx(printer); printer.Println();
        printer.Print("terminatePullToolSessions = "); _TerminatePullToolSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class AbstractPage : RdBindableBase, JetBrains.Application.UI.UIAutomation.IAutomation {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<bool> ContinueEnabled { get { return _ContinueEnabled; }}
    [NotNull] public IRdSignal<RefactoringsValidationResult> ValidationResult { get { return _ValidationResult; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _ContinueEnabled;
    [NotNull] protected readonly RdSignal<RefactoringsValidationResult> _ValidationResult;
    
    //primary constructor
    protected AbstractPage(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (description == null) throw new ArgumentNullException("description");
      if (continueEnabled == null) throw new ArgumentNullException("continueEnabled");
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      
      Title = title;
      Description = description;
      _ContinueEnabled = continueEnabled;
      _ValidationResult = validationResult;
      _ContinueEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("continueEnabled", _ContinueEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AbstractPage> Read = Polymorphic<AbstractPage>.ReadAbstract(AbstractPage_Unknown.Read);
    
    public static CtxWriteDelegate<AbstractPage> Write = Polymorphic<AbstractPage>.Write;
    //custom body
    public event System.ComponentModel.PropertyChangedEventHandler PropertyChanged;
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class AbstractPage_Unknown : AbstractPage
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private AbstractPage_Unknown(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public AbstractPage_Unknown (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<AbstractPage_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      return new AbstractPage_Unknown(title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<AbstractPage_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AbstractPage_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AdjustNamespacesModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<AdjustNamespacesModelElement> Elements {get; private set;}
    
    //private fields
    //primary constructor
    private AdjustNamespacesModel(
      [NotNull] List<AdjustNamespacesModelElement> elements,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (elements == null) throw new ArgumentNullException("elements");
      
      Elements = elements;
      BindableChildren.Add(new KeyValuePair<string, object>("elements", Elements));
    }
    //secondary constructor
    public AdjustNamespacesModel (
      [NotNull] List<AdjustNamespacesModelElement> elements,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      elements,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<AdjustNamespacesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var elements = ReadAdjustNamespacesModelElementList(ctx, reader);
      return new AdjustNamespacesModel(elements, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<AdjustNamespacesModelElement>> ReadAdjustNamespacesModelElementList = AdjustNamespacesModelElement.Read.List();
    
    public static new CtxWriteDelegate<AdjustNamespacesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteAdjustNamespacesModelElementList(ctx, writer, value.Elements);
    };
    public static CtxWriteDelegate<List<AdjustNamespacesModelElement>> WriteAdjustNamespacesModelElementList = AdjustNamespacesModelElement.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AdjustNamespacesModel (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AdjustNamespacesModelElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Include { get { return _Include; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Include;
    [NotNull] private readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    private AdjustNamespacesModelElement(
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> include,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      if (include == null) throw new ArgumentNullException("include");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Text = text;
      Icon = icon;
      _Include = include;
      _Navigate = navigate;
      _Include.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("include", _Include));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public AdjustNamespacesModelElement (
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      text,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<AdjustNamespacesModelElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var include = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new AdjustNamespacesModelElement(text, icon, include, navigate).WithId(_id);
    };
    
    public static CtxWriteDelegate<AdjustNamespacesModelElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Include);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AdjustNamespacesModelElement (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("include = "); _Include.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ApplyChangeSignatureModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<ChangeSignatureItem> OldItems {get; private set;}
    [NotNull] public List<ChangeSignatureItem> NewItems {get; private set;}
    [NotNull] public List<ChangeSignatureArrows> Arrows {get; private set;}
    
    //private fields
    //primary constructor
    private ApplyChangeSignatureModel(
      [NotNull] List<ChangeSignatureItem> oldItems,
      [NotNull] List<ChangeSignatureItem> newItems,
      [NotNull] List<ChangeSignatureArrows> arrows,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (oldItems == null) throw new ArgumentNullException("oldItems");
      if (newItems == null) throw new ArgumentNullException("newItems");
      if (arrows == null) throw new ArgumentNullException("arrows");
      
      OldItems = oldItems;
      NewItems = newItems;
      Arrows = arrows;
      BindableChildren.Add(new KeyValuePair<string, object>("oldItems", OldItems));
      BindableChildren.Add(new KeyValuePair<string, object>("newItems", NewItems));
      BindableChildren.Add(new KeyValuePair<string, object>("arrows", Arrows));
    }
    //secondary constructor
    public ApplyChangeSignatureModel (
      [NotNull] List<ChangeSignatureItem> oldItems,
      [NotNull] List<ChangeSignatureItem> newItems,
      [NotNull] List<ChangeSignatureArrows> arrows,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      oldItems,
      newItems,
      arrows,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ApplyChangeSignatureModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var oldItems = ReadChangeSignatureItemList(ctx, reader);
      var newItems = ReadChangeSignatureItemList(ctx, reader);
      var arrows = ReadChangeSignatureArrowsList(ctx, reader);
      return new ApplyChangeSignatureModel(oldItems, newItems, arrows, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<ChangeSignatureItem>> ReadChangeSignatureItemList = ChangeSignatureItem.Read.List();
    public static CtxReadDelegate<List<ChangeSignatureArrows>> ReadChangeSignatureArrowsList = ChangeSignatureArrows.Read.List();
    
    public static new CtxWriteDelegate<ApplyChangeSignatureModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteChangeSignatureItemList(ctx, writer, value.OldItems);
      WriteChangeSignatureItemList(ctx, writer, value.NewItems);
      WriteChangeSignatureArrowsList(ctx, writer, value.Arrows);
    };
    public static CtxWriteDelegate<List<ChangeSignatureItem>> WriteChangeSignatureItemList = ChangeSignatureItem.Write.List();
    public static CtxWriteDelegate<List<ChangeSignatureArrows>> WriteChangeSignatureArrowsList = ChangeSignatureArrows.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ApplyChangeSignatureModel (");
      using (printer.IndentCookie()) {
        printer.Print("oldItems = "); OldItems.PrintEx(printer); printer.Println();
        printer.Print("newItems = "); NewItems.PrintEx(printer); printer.Println();
        printer.Print("arrows = "); Arrows.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeRefactoringsPage : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.UIAutomation.BeControl Content {get; private set;}
    
    //private fields
    //primary constructor
    private BeRefactoringsPage(
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl content,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeRefactoringsPage (
      [NotNull] JetBrains.Rider.Model.UIAutomation.BeControl content,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      content,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeRefactoringsPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var content = JetBrains.Rider.Model.UIAutomation.BeControl.Read(ctx, reader);
      return new BeRefactoringsPage(content, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<BeRefactoringsPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      JetBrains.Rider.Model.UIAutomation.BeControl.Write(ctx, writer, value.Content);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeRefactoringsPage (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeUsagesPanel : JetBrains.Rider.Model.UIAutomation.BeControl
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.RdUsageList Content {get; private set;}
    [NotNull] public IRdSignal<int> SetChecked { get { return _SetChecked; }}
    [NotNull] public IRdSignal<int> SetUnchecked { get { return _SetUnchecked; }}
    
    //private fields
    [NotNull] private readonly RdSignal<int> _SetChecked;
    [NotNull] private readonly RdSignal<int> _SetUnchecked;
    
    //primary constructor
    private BeUsagesPanel(
      [NotNull] JetBrains.Rider.Model.RdUsageList content,
      [NotNull] RdSignal<int> setChecked,
      [NotNull] RdSignal<int> setUnchecked,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (setChecked == null) throw new ArgumentNullException("setChecked");
      if (setUnchecked == null) throw new ArgumentNullException("setUnchecked");
      
      Content = content;
      _SetChecked = setChecked;
      _SetUnchecked = setUnchecked;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("setChecked", _SetChecked));
      BindableChildren.Add(new KeyValuePair<string, object>("setUnchecked", _SetUnchecked));
    }
    //secondary constructor
    public BeUsagesPanel (
      [NotNull] JetBrains.Rider.Model.RdUsageList content
    ) : this (
      content,
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeUsagesPanel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = JetBrains.Rider.Model.RdUsageList.Read(ctx, reader);
      var setChecked = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var setUnchecked = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeUsagesPanel(content, setChecked, setUnchecked, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> ReadControlVisibility = new CtxReadDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    
    public static new CtxWriteDelegate<BeUsagesPanel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ControlVisibility>.Write(ctx, writer, value._Visible);
      JetBrains.Rider.Model.RdUsageList.Write(ctx, writer, value.Content);
      RdSignal<int>.Write(ctx, writer, value._SetChecked);
      RdSignal<int>.Write(ctx, writer, value._SetUnchecked);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<JetBrains.Rider.Model.UIAutomation.ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.UIAutomation.ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeUsagesPanel (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("setChecked = "); _SetChecked.PrintEx(printer); printer.Println();
        printer.Print("setUnchecked = "); _SetUnchecked.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BulkRenameModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.RdUsageList Occurrences {get; private set;}
    [NotNull] public List<string> NewNames {get; private set;}
    [NotNull] public IRdSignal<int> Include { get { return _Include; }}
    [NotNull] public IRdSignal<int> Exclude { get { return _Exclude; }}
    
    //private fields
    [NotNull] private readonly RdSignal<int> _Include;
    [NotNull] private readonly RdSignal<int> _Exclude;
    
    //primary constructor
    private BulkRenameModel(
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] List<string> newNames,
      [NotNull] RdSignal<int> include,
      [NotNull] RdSignal<int> exclude,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (occurrences == null) throw new ArgumentNullException("occurrences");
      if (newNames == null) throw new ArgumentNullException("newNames");
      if (include == null) throw new ArgumentNullException("include");
      if (exclude == null) throw new ArgumentNullException("exclude");
      
      Occurrences = occurrences;
      NewNames = newNames;
      _Include = include;
      _Exclude = exclude;
      BindableChildren.Add(new KeyValuePair<string, object>("occurrences", Occurrences));
      BindableChildren.Add(new KeyValuePair<string, object>("include", _Include));
      BindableChildren.Add(new KeyValuePair<string, object>("exclude", _Exclude));
    }
    //secondary constructor
    public BulkRenameModel (
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] List<string> newNames,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      occurrences,
      newNames,
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BulkRenameModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var occurrences = JetBrains.Rider.Model.RdUsageList.Read(ctx, reader);
      var newNames = ReadStringList(ctx, reader);
      var include = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var exclude = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BulkRenameModel(occurrences, newNames, include, exclude, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<BulkRenameModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      JetBrains.Rider.Model.RdUsageList.Write(ctx, writer, value.Occurrences);
      WriteStringList(ctx, writer, value.NewNames);
      RdSignal<int>.Write(ctx, writer, value._Include);
      RdSignal<int>.Write(ctx, writer, value._Exclude);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BulkRenameModel (");
      using (printer.IndentCookie()) {
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
        printer.Print("newNames = "); NewNames.PrintEx(printer); printer.Println();
        printer.Print("include = "); _Include.PrintEx(printer); printer.Println();
        printer.Print("exclude = "); _Exclude.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureArrows : RdBindableBase {
    //fields
    //public fields
    public int From {get; private set;}
    public int To {get; private set;}
    
    //private fields
    //primary constructor
    public ChangeSignatureArrows(
      int from,
      int to
    )
    {
      From = from;
      To = to;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ChangeSignatureArrows> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var from = reader.ReadInt();
      var to = reader.ReadInt();
      return new ChangeSignatureArrows(from, to).WithId(_id);
    };
    
    public static CtxWriteDelegate<ChangeSignatureArrows> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.From);
      writer.Write(value.To);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureArrows (");
      using (printer.IndentCookie()) {
        printer.Print("from = "); From.PrintEx(printer); printer.Println();
        printer.Print("to = "); To.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ChangeSignatureItem : RdBindableBase {
    //fields
    //public fields
    public ChangeSignatureState State {get; private set;}
    [NotNull] public string Text {get; private set;}
    public bool IsBold {get; private set;}
    public bool IsChanged {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    
    //private fields
    //primary constructor
    public ChangeSignatureItem(
      ChangeSignatureState state,
      [NotNull] string text,
      bool isBold,
      bool isChanged,
      [NotNull] List<int> children
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (children == null) throw new ArgumentNullException("children");
      
      State = state;
      Text = text;
      IsBold = isBold;
      IsChanged = isChanged;
      Children = children;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ChangeSignatureItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var state = (ChangeSignatureState)reader.ReadInt();
      var text = reader.ReadString();
      var isBold = reader.ReadBool();
      var isChanged = reader.ReadBool();
      var children = ReadIntList(ctx, reader);
      return new ChangeSignatureItem(state, text, isBold, isChanged, children).WithId(_id);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<ChangeSignatureItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.State);
      writer.Write(value.Text);
      writer.Write(value.IsBold);
      writer.Write(value.IsChanged);
      WriteIntList(ctx, writer, value.Children);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ChangeSignatureItem (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isBold = "); IsBold.PrintEx(printer); printer.Println();
        printer.Print("isChanged = "); IsChanged.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ChangeSignatureState {
    Normal,
    Added,
    Removed
  }
  
  
  public enum CheckboxState {
    Checked,
    Unchecked,
    PartiallyChecked
  }
  
  
  public class Conflict : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<ConflictTextFragment> TextFragments {get; private set;}
    public bool IsError {get; private set;}
    
    //private fields
    //primary constructor
    public Conflict(
      [NotNull] List<ConflictTextFragment> textFragments,
      bool isError
    )
    {
      if (textFragments == null) throw new ArgumentNullException("textFragments");
      
      TextFragments = textFragments;
      IsError = isError;
      BindableChildren.Add(new KeyValuePair<string, object>("textFragments", TextFragments));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Conflict> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var textFragments = ReadConflictTextFragmentList(ctx, reader);
      var isError = reader.ReadBool();
      return new Conflict(textFragments, isError).WithId(_id);
    };
    public static CtxReadDelegate<List<ConflictTextFragment>> ReadConflictTextFragmentList = ConflictTextFragment.Read.List();
    
    public static CtxWriteDelegate<Conflict> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteConflictTextFragmentList(ctx, writer, value.TextFragments);
      writer.Write(value.IsError);
    };
    public static CtxWriteDelegate<List<ConflictTextFragment>> WriteConflictTextFragmentList = ConflictTextFragment.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Conflict (");
      using (printer.IndentCookie()) {
        printer.Print("textFragments = "); TextFragments.PrintEx(printer); printer.Println();
        printer.Print("isError = "); IsError.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictList : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<Conflict> List {get; private set;}
    
    //private fields
    //primary constructor
    public ConflictList(
      [NotNull] List<Conflict> list
    )
    {
      if (list == null) throw new ArgumentNullException("list");
      
      List = list;
      BindableChildren.Add(new KeyValuePair<string, object>("list", List));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ConflictList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var list = ReadConflictList(ctx, reader);
      return new ConflictList(list).WithId(_id);
    };
    public static CtxReadDelegate<List<Conflict>> ReadConflictList = Conflict.Read.List();
    
    public static CtxWriteDelegate<ConflictList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteConflictList(ctx, writer, value.List);
    };
    public static CtxWriteDelegate<List<Conflict>> WriteConflictList = Conflict.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictList (");
      using (printer.IndentCookie()) {
        printer.Print("list = "); List.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictTextFragment : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public bool IsClickable {get; private set;}
    
    //private fields
    //primary constructor
    public ConflictTextFragment(
      [NotNull] string text,
      bool isClickable
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      IsClickable = isClickable;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ConflictTextFragment> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var isClickable = reader.ReadBool();
      return new ConflictTextFragment(text, isClickable).WithId(_id);
    };
    
    public static CtxWriteDelegate<ConflictTextFragment> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      writer.Write(value.IsClickable);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictTextFragment (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isClickable = "); IsClickable.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictsMovePageModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<MoveConflictModel> Conflicts {get; private set;}
    [NotNull] public IRdSignal<int> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdSignal<int> _Navigate;
    
    //primary constructor
    private ConflictsMovePageModel(
      [NotNull] List<MoveConflictModel> conflicts,
      [NotNull] RdSignal<int> navigate,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (conflicts == null) throw new ArgumentNullException("conflicts");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Conflicts = conflicts;
      _Navigate = navigate;
      BindableChildren.Add(new KeyValuePair<string, object>("conflicts", Conflicts));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public ConflictsMovePageModel (
      [NotNull] List<MoveConflictModel> conflicts,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      conflicts,
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ConflictsMovePageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var conflicts = ReadMoveConflictModelList(ctx, reader);
      var navigate = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new ConflictsMovePageModel(conflicts, navigate, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<MoveConflictModel>> ReadMoveConflictModelList = MoveConflictModel.Read.List();
    
    public static new CtxWriteDelegate<ConflictsMovePageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteMoveConflictModelList(ctx, writer, value.Conflicts);
      RdSignal<int>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<List<MoveConflictModel>> WriteMoveConflictModelList = MoveConflictModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictsMovePageModel (");
      using (printer.IndentCookie()) {
        printer.Print("conflicts = "); Conflicts.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ConflictsPageModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<ConflictList> Conflicts { get { return _Conflicts; }}
    [NotNull] public IRdSignal<LinkInfo> NavigateLink { get { return _NavigateLink; }}
    [NotNull] public IRdSignal<RdVoid> Refresh { get { return _Refresh; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ConflictList> _Conflicts;
    [NotNull] private readonly RdSignal<LinkInfo> _NavigateLink;
    [NotNull] private readonly RdSignal<RdVoid> _Refresh;
    
    //primary constructor
    private ConflictsPageModel(
      [NotNull] RdProperty<ConflictList> conflicts,
      [NotNull] RdSignal<LinkInfo> navigateLink,
      [NotNull] RdSignal<RdVoid> refresh,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (conflicts == null) throw new ArgumentNullException("conflicts");
      if (navigateLink == null) throw new ArgumentNullException("navigateLink");
      if (refresh == null) throw new ArgumentNullException("refresh");
      
      _Conflicts = conflicts;
      _NavigateLink = navigateLink;
      _Refresh = refresh;
      BindableChildren.Add(new KeyValuePair<string, object>("conflicts", _Conflicts));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateLink", _NavigateLink));
      BindableChildren.Add(new KeyValuePair<string, object>("refresh", _Refresh));
    }
    //secondary constructor
    public ConflictsPageModel (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<ConflictList>(ConflictList.Read, ConflictList.Write),
      new RdSignal<LinkInfo>(LinkInfo.Read, LinkInfo.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ConflictsPageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var conflicts = RdProperty<ConflictList>.Read(ctx, reader, ConflictList.Read, ConflictList.Write);
      var navigateLink = RdSignal<LinkInfo>.Read(ctx, reader, LinkInfo.Read, LinkInfo.Write);
      var refresh = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new ConflictsPageModel(conflicts, navigateLink, refresh, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ConflictsPageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<ConflictList>.Write(ctx, writer, value._Conflicts);
      RdSignal<LinkInfo>.Write(ctx, writer, value._NavigateLink);
      RdSignal<RdVoid>.Write(ctx, writer, value._Refresh);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ConflictsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("conflicts = "); _Conflicts.PrintEx(printer); printer.Println();
        printer.Print("navigateLink = "); _NavigateLink.PrintEx(printer); printer.Println();
        printer.Print("refresh = "); _Refresh.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EmptyPage : AbstractPage
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private EmptyPage(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public EmptyPage (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<EmptyPage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      return new EmptyPage(title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<EmptyPage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EmptyPage (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceMemberModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<ExtractInterfaceSingleMemberModel> Members {get; private set;}
    [NotNull] public IRdSignal<RdVoid> PublicButtonClicked { get { return _PublicButtonClicked; }}
    [NotNull] public IRdSignal<RdVoid> DependentButtonClicked { get { return _DependentButtonClicked; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _PublicButtonClicked;
    [NotNull] private readonly RdSignal<RdVoid> _DependentButtonClicked;
    
    //primary constructor
    private ExtractInterfaceMemberModel(
      [NotNull] List<ExtractInterfaceSingleMemberModel> members,
      [NotNull] RdSignal<RdVoid> publicButtonClicked,
      [NotNull] RdSignal<RdVoid> dependentButtonClicked
    )
    {
      if (members == null) throw new ArgumentNullException("members");
      if (publicButtonClicked == null) throw new ArgumentNullException("publicButtonClicked");
      if (dependentButtonClicked == null) throw new ArgumentNullException("dependentButtonClicked");
      
      Members = members;
      _PublicButtonClicked = publicButtonClicked;
      _DependentButtonClicked = dependentButtonClicked;
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
      BindableChildren.Add(new KeyValuePair<string, object>("publicButtonClicked", _PublicButtonClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("dependentButtonClicked", _DependentButtonClicked));
    }
    //secondary constructor
    public ExtractInterfaceMemberModel (
      [NotNull] List<ExtractInterfaceSingleMemberModel> members
    ) : this (
      members,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<ExtractInterfaceMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var members = ReadExtractInterfaceSingleMemberModelList(ctx, reader);
      var publicButtonClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var dependentButtonClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new ExtractInterfaceMemberModel(members, publicButtonClicked, dependentButtonClicked).WithId(_id);
    };
    public static CtxReadDelegate<List<ExtractInterfaceSingleMemberModel>> ReadExtractInterfaceSingleMemberModelList = ExtractInterfaceSingleMemberModel.Read.List();
    
    public static CtxWriteDelegate<ExtractInterfaceMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteExtractInterfaceSingleMemberModelList(ctx, writer, value.Members);
      RdSignal<RdVoid>.Write(ctx, writer, value._PublicButtonClicked);
      RdSignal<RdVoid>.Write(ctx, writer, value._DependentButtonClicked);
    };
    public static CtxWriteDelegate<List<ExtractInterfaceSingleMemberModel>> WriteExtractInterfaceSingleMemberModelList = ExtractInterfaceSingleMemberModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("publicButtonClicked = "); _PublicButtonClicked.PrintEx(printer); printer.Println();
        printer.Print("dependentButtonClicked = "); _DependentButtonClicked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceSingleMemberModel : RdListViewModelElement
   {
    //fields
    //public fields
    public bool CanHaveAbstract {get; private set;}
    [NotNull] public IRdProperty<bool> CanMakeAbstract { get { return _CanMakeAbstract; }}
    [NotNull] public IRdProperty<bool> DoMakeAbstract { get { return _DoMakeAbstract; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _CanMakeAbstract;
    [NotNull] private readonly RdProperty<bool> _DoMakeAbstract;
    
    //primary constructor
    private ExtractInterfaceSingleMemberModel(
      bool canHaveAbstract,
      [NotNull] RdProperty<bool> canMakeAbstract,
      [NotNull] RdProperty<bool> doMakeAbstract,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
      if (canMakeAbstract == null) throw new ArgumentNullException("canMakeAbstract");
      if (doMakeAbstract == null) throw new ArgumentNullException("doMakeAbstract");
      
      CanHaveAbstract = canHaveAbstract;
      _CanMakeAbstract = canMakeAbstract;
      _DoMakeAbstract = doMakeAbstract;
      _CanMakeAbstract.OptimizeNested = true;
      _DoMakeAbstract.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("canMakeAbstract", _CanMakeAbstract));
      BindableChildren.Add(new KeyValuePair<string, object>("doMakeAbstract", _DoMakeAbstract));
    }
    //secondary constructor
    public ExtractInterfaceSingleMemberModel (
      bool canHaveAbstract,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      canHaveAbstract,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ExtractInterfaceSingleMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var canHaveAbstract = reader.ReadBool();
      var canMakeAbstract = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var doMakeAbstract = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new ExtractInterfaceSingleMemberModel(canHaveAbstract, canMakeAbstract, doMakeAbstract, text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<ExtractInterfaceSingleMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
      writer.Write(value.CanHaveAbstract);
      RdProperty<bool>.Write(ctx, writer, value._CanMakeAbstract);
      RdProperty<bool>.Write(ctx, writer, value._DoMakeAbstract);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceSingleMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("canHaveAbstract = "); CanHaveAbstract.PrintEx(printer); printer.Println();
        printer.Print("canMakeAbstract = "); _CanMakeAbstract.PrintEx(printer); printer.Println();
        printer.Print("doMakeAbstract = "); _DoMakeAbstract.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ExtractInterfaceSuperclassModel : AbstractPage
   {
    //fields
    //public fields
    public bool IsSuperclass {get; private set;}
    public bool BesideEnabled {get; private set;}
    [NotNull] public IRdProperty<string> InterfaceName { get { return _InterfaceName; }}
    [NotNull] public IRdProperty<bool> PlaceBeside { get { return _PlaceBeside; }}
    [NotNull] public ExtractInterfaceMemberModel Members {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _InterfaceName;
    [NotNull] private readonly RdProperty<bool> _PlaceBeside;
    
    //primary constructor
    private ExtractInterfaceSuperclassModel(
      bool isSuperclass,
      bool besideEnabled,
      [NotNull] RdProperty<string> interfaceName,
      [NotNull] RdProperty<bool> placeBeside,
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (interfaceName == null) throw new ArgumentNullException("interfaceName");
      if (placeBeside == null) throw new ArgumentNullException("placeBeside");
      if (members == null) throw new ArgumentNullException("members");
      
      IsSuperclass = isSuperclass;
      BesideEnabled = besideEnabled;
      _InterfaceName = interfaceName;
      _PlaceBeside = placeBeside;
      Members = members;
      _InterfaceName.OptimizeNested = true;
      _PlaceBeside.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("interfaceName", _InterfaceName));
      BindableChildren.Add(new KeyValuePair<string, object>("placeBeside", _PlaceBeside));
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
    }
    //secondary constructor
    public ExtractInterfaceSuperclassModel (
      bool isSuperclass,
      bool besideEnabled,
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      isSuperclass,
      besideEnabled,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      members,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<ExtractInterfaceSuperclassModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var isSuperclass = reader.ReadBool();
      var besideEnabled = reader.ReadBool();
      var interfaceName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var placeBeside = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var members = ExtractInterfaceMemberModel.Read(ctx, reader);
      return new ExtractInterfaceSuperclassModel(isSuperclass, besideEnabled, interfaceName, placeBeside, members, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<ExtractInterfaceSuperclassModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.IsSuperclass);
      writer.Write(value.BesideEnabled);
      RdProperty<string>.Write(ctx, writer, value._InterfaceName);
      RdProperty<bool>.Write(ctx, writer, value._PlaceBeside);
      ExtractInterfaceMemberModel.Write(ctx, writer, value.Members);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ExtractInterfaceSuperclassModel (");
      using (printer.IndentCookie()) {
        printer.Print("isSuperclass = "); IsSuperclass.PrintEx(printer); printer.Println();
        printer.Print("besideEnabled = "); BesideEnabled.PrintEx(printer); printer.Println();
        printer.Print("interfaceName = "); _InterfaceName.PrintEx(printer); printer.Println();
        printer.Print("placeBeside = "); _PlaceBeside.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FeelLucky : AbstractPage
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private FeelLucky(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public FeelLucky (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<FeelLucky> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      return new FeelLucky(title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<FeelLucky> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("FeelLucky (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineMethodPageModel : AbstractPage
   {
    //fields
    //public fields
    public bool InlineAllEnabled {get; private set;}
    [NotNull] public IRdProperty<bool> InlineAllUsages { get { return _InlineAllUsages; }}
    [NotNull] public IRdProperty<bool> RemoveEnabled { get { return _RemoveEnabled; }}
    [NotNull] public IRdProperty<bool> RemoveMethod { get { return _RemoveMethod; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _InlineAllUsages;
    [NotNull] private readonly RdProperty<bool> _RemoveEnabled;
    [NotNull] private readonly RdProperty<bool> _RemoveMethod;
    
    //primary constructor
    private InlineMethodPageModel(
      bool inlineAllEnabled,
      [NotNull] RdProperty<bool> inlineAllUsages,
      [NotNull] RdProperty<bool> removeEnabled,
      [NotNull] RdProperty<bool> removeMethod,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (inlineAllUsages == null) throw new ArgumentNullException("inlineAllUsages");
      if (removeEnabled == null) throw new ArgumentNullException("removeEnabled");
      if (removeMethod == null) throw new ArgumentNullException("removeMethod");
      
      InlineAllEnabled = inlineAllEnabled;
      _InlineAllUsages = inlineAllUsages;
      _RemoveEnabled = removeEnabled;
      _RemoveMethod = removeMethod;
      _InlineAllUsages.OptimizeNested = true;
      _RemoveEnabled.OptimizeNested = true;
      _RemoveMethod.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("inlineAllUsages", _InlineAllUsages));
      BindableChildren.Add(new KeyValuePair<string, object>("removeEnabled", _RemoveEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("removeMethod", _RemoveMethod));
    }
    //secondary constructor
    public InlineMethodPageModel (
      bool inlineAllEnabled,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      inlineAllEnabled,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<InlineMethodPageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var inlineAllEnabled = reader.ReadBool();
      var inlineAllUsages = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var removeEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var removeMethod = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new InlineMethodPageModel(inlineAllEnabled, inlineAllUsages, removeEnabled, removeMethod, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<InlineMethodPageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.InlineAllEnabled);
      RdProperty<bool>.Write(ctx, writer, value._InlineAllUsages);
      RdProperty<bool>.Write(ctx, writer, value._RemoveEnabled);
      RdProperty<bool>.Write(ctx, writer, value._RemoveMethod);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineMethodPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("inlineAllEnabled = "); InlineAllEnabled.PrintEx(printer); printer.Println();
        printer.Print("inlineAllUsages = "); _InlineAllUsages.PrintEx(printer); printer.Println();
        printer.Print("removeEnabled = "); _RemoveEnabled.PrintEx(printer); printer.Println();
        printer.Print("removeMethod = "); _RemoveMethod.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterInvocationsModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public List<string> PossibleSources {get; private set;}
    [NotNull] public IRdProperty<int> SelectedItem { get { return _SelectedItem; }}
    [NotNull] public IRdSignal<int> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedItem;
    [NotNull] private readonly RdSignal<int> _Navigate;
    
    //primary constructor
    private InlineParameterInvocationsModel(
      [NotNull] string labelText,
      [NotNull] List<string> possibleSources,
      [NotNull] RdProperty<int> selectedItem,
      [NotNull] RdSignal<int> navigate,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (labelText == null) throw new ArgumentNullException("labelText");
      if (possibleSources == null) throw new ArgumentNullException("possibleSources");
      if (selectedItem == null) throw new ArgumentNullException("selectedItem");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      LabelText = labelText;
      PossibleSources = possibleSources;
      _SelectedItem = selectedItem;
      _Navigate = navigate;
      _SelectedItem.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedItem", _SelectedItem));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public InlineParameterInvocationsModel (
      [NotNull] string labelText,
      [NotNull] List<string> possibleSources,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      labelText,
      possibleSources,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<InlineParameterInvocationsModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var labelText = reader.ReadString();
      var possibleSources = ReadStringList(ctx, reader);
      var selectedItem = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var navigate = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new InlineParameterInvocationsModel(labelText, possibleSources, selectedItem, navigate, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<InlineParameterInvocationsModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.LabelText);
      WriteStringList(ctx, writer, value.PossibleSources);
      RdProperty<int>.Write(ctx, writer, value._SelectedItem);
      RdSignal<int>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterInvocationsModel (");
      using (printer.IndentCookie()) {
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("possibleSources = "); PossibleSources.PrintEx(printer); printer.Println();
        printer.Print("selectedItem = "); _SelectedItem.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterNewParameterList : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<InlineParameterParameterModel> Items {get; private set;}
    
    //private fields
    //primary constructor
    public InlineParameterNewParameterList(
      [NotNull] List<InlineParameterParameterModel> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<InlineParameterNewParameterList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadInlineParameterParameterModelList(ctx, reader);
      return new InlineParameterNewParameterList(items).WithId(_id);
    };
    public static CtxReadDelegate<List<InlineParameterParameterModel>> ReadInlineParameterParameterModelList = InlineParameterParameterModel.Read.List();
    
    public static CtxWriteDelegate<InlineParameterNewParameterList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteInlineParameterParameterModelList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<InlineParameterParameterModel>> WriteInlineParameterParameterModelList = InlineParameterParameterModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterNewParameterList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterParameterModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Included;
    [NotNull] private readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    private InlineParameterParameterModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (included == null) throw new ArgumentNullException("included");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Text = text;
      Icon = icon;
      _Included = included;
      _Navigate = navigate;
      _Included.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("included", _Included));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public InlineParameterParameterModel (
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      text,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<InlineParameterParameterModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new InlineParameterParameterModel(text, icon, included, navigate).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<InlineParameterParameterModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class InlineParameterRdModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string UsedUsage {get; private set;}
    [NotNull] public List<InlineParameterParameterModel> ParameterList {get; private set;}
    [NotNull] public IRdProperty<InlineParameterNewParameterList> NewParameterList { get { return _NewParameterList; }}
    [NotNull] public IRdProperty<string> PreviewText { get { return _PreviewText; }}
    [NotNull] public JetBrains.Rider.Model.RdLanguage Language {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<InlineParameterNewParameterList> _NewParameterList;
    [NotNull] private readonly RdProperty<string> _PreviewText;
    
    //primary constructor
    private InlineParameterRdModel(
      [NotNull] string usedUsage,
      [NotNull] List<InlineParameterParameterModel> parameterList,
      [NotNull] RdProperty<InlineParameterNewParameterList> newParameterList,
      [NotNull] RdProperty<string> previewText,
      [NotNull] JetBrains.Rider.Model.RdLanguage language,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (usedUsage == null) throw new ArgumentNullException("usedUsage");
      if (parameterList == null) throw new ArgumentNullException("parameterList");
      if (newParameterList == null) throw new ArgumentNullException("newParameterList");
      if (previewText == null) throw new ArgumentNullException("previewText");
      if (language == null) throw new ArgumentNullException("language");
      
      UsedUsage = usedUsage;
      ParameterList = parameterList;
      _NewParameterList = newParameterList;
      _PreviewText = previewText;
      Language = language;
      _PreviewText.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("parameterList", ParameterList));
      BindableChildren.Add(new KeyValuePair<string, object>("newParameterList", _NewParameterList));
      BindableChildren.Add(new KeyValuePair<string, object>("previewText", _PreviewText));
    }
    //secondary constructor
    public InlineParameterRdModel (
      [NotNull] string usedUsage,
      [NotNull] List<InlineParameterParameterModel> parameterList,
      [NotNull] JetBrains.Rider.Model.RdLanguage language,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      usedUsage,
      parameterList,
      new RdProperty<InlineParameterNewParameterList>(InlineParameterNewParameterList.Read, InlineParameterNewParameterList.Write),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      language,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<InlineParameterRdModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var usedUsage = reader.ReadString();
      var parameterList = ReadInlineParameterParameterModelList(ctx, reader);
      var newParameterList = RdProperty<InlineParameterNewParameterList>.Read(ctx, reader, InlineParameterNewParameterList.Read, InlineParameterNewParameterList.Write);
      var previewText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var language = JetBrains.Rider.Model.RdLanguage.Read(ctx, reader);
      return new InlineParameterRdModel(usedUsage, parameterList, newParameterList, previewText, language, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<InlineParameterParameterModel>> ReadInlineParameterParameterModelList = InlineParameterParameterModel.Read.List();
    
    public static new CtxWriteDelegate<InlineParameterRdModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.UsedUsage);
      WriteInlineParameterParameterModelList(ctx, writer, value.ParameterList);
      RdProperty<InlineParameterNewParameterList>.Write(ctx, writer, value._NewParameterList);
      RdProperty<string>.Write(ctx, writer, value._PreviewText);
      JetBrains.Rider.Model.RdLanguage.Write(ctx, writer, value.Language);
    };
    public static CtxWriteDelegate<List<InlineParameterParameterModel>> WriteInlineParameterParameterModelList = InlineParameterParameterModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("InlineParameterRdModel (");
      using (printer.IndentCookie()) {
        printer.Print("usedUsage = "); UsedUsage.PrintEx(printer); printer.Println();
        printer.Print("parameterList = "); ParameterList.PrintEx(printer); printer.Println();
        printer.Print("newParameterList = "); _NewParameterList.PrintEx(printer); printer.Println();
        printer.Print("previewText = "); _PreviewText.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntroduceParameterElementModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ElementName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    
    //primary constructor
    private IntroduceParameterElementModel(
      [NotNull] string elementName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isEnabled
    )
    {
      if (elementName == null) throw new ArgumentNullException("elementName");
      if (icon == null) throw new ArgumentNullException("icon");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      
      ElementName = elementName;
      Icon = icon;
      _IsEnabled = isEnabled;
      _IsEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
    }
    //secondary constructor
    public IntroduceParameterElementModel (
      [NotNull] string elementName,
      [NotNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      elementName,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<IntroduceParameterElementModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var elementName = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new IntroduceParameterElementModel(elementName, icon, isEnabled).WithId(_id);
    };
    
    public static CtxWriteDelegate<IntroduceParameterElementModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ElementName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceParameterElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementName = "); ElementName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntroduceParameterModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<string> Suggestions {get; private set;}
    public bool CanBeMadeDefault {get; private set;}
    [NotNull] public IRdProperty<string> NewName { get { return _NewName; }}
    [NotNull] public IRdProperty<string> TypePreview { get { return _TypePreview; }}
    [NotNull] public IRdProperty<bool> MakeDefault { get { return _MakeDefault; }}
    [NotNull] public List<IntroduceParameterElementModel> RemovableParameters {get; private set;}
    [NotNull] public List<IntroduceParameterElementModel> LambdaParameters {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _NewName;
    [NotNull] private readonly RdProperty<string> _TypePreview;
    [NotNull] private readonly RdProperty<bool> _MakeDefault;
    
    //primary constructor
    private IntroduceParameterModel(
      [NotNull] List<string> suggestions,
      bool canBeMadeDefault,
      [NotNull] RdProperty<string> newName,
      [NotNull] RdProperty<string> typePreview,
      [NotNull] RdProperty<bool> makeDefault,
      [NotNull] List<IntroduceParameterElementModel> removableParameters,
      [NotNull] List<IntroduceParameterElementModel> lambdaParameters,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (suggestions == null) throw new ArgumentNullException("suggestions");
      if (newName == null) throw new ArgumentNullException("newName");
      if (typePreview == null) throw new ArgumentNullException("typePreview");
      if (makeDefault == null) throw new ArgumentNullException("makeDefault");
      if (removableParameters == null) throw new ArgumentNullException("removableParameters");
      if (lambdaParameters == null) throw new ArgumentNullException("lambdaParameters");
      
      Suggestions = suggestions;
      CanBeMadeDefault = canBeMadeDefault;
      _NewName = newName;
      _TypePreview = typePreview;
      _MakeDefault = makeDefault;
      RemovableParameters = removableParameters;
      LambdaParameters = lambdaParameters;
      _NewName.OptimizeNested = true;
      _TypePreview.OptimizeNested = true;
      _MakeDefault.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("newName", _NewName));
      BindableChildren.Add(new KeyValuePair<string, object>("typePreview", _TypePreview));
      BindableChildren.Add(new KeyValuePair<string, object>("makeDefault", _MakeDefault));
      BindableChildren.Add(new KeyValuePair<string, object>("removableParameters", RemovableParameters));
      BindableChildren.Add(new KeyValuePair<string, object>("lambdaParameters", LambdaParameters));
    }
    //secondary constructor
    public IntroduceParameterModel (
      [NotNull] List<string> suggestions,
      bool canBeMadeDefault,
      [NotNull] List<IntroduceParameterElementModel> removableParameters,
      [NotNull] List<IntroduceParameterElementModel> lambdaParameters,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      suggestions,
      canBeMadeDefault,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      removableParameters,
      lambdaParameters,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<IntroduceParameterModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var suggestions = ReadStringList(ctx, reader);
      var canBeMadeDefault = reader.ReadBool();
      var newName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var typePreview = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var makeDefault = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var removableParameters = ReadIntroduceParameterElementModelList(ctx, reader);
      var lambdaParameters = ReadIntroduceParameterElementModelList(ctx, reader);
      return new IntroduceParameterModel(suggestions, canBeMadeDefault, newName, typePreview, makeDefault, removableParameters, lambdaParameters, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<List<IntroduceParameterElementModel>> ReadIntroduceParameterElementModelList = IntroduceParameterElementModel.Read.List();
    
    public static new CtxWriteDelegate<IntroduceParameterModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteStringList(ctx, writer, value.Suggestions);
      writer.Write(value.CanBeMadeDefault);
      RdProperty<string>.Write(ctx, writer, value._NewName);
      RdProperty<string>.Write(ctx, writer, value._TypePreview);
      RdProperty<bool>.Write(ctx, writer, value._MakeDefault);
      WriteIntroduceParameterElementModelList(ctx, writer, value.RemovableParameters);
      WriteIntroduceParameterElementModelList(ctx, writer, value.LambdaParameters);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<List<IntroduceParameterElementModel>> WriteIntroduceParameterElementModelList = IntroduceParameterElementModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("IntroduceParameterModel (");
      using (printer.IndentCookie()) {
        printer.Print("suggestions = "); Suggestions.PrintEx(printer); printer.Println();
        printer.Print("canBeMadeDefault = "); CanBeMadeDefault.PrintEx(printer); printer.Println();
        printer.Print("newName = "); _NewName.PrintEx(printer); printer.Println();
        printer.Print("typePreview = "); _TypePreview.PrintEx(printer); printer.Println();
        printer.Print("makeDefault = "); _MakeDefault.PrintEx(printer); printer.Println();
        printer.Print("removableParameters = "); RemovableParameters.PrintEx(printer); printer.Println();
        printer.Print("lambdaParameters = "); LambdaParameters.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LinkInfo : IPrintable, IEquatable<LinkInfo> {
    //fields
    //public fields
    public int Row {get; private set;}
    public int LinkInRow {get; private set;}
    
    //private fields
    //primary constructor
    public LinkInfo(
      int row,
      int linkInRow
    )
    {
      Row = row;
      LinkInRow = linkInRow;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LinkInfo> Read = (ctx, reader) => 
    {
      var row = reader.ReadInt();
      var linkInRow = reader.ReadInt();
      return new LinkInfo(row, linkInRow);
    };
    
    public static CtxWriteDelegate<LinkInfo> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Row);
      writer.Write(value.LinkInRow);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LinkInfo) obj);
    }
    public bool Equals(LinkInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Row == other.Row && LinkInRow == other.LinkInRow;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Row.GetHashCode();
        hash = hash * 31 + LinkInRow.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LinkInfo (");
      using (printer.IndentCookie()) {
        printer.Print("row = "); Row.PrintEx(printer); printer.Println();
        printer.Print("linkInRow = "); LinkInRow.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MessageBoxOK : IPrintable, IEquatable<MessageBoxOK> {
    //fields
    //public fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    public MessageBoxOK(
      [NotNull] string title,
      [NotNull] string message
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (message == null) throw new ArgumentNullException("message");
      
      Title = title;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MessageBoxOK> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var message = reader.ReadString();
      return new MessageBoxOK(title, message);
    };
    
    public static CtxWriteDelegate<MessageBoxOK> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Message);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MessageBoxOK) obj);
    }
    public bool Equals(MessageBoxOK other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Title == other.Title && Message == other.Message;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + Message.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MessageBoxOK (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveConflictModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int ParentId {get; private set;}
    
    //private fields
    //primary constructor
    public MoveConflictModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      int parentId
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Icon = icon;
      ParentId = parentId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MoveConflictModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var parentId = reader.ReadInt();
      return new MoveConflictModel(text, icon, parentId).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<MoveConflictModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.ParentId);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveConflictModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("parentId = "); ParentId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveFileRemoveEmptyFileModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> DoRemove { get { return _DoRemove; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _DoRemove;
    
    //primary constructor
    private MoveFileRemoveEmptyFileModel(
      [NotNull] RdProperty<bool> doRemove,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (doRemove == null) throw new ArgumentNullException("doRemove");
      
      _DoRemove = doRemove;
      _DoRemove.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("doRemove", _DoRemove));
    }
    //secondary constructor
    public MoveFileRemoveEmptyFileModel (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveFileRemoveEmptyFileModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var doRemove = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new MoveFileRemoveEmptyFileModel(doRemove, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<MoveFileRemoveEmptyFileModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._DoRemove);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveFileRemoveEmptyFileModel (");
      using (printer.IndentCookie()) {
        printer.Print("doRemove = "); _DoRemove.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveIntoMatchingFilesModel : AbstractPage
   {
    //fields
    //public fields
    public bool CanMoveDelegates {get; private set;}
    public bool CanMoveClasses {get; private set;}
    public bool CanMoveEnums {get; private set;}
    public bool CanRenameFiles {get; private set;}
    [NotNull] public IRdProperty<bool> MoveDelegates { get { return _MoveDelegates; }}
    [NotNull] public IRdProperty<bool> MoveClasses { get { return _MoveClasses; }}
    [NotNull] public IRdProperty<bool> MoveEnums { get { return _MoveEnums; }}
    [NotNull] public IRdProperty<bool> RenameFiles { get { return _RenameFiles; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _MoveDelegates;
    [NotNull] private readonly RdProperty<bool> _MoveClasses;
    [NotNull] private readonly RdProperty<bool> _MoveEnums;
    [NotNull] private readonly RdProperty<bool> _RenameFiles;
    
    //primary constructor
    private MoveIntoMatchingFilesModel(
      bool canMoveDelegates,
      bool canMoveClasses,
      bool canMoveEnums,
      bool canRenameFiles,
      [NotNull] RdProperty<bool> moveDelegates,
      [NotNull] RdProperty<bool> moveClasses,
      [NotNull] RdProperty<bool> moveEnums,
      [NotNull] RdProperty<bool> renameFiles,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (moveDelegates == null) throw new ArgumentNullException("moveDelegates");
      if (moveClasses == null) throw new ArgumentNullException("moveClasses");
      if (moveEnums == null) throw new ArgumentNullException("moveEnums");
      if (renameFiles == null) throw new ArgumentNullException("renameFiles");
      
      CanMoveDelegates = canMoveDelegates;
      CanMoveClasses = canMoveClasses;
      CanMoveEnums = canMoveEnums;
      CanRenameFiles = canRenameFiles;
      _MoveDelegates = moveDelegates;
      _MoveClasses = moveClasses;
      _MoveEnums = moveEnums;
      _RenameFiles = renameFiles;
      _MoveDelegates.OptimizeNested = true;
      _MoveClasses.OptimizeNested = true;
      _MoveEnums.OptimizeNested = true;
      _RenameFiles.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("moveDelegates", _MoveDelegates));
      BindableChildren.Add(new KeyValuePair<string, object>("moveClasses", _MoveClasses));
      BindableChildren.Add(new KeyValuePair<string, object>("moveEnums", _MoveEnums));
      BindableChildren.Add(new KeyValuePair<string, object>("renameFiles", _RenameFiles));
    }
    //secondary constructor
    public MoveIntoMatchingFilesModel (
      bool canMoveDelegates,
      bool canMoveClasses,
      bool canMoveEnums,
      bool canRenameFiles,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      canMoveDelegates,
      canMoveClasses,
      canMoveEnums,
      canRenameFiles,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveIntoMatchingFilesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var canMoveDelegates = reader.ReadBool();
      var canMoveClasses = reader.ReadBool();
      var canMoveEnums = reader.ReadBool();
      var canRenameFiles = reader.ReadBool();
      var moveDelegates = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var moveClasses = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var moveEnums = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var renameFiles = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new MoveIntoMatchingFilesModel(canMoveDelegates, canMoveClasses, canMoveEnums, canRenameFiles, moveDelegates, moveClasses, moveEnums, renameFiles, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<MoveIntoMatchingFilesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.CanMoveDelegates);
      writer.Write(value.CanMoveClasses);
      writer.Write(value.CanMoveEnums);
      writer.Write(value.CanRenameFiles);
      RdProperty<bool>.Write(ctx, writer, value._MoveDelegates);
      RdProperty<bool>.Write(ctx, writer, value._MoveClasses);
      RdProperty<bool>.Write(ctx, writer, value._MoveEnums);
      RdProperty<bool>.Write(ctx, writer, value._RenameFiles);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveIntoMatchingFilesModel (");
      using (printer.IndentCookie()) {
        printer.Print("canMoveDelegates = "); CanMoveDelegates.PrintEx(printer); printer.Println();
        printer.Print("canMoveClasses = "); CanMoveClasses.PrintEx(printer); printer.Println();
        printer.Print("canMoveEnums = "); CanMoveEnums.PrintEx(printer); printer.Println();
        printer.Print("canRenameFiles = "); CanRenameFiles.PrintEx(printer); printer.Println();
        printer.Print("moveDelegates = "); _MoveDelegates.PrintEx(printer); printer.Println();
        printer.Print("moveClasses = "); _MoveClasses.PrintEx(printer); printer.Println();
        printer.Print("moveEnums = "); _MoveEnums.PrintEx(printer); printer.Println();
        printer.Print("renameFiles = "); _RenameFiles.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveStaticMemberMemberModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string MemberName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    [NotNull] private readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    private MoveStaticMemberMemberModel(
      [NotNull] string memberName,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> isSelected,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (memberName == null) throw new ArgumentNullException("memberName");
      if (icon == null) throw new ArgumentNullException("icon");
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      MemberName = memberName;
      Icon = icon;
      _IsSelected = isSelected;
      _Navigate = navigate;
      _IsSelected.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public MoveStaticMemberMemberModel (
      [NotNull] string memberName,
      [NotNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      memberName,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<MoveStaticMemberMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var memberName = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var isSelected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new MoveStaticMemberMemberModel(memberName, icon, isSelected, navigate).WithId(_id);
    };
    
    public static CtxWriteDelegate<MoveStaticMemberMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.MemberName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveStaticMemberMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("memberName = "); MemberName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveStaticMemberModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string SourceType {get; private set;}
    [NotNull] public IRdProperty<string> TargetName { get { return _TargetName; }}
    [NotNull] public IRdProperty<MoveStaticMemberVisibility> Visibility { get { return _Visibility; }}
    [NotNull] public List<MoveStaticMemberMemberModel> Members {get; private set;}
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _TargetName;
    [NotNull] private readonly RdProperty<MoveStaticMemberVisibility> _Visibility;
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private MoveStaticMemberModel(
      [NotNull] string sourceType,
      [NotNull] RdProperty<string> targetName,
      [NotNull] RdProperty<MoveStaticMemberVisibility> visibility,
      [NotNull] List<MoveStaticMemberMemberModel> members,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (sourceType == null) throw new ArgumentNullException("sourceType");
      if (targetName == null) throw new ArgumentNullException("targetName");
      if (visibility == null) throw new ArgumentNullException("visibility");
      if (members == null) throw new ArgumentNullException("members");
      if (completionList == null) throw new ArgumentNullException("completionList");
      
      SourceType = sourceType;
      _TargetName = targetName;
      _Visibility = visibility;
      Members = members;
      _CompletionList = completionList;
      _TargetName.OptimizeNested = true;
      _Visibility.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("targetName", _TargetName));
      BindableChildren.Add(new KeyValuePair<string, object>("visibility", _Visibility));
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
      BindableChildren.Add(new KeyValuePair<string, object>("completionList", _CompletionList));
    }
    //secondary constructor
    public MoveStaticMemberModel (
      [NotNull] string sourceType,
      [NotNull] List<MoveStaticMemberMemberModel> members,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      sourceType,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<MoveStaticMemberVisibility>(ReadMoveStaticMemberVisibility, WriteMoveStaticMemberVisibility),
      members,
      new RdProperty<RefactoringCompletionList>(RefactoringCompletionList.Read, RefactoringCompletionList.Write),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveStaticMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var sourceType = reader.ReadString();
      var targetName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visibility = RdProperty<MoveStaticMemberVisibility>.Read(ctx, reader, ReadMoveStaticMemberVisibility, WriteMoveStaticMemberVisibility);
      var members = ReadMoveStaticMemberMemberModelList(ctx, reader);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader, RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      return new MoveStaticMemberModel(sourceType, targetName, visibility, members, completionList, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<MoveStaticMemberVisibility> ReadMoveStaticMemberVisibility = new CtxReadDelegate<MoveStaticMemberVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<MoveStaticMemberVisibility>);
    public static CtxReadDelegate<List<MoveStaticMemberMemberModel>> ReadMoveStaticMemberMemberModelList = MoveStaticMemberMemberModel.Read.List();
    
    public static new CtxWriteDelegate<MoveStaticMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.SourceType);
      RdProperty<string>.Write(ctx, writer, value._TargetName);
      RdProperty<MoveStaticMemberVisibility>.Write(ctx, writer, value._Visibility);
      WriteMoveStaticMemberMemberModelList(ctx, writer, value.Members);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
    };
    public static CtxWriteDelegate<MoveStaticMemberVisibility> WriteMoveStaticMemberVisibility = new CtxWriteDelegate<MoveStaticMemberVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<MoveStaticMemberVisibility>);
    public static CtxWriteDelegate<List<MoveStaticMemberMemberModel>> WriteMoveStaticMemberMemberModelList = MoveStaticMemberMemberModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveStaticMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("sourceType = "); SourceType.PrintEx(printer); printer.Println();
        printer.Print("targetName = "); _TargetName.PrintEx(printer); printer.Println();
        printer.Print("visibility = "); _Visibility.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MoveStaticMemberVisibility {
    AsIs,
    Public,
    Private,
    Protected,
    Internal,
    ProtectedInternal
  }
  
  
  public class MoveToFolderModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> FolderName { get { return _FolderName; }}
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    [NotNull] public IRdProperty<bool> CreateEnabled { get { return _CreateEnabled; }}
    [NotNull] public IRdSignal<RdVoid> CreateClicked { get { return _CreateClicked; }}
    public bool FixNamespacesVisible {get; private set;}
    public bool SearchInRelatedFilesVisible {get; private set;}
    [NotNull] public IRdProperty<bool> FixVisibility { get { return _FixVisibility; }}
    [NotNull] public IRdProperty<bool> FixNamespaces { get { return _FixNamespaces; }}
    [NotNull] public IRdProperty<bool> SearchInRelatedFiles { get { return _SearchInRelatedFiles; }}
    [NotNull] public IRdProperty<bool> MoveToSeparateFiles { get { return _MoveToSeparateFiles; }}
    [NotNull] public List<MoveToFolderTreeElement> ElementsTree {get; private set;}
    [NotNull] public IRdProperty<string> TextfieldValidationResult { get { return _TextfieldValidationResult; }}
    [NotNull] public IRdProperty<string> TreeValidationResult { get { return _TreeValidationResult; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _FolderName;
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    [NotNull] private readonly RdProperty<bool> _CreateEnabled;
    [NotNull] private readonly RdSignal<RdVoid> _CreateClicked;
    [NotNull] private readonly RdProperty<bool> _FixVisibility;
    [NotNull] private readonly RdProperty<bool> _FixNamespaces;
    [NotNull] private readonly RdProperty<bool> _SearchInRelatedFiles;
    [NotNull] private readonly RdProperty<bool> _MoveToSeparateFiles;
    [NotNull] private readonly RdProperty<string> _TextfieldValidationResult;
    [NotNull] private readonly RdProperty<string> _TreeValidationResult;
    
    //primary constructor
    private MoveToFolderModel(
      [NotNull] RdProperty<string> folderName,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] RdProperty<bool> createEnabled,
      [NotNull] RdSignal<RdVoid> createClicked,
      bool fixNamespacesVisible,
      bool searchInRelatedFilesVisible,
      [NotNull] RdProperty<bool> fixVisibility,
      [NotNull] RdProperty<bool> fixNamespaces,
      [NotNull] RdProperty<bool> searchInRelatedFiles,
      [NotNull] RdProperty<bool> moveToSeparateFiles,
      [NotNull] List<MoveToFolderTreeElement> elementsTree,
      [NotNull] RdProperty<string> textfieldValidationResult,
      [NotNull] RdProperty<string> treeValidationResult,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (folderName == null) throw new ArgumentNullException("folderName");
      if (completionList == null) throw new ArgumentNullException("completionList");
      if (createEnabled == null) throw new ArgumentNullException("createEnabled");
      if (createClicked == null) throw new ArgumentNullException("createClicked");
      if (fixVisibility == null) throw new ArgumentNullException("fixVisibility");
      if (fixNamespaces == null) throw new ArgumentNullException("fixNamespaces");
      if (searchInRelatedFiles == null) throw new ArgumentNullException("searchInRelatedFiles");
      if (moveToSeparateFiles == null) throw new ArgumentNullException("moveToSeparateFiles");
      if (elementsTree == null) throw new ArgumentNullException("elementsTree");
      if (textfieldValidationResult == null) throw new ArgumentNullException("textfieldValidationResult");
      if (treeValidationResult == null) throw new ArgumentNullException("treeValidationResult");
      
      _FolderName = folderName;
      _CompletionList = completionList;
      _CreateEnabled = createEnabled;
      _CreateClicked = createClicked;
      FixNamespacesVisible = fixNamespacesVisible;
      SearchInRelatedFilesVisible = searchInRelatedFilesVisible;
      _FixVisibility = fixVisibility;
      _FixNamespaces = fixNamespaces;
      _SearchInRelatedFiles = searchInRelatedFiles;
      _MoveToSeparateFiles = moveToSeparateFiles;
      ElementsTree = elementsTree;
      _TextfieldValidationResult = textfieldValidationResult;
      _TreeValidationResult = treeValidationResult;
      _FolderName.OptimizeNested = true;
      _CreateEnabled.OptimizeNested = true;
      _FixVisibility.OptimizeNested = true;
      _FixNamespaces.OptimizeNested = true;
      _SearchInRelatedFiles.OptimizeNested = true;
      _MoveToSeparateFiles.OptimizeNested = true;
      _TextfieldValidationResult.OptimizeNested = true;
      _TreeValidationResult.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("folderName", _FolderName));
      BindableChildren.Add(new KeyValuePair<string, object>("completionList", _CompletionList));
      BindableChildren.Add(new KeyValuePair<string, object>("createEnabled", _CreateEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("createClicked", _CreateClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("fixVisibility", _FixVisibility));
      BindableChildren.Add(new KeyValuePair<string, object>("fixNamespaces", _FixNamespaces));
      BindableChildren.Add(new KeyValuePair<string, object>("searchInRelatedFiles", _SearchInRelatedFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("moveToSeparateFiles", _MoveToSeparateFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("elementsTree", ElementsTree));
      BindableChildren.Add(new KeyValuePair<string, object>("textfieldValidationResult", _TextfieldValidationResult));
      BindableChildren.Add(new KeyValuePair<string, object>("treeValidationResult", _TreeValidationResult));
    }
    //secondary constructor
    public MoveToFolderModel (
      bool fixNamespacesVisible,
      bool searchInRelatedFilesVisible,
      [NotNull] List<MoveToFolderTreeElement> elementsTree,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<RefactoringCompletionList>(RefactoringCompletionList.Read, RefactoringCompletionList.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      fixNamespacesVisible,
      searchInRelatedFilesVisible,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      elementsTree,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveToFolderModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var folderName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader, RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      var createEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var createClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var fixNamespacesVisible = reader.ReadBool();
      var searchInRelatedFilesVisible = reader.ReadBool();
      var fixVisibility = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var fixNamespaces = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var searchInRelatedFiles = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var moveToSeparateFiles = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var elementsTree = ReadMoveToFolderTreeElementList(ctx, reader);
      var textfieldValidationResult = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var treeValidationResult = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new MoveToFolderModel(folderName, completionList, createEnabled, createClicked, fixNamespacesVisible, searchInRelatedFilesVisible, fixVisibility, fixNamespaces, searchInRelatedFiles, moveToSeparateFiles, elementsTree, textfieldValidationResult, treeValidationResult, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<MoveToFolderTreeElement>> ReadMoveToFolderTreeElementList = MoveToFolderTreeElement.Read.List();
    
    public static new CtxWriteDelegate<MoveToFolderModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<string>.Write(ctx, writer, value._FolderName);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
      RdProperty<bool>.Write(ctx, writer, value._CreateEnabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._CreateClicked);
      writer.Write(value.FixNamespacesVisible);
      writer.Write(value.SearchInRelatedFilesVisible);
      RdProperty<bool>.Write(ctx, writer, value._FixVisibility);
      RdProperty<bool>.Write(ctx, writer, value._FixNamespaces);
      RdProperty<bool>.Write(ctx, writer, value._SearchInRelatedFiles);
      RdProperty<bool>.Write(ctx, writer, value._MoveToSeparateFiles);
      WriteMoveToFolderTreeElementList(ctx, writer, value.ElementsTree);
      RdProperty<string>.Write(ctx, writer, value._TextfieldValidationResult);
      RdProperty<string>.Write(ctx, writer, value._TreeValidationResult);
    };
    public static CtxWriteDelegate<List<MoveToFolderTreeElement>> WriteMoveToFolderTreeElementList = MoveToFolderTreeElement.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToFolderModel (");
      using (printer.IndentCookie()) {
        printer.Print("folderName = "); _FolderName.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("createEnabled = "); _CreateEnabled.PrintEx(printer); printer.Println();
        printer.Print("createClicked = "); _CreateClicked.PrintEx(printer); printer.Println();
        printer.Print("fixNamespacesVisible = "); FixNamespacesVisible.PrintEx(printer); printer.Println();
        printer.Print("searchInRelatedFilesVisible = "); SearchInRelatedFilesVisible.PrintEx(printer); printer.Println();
        printer.Print("fixVisibility = "); _FixVisibility.PrintEx(printer); printer.Println();
        printer.Print("fixNamespaces = "); _FixNamespaces.PrintEx(printer); printer.Println();
        printer.Print("searchInRelatedFiles = "); _SearchInRelatedFiles.PrintEx(printer); printer.Println();
        printer.Print("moveToSeparateFiles = "); _MoveToSeparateFiles.PrintEx(printer); printer.Println();
        printer.Print("elementsTree = "); ElementsTree.PrintEx(printer); printer.Println();
        printer.Print("textfieldValidationResult = "); _TextfieldValidationResult.PrintEx(printer); printer.Println();
        printer.Print("treeValidationResult = "); _TreeValidationResult.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveToFolderTreeElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<int> Children {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] public IRdProperty<string> ErrorText { get { return _ErrorText; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Included;
    [NotNull] private readonly RdProperty<string> _ErrorText;
    [NotNull] private readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    private MoveToFolderTreeElement(
      [NotNull] List<int> children,
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<string> errorText,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (children == null) throw new ArgumentNullException("children");
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      if (included == null) throw new ArgumentNullException("included");
      if (errorText == null) throw new ArgumentNullException("errorText");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Children = children;
      Text = text;
      Icon = icon;
      _Included = included;
      _ErrorText = errorText;
      _Navigate = navigate;
      _Included.OptimizeNested = true;
      _ErrorText.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("included", _Included));
      BindableChildren.Add(new KeyValuePair<string, object>("errorText", _ErrorText));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    public MoveToFolderTreeElement (
      [NotNull] List<int> children,
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      children,
      text,
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<MoveToFolderTreeElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var children = ReadIntList(ctx, reader);
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var errorText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new MoveToFolderTreeElement(children, text, icon, included, errorText, navigate).WithId(_id);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<MoveToFolderTreeElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIntList(ctx, writer, value.Children);
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<string>.Write(ctx, writer, value._ErrorText);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToFolderTreeElement (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("errorText = "); _ErrorText.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MoveToNamespaceModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string LabelText {get; private set;}
    [NotNull] public IRdProperty<string> NamespaceName { get { return _NamespaceName; }}
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _NamespaceName;
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private MoveToNamespaceModel(
      [NotNull] string labelText,
      [NotNull] RdProperty<string> namespaceName,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (labelText == null) throw new ArgumentNullException("labelText");
      if (namespaceName == null) throw new ArgumentNullException("namespaceName");
      if (completionList == null) throw new ArgumentNullException("completionList");
      
      LabelText = labelText;
      _NamespaceName = namespaceName;
      _CompletionList = completionList;
      _NamespaceName.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("namespaceName", _NamespaceName));
      BindableChildren.Add(new KeyValuePair<string, object>("completionList", _CompletionList));
    }
    //secondary constructor
    public MoveToNamespaceModel (
      [NotNull] string labelText,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      labelText,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<RefactoringCompletionList>(RefactoringCompletionList.Read, RefactoringCompletionList.Write),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<MoveToNamespaceModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var labelText = reader.ReadString();
      var namespaceName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader, RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      return new MoveToNamespaceModel(labelText, namespaceName, completionList, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<MoveToNamespaceModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.LabelText);
      RdProperty<string>.Write(ctx, writer, value._NamespaceName);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MoveToNamespaceModel (");
      using (printer.IndentCookie()) {
        printer.Print("labelText = "); LabelText.PrintEx(printer); printer.Println();
        printer.Print("namespaceName = "); _NamespaceName.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class PullToolSessionBaseNode : RdBindableBase {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string Text {get; private set;}
    [NotNull] public IRdProperty<string> ResolutionText { get { return _ResolutionText; }}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] public List<string> PossibleFixes {get; private set;}
    [NotNull] public IRdProperty<int> SelectedFix { get { return _SelectedFix; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<string> _ResolutionText;
    [NotNull] protected readonly RdProperty<bool> _IsEnabled;
    [NotNull] protected readonly RdProperty<int> _SelectedFix;
    [NotNull] protected readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    protected PullToolSessionBaseNode(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] RdProperty<string> resolutionText,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] List<string> possibleFixes,
      [NotNull] RdProperty<int> selectedFix,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (icon == null) throw new ArgumentNullException("icon");
      if (text == null) throw new ArgumentNullException("text");
      if (resolutionText == null) throw new ArgumentNullException("resolutionText");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      if (possibleFixes == null) throw new ArgumentNullException("possibleFixes");
      if (selectedFix == null) throw new ArgumentNullException("selectedFix");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Icon = icon;
      Text = text;
      _ResolutionText = resolutionText;
      _IsEnabled = isEnabled;
      PossibleFixes = possibleFixes;
      _SelectedFix = selectedFix;
      _Navigate = navigate;
      _ResolutionText.OptimizeNested = true;
      _IsEnabled.OptimizeNested = true;
      _SelectedFix.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("resolutionText", _ResolutionText));
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedFix", _SelectedFix));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PullToolSessionBaseNode> Read = Polymorphic<PullToolSessionBaseNode>.ReadAbstract(PullToolSessionBaseNode_Unknown.Read);
    
    public static CtxWriteDelegate<PullToolSessionBaseNode> Write = Polymorphic<PullToolSessionBaseNode>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class PullToolSessionBaseNode_Unknown : PullToolSessionBaseNode
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private PullToolSessionBaseNode_Unknown(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] RdProperty<string> resolutionText,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] List<string> possibleFixes,
      [NotNull] RdProperty<int> selectedFix,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      icon,
      text,
      resolutionText,
      isEnabled,
      possibleFixes,
      selectedFix,
      navigate
     ) 
    {
    }
    //secondary constructor
    public PullToolSessionBaseNode_Unknown (
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] List<string> possibleFixes
    ) : this (
      icon,
      text,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      possibleFixes,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<PullToolSessionBaseNode_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var text = reader.ReadString();
      var resolutionText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var possibleFixes = ReadStringList(ctx, reader);
      var selectedFix = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new PullToolSessionBaseNode_Unknown(icon, text, resolutionText, isEnabled, possibleFixes, selectedFix, navigate).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<PullToolSessionBaseNode_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.Text);
      RdProperty<string>.Write(ctx, writer, value._ResolutionText);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      WriteStringList(ctx, writer, value.PossibleFixes);
      RdProperty<int>.Write(ctx, writer, value._SelectedFix);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionBaseNode_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("resolutionText = "); _ResolutionText.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("possibleFixes = "); PossibleFixes.PrintEx(printer); printer.Println();
        printer.Print("selectedFix = "); _SelectedFix.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullToolSessionModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string SessionName {get; private set;}
    [NotNull] public List<PullToolSessionNode> Roots {get; private set;}
    
    //private fields
    //primary constructor
    public PullToolSessionModel(
      [NotNull] string sessionName,
      [NotNull] List<PullToolSessionNode> roots
    )
    {
      if (sessionName == null) throw new ArgumentNullException("sessionName");
      if (roots == null) throw new ArgumentNullException("roots");
      
      SessionName = sessionName;
      Roots = roots;
      BindableChildren.Add(new KeyValuePair<string, object>("roots", Roots));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PullToolSessionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var sessionName = reader.ReadString();
      var roots = ReadPullToolSessionNodeList(ctx, reader);
      return new PullToolSessionModel(sessionName, roots).WithId(_id);
    };
    public static CtxReadDelegate<List<PullToolSessionNode>> ReadPullToolSessionNodeList = PullToolSessionNode.Read.List();
    
    public static CtxWriteDelegate<PullToolSessionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.SessionName);
      WritePullToolSessionNodeList(ctx, writer, value.Roots);
    };
    public static CtxWriteDelegate<List<PullToolSessionNode>> WritePullToolSessionNodeList = PullToolSessionNode.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("sessionName = "); SessionName.PrintEx(printer); printer.Println();
        printer.Print("roots = "); Roots.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullToolSessionNode : PullToolSessionBaseNode
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<PullToolSessionNodeChildren> Children { get { return _Children; }}
    
    //private fields
    [NotNull] private readonly RdProperty<PullToolSessionNodeChildren> _Children;
    
    //primary constructor
    private PullToolSessionNode(
      [NotNull] RdProperty<PullToolSessionNodeChildren> children,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] RdProperty<string> resolutionText,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] List<string> possibleFixes,
      [NotNull] RdProperty<int> selectedFix,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      icon,
      text,
      resolutionText,
      isEnabled,
      possibleFixes,
      selectedFix,
      navigate
     ) 
    {
      if (children == null) throw new ArgumentNullException("children");
      
      _Children = children;
      BindableChildren.Add(new KeyValuePair<string, object>("children", _Children));
    }
    //secondary constructor
    public PullToolSessionNode (
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string text,
      [NotNull] List<string> possibleFixes
    ) : this (
      new RdProperty<PullToolSessionNodeChildren>(PullToolSessionNodeChildren.Read, PullToolSessionNodeChildren.Write),
      icon,
      text,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      possibleFixes,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<PullToolSessionNode> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var text = reader.ReadString();
      var resolutionText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var possibleFixes = ReadStringList(ctx, reader);
      var selectedFix = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var children = RdProperty<PullToolSessionNodeChildren>.Read(ctx, reader, PullToolSessionNodeChildren.Read, PullToolSessionNodeChildren.Write);
      return new PullToolSessionNode(children, icon, text, resolutionText, isEnabled, possibleFixes, selectedFix, navigate).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<PullToolSessionNode> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.Text);
      RdProperty<string>.Write(ctx, writer, value._ResolutionText);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      WriteStringList(ctx, writer, value.PossibleFixes);
      RdProperty<int>.Write(ctx, writer, value._SelectedFix);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
      RdProperty<PullToolSessionNodeChildren>.Write(ctx, writer, value._Children);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionNode (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); _Children.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("resolutionText = "); _ResolutionText.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("possibleFixes = "); PossibleFixes.PrintEx(printer); printer.Println();
        printer.Print("selectedFix = "); _SelectedFix.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullToolSessionNodeChildren : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<PullToolSessionBaseNode> Data {get; private set;}
    
    //private fields
    //primary constructor
    public PullToolSessionNodeChildren(
      [NotNull] List<PullToolSessionBaseNode> data
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      
      Data = data;
      BindableChildren.Add(new KeyValuePair<string, object>("data", Data));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PullToolSessionNodeChildren> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var data = ReadPullToolSessionBaseNodeList(ctx, reader);
      return new PullToolSessionNodeChildren(data).WithId(_id);
    };
    public static CtxReadDelegate<List<PullToolSessionBaseNode>> ReadPullToolSessionBaseNodeList = PullToolSessionBaseNode.Read.List();
    
    public static CtxWriteDelegate<PullToolSessionNodeChildren> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WritePullToolSessionBaseNodeList(ctx, writer, value.Data);
    };
    public static CtxWriteDelegate<List<PullToolSessionBaseNode>> WritePullToolSessionBaseNodeList = PullToolSessionBaseNode.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullToolSessionNodeChildren (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); Data.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullUpMembersModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<PullUpTreeElementModel> Ancestors {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] public IRdProperty<ExtractInterfaceMemberModel> Members { get { return _Members; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] private readonly RdProperty<ExtractInterfaceMemberModel> _Members;
    
    //primary constructor
    private PullUpMembersModel(
      [NotNull] List<PullUpTreeElementModel> ancestors,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<ExtractInterfaceMemberModel> members,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (ancestors == null) throw new ArgumentNullException("ancestors");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      if (members == null) throw new ArgumentNullException("members");
      
      Ancestors = ancestors;
      _SelectedIndex = selectedIndex;
      _Members = members;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("ancestors", Ancestors));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
      BindableChildren.Add(new KeyValuePair<string, object>("members", _Members));
    }
    //secondary constructor
    public PullUpMembersModel (
      [NotNull] List<PullUpTreeElementModel> ancestors,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      ancestors,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<ExtractInterfaceMemberModel>(ExtractInterfaceMemberModel.Read, ExtractInterfaceMemberModel.Write),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<PullUpMembersModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var ancestors = ReadPullUpTreeElementModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var members = RdProperty<ExtractInterfaceMemberModel>.Read(ctx, reader, ExtractInterfaceMemberModel.Read, ExtractInterfaceMemberModel.Write);
      return new PullUpMembersModel(ancestors, selectedIndex, members, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<PullUpTreeElementModel>> ReadPullUpTreeElementModelList = PullUpTreeElementModel.Read.List();
    
    public static new CtxWriteDelegate<PullUpMembersModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WritePullUpTreeElementModelList(ctx, writer, value.Ancestors);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdProperty<ExtractInterfaceMemberModel>.Write(ctx, writer, value._Members);
    };
    public static CtxWriteDelegate<List<PullUpTreeElementModel>> WritePullUpTreeElementModelList = PullUpTreeElementModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullUpMembersModel (");
      using (printer.IndentCookie()) {
        printer.Print("ancestors = "); Ancestors.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("members = "); _Members.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PullUpTreeElementModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ClassName {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<int> Children {get; private set;}
    
    //private fields
    //primary constructor
    public PullUpTreeElementModel(
      [NotNull] string className,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<int> children
    )
    {
      if (className == null) throw new ArgumentNullException("className");
      if (icon == null) throw new ArgumentNullException("icon");
      if (children == null) throw new ArgumentNullException("children");
      
      ClassName = className;
      Icon = icon;
      Children = children;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PullUpTreeElementModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var className = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var children = ReadIntList(ctx, reader);
      return new PullUpTreeElementModel(className, icon, children).WithId(_id);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<PullUpTreeElementModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ClassName);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      WriteIntList(ctx, writer, value.Children);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PullUpTreeElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("className = "); ClassName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PushDownMembersModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public ExtractInterfaceMemberModel Members {get; private set;}
    [NotNull] public List<PushDownSingleMemberModel> Children {get; private set;}
    
    //private fields
    //primary constructor
    private PushDownMembersModel(
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] List<PushDownSingleMemberModel> children,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (members == null) throw new ArgumentNullException("members");
      if (children == null) throw new ArgumentNullException("children");
      
      Members = members;
      Children = children;
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
      BindableChildren.Add(new KeyValuePair<string, object>("children", Children));
    }
    //secondary constructor
    public PushDownMembersModel (
      [NotNull] ExtractInterfaceMemberModel members,
      [NotNull] List<PushDownSingleMemberModel> children,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      members,
      children,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<PushDownMembersModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var members = ExtractInterfaceMemberModel.Read(ctx, reader);
      var children = ReadPushDownSingleMemberModelList(ctx, reader);
      return new PushDownMembersModel(members, children, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<PushDownSingleMemberModel>> ReadPushDownSingleMemberModelList = PushDownSingleMemberModel.Read.List();
    
    public static new CtxWriteDelegate<PushDownMembersModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      ExtractInterfaceMemberModel.Write(ctx, writer, value.Members);
      WritePushDownSingleMemberModelList(ctx, writer, value.Children);
    };
    public static CtxWriteDelegate<List<PushDownSingleMemberModel>> WritePushDownSingleMemberModelList = PushDownSingleMemberModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PushDownMembersModel (");
      using (printer.IndentCookie()) {
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PushDownSingleMemberModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public TextWithIconModel Info {get; private set;}
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    
    //primary constructor
    private PushDownSingleMemberModel(
      [NotNull] TextWithIconModel info,
      [NotNull] RdProperty<bool> isSelected
    )
    {
      if (info == null) throw new ArgumentNullException("info");
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      
      Info = info;
      _IsSelected = isSelected;
      _IsSelected.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
    }
    //secondary constructor
    public PushDownSingleMemberModel (
      [NotNull] TextWithIconModel info
    ) : this (
      info,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<PushDownSingleMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var info = TextWithIconModel.Read(ctx, reader);
      var isSelected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new PushDownSingleMemberModel(info, isSelected).WithId(_id);
    };
    
    public static CtxWriteDelegate<PushDownSingleMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      TextWithIconModel.Write(ctx, writer, value.Info);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("PushDownSingleMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("info = "); Info.PrintEx(printer); printer.Println();
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdAdjustNamespacesViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection ProjectFilesWithProblems {get; private set;}
    
    //private fields
    //primary constructor
    private RdAdjustNamespacesViewModel(
      [NotNull] RdSelectionCollection projectFilesWithProblems,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (projectFilesWithProblems == null) throw new ArgumentNullException("projectFilesWithProblems");
      
      ProjectFilesWithProblems = projectFilesWithProblems;
      BindableChildren.Add(new KeyValuePair<string, object>("projectFilesWithProblems", ProjectFilesWithProblems));
    }
    //secondary constructor
    public RdAdjustNamespacesViewModel (
      [NotNull] RdSelectionCollection projectFilesWithProblems,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      projectFilesWithProblems,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdAdjustNamespacesViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var projectFilesWithProblems = RdSelectionCollection.Read(ctx, reader);
      return new RdAdjustNamespacesViewModel(projectFilesWithProblems, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdAdjustNamespacesViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.ProjectFilesWithProblems);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdAdjustNamespacesViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("projectFilesWithProblems = "); ProjectFilesWithProblems.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCheckBoxViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<bool> Property { get { return _Property; }}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Property;
    [NotNull] private readonly RdProperty<bool> _Enabled;
    
    //primary constructor
    private RdCheckBoxViewModel(
      [NotNull] string description,
      [NotNull] RdProperty<bool> property,
      [NotNull] RdProperty<bool> enabled
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (property == null) throw new ArgumentNullException("property");
      if (enabled == null) throw new ArgumentNullException("enabled");
      
      Description = description;
      _Property = property;
      _Enabled = enabled;
      _Property.OptimizeNested = true;
      _Enabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
    }
    //secondary constructor
    public RdCheckBoxViewModel (
      [NotNull] string description
    ) : this (
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCheckBoxViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var property = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdCheckBoxViewModel(description, property, enabled).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCheckBoxViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._Property);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCheckBoxViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCodePreviewPresentation : RdBindableBase, JetBrains.Application.UI.UIAutomation.IAutomation {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public JetBrains.Rider.Model.RdLanguage Language {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    
    //primary constructor
    private RdCodePreviewPresentation(
      [NotNull] RdProperty<string> text,
      [NotNull] JetBrains.Rider.Model.RdLanguage language
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (language == null) throw new ArgumentNullException("language");
      
      _Text = text;
      Language = language;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
    }
    //secondary constructor
    public RdCodePreviewPresentation (
      [NotNull] JetBrains.Rider.Model.RdLanguage language
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      language
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCodePreviewPresentation> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var language = JetBrains.Rider.Model.RdLanguage.Read(ctx, reader);
      return new RdCodePreviewPresentation(text, language).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCodePreviewPresentation> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._Text);
      JetBrains.Rider.Model.RdLanguage.Write(ctx, writer, value.Language);
    };
    //custom body
    public event System.ComponentModel.PropertyChangedEventHandler PropertyChanged;
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCodePreviewPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdConflictsViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection Conflicts {get; private set;}
    
    //private fields
    //primary constructor
    private RdConflictsViewModel(
      [NotNull] RdSelectionCollection conflicts,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (conflicts == null) throw new ArgumentNullException("conflicts");
      
      Conflicts = conflicts;
      BindableChildren.Add(new KeyValuePair<string, object>("conflicts", Conflicts));
    }
    //secondary constructor
    public RdConflictsViewModel (
      [NotNull] RdSelectionCollection conflicts,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      conflicts,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdConflictsViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var conflicts = RdSelectionCollection.Read(ctx, reader);
      return new RdConflictsViewModel(conflicts, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdConflictsViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.Conflicts);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdConflictsViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("conflicts = "); Conflicts.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDeclaredElementViewModelElement : RdListViewModelElement
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> AdditionalIcon { get { return _AdditionalIcon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _AdditionalIcon;
    
    //primary constructor
    private RdDeclaredElementViewModelElement(
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> additionalIcon,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
      if (additionalIcon == null) throw new ArgumentNullException("additionalIcon");
      
      _AdditionalIcon = additionalIcon;
      _AdditionalIcon.OptimizeNested = true;
      _AdditionalIcon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("additionalIcon", _AdditionalIcon));
    }
    //secondary constructor
    public RdDeclaredElementViewModelElement (
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdDeclaredElementViewModelElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var additionalIcon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      return new RdDeclaredElementViewModelElement(additionalIcon, text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdDeclaredElementViewModelElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._AdditionalIcon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDeclaredElementViewModelElement (");
      using (printer.IndentCookie()) {
        printer.Print("additionalIcon = "); _AdditionalIcon.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEditableTextViewModel : RdTextViewModel
   {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> ValidationResult { get { return _ValidationResult; }}
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<RefactoringCompletionList> CompletionList { get { return _CompletionList; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> _ValidationResult;
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<RefactoringCompletionList> _CompletionList;
    
    //primary constructor
    private RdEditableTextViewModel(
      [NotNull] string description,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<RefactoringCompletionList> completionList,
      [NotNull] string initialText
    ) : base (
      initialText
     ) 
    {
      if (description == null) throw new ArgumentNullException("description");
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      if (text == null) throw new ArgumentNullException("text");
      if (completionList == null) throw new ArgumentNullException("completionList");
      
      Description = description;
      _ValidationResult = validationResult;
      _Text = text;
      _CompletionList = completionList;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("completionList", _CompletionList));
    }
    //secondary constructor
    public RdEditableTextViewModel (
      [NotNull] string description,
      [NotNull] string initialText
    ) : this (
      description,
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<RefactoringCompletionList>(RefactoringCompletionList.Read, RefactoringCompletionList.Write),
      initialText
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdEditableTextViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var initialText = reader.ReadString();
      var description = reader.ReadString();
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var completionList = RdProperty<RefactoringCompletionList>.Read(ctx, reader, RefactoringCompletionList.Read, RefactoringCompletionList.Write);
      return new RdEditableTextViewModel(description, validationResult, text, completionList, initialText).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdEditableTextViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InitialText);
      writer.Write(value.Description);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<RefactoringCompletionList>.Write(ctx, writer, value._CompletionList);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEditableTextViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("completionList = "); _CompletionList.PrintEx(printer); printer.Println();
        printer.Print("initialText = "); InitialText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEnumValuesModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdProperty<bool> IsEnabled { get { return _IsEnabled; }}
    [NotNull] public IRdProperty<List<string>> Values { get { return _Values; }}
    [NotNull] public IRdProperty<string> SelectedValue { get { return _SelectedValue; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsEnabled;
    [NotNull] private readonly RdProperty<List<string>> _Values;
    [NotNull] private readonly RdProperty<string> _SelectedValue;
    
    //primary constructor
    private RdEnumValuesModel(
      [NotNull] string description,
      [NotNull] RdProperty<bool> isEnabled,
      [NotNull] RdProperty<List<string>> values,
      [NotNull] RdProperty<string> selectedValue
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (isEnabled == null) throw new ArgumentNullException("isEnabled");
      if (values == null) throw new ArgumentNullException("values");
      if (selectedValue == null) throw new ArgumentNullException("selectedValue");
      
      Description = description;
      _IsEnabled = isEnabled;
      _Values = values;
      _SelectedValue = selectedValue;
      _IsEnabled.OptimizeNested = true;
      _Values.OptimizeNested = true;
      _SelectedValue.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isEnabled", _IsEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("values", _Values));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedValue", _SelectedValue));
    }
    //secondary constructor
    public RdEnumValuesModel (
      [NotNull] string description
    ) : this (
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<List<string>>(ReadStringList, WriteStringList),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdEnumValuesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var isEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var values = RdProperty<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var selectedValue = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdEnumValuesModel(description, isEnabled, values, selectedValue).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<RdEnumValuesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._IsEnabled);
      RdProperty<List<string>>.Write(ctx, writer, value._Values);
      RdProperty<string>.Write(ctx, writer, value._SelectedValue);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEnumValuesModel (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("isEnabled = "); _IsEnabled.PrintEx(printer); printer.Println();
        printer.Print("values = "); _Values.PrintEx(printer); printer.Println();
        printer.Print("selectedValue = "); _SelectedValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExtractParentViewModel : RdMoveMembersViewModel
   {
    //fields
    //public fields
    [NotNull] public RdEditableTextViewModel ParentName {get; private set;}
    [NotNull] public IRdProperty<bool> PlaceBeside { get { return _PlaceBeside; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _PlaceBeside;
    
    //primary constructor
    private RdExtractParentViewModel(
      [NotNull] RdEditableTextViewModel parentName,
      [NotNull] RdProperty<bool> placeBeside,
      [NotNull] RdSelectionCollection members,
      [NotNull] RdProperty<string> secondColumnName,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      members,
      secondColumnName,
      selectPublic,
      selectDependent,
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (parentName == null) throw new ArgumentNullException("parentName");
      if (placeBeside == null) throw new ArgumentNullException("placeBeside");
      
      ParentName = parentName;
      _PlaceBeside = placeBeside;
      _PlaceBeside.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("parentName", ParentName));
      BindableChildren.Add(new KeyValuePair<string, object>("placeBeside", _PlaceBeside));
    }
    //secondary constructor
    public RdExtractParentViewModel (
      [NotNull] RdEditableTextViewModel parentName,
      [NotNull] RdSelectionCollection members,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      parentName,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      members,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      selectPublic,
      selectDependent,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdExtractParentViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var members = RdSelectionCollection.Read(ctx, reader);
      var secondColumnName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectPublic = RdSignalViewModel.Read(ctx, reader);
      var selectDependent = RdSignalViewModel.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var parentName = RdEditableTextViewModel.Read(ctx, reader);
      var placeBeside = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdExtractParentViewModel(parentName, placeBeside, members, secondColumnName, selectPublic, selectDependent, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdExtractParentViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSelectionCollection.Write(ctx, writer, value.Members);
      RdProperty<string>.Write(ctx, writer, value._SecondColumnName);
      RdSignalViewModel.Write(ctx, writer, value.SelectPublic);
      RdSignalViewModel.Write(ctx, writer, value.SelectDependent);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdEditableTextViewModel.Write(ctx, writer, value.ParentName);
      RdProperty<bool>.Write(ctx, writer, value._PlaceBeside);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdExtractParentViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("parentName = "); ParentName.PrintEx(printer); printer.Println();
        printer.Print("placeBeside = "); _PlaceBeside.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("secondColumnName = "); _SecondColumnName.PrintEx(printer); printer.Println();
        printer.Print("selectPublic = "); SelectPublic.PrintEx(printer); printer.Println();
        printer.Print("selectDependent = "); SelectDependent.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFixAccessRightsViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection ElementsToMakePublic {get; private set;}
    
    //private fields
    //primary constructor
    private RdFixAccessRightsViewModel(
      [NotNull] RdSelectionCollection elementsToMakePublic,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (elementsToMakePublic == null) throw new ArgumentNullException("elementsToMakePublic");
      
      ElementsToMakePublic = elementsToMakePublic;
      BindableChildren.Add(new KeyValuePair<string, object>("elementsToMakePublic", ElementsToMakePublic));
    }
    //secondary constructor
    public RdFixAccessRightsViewModel (
      [NotNull] RdSelectionCollection elementsToMakePublic,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      elementsToMakePublic,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdFixAccessRightsViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var elementsToMakePublic = RdSelectionCollection.Read(ctx, reader);
      return new RdFixAccessRightsViewModel(elementsToMakePublic, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdFixAccessRightsViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.ElementsToMakePublic);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdFixAccessRightsViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementsToMakePublic = "); ElementsToMakePublic.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdInlineParameterPresentation : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection Parameters {get; private set;}
    [NotNull] public IRdProperty<RdSelectionCollection> Suggestions { get { return _Suggestions; }}
    [NotNull] public RdSelectionCollection Usages {get; private set;}
    [NotNull] public RdCodePreviewPresentation Preview {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<RdSelectionCollection> _Suggestions;
    
    //primary constructor
    private RdInlineParameterPresentation(
      [NotNull] RdSelectionCollection parameters,
      [NotNull] RdProperty<RdSelectionCollection> suggestions,
      [NotNull] RdSelectionCollection usages,
      [NotNull] RdCodePreviewPresentation preview,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (parameters == null) throw new ArgumentNullException("parameters");
      if (suggestions == null) throw new ArgumentNullException("suggestions");
      if (usages == null) throw new ArgumentNullException("usages");
      if (preview == null) throw new ArgumentNullException("preview");
      
      Parameters = parameters;
      _Suggestions = suggestions;
      Usages = usages;
      Preview = preview;
      BindableChildren.Add(new KeyValuePair<string, object>("parameters", Parameters));
      BindableChildren.Add(new KeyValuePair<string, object>("suggestions", _Suggestions));
      BindableChildren.Add(new KeyValuePair<string, object>("usages", Usages));
      BindableChildren.Add(new KeyValuePair<string, object>("preview", Preview));
    }
    //secondary constructor
    public RdInlineParameterPresentation (
      [NotNull] RdSelectionCollection parameters,
      [NotNull] RdSelectionCollection usages,
      [NotNull] RdCodePreviewPresentation preview,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      parameters,
      new RdProperty<RdSelectionCollection>(RdSelectionCollection.Read, RdSelectionCollection.Write),
      usages,
      preview,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdInlineParameterPresentation> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var parameters = RdSelectionCollection.Read(ctx, reader);
      var suggestions = RdProperty<RdSelectionCollection>.Read(ctx, reader, RdSelectionCollection.Read, RdSelectionCollection.Write);
      var usages = RdSelectionCollection.Read(ctx, reader);
      var preview = RdCodePreviewPresentation.Read(ctx, reader);
      return new RdInlineParameterPresentation(parameters, suggestions, usages, preview, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdInlineParameterPresentation> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.Parameters);
      RdProperty<RdSelectionCollection>.Write(ctx, writer, value._Suggestions);
      RdSelectionCollection.Write(ctx, writer, value.Usages);
      RdCodePreviewPresentation.Write(ctx, writer, value.Preview);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdInlineParameterPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("parameters = "); Parameters.PrintEx(printer); printer.Println();
        printer.Print("suggestions = "); _Suggestions.PrintEx(printer); printer.Println();
        printer.Print("usages = "); Usages.PrintEx(printer); printer.Println();
        printer.Print("preview = "); Preview.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdIntroduceParameterViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> ParameterTypeName { get { return _ParameterTypeName; }}
    [NotNull] public IRdProperty<bool> MakeDefault { get { return _MakeDefault; }}
    public bool CanBeDefault {get; private set;}
    public bool HasLocals {get; private set;}
    public bool HasParametersToRemove {get; private set;}
    [NotNull] public RdEditableTextViewModel ParameterName {get; private set;}
    [NotNull] public RdSelectionCollection Locals {get; private set;}
    [NotNull] public RdSelectionCollection ParametersToRemove {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ParameterTypeName;
    [NotNull] private readonly RdProperty<bool> _MakeDefault;
    
    //primary constructor
    private RdIntroduceParameterViewModel(
      [NotNull] RdProperty<string> parameterTypeName,
      [NotNull] RdProperty<bool> makeDefault,
      bool canBeDefault,
      bool hasLocals,
      bool hasParametersToRemove,
      [NotNull] RdEditableTextViewModel parameterName,
      [NotNull] RdSelectionCollection locals,
      [NotNull] RdSelectionCollection parametersToRemove,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (parameterTypeName == null) throw new ArgumentNullException("parameterTypeName");
      if (makeDefault == null) throw new ArgumentNullException("makeDefault");
      if (parameterName == null) throw new ArgumentNullException("parameterName");
      if (locals == null) throw new ArgumentNullException("locals");
      if (parametersToRemove == null) throw new ArgumentNullException("parametersToRemove");
      
      _ParameterTypeName = parameterTypeName;
      _MakeDefault = makeDefault;
      CanBeDefault = canBeDefault;
      HasLocals = hasLocals;
      HasParametersToRemove = hasParametersToRemove;
      ParameterName = parameterName;
      Locals = locals;
      ParametersToRemove = parametersToRemove;
      _ParameterTypeName.OptimizeNested = true;
      _MakeDefault.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("parameterTypeName", _ParameterTypeName));
      BindableChildren.Add(new KeyValuePair<string, object>("makeDefault", _MakeDefault));
      BindableChildren.Add(new KeyValuePair<string, object>("parameterName", ParameterName));
      BindableChildren.Add(new KeyValuePair<string, object>("locals", Locals));
      BindableChildren.Add(new KeyValuePair<string, object>("parametersToRemove", ParametersToRemove));
    }
    //secondary constructor
    public RdIntroduceParameterViewModel (
      bool canBeDefault,
      bool hasLocals,
      bool hasParametersToRemove,
      [NotNull] RdEditableTextViewModel parameterName,
      [NotNull] RdSelectionCollection locals,
      [NotNull] RdSelectionCollection parametersToRemove,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      canBeDefault,
      hasLocals,
      hasParametersToRemove,
      parameterName,
      locals,
      parametersToRemove,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdIntroduceParameterViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var parameterTypeName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var makeDefault = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var canBeDefault = reader.ReadBool();
      var hasLocals = reader.ReadBool();
      var hasParametersToRemove = reader.ReadBool();
      var parameterName = RdEditableTextViewModel.Read(ctx, reader);
      var locals = RdSelectionCollection.Read(ctx, reader);
      var parametersToRemove = RdSelectionCollection.Read(ctx, reader);
      return new RdIntroduceParameterViewModel(parameterTypeName, makeDefault, canBeDefault, hasLocals, hasParametersToRemove, parameterName, locals, parametersToRemove, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdIntroduceParameterViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<string>.Write(ctx, writer, value._ParameterTypeName);
      RdProperty<bool>.Write(ctx, writer, value._MakeDefault);
      writer.Write(value.CanBeDefault);
      writer.Write(value.HasLocals);
      writer.Write(value.HasParametersToRemove);
      RdEditableTextViewModel.Write(ctx, writer, value.ParameterName);
      RdSelectionCollection.Write(ctx, writer, value.Locals);
      RdSelectionCollection.Write(ctx, writer, value.ParametersToRemove);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdIntroduceParameterViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("parameterTypeName = "); _ParameterTypeName.PrintEx(printer); printer.Println();
        printer.Print("makeDefault = "); _MakeDefault.PrintEx(printer); printer.Println();
        printer.Print("canBeDefault = "); CanBeDefault.PrintEx(printer); printer.Println();
        printer.Print("hasLocals = "); HasLocals.PrintEx(printer); printer.Println();
        printer.Print("hasParametersToRemove = "); HasParametersToRemove.PrintEx(printer); printer.Println();
        printer.Print("parameterName = "); ParameterName.PrintEx(printer); printer.Println();
        printer.Print("locals = "); Locals.PrintEx(printer); printer.Println();
        printer.Print("parametersToRemove = "); ParametersToRemove.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdInvertBooleanPresentation : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdEditableTextViewModel NewName {get; private set;}
    [NotNull] public RdCheckBoxViewModel InvertInner {get; private set;}
    [NotNull] public RdCheckBoxViewModel InvertOuter {get; private set;}
    
    //private fields
    //primary constructor
    private RdInvertBooleanPresentation(
      [NotNull] RdEditableTextViewModel newName,
      [NotNull] RdCheckBoxViewModel invertInner,
      [NotNull] RdCheckBoxViewModel invertOuter,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (newName == null) throw new ArgumentNullException("newName");
      if (invertInner == null) throw new ArgumentNullException("invertInner");
      if (invertOuter == null) throw new ArgumentNullException("invertOuter");
      
      NewName = newName;
      InvertInner = invertInner;
      InvertOuter = invertOuter;
      BindableChildren.Add(new KeyValuePair<string, object>("newName", NewName));
      BindableChildren.Add(new KeyValuePair<string, object>("invertInner", InvertInner));
      BindableChildren.Add(new KeyValuePair<string, object>("invertOuter", InvertOuter));
    }
    //secondary constructor
    public RdInvertBooleanPresentation (
      [NotNull] RdEditableTextViewModel newName,
      [NotNull] RdCheckBoxViewModel invertInner,
      [NotNull] RdCheckBoxViewModel invertOuter,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      newName,
      invertInner,
      invertOuter,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdInvertBooleanPresentation> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var newName = RdEditableTextViewModel.Read(ctx, reader);
      var invertInner = RdCheckBoxViewModel.Read(ctx, reader);
      var invertOuter = RdCheckBoxViewModel.Read(ctx, reader);
      return new RdInvertBooleanPresentation(newName, invertInner, invertOuter, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdInvertBooleanPresentation> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdEditableTextViewModel.Write(ctx, writer, value.NewName);
      RdCheckBoxViewModel.Write(ctx, writer, value.InvertInner);
      RdCheckBoxViewModel.Write(ctx, writer, value.InvertOuter);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdInvertBooleanPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("newName = "); NewName.PrintEx(printer); printer.Println();
        printer.Print("invertInner = "); InvertInner.PrintEx(printer); printer.Println();
        printer.Print("invertOuter = "); InvertOuter.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdListViewModelElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdTextViewModel Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public IRdProperty<string> AdditionalText { get { return _AdditionalText; }}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdSignal<RdVoid> Navigate { get { return _Navigate; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<string> _AdditionalText;
    [NotNull] protected readonly RdProperty<string> _Tooltip;
    [NotNull] protected readonly RdProperty<bool> _Included;
    [NotNull] protected readonly RdProperty<bool> _Enabled;
    [NotNull] protected readonly RdSignal<RdVoid> _Navigate;
    
    //primary constructor
    protected RdListViewModelElement(
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (additionalText == null) throw new ArgumentNullException("additionalText");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      if (included == null) throw new ArgumentNullException("included");
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (navigate == null) throw new ArgumentNullException("navigate");
      
      Text = text;
      Icon = icon;
      _AdditionalText = additionalText;
      _Tooltip = tooltip;
      _Included = included;
      _Enabled = enabled;
      _Navigate = navigate;
      _AdditionalText.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      _Included.OptimizeNested = true;
      _Enabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", Text));
      BindableChildren.Add(new KeyValuePair<string, object>("additionalText", _AdditionalText));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
      BindableChildren.Add(new KeyValuePair<string, object>("included", _Included));
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdListViewModelElement> Read = Polymorphic<RdListViewModelElement>.ReadAbstract(RdListViewModelElement_Unknown.Read);
    
    public static CtxWriteDelegate<RdListViewModelElement> Write = Polymorphic<RdListViewModelElement>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdListViewModelElement_Unknown : RdListViewModelElement
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private RdListViewModelElement_Unknown(
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
    }
    //secondary constructor
    public RdListViewModelElement_Unknown (
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdListViewModelElement_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdListViewModelElement_Unknown(text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdListViewModelElement_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdListViewModelElement_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdListViewModelElementWithChildren : RdListViewModelElement
   {
    //fields
    //public fields
    [NotNull] public List<RdListViewModelElement> Children {get; private set;}
    public bool IsRoot {get; private set;}
    
    //private fields
    //primary constructor
    private RdListViewModelElementWithChildren(
      [NotNull] List<RdListViewModelElement> children,
      bool isRoot,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
      if (children == null) throw new ArgumentNullException("children");
      
      Children = children;
      IsRoot = isRoot;
      BindableChildren.Add(new KeyValuePair<string, object>("children", Children));
    }
    //secondary constructor
    public RdListViewModelElementWithChildren (
      [NotNull] List<RdListViewModelElement> children,
      bool isRoot,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      children,
      isRoot,
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdListViewModelElementWithChildren> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var children = ReadRdListViewModelElementNullableList(ctx, reader);
      var isRoot = reader.ReadBool();
      return new RdListViewModelElementWithChildren(children, isRoot, text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<List<RdListViewModelElement>> ReadRdListViewModelElementNullableList = RdListViewModelElement.Read.NullableClass().List();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdListViewModelElementWithChildren> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
      WriteRdListViewModelElementNullableList(ctx, writer, value.Children);
      writer.Write(value.IsRoot);
    };
    public static CtxWriteDelegate<List<RdListViewModelElement>> WriteRdListViewModelElementNullableList = RdListViewModelElement.Write.NullableClass().List();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdListViewModelElementWithChildren (");
      using (printer.IndentCookie()) {
        printer.Print("children = "); Children.PrintEx(printer); printer.Println();
        printer.Print("isRoot = "); IsRoot.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveIntoFileViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdEditableTextViewModel FileName {get; private set;}
    [NotNull] public IRdProperty<bool> RemoveOld { get { return _RemoveOld; }}
    public bool CanRemove {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _RemoveOld;
    
    //primary constructor
    private RdMoveIntoFileViewModel(
      [NotNull] RdEditableTextViewModel fileName,
      [NotNull] RdProperty<bool> removeOld,
      bool canRemove,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (fileName == null) throw new ArgumentNullException("fileName");
      if (removeOld == null) throw new ArgumentNullException("removeOld");
      
      FileName = fileName;
      _RemoveOld = removeOld;
      CanRemove = canRemove;
      _RemoveOld.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("fileName", FileName));
      BindableChildren.Add(new KeyValuePair<string, object>("removeOld", _RemoveOld));
    }
    //secondary constructor
    public RdMoveIntoFileViewModel (
      [NotNull] RdEditableTextViewModel fileName,
      bool canRemove,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      fileName,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      canRemove,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveIntoFileViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var fileName = RdEditableTextViewModel.Read(ctx, reader);
      var removeOld = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var canRemove = reader.ReadBool();
      return new RdMoveIntoFileViewModel(fileName, removeOld, canRemove, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveIntoFileViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdEditableTextViewModel.Write(ctx, writer, value.FileName);
      RdProperty<bool>.Write(ctx, writer, value._RemoveOld);
      writer.Write(value.CanRemove);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveIntoFileViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("fileName = "); FileName.PrintEx(printer); printer.Println();
        printer.Print("removeOld = "); _RemoveOld.PrintEx(printer); printer.Println();
        printer.Print("canRemove = "); CanRemove.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdMoveMembersViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection Members {get; private set;}
    [NotNull] public IRdProperty<string> SecondColumnName { get { return _SecondColumnName; }}
    [NotNull] public RdSignalViewModel SelectPublic {get; private set;}
    [NotNull] public RdSignalViewModel SelectDependent {get; private set;}
    
    //private fields
    [NotNull] protected readonly RdProperty<string> _SecondColumnName;
    
    //primary constructor
    protected RdMoveMembersViewModel(
      [NotNull] RdSelectionCollection members,
      [NotNull] RdProperty<string> secondColumnName,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (members == null) throw new ArgumentNullException("members");
      if (secondColumnName == null) throw new ArgumentNullException("secondColumnName");
      if (selectPublic == null) throw new ArgumentNullException("selectPublic");
      if (selectDependent == null) throw new ArgumentNullException("selectDependent");
      
      Members = members;
      _SecondColumnName = secondColumnName;
      SelectPublic = selectPublic;
      SelectDependent = selectDependent;
      _SecondColumnName.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
      BindableChildren.Add(new KeyValuePair<string, object>("secondColumnName", _SecondColumnName));
      BindableChildren.Add(new KeyValuePair<string, object>("selectPublic", SelectPublic));
      BindableChildren.Add(new KeyValuePair<string, object>("selectDependent", SelectDependent));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdMoveMembersViewModel> Read = Polymorphic<RdMoveMembersViewModel>.ReadAbstract(RdMoveMembersViewModel_Unknown.Read);
    
    public static new CtxWriteDelegate<RdMoveMembersViewModel> Write = Polymorphic<RdMoveMembersViewModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdMoveMembersViewModel_Unknown : RdMoveMembersViewModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private RdMoveMembersViewModel_Unknown(
      [NotNull] RdSelectionCollection members,
      [NotNull] RdProperty<string> secondColumnName,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      members,
      secondColumnName,
      selectPublic,
      selectDependent,
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
    }
    //secondary constructor
    public RdMoveMembersViewModel_Unknown (
      [NotNull] RdSelectionCollection members,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      members,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      selectPublic,
      selectDependent,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveMembersViewModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var members = RdSelectionCollection.Read(ctx, reader);
      var secondColumnName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectPublic = RdSignalViewModel.Read(ctx, reader);
      var selectDependent = RdSignalViewModel.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      return new RdMoveMembersViewModel_Unknown(members, secondColumnName, selectPublic, selectDependent, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveMembersViewModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSelectionCollection.Write(ctx, writer, value.Members);
      RdProperty<string>.Write(ctx, writer, value._SecondColumnName);
      RdSignalViewModel.Write(ctx, writer, value.SelectPublic);
      RdSignalViewModel.Write(ctx, writer, value.SelectDependent);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveMembersViewModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("secondColumnName = "); _SecondColumnName.PrintEx(printer); printer.Println();
        printer.Print("selectPublic = "); SelectPublic.PrintEx(printer); printer.Println();
        printer.Print("selectDependent = "); SelectDependent.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveStaticViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string SourceName {get; private set;}
    [NotNull] public RdEditableTextViewModel TargetText {get; private set;}
    [NotNull] public RdSelectionCollection MembersInfo {get; private set;}
    
    //private fields
    //primary constructor
    private RdMoveStaticViewModel(
      [NotNull] string sourceName,
      [NotNull] RdEditableTextViewModel targetText,
      [NotNull] RdSelectionCollection membersInfo,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (sourceName == null) throw new ArgumentNullException("sourceName");
      if (targetText == null) throw new ArgumentNullException("targetText");
      if (membersInfo == null) throw new ArgumentNullException("membersInfo");
      
      SourceName = sourceName;
      TargetText = targetText;
      MembersInfo = membersInfo;
      BindableChildren.Add(new KeyValuePair<string, object>("targetText", TargetText));
      BindableChildren.Add(new KeyValuePair<string, object>("membersInfo", MembersInfo));
    }
    //secondary constructor
    public RdMoveStaticViewModel (
      [NotNull] string sourceName,
      [NotNull] RdEditableTextViewModel targetText,
      [NotNull] RdSelectionCollection membersInfo,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      sourceName,
      targetText,
      membersInfo,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveStaticViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var sourceName = reader.ReadString();
      var targetText = RdEditableTextViewModel.Read(ctx, reader);
      var membersInfo = RdSelectionCollection.Read(ctx, reader);
      return new RdMoveStaticViewModel(sourceName, targetText, membersInfo, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveStaticViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.SourceName);
      RdEditableTextViewModel.Write(ctx, writer, value.TargetText);
      RdSelectionCollection.Write(ctx, writer, value.MembersInfo);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveStaticViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("sourceName = "); SourceName.PrintEx(printer); printer.Println();
        printer.Print("targetText = "); TargetText.PrintEx(printer); printer.Println();
        printer.Print("membersInfo = "); MembersInfo.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveToFolderViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string SourceName {get; private set;}
    [NotNull] public RdEditableTextViewModel TargetName {get; private set;}
    [NotNull] public IRdProperty<bool> FixNamespaces { get { return _FixNamespaces; }}
    [NotNull] public IRdProperty<bool> ChangeVisibility { get { return _ChangeVisibility; }}
    [NotNull] public IRdProperty<bool> SearchInRelated { get { return _SearchInRelated; }}
    [NotNull] public IRdProperty<bool> PreserveHierarchy { get { return _PreserveHierarchy; }}
    [NotNull] public RdSelectionCollection Members {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _FixNamespaces;
    [NotNull] private readonly RdProperty<bool> _ChangeVisibility;
    [NotNull] private readonly RdProperty<bool> _SearchInRelated;
    [NotNull] private readonly RdProperty<bool> _PreserveHierarchy;
    
    //primary constructor
    private RdMoveToFolderViewModel(
      [NotNull] string sourceName,
      [NotNull] RdEditableTextViewModel targetName,
      [NotNull] RdProperty<bool> fixNamespaces,
      [NotNull] RdProperty<bool> changeVisibility,
      [NotNull] RdProperty<bool> searchInRelated,
      [NotNull] RdProperty<bool> preserveHierarchy,
      [NotNull] RdSelectionCollection members,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (sourceName == null) throw new ArgumentNullException("sourceName");
      if (targetName == null) throw new ArgumentNullException("targetName");
      if (fixNamespaces == null) throw new ArgumentNullException("fixNamespaces");
      if (changeVisibility == null) throw new ArgumentNullException("changeVisibility");
      if (searchInRelated == null) throw new ArgumentNullException("searchInRelated");
      if (preserveHierarchy == null) throw new ArgumentNullException("preserveHierarchy");
      if (members == null) throw new ArgumentNullException("members");
      
      SourceName = sourceName;
      TargetName = targetName;
      _FixNamespaces = fixNamespaces;
      _ChangeVisibility = changeVisibility;
      _SearchInRelated = searchInRelated;
      _PreserveHierarchy = preserveHierarchy;
      Members = members;
      _FixNamespaces.OptimizeNested = true;
      _ChangeVisibility.OptimizeNested = true;
      _SearchInRelated.OptimizeNested = true;
      _PreserveHierarchy.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("targetName", TargetName));
      BindableChildren.Add(new KeyValuePair<string, object>("fixNamespaces", _FixNamespaces));
      BindableChildren.Add(new KeyValuePair<string, object>("changeVisibility", _ChangeVisibility));
      BindableChildren.Add(new KeyValuePair<string, object>("searchInRelated", _SearchInRelated));
      BindableChildren.Add(new KeyValuePair<string, object>("preserveHierarchy", _PreserveHierarchy));
      BindableChildren.Add(new KeyValuePair<string, object>("members", Members));
    }
    //secondary constructor
    public RdMoveToFolderViewModel (
      [NotNull] string sourceName,
      [NotNull] RdEditableTextViewModel targetName,
      [NotNull] RdSelectionCollection members,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      sourceName,
      targetName,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      members,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveToFolderViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var sourceName = reader.ReadString();
      var targetName = RdEditableTextViewModel.Read(ctx, reader);
      var fixNamespaces = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var changeVisibility = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var searchInRelated = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var preserveHierarchy = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var members = RdSelectionCollection.Read(ctx, reader);
      return new RdMoveToFolderViewModel(sourceName, targetName, fixNamespaces, changeVisibility, searchInRelated, preserveHierarchy, members, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveToFolderViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.SourceName);
      RdEditableTextViewModel.Write(ctx, writer, value.TargetName);
      RdProperty<bool>.Write(ctx, writer, value._FixNamespaces);
      RdProperty<bool>.Write(ctx, writer, value._ChangeVisibility);
      RdProperty<bool>.Write(ctx, writer, value._SearchInRelated);
      RdProperty<bool>.Write(ctx, writer, value._PreserveHierarchy);
      RdSelectionCollection.Write(ctx, writer, value.Members);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveToFolderViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("sourceName = "); SourceName.PrintEx(printer); printer.Println();
        printer.Print("targetName = "); TargetName.PrintEx(printer); printer.Println();
        printer.Print("fixNamespaces = "); _FixNamespaces.PrintEx(printer); printer.Println();
        printer.Print("changeVisibility = "); _ChangeVisibility.PrintEx(printer); printer.Println();
        printer.Print("searchInRelated = "); _SearchInRelated.PrintEx(printer); printer.Println();
        printer.Print("preserveHierarchy = "); _PreserveHierarchy.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveToNamespaceViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdEditableTextViewModel TargetNamespaceName {get; private set;}
    
    //private fields
    //primary constructor
    private RdMoveToNamespaceViewModel(
      [NotNull] RdEditableTextViewModel targetNamespaceName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (targetNamespaceName == null) throw new ArgumentNullException("targetNamespaceName");
      
      TargetNamespaceName = targetNamespaceName;
      BindableChildren.Add(new KeyValuePair<string, object>("targetNamespaceName", TargetNamespaceName));
    }
    //secondary constructor
    public RdMoveToNamespaceViewModel (
      [NotNull] RdEditableTextViewModel targetNamespaceName,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      targetNamespaceName,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveToNamespaceViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var targetNamespaceName = RdEditableTextViewModel.Read(ctx, reader);
      return new RdMoveToNamespaceViewModel(targetNamespaceName, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveToNamespaceViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdEditableTextViewModel.Write(ctx, writer, value.TargetNamespaceName);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveToNamespaceViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("targetNamespaceName = "); TargetNamespaceName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveTypeToOuterViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> SearchInComments { get { return _SearchInComments; }}
    [NotNull] public RdEditableTextViewModel NewName {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _SearchInComments;
    
    //primary constructor
    private RdMoveTypeToOuterViewModel(
      [NotNull] RdProperty<bool> searchInComments,
      [NotNull] RdEditableTextViewModel newName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (searchInComments == null) throw new ArgumentNullException("searchInComments");
      if (newName == null) throw new ArgumentNullException("newName");
      
      _SearchInComments = searchInComments;
      NewName = newName;
      _SearchInComments.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("searchInComments", _SearchInComments));
      BindableChildren.Add(new KeyValuePair<string, object>("newName", NewName));
    }
    //secondary constructor
    public RdMoveTypeToOuterViewModel (
      [NotNull] RdEditableTextViewModel newName,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      newName,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveTypeToOuterViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var searchInComments = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var newName = RdEditableTextViewModel.Read(ctx, reader);
      return new RdMoveTypeToOuterViewModel(searchInComments, newName, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveTypeToOuterViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._SearchInComments);
      RdEditableTextViewModel.Write(ctx, writer, value.NewName);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveTypeToOuterViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("searchInComments = "); _SearchInComments.PrintEx(printer); printer.Println();
        printer.Print("newName = "); NewName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdMoveUpDownViewModel : RdMoveMembersViewModel
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection ElementsToMoveIn {get; private set;}
    
    //private fields
    //primary constructor
    private RdMoveUpDownViewModel(
      [NotNull] RdSelectionCollection elementsToMoveIn,
      [NotNull] RdSelectionCollection members,
      [NotNull] RdProperty<string> secondColumnName,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      members,
      secondColumnName,
      selectPublic,
      selectDependent,
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (elementsToMoveIn == null) throw new ArgumentNullException("elementsToMoveIn");
      
      ElementsToMoveIn = elementsToMoveIn;
      BindableChildren.Add(new KeyValuePair<string, object>("elementsToMoveIn", ElementsToMoveIn));
    }
    //secondary constructor
    public RdMoveUpDownViewModel (
      [NotNull] RdSelectionCollection elementsToMoveIn,
      [NotNull] RdSelectionCollection members,
      [NotNull] RdSignalViewModel selectPublic,
      [NotNull] RdSignalViewModel selectDependent,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      elementsToMoveIn,
      members,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      selectPublic,
      selectDependent,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMoveUpDownViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var members = RdSelectionCollection.Read(ctx, reader);
      var secondColumnName = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectPublic = RdSignalViewModel.Read(ctx, reader);
      var selectDependent = RdSignalViewModel.Read(ctx, reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var elementsToMoveIn = RdSelectionCollection.Read(ctx, reader);
      return new RdMoveUpDownViewModel(elementsToMoveIn, members, secondColumnName, selectPublic, selectDependent, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMoveUpDownViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSelectionCollection.Write(ctx, writer, value.Members);
      RdProperty<string>.Write(ctx, writer, value._SecondColumnName);
      RdSignalViewModel.Write(ctx, writer, value.SelectPublic);
      RdSignalViewModel.Write(ctx, writer, value.SelectDependent);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.ElementsToMoveIn);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMoveUpDownViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementsToMoveIn = "); ElementsToMoveIn.PrintEx(printer); printer.Println();
        printer.Print("members = "); Members.PrintEx(printer); printer.Println();
        printer.Print("secondColumnName = "); _SecondColumnName.PrintEx(printer); printer.Println();
        printer.Print("selectPublic = "); SelectPublic.PrintEx(printer); printer.Println();
        printer.Print("selectDependent = "); SelectDependent.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdParameterElement : RdListViewModelElement
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsOut { get { return _IsOut; }}
    [NotNull] public IRdProperty<bool> IsRef { get { return _IsRef; }}
    [NotNull] public IRdProperty<int> Index { get { return _Index; }}
    [CanBeNull] public RdPreviewElement PreviewElement {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsOut;
    [NotNull] private readonly RdProperty<bool> _IsRef;
    [NotNull] private readonly RdProperty<int> _Index;
    
    //primary constructor
    private RdParameterElement(
      [NotNull] RdProperty<bool> isOut,
      [NotNull] RdProperty<bool> isRef,
      [NotNull] RdProperty<int> index,
      [CanBeNull] RdPreviewElement previewElement,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
      if (isOut == null) throw new ArgumentNullException("isOut");
      if (isRef == null) throw new ArgumentNullException("isRef");
      if (index == null) throw new ArgumentNullException("index");
      
      _IsOut = isOut;
      _IsRef = isRef;
      _Index = index;
      PreviewElement = previewElement;
      _IsOut.OptimizeNested = true;
      _IsRef.OptimizeNested = true;
      _Index.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isOut", _IsOut));
      BindableChildren.Add(new KeyValuePair<string, object>("isRef", _IsRef));
      BindableChildren.Add(new KeyValuePair<string, object>("index", _Index));
      BindableChildren.Add(new KeyValuePair<string, object>("previewElement", PreviewElement));
    }
    //secondary constructor
    public RdParameterElement (
      [CanBeNull] RdPreviewElement previewElement,
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      previewElement,
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdParameterElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var isOut = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isRef = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var index = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var previewElement = ReadRdPreviewElementNullable(ctx, reader);
      return new RdParameterElement(isOut, isRef, index, previewElement, text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<RdPreviewElement> ReadRdPreviewElementNullable = RdPreviewElement.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdParameterElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
      RdProperty<bool>.Write(ctx, writer, value._IsOut);
      RdProperty<bool>.Write(ctx, writer, value._IsRef);
      RdProperty<int>.Write(ctx, writer, value._Index);
      WriteRdPreviewElementNullable(ctx, writer, value.PreviewElement);
    };
    public static CtxWriteDelegate<RdPreviewElement> WriteRdPreviewElementNullable = RdPreviewElement.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdParameterElement (");
      using (printer.IndentCookie()) {
        printer.Print("isOut = "); _IsOut.PrintEx(printer); printer.Println();
        printer.Print("isRef = "); _IsRef.PrintEx(printer); printer.Println();
        printer.Print("index = "); _Index.PrintEx(printer); printer.Println();
        printer.Print("previewElement = "); PreviewElement.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPreviewElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Included { get { return _Included; }}
    [NotNull] public IRdProperty<string> Preview { get { return _Preview; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Included;
    [NotNull] private readonly RdProperty<string> _Preview;
    
    //primary constructor
    private RdPreviewElement(
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<string> preview
    )
    {
      if (included == null) throw new ArgumentNullException("included");
      if (preview == null) throw new ArgumentNullException("preview");
      
      _Included = included;
      _Preview = preview;
      _Included.OptimizeNested = true;
      _Preview.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("included", _Included));
      BindableChildren.Add(new KeyValuePair<string, object>("preview", _Preview));
    }
    //secondary constructor
    public RdPreviewElement (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdPreviewElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var preview = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdPreviewElement(included, preview).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdPreviewElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<string>.Write(ctx, writer, value._Preview);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPreviewElement (");
      using (printer.IndentCookie()) {
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("preview = "); _Preview.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdPropertyToRadioViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public string PropertySelectedText {get; private set;}
    [NotNull] public string PropertyNotSelectedText {get; private set;}
    [NotNull] public IRdProperty<bool> Property { get { return _Property; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Property;
    
    //primary constructor
    private RdPropertyToRadioViewModel(
      [NotNull] string description,
      [NotNull] string propertySelectedText,
      [NotNull] string propertyNotSelectedText,
      [NotNull] RdProperty<bool> property
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (propertySelectedText == null) throw new ArgumentNullException("propertySelectedText");
      if (propertyNotSelectedText == null) throw new ArgumentNullException("propertyNotSelectedText");
      if (property == null) throw new ArgumentNullException("property");
      
      Description = description;
      PropertySelectedText = propertySelectedText;
      PropertyNotSelectedText = propertyNotSelectedText;
      _Property = property;
      _Property.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
    }
    //secondary constructor
    public RdPropertyToRadioViewModel (
      [NotNull] string description,
      [NotNull] string propertySelectedText,
      [NotNull] string propertyNotSelectedText
    ) : this (
      description,
      propertySelectedText,
      propertyNotSelectedText,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdPropertyToRadioViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var propertySelectedText = reader.ReadString();
      var propertyNotSelectedText = reader.ReadString();
      var property = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdPropertyToRadioViewModel(description, propertySelectedText, propertyNotSelectedText, property).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdPropertyToRadioViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      writer.Write(value.PropertySelectedText);
      writer.Write(value.PropertyNotSelectedText);
      RdProperty<bool>.Write(ctx, writer, value._Property);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdPropertyToRadioViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("propertySelectedText = "); PropertySelectedText.PrintEx(printer); printer.Println();
        printer.Print("propertyNotSelectedText = "); PropertyNotSelectedText.PrintEx(printer); printer.Println();
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdReadOnlyTextViewModel : RdTextViewModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public RdReadOnlyTextViewModel(
      [NotNull] string initialText
    ) : base (
      initialText
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdReadOnlyTextViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var initialText = reader.ReadString();
      return new RdReadOnlyTextViewModel(initialText).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdReadOnlyTextViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InitialText);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdReadOnlyTextViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("initialText = "); InitialText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRefactoringsViewModelElement : RdListViewModelElement
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private RdRefactoringsViewModelElement(
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<string> additionalText,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> included,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdSignal<RdVoid> navigate
    ) : base (
      text,
      icon,
      additionalText,
      tooltip,
      included,
      enabled,
      navigate
     ) 
    {
    }
    //secondary constructor
    public RdRefactoringsViewModelElement (
      [NotNull] RdTextViewModel text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      text,
      icon,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdRefactoringsViewModelElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = RdTextViewModel.Read(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var additionalText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var included = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var navigate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdRefactoringsViewModelElement(text, icon, additionalText, tooltip, included, enabled, navigate).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static new CtxWriteDelegate<RdRefactoringsViewModelElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdTextViewModel.Write(ctx, writer, value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
      RdProperty<string>.Write(ctx, writer, value._AdditionalText);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<bool>.Write(ctx, writer, value._Included);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdSignal<RdVoid>.Write(ctx, writer, value._Navigate);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRefactoringsViewModelElement (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("additionalText = "); _AdditionalText.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("included = "); _Included.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRenameFileViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> RenameType { get { return _RenameType; }}
    [NotNull] public RdEditableTextViewModel NewName {get; private set;}
    public bool SuggestRenameType {get; private set;}
    public bool AllowChangeExtension {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _RenameType;
    
    //primary constructor
    private RdRenameFileViewModel(
      [NotNull] RdProperty<bool> renameType,
      [NotNull] RdEditableTextViewModel newName,
      bool suggestRenameType,
      bool allowChangeExtension,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (renameType == null) throw new ArgumentNullException("renameType");
      if (newName == null) throw new ArgumentNullException("newName");
      
      _RenameType = renameType;
      NewName = newName;
      SuggestRenameType = suggestRenameType;
      AllowChangeExtension = allowChangeExtension;
      _RenameType.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("renameType", _RenameType));
      BindableChildren.Add(new KeyValuePair<string, object>("newName", NewName));
    }
    //secondary constructor
    public RdRenameFileViewModel (
      [NotNull] RdEditableTextViewModel newName,
      bool suggestRenameType,
      bool allowChangeExtension,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      newName,
      suggestRenameType,
      allowChangeExtension,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdRenameFileViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var renameType = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var newName = RdEditableTextViewModel.Read(ctx, reader);
      var suggestRenameType = reader.ReadBool();
      var allowChangeExtension = reader.ReadBool();
      return new RdRenameFileViewModel(renameType, newName, suggestRenameType, allowChangeExtension, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdRenameFileViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._RenameType);
      RdEditableTextViewModel.Write(ctx, writer, value.NewName);
      writer.Write(value.SuggestRenameType);
      writer.Write(value.AllowChangeExtension);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRenameFileViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("renameType = "); _RenameType.PrintEx(printer); printer.Println();
        printer.Print("newName = "); NewName.PrintEx(printer); printer.Println();
        printer.Print("suggestRenameType = "); SuggestRenameType.PrintEx(printer); printer.Println();
        printer.Print("allowChangeExtension = "); AllowChangeExtension.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdRenameNamespaceViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdEditableTextViewModel NamespaceName {get; private set;}
    
    //private fields
    //primary constructor
    private RdRenameNamespaceViewModel(
      [NotNull] RdEditableTextViewModel namespaceName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (namespaceName == null) throw new ArgumentNullException("namespaceName");
      
      NamespaceName = namespaceName;
      BindableChildren.Add(new KeyValuePair<string, object>("namespaceName", NamespaceName));
    }
    //secondary constructor
    public RdRenameNamespaceViewModel (
      [NotNull] RdEditableTextViewModel namespaceName,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      namespaceName,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdRenameNamespaceViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var namespaceName = RdEditableTextViewModel.Read(ctx, reader);
      return new RdRenameNamespaceViewModel(namespaceName, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdRenameNamespaceViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdEditableTextViewModel.Write(ctx, writer, value.NamespaceName);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdRenameNamespaceViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("namespaceName = "); NamespaceName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSafeDeleteFolderViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection ElementsToBeDeleted {get; private set;}
    
    //private fields
    //primary constructor
    private RdSafeDeleteFolderViewModel(
      [NotNull] RdSelectionCollection elementsToBeDeleted,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (elementsToBeDeleted == null) throw new ArgumentNullException("elementsToBeDeleted");
      
      ElementsToBeDeleted = elementsToBeDeleted;
      BindableChildren.Add(new KeyValuePair<string, object>("elementsToBeDeleted", ElementsToBeDeleted));
    }
    //secondary constructor
    public RdSafeDeleteFolderViewModel (
      [NotNull] RdSelectionCollection elementsToBeDeleted,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      elementsToBeDeleted,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdSafeDeleteFolderViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var elementsToBeDeleted = RdSelectionCollection.Read(ctx, reader);
      return new RdSafeDeleteFolderViewModel(elementsToBeDeleted, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdSafeDeleteFolderViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.ElementsToBeDeleted);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdSafeDeleteFolderViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementsToBeDeleted = "); ElementsToBeDeleted.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSelectionCollection : RdBindableBase, JetBrains.Application.UI.UIAutomation.IAutomation {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public List<RdListViewModelElement> ModelElements {get; private set;}
    public bool IsChecked {get; private set;}
    public bool HasChildren {get; private set;}
    
    //private fields
    //primary constructor
    public RdSelectionCollection(
      [NotNull] string description,
      [NotNull] List<RdListViewModelElement> modelElements,
      bool isChecked,
      bool hasChildren
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (modelElements == null) throw new ArgumentNullException("modelElements");
      
      Description = description;
      ModelElements = modelElements;
      IsChecked = isChecked;
      HasChildren = hasChildren;
      BindableChildren.Add(new KeyValuePair<string, object>("modelElements", ModelElements));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSelectionCollection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var modelElements = ReadRdListViewModelElementList(ctx, reader);
      var isChecked = reader.ReadBool();
      var hasChildren = reader.ReadBool();
      return new RdSelectionCollection(description, modelElements, isChecked, hasChildren).WithId(_id);
    };
    public static CtxReadDelegate<List<RdListViewModelElement>> ReadRdListViewModelElementList = RdListViewModelElement.Read.List();
    
    public static CtxWriteDelegate<RdSelectionCollection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      WriteRdListViewModelElementList(ctx, writer, value.ModelElements);
      writer.Write(value.IsChecked);
      writer.Write(value.HasChildren);
    };
    public static CtxWriteDelegate<List<RdListViewModelElement>> WriteRdListViewModelElementList = RdListViewModelElement.Write.List();
    //custom body
    public event System.ComponentModel.PropertyChangedEventHandler PropertyChanged;
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdSelectionCollection (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("modelElements = "); ModelElements.PrintEx(printer); printer.Println();
        printer.Print("isChecked = "); IsChecked.PrintEx(printer); printer.Println();
        printer.Print("hasChildren = "); HasChildren.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdSignalViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Description {get; private set;}
    [NotNull] public IRdSignal<RdVoid> Click { get { return _Click; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Click;
    
    //primary constructor
    private RdSignalViewModel(
      [NotNull] string description,
      [NotNull] RdSignal<RdVoid> click
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      if (click == null) throw new ArgumentNullException("click");
      
      Description = description;
      _Click = click;
      BindableChildren.Add(new KeyValuePair<string, object>("click", _Click));
    }
    //secondary constructor
    public RdSignalViewModel (
      [NotNull] string description
    ) : this (
      description,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdSignalViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = reader.ReadString();
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdSignalViewModel(description, click).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdSignalViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Description);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdSignalViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdTextViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string InitialText {get; private set;}
    
    //private fields
    //primary constructor
    protected RdTextViewModel(
      [NotNull] string initialText
    )
    {
      if (initialText == null) throw new ArgumentNullException("initialText");
      
      InitialText = initialText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTextViewModel> Read = Polymorphic<RdTextViewModel>.ReadAbstract(RdTextViewModel_Unknown.Read);
    
    public static CtxWriteDelegate<RdTextViewModel> Write = Polymorphic<RdTextViewModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdTextViewModel_Unknown : RdTextViewModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public RdTextViewModel_Unknown(
      [NotNull] string initialText
    ) : base (
      initialText
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTextViewModel_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var initialText = reader.ReadString();
      return new RdTextViewModel_Unknown(initialText).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdTextViewModel_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InitialText);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextViewModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("initialText = "); InitialText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTextViewModelWithCustomText : RdTextViewModel
   {
    //fields
    //public fields
    [NotNull] public List<RdSignalViewModel> CustomText {get; private set;}
    
    //private fields
    //primary constructor
    public RdTextViewModelWithCustomText(
      [NotNull] List<RdSignalViewModel> customText,
      [NotNull] string initialText
    ) : base (
      initialText
     ) 
    {
      if (customText == null) throw new ArgumentNullException("customText");
      
      CustomText = customText;
      BindableChildren.Add(new KeyValuePair<string, object>("customText", CustomText));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdTextViewModelWithCustomText> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var initialText = reader.ReadString();
      var customText = ReadRdSignalViewModelList(ctx, reader);
      return new RdTextViewModelWithCustomText(customText, initialText).WithId(_id);
    };
    public static CtxReadDelegate<List<RdSignalViewModel>> ReadRdSignalViewModelList = RdSignalViewModel.Read.List();
    
    public static new CtxWriteDelegate<RdTextViewModelWithCustomText> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.InitialText);
      WriteRdSignalViewModelList(ctx, writer, value.CustomText);
    };
    public static CtxWriteDelegate<List<RdSignalViewModel>> WriteRdSignalViewModelList = RdSignalViewModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextViewModelWithCustomText (");
      using (printer.IndentCookie()) {
        printer.Print("customText = "); CustomText.PrintEx(printer); printer.Println();
        printer.Print("initialText = "); InitialText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTransformParametersPresentation : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdSelectionCollection Parameters {get; private set;}
    [NotNull] public RdEditableTextViewModel InClassName {get; private set;}
    [NotNull] public IRdProperty<bool> InEnabled { get { return _InEnabled; }}
    [NotNull] public RdEnumValuesModel InCombo {get; private set;}
    [NotNull] public RdEditableTextViewModel OutClassName {get; private set;}
    [NotNull] public RdEnumValuesModel OutCombo {get; private set;}
    [NotNull] public IRdProperty<bool> OutEnabled { get { return _OutEnabled; }}
    [NotNull] public RdCheckBoxViewModel AppendToTuple {get; private set;}
    [NotNull] public RdCodePreviewPresentation Preview {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _InEnabled;
    [NotNull] private readonly RdProperty<bool> _OutEnabled;
    
    //primary constructor
    private RdTransformParametersPresentation(
      [NotNull] RdSelectionCollection parameters,
      [NotNull] RdEditableTextViewModel inClassName,
      [NotNull] RdProperty<bool> inEnabled,
      [NotNull] RdEnumValuesModel inCombo,
      [NotNull] RdEditableTextViewModel outClassName,
      [NotNull] RdEnumValuesModel outCombo,
      [NotNull] RdProperty<bool> outEnabled,
      [NotNull] RdCheckBoxViewModel appendToTuple,
      [NotNull] RdCodePreviewPresentation preview,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (parameters == null) throw new ArgumentNullException("parameters");
      if (inClassName == null) throw new ArgumentNullException("inClassName");
      if (inEnabled == null) throw new ArgumentNullException("inEnabled");
      if (inCombo == null) throw new ArgumentNullException("inCombo");
      if (outClassName == null) throw new ArgumentNullException("outClassName");
      if (outCombo == null) throw new ArgumentNullException("outCombo");
      if (outEnabled == null) throw new ArgumentNullException("outEnabled");
      if (appendToTuple == null) throw new ArgumentNullException("appendToTuple");
      if (preview == null) throw new ArgumentNullException("preview");
      
      Parameters = parameters;
      InClassName = inClassName;
      _InEnabled = inEnabled;
      InCombo = inCombo;
      OutClassName = outClassName;
      OutCombo = outCombo;
      _OutEnabled = outEnabled;
      AppendToTuple = appendToTuple;
      Preview = preview;
      _InEnabled.OptimizeNested = true;
      _OutEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("parameters", Parameters));
      BindableChildren.Add(new KeyValuePair<string, object>("inClassName", InClassName));
      BindableChildren.Add(new KeyValuePair<string, object>("inEnabled", _InEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("inCombo", InCombo));
      BindableChildren.Add(new KeyValuePair<string, object>("outClassName", OutClassName));
      BindableChildren.Add(new KeyValuePair<string, object>("outCombo", OutCombo));
      BindableChildren.Add(new KeyValuePair<string, object>("outEnabled", _OutEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("appendToTuple", AppendToTuple));
      BindableChildren.Add(new KeyValuePair<string, object>("preview", Preview));
    }
    //secondary constructor
    public RdTransformParametersPresentation (
      [NotNull] RdSelectionCollection parameters,
      [NotNull] RdEditableTextViewModel inClassName,
      [NotNull] RdEnumValuesModel inCombo,
      [NotNull] RdEditableTextViewModel outClassName,
      [NotNull] RdEnumValuesModel outCombo,
      [NotNull] RdCheckBoxViewModel appendToTuple,
      [NotNull] RdCodePreviewPresentation preview,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      parameters,
      inClassName,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      inCombo,
      outClassName,
      outCombo,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      appendToTuple,
      preview,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdTransformParametersPresentation> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var parameters = RdSelectionCollection.Read(ctx, reader);
      var inClassName = RdEditableTextViewModel.Read(ctx, reader);
      var inEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var inCombo = RdEnumValuesModel.Read(ctx, reader);
      var outClassName = RdEditableTextViewModel.Read(ctx, reader);
      var outCombo = RdEnumValuesModel.Read(ctx, reader);
      var outEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var appendToTuple = RdCheckBoxViewModel.Read(ctx, reader);
      var preview = RdCodePreviewPresentation.Read(ctx, reader);
      return new RdTransformParametersPresentation(parameters, inClassName, inEnabled, inCombo, outClassName, outCombo, outEnabled, appendToTuple, preview, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdTransformParametersPresentation> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdSelectionCollection.Write(ctx, writer, value.Parameters);
      RdEditableTextViewModel.Write(ctx, writer, value.InClassName);
      RdProperty<bool>.Write(ctx, writer, value._InEnabled);
      RdEnumValuesModel.Write(ctx, writer, value.InCombo);
      RdEditableTextViewModel.Write(ctx, writer, value.OutClassName);
      RdEnumValuesModel.Write(ctx, writer, value.OutCombo);
      RdProperty<bool>.Write(ctx, writer, value._OutEnabled);
      RdCheckBoxViewModel.Write(ctx, writer, value.AppendToTuple);
      RdCodePreviewPresentation.Write(ctx, writer, value.Preview);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTransformParametersPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("parameters = "); Parameters.PrintEx(printer); printer.Println();
        printer.Print("inClassName = "); InClassName.PrintEx(printer); printer.Println();
        printer.Print("inEnabled = "); _InEnabled.PrintEx(printer); printer.Println();
        printer.Print("inCombo = "); InCombo.PrintEx(printer); printer.Println();
        printer.Print("outClassName = "); OutClassName.PrintEx(printer); printer.Println();
        printer.Print("outCombo = "); OutCombo.PrintEx(printer); printer.Println();
        printer.Print("outEnabled = "); _OutEnabled.PrintEx(printer); printer.Println();
        printer.Print("appendToTuple = "); AppendToTuple.PrintEx(printer); printer.Println();
        printer.Print("preview = "); Preview.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUseBaseTypeViewModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> ChangeTypeOf { get { return _ChangeTypeOf; }}
    [NotNull] public IRdProperty<bool> ChangeIs { get { return _ChangeIs; }}
    [NotNull] public RdSelectionCollection BaseTypes {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _ChangeTypeOf;
    [NotNull] private readonly RdProperty<bool> _ChangeIs;
    
    //primary constructor
    private RdUseBaseTypeViewModel(
      [NotNull] RdProperty<bool> changeTypeOf,
      [NotNull] RdProperty<bool> changeIs,
      [NotNull] RdSelectionCollection baseTypes,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (changeTypeOf == null) throw new ArgumentNullException("changeTypeOf");
      if (changeIs == null) throw new ArgumentNullException("changeIs");
      if (baseTypes == null) throw new ArgumentNullException("baseTypes");
      
      _ChangeTypeOf = changeTypeOf;
      _ChangeIs = changeIs;
      BaseTypes = baseTypes;
      _ChangeTypeOf.OptimizeNested = true;
      _ChangeIs.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("changeTypeOf", _ChangeTypeOf));
      BindableChildren.Add(new KeyValuePair<string, object>("changeIs", _ChangeIs));
      BindableChildren.Add(new KeyValuePair<string, object>("baseTypes", BaseTypes));
    }
    //secondary constructor
    public RdUseBaseTypeViewModel (
      [NotNull] RdSelectionCollection baseTypes,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      baseTypes,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdUseBaseTypeViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var changeTypeOf = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var changeIs = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var baseTypes = RdSelectionCollection.Read(ctx, reader);
      return new RdUseBaseTypeViewModel(changeTypeOf, changeIs, baseTypes, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdUseBaseTypeViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._ChangeTypeOf);
      RdProperty<bool>.Write(ctx, writer, value._ChangeIs);
      RdSelectionCollection.Write(ctx, writer, value.BaseTypes);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUseBaseTypeViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("changeTypeOf = "); _ChangeTypeOf.PrintEx(printer); printer.Println();
        printer.Print("changeIs = "); _ChangeIs.PrintEx(printer); printer.Println();
        printer.Print("baseTypes = "); BaseTypes.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringCompletionItem : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Label {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public string TranslatedText {get; private set;}
    
    //private fields
    //primary constructor
    public RefactoringCompletionItem(
      [NotNull] string label,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] string translatedText
    )
    {
      if (label == null) throw new ArgumentNullException("label");
      if (translatedText == null) throw new ArgumentNullException("translatedText");
      
      Label = label;
      Icon = icon;
      TranslatedText = translatedText;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RefactoringCompletionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var label = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var translatedText = reader.ReadString();
      return new RefactoringCompletionItem(label, icon, translatedText).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RefactoringCompletionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Label);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.TranslatedText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringCompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("translatedText = "); TranslatedText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringCompletionList : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<RefactoringCompletionItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RefactoringCompletionList(
      [NotNull] List<RefactoringCompletionItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RefactoringCompletionList> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadRefactoringCompletionItemList(ctx, reader);
      return new RefactoringCompletionList(items).WithId(_id);
    };
    public static CtxReadDelegate<List<RefactoringCompletionItem>> ReadRefactoringCompletionItemList = RefactoringCompletionItem.Read.List();
    
    public static CtxWriteDelegate<RefactoringCompletionList> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRefactoringCompletionItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RefactoringCompletionItem>> WriteRefactoringCompletionItemList = RefactoringCompletionItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringCompletionList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringInteraction : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> WizardForm { get { return _WizardForm; }}
    [NotNull] public string Title {get; private set;}
    [NotNull] public IRdSignal<MessageBoxOK> Message { get { return _Message; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> _WizardForm;
    [NotNull] private readonly RdSignal<MessageBoxOK> _Message;
    
    //primary constructor
    private RefactoringInteraction(
      [NotNull] RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm> wizardForm,
      [NotNull] string title,
      [NotNull] RdSignal<MessageBoxOK> message
    )
    {
      if (wizardForm == null) throw new ArgumentNullException("wizardForm");
      if (title == null) throw new ArgumentNullException("title");
      if (message == null) throw new ArgumentNullException("message");
      
      _WizardForm = wizardForm;
      Title = title;
      _Message = message;
      BindableChildren.Add(new KeyValuePair<string, object>("wizardForm", _WizardForm));
      BindableChildren.Add(new KeyValuePair<string, object>("message", _Message));
    }
    //secondary constructor
    public RefactoringInteraction (
      [NotNull] string title
    ) : this (
      new RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>(JetBrains.Rider.Model.Refactorings.WizardForm.Read, JetBrains.Rider.Model.Refactorings.WizardForm.Write),
      title,
      new RdSignal<MessageBoxOK>(MessageBoxOK.Read, MessageBoxOK.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RefactoringInteraction> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var wizardForm = RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>.Read(ctx, reader, JetBrains.Rider.Model.Refactorings.WizardForm.Read, JetBrains.Rider.Model.Refactorings.WizardForm.Write);
      var title = reader.ReadString();
      var message = RdSignal<MessageBoxOK>.Read(ctx, reader, MessageBoxOK.Read, MessageBoxOK.Write);
      return new RefactoringInteraction(wizardForm, title, message).WithId(_id);
    };
    
    public static CtxWriteDelegate<RefactoringInteraction> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.Refactorings.WizardForm>.Write(ctx, writer, value._WizardForm);
      writer.Write(value.Title);
      RdSignal<MessageBoxOK>.Write(ctx, writer, value._Message);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringInteraction (");
      using (printer.IndentCookie()) {
        printer.Print("wizardForm = "); _WizardForm.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("message = "); _Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringListViewModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<RefactoringCompletionItem> Items {get; private set;}
    public bool IsChecked {get; private set;}
    
    //private fields
    //primary constructor
    public RefactoringListViewModel(
      [NotNull] List<RefactoringCompletionItem> items,
      bool isChecked
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      IsChecked = isChecked;
      BindableChildren.Add(new KeyValuePair<string, object>("items", Items));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RefactoringListViewModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var items = ReadRefactoringCompletionItemList(ctx, reader);
      var isChecked = reader.ReadBool();
      return new RefactoringListViewModel(items, isChecked).WithId(_id);
    };
    public static CtxReadDelegate<List<RefactoringCompletionItem>> ReadRefactoringCompletionItemList = RefactoringCompletionItem.Read.List();
    
    public static CtxWriteDelegate<RefactoringListViewModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteRefactoringCompletionItemList(ctx, writer, value.Items);
      writer.Write(value.IsChecked);
    };
    public static CtxWriteDelegate<List<RefactoringCompletionItem>> WriteRefactoringCompletionItemList = RefactoringCompletionItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringListViewModel (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("isChecked = "); IsChecked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RefactoringsValidationResult : IPrintable, IEquatable<RefactoringsValidationResult> {
    //fields
    //public fields
    public JetBrains.Rider.Model.UIAutomation.ValidationStates State {get; private set;}
    [NotNull] public string ResultMessage {get; private set;}
    
    //private fields
    //primary constructor
    public RefactoringsValidationResult(
      JetBrains.Rider.Model.UIAutomation.ValidationStates state,
      [NotNull] string resultMessage
    )
    {
      if (resultMessage == null) throw new ArgumentNullException("resultMessage");
      
      State = state;
      ResultMessage = resultMessage;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RefactoringsValidationResult> Read = (ctx, reader) => 
    {
      var state = (JetBrains.Rider.Model.UIAutomation.ValidationStates)reader.ReadInt();
      var resultMessage = reader.ReadString();
      return new RefactoringsValidationResult(state, resultMessage);
    };
    
    public static CtxWriteDelegate<RefactoringsValidationResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      writer.Write(value.ResultMessage);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RefactoringsValidationResult) obj);
    }
    public bool Equals(RefactoringsValidationResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && ResultMessage == other.ResultMessage;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        hash = hash * 31 + ResultMessage.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RefactoringsValidationResult (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("resultMessage = "); ResultMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RelatedElementsPageModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<RelatedElementsPageModelNode> Node {get; private set;}
    
    //private fields
    //primary constructor
    private RelatedElementsPageModel(
      [NotNull] List<RelatedElementsPageModelNode> node,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (node == null) throw new ArgumentNullException("node");
      
      Node = node;
      BindableChildren.Add(new KeyValuePair<string, object>("node", Node));
    }
    //secondary constructor
    public RelatedElementsPageModel (
      [NotNull] List<RelatedElementsPageModelNode> node,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      node,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<RelatedElementsPageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var node = ReadRelatedElementsPageModelNodeList(ctx, reader);
      return new RelatedElementsPageModel(node, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<RelatedElementsPageModelNode>> ReadRelatedElementsPageModelNodeList = RelatedElementsPageModelNode.Read.List();
    
    public static new CtxWriteDelegate<RelatedElementsPageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteRelatedElementsPageModelNodeList(ctx, writer, value.Node);
    };
    public static CtxWriteDelegate<List<RelatedElementsPageModelNode>> WriteRelatedElementsPageModelNodeList = RelatedElementsPageModelNode.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RelatedElementsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("node = "); Node.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RelatedElementsPageModelNode : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public int ParentIndex {get; private set;}
    [NotNull] public IRdProperty<CheckboxState> Enabled { get { return _Enabled; }}
    
    //private fields
    [NotNull] private readonly RdProperty<CheckboxState> _Enabled;
    
    //primary constructor
    private RelatedElementsPageModelNode(
      [NotNull] string text,
      int parentIndex,
      [NotNull] RdProperty<CheckboxState> enabled
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (enabled == null) throw new ArgumentNullException("enabled");
      
      Text = text;
      ParentIndex = parentIndex;
      _Enabled = enabled;
      _Enabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
    }
    //secondary constructor
    public RelatedElementsPageModelNode (
      [NotNull] string text,
      int parentIndex
    ) : this (
      text,
      parentIndex,
      new RdProperty<CheckboxState>(ReadCheckboxState, WriteCheckboxState)
    ) {}
    //statics
    
    public static CtxReadDelegate<RelatedElementsPageModelNode> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var text = reader.ReadString();
      var parentIndex = reader.ReadInt();
      var enabled = RdProperty<CheckboxState>.Read(ctx, reader, ReadCheckboxState, WriteCheckboxState);
      return new RelatedElementsPageModelNode(text, parentIndex, enabled).WithId(_id);
    };
    public static CtxReadDelegate<CheckboxState> ReadCheckboxState = new CtxReadDelegate<CheckboxState>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<CheckboxState>);
    
    public static CtxWriteDelegate<RelatedElementsPageModelNode> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Text);
      writer.Write(value.ParentIndex);
      RdProperty<CheckboxState>.Write(ctx, writer, value._Enabled);
    };
    public static CtxWriteDelegate<CheckboxState> WriteCheckboxState = new CtxWriteDelegate<CheckboxState>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<CheckboxState>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RelatedElementsPageModelNode (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("parentIndex = "); ParentIndex.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteDeleteFilesModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> DeleteFiles { get { return _DeleteFiles; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _DeleteFiles;
    
    //primary constructor
    private SafeDeleteDeleteFilesModel(
      [NotNull] RdProperty<bool> deleteFiles,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (deleteFiles == null) throw new ArgumentNullException("deleteFiles");
      
      _DeleteFiles = deleteFiles;
      _DeleteFiles.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("deleteFiles", _DeleteFiles));
    }
    //secondary constructor
    public SafeDeleteDeleteFilesModel (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteDeleteFilesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var deleteFiles = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new SafeDeleteDeleteFilesModel(deleteFiles, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<SafeDeleteDeleteFilesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._DeleteFiles);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteDeleteFilesModel (");
      using (printer.IndentCookie()) {
        printer.Print("deleteFiles = "); _DeleteFiles.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteInheritorsPageModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public RdPropertyToRadioViewModel DeleteInheritors {get; private set;}
    
    //private fields
    //primary constructor
    private SafeDeleteInheritorsPageModel(
      [NotNull] RdPropertyToRadioViewModel deleteInheritors,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (deleteInheritors == null) throw new ArgumentNullException("deleteInheritors");
      
      DeleteInheritors = deleteInheritors;
      BindableChildren.Add(new KeyValuePair<string, object>("deleteInheritors", DeleteInheritors));
    }
    //secondary constructor
    public SafeDeleteInheritorsPageModel (
      [NotNull] RdPropertyToRadioViewModel deleteInheritors,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      deleteInheritors,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteInheritorsPageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var deleteInheritors = RdPropertyToRadioViewModel.Read(ctx, reader);
      return new SafeDeleteInheritorsPageModel(deleteInheritors, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<SafeDeleteInheritorsPageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdPropertyToRadioViewModel.Write(ctx, writer, value.DeleteInheritors);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteInheritorsPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("deleteInheritors = "); DeleteInheritors.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SafeDeleteOverridableMemberEnum {
    All,
    Inheritors,
    Single
  }
  
  
  public class SafeDeleteOverridableMemberModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<SafeDeleteOverridableMemberEnum> ReplaceType { get { return _ReplaceType; }}
    [NotNull] public string BaseName {get; private set;}
    public bool EnableInheritor {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<SafeDeleteOverridableMemberEnum> _ReplaceType;
    
    //primary constructor
    private SafeDeleteOverridableMemberModel(
      [NotNull] RdProperty<SafeDeleteOverridableMemberEnum> replaceType,
      [NotNull] string baseName,
      bool enableInheritor,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (replaceType == null) throw new ArgumentNullException("replaceType");
      if (baseName == null) throw new ArgumentNullException("baseName");
      
      _ReplaceType = replaceType;
      BaseName = baseName;
      EnableInheritor = enableInheritor;
      _ReplaceType.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("replaceType", _ReplaceType));
    }
    //secondary constructor
    public SafeDeleteOverridableMemberModel (
      [NotNull] string baseName,
      bool enableInheritor,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<SafeDeleteOverridableMemberEnum>(ReadSafeDeleteOverridableMemberEnum, WriteSafeDeleteOverridableMemberEnum),
      baseName,
      enableInheritor,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteOverridableMemberModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var replaceType = RdProperty<SafeDeleteOverridableMemberEnum>.Read(ctx, reader, ReadSafeDeleteOverridableMemberEnum, WriteSafeDeleteOverridableMemberEnum);
      var baseName = reader.ReadString();
      var enableInheritor = reader.ReadBool();
      return new SafeDeleteOverridableMemberModel(replaceType, baseName, enableInheritor, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<SafeDeleteOverridableMemberEnum> ReadSafeDeleteOverridableMemberEnum = new CtxReadDelegate<SafeDeleteOverridableMemberEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<SafeDeleteOverridableMemberEnum>);
    
    public static new CtxWriteDelegate<SafeDeleteOverridableMemberModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<SafeDeleteOverridableMemberEnum>.Write(ctx, writer, value._ReplaceType);
      writer.Write(value.BaseName);
      writer.Write(value.EnableInheritor);
    };
    public static CtxWriteDelegate<SafeDeleteOverridableMemberEnum> WriteSafeDeleteOverridableMemberEnum = new CtxWriteDelegate<SafeDeleteOverridableMemberEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<SafeDeleteOverridableMemberEnum>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteOverridableMemberModel (");
      using (printer.IndentCookie()) {
        printer.Print("replaceType = "); _ReplaceType.PrintEx(printer); printer.Println();
        printer.Print("baseName = "); BaseName.PrintEx(printer); printer.Println();
        printer.Print("enableInheritor = "); EnableInheritor.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SafeDeleteReferenceUsagesModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> RemoveOnlyUnused { get { return _RemoveOnlyUnused; }}
    [NotNull] public IRdProperty<bool> RemoveUnusedEnabled { get { return _RemoveUnusedEnabled; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.RdUsageList> Occurrences { get { return _Occurrences; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _RemoveOnlyUnused;
    [NotNull] private readonly RdProperty<bool> _RemoveUnusedEnabled;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.RdUsageList> _Occurrences;
    
    //primary constructor
    private SafeDeleteReferenceUsagesModel(
      [NotNull] RdProperty<bool> removeOnlyUnused,
      [NotNull] RdProperty<bool> removeUnusedEnabled,
      [NotNull] RdProperty<JetBrains.Rider.Model.RdUsageList> occurrences,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (removeOnlyUnused == null) throw new ArgumentNullException("removeOnlyUnused");
      if (removeUnusedEnabled == null) throw new ArgumentNullException("removeUnusedEnabled");
      if (occurrences == null) throw new ArgumentNullException("occurrences");
      
      _RemoveOnlyUnused = removeOnlyUnused;
      _RemoveUnusedEnabled = removeUnusedEnabled;
      _Occurrences = occurrences;
      _RemoveOnlyUnused.OptimizeNested = true;
      _RemoveUnusedEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("removeOnlyUnused", _RemoveOnlyUnused));
      BindableChildren.Add(new KeyValuePair<string, object>("removeUnusedEnabled", _RemoveUnusedEnabled));
      BindableChildren.Add(new KeyValuePair<string, object>("occurrences", _Occurrences));
    }
    //secondary constructor
    public SafeDeleteReferenceUsagesModel (
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<JetBrains.Rider.Model.RdUsageList>(JetBrains.Rider.Model.RdUsageList.Read, JetBrains.Rider.Model.RdUsageList.Write),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteReferenceUsagesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var removeOnlyUnused = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var removeUnusedEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var occurrences = RdProperty<JetBrains.Rider.Model.RdUsageList>.Read(ctx, reader, JetBrains.Rider.Model.RdUsageList.Read, JetBrains.Rider.Model.RdUsageList.Write);
      return new SafeDeleteReferenceUsagesModel(removeOnlyUnused, removeUnusedEnabled, occurrences, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<SafeDeleteReferenceUsagesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._RemoveOnlyUnused);
      RdProperty<bool>.Write(ctx, writer, value._RemoveUnusedEnabled);
      RdProperty<JetBrains.Rider.Model.RdUsageList>.Write(ctx, writer, value._Occurrences);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteReferenceUsagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("removeOnlyUnused = "); _RemoveOnlyUnused.PrintEx(printer); printer.Println();
        printer.Print("removeUnusedEnabled = "); _RemoveUnusedEnabled.PrintEx(printer); printer.Println();
        printer.Print("occurrences = "); _Occurrences.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SafeDeleteReplaceTypeUsagesEnum {
    None,
    Inheritor,
    Base
  }
  
  
  public class SafeDeleteReplaceTypeUsagesModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<SafeDeleteReplaceTypeUsagesEnum> ReplaceType { get { return _ReplaceType; }}
    [NotNull] public string BaseName {get; private set;}
    [NotNull] public string InheritorName {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<SafeDeleteReplaceTypeUsagesEnum> _ReplaceType;
    
    //primary constructor
    private SafeDeleteReplaceTypeUsagesModel(
      [NotNull] RdProperty<SafeDeleteReplaceTypeUsagesEnum> replaceType,
      [NotNull] string baseName,
      [NotNull] string inheritorName,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (replaceType == null) throw new ArgumentNullException("replaceType");
      if (baseName == null) throw new ArgumentNullException("baseName");
      if (inheritorName == null) throw new ArgumentNullException("inheritorName");
      
      _ReplaceType = replaceType;
      BaseName = baseName;
      InheritorName = inheritorName;
      _ReplaceType.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("replaceType", _ReplaceType));
    }
    //secondary constructor
    public SafeDeleteReplaceTypeUsagesModel (
      [NotNull] string baseName,
      [NotNull] string inheritorName,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      new RdProperty<SafeDeleteReplaceTypeUsagesEnum>(ReadSafeDeleteReplaceTypeUsagesEnum, WriteSafeDeleteReplaceTypeUsagesEnum),
      baseName,
      inheritorName,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SafeDeleteReplaceTypeUsagesModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var replaceType = RdProperty<SafeDeleteReplaceTypeUsagesEnum>.Read(ctx, reader, ReadSafeDeleteReplaceTypeUsagesEnum, WriteSafeDeleteReplaceTypeUsagesEnum);
      var baseName = reader.ReadString();
      var inheritorName = reader.ReadString();
      return new SafeDeleteReplaceTypeUsagesModel(replaceType, baseName, inheritorName, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<SafeDeleteReplaceTypeUsagesEnum> ReadSafeDeleteReplaceTypeUsagesEnum = new CtxReadDelegate<SafeDeleteReplaceTypeUsagesEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<SafeDeleteReplaceTypeUsagesEnum>);
    
    public static new CtxWriteDelegate<SafeDeleteReplaceTypeUsagesModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<SafeDeleteReplaceTypeUsagesEnum>.Write(ctx, writer, value._ReplaceType);
      writer.Write(value.BaseName);
      writer.Write(value.InheritorName);
    };
    public static CtxWriteDelegate<SafeDeleteReplaceTypeUsagesEnum> WriteSafeDeleteReplaceTypeUsagesEnum = new CtxWriteDelegate<SafeDeleteReplaceTypeUsagesEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<SafeDeleteReplaceTypeUsagesEnum>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SafeDeleteReplaceTypeUsagesModel (");
      using (printer.IndentCookie()) {
        printer.Print("replaceType = "); _ReplaceType.PrintEx(printer); printer.Println();
        printer.Print("baseName = "); BaseName.PrintEx(printer); printer.Println();
        printer.Print("inheritorName = "); InheritorName.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectTypePartModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<TextWithIconModel> Parts {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] public IRdSignal<int> NavigateTo { get { return _NavigateTo; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    
    //primary constructor
    private SelectTypePartModel(
      [NotNull] List<TextWithIconModel> parts,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdSignal<int> navigateTo,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (parts == null) throw new ArgumentNullException("parts");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      
      Parts = parts;
      _SelectedIndex = selectedIndex;
      _NavigateTo = navigateTo;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
    }
    //secondary constructor
    public SelectTypePartModel (
      [NotNull] List<TextWithIconModel> parts,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      parts,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<SelectTypePartModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var parts = ReadTextWithIconModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var navigateTo = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new SelectTypePartModel(parts, selectedIndex, navigateTo, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<TextWithIconModel>> ReadTextWithIconModelList = TextWithIconModel.Read.List();
    
    public static new CtxWriteDelegate<SelectTypePartModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteTextWithIconModelList(ctx, writer, value.Parts);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdSignal<int>.Write(ctx, writer, value._NavigateTo);
    };
    public static CtxWriteDelegate<List<TextWithIconModel>> WriteTextWithIconModelList = TextWithIconModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SelectTypePartModel (");
      using (printer.IndentCookie()) {
        printer.Print("parts = "); Parts.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextOccurrencesPageModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.RdUsageList Occurrences {get; private set;}
    [NotNull] public string GlobalCheckboxLabel {get; private set;}
    [NotNull] public IRdSignal<int> SetChecked { get { return _SetChecked; }}
    [NotNull] public IRdSignal<int> SetUnchecked { get { return _SetUnchecked; }}
    [NotNull] public IRdProperty<bool> GlobalEnabled { get { return _GlobalEnabled; }}
    
    //private fields
    [NotNull] private readonly RdSignal<int> _SetChecked;
    [NotNull] private readonly RdSignal<int> _SetUnchecked;
    [NotNull] private readonly RdProperty<bool> _GlobalEnabled;
    
    //primary constructor
    private TextOccurrencesPageModel(
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] string globalCheckboxLabel,
      [NotNull] RdSignal<int> setChecked,
      [NotNull] RdSignal<int> setUnchecked,
      [NotNull] RdProperty<bool> globalEnabled,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (occurrences == null) throw new ArgumentNullException("occurrences");
      if (globalCheckboxLabel == null) throw new ArgumentNullException("globalCheckboxLabel");
      if (setChecked == null) throw new ArgumentNullException("setChecked");
      if (setUnchecked == null) throw new ArgumentNullException("setUnchecked");
      if (globalEnabled == null) throw new ArgumentNullException("globalEnabled");
      
      Occurrences = occurrences;
      GlobalCheckboxLabel = globalCheckboxLabel;
      _SetChecked = setChecked;
      _SetUnchecked = setUnchecked;
      _GlobalEnabled = globalEnabled;
      _GlobalEnabled.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("occurrences", Occurrences));
      BindableChildren.Add(new KeyValuePair<string, object>("setChecked", _SetChecked));
      BindableChildren.Add(new KeyValuePair<string, object>("setUnchecked", _SetUnchecked));
      BindableChildren.Add(new KeyValuePair<string, object>("globalEnabled", _GlobalEnabled));
    }
    //secondary constructor
    public TextOccurrencesPageModel (
      [NotNull] JetBrains.Rider.Model.RdUsageList occurrences,
      [NotNull] string globalCheckboxLabel,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      occurrences,
      globalCheckboxLabel,
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<TextOccurrencesPageModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var occurrences = JetBrains.Rider.Model.RdUsageList.Read(ctx, reader);
      var globalCheckboxLabel = reader.ReadString();
      var setChecked = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var setUnchecked = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var globalEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new TextOccurrencesPageModel(occurrences, globalCheckboxLabel, setChecked, setUnchecked, globalEnabled, title, description, continueEnabled, validationResult).WithId(_id);
    };
    
    public static new CtxWriteDelegate<TextOccurrencesPageModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      JetBrains.Rider.Model.RdUsageList.Write(ctx, writer, value.Occurrences);
      writer.Write(value.GlobalCheckboxLabel);
      RdSignal<int>.Write(ctx, writer, value._SetChecked);
      RdSignal<int>.Write(ctx, writer, value._SetUnchecked);
      RdProperty<bool>.Write(ctx, writer, value._GlobalEnabled);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextOccurrencesPageModel (");
      using (printer.IndentCookie()) {
        printer.Print("occurrences = "); Occurrences.PrintEx(printer); printer.Println();
        printer.Print("globalCheckboxLabel = "); GlobalCheckboxLabel.PrintEx(printer); printer.Println();
        printer.Print("setChecked = "); _SetChecked.PrintEx(printer); printer.Println();
        printer.Print("setUnchecked = "); _SetUnchecked.PrintEx(printer); printer.Println();
        printer.Print("globalEnabled = "); _GlobalEnabled.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextWithIconModel : IPrintable, IEquatable<TextWithIconModel> {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public TextWithIconModel(
      [NotNull] string text,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextWithIconModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new TextWithIconModel(text, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<TextWithIconModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextWithIconModel) obj);
    }
    public bool Equals(TextWithIconModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Text == other.Text && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextWithIconModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TypeSuggestionsElementModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ParameterName {get; private set;}
    [NotNull] public List<string> PossibleResolutions {get; private set;}
    [NotNull] public IRdProperty<int> Resolution { get { return _Resolution; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Resolution;
    
    //primary constructor
    private TypeSuggestionsElementModel(
      [NotNull] string parameterName,
      [NotNull] List<string> possibleResolutions,
      [NotNull] RdProperty<int> resolution
    )
    {
      if (parameterName == null) throw new ArgumentNullException("parameterName");
      if (possibleResolutions == null) throw new ArgumentNullException("possibleResolutions");
      if (resolution == null) throw new ArgumentNullException("resolution");
      
      ParameterName = parameterName;
      PossibleResolutions = possibleResolutions;
      _Resolution = resolution;
      _Resolution.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("resolution", _Resolution));
    }
    //secondary constructor
    public TypeSuggestionsElementModel (
      [NotNull] string parameterName,
      [NotNull] List<string> possibleResolutions
    ) : this (
      parameterName,
      possibleResolutions,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<TypeSuggestionsElementModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var parameterName = reader.ReadString();
      var possibleResolutions = ReadStringList(ctx, reader);
      var resolution = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new TypeSuggestionsElementModel(parameterName, possibleResolutions, resolution).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<TypeSuggestionsElementModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ParameterName);
      WriteStringList(ctx, writer, value.PossibleResolutions);
      RdProperty<int>.Write(ctx, writer, value._Resolution);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypeSuggestionsElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("parameterName = "); ParameterName.PrintEx(printer); printer.Println();
        printer.Print("possibleResolutions = "); PossibleResolutions.PrintEx(printer); printer.Println();
        printer.Print("resolution = "); _Resolution.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TypeSuggestionsModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public List<TypeSuggestionsElementModel> Elements {get; private set;}
    
    //private fields
    //primary constructor
    private TypeSuggestionsModel(
      [NotNull] List<TypeSuggestionsElementModel> elements,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (elements == null) throw new ArgumentNullException("elements");
      
      Elements = elements;
      BindableChildren.Add(new KeyValuePair<string, object>("elements", Elements));
    }
    //secondary constructor
    public TypeSuggestionsModel (
      [NotNull] List<TypeSuggestionsElementModel> elements,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      elements,
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<TypeSuggestionsModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var elements = ReadTypeSuggestionsElementModelList(ctx, reader);
      return new TypeSuggestionsModel(elements, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<TypeSuggestionsElementModel>> ReadTypeSuggestionsElementModelList = TypeSuggestionsElementModel.Read.List();
    
    public static new CtxWriteDelegate<TypeSuggestionsModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      WriteTypeSuggestionsElementModelList(ctx, writer, value.Elements);
    };
    public static CtxWriteDelegate<List<TypeSuggestionsElementModel>> WriteTypeSuggestionsElementModelList = TypeSuggestionsElementModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypeSuggestionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class UseBaseTypeModel : AbstractPage
   {
    //fields
    //public fields
    [NotNull] public string DerivedTypeName {get; private set;}
    [NotNull] public List<TextWithIconModel> TypeParts {get; private set;}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    [NotNull] public IRdSignal<int> NavigateTo { get { return _NavigateTo; }}
    [NotNull] public IRdProperty<bool> ReplaceInTypeof { get { return _ReplaceInTypeof; }}
    [NotNull] public IRdProperty<bool> ReplaceInIs { get { return _ReplaceInIs; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    [NotNull] private readonly RdSignal<int> _NavigateTo;
    [NotNull] private readonly RdProperty<bool> _ReplaceInTypeof;
    [NotNull] private readonly RdProperty<bool> _ReplaceInIs;
    
    //primary constructor
    private UseBaseTypeModel(
      [NotNull] string derivedTypeName,
      [NotNull] List<TextWithIconModel> typeParts,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdSignal<int> navigateTo,
      [NotNull] RdProperty<bool> replaceInTypeof,
      [NotNull] RdProperty<bool> replaceInIs,
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] RdProperty<bool> continueEnabled,
      [NotNull] RdSignal<RefactoringsValidationResult> validationResult
    ) : base (
      title,
      description,
      continueEnabled,
      validationResult
     ) 
    {
      if (derivedTypeName == null) throw new ArgumentNullException("derivedTypeName");
      if (typeParts == null) throw new ArgumentNullException("typeParts");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      if (navigateTo == null) throw new ArgumentNullException("navigateTo");
      if (replaceInTypeof == null) throw new ArgumentNullException("replaceInTypeof");
      if (replaceInIs == null) throw new ArgumentNullException("replaceInIs");
      
      DerivedTypeName = derivedTypeName;
      TypeParts = typeParts;
      _SelectedIndex = selectedIndex;
      _NavigateTo = navigateTo;
      _ReplaceInTypeof = replaceInTypeof;
      _ReplaceInIs = replaceInIs;
      _SelectedIndex.OptimizeNested = true;
      _ReplaceInTypeof.OptimizeNested = true;
      _ReplaceInIs.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateTo", _NavigateTo));
      BindableChildren.Add(new KeyValuePair<string, object>("replaceInTypeof", _ReplaceInTypeof));
      BindableChildren.Add(new KeyValuePair<string, object>("replaceInIs", _ReplaceInIs));
    }
    //secondary constructor
    public UseBaseTypeModel (
      [NotNull] string derivedTypeName,
      [NotNull] List<TextWithIconModel> typeParts,
      [NotNull] string title,
      [NotNull] string description
    ) : this (
      derivedTypeName,
      typeParts,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      title,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RefactoringsValidationResult>(RefactoringsValidationResult.Read, RefactoringsValidationResult.Write)
    ) {}
    //statics
    
    public static new CtxReadDelegate<UseBaseTypeModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = reader.ReadString();
      var description = reader.ReadString();
      var continueEnabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var validationResult = RdSignal<RefactoringsValidationResult>.Read(ctx, reader, RefactoringsValidationResult.Read, RefactoringsValidationResult.Write);
      var derivedTypeName = reader.ReadString();
      var typeParts = ReadTextWithIconModelList(ctx, reader);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var navigateTo = RdSignal<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var replaceInTypeof = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var replaceInIs = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new UseBaseTypeModel(derivedTypeName, typeParts, selectedIndex, navigateTo, replaceInTypeof, replaceInIs, title, description, continueEnabled, validationResult).WithId(_id);
    };
    public static CtxReadDelegate<List<TextWithIconModel>> ReadTextWithIconModelList = TextWithIconModel.Read.List();
    
    public static new CtxWriteDelegate<UseBaseTypeModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Title);
      writer.Write(value.Description);
      RdProperty<bool>.Write(ctx, writer, value._ContinueEnabled);
      RdSignal<RefactoringsValidationResult>.Write(ctx, writer, value._ValidationResult);
      writer.Write(value.DerivedTypeName);
      WriteTextWithIconModelList(ctx, writer, value.TypeParts);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
      RdSignal<int>.Write(ctx, writer, value._NavigateTo);
      RdProperty<bool>.Write(ctx, writer, value._ReplaceInTypeof);
      RdProperty<bool>.Write(ctx, writer, value._ReplaceInIs);
    };
    public static CtxWriteDelegate<List<TextWithIconModel>> WriteTextWithIconModelList = TextWithIconModel.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UseBaseTypeModel (");
      using (printer.IndentCookie()) {
        printer.Print("derivedTypeName = "); DerivedTypeName.PrintEx(printer); printer.Println();
        printer.Print("typeParts = "); TypeParts.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("navigateTo = "); _NavigateTo.PrintEx(printer); printer.Println();
        printer.Print("replaceInTypeof = "); _ReplaceInTypeof.PrintEx(printer); printer.Println();
        printer.Print("replaceInIs = "); _ReplaceInIs.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("continueEnabled = "); _ContinueEnabled.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class WizardForm : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdSignal<RdVoid> ContinueClicked { get { return _ContinueClicked; }}
    [NotNull] public IRdSignal<RdVoid> BackClicked { get { return _BackClicked; }}
    [NotNull] public IRdSignal<RdVoid> FormClosed { get { return _FormClosed; }}
    [NotNull] public IRdSignal<RdVoid> Activated { get { return _Activated; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.RdCancelableProgress> ExecuteTask { get { return _ExecuteTask; }}
    [NotNull] public IRdProperty<AbstractPage> Page { get { return _Page; }}
    [NotNull] public IRdProperty<bool> HasBack { get { return _HasBack; }}
    [NotNull] public IRdSignal<RdVoid> PumpUi { get { return _PumpUi; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _ContinueClicked;
    [NotNull] private readonly RdSignal<RdVoid> _BackClicked;
    [NotNull] private readonly RdSignal<RdVoid> _FormClosed;
    [NotNull] private readonly RdSignal<RdVoid> _Activated;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.RdCancelableProgress> _ExecuteTask;
    [NotNull] private readonly RdProperty<AbstractPage> _Page;
    [NotNull] private readonly RdProperty<bool> _HasBack;
    [NotNull] private readonly RdSignal<RdVoid> _PumpUi;
    
    //primary constructor
    private WizardForm(
      [NotNull] RdSignal<RdVoid> continueClicked,
      [NotNull] RdSignal<RdVoid> backClicked,
      [NotNull] RdSignal<RdVoid> formClosed,
      [NotNull] RdSignal<RdVoid> activated,
      [NotNull] RdProperty<JetBrains.Rider.Model.RdCancelableProgress> executeTask,
      [NotNull] RdProperty<AbstractPage> page,
      [NotNull] RdProperty<bool> hasBack,
      [NotNull] RdSignal<RdVoid> pumpUi
    )
    {
      if (continueClicked == null) throw new ArgumentNullException("continueClicked");
      if (backClicked == null) throw new ArgumentNullException("backClicked");
      if (formClosed == null) throw new ArgumentNullException("formClosed");
      if (activated == null) throw new ArgumentNullException("activated");
      if (executeTask == null) throw new ArgumentNullException("executeTask");
      if (page == null) throw new ArgumentNullException("page");
      if (hasBack == null) throw new ArgumentNullException("hasBack");
      if (pumpUi == null) throw new ArgumentNullException("pumpUi");
      
      _ContinueClicked = continueClicked;
      _BackClicked = backClicked;
      _FormClosed = formClosed;
      _Activated = activated;
      _ExecuteTask = executeTask;
      _Page = page;
      _HasBack = hasBack;
      _PumpUi = pumpUi;
      _HasBack.OptimizeNested = true;
      _ExecuteTask.ValueCanBeNull = true;
      _Page.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("continueClicked", _ContinueClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("backClicked", _BackClicked));
      BindableChildren.Add(new KeyValuePair<string, object>("formClosed", _FormClosed));
      BindableChildren.Add(new KeyValuePair<string, object>("activated", _Activated));
      BindableChildren.Add(new KeyValuePair<string, object>("executeTask", _ExecuteTask));
      BindableChildren.Add(new KeyValuePair<string, object>("page", _Page));
      BindableChildren.Add(new KeyValuePair<string, object>("hasBack", _HasBack));
      BindableChildren.Add(new KeyValuePair<string, object>("pumpUi", _PumpUi));
    }
    //secondary constructor
    public WizardForm (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<JetBrains.Rider.Model.RdCancelableProgress>(ReadRdCancelableProgressNullable, WriteRdCancelableProgressNullable),
      new RdProperty<AbstractPage>(ReadAbstractPageNullable, WriteAbstractPageNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<WizardForm> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var continueClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var backClicked = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var formClosed = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var activated = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var executeTask = RdProperty<JetBrains.Rider.Model.RdCancelableProgress>.Read(ctx, reader, ReadRdCancelableProgressNullable, WriteRdCancelableProgressNullable);
      var page = RdProperty<AbstractPage>.Read(ctx, reader, ReadAbstractPageNullable, WriteAbstractPageNullable);
      var hasBack = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var pumpUi = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new WizardForm(continueClicked, backClicked, formClosed, activated, executeTask, page, hasBack, pumpUi).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.RdCancelableProgress> ReadRdCancelableProgressNullable = JetBrains.Rider.Model.RdCancelableProgress.Read.NullableClass();
    public static CtxReadDelegate<AbstractPage> ReadAbstractPageNullable = AbstractPage.Read.NullableClass();
    
    public static CtxWriteDelegate<WizardForm> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._ContinueClicked);
      RdSignal<RdVoid>.Write(ctx, writer, value._BackClicked);
      RdSignal<RdVoid>.Write(ctx, writer, value._FormClosed);
      RdSignal<RdVoid>.Write(ctx, writer, value._Activated);
      RdProperty<JetBrains.Rider.Model.RdCancelableProgress>.Write(ctx, writer, value._ExecuteTask);
      RdProperty<AbstractPage>.Write(ctx, writer, value._Page);
      RdProperty<bool>.Write(ctx, writer, value._HasBack);
      RdSignal<RdVoid>.Write(ctx, writer, value._PumpUi);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.RdCancelableProgress> WriteRdCancelableProgressNullable = JetBrains.Rider.Model.RdCancelableProgress.Write.NullableClass();
    public static CtxWriteDelegate<AbstractPage> WriteAbstractPageNullable = AbstractPage.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("WizardForm (");
      using (printer.IndentCookie()) {
        printer.Print("continueClicked = "); _ContinueClicked.PrintEx(printer); printer.Println();
        printer.Print("backClicked = "); _BackClicked.PrintEx(printer); printer.Println();
        printer.Print("formClosed = "); _FormClosed.PrintEx(printer); printer.Println();
        printer.Print("activated = "); _Activated.PrintEx(printer); printer.Println();
        printer.Print("executeTask = "); _ExecuteTask.PrintEx(printer); printer.Println();
        printer.Print("page = "); _Page.PrintEx(printer); printer.Println();
        printer.Print("hasBack = "); _HasBack.PrintEx(printer); printer.Println();
        printer.Print("pumpUi = "); _PumpUi.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
