using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class SettingsModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<JetBrains.Application.Settings.Storage.KeyPathComponents, PredefinedValue> ProtocolStorage { get { return _ProtocolStorage; }}
    [NotNull] public IRdProperty<int> RightMargin { get { return _RightMargin; }}
    [NotNull] public IRdProperty<bool> VirtualSpace { get { return _VirtualSpace; }}
    [NotNull] public IRdProperty<LineSeparators> LineSeparator { get { return _LineSeparator; }}
    [NotNull] public IRdProperty<List<FileNestingRule>> FileNestingRules { get { return _FileNestingRules; }}
    [NotNull] public IRdProperty<bool> InsertPairBracket { get { return _InsertPairBracket; }}
    [NotNull] public IRdProperty<bool> InsertPairQuote { get { return _InsertPairQuote; }}
    [NotNull] public IRdProperty<bool> SurroundSelectionOnTyping { get { return _SurroundSelectionOnTyping; }}
    [NotNull] public IRdProperty<bool> ReformatBlockOnClosingBrace { get { return _ReformatBlockOnClosingBrace; }}
    [NotNull] public IRdProperty<bool> UseCamelHumps { get { return _UseCamelHumps; }}
    [NotNull] public IRdProperty<bool> InsertPairBraceOnEnter { get { return _InsertPairBraceOnEnter; }}
    [NotNull] public IRdProperty<ReformatOnPasteKind> ReformatOnPaste { get { return _ReformatOnPaste; }}
    [NotNull] public IRdProperty<bool> SmartIndent { get { return _SmartIndent; }}
    [NotNull] public IRdProperty<bool> NoBomForNewFiles { get { return _NoBomForNewFiles; }}
    [NotNull] public IRdProperty<bool> ShowBuildProgressOnStatusBar { get { return _ShowBuildProgressOnStatusBar; }}
    [NotNull] public IRdProperty<bool> ShowBuildProgressOnTaskBar { get { return _ShowBuildProgressOnTaskBar; }}
    [NotNull] public IRdProperty<WhenShowBuildResultMode> ShowResultAfterBuild { get { return _ShowResultAfterBuild; }}
    [NotNull] public IRdProperty<bool> ShowBuildProgressInToolWindow { get { return _ShowBuildProgressInToolWindow; }}
    
    //private fields
    [NotNull] private readonly RdMap<JetBrains.Application.Settings.Storage.KeyPathComponents, PredefinedValue> _ProtocolStorage;
    [NotNull] private readonly RdProperty<int> _RightMargin;
    [NotNull] private readonly RdProperty<bool> _VirtualSpace;
    [NotNull] private readonly RdProperty<LineSeparators> _LineSeparator;
    [NotNull] private readonly RdProperty<List<FileNestingRule>> _FileNestingRules;
    [NotNull] private readonly RdProperty<bool> _InsertPairBracket;
    [NotNull] private readonly RdProperty<bool> _InsertPairQuote;
    [NotNull] private readonly RdProperty<bool> _SurroundSelectionOnTyping;
    [NotNull] private readonly RdProperty<bool> _ReformatBlockOnClosingBrace;
    [NotNull] private readonly RdProperty<bool> _UseCamelHumps;
    [NotNull] private readonly RdProperty<bool> _InsertPairBraceOnEnter;
    [NotNull] private readonly RdProperty<ReformatOnPasteKind> _ReformatOnPaste;
    [NotNull] private readonly RdProperty<bool> _SmartIndent;
    [NotNull] private readonly RdProperty<bool> _NoBomForNewFiles;
    [NotNull] private readonly RdProperty<bool> _ShowBuildProgressOnStatusBar;
    [NotNull] private readonly RdProperty<bool> _ShowBuildProgressOnTaskBar;
    [NotNull] private readonly RdProperty<WhenShowBuildResultMode> _ShowResultAfterBuild;
    [NotNull] private readonly RdProperty<bool> _ShowBuildProgressInToolWindow;
    
    //primary constructor
    private SettingsModel(
      [NotNull] RdMap<JetBrains.Application.Settings.Storage.KeyPathComponents, PredefinedValue> protocolStorage,
      [NotNull] RdProperty<int> rightMargin,
      [NotNull] RdProperty<bool> virtualSpace,
      [NotNull] RdProperty<LineSeparators> lineSeparator,
      [NotNull] RdProperty<List<FileNestingRule>> fileNestingRules,
      [NotNull] RdProperty<bool> insertPairBracket,
      [NotNull] RdProperty<bool> insertPairQuote,
      [NotNull] RdProperty<bool> surroundSelectionOnTyping,
      [NotNull] RdProperty<bool> reformatBlockOnClosingBrace,
      [NotNull] RdProperty<bool> useCamelHumps,
      [NotNull] RdProperty<bool> insertPairBraceOnEnter,
      [NotNull] RdProperty<ReformatOnPasteKind> reformatOnPaste,
      [NotNull] RdProperty<bool> smartIndent,
      [NotNull] RdProperty<bool> noBomForNewFiles,
      [NotNull] RdProperty<bool> showBuildProgressOnStatusBar,
      [NotNull] RdProperty<bool> showBuildProgressOnTaskBar,
      [NotNull] RdProperty<WhenShowBuildResultMode> showResultAfterBuild,
      [NotNull] RdProperty<bool> showBuildProgressInToolWindow
    )
    {
      if (protocolStorage == null) throw new ArgumentNullException("protocolStorage");
      if (rightMargin == null) throw new ArgumentNullException("rightMargin");
      if (virtualSpace == null) throw new ArgumentNullException("virtualSpace");
      if (lineSeparator == null) throw new ArgumentNullException("lineSeparator");
      if (fileNestingRules == null) throw new ArgumentNullException("fileNestingRules");
      if (insertPairBracket == null) throw new ArgumentNullException("insertPairBracket");
      if (insertPairQuote == null) throw new ArgumentNullException("insertPairQuote");
      if (surroundSelectionOnTyping == null) throw new ArgumentNullException("surroundSelectionOnTyping");
      if (reformatBlockOnClosingBrace == null) throw new ArgumentNullException("reformatBlockOnClosingBrace");
      if (useCamelHumps == null) throw new ArgumentNullException("useCamelHumps");
      if (insertPairBraceOnEnter == null) throw new ArgumentNullException("insertPairBraceOnEnter");
      if (reformatOnPaste == null) throw new ArgumentNullException("reformatOnPaste");
      if (smartIndent == null) throw new ArgumentNullException("smartIndent");
      if (noBomForNewFiles == null) throw new ArgumentNullException("noBomForNewFiles");
      if (showBuildProgressOnStatusBar == null) throw new ArgumentNullException("showBuildProgressOnStatusBar");
      if (showBuildProgressOnTaskBar == null) throw new ArgumentNullException("showBuildProgressOnTaskBar");
      if (showResultAfterBuild == null) throw new ArgumentNullException("showResultAfterBuild");
      if (showBuildProgressInToolWindow == null) throw new ArgumentNullException("showBuildProgressInToolWindow");
      
      _ProtocolStorage = protocolStorage;
      _RightMargin = rightMargin;
      _VirtualSpace = virtualSpace;
      _LineSeparator = lineSeparator;
      _FileNestingRules = fileNestingRules;
      _InsertPairBracket = insertPairBracket;
      _InsertPairQuote = insertPairQuote;
      _SurroundSelectionOnTyping = surroundSelectionOnTyping;
      _ReformatBlockOnClosingBrace = reformatBlockOnClosingBrace;
      _UseCamelHumps = useCamelHumps;
      _InsertPairBraceOnEnter = insertPairBraceOnEnter;
      _ReformatOnPaste = reformatOnPaste;
      _SmartIndent = smartIndent;
      _NoBomForNewFiles = noBomForNewFiles;
      _ShowBuildProgressOnStatusBar = showBuildProgressOnStatusBar;
      _ShowBuildProgressOnTaskBar = showBuildProgressOnTaskBar;
      _ShowResultAfterBuild = showResultAfterBuild;
      _ShowBuildProgressInToolWindow = showBuildProgressInToolWindow;
      _ProtocolStorage.OptimizeNested = true;
      _RightMargin.OptimizeNested = true;
      _VirtualSpace.OptimizeNested = true;
      _LineSeparator.OptimizeNested = true;
      _FileNestingRules.OptimizeNested = true;
      _InsertPairBracket.OptimizeNested = true;
      _InsertPairQuote.OptimizeNested = true;
      _SurroundSelectionOnTyping.OptimizeNested = true;
      _ReformatBlockOnClosingBrace.OptimizeNested = true;
      _UseCamelHumps.OptimizeNested = true;
      _InsertPairBraceOnEnter.OptimizeNested = true;
      _ReformatOnPaste.OptimizeNested = true;
      _SmartIndent.OptimizeNested = true;
      _NoBomForNewFiles.OptimizeNested = true;
      _ShowBuildProgressOnStatusBar.OptimizeNested = true;
      _ShowBuildProgressOnTaskBar.OptimizeNested = true;
      _ShowResultAfterBuild.OptimizeNested = true;
      _ShowBuildProgressInToolWindow.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("protocolStorage", _ProtocolStorage));
      BindableChildren.Add(new KeyValuePair<string, object>("rightMargin", _RightMargin));
      BindableChildren.Add(new KeyValuePair<string, object>("virtualSpace", _VirtualSpace));
      BindableChildren.Add(new KeyValuePair<string, object>("lineSeparator", _LineSeparator));
      BindableChildren.Add(new KeyValuePair<string, object>("fileNestingRules", _FileNestingRules));
      BindableChildren.Add(new KeyValuePair<string, object>("insertPairBracket", _InsertPairBracket));
      BindableChildren.Add(new KeyValuePair<string, object>("insertPairQuote", _InsertPairQuote));
      BindableChildren.Add(new KeyValuePair<string, object>("surroundSelectionOnTyping", _SurroundSelectionOnTyping));
      BindableChildren.Add(new KeyValuePair<string, object>("reformatBlockOnClosingBrace", _ReformatBlockOnClosingBrace));
      BindableChildren.Add(new KeyValuePair<string, object>("useCamelHumps", _UseCamelHumps));
      BindableChildren.Add(new KeyValuePair<string, object>("insertPairBraceOnEnter", _InsertPairBraceOnEnter));
      BindableChildren.Add(new KeyValuePair<string, object>("reformatOnPaste", _ReformatOnPaste));
      BindableChildren.Add(new KeyValuePair<string, object>("smartIndent", _SmartIndent));
      BindableChildren.Add(new KeyValuePair<string, object>("noBomForNewFiles", _NoBomForNewFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("showBuildProgressOnStatusBar", _ShowBuildProgressOnStatusBar));
      BindableChildren.Add(new KeyValuePair<string, object>("showBuildProgressOnTaskBar", _ShowBuildProgressOnTaskBar));
      BindableChildren.Add(new KeyValuePair<string, object>("showResultAfterBuild", _ShowResultAfterBuild));
      BindableChildren.Add(new KeyValuePair<string, object>("showBuildProgressInToolWindow", _ShowBuildProgressInToolWindow));
    }
    //secondary constructor
    private SettingsModel (
    ) : this (
      new RdMap<JetBrains.Application.Settings.Storage.KeyPathComponents, PredefinedValue>(JetBrains.Platform.RdFramework.Intrinsics.KeyPathComponentsSerializer.ReadDelegate, JetBrains.Platform.RdFramework.Intrinsics.KeyPathComponentsSerializer.WriteDelegate, PredefinedValue.Read, PredefinedValue.Write),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<LineSeparators>(ReadLineSeparators, WriteLineSeparators),
      new RdProperty<List<FileNestingRule>>(ReadFileNestingRuleList, WriteFileNestingRuleList),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<ReformatOnPasteKind>(ReadReformatOnPasteKind, WriteReformatOnPasteKind),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<WhenShowBuildResultMode>(ReadWhenShowBuildResultMode, WriteWhenShowBuildResultMode),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<LineSeparators> ReadLineSeparators = new CtxReadDelegate<LineSeparators>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<LineSeparators>);
    public static CtxReadDelegate<List<FileNestingRule>> ReadFileNestingRuleList = FileNestingRule.Read.List();
    public static CtxReadDelegate<ReformatOnPasteKind> ReadReformatOnPasteKind = new CtxReadDelegate<ReformatOnPasteKind>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ReformatOnPasteKind>);
    public static CtxReadDelegate<WhenShowBuildResultMode> ReadWhenShowBuildResultMode = new CtxReadDelegate<WhenShowBuildResultMode>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<WhenShowBuildResultMode>);
    
    public static CtxWriteDelegate<LineSeparators> WriteLineSeparators = new CtxWriteDelegate<LineSeparators>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<LineSeparators>);
    public static CtxWriteDelegate<List<FileNestingRule>> WriteFileNestingRuleList = FileNestingRule.Write.List();
    public static CtxWriteDelegate<ReformatOnPasteKind> WriteReformatOnPasteKind = new CtxWriteDelegate<ReformatOnPasteKind>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ReformatOnPasteKind>);
    public static CtxWriteDelegate<WhenShowBuildResultMode> WriteWhenShowBuildResultMode = new CtxWriteDelegate<WhenShowBuildResultMode>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<WhenShowBuildResultMode>);
    
    protected override long SerializationHash => 8080262460370369559L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<LineSeparators>();
      serializers.Register(RdLanguage.Read, RdLanguage.Write);
      serializers.RegisterEnum<ReformatOnPasteKind>();
      serializers.Register(FileNestingRule.Read, FileNestingRule.Write);
      serializers.Register(JetBrains.Platform.RdFramework.Intrinsics.KeyPathComponentsSerializer.ReadDelegate, JetBrains.Platform.RdFramework.Intrinsics.KeyPathComponentsSerializer.WriteDelegate);
      serializers.Register(IntegerValue.Read, IntegerValue.Write);
      serializers.Register(BooleanValue.Read, BooleanValue.Write);
      serializers.Register(DoubleValue.Read, DoubleValue.Write);
      serializers.Register(StringValue.Read, StringValue.Write);
      serializers.RegisterEnum<WhenShowBuildResultMode>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public SettingsModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SettingsModel (");
      using (printer.IndentCookie()) {
        printer.Print("protocolStorage = "); _ProtocolStorage.PrintEx(printer); printer.Println();
        printer.Print("rightMargin = "); _RightMargin.PrintEx(printer); printer.Println();
        printer.Print("virtualSpace = "); _VirtualSpace.PrintEx(printer); printer.Println();
        printer.Print("lineSeparator = "); _LineSeparator.PrintEx(printer); printer.Println();
        printer.Print("fileNestingRules = "); _FileNestingRules.PrintEx(printer); printer.Println();
        printer.Print("insertPairBracket = "); _InsertPairBracket.PrintEx(printer); printer.Println();
        printer.Print("insertPairQuote = "); _InsertPairQuote.PrintEx(printer); printer.Println();
        printer.Print("surroundSelectionOnTyping = "); _SurroundSelectionOnTyping.PrintEx(printer); printer.Println();
        printer.Print("reformatBlockOnClosingBrace = "); _ReformatBlockOnClosingBrace.PrintEx(printer); printer.Println();
        printer.Print("useCamelHumps = "); _UseCamelHumps.PrintEx(printer); printer.Println();
        printer.Print("insertPairBraceOnEnter = "); _InsertPairBraceOnEnter.PrintEx(printer); printer.Println();
        printer.Print("reformatOnPaste = "); _ReformatOnPaste.PrintEx(printer); printer.Println();
        printer.Print("smartIndent = "); _SmartIndent.PrintEx(printer); printer.Println();
        printer.Print("noBomForNewFiles = "); _NoBomForNewFiles.PrintEx(printer); printer.Println();
        printer.Print("showBuildProgressOnStatusBar = "); _ShowBuildProgressOnStatusBar.PrintEx(printer); printer.Println();
        printer.Print("showBuildProgressOnTaskBar = "); _ShowBuildProgressOnTaskBar.PrintEx(printer); printer.Println();
        printer.Print("showResultAfterBuild = "); _ShowResultAfterBuild.PrintEx(printer); printer.Println();
        printer.Print("showBuildProgressInToolWindow = "); _ShowBuildProgressInToolWindow.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BooleanValue : PredefinedValue
   {
    //fields
    //public fields
    public bool Value {get; private set;}
    
    //private fields
    //primary constructor
    public BooleanValue(
      bool value
    )
    {
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BooleanValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadBool();
      return new BooleanValue(value);
    };
    
    public static new CtxWriteDelegate<BooleanValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BooleanValue) obj);
    }
    public bool Equals(BooleanValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BooleanValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DoubleValue : PredefinedValue
   {
    //fields
    //public fields
    public double Value {get; private set;}
    
    //private fields
    //primary constructor
    public DoubleValue(
      double value
    )
    {
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DoubleValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadDouble();
      return new DoubleValue(value);
    };
    
    public static new CtxWriteDelegate<DoubleValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DoubleValue) obj);
    }
    public bool Equals(DoubleValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DoubleValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FileNestingRule : IPrintable, IEquatable<FileNestingRule> {
    //fields
    //public fields
    [NotNull] public string ParentSuffix {get; private set;}
    [NotNull] public string ChildSuffix {get; private set;}
    
    //private fields
    //primary constructor
    public FileNestingRule(
      [NotNull] string parentSuffix,
      [NotNull] string childSuffix
    )
    {
      if (parentSuffix == null) throw new ArgumentNullException("parentSuffix");
      if (childSuffix == null) throw new ArgumentNullException("childSuffix");
      
      ParentSuffix = parentSuffix;
      ChildSuffix = childSuffix;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FileNestingRule> Read = (ctx, reader) => 
    {
      var parentSuffix = reader.ReadString();
      var childSuffix = reader.ReadString();
      return new FileNestingRule(parentSuffix, childSuffix);
    };
    
    public static CtxWriteDelegate<FileNestingRule> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ParentSuffix);
      writer.Write(value.ChildSuffix);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FileNestingRule) obj);
    }
    public bool Equals(FileNestingRule other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ParentSuffix == other.ParentSuffix && ChildSuffix == other.ChildSuffix;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ParentSuffix.GetHashCode();
        hash = hash * 31 + ChildSuffix.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FileNestingRule (");
      using (printer.IndentCookie()) {
        printer.Print("parentSuffix = "); ParentSuffix.PrintEx(printer); printer.Println();
        printer.Print("childSuffix = "); ChildSuffix.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class IntegerValue : PredefinedValue
   {
    //fields
    //public fields
    public int Value {get; private set;}
    
    //private fields
    //primary constructor
    public IntegerValue(
      int value
    )
    {
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<IntegerValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadInt();
      return new IntegerValue(value);
    };
    
    public static new CtxWriteDelegate<IntegerValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((IntegerValue) obj);
    }
    public bool Equals(IntegerValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("IntegerValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LineSeparators {
    LF,
    CR,
    CRLF
  }
  
  
  public abstract class PredefinedValue {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PredefinedValue> Read = Polymorphic<PredefinedValue>.ReadAbstract(PredefinedValue_Unknown.Read);
    
    public static CtxWriteDelegate<PredefinedValue> Write = Polymorphic<PredefinedValue>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class PredefinedValue_Unknown : PredefinedValue
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<PredefinedValue_Unknown> Read = (ctx, reader) => 
    {
      return new PredefinedValue_Unknown();
    };
    
    public static new CtxWriteDelegate<PredefinedValue_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PredefinedValue_Unknown) obj);
    }
    public bool Equals(PredefinedValue_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PredefinedValue_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdLanguage : IPrintable, IEquatable<RdLanguage> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    
    //private fields
    //primary constructor
    public RdLanguage(
      [NotNull] string name
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdLanguage> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      return new RdLanguage(name);
    };
    
    public static CtxWriteDelegate<RdLanguage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdLanguage) obj);
    }
    public bool Equals(RdLanguage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdLanguage (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ReformatOnPasteKind {
    NONE,
    INDENT_EACH_LINE,
    INDENT_BLOCK,
    REFORMAT_BLOCK
  }
  
  
  public class StringValue : PredefinedValue
   {
    //fields
    //public fields
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public StringValue(
      [NotNull] string value
    )
    {
      if (value == null) throw new ArgumentNullException("value");
      
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StringValue> Read = (ctx, reader) => 
    {
      var value = reader.ReadString();
      return new StringValue(value);
    };
    
    public static new CtxWriteDelegate<StringValue> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StringValue) obj);
    }
    public bool Equals(StringValue other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StringValue (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum WhenShowBuildResultMode {
    Always,
    ForWarningsOrErrors,
    ForErrors,
    Never
  }
}
