using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class SolutionModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<int, Solution> Solutions { get { return _Solutions; }}
    [NotNull] public IRdProperty<bool> HasBackedSolution { get { return _HasBackedSolution; }}
    
    //private fields
    [NotNull] private readonly RdMap<int, Solution> _Solutions;
    [NotNull] private readonly RdProperty<bool> _HasBackedSolution;
    
    //primary constructor
    private SolutionModel(
      [NotNull] RdMap<int, Solution> solutions,
      [NotNull] RdProperty<bool> hasBackedSolution
    )
    {
      if (solutions == null) throw new ArgumentNullException("solutions");
      if (hasBackedSolution == null) throw new ArgumentNullException("hasBackedSolution");
      
      _Solutions = solutions;
      _HasBackedSolution = hasBackedSolution;
      _HasBackedSolution.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("solutions", _Solutions));
      BindableChildren.Add(new KeyValuePair<string, object>("hasBackedSolution", _HasBackedSolution));
    }
    //secondary constructor
    private SolutionModel (
    ) : this (
      new RdMap<int, Solution>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, Solution.Read, Solution.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -7708642481607347711L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(EditableEntityId.Read, EditableEntityId.Write);
      serializers.Register(DocOffsetAndVirtualModel.Read, DocOffsetAndVirtualModel.Write);
      serializers.Register(SelectionRange.Read, SelectionRange.Write);
      serializers.Register(VisibleRange.Read, VisibleRange.Write);
      serializers.Register(RdTextRange.Read, RdTextRange.Write);
      serializers.RegisterEnum<ErrorStripeIndicatorStateEnum>();
      serializers.Register(ErrorStripeIndicatorModel.Read, ErrorStripeIndicatorModel.Write);
      serializers.RegisterEnum<ScrollKind>();
      serializers.Register(ScrollingInfo.Read, ScrollingInfo.Write);
      serializers.RegisterEnum<OriginKind>();
      serializers.Register(TextControlModel.Read, TextControlModel.Write);
      serializers.Register(TextControlId.Read, TextControlId.Write);
      serializers.Register(TextControlSnapshot.Read, TextControlSnapshot.Write);
      serializers.Register(FrontendTextControl.Read, FrontendTextControl.Write);
      serializers.RegisterEnum<CompletionMode>();
      serializers.Register(CompletionParameters.Read, CompletionParameters.Write);
      serializers.Register(CompletionItem.Read, CompletionItem.Write);
      serializers.Register(CompletionList.Read, CompletionList.Write);
      serializers.Register(CompleteData.Read, CompleteData.Write);
      serializers.Register(ItemsToUpdate.Read, ItemsToUpdate.Write);
      serializers.Register(ToUpdate.Read, ToUpdate.Write);
      serializers.Register(SummaryInfoItem.Read, SummaryInfoItem.Write);
      serializers.Register(LookupSummaryInfo.Read, LookupSummaryInfo.Write);
      serializers.Register(CompletionSessionModel.Read, CompletionSessionModel.Write);
      serializers.Register(SignatureItem.Read, SignatureItem.Write);
      serializers.Register(ParameterInfoContext.Read, ParameterInfoContext.Write);
      serializers.Register(ParameterInfoModel.Read, ParameterInfoModel.Write);
      serializers.RegisterEnum<ReSharperDaemonStateEnum>();
      serializers.RegisterEnum<HighlightingSettingsState>();
      serializers.Register(HighlightingSettingsModel.Read, HighlightingSettingsModel.Write);
      serializers.Register(RdDaemonModel.Read, RdDaemonModel.Write);
      serializers.Register(DocumentVersion.Read, DocumentVersion.Write);
      serializers.Register(NotCalculatedTooltipModel.Read, NotCalculatedTooltipModel.Write);
      serializers.Register(StringTooltipModel.Read, StringTooltipModel.Write);
      serializers.Register(HtmlStringTooltipModel.Read, HtmlStringTooltipModel.Write);
      serializers.Register(TooltipProviderModel.Read, TooltipProviderModel.Write);
      serializers.Register(DefaultHighlighterModel.Read, DefaultHighlighterModel.Write);
      serializers.Register(RdGutterExecutionRequest.Read, RdGutterExecutionRequest.Write);
      serializers.Register(GutterMarkActionModel.Read, GutterMarkActionModel.Write);
      serializers.Register(GutterMarkHighlighterModel.Read, GutterMarkHighlighterModel.Write);
      serializers.Register(CustomStyleHighlighterModel.Read, CustomStyleHighlighterModel.Write);
      serializers.Register(FoldingHighlighterModel.Read, FoldingHighlighterModel.Write);
      serializers.RegisterEnum<LineMarkerRendererSide>();
      serializers.RegisterEnum<MouseButtonKind>();
      serializers.Register(SimpleLineMarkerHighlighterModel.Read, SimpleLineMarkerHighlighterModel.Write);
      serializers.Register(LineMarkerHighlighterModel.Read, LineMarkerHighlighterModel.Write);
      serializers.Register(LineMarkerActionEvent.Read, LineMarkerActionEvent.Write);
      serializers.Register(LineMarkerActionModel.Read, LineMarkerActionModel.Write);
      serializers.Register(HighlighterList.Read, HighlighterList.Write);
      serializers.Register(HighlighterIdList.Read, HighlighterIdList.Write);
      serializers.Register(MarkupDumpInfo.Read, MarkupDumpInfo.Write);
      serializers.Register(RdEmptyMarkupModel.Read, RdEmptyMarkupModel.Write);
      serializers.Register(RdMarkupModel.Read, RdMarkupModel.Write);
      serializers.Register(MarkupDiagnostics.Read, MarkupDiagnostics.Write);
      serializers.Register(AutoPopupResult.Read, AutoPopupResult.Write);
      serializers.Register(CustomLookup.Read, CustomLookup.Write);
      serializers.Register(LastFocusedTextControl.Read, LastFocusedTextControl.Write);
      serializers.RegisterEnum<SandboxLanguage>();
      serializers.Register(SandboxInfo.Read, SandboxInfo.Write);
      serializers.Register(EditableEntity.Read, EditableEntity.Write);
      serializers.Register(RdCommandProcessor.Read, RdCommandProcessor.Write);
      serializers.Register(EditableEntityCollection.Read, EditableEntityCollection.Write);
      serializers.Register(PopupActionModel.Read, PopupActionModel.Write);
      serializers.Register(ActionPopupSession.Read, ActionPopupSession.Write);
      serializers.Register(RdFileToOpen.Read, RdFileToOpen.Write);
      serializers.Register(RdExistingSolution.Read, RdExistingSolution.Write);
      serializers.Register(RdVirtualSolution.Read, RdVirtualSolution.Write);
      serializers.Register(RdOpenSolution.Read, RdOpenSolution.Write);
      serializers.Register(RdOpenSolutionAndPostprocess.Read, RdOpenSolutionAndPostprocess.Write);
      serializers.Register(RdOpenSolutionAndCollectProjectModelChanges.Read, RdOpenSolutionAndCollectProjectModelChanges.Write);
      serializers.Register(SolutionExplorerNavigation.Read, SolutionExplorerNavigation.Write);
      serializers.Register(SolutionLifecycle.Read, SolutionLifecycle.Write);
      serializers.Register(RdCustomData.Read, RdCustomData.Write);
      serializers.RegisterEnum<GatewayState>();
      serializers.Register(RdTextEditingGateway.Read, RdTextEditingGateway.Write);
      serializers.Register(Solution.Read, Solution.Write);
      serializers.RegisterEnum<RdMakeWritableResultKind>();
      serializers.Register(MakeWritableRequest.Read, MakeWritableRequest.Write);
      serializers.Register(MakeWritableResponse.Read, MakeWritableResponse.Write);
      serializers.RegisterEnum<CompletionItemType>();
      serializers.RegisterEnum<ScoringHint>();
      serializers.Register(AdvancedPresentation.Read, AdvancedPresentation.Write);
      serializers.RegisterEnum<FocusBehaviour>();
      serializers.RegisterEnum<SessionState>();
      serializers.Register(Range.Read, Range.Write);
      serializers.RegisterEnum<ShouldBeShown>();
      serializers.Register(CompletionTuple.Read, CompletionTuple.Write);
      serializers.Register(CommandDescriptor.Read, CommandDescriptor.Write);
      serializers.Register(TextControlTuple.Read, TextControlTuple.Write);
      serializers.Register(LoadResult.Read, LoadResult.Write);
      serializers.Register(DaemonModel.Read, DaemonModel.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public SolutionModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionModel (");
      using (printer.IndentCookie()) {
        printer.Print("solutions = "); _Solutions.PrintEx(printer); printer.Println();
        printer.Print("hasBackedSolution = "); _HasBackedSolution.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionPopupSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<PopupActionModel> PopupAction { get { return _PopupAction; }}
    
    //private fields
    [NotNull] private readonly RdProperty<PopupActionModel> _PopupAction;
    
    //primary constructor
    private ActionPopupSession(
      [NotNull] RdProperty<PopupActionModel> popupAction
    )
    {
      if (popupAction == null) throw new ArgumentNullException("popupAction");
      
      _PopupAction = popupAction;
      _PopupAction.OptimizeNested = true;
      _PopupAction.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("popupAction", _PopupAction));
    }
    //secondary constructor
    public ActionPopupSession (
    ) : this (
      new RdProperty<PopupActionModel>(ReadPopupActionModelNullable, WritePopupActionModelNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionPopupSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var popupAction = RdProperty<PopupActionModel>.Read(ctx, reader, ReadPopupActionModelNullable, WritePopupActionModelNullable);
      return new ActionPopupSession(popupAction).WithId(_id);
    };
    public static CtxReadDelegate<PopupActionModel> ReadPopupActionModelNullable = PopupActionModel.Read.NullableClass();
    
    public static CtxWriteDelegate<ActionPopupSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<PopupActionModel>.Write(ctx, writer, value._PopupAction);
    };
    public static CtxWriteDelegate<PopupActionModel> WritePopupActionModelNullable = PopupActionModel.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionPopupSession (");
      using (printer.IndentCookie()) {
        printer.Print("popupAction = "); _PopupAction.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AdvancedPresentation : IPrintable, IEquatable<AdvancedPresentation> {
    //fields
    //public fields
    public int Id {get; private set;}
    [CanBeNull] public ModelRichText DisplayName {get; private set;}
    [CanBeNull] public string ReturnType {get; private set;}
    
    //private fields
    //primary constructor
    public AdvancedPresentation(
      int id,
      [CanBeNull] ModelRichText displayName,
      [CanBeNull] string returnType
    )
    {
      Id = id;
      DisplayName = displayName;
      ReturnType = returnType;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AdvancedPresentation> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var displayName = ReadModelRichTextNullable(ctx, reader);
      var returnType = ReadStringNullable(ctx, reader);
      return new AdvancedPresentation(id, displayName, returnType);
    };
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<AdvancedPresentation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      WriteModelRichTextNullable(ctx, writer, value.DisplayName);
      WriteStringNullable(ctx, writer, value.ReturnType);
    };
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AdvancedPresentation) obj);
    }
    public bool Equals(AdvancedPresentation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(DisplayName, other.DisplayName) && Equals(ReturnType, other.ReturnType);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + (DisplayName != null ?DisplayName.GetHashCode() : 0);
        hash = hash * 31 + (ReturnType != null ?ReturnType.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AdvancedPresentation (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("returnType = "); ReturnType.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AutoPopupResult : IPrintable, IEquatable<AutoPopupResult> {
    //fields
    //public fields
    public JetBrains.Rider.Model.ShouldBeShown ShouldBeShown {get; private set;}
    public int TypingTimeStamp {get; private set;}
    
    //private fields
    //primary constructor
    public AutoPopupResult(
      JetBrains.Rider.Model.ShouldBeShown shouldBeShown,
      int typingTimeStamp
    )
    {
      ShouldBeShown = shouldBeShown;
      TypingTimeStamp = typingTimeStamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AutoPopupResult> Read = (ctx, reader) => 
    {
      var shouldBeShown = (JetBrains.Rider.Model.ShouldBeShown)reader.ReadInt();
      var typingTimeStamp = reader.ReadInt();
      return new AutoPopupResult(shouldBeShown, typingTimeStamp);
    };
    
    public static CtxWriteDelegate<AutoPopupResult> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.ShouldBeShown);
      writer.Write(value.TypingTimeStamp);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AutoPopupResult) obj);
    }
    public bool Equals(AutoPopupResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ShouldBeShown == other.ShouldBeShown && TypingTimeStamp == other.TypingTimeStamp;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) ShouldBeShown;
        hash = hash * 31 + TypingTimeStamp.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AutoPopupResult (");
      using (printer.IndentCookie()) {
        printer.Print("shouldBeShown = "); ShouldBeShown.PrintEx(printer); printer.Println();
        printer.Print("typingTimeStamp = "); TypingTimeStamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CommandDescriptor : IPrintable, IEquatable<CommandDescriptor> {
    //fields
    //public fields
    [NotNull] public string Name {get; private set;}
    public bool IsNavigation {get; private set;}
    public bool IsTypingPostProcessor {get; private set;}
    
    //private fields
    //primary constructor
    public CommandDescriptor(
      [NotNull] string name,
      bool isNavigation,
      bool isTypingPostProcessor
    )
    {
      if (name == null) throw new ArgumentNullException("name");
      
      Name = name;
      IsNavigation = isNavigation;
      IsTypingPostProcessor = isTypingPostProcessor;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CommandDescriptor> Read = (ctx, reader) => 
    {
      var name = reader.ReadString();
      var isNavigation = reader.ReadBool();
      var isTypingPostProcessor = reader.ReadBool();
      return new CommandDescriptor(name, isNavigation, isTypingPostProcessor);
    };
    
    public static CtxWriteDelegate<CommandDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Name);
      writer.Write(value.IsNavigation);
      writer.Write(value.IsTypingPostProcessor);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CommandDescriptor) obj);
    }
    public bool Equals(CommandDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Name == other.Name && IsNavigation == other.IsNavigation && IsTypingPostProcessor == other.IsTypingPostProcessor;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + IsNavigation.GetHashCode();
        hash = hash * 31 + IsTypingPostProcessor.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CommandDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("isNavigation = "); IsNavigation.PrintEx(printer); printer.Println();
        printer.Print("isTypingPostProcessor = "); IsTypingPostProcessor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompleteData : IPrintable, IEquatable<CompleteData> {
    //fields
    //public fields
    [NotNull] public CompletionItem Item {get; private set;}
    public char TypedChar {get; private set;}
    
    //private fields
    //primary constructor
    public CompleteData(
      [NotNull] CompletionItem item,
      char typedChar
    )
    {
      if (item == null) throw new ArgumentNullException("item");
      
      Item = item;
      TypedChar = typedChar;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompleteData> Read = (ctx, reader) => 
    {
      var item = CompletionItem.Read(ctx, reader);
      var typedChar = reader.ReadChar();
      return new CompleteData(item, typedChar);
    };
    
    public static CtxWriteDelegate<CompleteData> Write = (ctx, writer, value) => 
    {
      CompletionItem.Write(ctx, writer, value.Item);
      writer.Write(value.TypedChar);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompleteData) obj);
    }
    public bool Equals(CompleteData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Item, other.Item) && TypedChar == other.TypedChar;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Item.GetHashCode();
        hash = hash * 31 + TypedChar.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompleteData (");
      using (printer.IndentCookie()) {
        printer.Print("item = "); Item.PrintEx(printer); printer.Println();
        printer.Print("typedChar = "); TypedChar.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionItem : IPrintable, IEquatable<CompletionItem> {
    //fields
    //public fields
    [NotNull] public string ShortText {get; private set;}
    [CanBeNull] public ModelRichText DisplayName {get; private set;}
    [CanBeNull] public string TypeName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int Id {get; private set;}
    public long Priority {get; private set;}
    public CompletionItemType ItemType {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.ScoringHint? ScoringHint {get; private set;}
    [CanBeNull] public string Prefix {get; private set;}
    
    //private fields
    //primary constructor
    public CompletionItem(
      [NotNull] string shortText,
      [CanBeNull] ModelRichText displayName,
      [CanBeNull] string typeName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      int id,
      long priority,
      CompletionItemType itemType,
      [CanBeNull] JetBrains.Rider.Model.ScoringHint? scoringHint,
      [CanBeNull] string prefix
    )
    {
      if (shortText == null) throw new ArgumentNullException("shortText");
      
      ShortText = shortText;
      DisplayName = displayName;
      TypeName = typeName;
      Icon = icon;
      Id = id;
      Priority = priority;
      ItemType = itemType;
      ScoringHint = scoringHint;
      Prefix = prefix;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompletionItem> Read = (ctx, reader) => 
    {
      var shortText = reader.ReadString();
      var displayName = ReadModelRichTextNullable(ctx, reader);
      var typeName = ReadStringNullable(ctx, reader);
      var icon = ReadIconNullable(ctx, reader);
      var id = reader.ReadInt();
      var priority = reader.ReadLong();
      var itemType = (CompletionItemType)reader.ReadInt();
      var scoringHint = ReadScoringHintNullable(ctx, reader);
      var prefix = ReadStringNullable(ctx, reader);
      return new CompletionItem(shortText, displayName, typeName, icon, id, priority, itemType, scoringHint, prefix);
    };
    public static CtxReadDelegate<ModelRichText> ReadModelRichTextNullable = ModelRichText.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<JetBrains.Rider.Model.ScoringHint?> ReadScoringHintNullable = new CtxReadDelegate<JetBrains.Rider.Model.ScoringHint>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.ScoringHint>).NullableStruct();
    
    public static CtxWriteDelegate<CompletionItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ShortText);
      WriteModelRichTextNullable(ctx, writer, value.DisplayName);
      WriteStringNullable(ctx, writer, value.TypeName);
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write(value.Id);
      writer.Write(value.Priority);
      writer.Write((int)value.ItemType);
      WriteScoringHintNullable(ctx, writer, value.ScoringHint);
      WriteStringNullable(ctx, writer, value.Prefix);
    };
    public static CtxWriteDelegate<ModelRichText> WriteModelRichTextNullable = ModelRichText.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<JetBrains.Rider.Model.ScoringHint?> WriteScoringHintNullable = new CtxWriteDelegate<JetBrains.Rider.Model.ScoringHint>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.ScoringHint>).NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompletionItem) obj);
    }
    public bool Equals(CompletionItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ShortText == other.ShortText && Equals(DisplayName, other.DisplayName) && Equals(TypeName, other.TypeName) && Equals(Icon, other.Icon) && Id == other.Id && Priority == other.Priority && ItemType == other.ItemType && Equals(ScoringHint, other.ScoringHint) && Equals(Prefix, other.Prefix);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ShortText.GetHashCode();
        hash = hash * 31 + (DisplayName != null ?DisplayName.GetHashCode() : 0);
        hash = hash * 31 + (TypeName != null ?TypeName.GetHashCode() : 0);
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + Priority.GetHashCode();
        hash = hash * 31 + (int) ItemType;
        hash = hash * 31 + (ScoringHint != null ?(int) ScoringHint : 0);
        hash = hash * 31 + (Prefix != null ?Prefix.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("shortText = "); ShortText.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("typeName = "); TypeName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
        printer.Print("itemType = "); ItemType.PrintEx(printer); printer.Println();
        printer.Print("scoringHint = "); ScoringHint.PrintEx(printer); printer.Println();
        printer.Print("prefix = "); Prefix.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum CompletionItemType {
    Default,
    TemplateItem
  }
  
  
  public class CompletionList : IPrintable, IEquatable<CompletionList> {
    //fields
    //public fields
    [NotNull] public List<CompletionItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public CompletionList(
      [NotNull] List<CompletionItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompletionList> Read = (ctx, reader) => 
    {
      var items = ReadCompletionItemList(ctx, reader);
      return new CompletionList(items);
    };
    public static CtxReadDelegate<List<CompletionItem>> ReadCompletionItemList = CompletionItem.Read.List();
    
    public static CtxWriteDelegate<CompletionList> Write = (ctx, writer, value) => 
    {
      WriteCompletionItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<CompletionItem>> WriteCompletionItemList = CompletionItem.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CompletionList) obj);
    }
    public bool Equals(CompletionList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum CompletionMode {
    Basic,
    Smart,
    Import
  }
  
  
  public class CompletionParameters : RdBindableBase {
    //fields
    //public fields
    public CompletionMode Mode {get; private set;}
    public bool IsAutoCompletion {get; private set;}
    public int Offset {get; private set;}
    
    //private fields
    //primary constructor
    public CompletionParameters(
      CompletionMode mode,
      bool isAutoCompletion,
      int offset
    )
    {
      Mode = mode;
      IsAutoCompletion = isAutoCompletion;
      Offset = offset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CompletionParameters> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var mode = (CompletionMode)reader.ReadInt();
      var isAutoCompletion = reader.ReadBool();
      var offset = reader.ReadInt();
      return new CompletionParameters(mode, isAutoCompletion, offset).WithId(_id);
    };
    
    public static CtxWriteDelegate<CompletionParameters> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.Mode);
      writer.Write(value.IsAutoCompletion);
      writer.Write(value.Offset);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionParameters (");
      using (printer.IndentCookie()) {
        printer.Print("mode = "); Mode.PrintEx(printer); printer.Println();
        printer.Print("isAutoCompletion = "); IsAutoCompletion.PrintEx(printer); printer.Println();
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionSessionModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISource<CompletionList> LightCompletionItems { get { return _LightCompletionItems; }}
    [NotNull] public ISource<CompletionList> AdvancedItems { get { return _AdvancedItems; }}
    [NotNull] public ISource<FocusBehaviour> IsSoft { get { return _IsSoft; }}
    [NotNull] public IRdProperty<bool> ItemsContainer { get { return _ItemsContainer; }}
    [NotNull] public ISource<JetBrains.Rider.Model.SessionState> SessionState { get { return _SessionState; }}
    [NotNull] public RdEndpoint<CompleteData, bool> Complete { get { return _Complete; }}
    [NotNull] public RdEndpoint<ItemsToUpdate, ToUpdate> UpdatePresentation { get { return _UpdatePresentation; }}
    [NotNull] public RdEndpoint<int, LookupSummaryInfo> GetSummaryInfoById { get { return _GetSummaryInfoById; }}
    
    //private fields
    [NotNull] private readonly RdSignal<CompletionList> _LightCompletionItems;
    [NotNull] private readonly RdSignal<CompletionList> _AdvancedItems;
    [NotNull] private readonly RdSignal<FocusBehaviour> _IsSoft;
    [NotNull] private readonly RdProperty<bool> _ItemsContainer;
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.SessionState> _SessionState;
    [NotNull] private readonly RdEndpoint<CompleteData, bool> _Complete;
    [NotNull] private readonly RdEndpoint<ItemsToUpdate, ToUpdate> _UpdatePresentation;
    [NotNull] private readonly RdEndpoint<int, LookupSummaryInfo> _GetSummaryInfoById;
    
    //primary constructor
    private CompletionSessionModel(
      [NotNull] RdSignal<CompletionList> lightCompletionItems,
      [NotNull] RdSignal<CompletionList> advancedItems,
      [NotNull] RdSignal<FocusBehaviour> isSoft,
      [NotNull] RdProperty<bool> itemsContainer,
      [NotNull] RdSignal<JetBrains.Rider.Model.SessionState> sessionState,
      [NotNull] RdEndpoint<CompleteData, bool> complete,
      [NotNull] RdEndpoint<ItemsToUpdate, ToUpdate> updatePresentation,
      [NotNull] RdEndpoint<int, LookupSummaryInfo> getSummaryInfoById
    )
    {
      if (lightCompletionItems == null) throw new ArgumentNullException("lightCompletionItems");
      if (advancedItems == null) throw new ArgumentNullException("advancedItems");
      if (isSoft == null) throw new ArgumentNullException("isSoft");
      if (itemsContainer == null) throw new ArgumentNullException("itemsContainer");
      if (sessionState == null) throw new ArgumentNullException("sessionState");
      if (complete == null) throw new ArgumentNullException("complete");
      if (updatePresentation == null) throw new ArgumentNullException("updatePresentation");
      if (getSummaryInfoById == null) throw new ArgumentNullException("getSummaryInfoById");
      
      _LightCompletionItems = lightCompletionItems;
      _AdvancedItems = advancedItems;
      _IsSoft = isSoft;
      _ItemsContainer = itemsContainer;
      _SessionState = sessionState;
      _Complete = complete;
      _UpdatePresentation = updatePresentation;
      _GetSummaryInfoById = getSummaryInfoById;
      _ItemsContainer.OptimizeNested = true;
      _LightCompletionItems.Async = true;
      _AdvancedItems.Async = true;
      _IsSoft.Async = true;
      _SessionState.Async = true;
      _Complete.ValueCanBeNull = true;
      _GetSummaryInfoById.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("lightCompletionItems", _LightCompletionItems));
      BindableChildren.Add(new KeyValuePair<string, object>("advancedItems", _AdvancedItems));
      BindableChildren.Add(new KeyValuePair<string, object>("isSoft", _IsSoft));
      BindableChildren.Add(new KeyValuePair<string, object>("itemsContainer", _ItemsContainer));
      BindableChildren.Add(new KeyValuePair<string, object>("sessionState", _SessionState));
      BindableChildren.Add(new KeyValuePair<string, object>("complete", _Complete));
      BindableChildren.Add(new KeyValuePair<string, object>("updatePresentation", _UpdatePresentation));
      BindableChildren.Add(new KeyValuePair<string, object>("getSummaryInfoById", _GetSummaryInfoById));
    }
    //secondary constructor
    public CompletionSessionModel (
    ) : this (
      new RdSignal<CompletionList>(CompletionList.Read, CompletionList.Write),
      new RdSignal<CompletionList>(CompletionList.Read, CompletionList.Write),
      new RdSignal<FocusBehaviour>(ReadFocusBehaviour, WriteFocusBehaviour),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<JetBrains.Rider.Model.SessionState>(ReadSessionState, WriteSessionState),
      new RdEndpoint<CompleteData, bool>(ReadCompleteDataNullable, WriteCompleteDataNullable, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<ItemsToUpdate, ToUpdate>(ItemsToUpdate.Read, ItemsToUpdate.Write, ToUpdate.Read, ToUpdate.Write),
      new RdEndpoint<int, LookupSummaryInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadLookupSummaryInfoNullable, WriteLookupSummaryInfoNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<CompletionSessionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var lightCompletionItems = RdSignal<CompletionList>.Read(ctx, reader, CompletionList.Read, CompletionList.Write);
      var advancedItems = RdSignal<CompletionList>.Read(ctx, reader, CompletionList.Read, CompletionList.Write);
      var isSoft = RdSignal<FocusBehaviour>.Read(ctx, reader, ReadFocusBehaviour, WriteFocusBehaviour);
      var itemsContainer = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var sessionState = RdSignal<JetBrains.Rider.Model.SessionState>.Read(ctx, reader, ReadSessionState, WriteSessionState);
      var complete = RdEndpoint<CompleteData, bool>.Read(ctx, reader, ReadCompleteDataNullable, WriteCompleteDataNullable, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var updatePresentation = RdEndpoint<ItemsToUpdate, ToUpdate>.Read(ctx, reader, ItemsToUpdate.Read, ItemsToUpdate.Write, ToUpdate.Read, ToUpdate.Write);
      var getSummaryInfoById = RdEndpoint<int, LookupSummaryInfo>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, ReadLookupSummaryInfoNullable, WriteLookupSummaryInfoNullable);
      return new CompletionSessionModel(lightCompletionItems, advancedItems, isSoft, itemsContainer, sessionState, complete, updatePresentation, getSummaryInfoById).WithId(_id);
    };
    public static CtxReadDelegate<FocusBehaviour> ReadFocusBehaviour = new CtxReadDelegate<FocusBehaviour>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<FocusBehaviour>);
    public static CtxReadDelegate<JetBrains.Rider.Model.SessionState> ReadSessionState = new CtxReadDelegate<JetBrains.Rider.Model.SessionState>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.SessionState>);
    public static CtxReadDelegate<CompleteData> ReadCompleteDataNullable = CompleteData.Read.NullableClass();
    public static CtxReadDelegate<LookupSummaryInfo> ReadLookupSummaryInfoNullable = LookupSummaryInfo.Read.NullableClass();
    
    public static CtxWriteDelegate<CompletionSessionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<CompletionList>.Write(ctx, writer, value._LightCompletionItems);
      RdSignal<CompletionList>.Write(ctx, writer, value._AdvancedItems);
      RdSignal<FocusBehaviour>.Write(ctx, writer, value._IsSoft);
      RdProperty<bool>.Write(ctx, writer, value._ItemsContainer);
      RdSignal<JetBrains.Rider.Model.SessionState>.Write(ctx, writer, value._SessionState);
      RdEndpoint<CompleteData, bool>.Write(ctx, writer, value._Complete);
      RdEndpoint<ItemsToUpdate, ToUpdate>.Write(ctx, writer, value._UpdatePresentation);
      RdEndpoint<int, LookupSummaryInfo>.Write(ctx, writer, value._GetSummaryInfoById);
    };
    public static CtxWriteDelegate<FocusBehaviour> WriteFocusBehaviour = new CtxWriteDelegate<FocusBehaviour>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<FocusBehaviour>);
    public static CtxWriteDelegate<JetBrains.Rider.Model.SessionState> WriteSessionState = new CtxWriteDelegate<JetBrains.Rider.Model.SessionState>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.SessionState>);
    public static CtxWriteDelegate<CompleteData> WriteCompleteDataNullable = CompleteData.Write.NullableClass();
    public static CtxWriteDelegate<LookupSummaryInfo> WriteLookupSummaryInfoNullable = LookupSummaryInfo.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionSessionModel (");
      using (printer.IndentCookie()) {
        printer.Print("lightCompletionItems = "); _LightCompletionItems.PrintEx(printer); printer.Println();
        printer.Print("advancedItems = "); _AdvancedItems.PrintEx(printer); printer.Println();
        printer.Print("isSoft = "); _IsSoft.PrintEx(printer); printer.Println();
        printer.Print("itemsContainer = "); _ItemsContainer.PrintEx(printer); printer.Println();
        printer.Print("sessionState = "); _SessionState.PrintEx(printer); printer.Println();
        printer.Print("complete = "); _Complete.PrintEx(printer); printer.Println();
        printer.Print("updatePresentation = "); _UpdatePresentation.PrintEx(printer); printer.Println();
        printer.Print("getSummaryInfoById = "); _GetSummaryInfoById.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CompletionTuple : RdBindableBase {
    //fields
    //public fields
    [NotNull] public CompletionParameters Parameters {get; private set;}
    [NotNull] public CompletionSessionModel Session {get; private set;}
    
    //private fields
    //primary constructor
    private CompletionTuple(
      [NotNull] CompletionParameters parameters,
      [NotNull] CompletionSessionModel session
    )
    {
      if (parameters == null) throw new ArgumentNullException("parameters");
      if (session == null) throw new ArgumentNullException("session");
      
      Parameters = parameters;
      Session = session;
      BindableChildren.Add(new KeyValuePair<string, object>("parameters", Parameters));
      BindableChildren.Add(new KeyValuePair<string, object>("session", Session));
    }
    //secondary constructor
    public CompletionTuple (
      [NotNull] CompletionParameters parameters
    ) : this (
      parameters,
      new CompletionSessionModel()
    ) {}
    //statics
    
    public static CtxReadDelegate<CompletionTuple> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var parameters = CompletionParameters.Read(ctx, reader);
      var session = CompletionSessionModel.Read(ctx, reader);
      return new CompletionTuple(parameters, session).WithId(_id);
    };
    
    public static CtxWriteDelegate<CompletionTuple> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      CompletionParameters.Write(ctx, writer, value.Parameters);
      CompletionSessionModel.Write(ctx, writer, value.Session);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("CompletionTuple (");
      using (printer.IndentCookie()) {
        printer.Print("parameters = "); Parameters.PrintEx(printer); printer.Println();
        printer.Print("session = "); Session.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomLookup : IPrintable, IEquatable<CustomLookup> {
    //fields
    //public fields
    [NotNull] public List<string> LookupItems {get; private set;}
    
    //private fields
    //primary constructor
    public CustomLookup(
      [NotNull] List<string> lookupItems
    )
    {
      if (lookupItems == null) throw new ArgumentNullException("lookupItems");
      
      LookupItems = lookupItems;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<CustomLookup> Read = (ctx, reader) => 
    {
      var lookupItems = ReadStringList(ctx, reader);
      return new CustomLookup(lookupItems);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<CustomLookup> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.LookupItems);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomLookup) obj);
    }
    public bool Equals(CustomLookup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LookupItems.SequenceEqual(other.LookupItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(LookupItems);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomLookup (");
      using (printer.IndentCookie()) {
        printer.Print("lookupItems = "); LookupItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomStyleHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes LightAttributes {get; private set;}
    [NotNull] public JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes DarkAttributes {get; private set;}
    
    //private fields
    //primary constructor
    public CustomStyleHighlighterModel(
      [NotNull] JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes lightAttributes,
      [NotNull] JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes darkAttributes,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (lightAttributes == null) throw new ArgumentNullException("lightAttributes");
      if (darkAttributes == null) throw new ArgumentNullException("darkAttributes");
      
      LightAttributes = lightAttributes;
      DarkAttributes = darkAttributes;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<CustomStyleHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var lightAttributes = JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes.Read(ctx, reader);
      var darkAttributes = JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes.Read(ctx, reader);
      return new CustomStyleHighlighterModel(lightAttributes, darkAttributes, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<CustomStyleHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes.Write(ctx, writer, value.LightAttributes);
      JetBrains.Rider.Model.HighlighterRegistration.IdeaTextAttributes.Write(ctx, writer, value.DarkAttributes);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomStyleHighlighterModel) obj);
    }
    public bool Equals(CustomStyleHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(LightAttributes, other.LightAttributes) && Equals(DarkAttributes, other.DarkAttributes) && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + LightAttributes.GetHashCode();
        hash = hash * 31 + DarkAttributes.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomStyleHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("lightAttributes = "); LightAttributes.PrintEx(printer); printer.Println();
        printer.Print("darkAttributes = "); DarkAttributes.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DaemonModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISink<RdVoid> InvalidateAll { get { return _InvalidateAll; }}
    [NotNull] public IRdProperty<bool> IsSuspended { get { return _IsSuspended; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _InvalidateAll;
    [NotNull] private readonly RdProperty<bool> _IsSuspended;
    
    //primary constructor
    private DaemonModel(
      [NotNull] RdSignal<RdVoid> invalidateAll,
      [NotNull] RdProperty<bool> isSuspended
    )
    {
      if (invalidateAll == null) throw new ArgumentNullException("invalidateAll");
      if (isSuspended == null) throw new ArgumentNullException("isSuspended");
      
      _InvalidateAll = invalidateAll;
      _IsSuspended = isSuspended;
      _IsSuspended.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("invalidateAll", _InvalidateAll));
      BindableChildren.Add(new KeyValuePair<string, object>("isSuspended", _IsSuspended));
    }
    //secondary constructor
    public DaemonModel (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<DaemonModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var invalidateAll = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var isSuspended = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new DaemonModel(invalidateAll, isSuspended).WithId(_id);
    };
    
    public static CtxWriteDelegate<DaemonModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._InvalidateAll);
      RdProperty<bool>.Write(ctx, writer, value._IsSuspended);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DaemonModel (");
      using (printer.IndentCookie()) {
        printer.Print("invalidateAll = "); _InvalidateAll.PrintEx(printer); printer.Println();
        printer.Print("isSuspended = "); _IsSuspended.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DefaultHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public DefaultHighlighterModel(
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<DefaultHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new DefaultHighlighterModel(layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<DefaultHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DefaultHighlighterModel) obj);
    }
    public bool Equals(DefaultHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DefaultHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DocOffsetAndVirtualModel : IPrintable, IEquatable<DocOffsetAndVirtualModel> {
    //fields
    //public fields
    public int Offset {get; private set;}
    public int VirtualDelta {get; private set;}
    
    //private fields
    //primary constructor
    public DocOffsetAndVirtualModel(
      int offset,
      int virtualDelta
    )
    {
      Offset = offset;
      VirtualDelta = virtualDelta;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DocOffsetAndVirtualModel> Read = (ctx, reader) => 
    {
      var offset = reader.ReadInt();
      var virtualDelta = reader.ReadInt();
      return new DocOffsetAndVirtualModel(offset, virtualDelta);
    };
    
    public static CtxWriteDelegate<DocOffsetAndVirtualModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Offset);
      writer.Write(value.VirtualDelta);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DocOffsetAndVirtualModel) obj);
    }
    public bool Equals(DocOffsetAndVirtualModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Offset == other.Offset && VirtualDelta == other.VirtualDelta;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Offset.GetHashCode();
        hash = hash * 31 + VirtualDelta.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DocOffsetAndVirtualModel (");
      using (printer.IndentCookie()) {
        printer.Print("offset = "); Offset.PrintEx(printer); printer.Println();
        printer.Print("virtualDelta = "); VirtualDelta.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DocumentVersion : IPrintable, IEquatable<DocumentVersion> {
    //fields
    //public fields
    public int Master {get; private set;}
    public int Slave {get; private set;}
    
    //private fields
    //primary constructor
    public DocumentVersion(
      int master,
      int slave
    )
    {
      Master = master;
      Slave = slave;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<DocumentVersion> Read = (ctx, reader) => 
    {
      var master = reader.ReadInt();
      var slave = reader.ReadInt();
      return new DocumentVersion(master, slave);
    };
    
    public static CtxWriteDelegate<DocumentVersion> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Master);
      writer.Write(value.Slave);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((DocumentVersion) obj);
    }
    public bool Equals(DocumentVersion other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Master == other.Master && Slave == other.Slave;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Master.GetHashCode();
        hash = hash * 31 + Slave.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("DocumentVersion (");
      using (printer.IndentCookie()) {
        printer.Print("master = "); Master.PrintEx(printer); printer.Println();
        printer.Print("slave = "); Slave.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntity : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<TextControlId, TextControlModel> TextControls { get { return _TextControls; }}
    [NotNull] public JetBrains.Platform.RdFramework.Text.Impl.RdTextBuffer Text { get { return _Text; }}
    [NotNull] public IRdProperty<RdMarkupModelBase> Markup { get { return _Markup; }}
    [NotNull] public RdEndpoint<string, bool> CompareAllTextTask { get { return _CompareAllTextTask; }}
    [CanBeNull] public JetBrains.Rider.Model.SandboxInfo SandboxInfo {get; private set;}
    
    //private fields
    [NotNull] private readonly RdMap<TextControlId, TextControlModel> _TextControls;
    [NotNull] private readonly JetBrains.Platform.RdFramework.Text.Impl.RdTextBuffer _Text;
    [NotNull] private readonly RdProperty<RdMarkupModelBase> _Markup;
    [NotNull] private readonly RdEndpoint<string, bool> _CompareAllTextTask;
    
    //primary constructor
    private EditableEntity(
      [NotNull] RdMap<TextControlId, TextControlModel> textControls,
      [NotNull] JetBrains.Platform.RdFramework.Text.Impl.RdTextBuffer text,
      [NotNull] RdProperty<RdMarkupModelBase> markup,
      [NotNull] RdEndpoint<string, bool> compareAllTextTask,
      [CanBeNull] JetBrains.Rider.Model.SandboxInfo sandboxInfo
    )
    {
      if (textControls == null) throw new ArgumentNullException("textControls");
      if (text == null) throw new ArgumentNullException("text");
      if (markup == null) throw new ArgumentNullException("markup");
      if (compareAllTextTask == null) throw new ArgumentNullException("compareAllTextTask");
      
      _TextControls = textControls;
      _Text = text;
      _Markup = markup;
      _CompareAllTextTask = compareAllTextTask;
      SandboxInfo = sandboxInfo;
      BindableChildren.Add(new KeyValuePair<string, object>("textControls", _TextControls));
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("markup", _Markup));
      BindableChildren.Add(new KeyValuePair<string, object>("compareAllTextTask", _CompareAllTextTask));
      BindableChildren.Add(new KeyValuePair<string, object>("sandboxInfo", SandboxInfo));
    }
    //secondary constructor
    public EditableEntity (
      [CanBeNull] JetBrains.Rider.Model.SandboxInfo sandboxInfo
    ) : this (
      new RdMap<TextControlId, TextControlModel>(TextControlId.Read, TextControlId.Write, TextControlModel.Read, TextControlModel.Write),
      new JetBrains.Platform.RdFramework.Text.Impl.RdTextBuffer(),
      new RdProperty<RdMarkupModelBase>(RdMarkupModelBase.Read, RdMarkupModelBase.Write),
      new RdEndpoint<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      sandboxInfo
    ) {}
    //statics
    
    public static CtxReadDelegate<EditableEntity> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var textControls = RdMap<TextControlId, TextControlModel>.Read(ctx, reader, TextControlId.Read, TextControlId.Write, TextControlModel.Read, TextControlModel.Write);
      var text = new JetBrains.Platform.RdFramework.Text.Impl.RdTextBuffer(JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferState.Read(ctx, reader));
      var markup = RdProperty<RdMarkupModelBase>.Read(ctx, reader, RdMarkupModelBase.Read, RdMarkupModelBase.Write);
      var compareAllTextTask = RdEndpoint<string, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var sandboxInfo = ReadSandboxInfoNullable(ctx, reader);
      return new EditableEntity(textControls, text, markup, compareAllTextTask, sandboxInfo).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.SandboxInfo> ReadSandboxInfoNullable = JetBrains.Rider.Model.SandboxInfo.Read.NullableClass();
    
    public static CtxWriteDelegate<EditableEntity> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdMap<TextControlId, TextControlModel>.Write(ctx, writer, value._TextControls);
      JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferState.Write(ctx, writer, value._Text.Delegate);
      RdProperty<RdMarkupModelBase>.Write(ctx, writer, value._Markup);
      RdEndpoint<string, bool>.Write(ctx, writer, value._CompareAllTextTask);
      WriteSandboxInfoNullable(ctx, writer, value.SandboxInfo);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.SandboxInfo> WriteSandboxInfoNullable = JetBrains.Rider.Model.SandboxInfo.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntity (");
      using (printer.IndentCookie()) {
        printer.Print("textControls = "); _TextControls.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("markup = "); _Markup.PrintEx(printer); printer.Println();
        printer.Print("compareAllTextTask = "); _CompareAllTextTask.PrintEx(printer); printer.Println();
        printer.Print("sandboxInfo = "); SandboxInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntityCollection : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<TextControlId> FocusedTextControlSession { get { return _FocusedTextControlSession; }}
    [NotNull] public IRdProperty<TextControlTuple> LastFocusedTextControlSession { get { return _LastFocusedTextControlSession; }}
    [NotNull] public ISink<FrontendTextControl> CheckInternalState { get { return _CheckInternalState; }}
    [NotNull] public RdEndpoint<bool, string> DumpBackendTextControls { get { return _DumpBackendTextControls; }}
    [NotNull] public IViewableMap<EditableEntityId, EditableEntity> Documents { get { return _Documents; }}
    [NotNull] public ISource<EditableEntityId> NeedRecover { get { return _NeedRecover; }}
    [NotNull] public IRdProperty<bool> CommittingTransaction { get { return _CommittingTransaction; }}
    [NotNull] public RdCommandProcessor CommandProcessor {get; private set;}
    [NotNull] public IRdCall<bool, bool> SaveAllEditors { get { return _SaveAllEditors; }}
    [NotNull] public IRdCall<string, bool> SaveFile { get { return _SaveFile; }}
    [NotNull] public IViewableMap<int, string> DoNotStripFiles { get { return _DoNotStripFiles; }}
    [NotNull] public ISink<EditableEntityId> AfterDocumentInEditorSaved { get { return _AfterDocumentInEditorSaved; }}
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] public IRdSignal<RdVoid> ResetCompletionStatistics { get { return _ResetCompletionStatistics; }}
    
    //private fields
    [NotNull] private readonly RdProperty<TextControlId> _FocusedTextControlSession;
    [NotNull] private readonly RdProperty<TextControlTuple> _LastFocusedTextControlSession;
    [NotNull] private readonly RdSignal<FrontendTextControl> _CheckInternalState;
    [NotNull] private readonly RdEndpoint<bool, string> _DumpBackendTextControls;
    [NotNull] private readonly RdMap<EditableEntityId, EditableEntity> _Documents;
    [NotNull] private readonly RdSignal<EditableEntityId> _NeedRecover;
    [NotNull] private readonly RdProperty<bool> _CommittingTransaction;
    [NotNull] private readonly RdCall<bool, bool> _SaveAllEditors;
    [NotNull] private readonly RdCall<string, bool> _SaveFile;
    [NotNull] private readonly RdMap<int, string> _DoNotStripFiles;
    [NotNull] private readonly RdSignal<EditableEntityId> _AfterDocumentInEditorSaved;
    [NotNull] private readonly RdProperty<bool> _IsReady;
    [NotNull] private readonly RdSignal<RdVoid> _ResetCompletionStatistics;
    
    //primary constructor
    private EditableEntityCollection(
      [NotNull] RdProperty<TextControlId> focusedTextControlSession,
      [NotNull] RdProperty<TextControlTuple> lastFocusedTextControlSession,
      [NotNull] RdSignal<FrontendTextControl> checkInternalState,
      [NotNull] RdEndpoint<bool, string> dumpBackendTextControls,
      [NotNull] RdMap<EditableEntityId, EditableEntity> documents,
      [NotNull] RdSignal<EditableEntityId> needRecover,
      [NotNull] RdProperty<bool> committingTransaction,
      [NotNull] RdCommandProcessor commandProcessor,
      [NotNull] RdCall<bool, bool> saveAllEditors,
      [NotNull] RdCall<string, bool> saveFile,
      [NotNull] RdMap<int, string> doNotStripFiles,
      [NotNull] RdSignal<EditableEntityId> afterDocumentInEditorSaved,
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdSignal<RdVoid> resetCompletionStatistics
    )
    {
      if (focusedTextControlSession == null) throw new ArgumentNullException("focusedTextControlSession");
      if (lastFocusedTextControlSession == null) throw new ArgumentNullException("lastFocusedTextControlSession");
      if (checkInternalState == null) throw new ArgumentNullException("checkInternalState");
      if (dumpBackendTextControls == null) throw new ArgumentNullException("dumpBackendTextControls");
      if (documents == null) throw new ArgumentNullException("documents");
      if (needRecover == null) throw new ArgumentNullException("needRecover");
      if (committingTransaction == null) throw new ArgumentNullException("committingTransaction");
      if (commandProcessor == null) throw new ArgumentNullException("commandProcessor");
      if (saveAllEditors == null) throw new ArgumentNullException("saveAllEditors");
      if (saveFile == null) throw new ArgumentNullException("saveFile");
      if (doNotStripFiles == null) throw new ArgumentNullException("doNotStripFiles");
      if (afterDocumentInEditorSaved == null) throw new ArgumentNullException("afterDocumentInEditorSaved");
      if (isReady == null) throw new ArgumentNullException("isReady");
      if (resetCompletionStatistics == null) throw new ArgumentNullException("resetCompletionStatistics");
      
      _FocusedTextControlSession = focusedTextControlSession;
      _LastFocusedTextControlSession = lastFocusedTextControlSession;
      _CheckInternalState = checkInternalState;
      _DumpBackendTextControls = dumpBackendTextControls;
      _Documents = documents;
      _NeedRecover = needRecover;
      _CommittingTransaction = committingTransaction;
      CommandProcessor = commandProcessor;
      _SaveAllEditors = saveAllEditors;
      _SaveFile = saveFile;
      _DoNotStripFiles = doNotStripFiles;
      _AfterDocumentInEditorSaved = afterDocumentInEditorSaved;
      _IsReady = isReady;
      _ResetCompletionStatistics = resetCompletionStatistics;
      _FocusedTextControlSession.OptimizeNested = true;
      _CommittingTransaction.OptimizeNested = true;
      _DoNotStripFiles.OptimizeNested = true;
      _IsReady.OptimizeNested = true;
      _LastFocusedTextControlSession.Async = true;
      _FocusedTextControlSession.ValueCanBeNull = true;
      _LastFocusedTextControlSession.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("focusedTextControlSession", _FocusedTextControlSession));
      BindableChildren.Add(new KeyValuePair<string, object>("lastFocusedTextControlSession", _LastFocusedTextControlSession));
      BindableChildren.Add(new KeyValuePair<string, object>("checkInternalState", _CheckInternalState));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpBackendTextControls", _DumpBackendTextControls));
      BindableChildren.Add(new KeyValuePair<string, object>("documents", _Documents));
      BindableChildren.Add(new KeyValuePair<string, object>("needRecover", _NeedRecover));
      BindableChildren.Add(new KeyValuePair<string, object>("committingTransaction", _CommittingTransaction));
      BindableChildren.Add(new KeyValuePair<string, object>("commandProcessor", CommandProcessor));
      BindableChildren.Add(new KeyValuePair<string, object>("saveAllEditors", _SaveAllEditors));
      BindableChildren.Add(new KeyValuePair<string, object>("saveFile", _SaveFile));
      BindableChildren.Add(new KeyValuePair<string, object>("doNotStripFiles", _DoNotStripFiles));
      BindableChildren.Add(new KeyValuePair<string, object>("afterDocumentInEditorSaved", _AfterDocumentInEditorSaved));
      BindableChildren.Add(new KeyValuePair<string, object>("isReady", _IsReady));
      BindableChildren.Add(new KeyValuePair<string, object>("resetCompletionStatistics", _ResetCompletionStatistics));
    }
    //secondary constructor
    public EditableEntityCollection (
    ) : this (
      new RdProperty<TextControlId>(ReadTextControlIdNullable, WriteTextControlIdNullable),
      new RdProperty<TextControlTuple>(ReadTextControlTupleNullable, WriteTextControlTupleNullable),
      new RdSignal<FrontendTextControl>(FrontendTextControl.Read, FrontendTextControl.Write),
      new RdEndpoint<bool, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdMap<EditableEntityId, EditableEntity>(EditableEntityId.Read, EditableEntityId.Write, EditableEntity.Read, EditableEntity.Write),
      new RdSignal<EditableEntityId>(EditableEntityId.Read, EditableEntityId.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdCommandProcessor(),
      new RdCall<bool, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdCall<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdMap<int, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<EditableEntityId>(EditableEntityId.Read, EditableEntityId.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, false),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<EditableEntityCollection> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var focusedTextControlSession = RdProperty<TextControlId>.Read(ctx, reader, ReadTextControlIdNullable, WriteTextControlIdNullable);
      var lastFocusedTextControlSession = RdProperty<TextControlTuple>.Read(ctx, reader, ReadTextControlTupleNullable, WriteTextControlTupleNullable);
      var checkInternalState = RdSignal<FrontendTextControl>.Read(ctx, reader, FrontendTextControl.Read, FrontendTextControl.Write);
      var dumpBackendTextControls = RdEndpoint<bool, string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var documents = RdMap<EditableEntityId, EditableEntity>.Read(ctx, reader, EditableEntityId.Read, EditableEntityId.Write, EditableEntity.Read, EditableEntity.Write);
      var needRecover = RdSignal<EditableEntityId>.Read(ctx, reader, EditableEntityId.Read, EditableEntityId.Write);
      var committingTransaction = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var commandProcessor = RdCommandProcessor.Read(ctx, reader);
      var saveAllEditors = RdCall<bool, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var saveFile = RdCall<string, bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var doNotStripFiles = RdMap<int, string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var afterDocumentInEditorSaved = RdSignal<EditableEntityId>.Read(ctx, reader, EditableEntityId.Read, EditableEntityId.Write);
      var isReady = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var resetCompletionStatistics = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new EditableEntityCollection(focusedTextControlSession, lastFocusedTextControlSession, checkInternalState, dumpBackendTextControls, documents, needRecover, committingTransaction, commandProcessor, saveAllEditors, saveFile, doNotStripFiles, afterDocumentInEditorSaved, isReady, resetCompletionStatistics).WithId(_id);
    };
    public static CtxReadDelegate<TextControlId> ReadTextControlIdNullable = TextControlId.Read.NullableClass();
    public static CtxReadDelegate<TextControlTuple> ReadTextControlTupleNullable = TextControlTuple.Read.NullableClass();
    
    public static CtxWriteDelegate<EditableEntityCollection> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<TextControlId>.Write(ctx, writer, value._FocusedTextControlSession);
      RdProperty<TextControlTuple>.Write(ctx, writer, value._LastFocusedTextControlSession);
      RdSignal<FrontendTextControl>.Write(ctx, writer, value._CheckInternalState);
      RdEndpoint<bool, string>.Write(ctx, writer, value._DumpBackendTextControls);
      RdMap<EditableEntityId, EditableEntity>.Write(ctx, writer, value._Documents);
      RdSignal<EditableEntityId>.Write(ctx, writer, value._NeedRecover);
      RdProperty<bool>.Write(ctx, writer, value._CommittingTransaction);
      RdCommandProcessor.Write(ctx, writer, value.CommandProcessor);
      RdCall<bool, bool>.Write(ctx, writer, value._SaveAllEditors);
      RdCall<string, bool>.Write(ctx, writer, value._SaveFile);
      RdMap<int, string>.Write(ctx, writer, value._DoNotStripFiles);
      RdSignal<EditableEntityId>.Write(ctx, writer, value._AfterDocumentInEditorSaved);
      RdProperty<bool>.Write(ctx, writer, value._IsReady);
      RdSignal<RdVoid>.Write(ctx, writer, value._ResetCompletionStatistics);
    };
    public static CtxWriteDelegate<TextControlId> WriteTextControlIdNullable = TextControlId.Write.NullableClass();
    public static CtxWriteDelegate<TextControlTuple> WriteTextControlTupleNullable = TextControlTuple.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityCollection (");
      using (printer.IndentCookie()) {
        printer.Print("focusedTextControlSession = "); _FocusedTextControlSession.PrintEx(printer); printer.Println();
        printer.Print("lastFocusedTextControlSession = "); _LastFocusedTextControlSession.PrintEx(printer); printer.Println();
        printer.Print("checkInternalState = "); _CheckInternalState.PrintEx(printer); printer.Println();
        printer.Print("dumpBackendTextControls = "); _DumpBackendTextControls.PrintEx(printer); printer.Println();
        printer.Print("documents = "); _Documents.PrintEx(printer); printer.Println();
        printer.Print("needRecover = "); _NeedRecover.PrintEx(printer); printer.Println();
        printer.Print("committingTransaction = "); _CommittingTransaction.PrintEx(printer); printer.Println();
        printer.Print("commandProcessor = "); CommandProcessor.PrintEx(printer); printer.Println();
        printer.Print("saveAllEditors = "); _SaveAllEditors.PrintEx(printer); printer.Println();
        printer.Print("saveFile = "); _SaveFile.PrintEx(printer); printer.Println();
        printer.Print("doNotStripFiles = "); _DoNotStripFiles.PrintEx(printer); printer.Println();
        printer.Print("afterDocumentInEditorSaved = "); _AfterDocumentInEditorSaved.PrintEx(printer); printer.Println();
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("resetCompletionStatistics = "); _ResetCompletionStatistics.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditableEntityId : IPrintable, IEquatable<EditableEntityId> {
    //fields
    //public fields
    public int ProjectModelElementId {get; private set;}
    [NotNull] public string FilePath {get; private set;}
    
    //private fields
    //primary constructor
    public EditableEntityId(
      int projectModelElementId,
      [NotNull] string filePath
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      ProjectModelElementId = projectModelElementId;
      FilePath = filePath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditableEntityId> Read = (ctx, reader) => 
    {
      var projectModelElementId = reader.ReadInt();
      var filePath = reader.ReadString();
      return new EditableEntityId(projectModelElementId, filePath);
    };
    
    public static CtxWriteDelegate<EditableEntityId> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectModelElementId);
      writer.Write(value.FilePath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((EditableEntityId) obj);
    }
    public bool Equals(EditableEntityId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectModelElementId == other.ProjectModelElementId && FilePath == other.FilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectModelElementId.GetHashCode();
        hash = hash * 31 + FilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("EditableEntityId (");
      using (printer.IndentCookie()) {
        printer.Print("projectModelElementId = "); ProjectModelElementId.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ErrorStripeIndicatorModel : IPrintable, IEquatable<ErrorStripeIndicatorModel> {
    //fields
    //public fields
    public ErrorStripeIndicatorStateEnum State {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    
    //private fields
    //primary constructor
    public ErrorStripeIndicatorModel(
      ErrorStripeIndicatorStateEnum state,
      [CanBeNull] string message
    )
    {
      State = state;
      Message = message;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ErrorStripeIndicatorModel> Read = (ctx, reader) => 
    {
      var state = (ErrorStripeIndicatorStateEnum)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      return new ErrorStripeIndicatorModel(state, message);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<ErrorStripeIndicatorModel> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
      WriteStringNullable(ctx, writer, value.Message);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ErrorStripeIndicatorModel) obj);
    }
    public bool Equals(ErrorStripeIndicatorModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State && Equals(Message, other.Message);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ErrorStripeIndicatorModel (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ErrorStripeIndicatorStateEnum {
    HIDDEN,
    OFF,
    INVALID,
    WORKING,
    ON
  }
  
  
  public enum FocusBehaviour {
    Soft,
    SoftWhenEmpty,
    Hard
  }
  
  
  public class FoldingHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    [NotNull] public string PlaceholderText {get; private set;}
    public bool CollapsedByDefault {get; private set;}
    
    //private fields
    //primary constructor
    public FoldingHighlighterModel(
      [NotNull] string placeholderText,
      bool collapsedByDefault,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (placeholderText == null) throw new ArgumentNullException("placeholderText");
      
      PlaceholderText = placeholderText;
      CollapsedByDefault = collapsedByDefault;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<FoldingHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var placeholderText = reader.ReadString();
      var collapsedByDefault = reader.ReadBool();
      return new FoldingHighlighterModel(placeholderText, collapsedByDefault, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<FoldingHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.PlaceholderText);
      writer.Write(value.CollapsedByDefault);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FoldingHighlighterModel) obj);
    }
    public bool Equals(FoldingHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return PlaceholderText == other.PlaceholderText && CollapsedByDefault == other.CollapsedByDefault && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + PlaceholderText.GetHashCode();
        hash = hash * 31 + CollapsedByDefault.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FoldingHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("placeholderText = "); PlaceholderText.PrintEx(printer); printer.Println();
        printer.Print("collapsedByDefault = "); CollapsedByDefault.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class FrontendTextControl : IPrintable, IEquatable<FrontendTextControl> {
    //fields
    //public fields
    [NotNull] public TextControlId Id {get; private set;}
    [NotNull] public TextControlSnapshot FrontendState {get; private set;}
    
    //private fields
    //primary constructor
    public FrontendTextControl(
      [NotNull] TextControlId id,
      [NotNull] TextControlSnapshot frontendState
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (frontendState == null) throw new ArgumentNullException("frontendState");
      
      Id = id;
      FrontendState = frontendState;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<FrontendTextControl> Read = (ctx, reader) => 
    {
      var id = TextControlId.Read(ctx, reader);
      var frontendState = TextControlSnapshot.Read(ctx, reader);
      return new FrontendTextControl(id, frontendState);
    };
    
    public static CtxWriteDelegate<FrontendTextControl> Write = (ctx, writer, value) => 
    {
      TextControlId.Write(ctx, writer, value.Id);
      TextControlSnapshot.Write(ctx, writer, value.FrontendState);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((FrontendTextControl) obj);
    }
    public bool Equals(FrontendTextControl other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Id, other.Id) && Equals(FrontendState, other.FrontendState);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + FrontendState.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("FrontendTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("frontendState = "); FrontendState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum GatewayState {
    BothSides,
    ClosedToBackend,
    SyncFromBackend
  }
  
  
  public class GutterMarkActionModel : MarkupModelExtension
   {
    //fields
    //public fields
    [NotNull] public ISink<RdGutterExecutionRequest> LeftClick { get { return _LeftClick; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdGutterExecutionRequest> _LeftClick;
    
    //primary constructor
    private GutterMarkActionModel(
      [NotNull] RdSignal<RdGutterExecutionRequest> leftClick,
      [NotNull] string key
    ) : base (
      key
     ) 
    {
      if (leftClick == null) throw new ArgumentNullException("leftClick");
      
      _LeftClick = leftClick;
      BindableChildren.Add(new KeyValuePair<string, object>("leftClick", _LeftClick));
    }
    //secondary constructor
    public GutterMarkActionModel (
      [NotNull] string key
    ) : this (
      new RdSignal<RdGutterExecutionRequest>(RdGutterExecutionRequest.Read, RdGutterExecutionRequest.Write),
      key
    ) {}
    //statics
    
    public static new CtxReadDelegate<GutterMarkActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      var leftClick = RdSignal<RdGutterExecutionRequest>.Read(ctx, reader, RdGutterExecutionRequest.Read, RdGutterExecutionRequest.Write);
      return new GutterMarkActionModel(leftClick, key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<GutterMarkActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
      RdSignal<RdGutterExecutionRequest>.Write(ctx, writer, value._LeftClick);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GutterMarkActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("leftClick = "); _LeftClick.PrintEx(printer); printer.Println();
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GutterMarkHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<long> Priority {get; private set;}
    [CanBeNull] public string Tooltip {get; private set;}
    public bool IsNavigatable {get; private set;}
    
    //private fields
    //primary constructor
    public GutterMarkHighlighterModel(
      [NotNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<long> priority,
      [CanBeNull] string tooltip,
      bool isNavigatable,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (icon == null) throw new ArgumentNullException("icon");
      if (priority == null) throw new ArgumentNullException("priority");
      
      Icon = icon;
      Priority = priority;
      Tooltip = tooltip;
      IsNavigatable = isNavigatable;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<GutterMarkHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var priority = ReadLongList(ctx, reader);
      var tooltip = ReadStringNullable(ctx, reader);
      var isNavigatable = reader.ReadBool();
      return new GutterMarkHighlighterModel(icon, priority, tooltip, isNavigatable, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<List<long>> ReadLongList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<GutterMarkHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      WriteLongList(ctx, writer, value.Priority);
      WriteStringNullable(ctx, writer, value.Tooltip);
      writer.Write(value.IsNavigatable);
    };
    public static CtxWriteDelegate<List<long>> WriteLongList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((GutterMarkHighlighterModel) obj);
    }
    public bool Equals(GutterMarkHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Icon, other.Icon) && Priority.SequenceEqual(other.Priority) && Equals(Tooltip, other.Tooltip) && IsNavigatable == other.IsNavigatable && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Icon.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(Priority);
        hash = hash * 31 + (Tooltip != null ?Tooltip.GetHashCode() : 0);
        hash = hash * 31 + IsNavigatable.GetHashCode();
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("GutterMarkHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("priority = "); Priority.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("isNavigatable = "); IsNavigatable.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HighlighterIdList : IPrintable, IEquatable<HighlighterIdList> {
    //fields
    //public fields
    [NotNull] public List<long> Elements {get; private set;}
    
    //private fields
    //primary constructor
    public HighlighterIdList(
      [NotNull] List<long> elements
    )
    {
      if (elements == null) throw new ArgumentNullException("elements");
      
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HighlighterIdList> Read = (ctx, reader) => 
    {
      var elements = ReadLongList(ctx, reader);
      return new HighlighterIdList(elements);
    };
    public static CtxReadDelegate<List<long>> ReadLongList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong.List();
    
    public static CtxWriteDelegate<HighlighterIdList> Write = (ctx, writer, value) => 
    {
      WriteLongList(ctx, writer, value.Elements);
    };
    public static CtxWriteDelegate<List<long>> WriteLongList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterIdList) obj);
    }
    public bool Equals(HighlighterIdList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Elements);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterIdList (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HighlighterList : IPrintable, IEquatable<HighlighterList> {
    //fields
    //public fields
    [NotNull] public List<HighlighterModel> Elements {get; private set;}
    
    //private fields
    //primary constructor
    public HighlighterList(
      [NotNull] List<HighlighterModel> elements
    )
    {
      if (elements == null) throw new ArgumentNullException("elements");
      
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HighlighterList> Read = (ctx, reader) => 
    {
      var elements = ReadHighlighterModelList(ctx, reader);
      return new HighlighterList(elements);
    };
    public static CtxReadDelegate<List<HighlighterModel>> ReadHighlighterModelList = HighlighterModel.Read.List();
    
    public static CtxWriteDelegate<HighlighterList> Write = (ctx, writer, value) => 
    {
      WriteHighlighterModelList(ctx, writer, value.Elements);
    };
    public static CtxWriteDelegate<List<HighlighterModel>> WriteHighlighterModelList = HighlighterModel.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterList) obj);
    }
    public bool Equals(HighlighterList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Elements);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterList (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class HighlighterModel : LightweightHighlighter
   {
    //fields
    //public fields
    public int Layer {get; private set;}
    public bool IsExactRange {get; private set;}
    [NotNull] public JetBrains.Rider.Model.DocumentVersion DocumentVersion {get; private set;}
    [CanBeNull] public string TextToHighlight {get; private set;}
    
    //private fields
    //primary constructor
    protected HighlighterModel(
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
      if (documentVersion == null) throw new ArgumentNullException("documentVersion");
      
      Layer = layer;
      IsExactRange = isExactRange;
      DocumentVersion = documentVersion;
      TextToHighlight = textToHighlight;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<HighlighterModel> Read = Polymorphic<HighlighterModel>.ReadAbstract(HighlighterModel_Unknown.Read);
    
    public static new CtxWriteDelegate<HighlighterModel> Write = Polymorphic<HighlighterModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class HighlighterModel_Unknown : HighlighterModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public HighlighterModel_Unknown(
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<HighlighterModel_Unknown> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new HighlighterModel_Unknown(layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<HighlighterModel_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlighterModel_Unknown) obj);
    }
    public bool Equals(HighlighterModel_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlighterModel_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class HighlightingSettingsModel : IPrintable, IEquatable<HighlightingSettingsModel> {
    //fields
    //public fields
    public HighlightingSettingsState State {get; private set;}
    
    //private fields
    //primary constructor
    public HighlightingSettingsModel(
      HighlightingSettingsState state
    )
    {
      State = state;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<HighlightingSettingsModel> Read = (ctx, reader) => 
    {
      var state = (HighlightingSettingsState)reader.ReadInt();
      return new HighlightingSettingsModel(state);
    };
    
    public static CtxWriteDelegate<HighlightingSettingsModel> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.State);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HighlightingSettingsModel) obj);
    }
    public bool Equals(HighlightingSettingsModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return State == other.State;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) State;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HighlightingSettingsModel (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum HighlightingSettingsState {
    NONE,
    SYNTAX_ONLY,
    FULL
  }
  
  
  public class HtmlStringTooltipModel : TooltipModel
   {
    //fields
    //public fields
    [CanBeNull] public string HtmlText {get; private set;}
    [CanBeNull] public string Description {get; private set;}
    
    //private fields
    //primary constructor
    public HtmlStringTooltipModel(
      [CanBeNull] string htmlText,
      [CanBeNull] string description
    )
    {
      HtmlText = htmlText;
      Description = description;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<HtmlStringTooltipModel> Read = (ctx, reader) => 
    {
      var htmlText = ReadStringNullable(ctx, reader);
      var description = ReadStringNullable(ctx, reader);
      return new HtmlStringTooltipModel(htmlText, description);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<HtmlStringTooltipModel> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.HtmlText);
      WriteStringNullable(ctx, writer, value.Description);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((HtmlStringTooltipModel) obj);
    }
    public bool Equals(HtmlStringTooltipModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(HtmlText, other.HtmlText) && Equals(Description, other.Description);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (HtmlText != null ?HtmlText.GetHashCode() : 0);
        hash = hash * 31 + (Description != null ?Description.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("HtmlStringTooltipModel (");
      using (printer.IndentCookie()) {
        printer.Print("htmlText = "); HtmlText.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ItemsToUpdate : IPrintable, IEquatable<ItemsToUpdate> {
    //fields
    //public fields
    [NotNull] public List<int> ItemIds {get; private set;}
    
    //private fields
    //primary constructor
    public ItemsToUpdate(
      [NotNull] List<int> itemIds
    )
    {
      if (itemIds == null) throw new ArgumentNullException("itemIds");
      
      ItemIds = itemIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ItemsToUpdate> Read = (ctx, reader) => 
    {
      var itemIds = ReadIntList(ctx, reader);
      return new ItemsToUpdate(itemIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<ItemsToUpdate> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ItemIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ItemsToUpdate) obj);
    }
    public bool Equals(ItemsToUpdate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ItemIds.SequenceEqual(other.ItemIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ItemIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ItemsToUpdate (");
      using (printer.IndentCookie()) {
        printer.Print("itemIds = "); ItemIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LastFocusedTextControl : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<CompletionTuple> CompletionSession { get { return _CompletionSession; }}
    [NotNull] public ISource<JetBrains.Rider.Model.AutoPopupResult> AutoPopupResult { get { return _AutoPopupResult; }}
    [NotNull] public ISource<JetBrains.Rider.Model.CustomLookup> CustomLookup { get { return _CustomLookup; }}
    [NotNull] public IRdProperty<ParameterInfoModel> ParameterInfo { get { return _ParameterInfo; }}
    
    //private fields
    [NotNull] private readonly RdProperty<CompletionTuple> _CompletionSession;
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.AutoPopupResult> _AutoPopupResult;
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.CustomLookup> _CustomLookup;
    [NotNull] private readonly RdProperty<ParameterInfoModel> _ParameterInfo;
    
    //primary constructor
    private LastFocusedTextControl(
      [NotNull] RdProperty<CompletionTuple> completionSession,
      [NotNull] RdSignal<JetBrains.Rider.Model.AutoPopupResult> autoPopupResult,
      [NotNull] RdSignal<JetBrains.Rider.Model.CustomLookup> customLookup,
      [NotNull] RdProperty<ParameterInfoModel> parameterInfo
    )
    {
      if (completionSession == null) throw new ArgumentNullException("completionSession");
      if (autoPopupResult == null) throw new ArgumentNullException("autoPopupResult");
      if (customLookup == null) throw new ArgumentNullException("customLookup");
      if (parameterInfo == null) throw new ArgumentNullException("parameterInfo");
      
      _CompletionSession = completionSession;
      _AutoPopupResult = autoPopupResult;
      _CustomLookup = customLookup;
      _ParameterInfo = parameterInfo;
      _CompletionSession.Async = true;
      _CompletionSession.ValueCanBeNull = true;
      _ParameterInfo.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("completionSession", _CompletionSession));
      BindableChildren.Add(new KeyValuePair<string, object>("autoPopupResult", _AutoPopupResult));
      BindableChildren.Add(new KeyValuePair<string, object>("customLookup", _CustomLookup));
      BindableChildren.Add(new KeyValuePair<string, object>("parameterInfo", _ParameterInfo));
    }
    //secondary constructor
    public LastFocusedTextControl (
    ) : this (
      new RdProperty<CompletionTuple>(ReadCompletionTupleNullable, WriteCompletionTupleNullable),
      new RdSignal<JetBrains.Rider.Model.AutoPopupResult>(JetBrains.Rider.Model.AutoPopupResult.Read, JetBrains.Rider.Model.AutoPopupResult.Write),
      new RdSignal<JetBrains.Rider.Model.CustomLookup>(JetBrains.Rider.Model.CustomLookup.Read, JetBrains.Rider.Model.CustomLookup.Write),
      new RdProperty<ParameterInfoModel>(ReadParameterInfoModelNullable, WriteParameterInfoModelNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<LastFocusedTextControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var completionSession = RdProperty<CompletionTuple>.Read(ctx, reader, ReadCompletionTupleNullable, WriteCompletionTupleNullable);
      var autoPopupResult = RdSignal<JetBrains.Rider.Model.AutoPopupResult>.Read(ctx, reader, JetBrains.Rider.Model.AutoPopupResult.Read, JetBrains.Rider.Model.AutoPopupResult.Write);
      var customLookup = RdSignal<JetBrains.Rider.Model.CustomLookup>.Read(ctx, reader, JetBrains.Rider.Model.CustomLookup.Read, JetBrains.Rider.Model.CustomLookup.Write);
      var parameterInfo = RdProperty<ParameterInfoModel>.Read(ctx, reader, ReadParameterInfoModelNullable, WriteParameterInfoModelNullable);
      return new LastFocusedTextControl(completionSession, autoPopupResult, customLookup, parameterInfo).WithId(_id);
    };
    public static CtxReadDelegate<CompletionTuple> ReadCompletionTupleNullable = CompletionTuple.Read.NullableClass();
    public static CtxReadDelegate<ParameterInfoModel> ReadParameterInfoModelNullable = ParameterInfoModel.Read.NullableClass();
    
    public static CtxWriteDelegate<LastFocusedTextControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<CompletionTuple>.Write(ctx, writer, value._CompletionSession);
      RdSignal<JetBrains.Rider.Model.AutoPopupResult>.Write(ctx, writer, value._AutoPopupResult);
      RdSignal<JetBrains.Rider.Model.CustomLookup>.Write(ctx, writer, value._CustomLookup);
      RdProperty<ParameterInfoModel>.Write(ctx, writer, value._ParameterInfo);
    };
    public static CtxWriteDelegate<CompletionTuple> WriteCompletionTupleNullable = CompletionTuple.Write.NullableClass();
    public static CtxWriteDelegate<ParameterInfoModel> WriteParameterInfoModelNullable = ParameterInfoModel.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LastFocusedTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("completionSession = "); _CompletionSession.PrintEx(printer); printer.Println();
        printer.Print("autoPopupResult = "); _AutoPopupResult.PrintEx(printer); printer.Println();
        printer.Print("customLookup = "); _CustomLookup.PrintEx(printer); printer.Println();
        printer.Print("parameterInfo = "); _ParameterInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class LightweightHighlighter {
    //fields
    //public fields
    public long Id {get; private set;}
    [NotNull] public string AttributeId {get; private set;}
    public int Start {get; private set;}
    public int End {get; private set;}
    
    //private fields
    //primary constructor
    protected LightweightHighlighter(
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    )
    {
      if (attributeId == null) throw new ArgumentNullException("attributeId");
      
      Id = id;
      AttributeId = attributeId;
      Start = start;
      End = end;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LightweightHighlighter> Read = Polymorphic<LightweightHighlighter>.ReadAbstract(LightweightHighlighter_Unknown.Read);
    
    public static CtxWriteDelegate<LightweightHighlighter> Write = Polymorphic<LightweightHighlighter>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class LightweightHighlighter_Unknown : LightweightHighlighter
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public LightweightHighlighter_Unknown(
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      id,
      attributeId,
      start,
      end
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<LightweightHighlighter_Unknown> Read = (ctx, reader) => 
    {
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new LightweightHighlighter_Unknown(id, attributeId, start, end);
    };
    
    public static new CtxWriteDelegate<LightweightHighlighter_Unknown> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LightweightHighlighter_Unknown) obj);
    }
    public bool Equals(LightweightHighlighter_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LightweightHighlighter_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LineMarkerActionEvent : IPrintable, IEquatable<LineMarkerActionEvent> {
    //fields
    //public fields
    public long Id {get; private set;}
    public MouseButtonKind Button {get; private set;}
    
    //private fields
    //primary constructor
    public LineMarkerActionEvent(
      long id,
      MouseButtonKind button
    )
    {
      Id = id;
      Button = button;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LineMarkerActionEvent> Read = (ctx, reader) => 
    {
      var id = reader.ReadLong();
      var button = (MouseButtonKind)reader.ReadInt();
      return new LineMarkerActionEvent(id, button);
    };
    
    public static CtxWriteDelegate<LineMarkerActionEvent> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write((int)value.Button);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LineMarkerActionEvent) obj);
    }
    public bool Equals(LineMarkerActionEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && Button == other.Button;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + (int) Button;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LineMarkerActionEvent (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("button = "); Button.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LineMarkerActionModel : MarkupModelExtension
   {
    //fields
    //public fields
    [NotNull] public ISink<LineMarkerActionEvent> Click { get { return _Click; }}
    
    //private fields
    [NotNull] private readonly RdSignal<LineMarkerActionEvent> _Click;
    
    //primary constructor
    private LineMarkerActionModel(
      [NotNull] RdSignal<LineMarkerActionEvent> click,
      [NotNull] string key
    ) : base (
      key
     ) 
    {
      if (click == null) throw new ArgumentNullException("click");
      
      _Click = click;
      BindableChildren.Add(new KeyValuePair<string, object>("click", _Click));
    }
    //secondary constructor
    public LineMarkerActionModel (
      [NotNull] string key
    ) : this (
      new RdSignal<LineMarkerActionEvent>(LineMarkerActionEvent.Read, LineMarkerActionEvent.Write),
      key
    ) {}
    //statics
    
    public static new CtxReadDelegate<LineMarkerActionModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      var click = RdSignal<LineMarkerActionEvent>.Read(ctx, reader, LineMarkerActionEvent.Read, LineMarkerActionEvent.Write);
      return new LineMarkerActionModel(click, key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<LineMarkerActionModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
      RdSignal<LineMarkerActionEvent>.Write(ctx, writer, value._Click);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LineMarkerActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LineMarkerHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    public int Thickness {get; private set;}
    public LineMarkerRendererSide Side {get; private set;}
    
    //private fields
    //primary constructor
    public LineMarkerHighlighterModel(
      int thickness,
      LineMarkerRendererSide side,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      Thickness = thickness;
      Side = side;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<LineMarkerHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var thickness = reader.ReadInt();
      var side = (LineMarkerRendererSide)reader.ReadInt();
      return new LineMarkerHighlighterModel(thickness, side, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<LineMarkerHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.Thickness);
      writer.Write((int)value.Side);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LineMarkerHighlighterModel) obj);
    }
    public bool Equals(LineMarkerHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Thickness == other.Thickness && Side == other.Side && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Thickness.GetHashCode();
        hash = hash * 31 + (int) Side;
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LineMarkerHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("thickness = "); Thickness.PrintEx(printer); printer.Println();
        printer.Print("side = "); Side.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LineMarkerRendererSide {
    LEFT,
    RIGHT,
    CUSTOM
  }
  
  
  public class LoadResult : RdBindableBase {
    //fields
    //public fields
    public long LoadTime {get; private set;}
    public bool IsCold {get; private set;}
    
    //private fields
    //primary constructor
    public LoadResult(
      long loadTime,
      bool isCold
    )
    {
      LoadTime = loadTime;
      IsCold = isCold;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LoadResult> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var loadTime = reader.ReadLong();
      var isCold = reader.ReadBool();
      return new LoadResult(loadTime, isCold).WithId(_id);
    };
    
    public static CtxWriteDelegate<LoadResult> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.LoadTime);
      writer.Write(value.IsCold);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("LoadResult (");
      using (printer.IndentCookie()) {
        printer.Print("loadTime = "); LoadTime.PrintEx(printer); printer.Println();
        printer.Print("isCold = "); IsCold.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class LookupSummaryInfo : IPrintable, IEquatable<LookupSummaryInfo> {
    //fields
    //public fields
    [NotNull] public List<SummaryInfoItem> Items {get; private set;}
    public bool IsSignature {get; private set;}
    
    //private fields
    //primary constructor
    public LookupSummaryInfo(
      [NotNull] List<SummaryInfoItem> items,
      bool isSignature
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
      IsSignature = isSignature;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<LookupSummaryInfo> Read = (ctx, reader) => 
    {
      var items = ReadSummaryInfoItemList(ctx, reader);
      var isSignature = reader.ReadBool();
      return new LookupSummaryInfo(items, isSignature);
    };
    public static CtxReadDelegate<List<SummaryInfoItem>> ReadSummaryInfoItemList = SummaryInfoItem.Read.List();
    
    public static CtxWriteDelegate<LookupSummaryInfo> Write = (ctx, writer, value) => 
    {
      WriteSummaryInfoItemList(ctx, writer, value.Items);
      writer.Write(value.IsSignature);
    };
    public static CtxWriteDelegate<List<SummaryInfoItem>> WriteSummaryInfoItemList = SummaryInfoItem.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((LookupSummaryInfo) obj);
    }
    public bool Equals(LookupSummaryInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items) && IsSignature == other.IsSignature;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        hash = hash * 31 + IsSignature.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("LookupSummaryInfo (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("isSignature = "); IsSignature.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableRequest : IPrintable, IEquatable<MakeWritableRequest> {
    //fields
    //public fields
    [NotNull] public List<string> Files {get; private set;}
    
    //private fields
    //primary constructor
    public MakeWritableRequest(
      [NotNull] List<string> files
    )
    {
      if (files == null) throw new ArgumentNullException("files");
      
      Files = files;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MakeWritableRequest> Read = (ctx, reader) => 
    {
      var files = ReadStringList(ctx, reader);
      return new MakeWritableRequest(files);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<MakeWritableRequest> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Files);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableRequest) obj);
    }
    public bool Equals(MakeWritableRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Files.SequenceEqual(other.Files);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Files);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableRequest (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MakeWritableResponse : IPrintable, IEquatable<MakeWritableResponse> {
    //fields
    //public fields
    [CanBeNull] public string Message {get; private set;}
    public RdMakeWritableResultKind Result {get; private set;}
    
    //private fields
    //primary constructor
    public MakeWritableResponse(
      [CanBeNull] string message,
      RdMakeWritableResultKind result
    )
    {
      Message = message;
      Result = result;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MakeWritableResponse> Read = (ctx, reader) => 
    {
      var message = ReadStringNullable(ctx, reader);
      var result = (RdMakeWritableResultKind)reader.ReadInt();
      return new MakeWritableResponse(message, result);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<MakeWritableResponse> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Message);
      writer.Write((int)value.Result);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MakeWritableResponse) obj);
    }
    public bool Equals(MakeWritableResponse other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Message, other.Message) && Result == other.Result;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Message != null ?Message.GetHashCode() : 0);
        hash = hash * 31 + (int) Result;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MakeWritableResponse (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MarkupDiagnostics : MarkupModelExtension
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsDebugMode { get { return _IsDebugMode; }}
    [NotNull] public RdEndpoint<int, HighlighterList> DumpAllHighlighters { get { return _DumpAllHighlighters; }}
    [NotNull] public RdEndpoint<int, MarkupDumpInfo> DumpMarkupInfo { get { return _DumpMarkupInfo; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsDebugMode;
    [NotNull] private readonly RdEndpoint<int, HighlighterList> _DumpAllHighlighters;
    [NotNull] private readonly RdEndpoint<int, MarkupDumpInfo> _DumpMarkupInfo;
    
    //primary constructor
    private MarkupDiagnostics(
      [NotNull] RdProperty<bool> isDebugMode,
      [NotNull] RdEndpoint<int, HighlighterList> dumpAllHighlighters,
      [NotNull] RdEndpoint<int, MarkupDumpInfo> dumpMarkupInfo,
      [NotNull] string key
    ) : base (
      key
     ) 
    {
      if (isDebugMode == null) throw new ArgumentNullException("isDebugMode");
      if (dumpAllHighlighters == null) throw new ArgumentNullException("dumpAllHighlighters");
      if (dumpMarkupInfo == null) throw new ArgumentNullException("dumpMarkupInfo");
      
      _IsDebugMode = isDebugMode;
      _DumpAllHighlighters = dumpAllHighlighters;
      _DumpMarkupInfo = dumpMarkupInfo;
      _IsDebugMode.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isDebugMode", _IsDebugMode));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpAllHighlighters", _DumpAllHighlighters));
      BindableChildren.Add(new KeyValuePair<string, object>("dumpMarkupInfo", _DumpMarkupInfo));
    }
    //secondary constructor
    public MarkupDiagnostics (
      [NotNull] string key
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdEndpoint<int, HighlighterList>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, HighlighterList.Read, HighlighterList.Write),
      new RdEndpoint<int, MarkupDumpInfo>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, MarkupDumpInfo.Read, MarkupDumpInfo.Write),
      key
    ) {}
    //statics
    
    public static new CtxReadDelegate<MarkupDiagnostics> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      var isDebugMode = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var dumpAllHighlighters = RdEndpoint<int, HighlighterList>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, HighlighterList.Read, HighlighterList.Write);
      var dumpMarkupInfo = RdEndpoint<int, MarkupDumpInfo>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt, MarkupDumpInfo.Read, MarkupDumpInfo.Write);
      return new MarkupDiagnostics(isDebugMode, dumpAllHighlighters, dumpMarkupInfo, key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<MarkupDiagnostics> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
      RdProperty<bool>.Write(ctx, writer, value._IsDebugMode);
      RdEndpoint<int, HighlighterList>.Write(ctx, writer, value._DumpAllHighlighters);
      RdEndpoint<int, MarkupDumpInfo>.Write(ctx, writer, value._DumpMarkupInfo);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupDiagnostics (");
      using (printer.IndentCookie()) {
        printer.Print("isDebugMode = "); _IsDebugMode.PrintEx(printer); printer.Println();
        printer.Print("dumpAllHighlighters = "); _DumpAllHighlighters.PrintEx(printer); printer.Println();
        printer.Print("dumpMarkupInfo = "); _DumpMarkupInfo.PrintEx(printer); printer.Println();
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MarkupDumpInfo : IPrintable, IEquatable<MarkupDumpInfo> {
    //fields
    //public fields
    [NotNull] public HighlighterIdList AllIds {get; private set;}
    public int HighlighterCounter {get; private set;}
    [NotNull] public DocumentVersion DocumentTimestamp {get; private set;}
    
    //private fields
    //primary constructor
    public MarkupDumpInfo(
      [NotNull] HighlighterIdList allIds,
      int highlighterCounter,
      [NotNull] DocumentVersion documentTimestamp
    )
    {
      if (allIds == null) throw new ArgumentNullException("allIds");
      if (documentTimestamp == null) throw new ArgumentNullException("documentTimestamp");
      
      AllIds = allIds;
      HighlighterCounter = highlighterCounter;
      DocumentTimestamp = documentTimestamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MarkupDumpInfo> Read = (ctx, reader) => 
    {
      var allIds = HighlighterIdList.Read(ctx, reader);
      var highlighterCounter = reader.ReadInt();
      var documentTimestamp = DocumentVersion.Read(ctx, reader);
      return new MarkupDumpInfo(allIds, highlighterCounter, documentTimestamp);
    };
    
    public static CtxWriteDelegate<MarkupDumpInfo> Write = (ctx, writer, value) => 
    {
      HighlighterIdList.Write(ctx, writer, value.AllIds);
      writer.Write(value.HighlighterCounter);
      DocumentVersion.Write(ctx, writer, value.DocumentTimestamp);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MarkupDumpInfo) obj);
    }
    public bool Equals(MarkupDumpInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(AllIds, other.AllIds) && HighlighterCounter == other.HighlighterCounter && Equals(DocumentTimestamp, other.DocumentTimestamp);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AllIds.GetHashCode();
        hash = hash * 31 + HighlighterCounter.GetHashCode();
        hash = hash * 31 + DocumentTimestamp.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupDumpInfo (");
      using (printer.IndentCookie()) {
        printer.Print("allIds = "); AllIds.PrintEx(printer); printer.Println();
        printer.Print("highlighterCounter = "); HighlighterCounter.PrintEx(printer); printer.Println();
        printer.Print("documentTimestamp = "); DocumentTimestamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class MarkupModelExtension : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Key {get; private set;}
    
    //private fields
    //primary constructor
    protected MarkupModelExtension(
      [NotNull] string key
    )
    {
      if (key == null) throw new ArgumentNullException("key");
      
      Key = key;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MarkupModelExtension> Read = Polymorphic<MarkupModelExtension>.ReadAbstract(MarkupModelExtension_Unknown.Read);
    
    public static CtxWriteDelegate<MarkupModelExtension> Write = Polymorphic<MarkupModelExtension>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class MarkupModelExtension_Unknown : MarkupModelExtension
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public MarkupModelExtension_Unknown(
      [NotNull] string key
    ) : base (
      key
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<MarkupModelExtension_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      return new MarkupModelExtension_Unknown(key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<MarkupModelExtension_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MarkupModelExtension_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MouseButtonKind {
    BUTTON1,
    BUTTON2,
    BUTTON3
  }
  
  
  public abstract class Navigation {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Navigation> Read = Polymorphic<Navigation>.ReadAbstract(Navigation_Unknown.Read);
    
    public static CtxWriteDelegate<Navigation> Write = Polymorphic<Navigation>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class Navigation_Unknown : Navigation
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<Navigation_Unknown> Read = (ctx, reader) => 
    {
      return new Navigation_Unknown();
    };
    
    public static new CtxWriteDelegate<Navigation_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Navigation_Unknown) obj);
    }
    public bool Equals(Navigation_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Navigation_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NotCalculatedTooltipModel : TooltipModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NotCalculatedTooltipModel> Read = (ctx, reader) => 
    {
      return new NotCalculatedTooltipModel();
    };
    
    public static new CtxWriteDelegate<NotCalculatedTooltipModel> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((NotCalculatedTooltipModel) obj);
    }
    public bool Equals(NotCalculatedTooltipModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("NotCalculatedTooltipModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum OriginKind {
    Backend,
    Frontend
  }
  
  
  public class ParameterInfoContext : IPrintable, IEquatable<ParameterInfoContext> {
    //fields
    //public fields
    [NotNull] public List<SignatureItem> Items {get; private set;}
    [CanBeNull] public int? MatchedSignature {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Range Range {get; private set;}
    
    //private fields
    //primary constructor
    public ParameterInfoContext(
      [NotNull] List<SignatureItem> items,
      [CanBeNull] int? matchedSignature,
      [NotNull] JetBrains.Rider.Model.Range range
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      if (range == null) throw new ArgumentNullException("range");
      
      Items = items;
      MatchedSignature = matchedSignature;
      Range = range;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ParameterInfoContext> Read = (ctx, reader) => 
    {
      var items = ReadSignatureItemList(ctx, reader);
      var matchedSignature = ReadIntNullable(ctx, reader);
      var range = JetBrains.Rider.Model.Range.Read(ctx, reader);
      return new ParameterInfoContext(items, matchedSignature, range);
    };
    public static CtxReadDelegate<List<SignatureItem>> ReadSignatureItemList = SignatureItem.Read.List();
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<ParameterInfoContext> Write = (ctx, writer, value) => 
    {
      WriteSignatureItemList(ctx, writer, value.Items);
      WriteIntNullable(ctx, writer, value.MatchedSignature);
      JetBrains.Rider.Model.Range.Write(ctx, writer, value.Range);
    };
    public static CtxWriteDelegate<List<SignatureItem>> WriteSignatureItemList = SignatureItem.Write.List();
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ParameterInfoContext) obj);
    }
    public bool Equals(ParameterInfoContext other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items) && Equals(MatchedSignature, other.MatchedSignature) && Equals(Range, other.Range);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        hash = hash * 31 + (MatchedSignature != null ?MatchedSignature.GetHashCode() : 0);
        hash = hash * 31 + Range.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ParameterInfoContext (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
        printer.Print("matchedSignature = "); MatchedSignature.PrintEx(printer); printer.Println();
        printer.Print("range = "); Range.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ParameterInfoModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ParameterInfoContext InitialContext {get; private set;}
    [NotNull] public IRdProperty<ParameterInfoContext> Context { get { return _Context; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ParameterInfoContext> _Context;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private ParameterInfoModel(
      [NotNull] ParameterInfoContext initialContext,
      [NotNull] RdProperty<ParameterInfoContext> context
    )
    {
      if (initialContext == null) throw new ArgumentNullException("initialContext");
      if (context == null) throw new ArgumentNullException("context");
      
      InitialContext = initialContext;
      _Context = context;
      _Context.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("context", _Context));
    }
    //secondary constructor
    public ParameterInfoModel (
      [NotNull] ParameterInfoContext initialContext
    ) : this (
      initialContext,
      new RdProperty<ParameterInfoContext>(ParameterInfoContext.Read, ParameterInfoContext.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<ParameterInfoModel> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var initialContext = ParameterInfoContext.Read(ctx, reader);
      var context = RdProperty<ParameterInfoContext>.Read(ctx, reader, ParameterInfoContext.Read, ParameterInfoContext.Write);
      return new ParameterInfoModel(initialContext, context) { mySerializationContext = ctx }.WithId(_id);
    };
    
    public static CtxWriteDelegate<ParameterInfoModel> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      ParameterInfoContext.Write(ctx, writer, value.InitialContext);
      RdProperty<ParameterInfoContext>.Write(ctx, writer, value._Context);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ParameterInfoModel (");
      using (printer.IndentCookie()) {
        printer.Print("initialContext = "); InitialContext.PrintEx(printer); printer.Println();
        printer.Print("context = "); _Context.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class PopupActionModel : IPrintable, IEquatable<PopupActionModel> {
    //fields
    //public fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    [NotNull] public string Caption {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    [NotNull] public List<JetBrains.Rider.Model.UiContext.ContextPair> Timestamps {get; private set;}
    [NotNull] public JetBrains.Rider.Model.TextControlId TextControlId {get; private set;}
    
    //private fields
    //primary constructor
    public PopupActionModel(
      int startOffset,
      int endOffset,
      [NotNull] string caption,
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] List<JetBrains.Rider.Model.UiContext.ContextPair> timestamps,
      [NotNull] JetBrains.Rider.Model.TextControlId textControlId
    )
    {
      if (caption == null) throw new ArgumentNullException("caption");
      if (timestamps == null) throw new ArgumentNullException("timestamps");
      if (textControlId == null) throw new ArgumentNullException("textControlId");
      
      StartOffset = startOffset;
      EndOffset = endOffset;
      Caption = caption;
      Icon = icon;
      Timestamps = timestamps;
      TextControlId = textControlId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<PopupActionModel> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      var caption = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      var timestamps = ReadContextPairList(ctx, reader);
      var textControlId = JetBrains.Rider.Model.TextControlId.Read(ctx, reader);
      return new PopupActionModel(startOffset, endOffset, caption, icon, timestamps, textControlId);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> ReadContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Read.List();
    
    public static CtxWriteDelegate<PopupActionModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
      writer.Write(value.Caption);
      WriteIconNullable(ctx, writer, value.Icon);
      WriteContextPairList(ctx, writer, value.Timestamps);
      JetBrains.Rider.Model.TextControlId.Write(ctx, writer, value.TextControlId);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<JetBrains.Rider.Model.UiContext.ContextPair>> WriteContextPairList = JetBrains.Rider.Model.UiContext.ContextPair.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((PopupActionModel) obj);
    }
    public bool Equals(PopupActionModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset && Caption == other.Caption && Equals(Icon, other.Icon) && Timestamps.SequenceEqual(other.Timestamps) && Equals(TextControlId, other.TextControlId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        hash = hash * 31 + Caption.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + Collections.GetHashCode(Timestamps);
        hash = hash * 31 + TextControlId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("PopupActionModel (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
        printer.Print("caption = "); Caption.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("timestamps = "); Timestamps.PrintEx(printer); printer.Println();
        printer.Print("textControlId = "); TextControlId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Range : IPrintable, IEquatable<Range> {
    //fields
    //public fields
    public int From {get; private set;}
    public int To {get; private set;}
    
    //private fields
    //primary constructor
    public Range(
      int from,
      int to
    )
    {
      From = from;
      To = to;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<Range> Read = (ctx, reader) => 
    {
      var from = reader.ReadInt();
      var to = reader.ReadInt();
      return new Range(from, to);
    };
    
    public static CtxWriteDelegate<Range> Write = (ctx, writer, value) => 
    {
      writer.Write(value.From);
      writer.Write(value.To);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((Range) obj);
    }
    public bool Equals(Range other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return From == other.From && To == other.To;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + From.GetHashCode();
        hash = hash * 31 + To.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("Range (");
      using (printer.IndentCookie()) {
        printer.Print("from = "); From.PrintEx(printer); printer.Println();
        printer.Print("to = "); To.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCommandProcessor : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<CommandDescriptor> CurrentCommand { get { return _CurrentCommand; }}
    
    //private fields
    [NotNull] private readonly RdProperty<CommandDescriptor> _CurrentCommand;
    
    //primary constructor
    private RdCommandProcessor(
      [NotNull] RdProperty<CommandDescriptor> currentCommand
    )
    {
      if (currentCommand == null) throw new ArgumentNullException("currentCommand");
      
      _CurrentCommand = currentCommand;
      _CurrentCommand.OptimizeNested = true;
      _CurrentCommand.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("currentCommand", _CurrentCommand));
    }
    //secondary constructor
    public RdCommandProcessor (
    ) : this (
      new RdProperty<CommandDescriptor>(ReadCommandDescriptorNullable, WriteCommandDescriptorNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCommandProcessor> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var currentCommand = RdProperty<CommandDescriptor>.Read(ctx, reader, ReadCommandDescriptorNullable, WriteCommandDescriptorNullable);
      return new RdCommandProcessor(currentCommand).WithId(_id);
    };
    public static CtxReadDelegate<CommandDescriptor> ReadCommandDescriptorNullable = CommandDescriptor.Read.NullableClass();
    
    public static CtxWriteDelegate<RdCommandProcessor> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<CommandDescriptor>.Write(ctx, writer, value._CurrentCommand);
    };
    public static CtxWriteDelegate<CommandDescriptor> WriteCommandDescriptorNullable = CommandDescriptor.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCommandProcessor (");
      using (printer.IndentCookie()) {
        printer.Print("currentCommand = "); _CurrentCommand.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdCustomData : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<string, string> Data { get { return _Data; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, string> _Data;
    
    //primary constructor
    private RdCustomData(
      [NotNull] RdMap<string, string> data
    )
    {
      if (data == null) throw new ArgumentNullException("data");
      
      _Data = data;
      _Data.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("data", _Data));
    }
    //secondary constructor
    public RdCustomData (
    ) : this (
      new RdMap<string, string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdCustomData> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var data = RdMap<string, string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdCustomData(data).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdCustomData> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdMap<string, string>.Write(ctx, writer, value._Data);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdCustomData (");
      using (printer.IndentCookie()) {
        printer.Print("data = "); _Data.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDaemonModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<ReSharperDaemonStateEnum> State { get { return _State; }}
    [NotNull] public IRdProperty<HighlightingSettingsModel> Settings { get { return _Settings; }}
    [NotNull] public ISink<RdVoid> Restart { get { return _Restart; }}
    [NotNull] public ISink<RdVoid> InvalidateAll { get { return _InvalidateAll; }}
    
    //private fields
    [NotNull] private readonly RdProperty<ReSharperDaemonStateEnum> _State;
    [NotNull] private readonly RdProperty<HighlightingSettingsModel> _Settings;
    [NotNull] private readonly RdSignal<RdVoid> _Restart;
    [NotNull] private readonly RdSignal<RdVoid> _InvalidateAll;
    
    //primary constructor
    private RdDaemonModel(
      [NotNull] RdProperty<ReSharperDaemonStateEnum> state,
      [NotNull] RdProperty<HighlightingSettingsModel> settings,
      [NotNull] RdSignal<RdVoid> restart,
      [NotNull] RdSignal<RdVoid> invalidateAll
    )
    {
      if (state == null) throw new ArgumentNullException("state");
      if (settings == null) throw new ArgumentNullException("settings");
      if (restart == null) throw new ArgumentNullException("restart");
      if (invalidateAll == null) throw new ArgumentNullException("invalidateAll");
      
      _State = state;
      _Settings = settings;
      _Restart = restart;
      _InvalidateAll = invalidateAll;
      _State.OptimizeNested = true;
      _Settings.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("state", _State));
      BindableChildren.Add(new KeyValuePair<string, object>("settings", _Settings));
      BindableChildren.Add(new KeyValuePair<string, object>("restart", _Restart));
      BindableChildren.Add(new KeyValuePair<string, object>("invalidateAll", _InvalidateAll));
    }
    //secondary constructor
    public RdDaemonModel (
    ) : this (
      new RdProperty<ReSharperDaemonStateEnum>(ReadReSharperDaemonStateEnum, WriteReSharperDaemonStateEnum),
      new RdProperty<HighlightingSettingsModel>(HighlightingSettingsModel.Read, HighlightingSettingsModel.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDaemonModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var state = RdProperty<ReSharperDaemonStateEnum>.Read(ctx, reader, ReadReSharperDaemonStateEnum, WriteReSharperDaemonStateEnum);
      var settings = RdProperty<HighlightingSettingsModel>.Read(ctx, reader, HighlightingSettingsModel.Read, HighlightingSettingsModel.Write);
      var restart = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var invalidateAll = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdDaemonModel(state, settings, restart, invalidateAll).WithId(_id);
    };
    public static CtxReadDelegate<ReSharperDaemonStateEnum> ReadReSharperDaemonStateEnum = new CtxReadDelegate<ReSharperDaemonStateEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ReSharperDaemonStateEnum>);
    
    public static CtxWriteDelegate<RdDaemonModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<ReSharperDaemonStateEnum>.Write(ctx, writer, value._State);
      RdProperty<HighlightingSettingsModel>.Write(ctx, writer, value._Settings);
      RdSignal<RdVoid>.Write(ctx, writer, value._Restart);
      RdSignal<RdVoid>.Write(ctx, writer, value._InvalidateAll);
    };
    public static CtxWriteDelegate<ReSharperDaemonStateEnum> WriteReSharperDaemonStateEnum = new CtxWriteDelegate<ReSharperDaemonStateEnum>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ReSharperDaemonStateEnum>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDaemonModel (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("settings = "); _Settings.PrintEx(printer); printer.Println();
        printer.Print("restart = "); _Restart.PrintEx(printer); printer.Println();
        printer.Print("invalidateAll = "); _InvalidateAll.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdEmptyMarkupModel : RdMarkupModelBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdEmptyMarkupModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new RdEmptyMarkupModel().WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdEmptyMarkupModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdEmptyMarkupModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdExistingSolution : RdSolutionDescription
   {
    //fields
    //public fields
    [NotNull] public string SolutionFilePath {get; private set;}
    
    //private fields
    //primary constructor
    public RdExistingSolution(
      [NotNull] string solutionFilePath
    )
    {
      if (solutionFilePath == null) throw new ArgumentNullException("solutionFilePath");
      
      SolutionFilePath = solutionFilePath;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdExistingSolution> Read = (ctx, reader) => 
    {
      var solutionFilePath = reader.ReadString();
      return new RdExistingSolution(solutionFilePath);
    };
    
    public static new CtxWriteDelegate<RdExistingSolution> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFilePath);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdExistingSolution) obj);
    }
    public bool Equals(RdExistingSolution other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionFilePath == other.SolutionFilePath;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SolutionFilePath.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdExistingSolution (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFilePath = "); SolutionFilePath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdFileToOpen : IPrintable, IEquatable<RdFileToOpen> {
    //fields
    //public fields
    [NotNull] public string Path {get; private set;}
    public int Caret {get; private set;}
    
    //private fields
    //primary constructor
    public RdFileToOpen(
      [NotNull] string path,
      int caret
    )
    {
      if (path == null) throw new ArgumentNullException("path");
      
      Path = path;
      Caret = caret;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdFileToOpen> Read = (ctx, reader) => 
    {
      var path = reader.ReadString();
      var caret = reader.ReadInt();
      return new RdFileToOpen(path, caret);
    };
    
    public static CtxWriteDelegate<RdFileToOpen> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Path);
      writer.Write(value.Caret);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdFileToOpen) obj);
    }
    public bool Equals(RdFileToOpen other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Path == other.Path && Caret == other.Caret;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Path.GetHashCode();
        hash = hash * 31 + Caret.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdFileToOpen (");
      using (printer.IndentCookie()) {
        printer.Print("path = "); Path.PrintEx(printer); printer.Println();
        printer.Print("caret = "); Caret.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdGutterExecutionRequest : IPrintable, IEquatable<RdGutterExecutionRequest> {
    //fields
    //public fields
    public long GutterId {get; private set;}
    public int Start {get; private set;}
    public int End {get; private set;}
    
    //private fields
    //primary constructor
    public RdGutterExecutionRequest(
      long gutterId,
      int start,
      int end
    )
    {
      GutterId = gutterId;
      Start = start;
      End = end;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdGutterExecutionRequest> Read = (ctx, reader) => 
    {
      var gutterId = reader.ReadLong();
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      return new RdGutterExecutionRequest(gutterId, start, end);
    };
    
    public static CtxWriteDelegate<RdGutterExecutionRequest> Write = (ctx, writer, value) => 
    {
      writer.Write(value.GutterId);
      writer.Write(value.Start);
      writer.Write(value.End);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdGutterExecutionRequest) obj);
    }
    public bool Equals(RdGutterExecutionRequest other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return GutterId == other.GutterId && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + GutterId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdGutterExecutionRequest (");
      using (printer.IndentCookie()) {
        printer.Print("gutterId = "); GutterId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdMakeWritableResultKind {
    SUCCESS,
    FAILURE
  }
  
  
  public class RdMarkupModel : RdMarkupModelBase
   {
    //fields
    //public fields
    [NotNull] public ISource<HighlighterList> HighlightersAdded { get { return _HighlightersAdded; }}
    [NotNull] public ISource<HighlighterIdList> HighlightersRemoved { get { return _HighlightersRemoved; }}
    [NotNull] public RdDaemonModel Daemon {get; private set;}
    [NotNull] public List<MarkupModelExtension> Extensions {get; private set;}
    
    //private fields
    [NotNull] private readonly RdSignal<HighlighterList> _HighlightersAdded;
    [NotNull] private readonly RdSignal<HighlighterIdList> _HighlightersRemoved;
    
    private SerializationCtx mySerializationContext;
    public override SerializationCtx SerializationContext { get { return mySerializationContext; } }
    //primary constructor
    private RdMarkupModel(
      [NotNull] RdSignal<HighlighterList> highlightersAdded,
      [NotNull] RdSignal<HighlighterIdList> highlightersRemoved,
      [NotNull] RdDaemonModel daemon,
      [NotNull] List<MarkupModelExtension> extensions
    )
    {
      if (highlightersAdded == null) throw new ArgumentNullException("highlightersAdded");
      if (highlightersRemoved == null) throw new ArgumentNullException("highlightersRemoved");
      if (daemon == null) throw new ArgumentNullException("daemon");
      if (extensions == null) throw new ArgumentNullException("extensions");
      
      _HighlightersAdded = highlightersAdded;
      _HighlightersRemoved = highlightersRemoved;
      Daemon = daemon;
      Extensions = extensions;
      BindableChildren.Add(new KeyValuePair<string, object>("highlightersAdded", _HighlightersAdded));
      BindableChildren.Add(new KeyValuePair<string, object>("highlightersRemoved", _HighlightersRemoved));
      BindableChildren.Add(new KeyValuePair<string, object>("daemon", Daemon));
      BindableChildren.Add(new KeyValuePair<string, object>("extensions", Extensions));
    }
    //secondary constructor
    public RdMarkupModel (
      [NotNull] List<MarkupModelExtension> extensions
    ) : this (
      new RdSignal<HighlighterList>(HighlighterList.Read, HighlighterList.Write),
      new RdSignal<HighlighterIdList>(HighlighterIdList.Read, HighlighterIdList.Write),
      new RdDaemonModel(),
      extensions
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdMarkupModel> Read = (ctx, reader) => 
    {
      ctx = ctx.WithInternRootHere(false);
      var _id = RdId.Read(reader);
      var highlightersAdded = RdSignal<HighlighterList>.Read(ctx, reader, HighlighterList.Read, HighlighterList.Write);
      var highlightersRemoved = RdSignal<HighlighterIdList>.Read(ctx, reader, HighlighterIdList.Read, HighlighterIdList.Write);
      var daemon = RdDaemonModel.Read(ctx, reader);
      var extensions = ReadMarkupModelExtensionList(ctx, reader);
      return new RdMarkupModel(highlightersAdded, highlightersRemoved, daemon, extensions) { mySerializationContext = ctx }.WithId(_id);
    };
    public static CtxReadDelegate<List<MarkupModelExtension>> ReadMarkupModelExtensionList = MarkupModelExtension.Read.List();
    
    public static new CtxWriteDelegate<RdMarkupModel> Write = (ctx, writer, value) => 
    {
      ctx = ctx.WithInternRootHere(true);
      value.mySerializationContext = ctx;
      value.RdId.Write(writer);
      RdSignal<HighlighterList>.Write(ctx, writer, value._HighlightersAdded);
      RdSignal<HighlighterIdList>.Write(ctx, writer, value._HighlightersRemoved);
      RdDaemonModel.Write(ctx, writer, value.Daemon);
      WriteMarkupModelExtensionList(ctx, writer, value.Extensions);
    };
    public static CtxWriteDelegate<List<MarkupModelExtension>> WriteMarkupModelExtensionList = MarkupModelExtension.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMarkupModel (");
      using (printer.IndentCookie()) {
        printer.Print("highlightersAdded = "); _HighlightersAdded.PrintEx(printer); printer.Println();
        printer.Print("highlightersRemoved = "); _HighlightersRemoved.PrintEx(printer); printer.Println();
        printer.Print("daemon = "); Daemon.PrintEx(printer); printer.Println();
        printer.Print("extensions = "); Extensions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdMarkupModelBase : RdBindableBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdMarkupModelBase> Read = Polymorphic<RdMarkupModelBase>.ReadAbstract(RdMarkupModelBase_Unknown.Read);
    
    public static CtxWriteDelegate<RdMarkupModelBase> Write = Polymorphic<RdMarkupModelBase>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdMarkupModelBase_Unknown : RdMarkupModelBase
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdMarkupModelBase_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new RdMarkupModelBase_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdMarkupModelBase_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdMarkupModelBase_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdOpenSolution : RdSolutionOpenStrategy
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public RdOpenSolution(
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    ) : base (
      description,
      restorePackages
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdOpenSolution> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = RdSolutionDescription.Read(ctx, reader);
      var restorePackages = reader.ReadBool();
      return new RdOpenSolution(description, restorePackages).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdOpenSolution> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSolutionDescription.Write(ctx, writer, value.Description);
      writer.Write(value.RestorePackages);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdOpenSolution (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdOpenSolutionAndCollectProjectModelChanges : RdSolutionOpenStrategy
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> ChangesLogFile { get { return _ChangesLogFile; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ChangesLogFile;
    
    //primary constructor
    private RdOpenSolutionAndCollectProjectModelChanges(
      [NotNull] RdProperty<string> changesLogFile,
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    ) : base (
      description,
      restorePackages
     ) 
    {
      if (changesLogFile == null) throw new ArgumentNullException("changesLogFile");
      
      _ChangesLogFile = changesLogFile;
      _ChangesLogFile.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("changesLogFile", _ChangesLogFile));
    }
    //secondary constructor
    public RdOpenSolutionAndCollectProjectModelChanges (
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      description,
      restorePackages
    ) {}
    //statics
    
    public static new CtxReadDelegate<RdOpenSolutionAndCollectProjectModelChanges> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = RdSolutionDescription.Read(ctx, reader);
      var restorePackages = reader.ReadBool();
      var changesLogFile = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdOpenSolutionAndCollectProjectModelChanges(changesLogFile, description, restorePackages).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdOpenSolutionAndCollectProjectModelChanges> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSolutionDescription.Write(ctx, writer, value.Description);
      writer.Write(value.RestorePackages);
      RdProperty<string>.Write(ctx, writer, value._ChangesLogFile);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdOpenSolutionAndCollectProjectModelChanges (");
      using (printer.IndentCookie()) {
        printer.Print("changesLogFile = "); _ChangesLogFile.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdOpenSolutionAndPostprocess : RdSolutionOpenStrategy
   {
    //fields
    //public fields
    [NotNull] public List<RdFileToOpen> FilesToOpen {get; private set;}
    public bool Reformat {get; private set;}
    
    //private fields
    //primary constructor
    public RdOpenSolutionAndPostprocess(
      [NotNull] List<RdFileToOpen> filesToOpen,
      bool reformat,
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    ) : base (
      description,
      restorePackages
     ) 
    {
      if (filesToOpen == null) throw new ArgumentNullException("filesToOpen");
      
      FilesToOpen = filesToOpen;
      Reformat = reformat;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdOpenSolutionAndPostprocess> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = RdSolutionDescription.Read(ctx, reader);
      var restorePackages = reader.ReadBool();
      var filesToOpen = ReadRdFileToOpenList(ctx, reader);
      var reformat = reader.ReadBool();
      return new RdOpenSolutionAndPostprocess(filesToOpen, reformat, description, restorePackages).WithId(_id);
    };
    public static CtxReadDelegate<List<RdFileToOpen>> ReadRdFileToOpenList = RdFileToOpen.Read.List();
    
    public static new CtxWriteDelegate<RdOpenSolutionAndPostprocess> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSolutionDescription.Write(ctx, writer, value.Description);
      writer.Write(value.RestorePackages);
      WriteRdFileToOpenList(ctx, writer, value.FilesToOpen);
      writer.Write(value.Reformat);
    };
    public static CtxWriteDelegate<List<RdFileToOpen>> WriteRdFileToOpenList = RdFileToOpen.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdOpenSolutionAndPostprocess (");
      using (printer.IndentCookie()) {
        printer.Print("filesToOpen = "); FilesToOpen.PrintEx(printer); printer.Println();
        printer.Print("reformat = "); Reformat.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdSolutionDescription {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSolutionDescription> Read = Polymorphic<RdSolutionDescription>.ReadAbstract(RdSolutionDescription_Unknown.Read);
    
    public static CtxWriteDelegate<RdSolutionDescription> Write = Polymorphic<RdSolutionDescription>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdSolutionDescription_Unknown : RdSolutionDescription
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSolutionDescription_Unknown> Read = (ctx, reader) => 
    {
      return new RdSolutionDescription_Unknown();
    };
    
    public static new CtxWriteDelegate<RdSolutionDescription_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdSolutionDescription_Unknown) obj);
    }
    public bool Equals(RdSolutionDescription_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionDescription_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdSolutionOpenStrategy : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdSolutionDescription Description {get; private set;}
    public bool RestorePackages {get; private set;}
    
    //private fields
    //primary constructor
    protected RdSolutionOpenStrategy(
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    )
    {
      if (description == null) throw new ArgumentNullException("description");
      
      Description = description;
      RestorePackages = restorePackages;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdSolutionOpenStrategy> Read = Polymorphic<RdSolutionOpenStrategy>.ReadAbstract(RdSolutionOpenStrategy_Unknown.Read);
    
    public static CtxWriteDelegate<RdSolutionOpenStrategy> Write = Polymorphic<RdSolutionOpenStrategy>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class RdSolutionOpenStrategy_Unknown : RdSolutionOpenStrategy
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public RdSolutionOpenStrategy_Unknown(
      [NotNull] RdSolutionDescription description,
      bool restorePackages
    ) : base (
      description,
      restorePackages
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdSolutionOpenStrategy_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var description = RdSolutionDescription.Read(ctx, reader);
      var restorePackages = reader.ReadBool();
      return new RdSolutionOpenStrategy_Unknown(description, restorePackages).WithId(_id);
    };
    
    public static new CtxWriteDelegate<RdSolutionOpenStrategy_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSolutionDescription.Write(ctx, writer, value.Description);
      writer.Write(value.RestorePackages);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdSolutionOpenStrategy_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("restorePackages = "); RestorePackages.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTextEditingGateway : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.GatewayState> GatewayState { get { return _GatewayState; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.GatewayState> _GatewayState;
    
    //primary constructor
    private RdTextEditingGateway(
      [NotNull] RdProperty<JetBrains.Rider.Model.GatewayState> gatewayState
    )
    {
      if (gatewayState == null) throw new ArgumentNullException("gatewayState");
      
      _GatewayState = gatewayState;
      _GatewayState.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("gatewayState", _GatewayState));
    }
    //secondary constructor
    public RdTextEditingGateway (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.GatewayState>(ReadGatewayState, WriteGatewayState)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdTextEditingGateway> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var gatewayState = RdProperty<JetBrains.Rider.Model.GatewayState>.Read(ctx, reader, ReadGatewayState, WriteGatewayState);
      return new RdTextEditingGateway(gatewayState).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.GatewayState> ReadGatewayState = new CtxReadDelegate<JetBrains.Rider.Model.GatewayState>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<JetBrains.Rider.Model.GatewayState>);
    
    public static CtxWriteDelegate<RdTextEditingGateway> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.GatewayState>.Write(ctx, writer, value._GatewayState);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.GatewayState> WriteGatewayState = new CtxWriteDelegate<JetBrains.Rider.Model.GatewayState>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<JetBrains.Rider.Model.GatewayState>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextEditingGateway (");
      using (printer.IndentCookie()) {
        printer.Print("gatewayState = "); _GatewayState.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTextRange : IPrintable, IEquatable<RdTextRange> {
    //fields
    //public fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //private fields
    //primary constructor
    public RdTextRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTextRange> Read = (ctx, reader) => 
    {
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new RdTextRange(startOffset, endOffset);
    };
    
    public static CtxWriteDelegate<RdTextRange> Write = (ctx, writer, value) => 
    {
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTextRange) obj);
    }
    public bool Equals(RdTextRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return StartOffset == other.StartOffset && EndOffset == other.EndOffset;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + StartOffset.GetHashCode();
        hash = hash * 31 + EndOffset.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTextRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdVirtualSolution : RdSolutionDescription
   {
    //fields
    //public fields
    [NotNull] public string SolutionName {get; private set;}
    [NotNull] public string SolutionDirectory {get; private set;}
    [NotNull] public List<string> ProjectFilePaths {get; private set;}
    
    //private fields
    //primary constructor
    public RdVirtualSolution(
      [NotNull] string solutionName,
      [NotNull] string solutionDirectory,
      [NotNull] List<string> projectFilePaths
    )
    {
      if (solutionName == null) throw new ArgumentNullException("solutionName");
      if (solutionDirectory == null) throw new ArgumentNullException("solutionDirectory");
      if (projectFilePaths == null) throw new ArgumentNullException("projectFilePaths");
      
      SolutionName = solutionName;
      SolutionDirectory = solutionDirectory;
      ProjectFilePaths = projectFilePaths;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdVirtualSolution> Read = (ctx, reader) => 
    {
      var solutionName = reader.ReadString();
      var solutionDirectory = reader.ReadString();
      var projectFilePaths = ReadStringList(ctx, reader);
      return new RdVirtualSolution(solutionName, solutionDirectory, projectFilePaths);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static new CtxWriteDelegate<RdVirtualSolution> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionName);
      writer.Write(value.SolutionDirectory);
      WriteStringList(ctx, writer, value.ProjectFilePaths);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdVirtualSolution) obj);
    }
    public bool Equals(RdVirtualSolution other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionName == other.SolutionName && SolutionDirectory == other.SolutionDirectory && ProjectFilePaths.SequenceEqual(other.ProjectFilePaths);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SolutionName.GetHashCode();
        hash = hash * 31 + SolutionDirectory.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ProjectFilePaths);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdVirtualSolution (");
      using (printer.IndentCookie()) {
        printer.Print("solutionName = "); SolutionName.PrintEx(printer); printer.Println();
        printer.Print("solutionDirectory = "); SolutionDirectory.PrintEx(printer); printer.Println();
        printer.Print("projectFilePaths = "); ProjectFilePaths.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ReSharperDaemonStateEnum {
    HIDDEN,
    UNSUPPORTED,
    DISABLED,
    INVALIDATED,
    IN_PROGRESS_LOCAL,
    IN_PROGRESS_GLOBAL,
    UP_TO_DATE
  }
  
  
  public class SandboxInfo : RdBindableBase {
    //fields
    //public fields
    [CanBeNull] public EditableEntityId CloneFrom {get; private set;}
    [CanBeNull] public string FullText {get; private set;}
    [CanBeNull] public RdTextRange Range {get; private set;}
    [NotNull] public List<string> ExtraImports {get; private set;}
    [NotNull] public List<string> ExtraModules {get; private set;}
    public bool DisableAltEnter {get; private set;}
    public JetBrains.Rider.Model.SandboxLanguage SandboxLanguage {get; private set;}
    
    //private fields
    //primary constructor
    public SandboxInfo(
      [CanBeNull] EditableEntityId cloneFrom,
      [CanBeNull] string fullText,
      [CanBeNull] RdTextRange range,
      [NotNull] List<string> extraImports,
      [NotNull] List<string> extraModules,
      bool disableAltEnter,
      JetBrains.Rider.Model.SandboxLanguage sandboxLanguage
    )
    {
      if (extraImports == null) throw new ArgumentNullException("extraImports");
      if (extraModules == null) throw new ArgumentNullException("extraModules");
      
      CloneFrom = cloneFrom;
      FullText = fullText;
      Range = range;
      ExtraImports = extraImports;
      ExtraModules = extraModules;
      DisableAltEnter = disableAltEnter;
      SandboxLanguage = sandboxLanguage;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SandboxInfo> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var cloneFrom = ReadEditableEntityIdNullable(ctx, reader);
      var fullText = ReadStringNullable(ctx, reader);
      var range = ReadRdTextRangeNullable(ctx, reader);
      var extraImports = ReadStringList(ctx, reader);
      var extraModules = ReadStringList(ctx, reader);
      var disableAltEnter = reader.ReadBool();
      var sandboxLanguage = (JetBrains.Rider.Model.SandboxLanguage)reader.ReadInt();
      return new SandboxInfo(cloneFrom, fullText, range, extraImports, extraModules, disableAltEnter, sandboxLanguage).WithId(_id);
    };
    public static CtxReadDelegate<EditableEntityId> ReadEditableEntityIdNullable = EditableEntityId.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<RdTextRange> ReadRdTextRangeNullable = RdTextRange.Read.NullableClass();
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<SandboxInfo> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteEditableEntityIdNullable(ctx, writer, value.CloneFrom);
      WriteStringNullable(ctx, writer, value.FullText);
      WriteRdTextRangeNullable(ctx, writer, value.Range);
      WriteStringList(ctx, writer, value.ExtraImports);
      WriteStringList(ctx, writer, value.ExtraModules);
      writer.Write(value.DisableAltEnter);
      writer.Write((int)value.SandboxLanguage);
    };
    public static CtxWriteDelegate<EditableEntityId> WriteEditableEntityIdNullable = EditableEntityId.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<RdTextRange> WriteRdTextRangeNullable = RdTextRange.Write.NullableClass();
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SandboxInfo (");
      using (printer.IndentCookie()) {
        printer.Print("cloneFrom = "); CloneFrom.PrintEx(printer); printer.Println();
        printer.Print("fullText = "); FullText.PrintEx(printer); printer.Println();
        printer.Print("range = "); Range.PrintEx(printer); printer.Println();
        printer.Print("extraImports = "); ExtraImports.PrintEx(printer); printer.Println();
        printer.Print("extraModules = "); ExtraModules.PrintEx(printer); printer.Println();
        printer.Print("disableAltEnter = "); DisableAltEnter.PrintEx(printer); printer.Println();
        printer.Print("sandboxLanguage = "); SandboxLanguage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SandboxLanguage {
    CSharp,
    FSharp
  }
  
  
  public enum ScoringHint {
    Statistics
  }
  
  
  public enum ScrollKind {
    Center,
    UpperHalf,
    LowerHalf,
    Smart,
    Relative
  }
  
  
  public class ScrollingInfo : IPrintable, IEquatable<ScrollingInfo> {
    //fields
    //public fields
    public ScrollKind Kind {get; private set;}
    [CanBeNull] public int? DocOffset {get; private set;}
    
    //private fields
    //primary constructor
    public ScrollingInfo(
      ScrollKind kind,
      [CanBeNull] int? docOffset
    )
    {
      Kind = kind;
      DocOffset = docOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ScrollingInfo> Read = (ctx, reader) => 
    {
      var kind = (ScrollKind)reader.ReadInt();
      var docOffset = ReadIntNullable(ctx, reader);
      return new ScrollingInfo(kind, docOffset);
    };
    public static CtxReadDelegate<int?> ReadIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.NullableStruct();
    
    public static CtxWriteDelegate<ScrollingInfo> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteIntNullable(ctx, writer, value.DocOffset);
    };
    public static CtxWriteDelegate<int?> WriteIntNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.NullableStruct();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ScrollingInfo) obj);
    }
    public bool Equals(ScrollingInfo other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(DocOffset, other.DocOffset);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Kind;
        hash = hash * 31 + (DocOffset != null ?DocOffset.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ScrollingInfo (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("docOffset = "); DocOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SelectionRange : IPrintable, IEquatable<SelectionRange> {
    //fields
    //public fields
    [NotNull] public DocOffsetAndVirtualModel SelectionAnchor {get; private set;}
    [NotNull] public DocOffsetAndVirtualModel ActivePosition {get; private set;}
    
    //private fields
    //primary constructor
    public SelectionRange(
      [NotNull] DocOffsetAndVirtualModel selectionAnchor,
      [NotNull] DocOffsetAndVirtualModel activePosition
    )
    {
      if (selectionAnchor == null) throw new ArgumentNullException("selectionAnchor");
      if (activePosition == null) throw new ArgumentNullException("activePosition");
      
      SelectionAnchor = selectionAnchor;
      ActivePosition = activePosition;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SelectionRange> Read = (ctx, reader) => 
    {
      var selectionAnchor = DocOffsetAndVirtualModel.Read(ctx, reader);
      var activePosition = DocOffsetAndVirtualModel.Read(ctx, reader);
      return new SelectionRange(selectionAnchor, activePosition);
    };
    
    public static CtxWriteDelegate<SelectionRange> Write = (ctx, writer, value) => 
    {
      DocOffsetAndVirtualModel.Write(ctx, writer, value.SelectionAnchor);
      DocOffsetAndVirtualModel.Write(ctx, writer, value.ActivePosition);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SelectionRange) obj);
    }
    public bool Equals(SelectionRange other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(SelectionAnchor, other.SelectionAnchor) && Equals(ActivePosition, other.ActivePosition);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SelectionAnchor.GetHashCode();
        hash = hash * 31 + ActivePosition.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SelectionRange (");
      using (printer.IndentCookie()) {
        printer.Print("selectionAnchor = "); SelectionAnchor.PrintEx(printer); printer.Println();
        printer.Print("activePosition = "); ActivePosition.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum SessionState {
    FullItemsPrepared,
    ReturnedNull
  }
  
  
  public enum ShouldBeShown {
    Show,
    DoNotShow
  }
  
  
  public class SignatureItem : IPrintable, IEquatable<SignatureItem> {
    //fields
    //public fields
    [NotNull] public string Text {get; private set;}
    public bool IsDeprecated {get; private set;}
    public bool IsDisabled {get; private set;}
    public int CurrentArgumentIdx {get; private set;}
    [NotNull] public List<int> StartParamOffsets {get; private set;}
    [NotNull] public List<int> EndParamOffsets {get; private set;}
    
    //private fields
    //primary constructor
    public SignatureItem(
      [NotNull] string text,
      bool isDeprecated,
      bool isDisabled,
      int currentArgumentIdx,
      [NotNull] List<int> startParamOffsets,
      [NotNull] List<int> endParamOffsets
    )
    {
      if (text == null) throw new ArgumentNullException("text");
      if (startParamOffsets == null) throw new ArgumentNullException("startParamOffsets");
      if (endParamOffsets == null) throw new ArgumentNullException("endParamOffsets");
      
      Text = text;
      IsDeprecated = isDeprecated;
      IsDisabled = isDisabled;
      CurrentArgumentIdx = currentArgumentIdx;
      StartParamOffsets = startParamOffsets;
      EndParamOffsets = endParamOffsets;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SignatureItem> Read = (ctx, reader) => 
    {
      var text = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var isDeprecated = reader.ReadBool();
      var isDisabled = reader.ReadBool();
      var currentArgumentIdx = reader.ReadInt();
      var startParamOffsets = ReadIntList(ctx, reader);
      var endParamOffsets = ReadIntList(ctx, reader);
      return new SignatureItem(text, isDeprecated, isDisabled, currentArgumentIdx, startParamOffsets, endParamOffsets);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<SignatureItem> Write = (ctx, writer, value) => 
    {
      ctx.WriteInterned(writer, value.Text, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.IsDeprecated);
      writer.Write(value.IsDisabled);
      writer.Write(value.CurrentArgumentIdx);
      WriteIntList(ctx, writer, value.StartParamOffsets);
      WriteIntList(ctx, writer, value.EndParamOffsets);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SignatureItem) obj);
    }
    public bool Equals(SignatureItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text) && IsDeprecated == other.IsDeprecated && IsDisabled == other.IsDisabled && CurrentArgumentIdx == other.CurrentArgumentIdx && StartParamOffsets.SequenceEqual(other.StartParamOffsets) && EndParamOffsets.SequenceEqual(other.EndParamOffsets);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Text.GetHashCode();
        hash = hash * 31 + IsDeprecated.GetHashCode();
        hash = hash * 31 + IsDisabled.GetHashCode();
        hash = hash * 31 + CurrentArgumentIdx.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(StartParamOffsets);
        hash = hash * 31 + Collections.GetHashCode(EndParamOffsets);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SignatureItem (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("isDeprecated = "); IsDeprecated.PrintEx(printer); printer.Println();
        printer.Print("isDisabled = "); IsDisabled.PrintEx(printer); printer.Println();
        printer.Print("currentArgumentIdx = "); CurrentArgumentIdx.PrintEx(printer); printer.Println();
        printer.Print("startParamOffsets = "); StartParamOffsets.PrintEx(printer); printer.Println();
        printer.Print("endParamOffsets = "); EndParamOffsets.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SimpleLineMarkerHighlighterModel : HighlighterModel
   {
    //fields
    //public fields
    public int Thickness {get; private set;}
    public LineMarkerRendererSide Side {get; private set;}
    
    //private fields
    //primary constructor
    public SimpleLineMarkerHighlighterModel(
      int thickness,
      LineMarkerRendererSide side,
      int layer,
      bool isExactRange,
      [NotNull] JetBrains.Rider.Model.DocumentVersion documentVersion,
      [CanBeNull] string textToHighlight,
      long id,
      [NotNull] string attributeId,
      int start,
      int end
    ) : base (
      layer,
      isExactRange,
      documentVersion,
      textToHighlight,
      id,
      attributeId,
      start,
      end
     ) 
    {
      Thickness = thickness;
      Side = side;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SimpleLineMarkerHighlighterModel> Read = (ctx, reader) => 
    {
      var layer = reader.ReadInt();
      var isExactRange = reader.ReadBool();
      var documentVersion = JetBrains.Rider.Model.DocumentVersion.Read(ctx, reader);
      var textToHighlight = ReadStringNullable(ctx, reader);
      var id = reader.ReadLong();
      var attributeId = ctx.ReadInterned(reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var thickness = reader.ReadInt();
      var side = (LineMarkerRendererSide)reader.ReadInt();
      return new SimpleLineMarkerHighlighterModel(thickness, side, layer, isExactRange, documentVersion, textToHighlight, id, attributeId, start, end);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<SimpleLineMarkerHighlighterModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Layer);
      writer.Write(value.IsExactRange);
      JetBrains.Rider.Model.DocumentVersion.Write(ctx, writer, value.DocumentVersion);
      WriteStringNullable(ctx, writer, value.TextToHighlight);
      writer.Write(value.Id);
      ctx.WriteInterned(writer, value.AttributeId, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.Thickness);
      writer.Write((int)value.Side);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SimpleLineMarkerHighlighterModel) obj);
    }
    public bool Equals(SimpleLineMarkerHighlighterModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Thickness == other.Thickness && Side == other.Side && Layer == other.Layer && IsExactRange == other.IsExactRange && Equals(DocumentVersion, other.DocumentVersion) && Equals(TextToHighlight, other.TextToHighlight) && Id == other.Id && Equals(AttributeId, other.AttributeId) && Start == other.Start && End == other.End;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Thickness.GetHashCode();
        hash = hash * 31 + (int) Side;
        hash = hash * 31 + Layer.GetHashCode();
        hash = hash * 31 + IsExactRange.GetHashCode();
        hash = hash * 31 + DocumentVersion.GetHashCode();
        hash = hash * 31 + (TextToHighlight != null ?TextToHighlight.GetHashCode() : 0);
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + AttributeId.GetHashCode();
        hash = hash * 31 + Start.GetHashCode();
        hash = hash * 31 + End.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SimpleLineMarkerHighlighterModel (");
      using (printer.IndentCookie()) {
        printer.Print("thickness = "); Thickness.PrintEx(printer); printer.Println();
        printer.Print("side = "); Side.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
        printer.Print("isExactRange = "); IsExactRange.PrintEx(printer); printer.Println();
        printer.Print("documentVersion = "); DocumentVersion.PrintEx(printer); printer.Println();
        printer.Print("textToHighlight = "); TextToHighlight.PrintEx(printer); printer.Println();
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("attributeId = "); AttributeId.PrintEx(printer); printer.Println();
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class Solution : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IAsyncSink<RdVoid> Close { get { return _Close; }}
    [NotNull] public RdSolutionOpenStrategy SolutionOpenStrategy {get; private set;}
    [NotNull] public JetBrains.Rider.Model.SolutionLifecycle SolutionLifecycle {get; private set;}
    [NotNull] public EditableEntityCollection Editors {get; private set;}
    [NotNull] public DaemonModel Daemon {get; private set;}
    [NotNull] public JetBrains.Rider.Model.ActionPopupSession ActionPopupSession {get; private set;}
    [NotNull] public ISource<Navigation> Navigate { get { return _Navigate; }}
    [NotNull] public RdTextEditingGateway TextEditingGateway {get; private set;}
    [NotNull] public RdCustomData CustomData {get; private set;}
    [NotNull] public IRdProperty<bool> IsLoaded { get { return _IsLoaded; }}
    [NotNull] public IRdProperty<bool> IsLoading { get { return _IsLoading; }}
    [NotNull] public IRdProperty<bool> IsDotNetCoreReady { get { return _IsDotNetCoreReady; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Close;
    [NotNull] private readonly RdSignal<Navigation> _Navigate;
    [NotNull] private readonly RdProperty<bool> _IsLoaded;
    [NotNull] private readonly RdProperty<bool> _IsLoading;
    [NotNull] private readonly RdProperty<bool> _IsDotNetCoreReady;
    
    //primary constructor
    private Solution(
      [NotNull] RdSignal<RdVoid> close,
      [NotNull] RdSolutionOpenStrategy solutionOpenStrategy,
      [NotNull] JetBrains.Rider.Model.SolutionLifecycle solutionLifecycle,
      [NotNull] EditableEntityCollection editors,
      [NotNull] DaemonModel daemon,
      [NotNull] JetBrains.Rider.Model.ActionPopupSession actionPopupSession,
      [NotNull] RdSignal<Navigation> navigate,
      [NotNull] RdTextEditingGateway textEditingGateway,
      [NotNull] RdCustomData customData,
      [NotNull] RdProperty<bool> isLoaded,
      [NotNull] RdProperty<bool> isLoading,
      [NotNull] RdProperty<bool> isDotNetCoreReady
    )
    {
      if (close == null) throw new ArgumentNullException("close");
      if (solutionOpenStrategy == null) throw new ArgumentNullException("solutionOpenStrategy");
      if (solutionLifecycle == null) throw new ArgumentNullException("solutionLifecycle");
      if (editors == null) throw new ArgumentNullException("editors");
      if (daemon == null) throw new ArgumentNullException("daemon");
      if (actionPopupSession == null) throw new ArgumentNullException("actionPopupSession");
      if (navigate == null) throw new ArgumentNullException("navigate");
      if (textEditingGateway == null) throw new ArgumentNullException("textEditingGateway");
      if (customData == null) throw new ArgumentNullException("customData");
      if (isLoaded == null) throw new ArgumentNullException("isLoaded");
      if (isLoading == null) throw new ArgumentNullException("isLoading");
      if (isDotNetCoreReady == null) throw new ArgumentNullException("isDotNetCoreReady");
      
      _Close = close;
      SolutionOpenStrategy = solutionOpenStrategy;
      SolutionLifecycle = solutionLifecycle;
      Editors = editors;
      Daemon = daemon;
      ActionPopupSession = actionPopupSession;
      _Navigate = navigate;
      TextEditingGateway = textEditingGateway;
      CustomData = customData;
      _IsLoaded = isLoaded;
      _IsLoading = isLoading;
      _IsDotNetCoreReady = isDotNetCoreReady;
      _IsLoaded.OptimizeNested = true;
      _IsLoading.OptimizeNested = true;
      _IsDotNetCoreReady.OptimizeNested = true;
      _Close.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
      BindableChildren.Add(new KeyValuePair<string, object>("solutionOpenStrategy", SolutionOpenStrategy));
      BindableChildren.Add(new KeyValuePair<string, object>("solutionLifecycle", SolutionLifecycle));
      BindableChildren.Add(new KeyValuePair<string, object>("editors", Editors));
      BindableChildren.Add(new KeyValuePair<string, object>("daemon", Daemon));
      BindableChildren.Add(new KeyValuePair<string, object>("actionPopupSession", ActionPopupSession));
      BindableChildren.Add(new KeyValuePair<string, object>("navigate", _Navigate));
      BindableChildren.Add(new KeyValuePair<string, object>("textEditingGateway", TextEditingGateway));
      BindableChildren.Add(new KeyValuePair<string, object>("customData", CustomData));
      BindableChildren.Add(new KeyValuePair<string, object>("isLoaded", _IsLoaded));
      BindableChildren.Add(new KeyValuePair<string, object>("isLoading", _IsLoading));
      BindableChildren.Add(new KeyValuePair<string, object>("isDotNetCoreReady", _IsDotNetCoreReady));
    }
    //secondary constructor
    public Solution (
      [NotNull] RdSolutionOpenStrategy solutionOpenStrategy
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      solutionOpenStrategy,
      new JetBrains.Rider.Model.SolutionLifecycle(),
      new EditableEntityCollection(),
      new DaemonModel(),
      new JetBrains.Rider.Model.ActionPopupSession(),
      new RdSignal<Navigation>(Navigation.Read, Navigation.Write),
      new RdTextEditingGateway(),
      new RdCustomData(),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<Solution> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var close = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var solutionOpenStrategy = RdSolutionOpenStrategy.Read(ctx, reader);
      var solutionLifecycle = JetBrains.Rider.Model.SolutionLifecycle.Read(ctx, reader);
      var editors = EditableEntityCollection.Read(ctx, reader);
      var daemon = DaemonModel.Read(ctx, reader);
      var actionPopupSession = JetBrains.Rider.Model.ActionPopupSession.Read(ctx, reader);
      var navigate = RdSignal<Navigation>.Read(ctx, reader, Navigation.Read, Navigation.Write);
      var textEditingGateway = RdTextEditingGateway.Read(ctx, reader);
      var customData = RdCustomData.Read(ctx, reader);
      var isLoaded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isLoading = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isDotNetCoreReady = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new Solution(close, solutionOpenStrategy, solutionLifecycle, editors, daemon, actionPopupSession, navigate, textEditingGateway, customData, isLoaded, isLoading, isDotNetCoreReady).WithId(_id);
    };
    
    public static CtxWriteDelegate<Solution> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdVoid>.Write(ctx, writer, value._Close);
      RdSolutionOpenStrategy.Write(ctx, writer, value.SolutionOpenStrategy);
      JetBrains.Rider.Model.SolutionLifecycle.Write(ctx, writer, value.SolutionLifecycle);
      EditableEntityCollection.Write(ctx, writer, value.Editors);
      DaemonModel.Write(ctx, writer, value.Daemon);
      JetBrains.Rider.Model.ActionPopupSession.Write(ctx, writer, value.ActionPopupSession);
      RdSignal<Navigation>.Write(ctx, writer, value._Navigate);
      RdTextEditingGateway.Write(ctx, writer, value.TextEditingGateway);
      RdCustomData.Write(ctx, writer, value.CustomData);
      RdProperty<bool>.Write(ctx, writer, value._IsLoaded);
      RdProperty<bool>.Write(ctx, writer, value._IsLoading);
      RdProperty<bool>.Write(ctx, writer, value._IsDotNetCoreReady);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Solution (");
      using (printer.IndentCookie()) {
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
        printer.Print("solutionOpenStrategy = "); SolutionOpenStrategy.PrintEx(printer); printer.Println();
        printer.Print("solutionLifecycle = "); SolutionLifecycle.PrintEx(printer); printer.Println();
        printer.Print("editors = "); Editors.PrintEx(printer); printer.Println();
        printer.Print("daemon = "); Daemon.PrintEx(printer); printer.Println();
        printer.Print("actionPopupSession = "); ActionPopupSession.PrintEx(printer); printer.Println();
        printer.Print("navigate = "); _Navigate.PrintEx(printer); printer.Println();
        printer.Print("textEditingGateway = "); TextEditingGateway.PrintEx(printer); printer.Println();
        printer.Print("customData = "); CustomData.PrintEx(printer); printer.Println();
        printer.Print("isLoaded = "); _IsLoaded.PrintEx(printer); printer.Println();
        printer.Print("isLoading = "); _IsLoading.PrintEx(printer); printer.Println();
        printer.Print("isDotNetCoreReady = "); _IsDotNetCoreReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionExplorerNavigation : Navigation
   {
    //fields
    //public fields
    [NotNull] public string FilePath {get; private set;}
    public int ProjectModelElementId {get; private set;}
    
    //private fields
    //primary constructor
    public SolutionExplorerNavigation(
      [NotNull] string filePath,
      int projectModelElementId
    )
    {
      if (filePath == null) throw new ArgumentNullException("filePath");
      
      FilePath = filePath;
      ProjectModelElementId = projectModelElementId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SolutionExplorerNavigation> Read = (ctx, reader) => 
    {
      var filePath = reader.ReadString();
      var projectModelElementId = reader.ReadInt();
      return new SolutionExplorerNavigation(filePath, projectModelElementId);
    };
    
    public static new CtxWriteDelegate<SolutionExplorerNavigation> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FilePath);
      writer.Write(value.ProjectModelElementId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SolutionExplorerNavigation) obj);
    }
    public bool Equals(SolutionExplorerNavigation other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return FilePath == other.FilePath && ProjectModelElementId == other.ProjectModelElementId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + FilePath.GetHashCode();
        hash = hash * 31 + ProjectModelElementId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionExplorerNavigation (");
      using (printer.IndentCookie()) {
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("projectModelElementId = "); ProjectModelElementId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SolutionLifecycle : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<LoadResult> FullStartupFinished { get { return _FullStartupFinished; }}
    [NotNull] public IRdProperty<bool> IsReadyForTyping { get { return _IsReadyForTyping; }}
    [NotNull] public IRdProperty<bool> IsProjectModelReady { get { return _IsProjectModelReady; }}
    
    //private fields
    [NotNull] private readonly RdProperty<LoadResult> _FullStartupFinished;
    [NotNull] private readonly RdProperty<bool> _IsReadyForTyping;
    [NotNull] private readonly RdProperty<bool> _IsProjectModelReady;
    
    //primary constructor
    private SolutionLifecycle(
      [NotNull] RdProperty<LoadResult> fullStartupFinished,
      [NotNull] RdProperty<bool> isReadyForTyping,
      [NotNull] RdProperty<bool> isProjectModelReady
    )
    {
      if (fullStartupFinished == null) throw new ArgumentNullException("fullStartupFinished");
      if (isReadyForTyping == null) throw new ArgumentNullException("isReadyForTyping");
      if (isProjectModelReady == null) throw new ArgumentNullException("isProjectModelReady");
      
      _FullStartupFinished = fullStartupFinished;
      _IsReadyForTyping = isReadyForTyping;
      _IsProjectModelReady = isProjectModelReady;
      _IsReadyForTyping.OptimizeNested = true;
      _IsProjectModelReady.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("fullStartupFinished", _FullStartupFinished));
      BindableChildren.Add(new KeyValuePair<string, object>("isReadyForTyping", _IsReadyForTyping));
      BindableChildren.Add(new KeyValuePair<string, object>("isProjectModelReady", _IsProjectModelReady));
    }
    //secondary constructor
    public SolutionLifecycle (
    ) : this (
      new RdProperty<LoadResult>(LoadResult.Read, LoadResult.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<SolutionLifecycle> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var fullStartupFinished = RdProperty<LoadResult>.Read(ctx, reader, LoadResult.Read, LoadResult.Write);
      var isReadyForTyping = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isProjectModelReady = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new SolutionLifecycle(fullStartupFinished, isReadyForTyping, isProjectModelReady).WithId(_id);
    };
    
    public static CtxWriteDelegate<SolutionLifecycle> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<LoadResult>.Write(ctx, writer, value._FullStartupFinished);
      RdProperty<bool>.Write(ctx, writer, value._IsReadyForTyping);
      RdProperty<bool>.Write(ctx, writer, value._IsProjectModelReady);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionLifecycle (");
      using (printer.IndentCookie()) {
        printer.Print("fullStartupFinished = "); _FullStartupFinished.PrintEx(printer); printer.Println();
        printer.Print("isReadyForTyping = "); _IsReadyForTyping.PrintEx(printer); printer.Println();
        printer.Print("isProjectModelReady = "); _IsProjectModelReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class StringTooltipModel : TooltipModel
   {
    //fields
    //public fields
    [CanBeNull] public string Text {get; private set;}
    
    //private fields
    //primary constructor
    public StringTooltipModel(
      [CanBeNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<StringTooltipModel> Read = (ctx, reader) => 
    {
      var text = ReadStringNullable(ctx, reader);
      return new StringTooltipModel(text);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<StringTooltipModel> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Text);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((StringTooltipModel) obj);
    }
    public bool Equals(StringTooltipModel other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Text != null ?Text.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("StringTooltipModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SummaryInfoItem : IPrintable, IEquatable<SummaryInfoItem> {
    //fields
    //public fields
    [NotNull] public string HtmlTextBody {get; private set;}
    [CanBeNull] public string HtmlDocumentationBody {get; private set;}
    
    //private fields
    //primary constructor
    public SummaryInfoItem(
      [NotNull] string htmlTextBody,
      [CanBeNull] string htmlDocumentationBody
    )
    {
      if (htmlTextBody == null) throw new ArgumentNullException("htmlTextBody");
      
      HtmlTextBody = htmlTextBody;
      HtmlDocumentationBody = htmlDocumentationBody;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<SummaryInfoItem> Read = (ctx, reader) => 
    {
      var htmlTextBody = reader.ReadString();
      var htmlDocumentationBody = ReadStringNullable(ctx, reader);
      return new SummaryInfoItem(htmlTextBody, htmlDocumentationBody);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<SummaryInfoItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.HtmlTextBody);
      WriteStringNullable(ctx, writer, value.HtmlDocumentationBody);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SummaryInfoItem) obj);
    }
    public bool Equals(SummaryInfoItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return HtmlTextBody == other.HtmlTextBody && Equals(HtmlDocumentationBody, other.HtmlDocumentationBody);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + HtmlTextBody.GetHashCode();
        hash = hash * 31 + (HtmlDocumentationBody != null ?HtmlDocumentationBody.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SummaryInfoItem (");
      using (printer.IndentCookie()) {
        printer.Print("htmlTextBody = "); HtmlTextBody.PrintEx(printer); printer.Println();
        printer.Print("htmlDocumentationBody = "); HtmlDocumentationBody.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlId : IPrintable, IEquatable<TextControlId> {
    //fields
    //public fields
    [NotNull] public EditableEntityId DocumentId {get; private set;}
    public int TabIndex {get; private set;}
    
    //private fields
    //primary constructor
    public TextControlId(
      [NotNull] EditableEntityId documentId,
      int tabIndex
    )
    {
      if (documentId == null) throw new ArgumentNullException("documentId");
      
      DocumentId = documentId;
      TabIndex = tabIndex;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextControlId> Read = (ctx, reader) => 
    {
      var documentId = EditableEntityId.Read(ctx, reader);
      var tabIndex = reader.ReadInt();
      return new TextControlId(documentId, tabIndex);
    };
    
    public static CtxWriteDelegate<TextControlId> Write = (ctx, writer, value) => 
    {
      EditableEntityId.Write(ctx, writer, value.DocumentId);
      writer.Write(value.TabIndex);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlId) obj);
    }
    public bool Equals(TextControlId other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(DocumentId, other.DocumentId) && TabIndex == other.TabIndex;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + DocumentId.GetHashCode();
        hash = hash * 31 + TabIndex.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlId (");
      using (printer.IndentCookie()) {
        printer.Print("documentId = "); DocumentId.PrintEx(printer); printer.Println();
        printer.Print("tabIndex = "); TabIndex.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlModel : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<SelectionRange> Selection { get { return _Selection; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.VisibleRange> VisibleRange { get { return _VisibleRange; }}
    [NotNull] public EditableEntityId Content {get; private set;}
    [NotNull] public IRdProperty<int> TabSize { get { return _TabSize; }}
    [NotNull] public IRdProperty<int> RightMargin { get { return _RightMargin; }}
    [NotNull] public IRdProperty<bool> UseTab { get { return _UseTab; }}
    [NotNull] public IRdProperty<int> IndentSize { get { return _IndentSize; }}
    [NotNull] public IRdProperty<int> SpaceWidth { get { return _SpaceWidth; }}
    [NotNull] public IRdProperty<ErrorStripeIndicatorModel> DaemonIndicator { get { return _DaemonIndicator; }}
    [NotNull] public ISource<ScrollingInfo> Scrolling { get { return _Scrolling; }}
    [NotNull] public IRdProperty<bool> IsVisible { get { return _IsVisible; }}
    public OriginKind Origin {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<SelectionRange> _Selection;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.VisibleRange> _VisibleRange;
    [NotNull] private readonly RdProperty<int> _TabSize;
    [NotNull] private readonly RdProperty<int> _RightMargin;
    [NotNull] private readonly RdProperty<bool> _UseTab;
    [NotNull] private readonly RdProperty<int> _IndentSize;
    [NotNull] private readonly RdProperty<int> _SpaceWidth;
    [NotNull] private readonly RdProperty<ErrorStripeIndicatorModel> _DaemonIndicator;
    [NotNull] private readonly RdSignal<ScrollingInfo> _Scrolling;
    [NotNull] private readonly RdProperty<bool> _IsVisible;
    
    //primary constructor
    private TextControlModel(
      [NotNull] RdProperty<SelectionRange> selection,
      [NotNull] RdProperty<JetBrains.Rider.Model.VisibleRange> visibleRange,
      [NotNull] EditableEntityId content,
      [NotNull] RdProperty<int> tabSize,
      [NotNull] RdProperty<int> rightMargin,
      [NotNull] RdProperty<bool> useTab,
      [NotNull] RdProperty<int> indentSize,
      [NotNull] RdProperty<int> spaceWidth,
      [NotNull] RdProperty<ErrorStripeIndicatorModel> daemonIndicator,
      [NotNull] RdSignal<ScrollingInfo> scrolling,
      [NotNull] RdProperty<bool> isVisible,
      OriginKind origin
    )
    {
      if (selection == null) throw new ArgumentNullException("selection");
      if (visibleRange == null) throw new ArgumentNullException("visibleRange");
      if (content == null) throw new ArgumentNullException("content");
      if (tabSize == null) throw new ArgumentNullException("tabSize");
      if (rightMargin == null) throw new ArgumentNullException("rightMargin");
      if (useTab == null) throw new ArgumentNullException("useTab");
      if (indentSize == null) throw new ArgumentNullException("indentSize");
      if (spaceWidth == null) throw new ArgumentNullException("spaceWidth");
      if (daemonIndicator == null) throw new ArgumentNullException("daemonIndicator");
      if (scrolling == null) throw new ArgumentNullException("scrolling");
      if (isVisible == null) throw new ArgumentNullException("isVisible");
      
      _Selection = selection;
      _VisibleRange = visibleRange;
      Content = content;
      _TabSize = tabSize;
      _RightMargin = rightMargin;
      _UseTab = useTab;
      _IndentSize = indentSize;
      _SpaceWidth = spaceWidth;
      _DaemonIndicator = daemonIndicator;
      _Scrolling = scrolling;
      _IsVisible = isVisible;
      Origin = origin;
      _Selection.OptimizeNested = true;
      _TabSize.OptimizeNested = true;
      _RightMargin.OptimizeNested = true;
      _UseTab.OptimizeNested = true;
      _IndentSize.OptimizeNested = true;
      _SpaceWidth.OptimizeNested = true;
      _DaemonIndicator.OptimizeNested = true;
      _IsVisible.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selection", _Selection));
      BindableChildren.Add(new KeyValuePair<string, object>("visibleRange", _VisibleRange));
      BindableChildren.Add(new KeyValuePair<string, object>("tabSize", _TabSize));
      BindableChildren.Add(new KeyValuePair<string, object>("rightMargin", _RightMargin));
      BindableChildren.Add(new KeyValuePair<string, object>("useTab", _UseTab));
      BindableChildren.Add(new KeyValuePair<string, object>("indentSize", _IndentSize));
      BindableChildren.Add(new KeyValuePair<string, object>("spaceWidth", _SpaceWidth));
      BindableChildren.Add(new KeyValuePair<string, object>("daemonIndicator", _DaemonIndicator));
      BindableChildren.Add(new KeyValuePair<string, object>("scrolling", _Scrolling));
      BindableChildren.Add(new KeyValuePair<string, object>("isVisible", _IsVisible));
    }
    //secondary constructor
    public TextControlModel (
      [NotNull] EditableEntityId content,
      OriginKind origin
    ) : this (
      new RdProperty<SelectionRange>(SelectionRange.Read, SelectionRange.Write),
      new RdProperty<JetBrains.Rider.Model.VisibleRange>(JetBrains.Rider.Model.VisibleRange.Read, JetBrains.Rider.Model.VisibleRange.Write),
      content,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<ErrorStripeIndicatorModel>(ErrorStripeIndicatorModel.Read, ErrorStripeIndicatorModel.Write),
      new RdSignal<ScrollingInfo>(ScrollingInfo.Read, ScrollingInfo.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      origin
    ) {}
    //statics
    
    public static CtxReadDelegate<TextControlModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var selection = RdProperty<SelectionRange>.Read(ctx, reader, SelectionRange.Read, SelectionRange.Write);
      var visibleRange = RdProperty<JetBrains.Rider.Model.VisibleRange>.Read(ctx, reader, JetBrains.Rider.Model.VisibleRange.Read, JetBrains.Rider.Model.VisibleRange.Write);
      var content = EditableEntityId.Read(ctx, reader);
      var tabSize = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var rightMargin = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var useTab = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var indentSize = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var spaceWidth = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var daemonIndicator = RdProperty<ErrorStripeIndicatorModel>.Read(ctx, reader, ErrorStripeIndicatorModel.Read, ErrorStripeIndicatorModel.Write);
      var scrolling = RdSignal<ScrollingInfo>.Read(ctx, reader, ScrollingInfo.Read, ScrollingInfo.Write);
      var isVisible = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var origin = (OriginKind)reader.ReadInt();
      return new TextControlModel(selection, visibleRange, content, tabSize, rightMargin, useTab, indentSize, spaceWidth, daemonIndicator, scrolling, isVisible, origin).WithId(_id);
    };
    
    public static CtxWriteDelegate<TextControlModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<SelectionRange>.Write(ctx, writer, value._Selection);
      RdProperty<JetBrains.Rider.Model.VisibleRange>.Write(ctx, writer, value._VisibleRange);
      EditableEntityId.Write(ctx, writer, value.Content);
      RdProperty<int>.Write(ctx, writer, value._TabSize);
      RdProperty<int>.Write(ctx, writer, value._RightMargin);
      RdProperty<bool>.Write(ctx, writer, value._UseTab);
      RdProperty<int>.Write(ctx, writer, value._IndentSize);
      RdProperty<int>.Write(ctx, writer, value._SpaceWidth);
      RdProperty<ErrorStripeIndicatorModel>.Write(ctx, writer, value._DaemonIndicator);
      RdSignal<ScrollingInfo>.Write(ctx, writer, value._Scrolling);
      RdProperty<bool>.Write(ctx, writer, value._IsVisible);
      writer.Write((int)value.Origin);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlModel (");
      using (printer.IndentCookie()) {
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("visibleRange = "); _VisibleRange.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("tabSize = "); _TabSize.PrintEx(printer); printer.Println();
        printer.Print("rightMargin = "); _RightMargin.PrintEx(printer); printer.Println();
        printer.Print("useTab = "); _UseTab.PrintEx(printer); printer.Println();
        printer.Print("indentSize = "); _IndentSize.PrintEx(printer); printer.Println();
        printer.Print("spaceWidth = "); _SpaceWidth.PrintEx(printer); printer.Println();
        printer.Print("daemonIndicator = "); _DaemonIndicator.PrintEx(printer); printer.Println();
        printer.Print("scrolling = "); _Scrolling.PrintEx(printer); printer.Println();
        printer.Print("isVisible = "); _IsVisible.PrintEx(printer); printer.Println();
        printer.Print("origin = "); Origin.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlSnapshot : IPrintable, IEquatable<TextControlSnapshot> {
    //fields
    //public fields
    [NotNull] public SelectionRange Selection {get; private set;}
    
    //private fields
    //primary constructor
    public TextControlSnapshot(
      [NotNull] SelectionRange selection
    )
    {
      if (selection == null) throw new ArgumentNullException("selection");
      
      Selection = selection;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextControlSnapshot> Read = (ctx, reader) => 
    {
      var selection = SelectionRange.Read(ctx, reader);
      return new TextControlSnapshot(selection);
    };
    
    public static CtxWriteDelegate<TextControlSnapshot> Write = (ctx, writer, value) => 
    {
      SelectionRange.Write(ctx, writer, value.Selection);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlSnapshot) obj);
    }
    public bool Equals(TextControlSnapshot other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Selection, other.Selection);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Selection.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlSnapshot (");
      using (printer.IndentCookie()) {
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlTuple : RdBindableBase {
    //fields
    //public fields
    [NotNull] public TextControlId Id {get; private set;}
    [NotNull] public LastFocusedTextControl TextControl {get; private set;}
    
    //private fields
    //primary constructor
    private TextControlTuple(
      [NotNull] TextControlId id,
      [NotNull] LastFocusedTextControl textControl
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (textControl == null) throw new ArgumentNullException("textControl");
      
      Id = id;
      TextControl = textControl;
      BindableChildren.Add(new KeyValuePair<string, object>("textControl", TextControl));
    }
    //secondary constructor
    public TextControlTuple (
      [NotNull] TextControlId id
    ) : this (
      id,
      new LastFocusedTextControl()
    ) {}
    //statics
    
    public static CtxReadDelegate<TextControlTuple> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = TextControlId.Read(ctx, reader);
      var textControl = LastFocusedTextControl.Read(ctx, reader);
      return new TextControlTuple(id, textControl).WithId(_id);
    };
    
    public static CtxWriteDelegate<TextControlTuple> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      TextControlId.Write(ctx, writer, value.Id);
      LastFocusedTextControl.Write(ctx, writer, value.TextControl);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlTuple (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("textControl = "); TextControl.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ToUpdate : IPrintable, IEquatable<ToUpdate> {
    //fields
    //public fields
    [NotNull] public List<AdvancedPresentation> UpdatedItems {get; private set;}
    
    //private fields
    //primary constructor
    public ToUpdate(
      [NotNull] List<AdvancedPresentation> updatedItems
    )
    {
      if (updatedItems == null) throw new ArgumentNullException("updatedItems");
      
      UpdatedItems = updatedItems;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ToUpdate> Read = (ctx, reader) => 
    {
      var updatedItems = ReadAdvancedPresentationList(ctx, reader);
      return new ToUpdate(updatedItems);
    };
    public static CtxReadDelegate<List<AdvancedPresentation>> ReadAdvancedPresentationList = AdvancedPresentation.Read.List();
    
    public static CtxWriteDelegate<ToUpdate> Write = (ctx, writer, value) => 
    {
      WriteAdvancedPresentationList(ctx, writer, value.UpdatedItems);
    };
    public static CtxWriteDelegate<List<AdvancedPresentation>> WriteAdvancedPresentationList = AdvancedPresentation.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ToUpdate) obj);
    }
    public bool Equals(ToUpdate other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return UpdatedItems.SequenceEqual(other.UpdatedItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(UpdatedItems);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ToUpdate (");
      using (printer.IndentCookie()) {
        printer.Print("updatedItems = "); UpdatedItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class TooltipModel {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TooltipModel> Read = Polymorphic<TooltipModel>.ReadAbstract(TooltipModel_Unknown.Read);
    
    public static CtxWriteDelegate<TooltipModel> Write = Polymorphic<TooltipModel>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class TooltipModel_Unknown : TooltipModel
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<TooltipModel_Unknown> Read = (ctx, reader) => 
    {
      return new TooltipModel_Unknown();
    };
    
    public static new CtxWriteDelegate<TooltipModel_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TooltipModel_Unknown) obj);
    }
    public bool Equals(TooltipModel_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipModel_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TooltipProviderModel : MarkupModelExtension
   {
    //fields
    //public fields
    [NotNull] public RdEndpoint<long, TooltipModel> GetTooltip { get { return _GetTooltip; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<long, TooltipModel> _GetTooltip;
    
    //primary constructor
    private TooltipProviderModel(
      [NotNull] RdEndpoint<long, TooltipModel> getTooltip,
      [NotNull] string key
    ) : base (
      key
     ) 
    {
      if (getTooltip == null) throw new ArgumentNullException("getTooltip");
      
      _GetTooltip = getTooltip;
      _GetTooltip.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("getTooltip", _GetTooltip));
    }
    //secondary constructor
    public TooltipProviderModel (
      [NotNull] string key
    ) : this (
      new RdEndpoint<long, TooltipModel>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong, TooltipModel.Read, TooltipModel.Write),
      key
    ) {}
    //statics
    
    public static new CtxReadDelegate<TooltipProviderModel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var key = reader.ReadString();
      var getTooltip = RdEndpoint<long, TooltipModel>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadLong, JetBrains.Platform.RdFramework.Impl.Serializers.WriteLong, TooltipModel.Read, TooltipModel.Write);
      return new TooltipProviderModel(getTooltip, key).WithId(_id);
    };
    
    public static new CtxWriteDelegate<TooltipProviderModel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Key);
      RdEndpoint<long, TooltipModel>.Write(ctx, writer, value._GetTooltip);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TooltipProviderModel (");
      using (printer.IndentCookie()) {
        printer.Print("getTooltip = "); _GetTooltip.PrintEx(printer); printer.Println();
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class VisibleRange : RdBindableBase {
    //fields
    //public fields
    public int StartOffset {get; private set;}
    public int EndOffset {get; private set;}
    
    //private fields
    //primary constructor
    public VisibleRange(
      int startOffset,
      int endOffset
    )
    {
      StartOffset = startOffset;
      EndOffset = endOffset;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<VisibleRange> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var startOffset = reader.ReadInt();
      var endOffset = reader.ReadInt();
      return new VisibleRange(startOffset, endOffset).WithId(_id);
    };
    
    public static CtxWriteDelegate<VisibleRange> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.StartOffset);
      writer.Write(value.EndOffset);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("VisibleRange (");
      using (printer.IndentCookie()) {
        printer.Print("startOffset = "); StartOffset.PrintEx(printer); printer.Println();
        printer.Print("endOffset = "); EndOffset.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
