using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SolutionProperties : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<RdConfigurationAndPlatform> ActiveConfigurationPlatform { get { return _ActiveConfigurationPlatform; }}
    [NotNull] public IRdProperty<List<RdConfigurationAndPlatform>> ConfigurationsAndPlatformsCollection { get { return _ConfigurationsAndPlatformsCollection; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdConfigurationAndPlatform> _ActiveConfigurationPlatform;
    [NotNull] private readonly RdProperty<List<RdConfigurationAndPlatform>> _ConfigurationsAndPlatformsCollection;
    
    //primary constructor
    private SolutionProperties(
      [NotNull] RdProperty<RdConfigurationAndPlatform> activeConfigurationPlatform,
      [NotNull] RdProperty<List<RdConfigurationAndPlatform>> configurationsAndPlatformsCollection
    )
    {
      if (activeConfigurationPlatform == null) throw new ArgumentNullException("activeConfigurationPlatform");
      if (configurationsAndPlatformsCollection == null) throw new ArgumentNullException("configurationsAndPlatformsCollection");
      
      _ActiveConfigurationPlatform = activeConfigurationPlatform;
      _ConfigurationsAndPlatformsCollection = configurationsAndPlatformsCollection;
      _ActiveConfigurationPlatform.OptimizeNested = true;
      _ConfigurationsAndPlatformsCollection.OptimizeNested = true;
      _ActiveConfigurationPlatform.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("activeConfigurationPlatform", _ActiveConfigurationPlatform));
      BindableChildren.Add(new KeyValuePair<string, object>("configurationsAndPlatformsCollection", _ConfigurationsAndPlatformsCollection));
    }
    //secondary constructor
    internal SolutionProperties (
    ) : this (
      new RdProperty<RdConfigurationAndPlatform>(ReadRdConfigurationAndPlatformNullable, WriteRdConfigurationAndPlatformNullable),
      new RdProperty<List<RdConfigurationAndPlatform>>(ReadRdConfigurationAndPlatformList, WriteRdConfigurationAndPlatformList)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdConfigurationAndPlatform> ReadRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Read.NullableClass();
    public static CtxReadDelegate<List<RdConfigurationAndPlatform>> ReadRdConfigurationAndPlatformList = RdConfigurationAndPlatform.Read.List();
    
    public static CtxWriteDelegate<RdConfigurationAndPlatform> WriteRdConfigurationAndPlatformNullable = RdConfigurationAndPlatform.Write.NullableClass();
    public static CtxWriteDelegate<List<RdConfigurationAndPlatform>> WriteRdConfigurationAndPlatformList = RdConfigurationAndPlatform.Write.List();
    
    protected override long SerializationHash => -8101783164497145141L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdConfigurationAndPlatform.Read, RdConfigurationAndPlatform.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SolutionProperties (");
      using (printer.IndentCookie()) {
        printer.Print("activeConfigurationPlatform = "); _ActiveConfigurationPlatform.PrintEx(printer); printer.Println();
        printer.Print("configurationsAndPlatformsCollection = "); _ConfigurationsAndPlatformsCollection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionSolutionPropertiesEx
   {
    public static SolutionProperties GetSolutionProperties(this Solution solution)
    {
      return solution.GetOrCreateExtension("solutionProperties", () => new SolutionProperties());
    }
  }
  
  
  public class RdConfigurationAndPlatform : IPrintable, IEquatable<RdConfigurationAndPlatform> {
    //fields
    //public fields
    [NotNull] public string Configuration {get; private set;}
    [NotNull] public string Platform {get; private set;}
    
    //private fields
    //primary constructor
    public RdConfigurationAndPlatform(
      [NotNull] string configuration,
      [NotNull] string platform
    )
    {
      if (configuration == null) throw new ArgumentNullException("configuration");
      if (platform == null) throw new ArgumentNullException("platform");
      
      Configuration = configuration;
      Platform = platform;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdConfigurationAndPlatform> Read = (ctx, reader) => 
    {
      var configuration = reader.ReadString();
      var platform = reader.ReadString();
      return new RdConfigurationAndPlatform(configuration, platform);
    };
    
    public static CtxWriteDelegate<RdConfigurationAndPlatform> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Configuration);
      writer.Write(value.Platform);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdConfigurationAndPlatform) obj);
    }
    public bool Equals(RdConfigurationAndPlatform other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Configuration == other.Configuration && Platform == other.Platform;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Configuration.GetHashCode();
        hash = hash * 31 + Platform.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdConfigurationAndPlatform (");
      using (printer.IndentCookie()) {
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("platform = "); Platform.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
