using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class SpellCheckerModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<string, RdDictionary> Dictionaries { get { return _Dictionaries; }}
    [NotNull] public IRdCall<string, bool> IsCorrect { get { return _IsCorrect; }}
    [NotNull] public IRdCall<string, List<string>> Suggest { get { return _Suggest; }}
    [NotNull] public ISink<bool> EngineUpdated { get { return _EngineUpdated; }}
    [NotNull] public ISource<AddWordArgs> AddRemoveWord { get { return _AddRemoveWord; }}
    [NotNull] public IViewableList<RdAddWordUndoRedoHandler> AddWordUndoRedoHandlers { get { return _AddWordUndoRedoHandlers; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, RdDictionary> _Dictionaries;
    [NotNull] private readonly RdCall<string, bool> _IsCorrect;
    [NotNull] private readonly RdCall<string, List<string>> _Suggest;
    [NotNull] private readonly RdSignal<bool> _EngineUpdated;
    [NotNull] private readonly RdSignal<AddWordArgs> _AddRemoveWord;
    [NotNull] private readonly RdList<RdAddWordUndoRedoHandler> _AddWordUndoRedoHandlers;
    
    //primary constructor
    private SpellCheckerModel(
      [NotNull] RdMap<string, RdDictionary> dictionaries,
      [NotNull] RdCall<string, bool> isCorrect,
      [NotNull] RdCall<string, List<string>> suggest,
      [NotNull] RdSignal<bool> engineUpdated,
      [NotNull] RdSignal<AddWordArgs> addRemoveWord,
      [NotNull] RdList<RdAddWordUndoRedoHandler> addWordUndoRedoHandlers
    )
    {
      if (dictionaries == null) throw new ArgumentNullException("dictionaries");
      if (isCorrect == null) throw new ArgumentNullException("isCorrect");
      if (suggest == null) throw new ArgumentNullException("suggest");
      if (engineUpdated == null) throw new ArgumentNullException("engineUpdated");
      if (addRemoveWord == null) throw new ArgumentNullException("addRemoveWord");
      if (addWordUndoRedoHandlers == null) throw new ArgumentNullException("addWordUndoRedoHandlers");
      
      _Dictionaries = dictionaries;
      _IsCorrect = isCorrect;
      _Suggest = suggest;
      _EngineUpdated = engineUpdated;
      _AddRemoveWord = addRemoveWord;
      _AddWordUndoRedoHandlers = addWordUndoRedoHandlers;
      _IsCorrect.Async = true;
      _Suggest.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("dictionaries", _Dictionaries));
      BindableChildren.Add(new KeyValuePair<string, object>("isCorrect", _IsCorrect));
      BindableChildren.Add(new KeyValuePair<string, object>("suggest", _Suggest));
      BindableChildren.Add(new KeyValuePair<string, object>("engineUpdated", _EngineUpdated));
      BindableChildren.Add(new KeyValuePair<string, object>("addRemoveWord", _AddRemoveWord));
      BindableChildren.Add(new KeyValuePair<string, object>("addWordUndoRedoHandlers", _AddWordUndoRedoHandlers));
    }
    //secondary constructor
    internal SpellCheckerModel (
    ) : this (
      new RdMap<string, RdDictionary>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, RdDictionary.Read, RdDictionary.Write),
      new RdCall<string, bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdCall<string, List<string>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ReadStringList, WriteStringList),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<AddWordArgs>(AddWordArgs.Read, AddWordArgs.Write),
      new RdList<RdAddWordUndoRedoHandler>(RdAddWordUndoRedoHandler.Read, RdAddWordUndoRedoHandler.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    
    protected override long SerializationHash => 3481618900199079881L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdDictionary.Read, RdDictionary.Write);
      serializers.Register(AddWordArgs.Read, AddWordArgs.Write);
      serializers.Register(RdAddWordUndoRedoHandler.Read, RdAddWordUndoRedoHandler.Write);
      serializers.RegisterEnum<AddRemove>();
      serializers.RegisterEnum<LayerKind>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SpellCheckerModel (");
      using (printer.IndentCookie()) {
        printer.Print("dictionaries = "); _Dictionaries.PrintEx(printer); printer.Println();
        printer.Print("isCorrect = "); _IsCorrect.PrintEx(printer); printer.Println();
        printer.Print("suggest = "); _Suggest.PrintEx(printer); printer.Println();
        printer.Print("engineUpdated = "); _EngineUpdated.PrintEx(printer); printer.Println();
        printer.Print("addRemoveWord = "); _AddRemoveWord.PrintEx(printer); printer.Println();
        printer.Print("addWordUndoRedoHandlers = "); _AddWordUndoRedoHandlers.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionSpellCheckerModelEx
   {
    public static SpellCheckerModel GetSpellCheckerModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("spellCheckerModel", () => new SpellCheckerModel());
    }
  }
  
  
  public enum AddRemove {
    Add,
    Remove
  }
  
  
  public class AddWordArgs : IPrintable, IEquatable<AddWordArgs> {
    //fields
    //public fields
    [NotNull] public string Word {get; private set;}
    public AddRemove Operation {get; private set;}
    public LayerKind Layer {get; private set;}
    
    //private fields
    //primary constructor
    public AddWordArgs(
      [NotNull] string word,
      AddRemove operation,
      LayerKind layer
    )
    {
      if (word == null) throw new ArgumentNullException("word");
      
      Word = word;
      Operation = operation;
      Layer = layer;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddWordArgs> Read = (ctx, reader) => 
    {
      var word = reader.ReadString();
      var operation = (AddRemove)reader.ReadInt();
      var layer = (LayerKind)reader.ReadInt();
      return new AddWordArgs(word, operation, layer);
    };
    
    public static CtxWriteDelegate<AddWordArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Word);
      writer.Write((int)value.Operation);
      writer.Write((int)value.Layer);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddWordArgs) obj);
    }
    public bool Equals(AddWordArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Word == other.Word && Operation == other.Operation && Layer == other.Layer;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Word.GetHashCode();
        hash = hash * 31 + (int) Operation;
        hash = hash * 31 + (int) Layer;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddWordArgs (");
      using (printer.IndentCookie()) {
        printer.Print("word = "); Word.PrintEx(printer); printer.Println();
        printer.Print("operation = "); Operation.PrintEx(printer); printer.Println();
        printer.Print("layer = "); Layer.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum LayerKind {
    Application,
    Project
  }
  
  
  public class RdAddWordUndoRedoHandler : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string DocumentLocation {get; private set;}
    [NotNull] public ISink<RdVoid> Undo { get { return _Undo; }}
    [NotNull] public ISink<RdVoid> Redo { get { return _Redo; }}
    [NotNull] public IRdProperty<bool> Expired { get { return _Expired; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Undo;
    [NotNull] private readonly RdSignal<RdVoid> _Redo;
    [NotNull] private readonly RdProperty<bool> _Expired;
    
    //primary constructor
    private RdAddWordUndoRedoHandler(
      [NotNull] string documentLocation,
      [NotNull] RdSignal<RdVoid> undo,
      [NotNull] RdSignal<RdVoid> redo,
      [NotNull] RdProperty<bool> expired
    )
    {
      if (documentLocation == null) throw new ArgumentNullException("documentLocation");
      if (undo == null) throw new ArgumentNullException("undo");
      if (redo == null) throw new ArgumentNullException("redo");
      if (expired == null) throw new ArgumentNullException("expired");
      
      DocumentLocation = documentLocation;
      _Undo = undo;
      _Redo = redo;
      _Expired = expired;
      _Expired.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("undo", _Undo));
      BindableChildren.Add(new KeyValuePair<string, object>("redo", _Redo));
      BindableChildren.Add(new KeyValuePair<string, object>("expired", _Expired));
    }
    //secondary constructor
    public RdAddWordUndoRedoHandler (
      [NotNull] string documentLocation
    ) : this (
      documentLocation,
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdAddWordUndoRedoHandler> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var documentLocation = reader.ReadString();
      var undo = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var redo = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var expired = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new RdAddWordUndoRedoHandler(documentLocation, undo, redo, expired).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdAddWordUndoRedoHandler> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.DocumentLocation);
      RdSignal<RdVoid>.Write(ctx, writer, value._Undo);
      RdSignal<RdVoid>.Write(ctx, writer, value._Redo);
      RdProperty<bool>.Write(ctx, writer, value._Expired);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdAddWordUndoRedoHandler (");
      using (printer.IndentCookie()) {
        printer.Print("documentLocation = "); DocumentLocation.PrintEx(printer); printer.Println();
        printer.Print("undo = "); _Undo.PrintEx(printer); printer.Println();
        printer.Print("redo = "); _Redo.PrintEx(printer); printer.Println();
        printer.Print("expired = "); _Expired.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdDictionary : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IViewableSet<string> Content { get { return _Content; }}
    
    //private fields
    [NotNull] private readonly RdSet<string> _Content;
    
    //primary constructor
    private RdDictionary(
      [NotNull] RdSet<string> content
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      _Content = content;
      _Content.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public RdDictionary (
    ) : this (
      new RdSet<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdDictionary> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = RdSet<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new RdDictionary(content).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdDictionary> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSet<string>.Write(ctx, writer, value._Content);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdDictionary (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
