using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class TestModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<RdVoid, RdVoid> SyncImpulse { get { return _SyncImpulse; }}
    [NotNull] public RdEndpoint<string, RdVoid> CleanupDocuments { get { return _CleanupDocuments; }}
    [NotNull] public RdEndpoint<string, int> WaitForCaches { get { return _WaitForCaches; }}
    [NotNull] public RdEndpoint<string, RdVoid> FlushQueueFromTests { get { return _FlushQueueFromTests; }}
    [NotNull] public RdEndpoint<RdTestSettingsEntry, RdVoid> SetSetting { get { return _SetSetting; }}
    [NotNull] public RdEndpoint<RdVoid, RdVoid> ResetAllSettings { get { return _ResetAllSettings; }}
    [NotNull] public RdEndpoint<bool, RdVoid> ResetSettingsLayer { get { return _ResetSettingsLayer; }}
    [NotNull] public IRdProperty<string> ActiveToolsetPath { get { return _ActiveToolsetPath; }}
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] public IRdProperty<BulbTestState> BulbTestStateInfo { get { return _BulbTestStateInfo; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _SyncImpulse;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _CleanupDocuments;
    [NotNull] private readonly RdEndpoint<string, int> _WaitForCaches;
    [NotNull] private readonly RdEndpoint<string, RdVoid> _FlushQueueFromTests;
    [NotNull] private readonly RdEndpoint<RdTestSettingsEntry, RdVoid> _SetSetting;
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _ResetAllSettings;
    [NotNull] private readonly RdEndpoint<bool, RdVoid> _ResetSettingsLayer;
    [NotNull] private readonly RdProperty<string> _ActiveToolsetPath;
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] private readonly RdProperty<BulbTestState> _BulbTestStateInfo;
    
    //primary constructor
    private TestModel(
      [NotNull] RdEndpoint<RdVoid, RdVoid> syncImpulse,
      [NotNull] RdEndpoint<string, RdVoid> cleanupDocuments,
      [NotNull] RdEndpoint<string, int> waitForCaches,
      [NotNull] RdEndpoint<string, RdVoid> flushQueueFromTests,
      [NotNull] RdEndpoint<RdTestSettingsEntry, RdVoid> setSetting,
      [NotNull] RdEndpoint<RdVoid, RdVoid> resetAllSettings,
      [NotNull] RdEndpoint<bool, RdVoid> resetSettingsLayer,
      [NotNull] RdProperty<string> activeToolsetPath,
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdProperty<BulbTestState> bulbTestStateInfo
    )
    {
      if (syncImpulse == null) throw new ArgumentNullException("syncImpulse");
      if (cleanupDocuments == null) throw new ArgumentNullException("cleanupDocuments");
      if (waitForCaches == null) throw new ArgumentNullException("waitForCaches");
      if (flushQueueFromTests == null) throw new ArgumentNullException("flushQueueFromTests");
      if (setSetting == null) throw new ArgumentNullException("setSetting");
      if (resetAllSettings == null) throw new ArgumentNullException("resetAllSettings");
      if (resetSettingsLayer == null) throw new ArgumentNullException("resetSettingsLayer");
      if (activeToolsetPath == null) throw new ArgumentNullException("activeToolsetPath");
      if (ready == null) throw new ArgumentNullException("ready");
      if (bulbTestStateInfo == null) throw new ArgumentNullException("bulbTestStateInfo");
      
      _SyncImpulse = syncImpulse;
      _CleanupDocuments = cleanupDocuments;
      _WaitForCaches = waitForCaches;
      _FlushQueueFromTests = flushQueueFromTests;
      _SetSetting = setSetting;
      _ResetAllSettings = resetAllSettings;
      _ResetSettingsLayer = resetSettingsLayer;
      _ActiveToolsetPath = activeToolsetPath;
      _Ready = ready;
      _BulbTestStateInfo = bulbTestStateInfo;
      _ActiveToolsetPath.OptimizeNested = true;
      _Ready.OptimizeNested = true;
      _BulbTestStateInfo.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("syncImpulse", _SyncImpulse));
      BindableChildren.Add(new KeyValuePair<string, object>("cleanupDocuments", _CleanupDocuments));
      BindableChildren.Add(new KeyValuePair<string, object>("waitForCaches", _WaitForCaches));
      BindableChildren.Add(new KeyValuePair<string, object>("flushQueueFromTests", _FlushQueueFromTests));
      BindableChildren.Add(new KeyValuePair<string, object>("setSetting", _SetSetting));
      BindableChildren.Add(new KeyValuePair<string, object>("resetAllSettings", _ResetAllSettings));
      BindableChildren.Add(new KeyValuePair<string, object>("resetSettingsLayer", _ResetSettingsLayer));
      BindableChildren.Add(new KeyValuePair<string, object>("activeToolsetPath", _ActiveToolsetPath));
      BindableChildren.Add(new KeyValuePair<string, object>("ready", _Ready));
      BindableChildren.Add(new KeyValuePair<string, object>("bulbTestStateInfo", _BulbTestStateInfo));
    }
    //secondary constructor
    private TestModel (
    ) : this (
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<string, int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdEndpoint<string, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdTestSettingsEntry, RdVoid>(RdTestSettingsEntry.Read, RdTestSettingsEntry.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<RdVoid, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdEndpoint<bool, RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<BulbTestState>(BulbTestState.Read, BulbTestState.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 7925142738719236316L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(RdTestSettingsEntry.Read, RdTestSettingsEntry.Write);
      serializers.Register(ReadyTestState.Read, ReadyTestState.Write);
      serializers.Register(NotReadyTestState.Read, NotReadyTestState.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public TestModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TestModel (");
      using (printer.IndentCookie()) {
        printer.Print("syncImpulse = "); _SyncImpulse.PrintEx(printer); printer.Println();
        printer.Print("cleanupDocuments = "); _CleanupDocuments.PrintEx(printer); printer.Println();
        printer.Print("waitForCaches = "); _WaitForCaches.PrintEx(printer); printer.Println();
        printer.Print("flushQueueFromTests = "); _FlushQueueFromTests.PrintEx(printer); printer.Println();
        printer.Print("setSetting = "); _SetSetting.PrintEx(printer); printer.Println();
        printer.Print("resetAllSettings = "); _ResetAllSettings.PrintEx(printer); printer.Println();
        printer.Print("resetSettingsLayer = "); _ResetSettingsLayer.PrintEx(printer); printer.Println();
        printer.Print("activeToolsetPath = "); _ActiveToolsetPath.PrintEx(printer); printer.Println();
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("bulbTestStateInfo = "); _BulbTestStateInfo.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BulbTestState {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BulbTestState> Read = Polymorphic<BulbTestState>.ReadAbstract(BulbTestState_Unknown.Read);
    
    public static CtxWriteDelegate<BulbTestState> Write = Polymorphic<BulbTestState>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BulbTestState_Unknown : BulbTestState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BulbTestState_Unknown> Read = (ctx, reader) => 
    {
      return new BulbTestState_Unknown();
    };
    
    public static new CtxWriteDelegate<BulbTestState_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BulbTestState_Unknown) obj);
    }
    public bool Equals(BulbTestState_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BulbTestState_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NotReadyTestState : BulbTestState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NotReadyTestState> Read = (ctx, reader) => 
    {
      return new NotReadyTestState();
    };
    
    public static new CtxWriteDelegate<NotReadyTestState> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((NotReadyTestState) obj);
    }
    public bool Equals(NotReadyTestState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("NotReadyTestState (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdTestSettingsEntry : IPrintable, IEquatable<RdTestSettingsEntry> {
    //fields
    //public fields
    [NotNull] public string Key {get; private set;}
    [NotNull] public string Value {get; private set;}
    
    //private fields
    //primary constructor
    public RdTestSettingsEntry(
      [NotNull] string key,
      [NotNull] string value
    )
    {
      if (key == null) throw new ArgumentNullException("key");
      if (value == null) throw new ArgumentNullException("value");
      
      Key = key;
      Value = value;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdTestSettingsEntry> Read = (ctx, reader) => 
    {
      var key = reader.ReadString();
      var value = reader.ReadString();
      return new RdTestSettingsEntry(key, value);
    };
    
    public static CtxWriteDelegate<RdTestSettingsEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Key);
      writer.Write(value.Value);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdTestSettingsEntry) obj);
    }
    public bool Equals(RdTestSettingsEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Key == other.Key && Value == other.Value;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Key.GetHashCode();
        hash = hash * 31 + Value.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdTestSettingsEntry (");
      using (printer.IndentCookie()) {
        printer.Print("key = "); Key.PrintEx(printer); printer.Println();
        printer.Print("value = "); Value.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReadyTestState : BulbTestState
   {
    //fields
    //public fields
    public bool UponInvalidatedDaemon {get; private set;}
    public bool CreatedWithHighlighterUnderCaret {get; private set;}
    
    //private fields
    //primary constructor
    public ReadyTestState(
      bool uponInvalidatedDaemon,
      bool createdWithHighlighterUnderCaret
    )
    {
      UponInvalidatedDaemon = uponInvalidatedDaemon;
      CreatedWithHighlighterUnderCaret = createdWithHighlighterUnderCaret;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ReadyTestState> Read = (ctx, reader) => 
    {
      var uponInvalidatedDaemon = reader.ReadBool();
      var createdWithHighlighterUnderCaret = reader.ReadBool();
      return new ReadyTestState(uponInvalidatedDaemon, createdWithHighlighterUnderCaret);
    };
    
    public static new CtxWriteDelegate<ReadyTestState> Write = (ctx, writer, value) => 
    {
      writer.Write(value.UponInvalidatedDaemon);
      writer.Write(value.CreatedWithHighlighterUnderCaret);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReadyTestState) obj);
    }
    public bool Equals(ReadyTestState other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return UponInvalidatedDaemon == other.UponInvalidatedDaemon && CreatedWithHighlighterUnderCaret == other.CreatedWithHighlighterUnderCaret;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + UponInvalidatedDaemon.GetHashCode();
        hash = hash * 31 + CreatedWithHighlighterUnderCaret.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReadyTestState (");
      using (printer.IndentCookie()) {
        printer.Print("uponInvalidatedDaemon = "); UponInvalidatedDaemon.PrintEx(printer); printer.Println();
        printer.Print("createdWithHighlighterUnderCaret = "); CreatedWithHighlighterUnderCaret.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
