using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [JetBrains.Application.ShellComponent]
  public class TextModel : RdExtBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    private TextModel(
    )
    {
    }
    //secondary constructor
    //statics
    
    
    
    protected override long SerializationHash => 6719722094415850906L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.OtOperationSerializer.ReadDelegate, JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.OtOperationSerializer.WriteDelegate);
      serializers.RegisterEnum<JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdChangeOrigin>();
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.RdAck.Read, JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.RdAck.Write);
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.RdOtState.Read, JetBrains.Platform.RdFramework.Text.Impl.Ot.Intrinsics.RdOtState.Write);
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferChange.ReadDelegate, JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferChange.WriteDelegate);
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdAssertion.Read, JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdAssertion.Write);
      serializers.Register(JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferState.Read, JetBrains.Platform.RdFramework.Text.Impl.Intrinsics.RdTextBufferState.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public TextModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TextModel (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
