using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class TodoModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IViewableMap<string, JetBrains.Rider.Model.TodoItems> TodoItems { get { return _TodoItems; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.TodoPatterns> TodoPatterns { get { return _TodoPatterns; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, JetBrains.Rider.Model.TodoItems> _TodoItems;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.TodoPatterns> _TodoPatterns;
    
    //primary constructor
    private TodoModel(
      [NotNull] RdMap<string, JetBrains.Rider.Model.TodoItems> todoItems,
      [NotNull] RdProperty<JetBrains.Rider.Model.TodoPatterns> todoPatterns
    )
    {
      if (todoItems == null) throw new ArgumentNullException("todoItems");
      if (todoPatterns == null) throw new ArgumentNullException("todoPatterns");
      
      _TodoItems = todoItems;
      _TodoPatterns = todoPatterns;
      _TodoItems.Async = true;
      BindableChildren.Add(new KeyValuePair<string, object>("todoItems", _TodoItems));
      BindableChildren.Add(new KeyValuePair<string, object>("todoPatterns", _TodoPatterns));
    }
    //secondary constructor
    internal TodoModel (
    ) : this (
      new RdMap<string, JetBrains.Rider.Model.TodoItems>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, JetBrains.Rider.Model.TodoItems.Read, JetBrains.Rider.Model.TodoItems.Write),
      new RdProperty<JetBrains.Rider.Model.TodoPatterns>(JetBrains.Rider.Model.TodoPatterns.Read, JetBrains.Rider.Model.TodoPatterns.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5595688833056992965L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(TodoItem.Read, TodoItem.Write);
      serializers.Register(JetBrains.Rider.Model.TodoItems.Read, JetBrains.Rider.Model.TodoItems.Write);
      serializers.RegisterEnum<TodoIconStyle>();
      serializers.Register(TodoPattern.Read, TodoPattern.Write);
      serializers.Register(JetBrains.Rider.Model.TodoPatterns.Read, JetBrains.Rider.Model.TodoPatterns.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoModel (");
      using (printer.IndentCookie()) {
        printer.Print("todoItems = "); _TodoItems.PrintEx(printer); printer.Println();
        printer.Print("todoPatterns = "); _TodoPatterns.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionTodoModelEx
   {
    public static TodoModel GetTodoModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("todoModel", () => new TodoModel());
    }
  }
  
  
  public enum TodoIconStyle {
    None,
    Edit,
    Error,
    Info,
    Question,
    Warning
  }
  
  
  public class TodoItem : RdBindableBase {
    //fields
    //public fields
    public int Start {get; private set;}
    public int End {get; private set;}
    [NotNull] public string PatternId {get; private set;}
    
    //private fields
    //primary constructor
    public TodoItem(
      int start,
      int end,
      [NotNull] string patternId
    )
    {
      if (patternId == null) throw new ArgumentNullException("patternId");
      
      Start = start;
      End = end;
      PatternId = patternId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var start = reader.ReadInt();
      var end = reader.ReadInt();
      var patternId = reader.ReadString();
      return new TodoItem(start, end, patternId).WithId(_id);
    };
    
    public static CtxWriteDelegate<TodoItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Start);
      writer.Write(value.End);
      writer.Write(value.PatternId);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoItem (");
      using (printer.IndentCookie()) {
        printer.Print("start = "); Start.PrintEx(printer); printer.Println();
        printer.Print("end = "); End.PrintEx(printer); printer.Println();
        printer.Print("patternId = "); PatternId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoItems : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<TodoItem> Values {get; private set;}
    
    //private fields
    //primary constructor
    public TodoItems(
      [NotNull] List<TodoItem> values
    )
    {
      if (values == null) throw new ArgumentNullException("values");
      
      Values = values;
      BindableChildren.Add(new KeyValuePair<string, object>("values", Values));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoItems> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var values = ReadTodoItemList(ctx, reader);
      return new TodoItems(values).WithId(_id);
    };
    public static CtxReadDelegate<List<TodoItem>> ReadTodoItemList = TodoItem.Read.List();
    
    public static CtxWriteDelegate<TodoItems> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteTodoItemList(ctx, writer, value.Values);
    };
    public static CtxWriteDelegate<List<TodoItem>> WriteTodoItemList = TodoItem.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoItems (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoPattern : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string Pattern {get; private set;}
    public bool CaseSensitive {get; private set;}
    public TodoIconStyle IconStyle {get; private set;}
    [NotNull] public RgbColor Color {get; private set;}
    
    //private fields
    //primary constructor
    public TodoPattern(
      [NotNull] string id,
      [NotNull] string pattern,
      bool caseSensitive,
      TodoIconStyle iconStyle,
      [NotNull] RgbColor color
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (pattern == null) throw new ArgumentNullException("pattern");
      if (color == null) throw new ArgumentNullException("color");
      
      Id = id;
      Pattern = pattern;
      CaseSensitive = caseSensitive;
      IconStyle = iconStyle;
      Color = color;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoPattern> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadString();
      var pattern = reader.ReadString();
      var caseSensitive = reader.ReadBool();
      var iconStyle = (TodoIconStyle)reader.ReadInt();
      var color = RgbColor.Read(ctx, reader);
      return new TodoPattern(id, pattern, caseSensitive, iconStyle, color).WithId(_id);
    };
    
    public static CtxWriteDelegate<TodoPattern> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.Pattern);
      writer.Write(value.CaseSensitive);
      writer.Write((int)value.IconStyle);
      RgbColor.Write(ctx, writer, value.Color);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoPattern (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("pattern = "); Pattern.PrintEx(printer); printer.Println();
        printer.Print("caseSensitive = "); CaseSensitive.PrintEx(printer); printer.Println();
        printer.Print("iconStyle = "); IconStyle.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TodoPatterns : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<TodoPattern> Patterns {get; private set;}
    
    //private fields
    //primary constructor
    public TodoPatterns(
      [NotNull] List<TodoPattern> patterns
    )
    {
      if (patterns == null) throw new ArgumentNullException("patterns");
      
      Patterns = patterns;
      BindableChildren.Add(new KeyValuePair<string, object>("patterns", Patterns));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TodoPatterns> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var patterns = ReadTodoPatternList(ctx, reader);
      return new TodoPatterns(patterns).WithId(_id);
    };
    public static CtxReadDelegate<List<TodoPattern>> ReadTodoPatternList = TodoPattern.Read.List();
    
    public static CtxWriteDelegate<TodoPatterns> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteTodoPatternList(ctx, writer, value.Patterns);
    };
    public static CtxWriteDelegate<List<TodoPattern>> WriteTodoPatternList = TodoPattern.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TodoPatterns (");
      using (printer.IndentCookie()) {
        printer.Print("patterns = "); Patterns.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
