using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class TypingAssistModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdEndpoint<TypeData, bool> EmulateType { get { return _EmulateType; }}
    [NotNull] public ISink<TypeData> ReadonlyType { get { return _ReadonlyType; }}
    
    //private fields
    [NotNull] private readonly RdEndpoint<TypeData, bool> _EmulateType;
    [NotNull] private readonly RdSignal<TypeData> _ReadonlyType;
    
    //primary constructor
    private TypingAssistModel(
      [NotNull] RdEndpoint<TypeData, bool> emulateType,
      [NotNull] RdSignal<TypeData> readonlyType
    )
    {
      if (emulateType == null) throw new ArgumentNullException("emulateType");
      if (readonlyType == null) throw new ArgumentNullException("readonlyType");
      
      _EmulateType = emulateType;
      _ReadonlyType = readonlyType;
      BindableChildren.Add(new KeyValuePair<string, object>("emulateType", _EmulateType));
      BindableChildren.Add(new KeyValuePair<string, object>("readonlyType", _ReadonlyType));
    }
    //secondary constructor
    internal TypingAssistModel (
    ) : this (
      new RdEndpoint<TypeData, bool>(TypeData.Read, TypeData.Write, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<TypeData>(TypeData.Read, TypeData.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 5665207816566981510L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(TypeData.Read, TypeData.Write);
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("TypingAssistModel (");
      using (printer.IndentCookie()) {
        printer.Print("emulateType = "); _EmulateType.PrintEx(printer); printer.Println();
        printer.Print("readonlyType = "); _ReadonlyType.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionTypingAssistModelEx
   {
    public static TypingAssistModel GetTypingAssistModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("typingAssistModel", () => new TypingAssistModel());
    }
  }
  
  
  public class TypeData : IPrintable, IEquatable<TypeData> {
    //fields
    //public fields
    public char TypedChar {get; private set;}
    public bool IsCompletionTerminator {get; private set;}
    public int Timestamp {get; private set;}
    
    //private fields
    //primary constructor
    public TypeData(
      char typedChar,
      bool isCompletionTerminator,
      int timestamp
    )
    {
      TypedChar = typedChar;
      IsCompletionTerminator = isCompletionTerminator;
      Timestamp = timestamp;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TypeData> Read = (ctx, reader) => 
    {
      var typedChar = reader.ReadChar();
      var isCompletionTerminator = reader.ReadBool();
      var timestamp = reader.ReadInt();
      return new TypeData(typedChar, isCompletionTerminator, timestamp);
    };
    
    public static CtxWriteDelegate<TypeData> Write = (ctx, writer, value) => 
    {
      writer.Write(value.TypedChar);
      writer.Write(value.IsCompletionTerminator);
      writer.Write(value.Timestamp);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TypeData) obj);
    }
    public bool Equals(TypeData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return TypedChar == other.TypedChar && IsCompletionTerminator == other.IsCompletionTerminator && Timestamp == other.Timestamp;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + TypedChar.GetHashCode();
        hash = hash * 31 + IsCompletionTerminator.GetHashCode();
        hash = hash * 31 + Timestamp.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TypeData (");
      using (printer.IndentCookie()) {
        printer.Print("typedChar = "); TypedChar.PrintEx(printer); printer.Println();
        printer.Print("isCompletionTerminator = "); IsCompletionTerminator.PrintEx(printer); printer.Println();
        printer.Print("timestamp = "); Timestamp.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
