using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.UIAutomation
{
  
  
  [JetBrains.Application.ShellComponent]
  public class UIAutomationInteractionModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<BeControl> CurrentUIElement { get { return _CurrentUIElement; }}
    
    //private fields
    [NotNull] private readonly RdProperty<BeControl> _CurrentUIElement;
    
    //primary constructor
    private UIAutomationInteractionModel(
      [NotNull] RdProperty<BeControl> currentUIElement
    )
    {
      if (currentUIElement == null) throw new ArgumentNullException("currentUIElement");
      
      _CurrentUIElement = currentUIElement;
      _CurrentUIElement.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("currentUIElement", _CurrentUIElement));
    }
    //secondary constructor
    private UIAutomationInteractionModel (
    ) : this (
      new RdProperty<BeControl>(ReadBeControlNullable, WriteBeControlNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<BeControl> ReadBeControlNullable = BeControl.Read.NullableClass();
    
    public static CtxWriteDelegate<BeControl> WriteBeControlNullable = BeControl.Write.NullableClass();
    
    protected override long SerializationHash => 6121358944954168234L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(BeControlConstant.Read, BeControlConstant.Write);
      serializers.RegisterEnum<ValidationStates>();
      serializers.RegisterEnum<PathChooser>();
      serializers.Register(ValidationResult.Read, ValidationResult.Write);
      serializers.Register(BeLabel.Read, BeLabel.Write);
      serializers.Register(BeHeader.Read, BeHeader.Write);
      serializers.Register(BeSpacer.Read, BeSpacer.Write);
      serializers.RegisterEnum<BeTreeSelection>();
      serializers.RegisterEnum<GridOrientation>();
      serializers.RegisterEnum<MarginType>();
      serializers.Register(RdUnitSize.Read, RdUnitSize.Write);
      serializers.Register(BeWrap.Read, BeWrap.Write);
      serializers.Register(BeGridElement.Read, BeGridElement.Write);
      serializers.Register(BeSpanColumnElement.Read, BeSpanColumnElement.Write);
      serializers.Register(BeSpanRowElement.Read, BeSpanRowElement.Write);
      serializers.Register(BeSpanGrid.Read, BeSpanGrid.Write);
      serializers.Register(BeGrid.Read, BeGrid.Write);
      serializers.Register(BeColumnDefinition.Read, BeColumnDefinition.Write);
      serializers.Register(BeTreeGridLine.Read, BeTreeGridLine.Write);
      serializers.Register(BeResharperContextMenu.Read, BeResharperContextMenu.Write);
      serializers.Register(BeTreeConfiguration.Read, BeTreeConfiguration.Write);
      serializers.Register(BeTreeGrid.Read, BeTreeGrid.Write);
      serializers.Register(BeTab.Read, BeTab.Write);
      serializers.Register(BeSplitControl.Read, BeSplitControl.Write);
      serializers.Register(BeTabbedControl.Read, BeTabbedControl.Write);
      serializers.Register(BeIcon.Read, BeIcon.Write);
      serializers.Register(BeButton.Read, BeButton.Write);
      serializers.Register(BeSpinner.Read, BeSpinner.Write);
      serializers.RegisterEnum<DialogResult>();
      serializers.RegisterEnum<DialogModality>();
      serializers.Register(BeDialogSizeFitToContent.Read, BeDialogSizeFitToContent.Write);
      serializers.Register(BeDialogSizeCustom.Read, BeDialogSizeCustom.Write);
      serializers.Register(BeDialogSizePredefined.Read, BeDialogSizePredefined.Write);
      serializers.Register(BeScrollbarPolicy.Read, BeScrollbarPolicy.Write);
      serializers.Register(BeDialog.Read, BeDialog.Write);
      serializers.Register(BeOpenDialogButton.Read, BeOpenDialogButton.Write);
      serializers.Register(BeColor.Read, BeColor.Write);
      serializers.Register(BeColoredControl.Read, BeColoredControl.Write);
      serializers.Register(BeLinkButton.Read, BeLinkButton.Write);
      serializers.Register(BeCompletionItem.Read, BeCompletionItem.Write);
      serializers.Register(BeTextBox.Read, BeTextBox.Write);
      serializers.Register(BeCheckbox.Read, BeCheckbox.Write);
      serializers.Register(BeIconToggleButton.Read, BeIconToggleButton.Write);
      serializers.Register(BeRadioButton.Read, BeRadioButton.Write);
      serializers.Register(BeCustomComboBox.Read, BeCustomComboBox.Write);
      serializers.Register(BeComboBox.Read, BeComboBox.Write);
      serializers.Register(BePathSelectionButton.Read, BePathSelectionButton.Write);
      serializers.Register(BeTextControlWithLanguage.Read, BeTextControlWithLanguage.Write);
      serializers.Register(BeTextControl.Read, BeTextControl.Write);
      serializers.Register(BeCollapsiblePanel.Read, BeCollapsiblePanel.Write);
      serializers.Register(BeRichText.Read, BeRichText.Write);
      serializers.Register(BeToolbar.Read, BeToolbar.Write);
      serializers.RegisterEnum<ControlVisibility>();
      serializers.RegisterEnum<ChildOffsetSize>();
      serializers.RegisterEnum<BeDialogPredefinedSize>();
      
      serializers.RegisterToplevelOnce(typeof(JetBrains.Rider.Model.IdeRoot), JetBrains.Rider.Model.IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    public UIAutomationInteractionModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UIAutomationInteractionModel (");
      using (printer.IndentCookie()) {
        printer.Print("currentUIElement = "); _CurrentUIElement.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdSignal<RdVoid> Click { get { return _Click; }}
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Click;
    [NotNull] private readonly RdProperty<string> _Tooltip;
    
    //primary constructor
    private BeButton(
      [NotNull] RdSignal<RdVoid> click,
      [NotNull] BeControl content,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (click == null) throw new ArgumentNullException("click");
      if (content == null) throw new ArgumentNullException("content");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      
      _Click = click;
      Content = content;
      _Tooltip = tooltip;
      _Tooltip.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("click", _Click));
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
    }
    //secondary constructor
    public BeButton (
      [NotNull] BeControl content
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      content,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var click = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var content = BeControl.Read(ctx, reader);
      var tooltip = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      return new BeButton(click, content, tooltip, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdSignal<RdVoid>.Write(ctx, writer, value._Click);
      BeControl.Write(ctx, writer, value.Content);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeButton (");
      using (printer.IndentCookie()) {
        printer.Print("click = "); _Click.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCheckbox : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeLabel Description {get; private set;}
    [NotNull] public IRdProperty<bool?> Property { get { return _Property; }}
    [NotNull] public IRdProperty<bool> IsThreeState { get { return _IsThreeState; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool?> _Property;
    [NotNull] private readonly RdProperty<bool> _IsThreeState;
    
    //primary constructor
    private BeCheckbox(
      [NotNull] BeLabel description,
      [NotNull] RdProperty<bool?> property,
      [NotNull] RdProperty<bool> isThreeState,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (description == null) throw new ArgumentNullException("description");
      if (property == null) throw new ArgumentNullException("property");
      if (isThreeState == null) throw new ArgumentNullException("isThreeState");
      
      Description = description;
      _Property = property;
      _IsThreeState = isThreeState;
      _Property.OptimizeNested = true;
      _IsThreeState.OptimizeNested = true;
      _Property.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("description", Description));
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
      BindableChildren.Add(new KeyValuePair<string, object>("isThreeState", _IsThreeState));
    }
    //secondary constructor
    public BeCheckbox (
      [NotNull] BeLabel description
    ) : this (
      description,
      new RdProperty<bool?>(ReadBoolNullable, WriteBoolNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeCheckbox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var description = BeLabel.Read(ctx, reader);
      var property = RdProperty<bool?>.Read(ctx, reader, ReadBoolNullable, WriteBoolNullable);
      var isThreeState = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeCheckbox(description, property, isThreeState, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<bool?> ReadBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool.NullableStruct();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeCheckbox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeLabel.Write(ctx, writer, value.Description);
      RdProperty<bool?>.Write(ctx, writer, value._Property);
      RdProperty<bool>.Write(ctx, writer, value._IsThreeState);
    };
    public static CtxWriteDelegate<bool?> WriteBoolNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool.NullableStruct();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCheckbox (");
      using (printer.IndentCookie()) {
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
        printer.Print("isThreeState = "); _IsThreeState.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCollapsiblePanel : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl Contents {get; private set;}
    [NotNull] public IRdProperty<string> HeaderText { get { return _HeaderText; }}
    [NotNull] public IRdProperty<bool> IsExpanded { get { return _IsExpanded; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _HeaderText;
    [NotNull] private readonly RdProperty<bool> _IsExpanded;
    
    //primary constructor
    private BeCollapsiblePanel(
      [NotNull] BeControl contents,
      [NotNull] RdProperty<string> headerText,
      [NotNull] RdProperty<bool> isExpanded,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (contents == null) throw new ArgumentNullException("contents");
      if (headerText == null) throw new ArgumentNullException("headerText");
      if (isExpanded == null) throw new ArgumentNullException("isExpanded");
      
      Contents = contents;
      _HeaderText = headerText;
      _IsExpanded = isExpanded;
      _HeaderText.OptimizeNested = true;
      _IsExpanded.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("contents", Contents));
      BindableChildren.Add(new KeyValuePair<string, object>("headerText", _HeaderText));
      BindableChildren.Add(new KeyValuePair<string, object>("isExpanded", _IsExpanded));
    }
    //secondary constructor
    public BeCollapsiblePanel (
      [NotNull] BeControl contents
    ) : this (
      contents,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeCollapsiblePanel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var contents = BeControl.Read(ctx, reader);
      var headerText = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isExpanded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      return new BeCollapsiblePanel(contents, headerText, isExpanded, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeCollapsiblePanel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Contents);
      RdProperty<string>.Write(ctx, writer, value._HeaderText);
      RdProperty<bool>.Write(ctx, writer, value._IsExpanded);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCollapsiblePanel (");
      using (printer.IndentCookie()) {
        printer.Print("contents = "); Contents.PrintEx(printer); printer.Println();
        printer.Print("headerText = "); _HeaderText.PrintEx(printer); printer.Println();
        printer.Print("isExpanded = "); _IsExpanded.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeColor : RdBindableBase {
    //fields
    //public fields
    public int R {get; private set;}
    public int G {get; private set;}
    public int B {get; private set;}
    public int A {get; private set;}
    
    //private fields
    //primary constructor
    public BeColor(
      int r,
      int g,
      int b,
      int a
    )
    {
      R = r;
      G = g;
      B = b;
      A = a;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeColor> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var r = reader.ReadInt();
      var g = reader.ReadInt();
      var b = reader.ReadInt();
      var a = reader.ReadInt();
      return new BeColor(r, g, b, a).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeColor> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.R);
      writer.Write(value.G);
      writer.Write(value.B);
      writer.Write(value.A);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeColor (");
      using (printer.IndentCookie()) {
        printer.Print("r = "); R.PrintEx(printer); printer.Println();
        printer.Print("g = "); G.PrintEx(printer); printer.Println();
        printer.Print("b = "); B.PrintEx(printer); printer.Println();
        printer.Print("a = "); A.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeColoredControl : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public BeColor Color {get; private set;}
    
    //private fields
    //primary constructor
    private BeColoredControl(
      [NotNull] BeControl content,
      [NotNull] BeColor color,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (color == null) throw new ArgumentNullException("color");
      
      Content = content;
      Color = color;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("color", Color));
    }
    //secondary constructor
    public BeColoredControl (
      [NotNull] BeControl content,
      [NotNull] BeColor color
    ) : this (
      content,
      color,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeColoredControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      var color = BeColor.Read(ctx, reader);
      return new BeColoredControl(content, color, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeColoredControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
      BeColor.Write(ctx, writer, value.Color);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeColoredControl (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("color = "); Color.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeColumnDefinition : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ColumnName {get; private set;}
    [NotNull] public RdUnitSize Size {get; private set;}
    
    //private fields
    //primary constructor
    public BeColumnDefinition(
      [NotNull] string columnName,
      [NotNull] RdUnitSize size
    )
    {
      if (columnName == null) throw new ArgumentNullException("columnName");
      if (size == null) throw new ArgumentNullException("size");
      
      ColumnName = columnName;
      Size = size;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeColumnDefinition> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var columnName = reader.ReadString();
      var size = RdUnitSize.Read(ctx, reader);
      return new BeColumnDefinition(columnName, size).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeColumnDefinition> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ColumnName);
      RdUnitSize.Write(ctx, writer, value.Size);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeColumnDefinition (");
      using (printer.IndentCookie()) {
        printer.Print("columnName = "); ColumnName.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeComboBox : BeControlWithValidation
   {
    //fields
    //public fields
    [NotNull] public IViewableList<string> Values { get { return _Values; }}
    public bool IsEditable {get; private set;}
    [NotNull] public IRdProperty<string> SelectedValue { get { return _SelectedValue; }}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    
    //private fields
    [NotNull] private readonly RdList<string> _Values;
    [NotNull] private readonly RdProperty<string> _SelectedValue;
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    
    //primary constructor
    private BeComboBox(
      [NotNull] RdList<string> values,
      bool isEditable,
      [NotNull] RdProperty<string> selectedValue,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      visible
     ) 
    {
      if (values == null) throw new ArgumentNullException("values");
      if (selectedValue == null) throw new ArgumentNullException("selectedValue");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      
      _Values = values;
      IsEditable = isEditable;
      _SelectedValue = selectedValue;
      _SelectedIndex = selectedIndex;
      _Values.OptimizeNested = true;
      _SelectedValue.OptimizeNested = true;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("values", _Values));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedValue", _SelectedValue));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
    }
    //secondary constructor
    public BeComboBox (
      bool isEditable
    ) : this (
      new RdList<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      isEditable,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeComboBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var values = RdList<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isEditable = reader.ReadBool();
      var selectedValue = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeComboBox(values, isEditable, selectedValue, selectedIndex, validationResult, handledByParent, revalidate, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeComboBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdList<string>.Write(ctx, writer, value._Values);
      writer.Write(value.IsEditable);
      RdProperty<string>.Write(ctx, writer, value._SelectedValue);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeComboBox (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); _Values.PrintEx(printer); printer.Println();
        printer.Print("isEditable = "); IsEditable.PrintEx(printer); printer.Println();
        printer.Print("selectedValue = "); _SelectedValue.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCompletionItem : RdBindableBase {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon LeftIcon {get; private set;}
    [NotNull] public BeRichText LeftText {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> RightIcon { get { return _RightIcon; }}
    [NotNull] public IRdProperty<BeRichText> RightText { get { return _RightText; }}
    [NotNull] public string TranslatedText {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _RightIcon;
    [NotNull] private readonly RdProperty<BeRichText> _RightText;
    
    //primary constructor
    private BeCompletionItem(
      [CanBeNull] JetBrains.Rider.Model.Icon leftIcon,
      [NotNull] BeRichText leftText,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> rightIcon,
      [NotNull] RdProperty<BeRichText> rightText,
      [NotNull] string translatedText
    )
    {
      if (leftText == null) throw new ArgumentNullException("leftText");
      if (rightIcon == null) throw new ArgumentNullException("rightIcon");
      if (rightText == null) throw new ArgumentNullException("rightText");
      if (translatedText == null) throw new ArgumentNullException("translatedText");
      
      LeftIcon = leftIcon;
      LeftText = leftText;
      _RightIcon = rightIcon;
      _RightText = rightText;
      TranslatedText = translatedText;
      _RightIcon.OptimizeNested = true;
      _RightIcon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("leftText", LeftText));
      BindableChildren.Add(new KeyValuePair<string, object>("rightIcon", _RightIcon));
      BindableChildren.Add(new KeyValuePair<string, object>("rightText", _RightText));
    }
    //secondary constructor
    public BeCompletionItem (
      [CanBeNull] JetBrains.Rider.Model.Icon leftIcon,
      [NotNull] BeRichText leftText,
      [NotNull] string translatedText
    ) : this (
      leftIcon,
      leftText,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<BeRichText>(BeRichText.Read, BeRichText.Write),
      translatedText
    ) {}
    //statics
    
    public static CtxReadDelegate<BeCompletionItem> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var leftIcon = ReadIconNullable(ctx, reader);
      var leftText = BeRichText.Read(ctx, reader);
      var rightIcon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var rightText = RdProperty<BeRichText>.Read(ctx, reader, BeRichText.Read, BeRichText.Write);
      var translatedText = reader.ReadString();
      return new BeCompletionItem(leftIcon, leftText, rightIcon, rightText, translatedText).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<BeCompletionItem> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteIconNullable(ctx, writer, value.LeftIcon);
      BeRichText.Write(ctx, writer, value.LeftText);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._RightIcon);
      RdProperty<BeRichText>.Write(ctx, writer, value._RightText);
      writer.Write(value.TranslatedText);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCompletionItem (");
      using (printer.IndentCookie()) {
        printer.Print("leftIcon = "); LeftIcon.PrintEx(printer); printer.Println();
        printer.Print("leftText = "); LeftText.PrintEx(printer); printer.Println();
        printer.Print("rightIcon = "); _RightIcon.PrintEx(printer); printer.Println();
        printer.Print("rightText = "); _RightText.PrintEx(printer); printer.Println();
        printer.Print("translatedText = "); TranslatedText.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeControl : JetBrains.Rider.Model.Popups.ProtoViewModel
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdProperty<string> ControlId { get { return _ControlId; }}
    [NotNull] public IRdProperty<ControlVisibility> Visible { get { return _Visible; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<bool> _Enabled;
    [NotNull] protected readonly RdProperty<string> _ControlId;
    [NotNull] protected readonly RdProperty<ControlVisibility> _Visible;
    
    //primary constructor
    protected BeControl(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    )
    {
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (controlId == null) throw new ArgumentNullException("controlId");
      if (visible == null) throw new ArgumentNullException("visible");
      
      _Enabled = enabled;
      _ControlId = controlId;
      _Visible = visible;
      _Enabled.OptimizeNested = true;
      _ControlId.OptimizeNested = true;
      _Visible.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("controlId", _ControlId));
      BindableChildren.Add(new KeyValuePair<string, object>("visible", _Visible));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControl> Read = Polymorphic<BeControl>.ReadAbstract(BeControl_Unknown.Read);
    
    public static new CtxWriteDelegate<BeControl> Write = Polymorphic<BeControl>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeControl_Unknown : BeControl
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private BeControl_Unknown(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeControl_Unknown (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeControl_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeControl_Unknown(enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeControl_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeControl_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeControlConstant : JetBrains.Rider.Model.RdDataConstant
   {
    //fields
    //public fields
    [CanBeNull] public string EnclosingControlId {get; private set;}
    [CanBeNull] public string ControlId {get; private set;}
    
    //private fields
    //primary constructor
    public BeControlConstant(
      [CanBeNull] string enclosingControlId,
      [CanBeNull] string controlId
    )
    {
      EnclosingControlId = enclosingControlId;
      ControlId = controlId;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlConstant> Read = (ctx, reader) => 
    {
      var enclosingControlId = ReadStringNullable(ctx, reader);
      var controlId = ReadStringNullable(ctx, reader);
      return new BeControlConstant(enclosingControlId, controlId);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<BeControlConstant> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.EnclosingControlId);
      WriteStringNullable(ctx, writer, value.ControlId);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeControlConstant) obj);
    }
    public bool Equals(BeControlConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(EnclosingControlId, other.EnclosingControlId) && Equals(ControlId, other.ControlId);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (EnclosingControlId != null ?EnclosingControlId.GetHashCode() : 0);
        hash = hash * 31 + (ControlId != null ?ControlId.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlConstant (");
      using (printer.IndentCookie()) {
        printer.Print("enclosingControlId = "); EnclosingControlId.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); ControlId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class BeControlWithValidation : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> ValidationResult { get { return _ValidationResult; }}
    [NotNull] public IRdProperty<bool> HandledByParent { get { return _HandledByParent; }}
    [NotNull] public IRdSignal<RdVoid> Revalidate { get { return _Revalidate; }}
    
    //private fields
    [NotNull] protected readonly RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> _ValidationResult;
    [NotNull] protected readonly RdProperty<bool> _HandledByParent;
    [NotNull] protected readonly RdSignal<RdVoid> _Revalidate;
    
    //primary constructor
    protected BeControlWithValidation(
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (validationResult == null) throw new ArgumentNullException("validationResult");
      if (handledByParent == null) throw new ArgumentNullException("handledByParent");
      if (revalidate == null) throw new ArgumentNullException("revalidate");
      
      _ValidationResult = validationResult;
      _HandledByParent = handledByParent;
      _Revalidate = revalidate;
      _HandledByParent.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("validationResult", _ValidationResult));
      BindableChildren.Add(new KeyValuePair<string, object>("handledByParent", _HandledByParent));
      BindableChildren.Add(new KeyValuePair<string, object>("revalidate", _Revalidate));
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeControlWithValidation> Read = Polymorphic<BeControlWithValidation>.ReadAbstract(BeControlWithValidation_Unknown.Read);
    
    public static new CtxWriteDelegate<BeControlWithValidation> Write = Polymorphic<BeControlWithValidation>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeControlWithValidation_Unknown : BeControlWithValidation
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private BeControlWithValidation_Unknown(
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeControlWithValidation_Unknown (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeControlWithValidation_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeControlWithValidation_Unknown(validationResult, handledByParent, revalidate, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeControlWithValidation_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeControlWithValidation_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeCustomComboBox : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeControl>> Values { get { return _Values; }}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeControl>> _Values;
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    
    //primary constructor
    private BeCustomComboBox(
      [NotNull] RdProperty<List<BeControl>> values,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (values == null) throw new ArgumentNullException("values");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      
      _Values = values;
      _SelectedIndex = selectedIndex;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("values", _Values));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
    }
    //secondary constructor
    public BeCustomComboBox (
    ) : this (
      new RdProperty<List<BeControl>>(ReadBeControlList, WriteBeControlList),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeCustomComboBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var values = RdProperty<List<BeControl>>.Read(ctx, reader, ReadBeControlList, WriteBeControlList);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeCustomComboBox(values, selectedIndex, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeControl>> ReadBeControlList = BeControl.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeCustomComboBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<List<BeControl>>.Write(ctx, writer, value._Values);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
    };
    public static CtxWriteDelegate<List<BeControl>> WriteBeControlList = BeControl.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeCustomComboBox (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); _Values.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeDialog : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    public DialogModality Modality {get; private set;}
    [CanBeNull] public string Title {get; private set;}
    [NotNull] public IRdProperty<DialogResult> Result { get { return _Result; }}
    [NotNull] public List<BeButton> Buttons {get; private set;}
    [NotNull] public BeDialogSize Size {get; private set;}
    [NotNull] public BeScrollbarPolicy ScrollbarPolicy {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<DialogResult> _Result;
    
    //primary constructor
    private BeDialog(
      [NotNull] BeControl content,
      DialogModality modality,
      [CanBeNull] string title,
      [NotNull] RdProperty<DialogResult> result,
      [NotNull] List<BeButton> buttons,
      [NotNull] BeDialogSize size,
      [NotNull] BeScrollbarPolicy scrollbarPolicy,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (result == null) throw new ArgumentNullException("result");
      if (buttons == null) throw new ArgumentNullException("buttons");
      if (size == null) throw new ArgumentNullException("size");
      if (scrollbarPolicy == null) throw new ArgumentNullException("scrollbarPolicy");
      
      Content = content;
      Modality = modality;
      Title = title;
      _Result = result;
      Buttons = buttons;
      Size = size;
      ScrollbarPolicy = scrollbarPolicy;
      _Result.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("result", _Result));
      BindableChildren.Add(new KeyValuePair<string, object>("buttons", Buttons));
    }
    //secondary constructor
    public BeDialog (
      [NotNull] BeControl content,
      DialogModality modality,
      [CanBeNull] string title,
      [NotNull] List<BeButton> buttons,
      [NotNull] BeDialogSize size,
      [NotNull] BeScrollbarPolicy scrollbarPolicy
    ) : this (
      content,
      modality,
      title,
      new RdProperty<DialogResult>(ReadDialogResult, WriteDialogResult),
      buttons,
      size,
      scrollbarPolicy,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeDialog> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      var modality = (DialogModality)reader.ReadInt();
      var title = ReadStringNullable(ctx, reader);
      var result = RdProperty<DialogResult>.Read(ctx, reader, ReadDialogResult, WriteDialogResult);
      var buttons = ReadBeButtonList(ctx, reader);
      var size = BeDialogSize.Read(ctx, reader);
      var scrollbarPolicy = BeScrollbarPolicy.Read(ctx, reader);
      return new BeDialog(content, modality, title, result, buttons, size, scrollbarPolicy, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<DialogResult> ReadDialogResult = new CtxReadDelegate<DialogResult>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<DialogResult>);
    public static CtxReadDelegate<List<BeButton>> ReadBeButtonList = BeButton.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeDialog> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
      writer.Write((int)value.Modality);
      WriteStringNullable(ctx, writer, value.Title);
      RdProperty<DialogResult>.Write(ctx, writer, value._Result);
      WriteBeButtonList(ctx, writer, value.Buttons);
      BeDialogSize.Write(ctx, writer, value.Size);
      BeScrollbarPolicy.Write(ctx, writer, value.ScrollbarPolicy);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<DialogResult> WriteDialogResult = new CtxWriteDelegate<DialogResult>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<DialogResult>);
    public static CtxWriteDelegate<List<BeButton>> WriteBeButtonList = BeButton.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialog (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("modality = "); Modality.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("buttons = "); Buttons.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("scrollbarPolicy = "); ScrollbarPolicy.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeDialogPredefinedSize {
    TINY,
    SMALL,
    MEDIUM,
    LARGE,
    HUGE
  }
  
  
  public abstract class BeDialogSize {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeDialogSize> Read = Polymorphic<BeDialogSize>.ReadAbstract(BeDialogSize_Unknown.Read);
    
    public static CtxWriteDelegate<BeDialogSize> Write = Polymorphic<BeDialogSize>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class BeDialogSize_Unknown : BeDialogSize
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeDialogSize_Unknown> Read = (ctx, reader) => 
    {
      return new BeDialogSize_Unknown();
    };
    
    public static new CtxWriteDelegate<BeDialogSize_Unknown> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeDialogSize_Unknown) obj);
    }
    public bool Equals(BeDialogSize_Unknown other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialogSize_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeDialogSizeCustom : BeDialogSize
   {
    //fields
    //public fields
    public int Width {get; private set;}
    public int Height {get; private set;}
    
    //private fields
    //primary constructor
    public BeDialogSizeCustom(
      int width,
      int height
    )
    {
      Width = width;
      Height = height;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeDialogSizeCustom> Read = (ctx, reader) => 
    {
      var width = reader.ReadInt();
      var height = reader.ReadInt();
      return new BeDialogSizeCustom(width, height);
    };
    
    public static new CtxWriteDelegate<BeDialogSizeCustom> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Width);
      writer.Write(value.Height);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeDialogSizeCustom) obj);
    }
    public bool Equals(BeDialogSizeCustom other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Width == other.Width && Height == other.Height;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Width.GetHashCode();
        hash = hash * 31 + Height.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialogSizeCustom (");
      using (printer.IndentCookie()) {
        printer.Print("width = "); Width.PrintEx(printer); printer.Println();
        printer.Print("height = "); Height.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeDialogSizeFitToContent : BeDialogSize
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeDialogSizeFitToContent> Read = (ctx, reader) => 
    {
      return new BeDialogSizeFitToContent();
    };
    
    public static new CtxWriteDelegate<BeDialogSizeFitToContent> Write = (ctx, writer, value) => 
    {
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeDialogSizeFitToContent) obj);
    }
    public bool Equals(BeDialogSizeFitToContent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return true;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialogSizeFitToContent (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeDialogSizePredefined : BeDialogSize
   {
    //fields
    //public fields
    public BeDialogPredefinedSize Size {get; private set;}
    public float Proportion {get; private set;}
    
    //private fields
    //primary constructor
    public BeDialogSizePredefined(
      BeDialogPredefinedSize size,
      float proportion
    )
    {
      Size = size;
      Proportion = proportion;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BeDialogSizePredefined> Read = (ctx, reader) => 
    {
      var size = (BeDialogPredefinedSize)reader.ReadInt();
      var proportion = reader.ReadFloat();
      return new BeDialogSizePredefined(size, proportion);
    };
    
    public static new CtxWriteDelegate<BeDialogSizePredefined> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Size);
      writer.Write(value.Proportion);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeDialogSizePredefined) obj);
    }
    public bool Equals(BeDialogSizePredefined other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Size == other.Size && Proportion == other.Proportion;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Size;
        hash = hash * 31 + Proportion.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeDialogSizePredefined (");
      using (printer.IndentCookie()) {
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
        printer.Print("proportion = "); Proportion.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeGrid : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeGridElement>> Items { get { return _Items; }}
    public GridOrientation Orientation {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeGridElement>> _Items;
    
    //primary constructor
    private BeGrid(
      [NotNull] RdProperty<List<BeGridElement>> items,
      GridOrientation orientation,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (items == null) throw new ArgumentNullException("items");
      
      _Items = items;
      Orientation = orientation;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
    }
    //secondary constructor
    public BeGrid (
      GridOrientation orientation
    ) : this (
      new RdProperty<List<BeGridElement>>(ReadBeGridElementList, WriteBeGridElementList),
      orientation,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var items = RdProperty<List<BeGridElement>>.Read(ctx, reader, ReadBeGridElementList, WriteBeGridElementList);
      var orientation = (GridOrientation)reader.ReadInt();
      return new BeGrid(items, orientation, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeGridElement>> ReadBeGridElementList = BeGridElement.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<List<BeGridElement>>.Write(ctx, writer, value._Items);
      writer.Write((int)value.Orientation);
    };
    public static CtxWriteDelegate<List<BeGridElement>> WriteBeGridElementList = BeGridElement.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeGrid (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("orientation = "); Orientation.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeGridElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    [NotNull] public RdUnitSize Size {get; private set;}
    
    //private fields
    //primary constructor
    public BeGridElement(
      [NotNull] BeControl content,
      [NotNull] RdUnitSize size
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      if (size == null) throw new ArgumentNullException("size");
      
      Content = content;
      Size = size;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeGridElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeControl.Read(ctx, reader);
      var size = RdUnitSize.Read(ctx, reader);
      return new BeGridElement(content, size).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeGridElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeControl.Write(ctx, writer, value.Content);
      RdUnitSize.Write(ctx, writer, value.Size);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeGridElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeHeader : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    
    //primary constructor
    private BeHeader(
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (icon == null) throw new ArgumentNullException("icon");
      
      _Text = text;
      _Icon = icon;
      _Text.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
    }
    //secondary constructor
    public BeHeader (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeHeader> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      return new BeHeader(text, icon, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeHeader> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeHeader (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeIcon : BeControl
   {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    private BeIcon(
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      Icon = icon;
    }
    //secondary constructor
    public BeIcon (
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    ) : this (
      icon,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeIcon> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var icon = ReadIconNullable(ctx, reader);
      return new BeIcon(icon, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeIcon> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeIcon (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeIconToggleButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsChecked { get { return _IsChecked; }}
    [NotNull] public IRdProperty<string> Tooltip { get { return _Tooltip; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsChecked;
    [NotNull] private readonly RdProperty<string> _Tooltip;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    
    //primary constructor
    private BeIconToggleButton(
      [NotNull] RdProperty<bool> isChecked,
      [NotNull] RdProperty<string> tooltip,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (isChecked == null) throw new ArgumentNullException("isChecked");
      if (tooltip == null) throw new ArgumentNullException("tooltip");
      if (icon == null) throw new ArgumentNullException("icon");
      
      _IsChecked = isChecked;
      _Tooltip = tooltip;
      _Icon = icon;
      _IsChecked.OptimizeNested = true;
      _Tooltip.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _Tooltip.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isChecked", _IsChecked));
      BindableChildren.Add(new KeyValuePair<string, object>("tooltip", _Tooltip));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
    }
    //secondary constructor
    public BeIconToggleButton (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<JetBrains.Rider.Model.Icon>(JetBrains.Rider.Model.Icon.Read, JetBrains.Rider.Model.Icon.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeIconToggleButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var isChecked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var tooltip = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, JetBrains.Rider.Model.Icon.Read, JetBrains.Rider.Model.Icon.Write);
      return new BeIconToggleButton(isChecked, tooltip, icon, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeIconToggleButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._IsChecked);
      RdProperty<string>.Write(ctx, writer, value._Tooltip);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeIconToggleButton (");
      using (printer.IndentCookie()) {
        printer.Print("isChecked = "); _IsChecked.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); _Tooltip.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeLabel : BeControl
   {
    //fields
    //public fields
    public bool WrapText {get; private set;}
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<char> Shortcut { get { return _Shortcut; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    [NotNull] public IRdProperty<string> Target { get { return _Target; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<char> _Shortcut;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    [NotNull] private readonly RdProperty<string> _Target;
    
    //primary constructor
    private BeLabel(
      bool wrapText,
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<char> shortcut,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon,
      [NotNull] RdProperty<string> target,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (shortcut == null) throw new ArgumentNullException("shortcut");
      if (icon == null) throw new ArgumentNullException("icon");
      if (target == null) throw new ArgumentNullException("target");
      
      WrapText = wrapText;
      _Text = text;
      _Shortcut = shortcut;
      _Icon = icon;
      _Target = target;
      _Text.OptimizeNested = true;
      _Shortcut.OptimizeNested = true;
      _Icon.OptimizeNested = true;
      _Target.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      _Target.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("shortcut", _Shortcut));
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
      BindableChildren.Add(new KeyValuePair<string, object>("target", _Target));
    }
    //secondary constructor
    public BeLabel (
      bool wrapText
    ) : this (
      wrapText,
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<char>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar),
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeLabel> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var wrapText = reader.ReadBool();
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var shortcut = RdProperty<char>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadChar, JetBrains.Platform.RdFramework.Impl.Serializers.WriteChar);
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      var target = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      return new BeLabel(wrapText, text, shortcut, icon, target, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeLabel> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      writer.Write(value.WrapText);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<char>.Write(ctx, writer, value._Shortcut);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
      RdProperty<string>.Write(ctx, writer, value._Target);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeLabel (");
      using (printer.IndentCookie()) {
        printer.Print("wrapText = "); WrapText.PrintEx(printer); printer.Println();
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("shortcut = "); _Shortcut.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
        printer.Print("target = "); _Target.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeLinkButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl Content {get; private set;}
    
    //private fields
    //primary constructor
    private BeLinkButton(
      [NotNull] BeControl content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeLinkButton (
      [NotNull] BeControl content
    ) : this (
      content,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeLinkButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeControl.Read(ctx, reader);
      return new BeLinkButton(content, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeLinkButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeLinkButton (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeOpenDialogButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeButton Content {get; private set;}
    [NotNull] public IRdProperty<BeDialog> Dialog { get { return _Dialog; }}
    
    //private fields
    [NotNull] private readonly RdProperty<BeDialog> _Dialog;
    
    //primary constructor
    private BeOpenDialogButton(
      [NotNull] BeButton content,
      [NotNull] RdProperty<BeDialog> dialog,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      if (dialog == null) throw new ArgumentNullException("dialog");
      
      Content = content;
      _Dialog = dialog;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
      BindableChildren.Add(new KeyValuePair<string, object>("dialog", _Dialog));
    }
    //secondary constructor
    public BeOpenDialogButton (
      [NotNull] BeButton content
    ) : this (
      content,
      new RdProperty<BeDialog>(BeDialog.Read, BeDialog.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeOpenDialogButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = BeButton.Read(ctx, reader);
      var dialog = RdProperty<BeDialog>.Read(ctx, reader, BeDialog.Read, BeDialog.Write);
      return new BeOpenDialogButton(content, dialog, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeOpenDialogButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeButton.Write(ctx, writer, value.Content);
      RdProperty<BeDialog>.Write(ctx, writer, value._Dialog);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeOpenDialogButton (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("dialog = "); _Dialog.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BePathSelectionButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> SelectedPath { get { return _SelectedPath; }}
    [NotNull] public IRdProperty<string> InitialPath { get { return _InitialPath; }}
    [NotNull] public IRdProperty<string> Mask { get { return _Mask; }}
    public JetBrains.Rider.Model.UIAutomation.PathChooser PathChooser {get; private set;}
    [NotNull] public BeLabel Description {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _SelectedPath;
    [NotNull] private readonly RdProperty<string> _InitialPath;
    [NotNull] private readonly RdProperty<string> _Mask;
    
    //primary constructor
    private BePathSelectionButton(
      [NotNull] RdProperty<string> selectedPath,
      [NotNull] RdProperty<string> initialPath,
      [NotNull] RdProperty<string> mask,
      JetBrains.Rider.Model.UIAutomation.PathChooser pathChooser,
      [NotNull] BeLabel description,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (selectedPath == null) throw new ArgumentNullException("selectedPath");
      if (initialPath == null) throw new ArgumentNullException("initialPath");
      if (mask == null) throw new ArgumentNullException("mask");
      if (description == null) throw new ArgumentNullException("description");
      
      _SelectedPath = selectedPath;
      _InitialPath = initialPath;
      _Mask = mask;
      PathChooser = pathChooser;
      Description = description;
      _SelectedPath.OptimizeNested = true;
      _InitialPath.OptimizeNested = true;
      _Mask.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("selectedPath", _SelectedPath));
      BindableChildren.Add(new KeyValuePair<string, object>("initialPath", _InitialPath));
      BindableChildren.Add(new KeyValuePair<string, object>("mask", _Mask));
      BindableChildren.Add(new KeyValuePair<string, object>("description", Description));
    }
    //secondary constructor
    public BePathSelectionButton (
      JetBrains.Rider.Model.UIAutomation.PathChooser pathChooser,
      [NotNull] BeLabel description
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      pathChooser,
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BePathSelectionButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var selectedPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var initialPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var mask = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var pathChooser = (JetBrains.Rider.Model.UIAutomation.PathChooser)reader.ReadInt();
      var description = BeLabel.Read(ctx, reader);
      return new BePathSelectionButton(selectedPath, initialPath, mask, pathChooser, description, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BePathSelectionButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._SelectedPath);
      RdProperty<string>.Write(ctx, writer, value._InitialPath);
      RdProperty<string>.Write(ctx, writer, value._Mask);
      writer.Write((int)value.PathChooser);
      BeLabel.Write(ctx, writer, value.Description);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BePathSelectionButton (");
      using (printer.IndentCookie()) {
        printer.Print("selectedPath = "); _SelectedPath.PrintEx(printer); printer.Println();
        printer.Print("initialPath = "); _InitialPath.PrintEx(printer); printer.Println();
        printer.Print("mask = "); _Mask.PrintEx(printer); printer.Println();
        printer.Print("pathChooser = "); PathChooser.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeRadioButton : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Property { get { return _Property; }}
    [NotNull] public BeLabel Description {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Property;
    
    //primary constructor
    private BeRadioButton(
      [NotNull] RdProperty<bool> property,
      [NotNull] BeLabel description,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (property == null) throw new ArgumentNullException("property");
      if (description == null) throw new ArgumentNullException("description");
      
      _Property = property;
      Description = description;
      _Property.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("property", _Property));
      BindableChildren.Add(new KeyValuePair<string, object>("description", Description));
    }
    //secondary constructor
    public BeRadioButton (
      [NotNull] BeLabel description
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      description,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeRadioButton> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var property = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var description = BeLabel.Read(ctx, reader);
      return new BeRadioButton(property, description, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeRadioButton> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._Property);
      BeLabel.Write(ctx, writer, value.Description);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeRadioButton (");
      using (printer.IndentCookie()) {
        printer.Print("property = "); _Property.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeResharperContextMenu : IPrintable, IEquatable<BeResharperContextMenu> {
    //fields
    //public fields
    [NotNull] public string ResharperMenuGroupId {get; private set;}
    
    //private fields
    //primary constructor
    public BeResharperContextMenu(
      [NotNull] string resharperMenuGroupId
    )
    {
      if (resharperMenuGroupId == null) throw new ArgumentNullException("resharperMenuGroupId");
      
      ResharperMenuGroupId = resharperMenuGroupId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeResharperContextMenu> Read = (ctx, reader) => 
    {
      var resharperMenuGroupId = reader.ReadString();
      return new BeResharperContextMenu(resharperMenuGroupId);
    };
    
    public static CtxWriteDelegate<BeResharperContextMenu> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ResharperMenuGroupId);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeResharperContextMenu) obj);
    }
    public bool Equals(BeResharperContextMenu other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ResharperMenuGroupId == other.ResharperMenuGroupId;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ResharperMenuGroupId.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeResharperContextMenu (");
      using (printer.IndentCookie()) {
        printer.Print("resharperMenuGroupId = "); ResharperMenuGroupId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeRichText : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.ModelRichText> Content { get { return _Content; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.ModelRichText> _Content;
    
    //primary constructor
    private BeRichText(
      [NotNull] RdProperty<JetBrains.Rider.Model.ModelRichText> content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (content == null) throw new ArgumentNullException("content");
      
      _Content = content;
      _Content.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public BeRichText (
    ) : this (
      new RdProperty<JetBrains.Rider.Model.ModelRichText>(JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeRichText> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var content = RdProperty<JetBrains.Rider.Model.ModelRichText>.Read(ctx, reader, JetBrains.Rider.Model.ModelRichText.Read, JetBrains.Rider.Model.ModelRichText.Write);
      return new BeRichText(content, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeRichText> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<JetBrains.Rider.Model.ModelRichText>.Write(ctx, writer, value._Content);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeRichText (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeScrollbarPolicy : IPrintable, IEquatable<BeScrollbarPolicy> {
    //fields
    //public fields
    public bool AllowHorizontalScrollbars {get; private set;}
    public bool AllowVerticalScrollbars {get; private set;}
    
    //private fields
    //primary constructor
    public BeScrollbarPolicy(
      bool allowHorizontalScrollbars,
      bool allowVerticalScrollbars
    )
    {
      AllowHorizontalScrollbars = allowHorizontalScrollbars;
      AllowVerticalScrollbars = allowVerticalScrollbars;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeScrollbarPolicy> Read = (ctx, reader) => 
    {
      var allowHorizontalScrollbars = reader.ReadBool();
      var allowVerticalScrollbars = reader.ReadBool();
      return new BeScrollbarPolicy(allowHorizontalScrollbars, allowVerticalScrollbars);
    };
    
    public static CtxWriteDelegate<BeScrollbarPolicy> Write = (ctx, writer, value) => 
    {
      writer.Write(value.AllowHorizontalScrollbars);
      writer.Write(value.AllowVerticalScrollbars);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BeScrollbarPolicy) obj);
    }
    public bool Equals(BeScrollbarPolicy other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AllowHorizontalScrollbars == other.AllowHorizontalScrollbars && AllowVerticalScrollbars == other.AllowVerticalScrollbars;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + AllowHorizontalScrollbars.GetHashCode();
        hash = hash * 31 + AllowVerticalScrollbars.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BeScrollbarPolicy (");
      using (printer.IndentCookie()) {
        printer.Print("allowHorizontalScrollbars = "); AllowHorizontalScrollbars.PrintEx(printer); printer.Println();
        printer.Print("allowVerticalScrollbars = "); AllowVerticalScrollbars.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpacer : BeControl
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private BeSpacer(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeSpacer (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpacer> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeSpacer(enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpacer> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpacer (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanColumnElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public BeGridElement Content {get; private set;}
    public int ColumnSpan {get; private set;}
    
    //private fields
    //primary constructor
    public BeSpanColumnElement(
      [NotNull] BeGridElement content,
      int columnSpan
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      Content = content;
      ColumnSpan = columnSpan;
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BeSpanColumnElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = BeGridElement.Read(ctx, reader);
      var columnSpan = reader.ReadInt();
      return new BeSpanColumnElement(content, columnSpan).WithId(_id);
    };
    
    public static CtxWriteDelegate<BeSpanColumnElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      BeGridElement.Write(ctx, writer, value.Content);
      writer.Write(value.ColumnSpan);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanColumnElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("columnSpan = "); ColumnSpan.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanGrid : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeSpanRowElement>> Items { get { return _Items; }}
    [NotNull] public List<RdUnitSize> Columns {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeSpanRowElement>> _Items;
    
    //primary constructor
    private BeSpanGrid(
      [NotNull] RdProperty<List<BeSpanRowElement>> items,
      [NotNull] List<RdUnitSize> columns,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (items == null) throw new ArgumentNullException("items");
      if (columns == null) throw new ArgumentNullException("columns");
      
      _Items = items;
      Columns = columns;
      BindableChildren.Add(new KeyValuePair<string, object>("items", _Items));
    }
    //secondary constructor
    public BeSpanGrid (
      [NotNull] List<RdUnitSize> columns
    ) : this (
      new RdProperty<List<BeSpanRowElement>>(ReadBeSpanRowElementList, WriteBeSpanRowElementList),
      columns,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpanGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var items = RdProperty<List<BeSpanRowElement>>.Read(ctx, reader, ReadBeSpanRowElementList, WriteBeSpanRowElementList);
      var columns = ReadRdUnitSizeList(ctx, reader);
      return new BeSpanGrid(items, columns, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeSpanRowElement>> ReadBeSpanRowElementList = BeSpanRowElement.Read.List();
    public static CtxReadDelegate<List<RdUnitSize>> ReadRdUnitSizeList = RdUnitSize.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpanGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<List<BeSpanRowElement>>.Write(ctx, writer, value._Items);
      WriteRdUnitSizeList(ctx, writer, value.Columns);
    };
    public static CtxWriteDelegate<List<BeSpanRowElement>> WriteBeSpanRowElementList = BeSpanRowElement.Write.List();
    public static CtxWriteDelegate<List<RdUnitSize>> WriteRdUnitSizeList = RdUnitSize.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanGrid (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); _Items.PrintEx(printer); printer.Println();
        printer.Print("columns = "); Columns.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpanRowElement : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<BeSpanColumnElement>> Content { get { return _Content; }}
    [NotNull] public RdUnitSize Size {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<List<BeSpanColumnElement>> _Content;
    
    //primary constructor
    private BeSpanRowElement(
      [NotNull] RdProperty<List<BeSpanColumnElement>> content,
      [NotNull] RdUnitSize size
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      if (size == null) throw new ArgumentNullException("size");
      
      _Content = content;
      Size = size;
      BindableChildren.Add(new KeyValuePair<string, object>("content", _Content));
    }
    //secondary constructor
    public BeSpanRowElement (
      [NotNull] RdUnitSize size
    ) : this (
      new RdProperty<List<BeSpanColumnElement>>(ReadBeSpanColumnElementList, WriteBeSpanColumnElementList),
      size
    ) {}
    //statics
    
    public static CtxReadDelegate<BeSpanRowElement> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var content = RdProperty<List<BeSpanColumnElement>>.Read(ctx, reader, ReadBeSpanColumnElementList, WriteBeSpanColumnElementList);
      var size = RdUnitSize.Read(ctx, reader);
      return new BeSpanRowElement(content, size).WithId(_id);
    };
    public static CtxReadDelegate<List<BeSpanColumnElement>> ReadBeSpanColumnElementList = BeSpanColumnElement.Read.List();
    
    public static CtxWriteDelegate<BeSpanRowElement> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<BeSpanColumnElement>>.Write(ctx, writer, value._Content);
      RdUnitSize.Write(ctx, writer, value.Size);
    };
    public static CtxWriteDelegate<List<BeSpanColumnElement>> WriteBeSpanColumnElementList = BeSpanColumnElement.Write.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpanRowElement (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); _Content.PrintEx(printer); printer.Println();
        printer.Print("size = "); Size.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSpinner : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<int> Value { get { return _Value; }}
    public int MinValue {get; private set;}
    public int MaxValue {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Value;
    
    //primary constructor
    private BeSpinner(
      [NotNull] RdProperty<int> value,
      int minValue,
      int maxValue,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (value == null) throw new ArgumentNullException("value");
      
      _Value = value;
      MinValue = minValue;
      MaxValue = maxValue;
      _Value.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("value", _Value));
    }
    //secondary constructor
    public BeSpinner (
      int minValue,
      int maxValue
    ) : this (
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      minValue,
      maxValue,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSpinner> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var value = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var minValue = reader.ReadInt();
      var maxValue = reader.ReadInt();
      return new BeSpinner(value, minValue, maxValue, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSpinner> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<int>.Write(ctx, writer, value._Value);
      writer.Write(value.MinValue);
      writer.Write(value.MaxValue);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSpinner (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("minValue = "); MinValue.PrintEx(printer); printer.Println();
        printer.Print("maxValue = "); MaxValue.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeSplitControl : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl FirstPanel {get; private set;}
    [NotNull] public BeControl SecondPanel {get; private set;}
    public bool IsVertical {get; private set;}
    public float Proportion {get; private set;}
    
    //private fields
    //primary constructor
    private BeSplitControl(
      [NotNull] BeControl firstPanel,
      [NotNull] BeControl secondPanel,
      bool isVertical,
      float proportion,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (firstPanel == null) throw new ArgumentNullException("firstPanel");
      if (secondPanel == null) throw new ArgumentNullException("secondPanel");
      
      FirstPanel = firstPanel;
      SecondPanel = secondPanel;
      IsVertical = isVertical;
      Proportion = proportion;
      BindableChildren.Add(new KeyValuePair<string, object>("firstPanel", FirstPanel));
      BindableChildren.Add(new KeyValuePair<string, object>("secondPanel", SecondPanel));
    }
    //secondary constructor
    public BeSplitControl (
      [NotNull] BeControl firstPanel,
      [NotNull] BeControl secondPanel,
      bool isVertical,
      float proportion
    ) : this (
      firstPanel,
      secondPanel,
      isVertical,
      proportion,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeSplitControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var firstPanel = BeControl.Read(ctx, reader);
      var secondPanel = BeControl.Read(ctx, reader);
      var isVertical = reader.ReadBool();
      var proportion = reader.ReadFloat();
      return new BeSplitControl(firstPanel, secondPanel, isVertical, proportion, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeSplitControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.FirstPanel);
      BeControl.Write(ctx, writer, value.SecondPanel);
      writer.Write(value.IsVertical);
      writer.Write(value.Proportion);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeSplitControl (");
      using (printer.IndentCookie()) {
        printer.Print("firstPanel = "); FirstPanel.PrintEx(printer); printer.Println();
        printer.Print("secondPanel = "); SecondPanel.PrintEx(printer); printer.Println();
        printer.Print("isVertical = "); IsVertical.PrintEx(printer); printer.Println();
        printer.Print("proportion = "); Proportion.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTab : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeLabel TabName {get; private set;}
    [NotNull] public BeControl Content {get; private set;}
    
    //private fields
    //primary constructor
    private BeTab(
      [NotNull] BeLabel tabName,
      [NotNull] BeControl content,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (tabName == null) throw new ArgumentNullException("tabName");
      if (content == null) throw new ArgumentNullException("content");
      
      TabName = tabName;
      Content = content;
      BindableChildren.Add(new KeyValuePair<string, object>("tabName", TabName));
      BindableChildren.Add(new KeyValuePair<string, object>("content", Content));
    }
    //secondary constructor
    public BeTab (
      [NotNull] BeLabel tabName,
      [NotNull] BeControl content
    ) : this (
      tabName,
      content,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTab> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var tabName = BeLabel.Read(ctx, reader);
      var content = BeControl.Read(ctx, reader);
      return new BeTab(tabName, content, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTab> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeLabel.Write(ctx, writer, value.TabName);
      BeControl.Write(ctx, writer, value.Content);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTab (");
      using (printer.IndentCookie()) {
        printer.Print("tabName = "); TabName.PrintEx(printer); printer.Println();
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTabbedControl : BeControl
   {
    //fields
    //public fields
    [NotNull] public IViewableList<BeTab> Tabs { get { return _Tabs; }}
    [NotNull] public IRdProperty<int> SelectedIndex { get { return _SelectedIndex; }}
    
    //private fields
    [NotNull] private readonly RdList<BeTab> _Tabs;
    [NotNull] private readonly RdProperty<int> _SelectedIndex;
    
    //primary constructor
    private BeTabbedControl(
      [NotNull] RdList<BeTab> tabs,
      [NotNull] RdProperty<int> selectedIndex,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (tabs == null) throw new ArgumentNullException("tabs");
      if (selectedIndex == null) throw new ArgumentNullException("selectedIndex");
      
      _Tabs = tabs;
      _SelectedIndex = selectedIndex;
      _SelectedIndex.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("tabs", _Tabs));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedIndex", _SelectedIndex));
    }
    //secondary constructor
    public BeTabbedControl (
    ) : this (
      new RdList<BeTab>(BeTab.Read, BeTab.Write),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTabbedControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var tabs = RdList<BeTab>.Read(ctx, reader, BeTab.Read, BeTab.Write);
      var selectedIndex = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new BeTabbedControl(tabs, selectedIndex, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTabbedControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdList<BeTab>.Write(ctx, writer, value._Tabs);
      RdProperty<int>.Write(ctx, writer, value._SelectedIndex);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTabbedControl (");
      using (printer.IndentCookie()) {
        printer.Print("tabs = "); _Tabs.PrintEx(printer); printer.Println();
        printer.Print("selectedIndex = "); _SelectedIndex.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextBox : BeControlWithValidation
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [NotNull] public IRdProperty<bool> Readonly { get { return _Readonly; }}
    [NotNull] public IRdProperty<List<BeCompletionItem>> CompletionItems { get { return _CompletionItems; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    [NotNull] private readonly RdProperty<bool> _Readonly;
    [NotNull] private readonly RdProperty<List<BeCompletionItem>> _CompletionItems;
    
    //primary constructor
    private BeTextBox(
      [NotNull] RdProperty<string> text,
      [NotNull] RdProperty<bool> @readonly,
      [NotNull] RdProperty<List<BeCompletionItem>> completionItems,
      [NotNull] RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult> validationResult,
      [NotNull] RdProperty<bool> handledByParent,
      [NotNull] RdSignal<RdVoid> revalidate,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      validationResult,
      handledByParent,
      revalidate,
      enabled,
      controlId,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      if (@readonly == null) throw new ArgumentNullException("readonly");
      if (completionItems == null) throw new ArgumentNullException("completionItems");
      
      _Text = text;
      _Readonly = @readonly;
      _CompletionItems = completionItems;
      _Text.OptimizeNested = true;
      _Readonly.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
      BindableChildren.Add(new KeyValuePair<string, object>("readonly", _Readonly));
      BindableChildren.Add(new KeyValuePair<string, object>("completionItems", _CompletionItems));
    }
    //secondary constructor
    public BeTextBox (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<List<BeCompletionItem>>(ReadBeCompletionItemList, WriteBeCompletionItemList),
      new RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>(JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextBox> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var validationResult = RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Read(ctx, reader, JetBrains.Rider.Model.UIAutomation.ValidationResult.Read, JetBrains.Rider.Model.UIAutomation.ValidationResult.Write);
      var handledByParent = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var revalidate = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var @readonly = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var completionItems = RdProperty<List<BeCompletionItem>>.Read(ctx, reader, ReadBeCompletionItemList, WriteBeCompletionItemList);
      return new BeTextBox(text, @readonly, completionItems, validationResult, handledByParent, revalidate, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeCompletionItem>> ReadBeCompletionItemList = BeCompletionItem.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextBox> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<JetBrains.Rider.Model.UIAutomation.ValidationResult>.Write(ctx, writer, value._ValidationResult);
      RdProperty<bool>.Write(ctx, writer, value._HandledByParent);
      RdSignal<RdVoid>.Write(ctx, writer, value._Revalidate);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      RdProperty<bool>.Write(ctx, writer, value._Readonly);
      RdProperty<List<BeCompletionItem>>.Write(ctx, writer, value._CompletionItems);
    };
    public static CtxWriteDelegate<List<BeCompletionItem>> WriteBeCompletionItemList = BeCompletionItem.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextBox (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("readonly = "); _Readonly.PrintEx(printer); printer.Println();
        printer.Print("completionItems = "); _CompletionItems.PrintEx(printer); printer.Println();
        printer.Print("validationResult = "); _ValidationResult.PrintEx(printer); printer.Println();
        printer.Print("handledByParent = "); _HandledByParent.PrintEx(printer); printer.Println();
        printer.Print("revalidate = "); _Revalidate.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextControl : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    public bool ReadOnly {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    
    //primary constructor
    private BeTextControl(
      [NotNull] RdProperty<string> text,
      bool readOnly,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      _Text = text;
      ReadOnly = readOnly;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
    }
    //secondary constructor
    public BeTextControl (
      bool readOnly
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      readOnly,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextControl> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var readOnly = reader.ReadBool();
      return new BeTextControl(text, readOnly, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextControl> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      writer.Write(value.ReadOnly);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextControl (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("readOnly = "); ReadOnly.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTextControlWithLanguage : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Text { get { return _Text; }}
    [CanBeNull] public JetBrains.Rider.Model.RdLanguage Language {get; private set;}
    public bool ReadOnly {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Text;
    
    //primary constructor
    private BeTextControlWithLanguage(
      [NotNull] RdProperty<string> text,
      [CanBeNull] JetBrains.Rider.Model.RdLanguage language,
      bool readOnly,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (text == null) throw new ArgumentNullException("text");
      
      _Text = text;
      Language = language;
      ReadOnly = readOnly;
      _Text.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("text", _Text));
    }
    //secondary constructor
    public BeTextControlWithLanguage (
      [CanBeNull] JetBrains.Rider.Model.RdLanguage language,
      bool readOnly
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      language,
      readOnly,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTextControlWithLanguage> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var text = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var language = ReadRdLanguageNullable(ctx, reader);
      var readOnly = reader.ReadBool();
      return new BeTextControlWithLanguage(text, language, readOnly, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.RdLanguage> ReadRdLanguageNullable = JetBrains.Rider.Model.RdLanguage.Read.NullableClass();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTextControlWithLanguage> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<string>.Write(ctx, writer, value._Text);
      WriteRdLanguageNullable(ctx, writer, value.Language);
      writer.Write(value.ReadOnly);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.RdLanguage> WriteRdLanguageNullable = JetBrains.Rider.Model.RdLanguage.Write.NullableClass();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTextControlWithLanguage (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); _Text.PrintEx(printer); printer.Println();
        printer.Print("language = "); Language.PrintEx(printer); printer.Println();
        printer.Print("readOnly = "); ReadOnly.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeToolbar : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeControl Contents {get; private set;}
    public GridOrientation Orientation {get; private set;}
    [NotNull] public IViewableList<BeControl> ToolbarItems { get { return _ToolbarItems; }}
    
    //private fields
    [NotNull] private readonly RdList<BeControl> _ToolbarItems;
    
    //primary constructor
    private BeToolbar(
      [NotNull] BeControl contents,
      GridOrientation orientation,
      [NotNull] RdList<BeControl> toolbarItems,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (contents == null) throw new ArgumentNullException("contents");
      if (toolbarItems == null) throw new ArgumentNullException("toolbarItems");
      
      Contents = contents;
      Orientation = orientation;
      _ToolbarItems = toolbarItems;
      BindableChildren.Add(new KeyValuePair<string, object>("contents", Contents));
      BindableChildren.Add(new KeyValuePair<string, object>("toolbarItems", _ToolbarItems));
    }
    //secondary constructor
    public BeToolbar (
      [NotNull] BeControl contents,
      GridOrientation orientation
    ) : this (
      contents,
      orientation,
      new RdList<BeControl>(BeControl.Read, BeControl.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeToolbar> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var contents = BeControl.Read(ctx, reader);
      var orientation = (GridOrientation)reader.ReadInt();
      var toolbarItems = RdList<BeControl>.Read(ctx, reader, BeControl.Read, BeControl.Write);
      return new BeToolbar(contents, orientation, toolbarItems, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeToolbar> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeControl.Write(ctx, writer, value.Contents);
      writer.Write((int)value.Orientation);
      RdList<BeControl>.Write(ctx, writer, value._ToolbarItems);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeToolbar (");
      using (printer.IndentCookie()) {
        printer.Print("contents = "); Contents.PrintEx(printer); printer.Println();
        printer.Print("orientation = "); Orientation.PrintEx(printer); printer.Println();
        printer.Print("toolbarItems = "); _ToolbarItems.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTreeConfiguration : RdBindableBase {
    //fields
    //public fields
    [NotNull] public List<BeColumnDefinition> ColumnDefinitions {get; private set;}
    public BeTreeSelection Selection {get; private set;}
    public bool HasHeader {get; private set;}
    [NotNull] public IRdProperty<BeResharperContextMenu> ResharperContextMenu { get { return _ResharperContextMenu; }}
    public JetBrains.Rider.Model.UIAutomation.ChildOffsetSize ChildOffsetSize {get; private set;}
    public bool ShowAsList {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<BeResharperContextMenu> _ResharperContextMenu;
    
    //primary constructor
    private BeTreeConfiguration(
      [NotNull] List<BeColumnDefinition> columnDefinitions,
      BeTreeSelection selection,
      bool hasHeader,
      [NotNull] RdProperty<BeResharperContextMenu> resharperContextMenu,
      JetBrains.Rider.Model.UIAutomation.ChildOffsetSize childOffsetSize,
      bool showAsList
    )
    {
      if (columnDefinitions == null) throw new ArgumentNullException("columnDefinitions");
      if (resharperContextMenu == null) throw new ArgumentNullException("resharperContextMenu");
      
      ColumnDefinitions = columnDefinitions;
      Selection = selection;
      HasHeader = hasHeader;
      _ResharperContextMenu = resharperContextMenu;
      ChildOffsetSize = childOffsetSize;
      ShowAsList = showAsList;
      _ResharperContextMenu.OptimizeNested = true;
      _ResharperContextMenu.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("columnDefinitions", ColumnDefinitions));
      BindableChildren.Add(new KeyValuePair<string, object>("resharperContextMenu", _ResharperContextMenu));
    }
    //secondary constructor
    public BeTreeConfiguration (
      [NotNull] List<BeColumnDefinition> columnDefinitions,
      BeTreeSelection selection,
      bool hasHeader,
      JetBrains.Rider.Model.UIAutomation.ChildOffsetSize childOffsetSize,
      bool showAsList
    ) : this (
      columnDefinitions,
      selection,
      hasHeader,
      new RdProperty<BeResharperContextMenu>(ReadBeResharperContextMenuNullable, WriteBeResharperContextMenuNullable),
      childOffsetSize,
      showAsList
    ) {}
    //statics
    
    public static CtxReadDelegate<BeTreeConfiguration> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var columnDefinitions = ReadBeColumnDefinitionList(ctx, reader);
      var selection = (BeTreeSelection)reader.ReadInt();
      var hasHeader = reader.ReadBool();
      var resharperContextMenu = RdProperty<BeResharperContextMenu>.Read(ctx, reader, ReadBeResharperContextMenuNullable, WriteBeResharperContextMenuNullable);
      var childOffsetSize = (JetBrains.Rider.Model.UIAutomation.ChildOffsetSize)reader.ReadInt();
      var showAsList = reader.ReadBool();
      return new BeTreeConfiguration(columnDefinitions, selection, hasHeader, resharperContextMenu, childOffsetSize, showAsList).WithId(_id);
    };
    public static CtxReadDelegate<List<BeColumnDefinition>> ReadBeColumnDefinitionList = BeColumnDefinition.Read.List();
    public static CtxReadDelegate<BeResharperContextMenu> ReadBeResharperContextMenuNullable = BeResharperContextMenu.Read.NullableClass();
    
    public static CtxWriteDelegate<BeTreeConfiguration> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteBeColumnDefinitionList(ctx, writer, value.ColumnDefinitions);
      writer.Write((int)value.Selection);
      writer.Write(value.HasHeader);
      RdProperty<BeResharperContextMenu>.Write(ctx, writer, value._ResharperContextMenu);
      writer.Write((int)value.ChildOffsetSize);
      writer.Write(value.ShowAsList);
    };
    public static CtxWriteDelegate<List<BeColumnDefinition>> WriteBeColumnDefinitionList = BeColumnDefinition.Write.List();
    public static CtxWriteDelegate<BeResharperContextMenu> WriteBeResharperContextMenuNullable = BeResharperContextMenu.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeConfiguration (");
      using (printer.IndentCookie()) {
        printer.Print("columnDefinitions = "); ColumnDefinitions.PrintEx(printer); printer.Println();
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
        printer.Print("hasHeader = "); HasHeader.PrintEx(printer); printer.Println();
        printer.Print("resharperContextMenu = "); _ResharperContextMenu.PrintEx(printer); printer.Println();
        printer.Print("childOffsetSize = "); ChildOffsetSize.PrintEx(printer); printer.Println();
        printer.Print("showAsList = "); ShowAsList.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTreeGrid : BeControl
   {
    //fields
    //public fields
    [NotNull] public BeTreeGridLine FakeRoot {get; private set;}
    [NotNull] public BeTreeConfiguration Configuration {get; private set;}
    
    //private fields
    //primary constructor
    private BeTreeGrid(
      [NotNull] BeTreeGridLine fakeRoot,
      [NotNull] BeTreeConfiguration configuration,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (fakeRoot == null) throw new ArgumentNullException("fakeRoot");
      if (configuration == null) throw new ArgumentNullException("configuration");
      
      FakeRoot = fakeRoot;
      Configuration = configuration;
      BindableChildren.Add(new KeyValuePair<string, object>("fakeRoot", FakeRoot));
      BindableChildren.Add(new KeyValuePair<string, object>("configuration", Configuration));
    }
    //secondary constructor
    public BeTreeGrid (
      [NotNull] BeTreeGridLine fakeRoot,
      [NotNull] BeTreeConfiguration configuration
    ) : this (
      fakeRoot,
      configuration,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTreeGrid> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var fakeRoot = BeTreeGridLine.Read(ctx, reader);
      var configuration = BeTreeConfiguration.Read(ctx, reader);
      return new BeTreeGrid(fakeRoot, configuration, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTreeGrid> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      BeTreeGridLine.Write(ctx, writer, value.FakeRoot);
      BeTreeConfiguration.Write(ctx, writer, value.Configuration);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeGrid (");
      using (printer.IndentCookie()) {
        printer.Print("fakeRoot = "); FakeRoot.PrintEx(printer); printer.Println();
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BeTreeGridLine : BeControl
   {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> IsSelected { get { return _IsSelected; }}
    [NotNull] public List<BeControl> ColumnElements {get; private set;}
    [NotNull] public IRdProperty<bool> IsExpanded { get { return _IsExpanded; }}
    [NotNull] public IViewableList<BeControl> Children { get { return _Children; }}
    [NotNull] public IRdSignal<RdVoid> Signal { get { return _Signal; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _IsSelected;
    [NotNull] private readonly RdProperty<bool> _IsExpanded;
    [NotNull] private readonly RdList<BeControl> _Children;
    [NotNull] private readonly RdSignal<RdVoid> _Signal;
    
    //primary constructor
    private BeTreeGridLine(
      [NotNull] RdProperty<bool> isSelected,
      [NotNull] List<BeControl> columnElements,
      [NotNull] RdProperty<bool> isExpanded,
      [NotNull] RdList<BeControl> children,
      [NotNull] RdSignal<RdVoid> signal,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
      if (isSelected == null) throw new ArgumentNullException("isSelected");
      if (columnElements == null) throw new ArgumentNullException("columnElements");
      if (isExpanded == null) throw new ArgumentNullException("isExpanded");
      if (children == null) throw new ArgumentNullException("children");
      if (signal == null) throw new ArgumentNullException("signal");
      
      _IsSelected = isSelected;
      ColumnElements = columnElements;
      _IsExpanded = isExpanded;
      _Children = children;
      _Signal = signal;
      _IsSelected.OptimizeNested = true;
      _IsExpanded.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("isSelected", _IsSelected));
      BindableChildren.Add(new KeyValuePair<string, object>("columnElements", ColumnElements));
      BindableChildren.Add(new KeyValuePair<string, object>("isExpanded", _IsExpanded));
      BindableChildren.Add(new KeyValuePair<string, object>("children", _Children));
      BindableChildren.Add(new KeyValuePair<string, object>("signal", _Signal));
    }
    //secondary constructor
    public BeTreeGridLine (
      [NotNull] List<BeControl> columnElements
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      columnElements,
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdList<BeControl>(BeControl.Read, BeControl.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeTreeGridLine> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      var isSelected = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var columnElements = ReadBeControlList(ctx, reader);
      var isExpanded = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var children = RdList<BeControl>.Read(ctx, reader, BeControl.Read, BeControl.Write);
      var signal = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new BeTreeGridLine(isSelected, columnElements, isExpanded, children, signal, enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<List<BeControl>> ReadBeControlList = BeControl.Read.List();
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeTreeGridLine> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
      RdProperty<bool>.Write(ctx, writer, value._IsSelected);
      WriteBeControlList(ctx, writer, value.ColumnElements);
      RdProperty<bool>.Write(ctx, writer, value._IsExpanded);
      RdList<BeControl>.Write(ctx, writer, value._Children);
      RdSignal<RdVoid>.Write(ctx, writer, value._Signal);
    };
    public static CtxWriteDelegate<List<BeControl>> WriteBeControlList = BeControl.Write.List();
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeTreeGridLine (");
      using (printer.IndentCookie()) {
        printer.Print("isSelected = "); _IsSelected.PrintEx(printer); printer.Println();
        printer.Print("columnElements = "); ColumnElements.PrintEx(printer); printer.Println();
        printer.Print("isExpanded = "); _IsExpanded.PrintEx(printer); printer.Println();
        printer.Print("children = "); _Children.PrintEx(printer); printer.Println();
        printer.Print("signal = "); _Signal.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BeTreeSelection {
    Multi,
    Single
  }
  
  
  public class BeWrap : BeControl
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    private BeWrap(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<string> controlId,
      [NotNull] RdProperty<ControlVisibility> visible
    ) : base (
      enabled,
      controlId,
      visible
     ) 
    {
    }
    //secondary constructor
    public BeWrap (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<ControlVisibility>(ReadControlVisibility, WriteControlVisibility)
    ) {}
    //statics
    
    public static new CtxReadDelegate<BeWrap> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var controlId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var visible = RdProperty<ControlVisibility>.Read(ctx, reader, ReadControlVisibility, WriteControlVisibility);
      return new BeWrap(enabled, controlId, visible).WithId(_id);
    };
    public static CtxReadDelegate<ControlVisibility> ReadControlVisibility = new CtxReadDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<ControlVisibility>);
    
    public static new CtxWriteDelegate<BeWrap> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<string>.Write(ctx, writer, value._ControlId);
      RdProperty<ControlVisibility>.Write(ctx, writer, value._Visible);
    };
    public static CtxWriteDelegate<ControlVisibility> WriteControlVisibility = new CtxWriteDelegate<ControlVisibility>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<ControlVisibility>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BeWrap (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("controlId = "); _ControlId.PrintEx(printer); printer.Println();
        printer.Print("visible = "); _Visible.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ChildOffsetSize {
    DEFAULT,
    SMALL
  }
  
  
  public enum ControlVisibility {
    Visible,
    Collapsed,
    Hidden
  }
  
  
  public enum DialogModality {
    MODAL,
    NON_MODAL
  }
  
  
  public enum DialogResult {
    OK,
    CANCEL,
    CLOSE
  }
  
  
  public enum GridOrientation {
    Horizontal,
    Vertical
  }
  
  
  public enum MarginType {
    None,
    Checkbox,
    RadioButton
  }
  
  
  public enum PathChooser {
    File,
    Folder
  }
  
  
  public class RdUnitSize : IPrintable, IEquatable<RdUnitSize> {
    //fields
    //public fields
    public bool IsStar {get; private set;}
    public bool IsAuto {get; private set;}
    public MarginType LeftMargin {get; private set;}
    public int MarginMultiplier {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitSize(
      bool isStar,
      bool isAuto,
      MarginType leftMargin,
      int marginMultiplier
    )
    {
      IsStar = isStar;
      IsAuto = isAuto;
      LeftMargin = leftMargin;
      MarginMultiplier = marginMultiplier;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitSize> Read = (ctx, reader) => 
    {
      var isStar = reader.ReadBool();
      var isAuto = reader.ReadBool();
      var leftMargin = (MarginType)reader.ReadInt();
      var marginMultiplier = reader.ReadInt();
      return new RdUnitSize(isStar, isAuto, leftMargin, marginMultiplier);
    };
    
    public static CtxWriteDelegate<RdUnitSize> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsStar);
      writer.Write(value.IsAuto);
      writer.Write((int)value.LeftMargin);
      writer.Write(value.MarginMultiplier);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitSize) obj);
    }
    public bool Equals(RdUnitSize other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return IsStar == other.IsStar && IsAuto == other.IsAuto && LeftMargin == other.LeftMargin && MarginMultiplier == other.MarginMultiplier;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + IsStar.GetHashCode();
        hash = hash * 31 + IsAuto.GetHashCode();
        hash = hash * 31 + (int) LeftMargin;
        hash = hash * 31 + MarginMultiplier.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitSize (");
      using (printer.IndentCookie()) {
        printer.Print("isStar = "); IsStar.PrintEx(printer); printer.Println();
        printer.Print("isAuto = "); IsAuto.PrintEx(printer); printer.Println();
        printer.Print("leftMargin = "); LeftMargin.PrintEx(printer); printer.Println();
        printer.Print("marginMultiplier = "); MarginMultiplier.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ValidationResult : RdBindableBase {
    //fields
    //public fields
    public ValidationStates State {get; private set;}
    [NotNull] public string ResultMessage {get; private set;}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Icon> Icon { get { return _Icon; }}
    
    //private fields
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Icon> _Icon;
    
    //primary constructor
    private ValidationResult(
      ValidationStates state,
      [NotNull] string resultMessage,
      [NotNull] RdProperty<JetBrains.Rider.Model.Icon> icon
    )
    {
      if (resultMessage == null) throw new ArgumentNullException("resultMessage");
      if (icon == null) throw new ArgumentNullException("icon");
      
      State = state;
      ResultMessage = resultMessage;
      _Icon = icon;
      _Icon.OptimizeNested = true;
      _Icon.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("icon", _Icon));
    }
    //secondary constructor
    public ValidationResult (
      ValidationStates state,
      [NotNull] string resultMessage
    ) : this (
      state,
      resultMessage,
      new RdProperty<JetBrains.Rider.Model.Icon>(ReadIconNullable, WriteIconNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<ValidationResult> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var state = (ValidationStates)reader.ReadInt();
      var resultMessage = reader.ReadString();
      var icon = RdProperty<JetBrains.Rider.Model.Icon>.Read(ctx, reader, ReadIconNullable, WriteIconNullable);
      return new ValidationResult(state, resultMessage, icon).WithId(_id);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<ValidationResult> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write((int)value.State);
      writer.Write(value.ResultMessage);
      RdProperty<JetBrains.Rider.Model.Icon>.Write(ctx, writer, value._Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ValidationResult (");
      using (printer.IndentCookie()) {
        printer.Print("state = "); State.PrintEx(printer); printer.Println();
        printer.Print("resultMessage = "); ResultMessage.PrintEx(printer); printer.Println();
        printer.Print("icon = "); _Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ValidationStates {
    validationPassed,
    validationWarning,
    validationError
  }
}
