using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  public class UnitTestModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public RdUnitTestElementRepository ElementRepository {get; private set;}
    [NotNull] public RdUnitTestExplorerWindowService ExplorerWindowService {get; private set;}
    [NotNull] public IViewableMap<string, RdUnitTestSession> Sessions { get { return _Sessions; }}
    [NotNull] public IViewableMap<Guid, RdUnitTestDebuggerSession> DebugSessions { get { return _DebugSessions; }}
    [NotNull] public RdContinuousTestingProperties ContinuousTestingProperties {get; private set;}
    [NotNull] public RdUnitTestSessionManager SessionManager {get; private set;}
    [NotNull] public IRdProperty<bool> IsReady { get { return _IsReady; }}
    [NotNull] public RdUnitTestAdditionalLaunchOptions AdditionalLaunchOptions {get; private set;}
    
    //private fields
    [NotNull] private readonly RdMap<string, RdUnitTestSession> _Sessions;
    [NotNull] private readonly RdMap<Guid, RdUnitTestDebuggerSession> _DebugSessions;
    [NotNull] private readonly RdProperty<bool> _IsReady;
    
    //primary constructor
    private UnitTestModel(
      [NotNull] RdUnitTestElementRepository elementRepository,
      [NotNull] RdUnitTestExplorerWindowService explorerWindowService,
      [NotNull] RdMap<string, RdUnitTestSession> sessions,
      [NotNull] RdMap<Guid, RdUnitTestDebuggerSession> debugSessions,
      [NotNull] RdContinuousTestingProperties continuousTestingProperties,
      [NotNull] RdUnitTestSessionManager sessionManager,
      [NotNull] RdProperty<bool> isReady,
      [NotNull] RdUnitTestAdditionalLaunchOptions additionalLaunchOptions
    )
    {
      if (elementRepository == null) throw new ArgumentNullException("elementRepository");
      if (explorerWindowService == null) throw new ArgumentNullException("explorerWindowService");
      if (sessions == null) throw new ArgumentNullException("sessions");
      if (debugSessions == null) throw new ArgumentNullException("debugSessions");
      if (continuousTestingProperties == null) throw new ArgumentNullException("continuousTestingProperties");
      if (sessionManager == null) throw new ArgumentNullException("sessionManager");
      if (isReady == null) throw new ArgumentNullException("isReady");
      if (additionalLaunchOptions == null) throw new ArgumentNullException("additionalLaunchOptions");
      
      ElementRepository = elementRepository;
      ExplorerWindowService = explorerWindowService;
      _Sessions = sessions;
      _DebugSessions = debugSessions;
      ContinuousTestingProperties = continuousTestingProperties;
      SessionManager = sessionManager;
      _IsReady = isReady;
      AdditionalLaunchOptions = additionalLaunchOptions;
      _IsReady.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("elementRepository", ElementRepository));
      BindableChildren.Add(new KeyValuePair<string, object>("explorerWindowService", ExplorerWindowService));
      BindableChildren.Add(new KeyValuePair<string, object>("sessions", _Sessions));
      BindableChildren.Add(new KeyValuePair<string, object>("debugSessions", _DebugSessions));
      BindableChildren.Add(new KeyValuePair<string, object>("continuousTestingProperties", ContinuousTestingProperties));
      BindableChildren.Add(new KeyValuePair<string, object>("sessionManager", SessionManager));
      BindableChildren.Add(new KeyValuePair<string, object>("isReady", _IsReady));
      BindableChildren.Add(new KeyValuePair<string, object>("additionalLaunchOptions", AdditionalLaunchOptions));
    }
    //secondary constructor
    internal UnitTestModel (
    ) : this (
      new RdUnitTestElementRepository(),
      new RdUnitTestExplorerWindowService(),
      new RdMap<string, RdUnitTestSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, RdUnitTestSession.Read, RdUnitTestSession.Write),
      new RdMap<Guid, RdUnitTestDebuggerSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadGuid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteGuid, RdUnitTestDebuggerSession.Read, RdUnitTestDebuggerSession.Write),
      new RdContinuousTestingProperties(),
      new RdUnitTestSessionManager(),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdUnitTestAdditionalLaunchOptions()
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => 59606159078635L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.RegisterEnum<RdUnitTestStatus>();
      serializers.Register(RdUnitTestLaunchStatus.Read, RdUnitTestLaunchStatus.Write);
      serializers.Register(RdUnitTestResult.Read, RdUnitTestResult.Write);
      serializers.Register(RdUnitTestResultData.Read, RdUnitTestResultData.Write);
      serializers.Register(RdUnitTestElement.Read, RdUnitTestElement.Write);
      serializers.Register(RdUnitTestElementList.Read, RdUnitTestElementList.Write);
      serializers.Register(RdUnitTestElementSet.Read, RdUnitTestElementSet.Write);
      serializers.Register(RdUnitTestSelection.Read, RdUnitTestSelection.Write);
      serializers.Register(RdUnitTestConstant.Read, RdUnitTestConstant.Write);
      serializers.Register(RdUnitTestElementRepository.Read, RdUnitTestElementRepository.Write);
      serializers.Register(RdUnitTestExplorerWindowService.Read, RdUnitTestExplorerWindowService.Write);
      serializers.Register(RdUnitTestSession.Read, RdUnitTestSession.Write);
      serializers.Register(RdUnitTestDebuggerSession.Read, RdUnitTestDebuggerSession.Write);
      serializers.Register(RdContinuousTestingProperties.Read, RdContinuousTestingProperties.Write);
      serializers.Register(RdUnitTestSessionManager.Read, RdUnitTestSessionManager.Write);
      serializers.Register(RdUnitTestAdditionalLaunchOptions.Read, RdUnitTestAdditionalLaunchOptions.Write);
      serializers.Register(RdUnitTestNavigateToElementArgs.Read, RdUnitTestNavigateToElementArgs.Write);
      serializers.Register(RdUnitTestNavigateToProjectArgs.Read, RdUnitTestNavigateToProjectArgs.Write);
      serializers.Register(RdUnitTestOpenSessionArgs.Read, RdUnitTestOpenSessionArgs.Write);
      serializers.Register(RdUnitTestResultList.Read, RdUnitTestResultList.Write);
      serializers.Register(RdUnitTestSessionOptions.Read, RdUnitTestSessionOptions.Write);
      serializers.Register(RdUnitTestResultItem.Read, RdUnitTestResultItem.Write);
      serializers.RegisterEnum<RdUnitTestBuildPolicy>();
      serializers.RegisterEnum<RdUnitTestPlatformType>();
      serializers.RegisterEnum<RdUnitTestPlatformMonoPreference>();
      serializers.Register(ContinuousTesting.Read, ContinuousTesting.Write);
      serializers.Register(RdUnitTestDebuggerSessionStartDescriptor.Read, RdUnitTestDebuggerSessionStartDescriptor.Write);
      serializers.Register(RdContinuousTestingModeDescriptor.Read, RdContinuousTestingModeDescriptor.Write);
      serializers.RegisterEnum<RdContinuousTestingTriggerMode>();
      
      serializers.RegisterToplevelOnce(typeof(IdeRoot), IdeRoot.RegisterDeclaredTypesSerializers);
    }
    
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("UnitTestModel (");
      using (printer.IndentCookie()) {
        printer.Print("elementRepository = "); ElementRepository.PrintEx(printer); printer.Println();
        printer.Print("explorerWindowService = "); ExplorerWindowService.PrintEx(printer); printer.Println();
        printer.Print("sessions = "); _Sessions.PrintEx(printer); printer.Println();
        printer.Print("debugSessions = "); _DebugSessions.PrintEx(printer); printer.Println();
        printer.Print("continuousTestingProperties = "); ContinuousTestingProperties.PrintEx(printer); printer.Println();
        printer.Print("sessionManager = "); SessionManager.PrintEx(printer); printer.Println();
        printer.Print("isReady = "); _IsReady.PrintEx(printer); printer.Println();
        printer.Print("additionalLaunchOptions = "); AdditionalLaunchOptions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  public static class SolutionUnitTestModelEx
   {
    public static UnitTestModel GetUnitTestModel(this Solution solution)
    {
      return solution.GetOrCreateExtension("unitTestModel", () => new UnitTestModel());
    }
  }
  
  
  public class ContinuousTesting : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] public IRdProperty<int> RunModeId { get { return _RunModeId; }}
    
    //private fields
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] private readonly RdProperty<int> _RunModeId;
    
    //primary constructor
    private ContinuousTesting(
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<int> runModeId
    )
    {
      if (enabled == null) throw new ArgumentNullException("enabled");
      if (runModeId == null) throw new ArgumentNullException("runModeId");
      
      _Enabled = enabled;
      _RunModeId = runModeId;
      _Enabled.OptimizeNested = true;
      _RunModeId.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("enabled", _Enabled));
      BindableChildren.Add(new KeyValuePair<string, object>("runModeId", _RunModeId));
    }
    //secondary constructor
    public ContinuousTesting (
    ) : this (
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<ContinuousTesting> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var enabled = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var runModeId = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new ContinuousTesting(enabled, runModeId).WithId(_id);
    };
    
    public static CtxWriteDelegate<ContinuousTesting> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<int>.Write(ctx, writer, value._RunModeId);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ContinuousTesting (");
      using (printer.IndentCookie()) {
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("runModeId = "); _RunModeId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdContinuousTestingModeDescriptor : IPrintable, IEquatable<RdContinuousTestingModeDescriptor> {
    //fields
    //public fields
    public int Id {get; private set;}
    [NotNull] public string DisplayName {get; private set;}
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //private fields
    //primary constructor
    public RdContinuousTestingModeDescriptor(
      int id,
      [NotNull] string displayName,
      [CanBeNull] JetBrains.Rider.Model.Icon icon
    )
    {
      if (displayName == null) throw new ArgumentNullException("displayName");
      
      Id = id;
      DisplayName = displayName;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdContinuousTestingModeDescriptor> Read = (ctx, reader) => 
    {
      var id = reader.ReadInt();
      var displayName = reader.ReadString();
      var icon = ReadIconNullable(ctx, reader);
      return new RdContinuousTestingModeDescriptor(id, displayName, icon);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdContinuousTestingModeDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Id);
      writer.Write(value.DisplayName);
      WriteIconNullable(ctx, writer, value.Icon);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdContinuousTestingModeDescriptor) obj);
    }
    public bool Equals(RdContinuousTestingModeDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Id == other.Id && DisplayName == other.DisplayName && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Id.GetHashCode();
        hash = hash * 31 + DisplayName.GetHashCode();
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdContinuousTestingModeDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("displayName = "); DisplayName.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdContinuousTestingProperties : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IViewableList<RdContinuousTestingModeDescriptor> AvailableRunModes { get { return _AvailableRunModes; }}
    [NotNull] public IRdProperty<RdContinuousTestingTriggerMode> TriggerMode { get { return _TriggerMode; }}
    
    //private fields
    [NotNull] private readonly RdList<RdContinuousTestingModeDescriptor> _AvailableRunModes;
    [NotNull] private readonly RdProperty<RdContinuousTestingTriggerMode> _TriggerMode;
    
    //primary constructor
    private RdContinuousTestingProperties(
      [NotNull] RdList<RdContinuousTestingModeDescriptor> availableRunModes,
      [NotNull] RdProperty<RdContinuousTestingTriggerMode> triggerMode
    )
    {
      if (availableRunModes == null) throw new ArgumentNullException("availableRunModes");
      if (triggerMode == null) throw new ArgumentNullException("triggerMode");
      
      _AvailableRunModes = availableRunModes;
      _TriggerMode = triggerMode;
      _AvailableRunModes.OptimizeNested = true;
      _TriggerMode.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("availableRunModes", _AvailableRunModes));
      BindableChildren.Add(new KeyValuePair<string, object>("triggerMode", _TriggerMode));
    }
    //secondary constructor
    public RdContinuousTestingProperties (
    ) : this (
      new RdList<RdContinuousTestingModeDescriptor>(RdContinuousTestingModeDescriptor.Read, RdContinuousTestingModeDescriptor.Write),
      new RdProperty<RdContinuousTestingTriggerMode>(ReadRdContinuousTestingTriggerMode, WriteRdContinuousTestingTriggerMode)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdContinuousTestingProperties> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var availableRunModes = RdList<RdContinuousTestingModeDescriptor>.Read(ctx, reader, RdContinuousTestingModeDescriptor.Read, RdContinuousTestingModeDescriptor.Write);
      var triggerMode = RdProperty<RdContinuousTestingTriggerMode>.Read(ctx, reader, ReadRdContinuousTestingTriggerMode, WriteRdContinuousTestingTriggerMode);
      return new RdContinuousTestingProperties(availableRunModes, triggerMode).WithId(_id);
    };
    public static CtxReadDelegate<RdContinuousTestingTriggerMode> ReadRdContinuousTestingTriggerMode = new CtxReadDelegate<RdContinuousTestingTriggerMode>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdContinuousTestingTriggerMode>);
    
    public static CtxWriteDelegate<RdContinuousTestingProperties> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdList<RdContinuousTestingModeDescriptor>.Write(ctx, writer, value._AvailableRunModes);
      RdProperty<RdContinuousTestingTriggerMode>.Write(ctx, writer, value._TriggerMode);
    };
    public static CtxWriteDelegate<RdContinuousTestingTriggerMode> WriteRdContinuousTestingTriggerMode = new CtxWriteDelegate<RdContinuousTestingTriggerMode>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdContinuousTestingTriggerMode>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdContinuousTestingProperties (");
      using (printer.IndentCookie()) {
        printer.Print("availableRunModes = "); _AvailableRunModes.PrintEx(printer); printer.Println();
        printer.Print("triggerMode = "); _TriggerMode.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdContinuousTestingTriggerMode {
    Build,
    Save
  }
  
  
  public class RdUnitTestAdditionalLaunchOptions : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<List<string>> AllPlatformsForIntegrationTests { get { return _AllPlatformsForIntegrationTests; }}
    [NotNull] public IRdProperty<string> SelectedPlatformForIntegrationTests { get { return _SelectedPlatformForIntegrationTests; }}
    
    //private fields
    [NotNull] private readonly RdProperty<List<string>> _AllPlatformsForIntegrationTests;
    [NotNull] private readonly RdProperty<string> _SelectedPlatformForIntegrationTests;
    
    //primary constructor
    private RdUnitTestAdditionalLaunchOptions(
      [NotNull] RdProperty<List<string>> allPlatformsForIntegrationTests,
      [NotNull] RdProperty<string> selectedPlatformForIntegrationTests
    )
    {
      if (allPlatformsForIntegrationTests == null) throw new ArgumentNullException("allPlatformsForIntegrationTests");
      if (selectedPlatformForIntegrationTests == null) throw new ArgumentNullException("selectedPlatformForIntegrationTests");
      
      _AllPlatformsForIntegrationTests = allPlatformsForIntegrationTests;
      _SelectedPlatformForIntegrationTests = selectedPlatformForIntegrationTests;
      _AllPlatformsForIntegrationTests.OptimizeNested = true;
      _SelectedPlatformForIntegrationTests.OptimizeNested = true;
      _AllPlatformsForIntegrationTests.ValueCanBeNull = true;
      _SelectedPlatformForIntegrationTests.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("allPlatformsForIntegrationTests", _AllPlatformsForIntegrationTests));
      BindableChildren.Add(new KeyValuePair<string, object>("selectedPlatformForIntegrationTests", _SelectedPlatformForIntegrationTests));
    }
    //secondary constructor
    public RdUnitTestAdditionalLaunchOptions (
    ) : this (
      new RdProperty<List<string>>(ReadStringListNullable, WriteStringListNullable),
      new RdProperty<string>(ReadStringNullable, WriteStringNullable)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestAdditionalLaunchOptions> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var allPlatformsForIntegrationTests = RdProperty<List<string>>.Read(ctx, reader, ReadStringListNullable, WriteStringListNullable);
      var selectedPlatformForIntegrationTests = RdProperty<string>.Read(ctx, reader, ReadStringNullable, WriteStringNullable);
      return new RdUnitTestAdditionalLaunchOptions(allPlatformsForIntegrationTests, selectedPlatformForIntegrationTests).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List().NullableClass();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdUnitTestAdditionalLaunchOptions> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<List<string>>.Write(ctx, writer, value._AllPlatformsForIntegrationTests);
      RdProperty<string>.Write(ctx, writer, value._SelectedPlatformForIntegrationTests);
    };
    public static CtxWriteDelegate<List<string>> WriteStringListNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List().NullableClass();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestAdditionalLaunchOptions (");
      using (printer.IndentCookie()) {
        printer.Print("allPlatformsForIntegrationTests = "); _AllPlatformsForIntegrationTests.PrintEx(printer); printer.Println();
        printer.Print("selectedPlatformForIntegrationTests = "); _SelectedPlatformForIntegrationTests.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnitTestBuildPolicy {
    Automatic,
    Always,
    Never,
    WholeSolution
  }
  
  
  public class RdUnitTestConstant : RdDataConstant
   {
    //fields
    //public fields
    [NotNull] public string SessionId {get; private set;}
    [NotNull] public RdUnitTestSelection Selection {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestConstant(
      [NotNull] string sessionId,
      [NotNull] RdUnitTestSelection selection
    )
    {
      if (sessionId == null) throw new ArgumentNullException("sessionId");
      if (selection == null) throw new ArgumentNullException("selection");
      
      SessionId = sessionId;
      Selection = selection;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<RdUnitTestConstant> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadString();
      var selection = RdUnitTestSelection.Read(ctx, reader);
      return new RdUnitTestConstant(sessionId, selection);
    };
    
    public static new CtxWriteDelegate<RdUnitTestConstant> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      RdUnitTestSelection.Write(ctx, writer, value.Selection);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestConstant) obj);
    }
    public bool Equals(RdUnitTestConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && Equals(Selection, other.Selection);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SessionId.GetHashCode();
        hash = hash * 31 + Selection.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestConstant (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("selection = "); Selection.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestDebuggerSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public RdUnitTestDebuggerSessionStartDescriptor SessionStartDescriptor {get; private set;}
    [NotNull] public IRdProperty<int> Pid { get { return _Pid; }}
    [NotNull] public ISource<bool> Terminate { get { return _Terminate; }}
    [NotNull] public ISink<RdVoid> Terminated { get { return _Terminated; }}
    
    //private fields
    [NotNull] private readonly RdProperty<int> _Pid;
    [NotNull] private readonly RdSignal<bool> _Terminate;
    [NotNull] private readonly RdSignal<RdVoid> _Terminated;
    
    //primary constructor
    private RdUnitTestDebuggerSession(
      [NotNull] RdUnitTestDebuggerSessionStartDescriptor sessionStartDescriptor,
      [NotNull] RdProperty<int> pid,
      [NotNull] RdSignal<bool> terminate,
      [NotNull] RdSignal<RdVoid> terminated
    )
    {
      if (sessionStartDescriptor == null) throw new ArgumentNullException("sessionStartDescriptor");
      if (pid == null) throw new ArgumentNullException("pid");
      if (terminate == null) throw new ArgumentNullException("terminate");
      if (terminated == null) throw new ArgumentNullException("terminated");
      
      SessionStartDescriptor = sessionStartDescriptor;
      _Pid = pid;
      _Terminate = terminate;
      _Terminated = terminated;
      _Pid.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("pid", _Pid));
      BindableChildren.Add(new KeyValuePair<string, object>("terminate", _Terminate));
      BindableChildren.Add(new KeyValuePair<string, object>("terminated", _Terminated));
    }
    //secondary constructor
    public RdUnitTestDebuggerSession (
      [NotNull] RdUnitTestDebuggerSessionStartDescriptor sessionStartDescriptor
    ) : this (
      sessionStartDescriptor,
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdSignal<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestDebuggerSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var sessionStartDescriptor = RdUnitTestDebuggerSessionStartDescriptor.Read(ctx, reader);
      var pid = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var terminate = RdSignal<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var terminated = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdUnitTestDebuggerSession(sessionStartDescriptor, pid, terminate, terminated).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdUnitTestDebuggerSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdUnitTestDebuggerSessionStartDescriptor.Write(ctx, writer, value.SessionStartDescriptor);
      RdProperty<int>.Write(ctx, writer, value._Pid);
      RdSignal<bool>.Write(ctx, writer, value._Terminate);
      RdSignal<RdVoid>.Write(ctx, writer, value._Terminated);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestDebuggerSession (");
      using (printer.IndentCookie()) {
        printer.Print("sessionStartDescriptor = "); SessionStartDescriptor.PrintEx(printer); printer.Println();
        printer.Print("pid = "); _Pid.PrintEx(printer); printer.Println();
        printer.Print("terminate = "); _Terminate.PrintEx(printer); printer.Println();
        printer.Print("terminated = "); _Terminated.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestDebuggerSessionStartDescriptor : IPrintable, IEquatable<RdUnitTestDebuggerSessionStartDescriptor> {
    //fields
    //public fields
    [NotNull] public string SessionId {get; private set;}
    [NotNull] public string Name {get; private set;}
    [NotNull] public string ExecutablePath {get; private set;}
    [NotNull] public string CommandLineArgs {get; private set;}
    [NotNull] public List<EnvironmentVariable> EnvironmentVariables {get; private set;}
    [NotNull] public string WorkingDirPath {get; private set;}
    [CanBeNull] public string RuntimeArguments {get; private set;}
    public bool RedirectOutput {get; private set;}
    public bool IsCoreClr {get; private set;}
    public bool ExecuteAsIs {get; private set;}
    [NotNull] public string AssemblyToDebug {get; private set;}
    public bool PreferMono {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestDebuggerSessionStartDescriptor(
      [NotNull] string sessionId,
      [NotNull] string name,
      [NotNull] string executablePath,
      [NotNull] string commandLineArgs,
      [NotNull] List<EnvironmentVariable> environmentVariables,
      [NotNull] string workingDirPath,
      [CanBeNull] string runtimeArguments,
      bool redirectOutput,
      bool isCoreClr,
      bool executeAsIs,
      [NotNull] string assemblyToDebug,
      bool preferMono
    )
    {
      if (sessionId == null) throw new ArgumentNullException("sessionId");
      if (name == null) throw new ArgumentNullException("name");
      if (executablePath == null) throw new ArgumentNullException("executablePath");
      if (commandLineArgs == null) throw new ArgumentNullException("commandLineArgs");
      if (environmentVariables == null) throw new ArgumentNullException("environmentVariables");
      if (workingDirPath == null) throw new ArgumentNullException("workingDirPath");
      if (assemblyToDebug == null) throw new ArgumentNullException("assemblyToDebug");
      
      SessionId = sessionId;
      Name = name;
      ExecutablePath = executablePath;
      CommandLineArgs = commandLineArgs;
      EnvironmentVariables = environmentVariables;
      WorkingDirPath = workingDirPath;
      RuntimeArguments = runtimeArguments;
      RedirectOutput = redirectOutput;
      IsCoreClr = isCoreClr;
      ExecuteAsIs = executeAsIs;
      AssemblyToDebug = assemblyToDebug;
      PreferMono = preferMono;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestDebuggerSessionStartDescriptor> Read = (ctx, reader) => 
    {
      var sessionId = reader.ReadString();
      var name = reader.ReadString();
      var executablePath = reader.ReadString();
      var commandLineArgs = reader.ReadString();
      var environmentVariables = ReadEnvironmentVariableList(ctx, reader);
      var workingDirPath = reader.ReadString();
      var runtimeArguments = ReadStringNullable(ctx, reader);
      var redirectOutput = reader.ReadBool();
      var isCoreClr = reader.ReadBool();
      var executeAsIs = reader.ReadBool();
      var assemblyToDebug = reader.ReadString();
      var preferMono = reader.ReadBool();
      return new RdUnitTestDebuggerSessionStartDescriptor(sessionId, name, executablePath, commandLineArgs, environmentVariables, workingDirPath, runtimeArguments, redirectOutput, isCoreClr, executeAsIs, assemblyToDebug, preferMono);
    };
    public static CtxReadDelegate<List<EnvironmentVariable>> ReadEnvironmentVariableList = EnvironmentVariable.Read.List();
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<RdUnitTestDebuggerSessionStartDescriptor> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SessionId);
      writer.Write(value.Name);
      writer.Write(value.ExecutablePath);
      writer.Write(value.CommandLineArgs);
      WriteEnvironmentVariableList(ctx, writer, value.EnvironmentVariables);
      writer.Write(value.WorkingDirPath);
      WriteStringNullable(ctx, writer, value.RuntimeArguments);
      writer.Write(value.RedirectOutput);
      writer.Write(value.IsCoreClr);
      writer.Write(value.ExecuteAsIs);
      writer.Write(value.AssemblyToDebug);
      writer.Write(value.PreferMono);
    };
    public static CtxWriteDelegate<List<EnvironmentVariable>> WriteEnvironmentVariableList = EnvironmentVariable.Write.List();
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestDebuggerSessionStartDescriptor) obj);
    }
    public bool Equals(RdUnitTestDebuggerSessionStartDescriptor other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SessionId == other.SessionId && Name == other.Name && ExecutablePath == other.ExecutablePath && CommandLineArgs == other.CommandLineArgs && EnvironmentVariables.SequenceEqual(other.EnvironmentVariables) && WorkingDirPath == other.WorkingDirPath && Equals(RuntimeArguments, other.RuntimeArguments) && RedirectOutput == other.RedirectOutput && IsCoreClr == other.IsCoreClr && ExecuteAsIs == other.ExecuteAsIs && AssemblyToDebug == other.AssemblyToDebug && PreferMono == other.PreferMono;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + SessionId.GetHashCode();
        hash = hash * 31 + Name.GetHashCode();
        hash = hash * 31 + ExecutablePath.GetHashCode();
        hash = hash * 31 + CommandLineArgs.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(EnvironmentVariables);
        hash = hash * 31 + WorkingDirPath.GetHashCode();
        hash = hash * 31 + (RuntimeArguments != null ?RuntimeArguments.GetHashCode() : 0);
        hash = hash * 31 + RedirectOutput.GetHashCode();
        hash = hash * 31 + IsCoreClr.GetHashCode();
        hash = hash * 31 + ExecuteAsIs.GetHashCode();
        hash = hash * 31 + AssemblyToDebug.GetHashCode();
        hash = hash * 31 + PreferMono.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestDebuggerSessionStartDescriptor (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("name = "); Name.PrintEx(printer); printer.Println();
        printer.Print("executablePath = "); ExecutablePath.PrintEx(printer); printer.Println();
        printer.Print("commandLineArgs = "); CommandLineArgs.PrintEx(printer); printer.Println();
        printer.Print("environmentVariables = "); EnvironmentVariables.PrintEx(printer); printer.Println();
        printer.Print("workingDirPath = "); WorkingDirPath.PrintEx(printer); printer.Println();
        printer.Print("runtimeArguments = "); RuntimeArguments.PrintEx(printer); printer.Println();
        printer.Print("redirectOutput = "); RedirectOutput.PrintEx(printer); printer.Println();
        printer.Print("isCoreClr = "); IsCoreClr.PrintEx(printer); printer.Println();
        printer.Print("executeAsIs = "); ExecuteAsIs.PrintEx(printer); printer.Println();
        printer.Print("assemblyToDebug = "); AssemblyToDebug.PrintEx(printer); printer.Println();
        printer.Print("preferMono = "); PreferMono.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElement : IPrintable, IEquatable<RdUnitTestElement> {
    //fields
    //public fields
    public int ElementId {get; private set;}
    [NotNull] public string ElementFullId {get; private set;}
    [NotNull] public string FrameworkId {get; private set;}
    [CanBeNull] public Icon OwnIcon {get; private set;}
    public int ParentElementId {get; private set;}
    [NotNull] public List<int> ProjectIds {get; private set;}
    [NotNull] public string Presentation {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestElement(
      int elementId,
      [NotNull] string elementFullId,
      [NotNull] string frameworkId,
      [CanBeNull] Icon ownIcon,
      int parentElementId,
      [NotNull] List<int> projectIds,
      [NotNull] string presentation
    )
    {
      if (elementFullId == null) throw new ArgumentNullException("elementFullId");
      if (frameworkId == null) throw new ArgumentNullException("frameworkId");
      if (projectIds == null) throw new ArgumentNullException("projectIds");
      if (presentation == null) throw new ArgumentNullException("presentation");
      
      ElementId = elementId;
      ElementFullId = elementFullId;
      FrameworkId = frameworkId;
      OwnIcon = ownIcon;
      ParentElementId = parentElementId;
      ProjectIds = projectIds;
      Presentation = presentation;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestElement> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadInt();
      var elementFullId = reader.ReadString();
      var frameworkId = reader.ReadString();
      var ownIcon = ReadIconNullable(ctx, reader);
      var parentElementId = reader.ReadInt();
      var projectIds = ReadIntList(ctx, reader);
      var presentation = reader.ReadString();
      return new RdUnitTestElement(elementId, elementFullId, frameworkId, ownIcon, parentElementId, projectIds, presentation);
    };
    public static CtxReadDelegate<Icon> ReadIconNullable = Icon.Read.NullableClass();
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<RdUnitTestElement> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.ElementFullId);
      writer.Write(value.FrameworkId);
      WriteIconNullable(ctx, writer, value.OwnIcon);
      writer.Write(value.ParentElementId);
      WriteIntList(ctx, writer, value.ProjectIds);
      writer.Write(value.Presentation);
    };
    public static CtxWriteDelegate<Icon> WriteIconNullable = Icon.Write.NullableClass();
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElement) obj);
    }
    public bool Equals(RdUnitTestElement other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && ElementFullId == other.ElementFullId && FrameworkId == other.FrameworkId && Equals(OwnIcon, other.OwnIcon) && ParentElementId == other.ParentElementId && ProjectIds.SequenceEqual(other.ProjectIds) && Presentation == other.Presentation;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementId.GetHashCode();
        hash = hash * 31 + ElementFullId.GetHashCode();
        hash = hash * 31 + FrameworkId.GetHashCode();
        hash = hash * 31 + (OwnIcon != null ?OwnIcon.GetHashCode() : 0);
        hash = hash * 31 + ParentElementId.GetHashCode();
        hash = hash * 31 + Collections.GetHashCode(ProjectIds);
        hash = hash * 31 + Presentation.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElement (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("elementFullId = "); ElementFullId.PrintEx(printer); printer.Println();
        printer.Print("frameworkId = "); FrameworkId.PrintEx(printer); printer.Println();
        printer.Print("ownIcon = "); OwnIcon.PrintEx(printer); printer.Println();
        printer.Print("parentElementId = "); ParentElementId.PrintEx(printer); printer.Println();
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
        printer.Print("presentation = "); Presentation.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementList : IPrintable, IEquatable<RdUnitTestElementList> {
    //fields
    //public fields
    [NotNull] public List<int> ElementIds {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestElementList(
      [NotNull] List<int> elementIds
    )
    {
      if (elementIds == null) throw new ArgumentNullException("elementIds");
      
      ElementIds = elementIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementList> Read = (ctx, reader) => 
    {
      var elementIds = ReadIntList(ctx, reader);
      return new RdUnitTestElementList(elementIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<RdUnitTestElementList> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ElementIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementList) obj);
    }
    public bool Equals(RdUnitTestElementList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementIds.SequenceEqual(other.ElementIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ElementIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementList (");
      using (printer.IndentCookie()) {
        printer.Print("elementIds = "); ElementIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementRepository : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISource<RdUnitTestElementSet> ElementsUpdated { get { return _ElementsUpdated; }}
    [NotNull] public ISource<RdUnitTestElementList> ElementsRemoved { get { return _ElementsRemoved; }}
    [NotNull] public ISink<RdUnitTestNavigateToElementArgs> NavigateToElement { get { return _NavigateToElement; }}
    [NotNull] public ISink<RdUnitTestNavigateToProjectArgs> NavigateToProject { get { return _NavigateToProject; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdUnitTestElementSet> _ElementsUpdated;
    [NotNull] private readonly RdSignal<RdUnitTestElementList> _ElementsRemoved;
    [NotNull] private readonly RdSignal<RdUnitTestNavigateToElementArgs> _NavigateToElement;
    [NotNull] private readonly RdSignal<RdUnitTestNavigateToProjectArgs> _NavigateToProject;
    
    //primary constructor
    private RdUnitTestElementRepository(
      [NotNull] RdSignal<RdUnitTestElementSet> elementsUpdated,
      [NotNull] RdSignal<RdUnitTestElementList> elementsRemoved,
      [NotNull] RdSignal<RdUnitTestNavigateToElementArgs> navigateToElement,
      [NotNull] RdSignal<RdUnitTestNavigateToProjectArgs> navigateToProject
    )
    {
      if (elementsUpdated == null) throw new ArgumentNullException("elementsUpdated");
      if (elementsRemoved == null) throw new ArgumentNullException("elementsRemoved");
      if (navigateToElement == null) throw new ArgumentNullException("navigateToElement");
      if (navigateToProject == null) throw new ArgumentNullException("navigateToProject");
      
      _ElementsUpdated = elementsUpdated;
      _ElementsRemoved = elementsRemoved;
      _NavigateToElement = navigateToElement;
      _NavigateToProject = navigateToProject;
      BindableChildren.Add(new KeyValuePair<string, object>("elementsUpdated", _ElementsUpdated));
      BindableChildren.Add(new KeyValuePair<string, object>("elementsRemoved", _ElementsRemoved));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToElement", _NavigateToElement));
      BindableChildren.Add(new KeyValuePair<string, object>("navigateToProject", _NavigateToProject));
    }
    //secondary constructor
    public RdUnitTestElementRepository (
    ) : this (
      new RdSignal<RdUnitTestElementSet>(RdUnitTestElementSet.Read, RdUnitTestElementSet.Write),
      new RdSignal<RdUnitTestElementList>(RdUnitTestElementList.Read, RdUnitTestElementList.Write),
      new RdSignal<RdUnitTestNavigateToElementArgs>(RdUnitTestNavigateToElementArgs.Read, RdUnitTestNavigateToElementArgs.Write),
      new RdSignal<RdUnitTestNavigateToProjectArgs>(RdUnitTestNavigateToProjectArgs.Read, RdUnitTestNavigateToProjectArgs.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementRepository> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var elementsUpdated = RdSignal<RdUnitTestElementSet>.Read(ctx, reader, RdUnitTestElementSet.Read, RdUnitTestElementSet.Write);
      var elementsRemoved = RdSignal<RdUnitTestElementList>.Read(ctx, reader, RdUnitTestElementList.Read, RdUnitTestElementList.Write);
      var navigateToElement = RdSignal<RdUnitTestNavigateToElementArgs>.Read(ctx, reader, RdUnitTestNavigateToElementArgs.Read, RdUnitTestNavigateToElementArgs.Write);
      var navigateToProject = RdSignal<RdUnitTestNavigateToProjectArgs>.Read(ctx, reader, RdUnitTestNavigateToProjectArgs.Read, RdUnitTestNavigateToProjectArgs.Write);
      return new RdUnitTestElementRepository(elementsUpdated, elementsRemoved, navigateToElement, navigateToProject).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdUnitTestElementRepository> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdUnitTestElementSet>.Write(ctx, writer, value._ElementsUpdated);
      RdSignal<RdUnitTestElementList>.Write(ctx, writer, value._ElementsRemoved);
      RdSignal<RdUnitTestNavigateToElementArgs>.Write(ctx, writer, value._NavigateToElement);
      RdSignal<RdUnitTestNavigateToProjectArgs>.Write(ctx, writer, value._NavigateToProject);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementRepository (");
      using (printer.IndentCookie()) {
        printer.Print("elementsUpdated = "); _ElementsUpdated.PrintEx(printer); printer.Println();
        printer.Print("elementsRemoved = "); _ElementsRemoved.PrintEx(printer); printer.Println();
        printer.Print("navigateToElement = "); _NavigateToElement.PrintEx(printer); printer.Println();
        printer.Print("navigateToProject = "); _NavigateToProject.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestElementSet : IPrintable, IEquatable<RdUnitTestElementSet> {
    //fields
    //public fields
    [NotNull] public List<RdUnitTestElement> Elements {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestElementSet(
      [NotNull] List<RdUnitTestElement> elements
    )
    {
      if (elements == null) throw new ArgumentNullException("elements");
      
      Elements = elements;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestElementSet> Read = (ctx, reader) => 
    {
      var elements = ReadRdUnitTestElementList(ctx, reader);
      return new RdUnitTestElementSet(elements);
    };
    public static CtxReadDelegate<List<RdUnitTestElement>> ReadRdUnitTestElementList = RdUnitTestElement.Read.List();
    
    public static CtxWriteDelegate<RdUnitTestElementSet> Write = (ctx, writer, value) => 
    {
      WriteRdUnitTestElementList(ctx, writer, value.Elements);
    };
    public static CtxWriteDelegate<List<RdUnitTestElement>> WriteRdUnitTestElementList = RdUnitTestElement.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestElementSet) obj);
    }
    public bool Equals(RdUnitTestElementSet other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Elements.SequenceEqual(other.Elements);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Elements);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestElementSet (");
      using (printer.IndentCookie()) {
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestExplorerWindowService : RdBindableBase {
    //fields
    //public fields
    [NotNull] public ISource<RdUnitTestElementList> OpenInExplorer { get { return _OpenInExplorer; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdUnitTestElementList> _OpenInExplorer;
    
    //primary constructor
    private RdUnitTestExplorerWindowService(
      [NotNull] RdSignal<RdUnitTestElementList> openInExplorer
    )
    {
      if (openInExplorer == null) throw new ArgumentNullException("openInExplorer");
      
      _OpenInExplorer = openInExplorer;
      BindableChildren.Add(new KeyValuePair<string, object>("openInExplorer", _OpenInExplorer));
    }
    //secondary constructor
    public RdUnitTestExplorerWindowService (
    ) : this (
      new RdSignal<RdUnitTestElementList>(RdUnitTestElementList.Read, RdUnitTestElementList.Write)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestExplorerWindowService> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var openInExplorer = RdSignal<RdUnitTestElementList>.Read(ctx, reader, RdUnitTestElementList.Read, RdUnitTestElementList.Write);
      return new RdUnitTestExplorerWindowService(openInExplorer).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdUnitTestExplorerWindowService> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdSignal<RdUnitTestElementList>.Write(ctx, writer, value._OpenInExplorer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestExplorerWindowService (");
      using (printer.IndentCookie()) {
        printer.Print("openInExplorer = "); _OpenInExplorer.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestLaunchStatus : IPrintable, IEquatable<RdUnitTestLaunchStatus> {
    //fields
    //public fields
    public bool Pending {get; private set;}
    public bool Running {get; private set;}
    public bool Cancelling {get; private set;}
    public bool Aborting {get; private set;}
    public bool Failing {get; private set;}
    public bool Finished {get; private set;}
    public bool Cancelled {get; private set;}
    public bool Aborted {get; private set;}
    public bool Faulted {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestLaunchStatus(
      bool pending,
      bool running,
      bool cancelling,
      bool aborting,
      bool failing,
      bool finished,
      bool cancelled,
      bool aborted,
      bool faulted
    )
    {
      Pending = pending;
      Running = running;
      Cancelling = cancelling;
      Aborting = aborting;
      Failing = failing;
      Finished = finished;
      Cancelled = cancelled;
      Aborted = aborted;
      Faulted = faulted;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestLaunchStatus> Read = (ctx, reader) => 
    {
      var pending = reader.ReadBool();
      var running = reader.ReadBool();
      var cancelling = reader.ReadBool();
      var aborting = reader.ReadBool();
      var failing = reader.ReadBool();
      var finished = reader.ReadBool();
      var cancelled = reader.ReadBool();
      var aborted = reader.ReadBool();
      var faulted = reader.ReadBool();
      return new RdUnitTestLaunchStatus(pending, running, cancelling, aborting, failing, finished, cancelled, aborted, faulted);
    };
    
    public static CtxWriteDelegate<RdUnitTestLaunchStatus> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Pending);
      writer.Write(value.Running);
      writer.Write(value.Cancelling);
      writer.Write(value.Aborting);
      writer.Write(value.Failing);
      writer.Write(value.Finished);
      writer.Write(value.Cancelled);
      writer.Write(value.Aborted);
      writer.Write(value.Faulted);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestLaunchStatus) obj);
    }
    public bool Equals(RdUnitTestLaunchStatus other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Pending == other.Pending && Running == other.Running && Cancelling == other.Cancelling && Aborting == other.Aborting && Failing == other.Failing && Finished == other.Finished && Cancelled == other.Cancelled && Aborted == other.Aborted && Faulted == other.Faulted;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Pending.GetHashCode();
        hash = hash * 31 + Running.GetHashCode();
        hash = hash * 31 + Cancelling.GetHashCode();
        hash = hash * 31 + Aborting.GetHashCode();
        hash = hash * 31 + Failing.GetHashCode();
        hash = hash * 31 + Finished.GetHashCode();
        hash = hash * 31 + Cancelled.GetHashCode();
        hash = hash * 31 + Aborted.GetHashCode();
        hash = hash * 31 + Faulted.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestLaunchStatus (");
      using (printer.IndentCookie()) {
        printer.Print("pending = "); Pending.PrintEx(printer); printer.Println();
        printer.Print("running = "); Running.PrintEx(printer); printer.Println();
        printer.Print("cancelling = "); Cancelling.PrintEx(printer); printer.Println();
        printer.Print("aborting = "); Aborting.PrintEx(printer); printer.Println();
        printer.Print("failing = "); Failing.PrintEx(printer); printer.Println();
        printer.Print("finished = "); Finished.PrintEx(printer); printer.Println();
        printer.Print("cancelled = "); Cancelled.PrintEx(printer); printer.Println();
        printer.Print("aborted = "); Aborted.PrintEx(printer); printer.Println();
        printer.Print("faulted = "); Faulted.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestNavigateToElementArgs : IPrintable, IEquatable<RdUnitTestNavigateToElementArgs> {
    //fields
    //public fields
    public int ElementId {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestNavigateToElementArgs(
      int elementId,
      bool requestFocus
    )
    {
      ElementId = elementId;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestNavigateToElementArgs> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUnitTestNavigateToElementArgs(elementId, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUnitTestNavigateToElementArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestNavigateToElementArgs) obj);
    }
    public bool Equals(RdUnitTestNavigateToElementArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementId.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestNavigateToElementArgs (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestNavigateToProjectArgs : IPrintable, IEquatable<RdUnitTestNavigateToProjectArgs> {
    //fields
    //public fields
    public int ProjectId {get; private set;}
    public bool RequestFocus {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestNavigateToProjectArgs(
      int projectId,
      bool requestFocus
    )
    {
      ProjectId = projectId;
      RequestFocus = requestFocus;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestNavigateToProjectArgs> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var requestFocus = reader.ReadBool();
      return new RdUnitTestNavigateToProjectArgs(projectId, requestFocus);
    };
    
    public static CtxWriteDelegate<RdUnitTestNavigateToProjectArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      writer.Write(value.RequestFocus);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestNavigateToProjectArgs) obj);
    }
    public bool Equals(RdUnitTestNavigateToProjectArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ProjectId == other.ProjectId && RequestFocus == other.RequestFocus;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ProjectId.GetHashCode();
        hash = hash * 31 + RequestFocus.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestNavigateToProjectArgs (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("requestFocus = "); RequestFocus.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestOpenSessionArgs : IPrintable, IEquatable<RdUnitTestOpenSessionArgs> {
    //fields
    //public fields
    public bool Activate {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestOpenSessionArgs(
      bool activate
    )
    {
      Activate = activate;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestOpenSessionArgs> Read = (ctx, reader) => 
    {
      var activate = reader.ReadBool();
      return new RdUnitTestOpenSessionArgs(activate);
    };
    
    public static CtxWriteDelegate<RdUnitTestOpenSessionArgs> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Activate);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestOpenSessionArgs) obj);
    }
    public bool Equals(RdUnitTestOpenSessionArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Activate == other.Activate;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Activate.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestOpenSessionArgs (");
      using (printer.IndentCookie()) {
        printer.Print("activate = "); Activate.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnitTestPlatformMonoPreference {
    Default,
    PreferClr,
    PreferMono
  }
  
  
  public enum RdUnitTestPlatformType {
    Default,
    Automatic,
    X86,
    X64
  }
  
  
  public class RdUnitTestResult : IPrintable, IEquatable<RdUnitTestResult> {
    //fields
    //public fields
    [CanBeNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public RdUnitTestStatus Status {get; private set;}
    public bool Outdated {get; private set;}
    [NotNull] public string ShortMessage {get; private set;}
    public DateTime StartTime {get; private set;}
    public DateTime EndTime {get; private set;}
    public int Duration {get; private set;}
    public int ChildrenFailCount {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestResult(
      [CanBeNull] JetBrains.Rider.Model.Icon icon,
      RdUnitTestStatus status,
      bool outdated,
      [NotNull] string shortMessage,
      DateTime startTime,
      DateTime endTime,
      int duration,
      int childrenFailCount
    )
    {
      if (shortMessage == null) throw new ArgumentNullException("shortMessage");
      
      Icon = icon;
      Status = status;
      Outdated = outdated;
      ShortMessage = shortMessage;
      StartTime = startTime;
      EndTime = endTime;
      Duration = duration;
      ChildrenFailCount = childrenFailCount;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResult> Read = (ctx, reader) => 
    {
      var icon = ReadIconNullable(ctx, reader);
      var status = (RdUnitTestStatus)reader.ReadInt();
      var outdated = reader.ReadBool();
      var shortMessage = reader.ReadString();
      var startTime = reader.ReadDateTime();
      var endTime = reader.ReadDateTime();
      var duration = reader.ReadInt();
      var childrenFailCount = reader.ReadInt();
      return new RdUnitTestResult(icon, status, outdated, shortMessage, startTime, endTime, duration, childrenFailCount);
    };
    public static CtxReadDelegate<JetBrains.Rider.Model.Icon> ReadIconNullable = JetBrains.Rider.Model.Icon.Read.NullableClass();
    
    public static CtxWriteDelegate<RdUnitTestResult> Write = (ctx, writer, value) => 
    {
      WriteIconNullable(ctx, writer, value.Icon);
      writer.Write((int)value.Status);
      writer.Write(value.Outdated);
      writer.Write(value.ShortMessage);
      writer.Write(value.StartTime);
      writer.Write(value.EndTime);
      writer.Write(value.Duration);
      writer.Write(value.ChildrenFailCount);
    };
    public static CtxWriteDelegate<JetBrains.Rider.Model.Icon> WriteIconNullable = JetBrains.Rider.Model.Icon.Write.NullableClass();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResult) obj);
    }
    public bool Equals(RdUnitTestResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Icon, other.Icon) && Status == other.Status && Outdated == other.Outdated && ShortMessage == other.ShortMessage && StartTime == other.StartTime && EndTime == other.EndTime && Duration == other.Duration && ChildrenFailCount == other.ChildrenFailCount;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (Icon != null ?Icon.GetHashCode() : 0);
        hash = hash * 31 + (int) Status;
        hash = hash * 31 + Outdated.GetHashCode();
        hash = hash * 31 + ShortMessage.GetHashCode();
        hash = hash * 31 + StartTime.GetHashCode();
        hash = hash * 31 + EndTime.GetHashCode();
        hash = hash * 31 + Duration.GetHashCode();
        hash = hash * 31 + ChildrenFailCount.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResult (");
      using (printer.IndentCookie()) {
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("outdated = "); Outdated.PrintEx(printer); printer.Println();
        printer.Print("shortMessage = "); ShortMessage.PrintEx(printer); printer.Println();
        printer.Print("startTime = "); StartTime.PrintEx(printer); printer.Println();
        printer.Print("endTime = "); EndTime.PrintEx(printer); printer.Println();
        printer.Print("duration = "); Duration.PrintEx(printer); printer.Println();
        printer.Print("childrenFailCount = "); ChildrenFailCount.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultData : IPrintable, IEquatable<RdUnitTestResultData> {
    //fields
    //public fields
    public RdUnitTestStatus Status {get; private set;}
    [NotNull] public string Title {get; private set;}
    [NotNull] public string ExceptionLines {get; private set;}
    [NotNull] public string OutputLines {get; private set;}
    public bool IsTrimmed {get; private set;}
    [NotNull] public string ServiceMessage {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestResultData(
      RdUnitTestStatus status,
      [NotNull] string title,
      [NotNull] string exceptionLines,
      [NotNull] string outputLines,
      bool isTrimmed,
      [NotNull] string serviceMessage
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (exceptionLines == null) throw new ArgumentNullException("exceptionLines");
      if (outputLines == null) throw new ArgumentNullException("outputLines");
      if (serviceMessage == null) throw new ArgumentNullException("serviceMessage");
      
      Status = status;
      Title = title;
      ExceptionLines = exceptionLines;
      OutputLines = outputLines;
      IsTrimmed = isTrimmed;
      ServiceMessage = serviceMessage;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultData> Read = (ctx, reader) => 
    {
      var status = (RdUnitTestStatus)reader.ReadInt();
      var title = reader.ReadString();
      var exceptionLines = reader.ReadString();
      var outputLines = reader.ReadString();
      var isTrimmed = reader.ReadBool();
      var serviceMessage = reader.ReadString();
      return new RdUnitTestResultData(status, title, exceptionLines, outputLines, isTrimmed, serviceMessage);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultData> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Status);
      writer.Write(value.Title);
      writer.Write(value.ExceptionLines);
      writer.Write(value.OutputLines);
      writer.Write(value.IsTrimmed);
      writer.Write(value.ServiceMessage);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultData) obj);
    }
    public bool Equals(RdUnitTestResultData other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Status == other.Status && Title == other.Title && ExceptionLines == other.ExceptionLines && OutputLines == other.OutputLines && IsTrimmed == other.IsTrimmed && ServiceMessage == other.ServiceMessage;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + (int) Status;
        hash = hash * 31 + Title.GetHashCode();
        hash = hash * 31 + ExceptionLines.GetHashCode();
        hash = hash * 31 + OutputLines.GetHashCode();
        hash = hash * 31 + IsTrimmed.GetHashCode();
        hash = hash * 31 + ServiceMessage.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultData (");
      using (printer.IndentCookie()) {
        printer.Print("status = "); Status.PrintEx(printer); printer.Println();
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("exceptionLines = "); ExceptionLines.PrintEx(printer); printer.Println();
        printer.Print("outputLines = "); OutputLines.PrintEx(printer); printer.Println();
        printer.Print("isTrimmed = "); IsTrimmed.PrintEx(printer); printer.Println();
        printer.Print("serviceMessage = "); ServiceMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultItem : IPrintable, IEquatable<RdUnitTestResultItem> {
    //fields
    //public fields
    public int ElementId {get; private set;}
    [NotNull] public RdUnitTestResult Result {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestResultItem(
      int elementId,
      [NotNull] RdUnitTestResult result
    )
    {
      if (result == null) throw new ArgumentNullException("result");
      
      ElementId = elementId;
      Result = result;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultItem> Read = (ctx, reader) => 
    {
      var elementId = reader.ReadInt();
      var result = RdUnitTestResult.Read(ctx, reader);
      return new RdUnitTestResultItem(elementId, result);
    };
    
    public static CtxWriteDelegate<RdUnitTestResultItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ElementId);
      RdUnitTestResult.Write(ctx, writer, value.Result);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultItem) obj);
    }
    public bool Equals(RdUnitTestResultItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementId == other.ElementId && Equals(Result, other.Result);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + ElementId.GetHashCode();
        hash = hash * 31 + Result.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultItem (");
      using (printer.IndentCookie()) {
        printer.Print("elementId = "); ElementId.PrintEx(printer); printer.Println();
        printer.Print("result = "); Result.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestResultList : IPrintable, IEquatable<RdUnitTestResultList> {
    //fields
    //public fields
    [NotNull] public List<RdUnitTestResultItem> Items {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestResultList(
      [NotNull] List<RdUnitTestResultItem> items
    )
    {
      if (items == null) throw new ArgumentNullException("items");
      
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestResultList> Read = (ctx, reader) => 
    {
      var items = ReadRdUnitTestResultItemList(ctx, reader);
      return new RdUnitTestResultList(items);
    };
    public static CtxReadDelegate<List<RdUnitTestResultItem>> ReadRdUnitTestResultItemList = RdUnitTestResultItem.Read.List();
    
    public static CtxWriteDelegate<RdUnitTestResultList> Write = (ctx, writer, value) => 
    {
      WriteRdUnitTestResultItemList(ctx, writer, value.Items);
    };
    public static CtxWriteDelegate<List<RdUnitTestResultItem>> WriteRdUnitTestResultItemList = RdUnitTestResultItem.Write.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestResultList) obj);
    }
    public bool Equals(RdUnitTestResultList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(Items);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestResultList (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSelection : IPrintable, IEquatable<RdUnitTestSelection> {
    //fields
    //public fields
    [NotNull] public List<int> ElementIds {get; private set;}
    [NotNull] public List<int> ProjectIds {get; private set;}
    
    //private fields
    //primary constructor
    public RdUnitTestSelection(
      [NotNull] List<int> elementIds,
      [NotNull] List<int> projectIds
    )
    {
      if (elementIds == null) throw new ArgumentNullException("elementIds");
      if (projectIds == null) throw new ArgumentNullException("projectIds");
      
      ElementIds = elementIds;
      ProjectIds = projectIds;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdUnitTestSelection> Read = (ctx, reader) => 
    {
      var elementIds = ReadIntList(ctx, reader);
      var projectIds = ReadIntList(ctx, reader);
      return new RdUnitTestSelection(elementIds, projectIds);
    };
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    
    public static CtxWriteDelegate<RdUnitTestSelection> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.ElementIds);
      WriteIntList(ctx, writer, value.ProjectIds);
    };
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RdUnitTestSelection) obj);
    }
    public bool Equals(RdUnitTestSelection other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ElementIds.SequenceEqual(other.ElementIds) && ProjectIds.SequenceEqual(other.ProjectIds);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(ElementIds);
        hash = hash * 31 + Collections.GetHashCode(ProjectIds);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSelection (");
      using (printer.IndentCookie()) {
        printer.Print("elementIds = "); ElementIds.PrintEx(printer); printer.Println();
        printer.Print("projectIds = "); ProjectIds.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string SessionId {get; private set;}
    [NotNull] public IRdProperty<RdUnitTestLaunchStatus> Status { get { return _Status; }}
    [NotNull] public ISource<RdUnitTestOpenSessionArgs> OpenSession { get { return _OpenSession; }}
    [NotNull] public ISink<RdVoid> Close { get { return _Close; }}
    [NotNull] public ISource<List<string>> LogLaunchMessages { get { return _LogLaunchMessages; }}
    [NotNull] public IRdProperty<string> LastLaunchLogError { get { return _LastLaunchLogError; }}
    [NotNull] public IRdProperty<string> LastLaunchLogPath { get { return _LastLaunchLogPath; }}
    [NotNull] public IRdProperty<string> LastRunnerLogPath { get { return _LastRunnerLogPath; }}
    [NotNull] public IRdProperty<RdUnitTestSelection> Selection { get { return _Selection; }}
    [NotNull] public IRdProperty<RdUnitTestResultData> ResultData { get { return _ResultData; }}
    [NotNull] public ISource<List<int>> AddElements { get { return _AddElements; }}
    [NotNull] public ISource<List<int>> RemoveElements { get { return _RemoveElements; }}
    [NotNull] public ISource<RdUnitTestResultList> UpdateElementResults { get { return _UpdateElementResults; }}
    [NotNull] public RdUnitTestSessionOptions Options {get; private set;}
    [NotNull] public IRdProperty<RdUnitTestStatus?> StatusFilter { get { return _StatusFilter; }}
    [NotNull] public ISink<RdVoid> Run { get { return _Run; }}
    [NotNull] public ISink<RdVoid> Debug { get { return _Debug; }}
    
    //private fields
    [NotNull] private readonly RdProperty<RdUnitTestLaunchStatus> _Status;
    [NotNull] private readonly RdSignal<RdUnitTestOpenSessionArgs> _OpenSession;
    [NotNull] private readonly RdSignal<RdVoid> _Close;
    [NotNull] private readonly RdSignal<List<string>> _LogLaunchMessages;
    [NotNull] private readonly RdProperty<string> _LastLaunchLogError;
    [NotNull] private readonly RdProperty<string> _LastLaunchLogPath;
    [NotNull] private readonly RdProperty<string> _LastRunnerLogPath;
    [NotNull] private readonly RdProperty<RdUnitTestSelection> _Selection;
    [NotNull] private readonly RdProperty<RdUnitTestResultData> _ResultData;
    [NotNull] private readonly RdSignal<List<int>> _AddElements;
    [NotNull] private readonly RdSignal<List<int>> _RemoveElements;
    [NotNull] private readonly RdSignal<RdUnitTestResultList> _UpdateElementResults;
    [NotNull] private readonly RdProperty<RdUnitTestStatus?> _StatusFilter;
    [NotNull] private readonly RdSignal<RdVoid> _Run;
    [NotNull] private readonly RdSignal<RdVoid> _Debug;
    
    //primary constructor
    private RdUnitTestSession(
      [NotNull] string sessionId,
      [NotNull] RdProperty<RdUnitTestLaunchStatus> status,
      [NotNull] RdSignal<RdUnitTestOpenSessionArgs> openSession,
      [NotNull] RdSignal<RdVoid> close,
      [NotNull] RdSignal<List<string>> logLaunchMessages,
      [NotNull] RdProperty<string> lastLaunchLogError,
      [NotNull] RdProperty<string> lastLaunchLogPath,
      [NotNull] RdProperty<string> lastRunnerLogPath,
      [NotNull] RdProperty<RdUnitTestSelection> selection,
      [NotNull] RdProperty<RdUnitTestResultData> resultData,
      [NotNull] RdSignal<List<int>> addElements,
      [NotNull] RdSignal<List<int>> removeElements,
      [NotNull] RdSignal<RdUnitTestResultList> updateElementResults,
      [NotNull] RdUnitTestSessionOptions options,
      [NotNull] RdProperty<RdUnitTestStatus?> statusFilter,
      [NotNull] RdSignal<RdVoid> run,
      [NotNull] RdSignal<RdVoid> debug
    )
    {
      if (sessionId == null) throw new ArgumentNullException("sessionId");
      if (status == null) throw new ArgumentNullException("status");
      if (openSession == null) throw new ArgumentNullException("openSession");
      if (close == null) throw new ArgumentNullException("close");
      if (logLaunchMessages == null) throw new ArgumentNullException("logLaunchMessages");
      if (lastLaunchLogError == null) throw new ArgumentNullException("lastLaunchLogError");
      if (lastLaunchLogPath == null) throw new ArgumentNullException("lastLaunchLogPath");
      if (lastRunnerLogPath == null) throw new ArgumentNullException("lastRunnerLogPath");
      if (selection == null) throw new ArgumentNullException("selection");
      if (resultData == null) throw new ArgumentNullException("resultData");
      if (addElements == null) throw new ArgumentNullException("addElements");
      if (removeElements == null) throw new ArgumentNullException("removeElements");
      if (updateElementResults == null) throw new ArgumentNullException("updateElementResults");
      if (options == null) throw new ArgumentNullException("options");
      if (statusFilter == null) throw new ArgumentNullException("statusFilter");
      if (run == null) throw new ArgumentNullException("run");
      if (debug == null) throw new ArgumentNullException("debug");
      
      SessionId = sessionId;
      _Status = status;
      _OpenSession = openSession;
      _Close = close;
      _LogLaunchMessages = logLaunchMessages;
      _LastLaunchLogError = lastLaunchLogError;
      _LastLaunchLogPath = lastLaunchLogPath;
      _LastRunnerLogPath = lastRunnerLogPath;
      _Selection = selection;
      _ResultData = resultData;
      _AddElements = addElements;
      _RemoveElements = removeElements;
      _UpdateElementResults = updateElementResults;
      Options = options;
      _StatusFilter = statusFilter;
      _Run = run;
      _Debug = debug;
      _Status.OptimizeNested = true;
      _LastLaunchLogError.OptimizeNested = true;
      _LastLaunchLogPath.OptimizeNested = true;
      _LastRunnerLogPath.OptimizeNested = true;
      _Selection.OptimizeNested = true;
      _ResultData.OptimizeNested = true;
      _StatusFilter.OptimizeNested = true;
      _ResultData.ValueCanBeNull = true;
      _StatusFilter.ValueCanBeNull = true;
      BindableChildren.Add(new KeyValuePair<string, object>("status", _Status));
      BindableChildren.Add(new KeyValuePair<string, object>("openSession", _OpenSession));
      BindableChildren.Add(new KeyValuePair<string, object>("close", _Close));
      BindableChildren.Add(new KeyValuePair<string, object>("logLaunchMessages", _LogLaunchMessages));
      BindableChildren.Add(new KeyValuePair<string, object>("lastLaunchLogError", _LastLaunchLogError));
      BindableChildren.Add(new KeyValuePair<string, object>("lastLaunchLogPath", _LastLaunchLogPath));
      BindableChildren.Add(new KeyValuePair<string, object>("lastRunnerLogPath", _LastRunnerLogPath));
      BindableChildren.Add(new KeyValuePair<string, object>("selection", _Selection));
      BindableChildren.Add(new KeyValuePair<string, object>("resultData", _ResultData));
      BindableChildren.Add(new KeyValuePair<string, object>("addElements", _AddElements));
      BindableChildren.Add(new KeyValuePair<string, object>("removeElements", _RemoveElements));
      BindableChildren.Add(new KeyValuePair<string, object>("updateElementResults", _UpdateElementResults));
      BindableChildren.Add(new KeyValuePair<string, object>("options", Options));
      BindableChildren.Add(new KeyValuePair<string, object>("statusFilter", _StatusFilter));
      BindableChildren.Add(new KeyValuePair<string, object>("run", _Run));
      BindableChildren.Add(new KeyValuePair<string, object>("debug", _Debug));
    }
    //secondary constructor
    public RdUnitTestSession (
      [NotNull] string sessionId
    ) : this (
      sessionId,
      new RdProperty<RdUnitTestLaunchStatus>(RdUnitTestLaunchStatus.Read, RdUnitTestLaunchStatus.Write),
      new RdSignal<RdUnitTestOpenSessionArgs>(RdUnitTestOpenSessionArgs.Read, RdUnitTestOpenSessionArgs.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<List<string>>(ReadStringList, WriteStringList),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<RdUnitTestSelection>(RdUnitTestSelection.Read, RdUnitTestSelection.Write),
      new RdProperty<RdUnitTestResultData>(ReadRdUnitTestResultDataNullable, WriteRdUnitTestResultDataNullable),
      new RdSignal<List<int>>(ReadIntList, WriteIntList),
      new RdSignal<List<int>>(ReadIntList, WriteIntList),
      new RdSignal<RdUnitTestResultList>(RdUnitTestResultList.Read, RdUnitTestResultList.Write),
      new RdUnitTestSessionOptions(),
      new RdProperty<RdUnitTestStatus?>(ReadRdUnitTestStatusNullable, WriteRdUnitTestStatusNullable),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var sessionId = reader.ReadString();
      var status = RdProperty<RdUnitTestLaunchStatus>.Read(ctx, reader, RdUnitTestLaunchStatus.Read, RdUnitTestLaunchStatus.Write);
      var openSession = RdSignal<RdUnitTestOpenSessionArgs>.Read(ctx, reader, RdUnitTestOpenSessionArgs.Read, RdUnitTestOpenSessionArgs.Write);
      var close = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var logLaunchMessages = RdSignal<List<string>>.Read(ctx, reader, ReadStringList, WriteStringList);
      var lastLaunchLogError = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var lastLaunchLogPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var lastRunnerLogPath = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var selection = RdProperty<RdUnitTestSelection>.Read(ctx, reader, RdUnitTestSelection.Read, RdUnitTestSelection.Write);
      var resultData = RdProperty<RdUnitTestResultData>.Read(ctx, reader, ReadRdUnitTestResultDataNullable, WriteRdUnitTestResultDataNullable);
      var addElements = RdSignal<List<int>>.Read(ctx, reader, ReadIntList, WriteIntList);
      var removeElements = RdSignal<List<int>>.Read(ctx, reader, ReadIntList, WriteIntList);
      var updateElementResults = RdSignal<RdUnitTestResultList>.Read(ctx, reader, RdUnitTestResultList.Read, RdUnitTestResultList.Write);
      var options = RdUnitTestSessionOptions.Read(ctx, reader);
      var statusFilter = RdProperty<RdUnitTestStatus?>.Read(ctx, reader, ReadRdUnitTestStatusNullable, WriteRdUnitTestStatusNullable);
      var run = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var debug = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdUnitTestSession(sessionId, status, openSession, close, logLaunchMessages, lastLaunchLogError, lastLaunchLogPath, lastRunnerLogPath, selection, resultData, addElements, removeElements, updateElementResults, options, statusFilter, run, debug).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    public static CtxReadDelegate<RdUnitTestResultData> ReadRdUnitTestResultDataNullable = RdUnitTestResultData.Read.NullableClass();
    public static CtxReadDelegate<List<int>> ReadIntList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt.List();
    public static CtxReadDelegate<RdUnitTestStatus?> ReadRdUnitTestStatusNullable = new CtxReadDelegate<RdUnitTestStatus>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdUnitTestStatus>).NullableStruct();
    
    public static CtxWriteDelegate<RdUnitTestSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.SessionId);
      RdProperty<RdUnitTestLaunchStatus>.Write(ctx, writer, value._Status);
      RdSignal<RdUnitTestOpenSessionArgs>.Write(ctx, writer, value._OpenSession);
      RdSignal<RdVoid>.Write(ctx, writer, value._Close);
      RdSignal<List<string>>.Write(ctx, writer, value._LogLaunchMessages);
      RdProperty<string>.Write(ctx, writer, value._LastLaunchLogError);
      RdProperty<string>.Write(ctx, writer, value._LastLaunchLogPath);
      RdProperty<string>.Write(ctx, writer, value._LastRunnerLogPath);
      RdProperty<RdUnitTestSelection>.Write(ctx, writer, value._Selection);
      RdProperty<RdUnitTestResultData>.Write(ctx, writer, value._ResultData);
      RdSignal<List<int>>.Write(ctx, writer, value._AddElements);
      RdSignal<List<int>>.Write(ctx, writer, value._RemoveElements);
      RdSignal<RdUnitTestResultList>.Write(ctx, writer, value._UpdateElementResults);
      RdUnitTestSessionOptions.Write(ctx, writer, value.Options);
      RdProperty<RdUnitTestStatus?>.Write(ctx, writer, value._StatusFilter);
      RdSignal<RdVoid>.Write(ctx, writer, value._Run);
      RdSignal<RdVoid>.Write(ctx, writer, value._Debug);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    public static CtxWriteDelegate<RdUnitTestResultData> WriteRdUnitTestResultDataNullable = RdUnitTestResultData.Write.NullableClass();
    public static CtxWriteDelegate<List<int>> WriteIntList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt.List();
    public static CtxWriteDelegate<RdUnitTestStatus?> WriteRdUnitTestStatusNullable = new CtxWriteDelegate<RdUnitTestStatus>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdUnitTestStatus>).NullableStruct();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSession (");
      using (printer.IndentCookie()) {
        printer.Print("sessionId = "); SessionId.PrintEx(printer); printer.Println();
        printer.Print("status = "); _Status.PrintEx(printer); printer.Println();
        printer.Print("openSession = "); _OpenSession.PrintEx(printer); printer.Println();
        printer.Print("close = "); _Close.PrintEx(printer); printer.Println();
        printer.Print("logLaunchMessages = "); _LogLaunchMessages.PrintEx(printer); printer.Println();
        printer.Print("lastLaunchLogError = "); _LastLaunchLogError.PrintEx(printer); printer.Println();
        printer.Print("lastLaunchLogPath = "); _LastLaunchLogPath.PrintEx(printer); printer.Println();
        printer.Print("lastRunnerLogPath = "); _LastRunnerLogPath.PrintEx(printer); printer.Println();
        printer.Print("selection = "); _Selection.PrintEx(printer); printer.Println();
        printer.Print("resultData = "); _ResultData.PrintEx(printer); printer.Println();
        printer.Print("addElements = "); _AddElements.PrintEx(printer); printer.Println();
        printer.Print("removeElements = "); _RemoveElements.PrintEx(printer); printer.Println();
        printer.Print("updateElementResults = "); _UpdateElementResults.PrintEx(printer); printer.Println();
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("statusFilter = "); _StatusFilter.PrintEx(printer); printer.Println();
        printer.Print("run = "); _Run.PrintEx(printer); printer.Println();
        printer.Print("debug = "); _Debug.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSessionManager : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> ActiveSessionId { get { return _ActiveSessionId; }}
    [NotNull] public ISink<RdVoid> EnsureSessionsAreOpened { get { return _EnsureSessionsAreOpened; }}
    [NotNull] public ISink<RdVoid> CloseAllSessions { get { return _CloseAllSessions; }}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _ActiveSessionId;
    [NotNull] private readonly RdSignal<RdVoid> _EnsureSessionsAreOpened;
    [NotNull] private readonly RdSignal<RdVoid> _CloseAllSessions;
    
    //primary constructor
    private RdUnitTestSessionManager(
      [NotNull] RdProperty<string> activeSessionId,
      [NotNull] RdSignal<RdVoid> ensureSessionsAreOpened,
      [NotNull] RdSignal<RdVoid> closeAllSessions
    )
    {
      if (activeSessionId == null) throw new ArgumentNullException("activeSessionId");
      if (ensureSessionsAreOpened == null) throw new ArgumentNullException("ensureSessionsAreOpened");
      if (closeAllSessions == null) throw new ArgumentNullException("closeAllSessions");
      
      _ActiveSessionId = activeSessionId;
      _EnsureSessionsAreOpened = ensureSessionsAreOpened;
      _CloseAllSessions = closeAllSessions;
      _ActiveSessionId.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("activeSessionId", _ActiveSessionId));
      BindableChildren.Add(new KeyValuePair<string, object>("ensureSessionsAreOpened", _EnsureSessionsAreOpened));
      BindableChildren.Add(new KeyValuePair<string, object>("closeAllSessions", _CloseAllSessions));
    }
    //secondary constructor
    public RdUnitTestSessionManager (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid)
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestSessionManager> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var activeSessionId = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var ensureSessionsAreOpened = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      var closeAllSessions = RdSignal<RdVoid>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid);
      return new RdUnitTestSessionManager(activeSessionId, ensureSessionsAreOpened, closeAllSessions).WithId(_id);
    };
    
    public static CtxWriteDelegate<RdUnitTestSessionManager> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._ActiveSessionId);
      RdSignal<RdVoid>.Write(ctx, writer, value._EnsureSessionsAreOpened);
      RdSignal<RdVoid>.Write(ctx, writer, value._CloseAllSessions);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSessionManager (");
      using (printer.IndentCookie()) {
        printer.Print("activeSessionId = "); _ActiveSessionId.PrintEx(printer); printer.Println();
        printer.Print("ensureSessionsAreOpened = "); _EnsureSessionsAreOpened.PrintEx(printer); printer.Println();
        printer.Print("closeAllSessions = "); _CloseAllSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RdUnitTestSessionOptions : RdBindableBase {
    //fields
    //public fields
    [NotNull] public IRdProperty<string> Title { get { return _Title; }}
    [NotNull] public IRdProperty<bool> IsIdle { get { return _IsIdle; }}
    [NotNull] public IRdProperty<bool> IsLocked { get { return _IsLocked; }}
    [NotNull] public IRdProperty<bool> IsActive { get { return _IsActive; }}
    [NotNull] public IRdProperty<RdUnitTestBuildPolicy> BuildPolicy { get { return _BuildPolicy; }}
    [NotNull] public IRdProperty<RdUnitTestPlatformType> PlatformType { get { return _PlatformType; }}
    [NotNull] public IRdProperty<RdUnitTestPlatformMonoPreference> PlatformMonoPreference { get { return _PlatformMonoPreference; }}
    [NotNull] public IRdProperty<bool> WrapLongLinesInUnitTestSessionOutput { get { return _WrapLongLinesInUnitTestSessionOutput; }}
    [NotNull] public JetBrains.Rider.Model.ContinuousTesting ContinuousTesting {get; private set;}
    
    //private fields
    [NotNull] private readonly RdProperty<string> _Title;
    [NotNull] private readonly RdProperty<bool> _IsIdle;
    [NotNull] private readonly RdProperty<bool> _IsLocked;
    [NotNull] private readonly RdProperty<bool> _IsActive;
    [NotNull] private readonly RdProperty<RdUnitTestBuildPolicy> _BuildPolicy;
    [NotNull] private readonly RdProperty<RdUnitTestPlatformType> _PlatformType;
    [NotNull] private readonly RdProperty<RdUnitTestPlatformMonoPreference> _PlatformMonoPreference;
    [NotNull] private readonly RdProperty<bool> _WrapLongLinesInUnitTestSessionOutput;
    
    //primary constructor
    private RdUnitTestSessionOptions(
      [NotNull] RdProperty<string> title,
      [NotNull] RdProperty<bool> isIdle,
      [NotNull] RdProperty<bool> isLocked,
      [NotNull] RdProperty<bool> isActive,
      [NotNull] RdProperty<RdUnitTestBuildPolicy> buildPolicy,
      [NotNull] RdProperty<RdUnitTestPlatformType> platformType,
      [NotNull] RdProperty<RdUnitTestPlatformMonoPreference> platformMonoPreference,
      [NotNull] RdProperty<bool> wrapLongLinesInUnitTestSessionOutput,
      [NotNull] JetBrains.Rider.Model.ContinuousTesting continuousTesting
    )
    {
      if (title == null) throw new ArgumentNullException("title");
      if (isIdle == null) throw new ArgumentNullException("isIdle");
      if (isLocked == null) throw new ArgumentNullException("isLocked");
      if (isActive == null) throw new ArgumentNullException("isActive");
      if (buildPolicy == null) throw new ArgumentNullException("buildPolicy");
      if (platformType == null) throw new ArgumentNullException("platformType");
      if (platformMonoPreference == null) throw new ArgumentNullException("platformMonoPreference");
      if (wrapLongLinesInUnitTestSessionOutput == null) throw new ArgumentNullException("wrapLongLinesInUnitTestSessionOutput");
      if (continuousTesting == null) throw new ArgumentNullException("continuousTesting");
      
      _Title = title;
      _IsIdle = isIdle;
      _IsLocked = isLocked;
      _IsActive = isActive;
      _BuildPolicy = buildPolicy;
      _PlatformType = platformType;
      _PlatformMonoPreference = platformMonoPreference;
      _WrapLongLinesInUnitTestSessionOutput = wrapLongLinesInUnitTestSessionOutput;
      ContinuousTesting = continuousTesting;
      _Title.OptimizeNested = true;
      _IsIdle.OptimizeNested = true;
      _IsLocked.OptimizeNested = true;
      _IsActive.OptimizeNested = true;
      _BuildPolicy.OptimizeNested = true;
      _PlatformType.OptimizeNested = true;
      _PlatformMonoPreference.OptimizeNested = true;
      _WrapLongLinesInUnitTestSessionOutput.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("title", _Title));
      BindableChildren.Add(new KeyValuePair<string, object>("isIdle", _IsIdle));
      BindableChildren.Add(new KeyValuePair<string, object>("isLocked", _IsLocked));
      BindableChildren.Add(new KeyValuePair<string, object>("isActive", _IsActive));
      BindableChildren.Add(new KeyValuePair<string, object>("buildPolicy", _BuildPolicy));
      BindableChildren.Add(new KeyValuePair<string, object>("platformType", _PlatformType));
      BindableChildren.Add(new KeyValuePair<string, object>("platformMonoPreference", _PlatformMonoPreference));
      BindableChildren.Add(new KeyValuePair<string, object>("wrapLongLinesInUnitTestSessionOutput", _WrapLongLinesInUnitTestSessionOutput));
      BindableChildren.Add(new KeyValuePair<string, object>("continuousTesting", ContinuousTesting));
    }
    //secondary constructor
    public RdUnitTestSessionOptions (
    ) : this (
      new RdProperty<string>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<RdUnitTestBuildPolicy>(ReadRdUnitTestBuildPolicy, WriteRdUnitTestBuildPolicy),
      new RdProperty<RdUnitTestPlatformType>(ReadRdUnitTestPlatformType, WriteRdUnitTestPlatformType),
      new RdProperty<RdUnitTestPlatformMonoPreference>(ReadRdUnitTestPlatformMonoPreference, WriteRdUnitTestPlatformMonoPreference),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new JetBrains.Rider.Model.ContinuousTesting()
    ) {}
    //statics
    
    public static CtxReadDelegate<RdUnitTestSessionOptions> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var title = RdProperty<string>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString);
      var isIdle = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isLocked = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var isActive = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var buildPolicy = RdProperty<RdUnitTestBuildPolicy>.Read(ctx, reader, ReadRdUnitTestBuildPolicy, WriteRdUnitTestBuildPolicy);
      var platformType = RdProperty<RdUnitTestPlatformType>.Read(ctx, reader, ReadRdUnitTestPlatformType, WriteRdUnitTestPlatformType);
      var platformMonoPreference = RdProperty<RdUnitTestPlatformMonoPreference>.Read(ctx, reader, ReadRdUnitTestPlatformMonoPreference, WriteRdUnitTestPlatformMonoPreference);
      var wrapLongLinesInUnitTestSessionOutput = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var continuousTesting = JetBrains.Rider.Model.ContinuousTesting.Read(ctx, reader);
      return new RdUnitTestSessionOptions(title, isIdle, isLocked, isActive, buildPolicy, platformType, platformMonoPreference, wrapLongLinesInUnitTestSessionOutput, continuousTesting).WithId(_id);
    };
    public static CtxReadDelegate<RdUnitTestBuildPolicy> ReadRdUnitTestBuildPolicy = new CtxReadDelegate<RdUnitTestBuildPolicy>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdUnitTestBuildPolicy>);
    public static CtxReadDelegate<RdUnitTestPlatformType> ReadRdUnitTestPlatformType = new CtxReadDelegate<RdUnitTestPlatformType>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdUnitTestPlatformType>);
    public static CtxReadDelegate<RdUnitTestPlatformMonoPreference> ReadRdUnitTestPlatformMonoPreference = new CtxReadDelegate<RdUnitTestPlatformMonoPreference>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadEnum<RdUnitTestPlatformMonoPreference>);
    
    public static CtxWriteDelegate<RdUnitTestSessionOptions> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      RdProperty<string>.Write(ctx, writer, value._Title);
      RdProperty<bool>.Write(ctx, writer, value._IsIdle);
      RdProperty<bool>.Write(ctx, writer, value._IsLocked);
      RdProperty<bool>.Write(ctx, writer, value._IsActive);
      RdProperty<RdUnitTestBuildPolicy>.Write(ctx, writer, value._BuildPolicy);
      RdProperty<RdUnitTestPlatformType>.Write(ctx, writer, value._PlatformType);
      RdProperty<RdUnitTestPlatformMonoPreference>.Write(ctx, writer, value._PlatformMonoPreference);
      RdProperty<bool>.Write(ctx, writer, value._WrapLongLinesInUnitTestSessionOutput);
      JetBrains.Rider.Model.ContinuousTesting.Write(ctx, writer, value.ContinuousTesting);
    };
    public static CtxWriteDelegate<RdUnitTestBuildPolicy> WriteRdUnitTestBuildPolicy = new CtxWriteDelegate<RdUnitTestBuildPolicy>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdUnitTestBuildPolicy>);
    public static CtxWriteDelegate<RdUnitTestPlatformType> WriteRdUnitTestPlatformType = new CtxWriteDelegate<RdUnitTestPlatformType>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdUnitTestPlatformType>);
    public static CtxWriteDelegate<RdUnitTestPlatformMonoPreference> WriteRdUnitTestPlatformMonoPreference = new CtxWriteDelegate<RdUnitTestPlatformMonoPreference>(JetBrains.Platform.RdFramework.Impl.Serializers.WriteEnum<RdUnitTestPlatformMonoPreference>);
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RdUnitTestSessionOptions (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); _Title.PrintEx(printer); printer.Println();
        printer.Print("isIdle = "); _IsIdle.PrintEx(printer); printer.Println();
        printer.Print("isLocked = "); _IsLocked.PrintEx(printer); printer.Println();
        printer.Print("isActive = "); _IsActive.PrintEx(printer); printer.Println();
        printer.Print("buildPolicy = "); _BuildPolicy.PrintEx(printer); printer.Println();
        printer.Print("platformType = "); _PlatformType.PrintEx(printer); printer.Println();
        printer.Print("platformMonoPreference = "); _PlatformMonoPreference.PrintEx(printer); printer.Println();
        printer.Print("wrapLongLinesInUnitTestSessionOutput = "); _WrapLongLinesInUnitTestSessionOutput.PrintEx(printer); printer.Println();
        printer.Print("continuousTesting = "); ContinuousTesting.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum RdUnitTestStatus {
    None,
    Unknown,
    Ignored,
    Success,
    Inconclusive,
    Failed,
    Aborted,
    Pending,
    Running
  }
}
