using System;
using System.Linq;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util.Collections;
using JetBrains.Util.Logging;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Xaml.Renderer
{
  
  
  public class XamlPreviewServiceModel : RdExtBase {
    //fields
    //public fields
    [NotNull] public IRdSignal<RdVoid> Initialized { get { return _Initialized; }}
    [NotNull] public IRdProperty<XamlPreviewEnvironment> Environment { get { return _Environment; }}
    [NotNull] public IRdSignal<RdVoid> Exit { get { return _Exit; }}
    [NotNull] public IViewableMap<string, XamlPreviewSession> PreviewSessions { get { return _PreviewSessions; }}
    
    //private fields
    [NotNull] private readonly RdSignal<RdVoid> _Initialized;
    [NotNull] private readonly RdProperty<XamlPreviewEnvironment> _Environment;
    [NotNull] private readonly RdSignal<RdVoid> _Exit;
    [NotNull] private readonly RdMap<string, XamlPreviewSession> _PreviewSessions;
    
    //primary constructor
    private XamlPreviewServiceModel(
      [NotNull] RdSignal<RdVoid> initialized,
      [NotNull] RdProperty<XamlPreviewEnvironment> environment,
      [NotNull] RdSignal<RdVoid> exit,
      [NotNull] RdMap<string, XamlPreviewSession> previewSessions
    )
    {
      if (initialized == null) throw new ArgumentNullException("initialized");
      if (environment == null) throw new ArgumentNullException("environment");
      if (exit == null) throw new ArgumentNullException("exit");
      if (previewSessions == null) throw new ArgumentNullException("previewSessions");
      
      _Initialized = initialized;
      _Environment = environment;
      _Exit = exit;
      _PreviewSessions = previewSessions;
      BindableChildren.Add(new KeyValuePair<string, object>("initialized", _Initialized));
      BindableChildren.Add(new KeyValuePair<string, object>("environment", _Environment));
      BindableChildren.Add(new KeyValuePair<string, object>("exit", _Exit));
      BindableChildren.Add(new KeyValuePair<string, object>("previewSessions", _PreviewSessions));
    }
    //secondary constructor
    private XamlPreviewServiceModel (
    ) : this (
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdProperty<XamlPreviewEnvironment>(XamlPreviewEnvironment.Read, XamlPreviewEnvironment.Write),
      new RdSignal<RdVoid>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadVoid, JetBrains.Platform.RdFramework.Impl.Serializers.WriteVoid),
      new RdMap<string, XamlPreviewSession>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, XamlPreviewSession.Read, XamlPreviewSession.Write)
    ) {}
    //statics
    
    
    
    protected override long SerializationHash => -4375459340429835377L;
    
    protected override Action<ISerializers> Register => RegisterDeclaredTypesSerializers;
    public static void RegisterDeclaredTypesSerializers(ISerializers serializers)
    {
      serializers.Register(NoneXamlPreviewState.Read, NoneXamlPreviewState.Write);
      serializers.Register(ReloadingMarkupXamlPreviewState.Read, ReloadingMarkupXamlPreviewState.Write);
      serializers.Register(SucceedXamlPreviewState.Read, SucceedXamlPreviewState.Write);
      serializers.Register(NotAvailableXamlPreviewState.Read, NotAvailableXamlPreviewState.Write);
      serializers.Register(SetupErrorXamlPreviewState.Read, SetupErrorXamlPreviewState.Write);
      serializers.Register(BuildErrorXamlPreviewState.Read, BuildErrorXamlPreviewState.Write);
      serializers.Register(AssembliesCollection.Read, AssembliesCollection.Write);
      serializers.Register(XamlMarkup.Read, XamlMarkup.Write);
      serializers.Register(XamlPreviewSession.Read, XamlPreviewSession.Write);
      serializers.Register(XamlPreviewEnvironment.Read, XamlPreviewEnvironment.Write);
      
      serializers.RegisterToplevelOnce(typeof(XamlPreviewServiceModel), XamlPreviewServiceModel.RegisterDeclaredTypesSerializers);
    }
    
    public XamlPreviewServiceModel(Lifetime lifetime, IProtocol protocol) : this()
    {
      Identify(protocol.Identities, RdId.Root.Mix(GetType().Name));
      Bind(lifetime, protocol, GetType().Name);
      if (Protocol.InitializationLogger.IsTraceEnabled())
        Protocol.InitializationLogger.Trace ("CREATED toplevel object {0}", this.PrintToString());
    }
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamlPreviewServiceModel (");
      using (printer.IndentCookie()) {
        printer.Print("initialized = "); _Initialized.PrintEx(printer); printer.Println();
        printer.Print("environment = "); _Environment.PrintEx(printer); printer.Println();
        printer.Print("exit = "); _Exit.PrintEx(printer); printer.Println();
        printer.Print("previewSessions = "); _PreviewSessions.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AssembliesCollection : IPrintable, IEquatable<AssembliesCollection> {
    //fields
    //public fields
    [NotNull] public List<string> AssembliesPaths {get; private set;}
    
    //private fields
    //primary constructor
    public AssembliesCollection(
      [NotNull] List<string> assembliesPaths
    )
    {
      if (assembliesPaths == null) throw new ArgumentNullException("assembliesPaths");
      
      AssembliesPaths = assembliesPaths;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AssembliesCollection> Read = (ctx, reader) => 
    {
      var assembliesPaths = ReadStringList(ctx, reader);
      return new AssembliesCollection(assembliesPaths);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<AssembliesCollection> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.AssembliesPaths);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AssembliesCollection) obj);
    }
    public bool Equals(AssembliesCollection other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return AssembliesPaths.SequenceEqual(other.AssembliesPaths);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Collections.GetHashCode(AssembliesPaths);
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AssembliesCollection (");
      using (printer.IndentCookie()) {
        printer.Print("assembliesPaths = "); AssembliesPaths.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildErrorXamlPreviewState : ErrorXamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public BuildErrorXamlPreviewState(
      [NotNull] string message,
      [CanBeNull] string dump
    ) : base (
      message,
      dump
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<BuildErrorXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var message = reader.ReadString();
      var dump = ReadStringNullable(ctx, reader);
      return new BuildErrorXamlPreviewState(message, dump).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<BuildErrorXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Message);
      WriteStringNullable(ctx, writer, value.Dump);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildErrorXamlPreviewState (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("dump = "); Dump.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class ErrorXamlPreviewState : XamlPreviewState
   {
    //fields
    //public fields
    [NotNull] public string Message {get; private set;}
    [CanBeNull] public string Dump {get; private set;}
    
    //private fields
    //primary constructor
    protected ErrorXamlPreviewState(
      [NotNull] string message,
      [CanBeNull] string dump
    )
    {
      if (message == null) throw new ArgumentNullException("message");
      
      Message = message;
      Dump = dump;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ErrorXamlPreviewState> Read = Polymorphic<ErrorXamlPreviewState>.ReadAbstract(ErrorXamlPreviewState_Unknown.Read);
    
    public static new CtxWriteDelegate<ErrorXamlPreviewState> Write = Polymorphic<ErrorXamlPreviewState>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class ErrorXamlPreviewState_Unknown : ErrorXamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public ErrorXamlPreviewState_Unknown(
      [NotNull] string message,
      [CanBeNull] string dump
    ) : base (
      message,
      dump
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ErrorXamlPreviewState_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var message = reader.ReadString();
      var dump = ReadStringNullable(ctx, reader);
      return new ErrorXamlPreviewState_Unknown(message, dump).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<ErrorXamlPreviewState_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Message);
      WriteStringNullable(ctx, writer, value.Dump);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ErrorXamlPreviewState_Unknown (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("dump = "); Dump.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NoneXamlPreviewState : XamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NoneXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new NoneXamlPreviewState().WithId(_id);
    };
    
    public static new CtxWriteDelegate<NoneXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NoneXamlPreviewState (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class NotAvailableXamlPreviewState : XamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<NotAvailableXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new NotAvailableXamlPreviewState().WithId(_id);
    };
    
    public static new CtxWriteDelegate<NotAvailableXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("NotAvailableXamlPreviewState (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ReloadingMarkupXamlPreviewState : XamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<ReloadingMarkupXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new ReloadingMarkupXamlPreviewState().WithId(_id);
    };
    
    public static new CtxWriteDelegate<ReloadingMarkupXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ReloadingMarkupXamlPreviewState (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SetupErrorXamlPreviewState : ErrorXamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    public SetupErrorXamlPreviewState(
      [NotNull] string message,
      [CanBeNull] string dump
    ) : base (
      message,
      dump
     ) 
    {
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SetupErrorXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var message = reader.ReadString();
      var dump = ReadStringNullable(ctx, reader);
      return new SetupErrorXamlPreviewState(message, dump).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static new CtxWriteDelegate<SetupErrorXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Message);
      WriteStringNullable(ctx, writer, value.Dump);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SetupErrorXamlPreviewState (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("dump = "); Dump.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class SucceedXamlPreviewState : XamlPreviewState
   {
    //fields
    //public fields
    [NotNull] public List<byte> Image {get; private set;}
    public double Width {get; private set;}
    public double Height {get; private set;}
    
    //private fields
    //primary constructor
    public SucceedXamlPreviewState(
      [NotNull] List<byte> image,
      double width,
      double height
    )
    {
      if (image == null) throw new ArgumentNullException("image");
      
      Image = image;
      Width = width;
      Height = height;
    }
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<SucceedXamlPreviewState> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var image = ReadByteList(ctx, reader);
      var width = reader.ReadDouble();
      var height = reader.ReadDouble();
      return new SucceedXamlPreviewState(image, width, height).WithId(_id);
    };
    public static CtxReadDelegate<List<byte>> ReadByteList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadByte.List();
    
    public static new CtxWriteDelegate<SucceedXamlPreviewState> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      WriteByteList(ctx, writer, value.Image);
      writer.Write(value.Width);
      writer.Write(value.Height);
    };
    public static CtxWriteDelegate<List<byte>> WriteByteList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteByte.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("SucceedXamlPreviewState (");
      using (printer.IndentCookie()) {
        printer.Print("image = "); Image.PrintEx(printer); printer.Println();
        printer.Print("width = "); Width.PrintEx(printer); printer.Println();
        printer.Print("height = "); Height.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamlMarkup : IPrintable, IEquatable<XamlMarkup> {
    //fields
    //public fields
    [NotNull] public string Content {get; private set;}
    
    //private fields
    //primary constructor
    public XamlMarkup(
      [NotNull] string content
    )
    {
      if (content == null) throw new ArgumentNullException("content");
      
      Content = content;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XamlMarkup> Read = (ctx, reader) => 
    {
      var content = reader.ReadString();
      return new XamlMarkup(content);
    };
    
    public static CtxWriteDelegate<XamlMarkup> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Content);
    };
    //custom body
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((XamlMarkup) obj);
    }
    public bool Equals(XamlMarkup other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Content == other.Content;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var hash = 0;
        hash = hash * 31 + Content.GetHashCode();
        return hash;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("XamlMarkup (");
      using (printer.IndentCookie()) {
        printer.Print("content = "); Content.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamlPreviewEnvironment : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string ProjectOutputPath {get; private set;}
    [NotNull] public string ProjectOutputFileName {get; private set;}
    [CanBeNull] public string ApplicationDefinitionFile {get; private set;}
    
    //private fields
    //primary constructor
    public XamlPreviewEnvironment(
      [NotNull] string projectOutputPath,
      [NotNull] string projectOutputFileName,
      [CanBeNull] string applicationDefinitionFile
    )
    {
      if (projectOutputPath == null) throw new ArgumentNullException("projectOutputPath");
      if (projectOutputFileName == null) throw new ArgumentNullException("projectOutputFileName");
      
      ProjectOutputPath = projectOutputPath;
      ProjectOutputFileName = projectOutputFileName;
      ApplicationDefinitionFile = applicationDefinitionFile;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XamlPreviewEnvironment> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var projectOutputPath = reader.ReadString();
      var projectOutputFileName = reader.ReadString();
      var applicationDefinitionFile = ReadStringNullable(ctx, reader);
      return new XamlPreviewEnvironment(projectOutputPath, projectOutputFileName, applicationDefinitionFile).WithId(_id);
    };
    public static CtxReadDelegate<string> ReadStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.NullableClass();
    
    public static CtxWriteDelegate<XamlPreviewEnvironment> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.ProjectOutputPath);
      writer.Write(value.ProjectOutputFileName);
      WriteStringNullable(ctx, writer, value.ApplicationDefinitionFile);
    };
    public static CtxWriteDelegate<string> WriteStringNullable = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.NullableClass();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamlPreviewEnvironment (");
      using (printer.IndentCookie()) {
        printer.Print("projectOutputPath = "); ProjectOutputPath.PrintEx(printer); printer.Println();
        printer.Print("projectOutputFileName = "); ProjectOutputFileName.PrintEx(printer); printer.Println();
        printer.Print("applicationDefinitionFile = "); ApplicationDefinitionFile.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class XamlPreviewSession : RdBindableBase {
    //fields
    //public fields
    [NotNull] public string Id {get; private set;}
    [NotNull] public string PresentablePath {get; private set;}
    [NotNull] public IViewableMap<string, List<string>> NamespaceToAssembliesMap { get { return _NamespaceToAssembliesMap; }}
    [NotNull] public IRdProperty<int> NamespaceToAssembliesMapVersion { get { return _NamespaceToAssembliesMapVersion; }}
    [NotNull] public IRdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup> XamlMarkup { get { return _XamlMarkup; }}
    [NotNull] public IRdProperty<XamlPreviewState> State { get { return _State; }}
    [NotNull] public IRdProperty<bool> IsTransparencyAllowed { get { return _IsTransparencyAllowed; }}
    [NotNull] public IRdProperty<int> SamplingFactor { get { return _SamplingFactor; }}
    
    //private fields
    [NotNull] private readonly RdMap<string, List<string>> _NamespaceToAssembliesMap;
    [NotNull] private readonly RdProperty<int> _NamespaceToAssembliesMapVersion;
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup> _XamlMarkup;
    [NotNull] private readonly RdProperty<XamlPreviewState> _State;
    [NotNull] private readonly RdProperty<bool> _IsTransparencyAllowed;
    [NotNull] private readonly RdProperty<int> _SamplingFactor;
    
    //primary constructor
    private XamlPreviewSession(
      [NotNull] string id,
      [NotNull] string presentablePath,
      [NotNull] RdMap<string, List<string>> namespaceToAssembliesMap,
      [NotNull] RdProperty<int> namespaceToAssembliesMapVersion,
      [NotNull] RdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup> xamlMarkup,
      [NotNull] RdProperty<XamlPreviewState> state,
      [NotNull] RdProperty<bool> isTransparencyAllowed,
      [NotNull] RdProperty<int> samplingFactor
    )
    {
      if (id == null) throw new ArgumentNullException("id");
      if (presentablePath == null) throw new ArgumentNullException("presentablePath");
      if (namespaceToAssembliesMap == null) throw new ArgumentNullException("namespaceToAssembliesMap");
      if (namespaceToAssembliesMapVersion == null) throw new ArgumentNullException("namespaceToAssembliesMapVersion");
      if (xamlMarkup == null) throw new ArgumentNullException("xamlMarkup");
      if (state == null) throw new ArgumentNullException("state");
      if (isTransparencyAllowed == null) throw new ArgumentNullException("isTransparencyAllowed");
      if (samplingFactor == null) throw new ArgumentNullException("samplingFactor");
      
      Id = id;
      PresentablePath = presentablePath;
      _NamespaceToAssembliesMap = namespaceToAssembliesMap;
      _NamespaceToAssembliesMapVersion = namespaceToAssembliesMapVersion;
      _XamlMarkup = xamlMarkup;
      _State = state;
      _IsTransparencyAllowed = isTransparencyAllowed;
      _SamplingFactor = samplingFactor;
      _NamespaceToAssembliesMap.OptimizeNested = true;
      _NamespaceToAssembliesMapVersion.OptimizeNested = true;
      _XamlMarkup.OptimizeNested = true;
      _IsTransparencyAllowed.OptimizeNested = true;
      _SamplingFactor.OptimizeNested = true;
      BindableChildren.Add(new KeyValuePair<string, object>("namespaceToAssembliesMap", _NamespaceToAssembliesMap));
      BindableChildren.Add(new KeyValuePair<string, object>("namespaceToAssembliesMapVersion", _NamespaceToAssembliesMapVersion));
      BindableChildren.Add(new KeyValuePair<string, object>("xamlMarkup", _XamlMarkup));
      BindableChildren.Add(new KeyValuePair<string, object>("state", _State));
      BindableChildren.Add(new KeyValuePair<string, object>("isTransparencyAllowed", _IsTransparencyAllowed));
      BindableChildren.Add(new KeyValuePair<string, object>("samplingFactor", _SamplingFactor));
    }
    //secondary constructor
    public XamlPreviewSession (
      [NotNull] string id,
      [NotNull] string presentablePath
    ) : this (
      id,
      presentablePath,
      new RdMap<string, List<string>>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ReadStringList, WriteStringList),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt),
      new RdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup>(JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup.Read, JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup.Write),
      new RdProperty<XamlPreviewState>(XamlPreviewState.Read, XamlPreviewState.Write),
      new RdProperty<bool>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool),
      new RdProperty<int>(JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt)
    ) {}
    //statics
    
    public static CtxReadDelegate<XamlPreviewSession> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      var id = reader.ReadString();
      var presentablePath = reader.ReadString();
      var namespaceToAssembliesMap = RdMap<string, List<string>>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadString, JetBrains.Platform.RdFramework.Impl.Serializers.WriteString, ReadStringList, WriteStringList);
      var namespaceToAssembliesMapVersion = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      var xamlMarkup = RdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup>.Read(ctx, reader, JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup.Read, JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup.Write);
      var state = RdProperty<XamlPreviewState>.Read(ctx, reader, XamlPreviewState.Read, XamlPreviewState.Write);
      var isTransparencyAllowed = RdProperty<bool>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadBool, JetBrains.Platform.RdFramework.Impl.Serializers.WriteBool);
      var samplingFactor = RdProperty<int>.Read(ctx, reader, JetBrains.Platform.RdFramework.Impl.Serializers.ReadInt, JetBrains.Platform.RdFramework.Impl.Serializers.WriteInt);
      return new XamlPreviewSession(id, presentablePath, namespaceToAssembliesMap, namespaceToAssembliesMapVersion, xamlMarkup, state, isTransparencyAllowed, samplingFactor).WithId(_id);
    };
    public static CtxReadDelegate<List<string>> ReadStringList = JetBrains.Platform.RdFramework.Impl.Serializers.ReadString.List();
    
    public static CtxWriteDelegate<XamlPreviewSession> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
      writer.Write(value.Id);
      writer.Write(value.PresentablePath);
      RdMap<string, List<string>>.Write(ctx, writer, value._NamespaceToAssembliesMap);
      RdProperty<int>.Write(ctx, writer, value._NamespaceToAssembliesMapVersion);
      RdProperty<JetBrains.Rider.Model.Xaml.Renderer.XamlMarkup>.Write(ctx, writer, value._XamlMarkup);
      RdProperty<XamlPreviewState>.Write(ctx, writer, value._State);
      RdProperty<bool>.Write(ctx, writer, value._IsTransparencyAllowed);
      RdProperty<int>.Write(ctx, writer, value._SamplingFactor);
    };
    public static CtxWriteDelegate<List<string>> WriteStringList = JetBrains.Platform.RdFramework.Impl.Serializers.WriteString.List();
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamlPreviewSession (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
        printer.Print("presentablePath = "); PresentablePath.PrintEx(printer); printer.Println();
        printer.Print("namespaceToAssembliesMap = "); _NamespaceToAssembliesMap.PrintEx(printer); printer.Println();
        printer.Print("namespaceToAssembliesMapVersion = "); _NamespaceToAssembliesMapVersion.PrintEx(printer); printer.Println();
        printer.Print("xamlMarkup = "); _XamlMarkup.PrintEx(printer); printer.Println();
        printer.Print("state = "); _State.PrintEx(printer); printer.Println();
        printer.Print("isTransparencyAllowed = "); _IsTransparencyAllowed.PrintEx(printer); printer.Println();
        printer.Print("samplingFactor = "); _SamplingFactor.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class XamlPreviewState : RdBindableBase {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<XamlPreviewState> Read = Polymorphic<XamlPreviewState>.ReadAbstract(XamlPreviewState_Unknown.Read);
    
    public static CtxWriteDelegate<XamlPreviewState> Write = Polymorphic<XamlPreviewState>.Write;
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class XamlPreviewState_Unknown : XamlPreviewState
   {
    //fields
    //public fields
    //private fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static new CtxReadDelegate<XamlPreviewState_Unknown> Read = (ctx, reader) => 
    {
      var _id = RdId.Read(reader);
      return new XamlPreviewState_Unknown().WithId(_id);
    };
    
    public static new CtxWriteDelegate<XamlPreviewState_Unknown> Write = (ctx, writer, value) => 
    {
      value.RdId.Write(writer);
    };
    //custom body
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("XamlPreviewState_Unknown (");
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
