/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.filters.Filter;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import icons.AngularJSIcons;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.angular2.cli.AngularCLIFilter;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.AngularJSProjectConfigurator;
import org.angular2.cli.Option;
import org.angular2.cli.SchematicOptionsTextField;
import org.angular2.cli.SchematicsLoader;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCLIProjectGenerator
extends NpmPackageProjectGenerator {
    public static final String PACKAGE_NAME = "@angular/cli";
    private static final Logger LOG = Logger.getInstance(AngularCLIProjectGenerator.class);
    private static final Pattern NPX_PACKAGE_PATTERN = Pattern.compile("npx --package @angular/cli(?:@([0-9]+\\.[0-9]+\\.[0-9a-zA-Z-.]+))? ng");
    private static final Pattern VALID_NG_APP_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*(-[a-zA-Z][0-9a-zA-Z]*)*");

    @Nls
    @NotNull
    public String getName() {
        if ("Angular CLI" == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(0);
        }
        return "Angular CLI";
    }

    @NotNull
    public String getDescription() {
        if ("The Angular CLI makes it easy to create an application that already works, right out of the box. It already follows our best practices!" == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(1);
        }
        return "The Angular CLI makes it easy to create an application that already works, right out of the box. It already follows our best practices!";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AngularJSIcons.Angular2;
        if (icon == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(3);
        }
        if (entry != null) {
            AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
        }
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(5);
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(9);
        }
        AngularCLIProjectSettings ngSettings = (AngularCLIProjectSettings)settings;
        ArrayList<String> result = new ArrayList<String>();
        result.add("new");
        result.add(baseDir.getName());
        CommandLineTokenizer tokenizer = new CommandLineTokenizer(ngSettings.myOptions);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        if (AngularCLIProjectGenerator.isPackageGreaterOrEqual(settings.myPackage, 7, 0, 0) && !result.contains("--defaults")) {
            result.add("--defaults");
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static boolean isPackageGreaterOrEqual(NodePackage pkg, int major, int minor, int patch) {
        SemVer ver = null;
        if (pkg.getName().equals(PACKAGE_NAME)) {
            ver = pkg.getVersion();
        } else {
            Matcher m = NPX_PACKAGE_PATTERN.matcher(pkg.getSystemIndependentPath());
            if (m.matches()) {
                ver = SemVer.parseFromText((String)m.group(1));
            }
        }
        return ver == null || ver.isGreaterOrEqualThan(major, minor, patch);
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(11);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(12);
        }
        Filter[] filterArray = new Filter[]{new AngularCLIFilter(project, baseDir.getParent().getPath())};
        if (filterArray == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(13);
        }
        return filterArray;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(14);
        }
        String string = AngularCLIProjectGenerator.ng(pkg.getSystemDependentPath());
        if (string == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String ng(String path) {
        String string = path + File.separator + "bin" + File.separator + "ng";
        if (string == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    protected String packageName() {
        if (PACKAGE_NAME == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(17);
        }
        return PACKAGE_NAME;
    }

    @NotNull
    protected String presentablePackageName() {
        if ("Angular &CLI:" == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(18);
        }
        return "Angular &CLI:";
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.singletonList(new NpxPackageDescriptor.NpxCommand(PACKAGE_NAME, "ng"));
        if (list == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(19);
        }
        return list;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(20);
        }
        return Optional.ofNullable(AngularCLIProjectGenerator.validateFolderName(path, "Project")).orElseGet(() -> {
            if (path == null) {
                AngularCLIProjectGenerator.$$$reportNull$$$0(31);
            }
            return super.validateProjectPath(path);
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        AngularCLIProjectGeneratorPeer angularCLIProjectGeneratorPeer = new AngularCLIProjectGeneratorPeer();
        if (angularCLIProjectGeneratorPeer == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(21);
        }
        return angularCLIProjectGeneratorPeer;
    }

    @NotNull
    protected File workingDir(NpmPackageProjectGenerator.Settings settings, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(22);
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir).getParentFile();
        if (file == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(23);
        }
        return file;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(24);
        }
        if (baseDir == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(25);
        }
        Runnable runnable = () -> {
            if (project == null) {
                AngularCLIProjectGenerator.$$$reportNull$$$0(27);
            }
            if (baseDir == null) {
                AngularCLIProjectGenerator.$$$reportNull$$$0(28);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (project == null) {
                    AngularCLIProjectGenerator.$$$reportNull$$$0(29);
                }
                if (baseDir == null) {
                    AngularCLIProjectGenerator.$$$reportNull$$$0(30);
                }
                super.postInstall(project, baseDir, workingDir).run();
                AngularCliUtil.createRunConfigurations(project, baseDir);
            });
        };
        if (runnable == null) {
            AngularCLIProjectGenerator.$$$reportNull$$$0(26);
        }
        return runnable;
    }

    @Nullable
    private static String validateFolderName(String path, String label) {
        String fileName = PathUtil.getFileName((String)path);
        if (!VALID_NG_APP_NAME.matcher(fileName).matches()) {
            return XmlStringUtil.wrapInHtml((CharSequence)(label + " name '" + fileName + "' is not valid. " + label + " name must start with a letter, and must contain only alphanumeric characters or dashes. When adding a dash the segment after the dash must also start with a letter."));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/cli/AngularCLIProjectGenerator";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 22: 
            case 25: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/cli/AngularCLIProjectGenerator";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "ng";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postInstall$2";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$validateProjectPath$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AngularCLIProjectSettings
    extends NpmPackageProjectGenerator.Settings {
        @NotNull
        public final String myOptions;

        AngularCLIProjectSettings(@NotNull NpmPackageProjectGenerator.Settings settings, @NotNull String options) {
            if (settings == null) {
                AngularCLIProjectSettings.$$$reportNull$$$0(0);
            }
            if (options == null) {
                AngularCLIProjectSettings.$$$reportNull$$$0(1);
            }
            super(settings.myInterpreterRef, settings.myPackage);
            this.myOptions = options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "options";
                    break;
                }
            }
            objectArray[1] = "org/angular2/cli/AngularCLIProjectGenerator$AngularCLIProjectSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AngularCLIProjectGeneratorPeer
    extends NpmPackageProjectGenerator.NpmPackageGeneratorPeer {
        private TextAccessor myContentRoot;
        private SchematicOptionsTextField myOptionsTextField;

        private AngularCLIProjectGeneratorPeer() {
            super((NpmPackageProjectGenerator)AngularCLIProjectGenerator.this);
        }

        protected JPanel createPanel() {
            JPanel panel = super.createPanel();
            ComboBox schematicsCollectionCombo = new ComboBox((Object[])new String[]{"default", "@ngrx/schematics"});
            LabeledComponent component = LabeledComponent.create((JComponent)schematicsCollectionCombo, (String)"Schematics collection:");
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            this.myOptionsTextField = new SchematicOptionsTextField(ProjectManager.getInstance().getDefaultProject(), Collections.emptyList());
            this.myOptionsTextField.setEnabled(true);
            this.myOptionsTextField.setVariants(Collections.singletonList(new Option("test")));
            component = LabeledComponent.create((JComponent)((Object)this.myOptionsTextField), (String)"Additional parameters:");
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            return panel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            if (settingsStep == null) {
                AngularCLIProjectGeneratorPeer.$$$reportNull$$$0(0);
            }
            super.buildUI(settingsStep);
            final ModuleNameLocationSettings field = settingsStep.getModuleNameLocationSettings();
            if (field != null) {
                this.myContentRoot = new TextAccessor(){

                    public void setText(@NotNull String text) {
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        field.setModuleContentRoot(text);
                    }

                    @NotNull
                    public String getText() {
                        String string = field.getModuleContentRoot();
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/angular2/cli/AngularCLIProjectGenerator$AngularCLIProjectGeneratorPeer$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/angular2/cli/AngularCLIProjectGenerator$AngularCLIProjectGeneratorPeer$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "setText";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
            ((GistManagerImpl)GistManager.getInstance()).invalidateData();
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Additional parameters:"), (JComponent)((Object)this.myOptionsTextField));
            this.getPackageField().addSelectionListener(this::nodePackageChanged);
            this.nodePackageChanged(this.getPackageField().getSelected());
        }

        @NotNull
        public NpmPackageProjectGenerator.Settings getSettings() {
            AngularCLIProjectSettings angularCLIProjectSettings = new AngularCLIProjectSettings(super.getSettings(), this.myOptionsTextField.getText());
            if (angularCLIProjectSettings == null) {
                AngularCLIProjectGeneratorPeer.$$$reportNull$$$0(1);
            }
            return angularCLIProjectSettings;
        }

        @Nullable
        public ValidationInfo validate() {
            String message;
            ValidationInfo info = super.validate();
            if (info != null) {
                return info;
            }
            if (this.myContentRoot != null && (message = AngularCLIProjectGenerator.validateFolderName(this.myContentRoot.getText(), "Content root folder")) != null) {
                return new ValidationInfo(message);
            }
            return null;
        }

        private void nodePackageChanged(NodePackage nodePackage) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                VirtualFile localFile;
                List options = Collections.emptyList();
                if (nodePackage.getSystemIndependentPath().endsWith("/node_modules/@angular/cli") && (localFile = StandardFileSystems.local().findFileByPath(nodePackage.getSystemDependentPath())) != null) {
                    localFile = localFile.getParent().getParent().getParent();
                    try {
                        options = SchematicsLoader.INSTANCE.load(ProjectManager.getInstance().getDefaultProject(), localFile, true, false).stream().filter(s -> "ng-new".equals(s.getName())).findFirst().map(schematic -> {
                            ArrayList list = ContainerUtil.newArrayList(schematic.getOptions());
                            list.add(this.createOption("verbose", "Boolean", false, "Adds more details to output logging."));
                            list.add(this.createOption("collection", "String", null, "Schematics collection to use"));
                            Collections.sort(list, Comparator.comparing(Option::getName));
                            return list;
                        }).orElse(Collections.emptyList());
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load schematics", (Throwable)e);
                    }
                }
                this.myOptionsTextField.setVariants(options);
            });
        }

        private Option createOption(String name, String type, Object defaultVal, String description) {
            Option res = new Option(name);
            res.setType(type);
            res.setDefault(defaultVal);
            res.setDescription(description);
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsStep";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/cli/AngularCLIProjectGenerator$AngularCLIProjectGeneratorPeer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/cli/AngularCLIProjectGenerator$AngularCLIProjectGeneratorPeer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUI";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

