/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliSchematicsRegistryServiceImpl
extends AngularCliSchematicsRegistryService {
    private static final String USER_AGENT = "JetBrains IDE";
    private static final String NG_PACKAGES_URL = "https://raw.githubusercontent.com/JetBrains/intellij-plugins/master/AngularJS/resources/org/angularjs/cli/ng-packages.json";
    private static final Logger LOG = Logger.getInstance(AngularCliSchematicsRegistryServiceImpl.class);
    private static final int CACHE_EXPIRY = 1500000;
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Angular CLI Schematics Registry Pool", (int)5);
    private final CachedValue<List<NodePackageBasicInfo>> myNgAddPackages = new CachedValue<List>(AngularCliSchematicsRegistryServiceImpl::fetchPackagesSupportingNgAdd);
    private final Map<String, Pair<Boolean, Long>> myLocalNgAddPackages = ContainerUtil.newConcurrentMap();
    private final Map<String, CachedValue<Boolean>> myNgAddSupportedCache = ContainerUtil.newConcurrentMap();

    @Override
    @NotNull
    public List<NodePackageBasicInfo> getPackagesSupportingNgAdd(long timeout) {
        List list = ContainerUtil.notNullize(this.myNgAddPackages.getValue(timeout));
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, long timeout) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        return this.getPackagesSupportingNgAdd(timeout).stream().anyMatch(pkg -> {
            if (packageName == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(22);
            }
            return packageName.equals(pkg.getName());
        });
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, @NotNull String versionOrRange, long timeout) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        if (versionOrRange == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        return this.supportsNgAdd(packageName, timeout) && Boolean.TRUE.equals(this.myNgAddSupportedCache.computeIfAbsent(AngularCliSchematicsRegistryServiceImpl.getKey(packageName, versionOrRange), k -> {
            if (packageName == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(18);
            }
            if (versionOrRange == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(19);
            }
            return new CachedValue<Boolean>(() -> {
                if (packageName == null) {
                    AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(20);
                }
                if (versionOrRange == null) {
                    AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(21);
                }
                return AngularCliSchematicsRegistryServiceImpl.checkForNgAddSupport(packageName, versionOrRange);
            });
        }).getValue(timeout));
    }

    @Override
    public boolean supportsNgAdd(@NotNull InstalledPackageVersion version) {
        if (version == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(4);
        }
        try {
            if (version.getPackageJson() != null) {
                return (Boolean)this.myLocalNgAddPackages.compute(version.getPackageJson().getPath(), (key, curValue) -> {
                    if (version == null) {
                        AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(17);
                    }
                    if (curValue != null && version.getPackageJson().getModificationStamp() == ((Long)curValue.getSecond()).longValue()) {
                        return curValue;
                    }
                    try {
                        File schematicsCollection = AngularCliSchematicsRegistryServiceImpl.getSchematicsCollection(new File(version.getPackageJson().getPath()));
                        return Pair.create((Object)(schematicsCollection != null && AngularCliSchematicsRegistryServiceImpl.hasNgAddSchematic(schematicsCollection) ? 1 : 0), (Object)version.getPackageJson().getModificationStamp());
                    }
                    catch (IOException e) {
                        return Pair.create((Object)false, (Object)version.getPackageJson().getModificationStamp());
                    }
                }).getFirst();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to retrieve schematics info for " + version.getPackageDir().getName(), (Throwable)e);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<NodePackageBasicInfo> fetchPackagesSupportingNgAdd() {
        List<NodePackageBasicInfo> list;
        try {
            RequestBuilder builder = HttpRequests.request((String)NG_PACKAGES_URL);
            builder.userAgent(USER_AGENT);
            builder.gzip(true);
            list = AngularCliSchematicsRegistryServiceImpl.readNgAddPackages(builder.readString(null));
        }
        catch (IOException e) {
            List<NodePackageBasicInfo> list2;
            Throwable throwable;
            InputStream is;
            block19: {
                block20: {
                    LOG.info("Failed to load current list of ng-add compatible packages.", (Throwable)e);
                    is = AngularCliSchematicsRegistryServiceImpl.class.getResourceAsStream("ng-packages.json");
                    throwable = null;
                    list2 = AngularCliSchematicsRegistryServiceImpl.readNgAddPackages(FileUtil.loadTextAndClose((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)));
                    if (is == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                is.close();
            }
            List<NodePackageBasicInfo> list3 = list2;
            if (list3 == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(6);
            }
            return list3;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e1) {
                        LOG.error("Failed to load list of ng-add compatible packages from static file.", (Throwable)e1);
                        List<NodePackageBasicInfo> list4 = Collections.emptyList();
                        if (list4 == null) {
                            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(7);
                        }
                        return list4;
                    }
                }
            }
        }
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> readNgAddPackages(@NotNull String content) {
        if (content == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(8);
        }
        JsonObject contents = (JsonObject)new JsonParser().parse(content);
        List<NodePackageBasicInfo> list = Collections.unmodifiableList(ContainerUtil.map((Collection)contents.get("ng-add").getAsJsonObject().entrySet(), e -> new NodePackageBasicInfo((String)e.getKey(), ((JsonElement)e.getValue()).getAsString())));
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static File getSchematicsCollection(@NotNull File packageJson) throws IOException {
        if (packageJson == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        try (JsonReader reader = new JsonReader((Reader)new FileReader(packageJson));){
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals("schematics")) {
                    String path = reader.nextString();
                    File file = Paths.get(packageJson.getParent(), path).normalize().toAbsolutePath().toFile();
                    return file;
                }
                reader.skipValue();
            }
            File file = null;
            return file;
        }
    }

    private static boolean hasNgAddSchematic(@NotNull File schematicsCollection) throws IOException {
        if (schematicsCollection == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(11);
        }
        try (JsonReader reader = new JsonReader((Reader)new FileReader(schematicsCollection));){
            boolean bl = AngularCliSchematicsRegistryServiceImpl.hasNgAddSchematic(reader);
            return bl;
        }
    }

    public static boolean hasNgAddSchematic(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        reader.setLenient(true);
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("schematics".equals(key)) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String schematicName = reader.nextName();
                    if (schematicName.equals("ng-add")) {
                        return true;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return false;
    }

    private static boolean checkForNgAddSupport(@NotNull String packageName, @NotNull String versionOrRange) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        if (versionOrRange == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(14);
        }
        try {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            JsonObject pkgJson = NpmRegistryService.getInstance().fetchPackageJson(packageName, versionOrRange, indicator);
            return pkgJson != null && pkgJson.get("schematics") != null;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static String getKey(@NotNull String packageName, @NotNull String version) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        if (version == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        return packageName + "@" + version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/cli/AngularCliSchematicsRegistryServiceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOrRange";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schematicsCollection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesSupportingNgAdd";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/cli/AngularCliSchematicsRegistryServiceImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchPackagesSupportingNgAdd";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readNgAddPackages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsNgAdd";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readNgAddPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSchematicsCollection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasNgAddSchematic";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkForNgAddSupport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$supportsNgAdd$3";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$supportsNgAdd$2";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$supportsNgAdd$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedValue<T> {
        private long myUpdateTime;
        private Future<T> myCacheComputation;
        private T myCachedValue;
        private final Callable<T> myValueSupplier;

        CachedValue(Callable<T> valueSupplier) {
            this.myValueSupplier = valueSupplier;
        }

        protected synchronized boolean isCacheExpired() {
            return this.myUpdateTime + 1500000L <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public T getValue(long timeout) {
            Future<T> cacheComputation;
            CachedValue cachedValue = this;
            synchronized (cachedValue) {
                if (this.myCachedValue != null && !this.isCacheExpired()) {
                    return this.myCachedValue;
                }
                if (this.myCacheComputation == null) {
                    this.myCachedValue = null;
                    this.myCacheComputation = ourExecutorService.submit(this.myValueSupplier);
                }
                cacheComputation = this.myCacheComputation;
            }
            Object result = JSLanguageServiceUtil.awaitFuture(cacheComputation, (long)timeout, (long)10L, null, (boolean)false, null);
            CachedValue cachedValue2 = this;
            synchronized (cachedValue2) {
                if (this.myCacheComputation != null && this.myCacheComputation.isDone()) {
                    try {
                        this.myCachedValue = this.myCacheComputation.get();
                        result = this.myCachedValue;
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    this.myCacheComputation = null;
                    this.myUpdateTime = System.currentTimeMillis();
                }
            }
            return (T)result;
        }
    }
}

