/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.angular2.cli.BlueprintParser;
import org.angular2.cli.Schematic;
import org.angular2.cli.SchematicsExternalizer;
import org.angular2.cli.SchematicsJsonParser;
import org.angular2.cli.SchematicsLoaderKt;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"(\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"(\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"DEFAULT_OUTPUT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "myLogErrors", "Ljava/lang/ThreadLocal;", "", "ourGist", "Lcom/intellij/util/gist/VirtualFileGist;", "", "Lorg/angular2/cli/Schematic;", "kotlin.jvm.PlatformType", "ourGistHiddenList", "doLoad", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeHidden", "grabCommandOutput", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "workingDir", "loadBlueprintHelpOutput", "node", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "loadSchematicsInfoJson", "shortenOutput", "output", "intellij.angularJS"})
public final class SchematicsLoaderKt {
    private static ThreadLocal<Boolean> myLogErrors;
    private static VirtualFileGist<List<Schematic>> ourGist;
    private static VirtualFileGist<List<Schematic>> ourGistHiddenList;
    private static final Logger LOG;
    @NotNull
    public static final String DEFAULT_OUTPUT = "\n\n  Available blueprints:\n    class <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    component <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --inline-template (Boolean) Specifies if the template will be in the ts file.\n        aliases: -it, --inlineTemplate\n      --inline-style (Boolean) Specifies if the style will be in the ts file.\n        aliases: -is, --inlineStyle\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --view-encapsulation (String) Specifies the view encapsulation strategy.\n        aliases: -ve <value>, --viewEncapsulation <value>\n      --change-detection (String) Specifies the change detection strategy.\n        aliases: -cd <value>, --changeDetection <value>\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    directive <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    enum <name> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    guard <name> <options...>\n      --flat (Boolean) Indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n    interface <interface-type> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    module <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --routing (Boolean) (Default: false) Specifies if a routing module file should be generated.\n        aliases: --routing\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    pipe <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the pipe.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    service <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n\nng generate <blueprint> <options...>\n  Generates new code from blueprints.\n  aliases: g\n  --dry-run (Boolean) (Default: false) Run through without making any changes.\n    aliases: -d, --dryRun\n  --verbose (Boolean) (Default: false) Adds more details to output logging.\n    aliases: -v, --verbose\n\n    ";

    private static final List<Schematic> doLoad(Project project, VirtualFile cli, boolean includeHidden) {
        String blueprintHelpOutput;
        Object object;
        NodeJsLocalInterpreter node;
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter interpreter = nodeJsInterpreterManager.getInterpreter();
        NodeJsLocalInterpreter nodeJsLocalInterpreter = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (nodeJsLocalInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter2 = node = nodeJsLocalInterpreter;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsLocalInterpreter2, (String)"node");
        if (!nodeJsLocalInterpreter2.isValid()) {
            return CollectionsKt.emptyList();
        }
        Collection<Schematic> parse = CollectionsKt.emptyList();
        String schematicsInfoJson = SchematicsLoaderKt.loadSchematicsInfoJson(node, cli, includeHidden);
        CharSequence charSequence = schematicsInfoJson;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((String)schematicsInfoJson, (String)"No schematics", (boolean)false, (int)2, null)) {
            try {
                List<Schematic> list = SchematicsJsonParser.parse(schematicsInfoJson);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"SchematicsJsonParser.parse(schematicsInfoJson)");
                parse = (Collection<Schematic>)list;
            }
            catch (Exception e) {
                LOG.error("Failed to parse schematics: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", schematicsInfoJson)});
            }
        }
        if (parse.isEmpty() && (object = (CharSequence)(blueprintHelpOutput = SchematicsLoaderKt.loadBlueprintHelpOutput(node, cli))).length() > 0) {
            try {
                parse = new BlueprintParser().parse(blueprintHelpOutput);
            }
            catch (Exception e) {
                LOG.error("Failed to parse blueprints: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", blueprintHelpOutput)});
            }
        }
        if (parse.isEmpty()) {
            parse = new BlueprintParser().parse(DEFAULT_OUTPUT);
        }
        Iterable $receiver$iv = parse;
        object = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                Schematic it = (Schematic)a;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Schematic)b;
                Comparable comparable2 = comparable;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator);
    }

    @NotNull
    public static final String loadSchematicsInfoJson(@NotNull NodeJsLocalInterpreter node, @NotNull VirtualFile cli, boolean includeHidden) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)cli, (String)"cli");
        File directory = JSLanguageServiceUtil.getPluginDirectory(AngularJSLanguage.class, (String)"ngCli");
        String utilityExe = directory + File.separator + "runner.js";
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), utilityExe, cli.getPath(), "./schematicsInfoProvider.js"});
        if (includeHidden) {
            commandLine.addParameter("--includeHidden");
        }
        return SchematicsLoaderKt.grabCommandOutput(commandLine, cli.getPath());
    }

    @NotNull
    public static final String loadBlueprintHelpOutput(@NotNull NodeJsLocalInterpreter node, @NotNull VirtualFile cli) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)cli, (String)"cli");
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)((NodeJsInterpreter)node));
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return "";
        }
        CompletionModuleInfo module = completionModuleInfo;
        StringBuilder stringBuilder = new StringBuilder();
        VirtualFile virtualFile = module.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"module.virtualFile!!");
        String moduleExe = stringBuilder.append(virtualFile.getPath()).append(File.separator).append("bin").append(File.separator).append("ng").toString();
        return SchematicsLoaderKt.grabCommandOutput(new GeneralCommandLine(new String[]{node.getInterpreterSystemDependentPath(), moduleExe, "help", "generate"}), cli.getPath());
    }

    @NotNull
    public static final String grabCommandOutput(@NotNull GeneralCommandLine commandLine, @Nullable String workingDir) {
        ProcessOutput output;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = output = handler.runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"output");
        if (processOutput.getExitCode() == 0) {
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            CharSequence charSequence = string;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (charSequence.length() > 0) {
                Boolean bl = myLogErrors.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"myLogErrors.get()");
                if (bl.booleanValue()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
                    String string3 = output.getStderr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output.stderr");
                    LOG.error(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string3)).toString(), new Attachment[]{new Attachment("err-output", output.getStderr())});
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
                    String string4 = output.getStderr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"output.stderr");
                    LOG.info(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string4)).toString());
                }
            }
            String string5 = output.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"output.stdout");
            return string5;
        }
        Boolean bl = myLogErrors.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"myLogErrors.get()");
        if (bl.booleanValue()) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to load schematics info.\n");
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            LOG.error(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string)).toString(), new Attachment[]{new Attachment("err-output", output.getStderr()), new Attachment("std-output", output.getStdout())});
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            LOG.info(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string)).toString());
        }
        return "";
    }

    @NotNull
    public static final String shortenOutput(@NotNull String output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        CharSequence charSequence = StringsKt.replace$default((String)output, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        String string = "(/[^()/:]+)+(/[^()/:]+)(/[^()/:]+)";
        string = new Regex(string);
        String string2 = "/...$1$2$3";
        String string3 = StringUtil.shortenTextWithEllipsis((String)string.replace(charSequence, string2), (int)750, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringUtil.shortenTextWi\u2026/...$1$2$3\"),\n    750, 0)");
        return string3;
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(myLogErrors.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"ThreadLocal.withInitial{true}");
        myLogErrors = threadLocal;
        ourGist = GistManager.getInstance().newVirtualFileGist("AngularBlueprints", 3, (DataExternalizer)new SchematicsExternalizer(), (VirtualFileGist.GistCalculator)ourGist.1.INSTANCE);
        ourGistHiddenList = GistManager.getInstance().newVirtualFileGist("AngularSchematicsHidden", 3, (DataExternalizer)new SchematicsExternalizer(), (VirtualFileGist.GistCalculator)ourGistHiddenList.1.INSTANCE);
        Logger logger = Logger.getInstance((String)"#org.angular2.cli.SchematicsLoader");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#org\u2026r2.cli.SchematicsLoader\")");
        LOG = logger;
    }

    @NotNull
    public static final /* synthetic */ ThreadLocal access$getMyLogErrors$p() {
        return myLogErrors;
    }

    public static final /* synthetic */ void access$setMyLogErrors$p(@NotNull ThreadLocal threadLocal) {
        myLogErrors = threadLocal;
    }

    @NotNull
    public static final /* synthetic */ VirtualFileGist access$getOurGistHiddenList$p() {
        return ourGistHiddenList;
    }

    public static final /* synthetic */ void access$setOurGistHiddenList$p(@NotNull VirtualFileGist virtualFileGist) {
        ourGistHiddenList = virtualFileGist;
    }

    @NotNull
    public static final /* synthetic */ VirtualFileGist access$getOurGist$p() {
        return ourGist;
    }

    public static final /* synthetic */ void access$setOurGist$p(@NotNull VirtualFileGist virtualFileGist) {
        ourGist = virtualFileGist;
    }

    @NotNull
    public static final /* synthetic */ List access$doLoad(@NotNull Project project, @NotNull VirtualFile cli, boolean includeHidden) {
        return SchematicsLoaderKt.doLoad(project, cli, includeHidden);
    }
}

