/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli.actions;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.angular2.cli.AngularCLIFilter;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliAddDependencyAction
extends DumbAwareAction {
    private static final NodePackageBasicInfo OTHER = new NodePackageBasicInfo("Install package not listed above\u2026", null);
    private static final Logger LOG = Logger.getInstance(AngularCliAddDependencyAction.class);
    private static final long TIMEOUT = 2000L;

    public static void runAndShowConsoleLater(@NotNull Project project, @NotNull VirtualFile cli, @NotNull String packageName, @Nullable String packageVersion, boolean proposeLatestVersionIfNeeded) {
        if (project == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(0);
        }
        if (cli == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                AngularCliAddDependencyAction.$$$reportNull$$$0(16);
            }
            if (packageName == null) {
                AngularCliAddDependencyAction.$$$reportNull$$$0(17);
            }
            if (cli == null) {
                AngularCliAddDependencyAction.$$$reportNull$$$0(18);
            }
            if (project.isDisposed()) {
                return;
            }
            Ref version = new Ref((Object)StringUtil.defaultIfEmpty((String)packageVersion, (String)"latest"));
            boolean proposeLatestVersion = proposeLatestVersionIfNeeded && !AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(packageName, (String)version.get(), 2000L);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    AngularCliAddDependencyAction.$$$reportNull$$$0(19);
                }
                if (cli == null) {
                    AngularCliAddDependencyAction.$$$reportNull$$$0(20);
                }
                if (packageName == null) {
                    AngularCliAddDependencyAction.$$$reportNull$$$0(21);
                }
                if (proposeLatestVersion) {
                    switch (Messages.showDialog((Project)project, (String)"It looks like specified version of package doesn't support 'ng add'.\n\nWould you like to install the latest version of the package?", (String)"Install with 'ng add'", (String[])new String[]{"Install latest version", "Try with current version", Messages.CANCEL_BUTTON}, (int)0, (Icon)Messages.getQuestionIcon())) {
                        case 0: {
                            version.set((Object)"latest");
                            break;
                        }
                        case 1: {
                            version.set((Object)packageVersion);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                AngularCliAddDependencyAction.runAndShowConsole(project, cli, packageName + "@" + (String)version.get(), !proposeLatestVersion);
            }, project.getDisposed());
        });
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile cli = AngularCliUtil.findAngularCliFolder(project, file);
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)cli);
        if (cli == null || packageJson == null) {
            return;
        }
        if (!AngularCliUtil.hasAngularCLIPackageInstalled(project, cli)) {
            AngularCliUtil.notifyAngularCliNotInstalled(project, cli, "Can't add new Angular dependency");
            return;
        }
        Set existingPackages = PackageJsonUtil.getOrCreateData((VirtualFile)packageJson).getAllDependencies();
        SortedListModel model2 = new SortedListModel(Comparator.comparing(p -> p == OTHER ? 1 : 0).thenComparing(NodePackageBasicInfo::getName));
        final JBList list = new JBList((ListModel)model2);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<NodePackageBasicInfo>(){

            protected void customizeCellRenderer(@NotNull JList<? extends NodePackageBasicInfo> list, NodePackageBasicInfo value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!selected && index % 2 == 0) {
                    this.setBackground(UIUtil.getDecoratedRowColor());
                }
                this.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)5)));
                this.append(value.getName(), value != OTHER ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.LINK_ATTRIBUTES, true);
                if (value.getDescription() != null) {
                    this.append(" - " + value.getDescription(), SimpleTextAttributes.GRAY_ATTRIBUTES, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/angular2/cli/actions/AngularCliAddDependencyAction$1", "customizeCellRenderer"));
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)list);
        scroll.setBorder((Border)JBUI.Borders.empty());
        JComponent pane = ListWithFilter.wrap((JList)list, (JScrollPane)scroll, NodePackageBasicInfo::getName);
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(pane, (JComponent)list).setMayBeParent(true).setRequestFocus(true).setFocusable(true).setFocusOwners(new Component[]{list}).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setMovable(true).setResizable(true).setCancelOnWindowDeactivation(false).setTitle("Install with 'ng add'").setCancelOnClickOutside(true).setDimensionServiceKey(project, "org.angular.cli.generate", true).setMinSize(new Dimension(JBUI.scale((int)350), JBUI.scale((int)300))).setCancelButton(new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        JBPopup popup = builder.createPopup();
        final Consumer<NodePackageBasicInfo> action = pkgInfo -> {
            popup.closeOk(null);
            if (pkgInfo == OTHER) {
                AngularCliAddDependencyAction.chooseCustomPackageAndInstall(project, cli, existingPackages);
            } else {
                AngularCliAddDependencyAction.runAndShowConsole(project, cli, pkgInfo.getName(), false);
            }
        };
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (list.getSelectedValue() == null) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    e.consume();
                    action.accept(list.getSelectedValue());
                }
            }
        });
        new DoubleClickListener(){

            public boolean onDoubleClick(MouseEvent event) {
                if (list.getSelectedValue() == null) {
                    return true;
                }
                action.accept(list.getSelectedValue());
                return true;
            }
        }.installOn((Component)list);
        popup.showCenteredInCurrentWindow(project);
        AngularCliAddDependencyAction.updateListAsync((JBList<NodePackageBasicInfo>)list, (SortedListModel<NodePackageBasicInfo>)model2, popup, existingPackages);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        e.getPresentation().setEnabledAndVisible(project != null && AngularCliUtil.findAngularCliFolder(project, file) != null);
    }

    private static void runAndShowConsole(final @NotNull Project project, final @NotNull VirtualFile cli, final @NotNull String packageSpec, boolean proposeLatestVersionIfNeeded) {
        if (project == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(5);
        }
        if (cli == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(6);
        }
        if (packageSpec == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(7);
        }
        if (project.isDisposed()) {
            return;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        NodeJsLocalInterpreter node = NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter);
        try {
            if (node == null) {
                throw new ExecutionException("Cannot find local node interpreter.");
            }
            ArrayList modules = new ArrayList();
            NodeModuleSearchUtil.findModulesWithName(modules, (String)"@angular/cli", (VirtualFile)cli, (boolean)false, (NodeJsInterpreter)node);
            if (modules.isEmpty() || ((CompletionModuleInfo)modules.get(0)).getVirtualFile() == null) {
                throw new ExecutionException("Angular CLI package is not installed.");
            }
            CompletionModuleInfo module = (CompletionModuleInfo)modules.get(0);
            ProcessHandler handler = NpmPackageProjectGenerator.generate((NodeJsInterpreter)node, (NodePackage)new NodePackage(Objects.requireNonNull(module.getVirtualFile()).getPath()), pkg -> Objects.requireNonNull(pkg.findBinFile()).getAbsolutePath(), (VirtualFile)cli, (File)VfsUtilCore.virtualToIoFile((VirtualFile)cli), (Project)project, () -> ((GistManagerImpl)GistManager.getInstance()).invalidateData(), (String)("Installing " + packageSpec + " for " + cli.getName()), (Filter[])new Filter[]{new AngularCLIFilter(project, cli.getPath())}, (String[])new String[]{"add", packageSpec});
            if (proposeLatestVersionIfNeeded) {
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (event.getExitCode() != 0) {
                            AngularCliAddDependencyAction.installLatestIfFeasible(project, cli, packageSpec);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/angular2/cli/actions/AngularCliAddDependencyAction$4", "processTerminated"));
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Failed to execute `ng add`: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void installLatestIfFeasible(@NotNull Project project, @NotNull VirtualFile cli, @NotNull String packageSpec) {
        if (project == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(8);
        }
        if (cli == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(9);
        }
        if (packageSpec == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(10);
        }
        if (project.isDisposed()) {
            return;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)cli);
        if (packageJson == null) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        int index = packageSpec.lastIndexOf(64);
        String packageName = index <= 0 ? packageSpec : packageSpec.substring(0, index);
        InstalledPackageVersion pkg = finder.findInstalledPackage(packageName);
        if (pkg == null) {
            return;
        }
        if (!AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(pkg)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    AngularCliAddDependencyAction.$$$reportNull$$$0(14);
                }
                if (cli == null) {
                    AngularCliAddDependencyAction.$$$reportNull$$$0(15);
                }
                if (0 == Messages.showDialog((Project)project, (String)"It looks like installed version of package doesn't support 'ng add'.\n\nWould you like to install the latest version of the package instead?", (String)"Install with 'ng add'", (String[])new String[]{"Install latest version", Messages.CANCEL_BUTTON}, (int)0, (Icon)Messages.getQuestionIcon())) {
                    AngularCliAddDependencyAction.runAndShowConsole(project, cli, packageName + "@latest", false);
                }
            }, project.getDisposed());
        }
    }

    private static void chooseCustomPackageAndInstall(@NotNull Project project, @NotNull VirtualFile cli, @NotNull Set<String> existingPackages) {
        SelectCustomPackageDialog dialog2;
        if (project == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(11);
        }
        if (cli == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(12);
        }
        if (existingPackages == null) {
            AngularCliAddDependencyAction.$$$reportNull$$$0(13);
        }
        if ((dialog2 = new SelectCustomPackageDialog(project, existingPackages)).showAndGet()) {
            AngularCliAddDependencyAction.runAndShowConsole(project, cli, dialog2.getPackage(), false);
        }
    }

    private static void updateListAsync(JBList<NodePackageBasicInfo> list, SortedListModel<NodePackageBasicInfo> model2, JBPopup popup, Set<String> existingPackages) {
        list.setPaintBusy(true);
        model2.clear();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (popup.isDisposed()) {
                return;
            }
            List<NodePackageBasicInfo> packages = AngularCliSchematicsRegistryService.getInstance().getPackagesSupportingNgAdd(20000L);
            ApplicationManager.getApplication().invokeLater(() -> {
                packages.forEach(pkg -> {
                    if (!existingPackages.contains(pkg.getName())) {
                        model2.add(pkg);
                    }
                });
                model2.add((Object)OTHER);
                list.setPaintBusy(false);
            }, o -> popup.isDisposed());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cli";
                break;
            }
            case 2: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageSpec";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPackages";
                break;
            }
        }
        objectArray2[1] = "org/angular2/cli/actions/AngularCliAddDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndShowConsoleLater";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runAndShowConsole";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "installLatestIfFeasible";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseCustomPackageAndInstall";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$installLatestIfFeasible$6";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runAndShowConsoleLater$1";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodePackagesCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<NodePackageBasicInfo> {
        private final Set<String> myExistingPackages;

        protected NodePackagesCompletionProvider(@NotNull Set<String> existingPackages) {
            if (existingPackages == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(0);
            }
            super(Collections.emptyList());
            this.myExistingPackages = existingPackages;
        }

        @NotNull
        protected String getLookupString(@NotNull NodePackageBasicInfo item) {
            if (item == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(1);
            }
            String string = item.getName();
            if (string == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public CharFilter.Result acceptChar(char c) {
            return c == '@' || c == '/' ? CharFilter.Result.ADD_TO_PREFIX : null;
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result, @NotNull String prefix) {
            if (result == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (prefix == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(4);
            }
            CompletionResultSet res = super.applyPrefixMatcher(result, prefix);
            res.restartCompletionOnAnyPrefixChange();
            CompletionResultSet completionResultSet = res;
            if (completionResultSet == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(5);
            }
            return completionResultSet;
        }

        @NotNull
        public Collection<NodePackageBasicInfo> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (cached) {
                List<NodePackageBasicInfo> list = Collections.emptyList();
                if (list == null) {
                    NodePackagesCompletionProvider.$$$reportNull$$$0(6);
                }
                return list;
            }
            ArrayList<NodePackageBasicInfo> result = new ArrayList<NodePackageBasicInfo>();
            try {
                NpmRegistryService.getInstance().findPackages(ProgressManager.getInstance().getProgressIndicator(), NpmRegistryService.namePrefixSearch((String)prefix), 20, pkg -> true, pkg -> {
                    if (!this.myExistingPackages.contains(pkg.getName())) {
                        result.add((NodePackageBasicInfo)pkg);
                    }
                });
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            ArrayList<NodePackageBasicInfo> arrayList = result;
            if (arrayList == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        public LookupElementBuilder createLookupBuilder(@NotNull NodePackageBasicInfo item) {
            if (item == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(8);
            }
            LookupElementBuilder lookupElementBuilder = super.createLookupBuilder((Object)item).withTailText(item.getDescription() != null ? "  " + item.getDescription() : null, true);
            if (lookupElementBuilder == null) {
                NodePackagesCompletionProvider.$$$reportNull$$$0(9);
            }
            return lookupElementBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingPackages";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/cli/actions/AngularCliAddDependencyAction$NodePackagesCompletionProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/cli/actions/AngularCliAddDependencyAction$NodePackagesCompletionProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPrefixMatcher";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLookupBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPrefixMatcher";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createLookupBuilder";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SelectCustomPackageDialog
    extends DialogWrapper {
        private final Set<String> myExistingPackages;
        private final Project myProject;
        private EditorTextField myTextEditor;

        SelectCustomPackageDialog(@NotNull Project project, @NotNull Set<String> existingPackages) {
            if (project == null) {
                SelectCustomPackageDialog.$$$reportNull$$$0(0);
            }
            if (existingPackages == null) {
                SelectCustomPackageDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myProject = project;
            this.myExistingPackages = existingPackages;
            this.setTitle("Install with 'ng add'");
            this.init();
            this.getOKAction().putValue("Name", "Install");
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTextEditor;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout(0, 4));
            this.myTextEditor = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new NodePackagesCompletionProvider(this.myExistingPackages), false, null);
            this.myTextEditor.setPreferredWidth(250);
            panel.add((Component)LabeledComponent.create((JComponent)this.myTextEditor, (String)"Package name", (String)"North"));
            return panel;
        }

        public String getPackage() {
            return this.myTextEditor.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "existingPackages";
                    break;
                }
            }
            objectArray[1] = "org/angular2/cli/actions/AngularCliAddDependencyAction$SelectCustomPackageDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

