/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.index;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.index.Angular2SourceDirectiveIndex;
import org.angular2.index.Angular2SourcePipeIndex;
import org.angular2.index.Angular2TemplateUrlIndex;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularSymbolIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2IndexingHandler
extends FrameworkIndexingHandler {
    public static final String TEMPLATE_URL = "templateUrl";
    public static final String TEMPLATE = "template";
    private static final String ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING = "a2tui";
    private static final String ANGULAR2_PIPE_INDEX_USER_STRING = "a2pi";
    private static final String ANGULAR2_DIRECTIVE_INDEX_USER_STRING = "a2di";
    private static final String PIPE_TYPE = "P;;;";
    private static final String DIRECTIVE_TYPE = "D;;;";
    private static final Map<String, StubIndexKey<String, JSImplicitElementProvider>> INDEX_MAP = new HashMap<String, StubIndexKey<String, JSImplicitElementProvider>>();

    public static boolean isPipe(@NotNull JSImplicitElement element) {
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(0);
        }
        return PIPE_TYPE.equals(element.getTypeString());
    }

    public static boolean isDirective(@NotNull JSImplicitElement element) {
        String type;
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(1);
        }
        if ((type = element.getTypeString()) == null) {
            return false;
        }
        return type.startsWith(DIRECTIVE_TYPE);
    }

    public int getVersion() {
        return 5;
    }

    @Nullable
    public JSElementIndexingDataImpl processDecorator(@NotNull ES6Decorator decorator, @Nullable JSElementIndexingDataImpl data) {
        TypeScriptClass enclosingClass;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(2);
        }
        if ((enclosingClass = (TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)decorator, (Class[])new Class[]{TypeScriptClass.class})) != null) {
            String decoratorName = decorator.getDecoratorName();
            boolean isComponent = false;
            if ("Pipe".equals(decoratorName)) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addPipe(enclosingClass, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2DecoratorUtil.getPropertyValue(decorator, "name"));
            } else if ("Directive".equals(decoratorName) || (isComponent = "Component".equals(decoratorName))) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addDirective(enclosingClass, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2DecoratorUtil.getPropertyValue(decorator, "selector"));
                if (isComponent) {
                    Angular2IndexingHandler.addComponentTemplateRef(decorator, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2IndexingHandler.getTemplateFileUrl(decorator));
                }
            }
        }
        return data;
    }

    private static void addDirective(@NotNull TypeScriptClass directiveClass, @NotNull Consumer<JSImplicitElement> processor, @Nullable String selector) {
        if (directiveClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)selector)) {
            return;
        }
        Set<String> indexNames = Angular2EntityUtils.getDirectiveIndexNames(selector);
        JSImplicitElementImpl directive = new JSImplicitElementImpl.Builder((String)ObjectUtils.notNull((Object)directiveClass.getName(), (Object)selector), (PsiElement)directiveClass).setType(JSImplicitElement.Type.Class).setTypeString(DIRECTIVE_TYPE + StringUtil.join(indexNames, (String)"/")).setUserString(ANGULAR2_DIRECTIVE_INDEX_USER_STRING).toImplicitElement();
        processor.consume((Object)directive);
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        StubIndexKey<String, JSImplicitElementProvider> index;
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            return false;
        }
        String userID = element.getUserString();
        StubIndexKey<String, JSImplicitElementProvider> stubIndexKey = index = userID != null ? INDEX_MAP.get(userID) : null;
        if (index == Angular2SourceDirectiveIndex.KEY) {
            String type = element.toImplicitElement(null).getTypeString();
            if (type != null && type.startsWith(DIRECTIVE_TYPE)) {
                type = type.substring(DIRECTIVE_TYPE.length());
                StringUtil.split((String)type, (String)"/").forEach(name -> sink.occurrence(index, name));
            }
            return true;
        }
        if (index != null) {
            sink.occurrence(index, (Object)element.getName());
            if (index == Angular2SourcePipeIndex.KEY) {
                sink.occurrence(AngularSymbolIndex.KEY, (Object)element.getName());
            } else {
                return true;
            }
        }
        return false;
    }

    private static void addComponentTemplateRef(@NotNull ES6Decorator decorator, @NotNull Consumer<JSImplicitElement> processor, @Nullable String templateUrl) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(7);
        }
        if (templateUrl == null) {
            return;
        }
        int lastSlash = templateUrl.lastIndexOf(47);
        String name = templateUrl.substring(lastSlash + 1);
        if ((lastSlash <= 0 || lastSlash == 1 && templateUrl.charAt(0) == '.') && name.equals(FileUtil.getNameWithoutExtension((String)decorator.getContainingFile().getOriginalFile().getName()) + ".html")) {
            return;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(name, (PsiElement)decorator).setUserString(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING);
        processor.consume((Object)elementBuilder.toImplicitElement());
    }

    private static void addPipe(@NotNull TypeScriptClass pipeClass, @NotNull Consumer<JSImplicitElement> processor, String pipe) {
        if (pipeClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(9);
        }
        if (pipe == null) {
            return;
        }
        JSImplicitElementImpl pipeElement = new JSImplicitElementImpl.Builder(pipe, (PsiElement)pipeClass).setUserString(ANGULAR2_PIPE_INDEX_USER_STRING).setTypeString(PIPE_TYPE).setType(JSImplicitElement.Type.Class).toImplicitElement();
        processor.consume((Object)pipeElement);
    }

    @Nullable
    public static TypeScriptClass findComponentClass(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(10);
        }
        if ((file = context.getContainingFile()) == null || !file.getLanguage().is((Language)Angular2HtmlLanguage.INSTANCE) && !file.getLanguage().is((Language)Angular2Language.INSTANCE)) {
            return null;
        }
        PsiFile hostFile = Angular2IndexingHandler.getHostFile(context);
        if (hostFile == null) {
            return null;
        }
        if (!file.getOriginalFile().equals(hostFile) && DialectDetector.isTypeScript((PsiElement)hostFile)) {
            return (TypeScriptClass)PsiTreeUtil.getContextOfType((PsiElement)InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file), (Class[])new Class[]{TypeScriptClass.class});
        }
        TypeScriptClass result = Angular2IndexingHandler.resolveComponentWithSameName(hostFile);
        if (result != null) {
            return result;
        }
        return Angular2IndexingHandler.resolveComponentFromIndex(hostFile);
    }

    @Nullable
    private static TypeScriptClass resolveComponentWithSameName(@NotNull PsiFile templateFile) {
        PsiFile directiveFile;
        if (templateFile == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(11);
        }
        String name = templateFile.getViewProvider().getVirtualFile().getNameWithoutExtension();
        PsiDirectory dir = templateFile.getParent();
        PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
        if (directiveFile != null) {
            return ((StreamEx)StreamEx.of((Stream)JSStubBasedPsiTreeUtil.getFileOrModuleChildrenStream(directiveFile)).select(TypeScriptClass.class).filter(cls -> {
                if (templateFile == null) {
                    Angular2IndexingHandler.$$$reportNull$$$0(17);
                }
                return Angular2IndexingHandler.hasTemplateReference(Angular2DecoratorUtil.findDecorator((JSClass)cls, "Component"), templateFile);
            })).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private static TypeScriptClass resolveComponentFromIndex(@NotNull PsiFile templateFile) {
        if (templateFile == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(12);
        }
        String name = templateFile.getViewProvider().getVirtualFile().getName();
        Ref result = new Ref();
        AngularIndexUtil.multiResolve(templateFile.getProject(), Angular2TemplateUrlIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)el -> {
            PsiElement componentDecorator;
            if (templateFile == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(16);
            }
            if (el != null && (componentDecorator = el.getParent()) instanceof ES6Decorator && Angular2IndexingHandler.hasTemplateReference((ES6Decorator)componentDecorator, templateFile)) {
                result.set((Object)PsiTreeUtil.getContextOfType((PsiElement)componentDecorator, (Class[])new Class[]{TypeScriptClass.class}));
                return false;
            }
            return true;
        }));
        return (TypeScriptClass)result.get();
    }

    private static boolean hasTemplateReference(@Nullable ES6Decorator componentDecorator, @NotNull PsiFile templateFile) {
        JSProperty templateProp;
        if (templateFile == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(13);
        }
        if (!((templateProp = Angular2DecoratorUtil.getProperty(componentDecorator, TEMPLATE_URL)) != null && templateProp.getValue() != null || (templateProp = Angular2DecoratorUtil.getProperty(componentDecorator, TEMPLATE)) != null && templateProp.getValue() != null)) {
            return false;
        }
        return AngularIndexUtil.hasFileReference((PsiElement)templateProp.getValue(), templateFile);
    }

    @Nullable
    private static String getTemplateFileUrl(@NotNull ES6Decorator decorator) {
        String templateUrl;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(14);
        }
        if ((templateUrl = Angular2DecoratorUtil.getPropertyValue(decorator, TEMPLATE_URL)) != null) {
            return templateUrl;
        }
        JSProperty property = Angular2DecoratorUtil.getProperty(decorator, TEMPLATE);
        if (property != null && property.getValue() instanceof JSReferenceExpression) {
            for (PsiElement resolvedElement : AngularIndexUtil.resolveLocally((JSReferenceExpression)property.getValue())) {
                ES6FromClause from;
                if (!(resolvedElement instanceof ES6ImportedBinding) || (from = (ES6FromClause)ObjectUtils.doIfNotNull((Object)((ES6ImportedBinding)resolvedElement).getDeclaration(), ES6ImportExportDeclaration::getFromClause)) == null) continue;
                return (String)ObjectUtils.doIfNotNull((Object)from.getReferenceText(), StringUtil::unquoteString);
            }
        }
        return null;
    }

    @Nullable
    private static PsiFile getHostFile(@NotNull PsiElement context) {
        PsiElement original;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(15);
        }
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)((original = CompletionUtil.getOriginalOrSelf((PsiElement)context)) != context ? original : context.getContainingFile().getOriginalFile()));
        return hostFile != null ? hostFile.getOriginalFile() : null;
    }

    static {
        INDEX_MAP.put(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING, Angular2TemplateUrlIndex.KEY);
        INDEX_MAP.put(ANGULAR2_DIRECTIVE_INDEX_USER_STRING, Angular2SourceDirectiveIndex.KEY);
        INDEX_MAP.put(ANGULAR2_PIPE_INDEX_USER_STRING, Angular2SourcePipeIndex.KEY);
        for (String key : INDEX_MAP.keySet()) {
            JSImplicitElement.ourUserStringsRegistry.registerUserString(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveClass";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeClass";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
        }
        objectArray2[1] = "org/angular2/index/Angular2IndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPipe";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirective";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processDecorator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirective";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "indexImplicitElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addComponentTemplateRef";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addPipe";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findComponentClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveComponentWithSameName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveComponentFromIndex";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTemplateReference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplateFileUrl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getHostFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$resolveComponentFromIndex$2";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$resolveComponentWithSameName$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

