/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag xmlTag) {
        if (xmlTag != null) {
            PsiElement declaration;
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return XmlAttributeDescriptor.EMPTY;
            }
            LinkedHashMap<String, XmlAttributeDescriptor> result = new LinkedHashMap<String, XmlAttributeDescriptor>();
            Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
            Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
            for (String directiveName : docDirectives) {
                declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesDocIndex.KEY);
                if (!AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            for (String directiveName : directives) {
                if (docDirectives.contains(directiveName) || !AngularJSAttributeDescriptorsProvider.isApplicable(declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesIndex.KEY))) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            return result.values().toArray(XmlAttributeDescriptor.EMPTY);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void addAttributes(@Nullable Project project, @NotNull Map<String, XmlAttributeDescriptor> result, @NotNull String directiveName, @NotNull PsiElement declaration) {
        if (result == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (directiveName == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(1);
        }
        if (declaration == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(2);
        }
        result.put(directiveName, (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName, declaration));
        if ("ng-repeat".equals(directiveName)) {
            result.put(directiveName + "-start", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-start", declaration));
            result.put(directiveName + "-end", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-end", declaration));
        }
    }

    private static PsiElement applicableDirective(Project project, String directiveName, XmlTag tag, StubIndexKey<String, JSImplicitElementProvider> index) {
        Ref result = Ref.create((Object)PsiUtilCore.NULL_PSI_ELEMENT);
        AngularIndexUtil.multiResolve(project, index, directiveName, (Processor<? super JSImplicitElement>)((Processor)directive -> {
            ThreeState applicable = AngularJSAttributeDescriptorsProvider.isApplicable(project, tag, directive);
            if (applicable == ThreeState.YES) {
                result.set(directive);
            }
            if (applicable == ThreeState.NO && result.get() == PsiUtilCore.NULL_PSI_ELEMENT) {
                result.set(null);
            }
            return !result.isNull();
        }));
        return (PsiElement)result.get();
    }

    @NotNull
    public static ThreeState isApplicable(Project project, XmlTag tag, JSImplicitElement directive) {
        if (directive == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        String restrictions = directive.getTypeString();
        if (restrictions != null) {
            String[] split = restrictions.split(";", -1);
            String restrict = AngularIndexUtil.convertRestrictions(project, split[0]);
            String requiredTag = split[1];
            if (!StringUtil.isEmpty((String)restrict) && !StringUtil.containsIgnoreCase((String)restrict, (String)"A")) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(4);
                }
                return threeState;
            }
            if (!AngularJSAttributeDescriptorsProvider.tagMatches(tag, requiredTag)) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(5);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(6);
        }
        return threeState;
    }

    private static boolean tagMatches(XmlTag tag, String requiredTag) {
        if (StringUtil.isEmpty((String)requiredTag) || StringUtil.equalsIgnoreCase((CharSequence)requiredTag, (CharSequence)"ANY")) {
            return true;
        }
        for (String s : requiredTag.split(",")) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)s.trim())) continue;
            return true;
        }
        if ("input".equalsIgnoreCase(requiredTag)) {
            XmlTag parent = tag;
            while (parent != null && !(parent instanceof PsiFile)) {
                if (!((parent = parent.getParent()) instanceof XmlTag) || !AngularJSAttributeDescriptorsProvider.isForm(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isForm(XmlTag parent) {
        String name = parent.getName();
        return "form".equalsIgnoreCase(name) || "ng-form".equalsIgnoreCase(name);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attrName, XmlTag xmlTag) {
        return AngularJSAttributeDescriptorsProvider.getDescriptor(attrName, xmlTag);
    }

    static XmlAttributeDescriptor getDescriptor(String attrName, XmlTag xmlTag) {
        if (xmlTag != null) {
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return null;
            }
            String attributeName = DirectiveUtil.normalizeAttributeName(attrName);
            PsiElement declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, attributeName, xmlTag, AngularDirectivesDocIndex.KEY);
            if (declaration == PsiUtilCore.NULL_PSI_ELEMENT) {
                declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, attributeName, xmlTag, AngularDirectivesIndex.KEY);
            }
            if (AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) {
                return AngularAttributesRegistry.createDescriptor(project, attributeName, declaration);
            }
        }
        return null;
    }

    private static boolean isApplicable(PsiElement declaration) {
        return declaration != null && declaration != PsiUtilCore.NULL_PSI_ELEMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/attributes/AngularJSAttributeDescriptorsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/attributes/AngularJSAttributeDescriptorsProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isApplicable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

