/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.angular2.lang.Angular2LangUtil;
import org.angularjs.codeInsight.refs.AngularJSControllerReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSDIReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSModuleReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSNgAppReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSTemplateReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSUiRouterStatesReferencesProvider;
import org.angularjs.codeInsight.refs.AngularJSUiRouterViewReferencesProvider;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularJSIndexingHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSReferencesContributor
extends PsiReferenceContributor {
    private static final PsiElementPattern.Capture<JSLiteralExpression> TEMPLATE_PATTERN = AngularJSReferencesContributor.literalInProperty("templateUrl");
    private static final PsiElementPattern.Capture<JSLiteralExpression> CONTROLLER_PATTERN = AngularJSReferencesContributor.literalInProperty("controller");
    public static final PsiElementPattern.Capture<PsiElement> UI_VIEW_PATTERN = AngularJSReferencesContributor.uiViewPattern();
    public static final PsiElementPattern.Capture<XmlAttributeValue> UI_VIEW_REF = AngularJSReferencesContributor.xmlAttributePattern("ui-sref");
    public static final PsiElementPattern.Capture<XmlAttributeValue> NG_APP_REF = AngularJSReferencesContributor.xmlAttributePattern("ng-app");
    public static final PsiElementPattern.Capture<JSLiteralExpression> MODULE_PATTERN = AngularJSReferencesContributor.modulePattern();
    public static final PsiElementPattern.Capture<JSLiteralExpression> MODULE_DEPENDENCY_PATTERN = AngularJSReferencesContributor.moduleDependencyPattern();
    private static final PsiElementPattern.Capture<JSLiteralExpression> NG_INCLUDE_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, @Nullable PsiElement context) {
            PsiElement original;
            PsiLanguageInjectionHost host;
            JSLiteralExpression literal;
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral() && (host = InjectedLanguageUtil.findInjectionHost((PsiElement)(original = CompletionUtil.getOriginalOrSelf((PsiElement)literal)))) instanceof XmlAttributeValue) {
                PsiElement parent = host.getParent();
                return parent instanceof XmlAttribute && "ng-include".equals(((XmlAttribute)parent).getName());
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));
    public static final PsiElementPattern.Capture<JSParameter> DI_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement(JSParameter.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, @Nullable PsiElement context) {
            return AngularJSIndexingHandler.isInjectable(context);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            AngularJSReferencesContributor.$$$reportNull$$$0(0);
        }
        AngularJSTemplateReferencesProvider templateProvider = new AngularJSTemplateReferencesProvider();
        registrar.registerReferenceProvider(TEMPLATE_PATTERN, (PsiReferenceProvider)templateProvider);
        registrar.registerReferenceProvider(NG_INCLUDE_PATTERN, (PsiReferenceProvider)templateProvider);
        registrar.registerReferenceProvider(CONTROLLER_PATTERN, (PsiReferenceProvider)new AngularJSControllerReferencesProvider());
        registrar.registerReferenceProvider(DI_PATTERN, (PsiReferenceProvider)new AngularJSDIReferencesProvider());
        registrar.registerReferenceProvider(UI_VIEW_PATTERN, (PsiReferenceProvider)new AngularJSUiRouterViewReferencesProvider());
        registrar.registerReferenceProvider(UI_VIEW_REF, (PsiReferenceProvider)new AngularJSUiRouterStatesReferencesProvider());
        registrar.registerReferenceProvider(NG_APP_REF, (PsiReferenceProvider)new AngularJSNgAppReferencesProvider());
        registrar.registerReferenceProvider(MODULE_PATTERN, (PsiReferenceProvider)new AngularJSModuleReferencesProvider());
    }

    private static PsiElementPattern.Capture<JSLiteralExpression> modulePattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JSExpression methodExpression;
                PsiElement parent;
                return element instanceof JSLiteralExpression && (parent = ((PsiElement)element).getParent()) instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ((JSArgumentList)parent).getArguments().length == 1 && PsiTreeUtil.isAncestor((PsiElement)((JSArgumentList)parent).getArguments()[0], (PsiElement)((PsiElement)element), (boolean)false) && AngularJSReferencesContributor.looksLikeAngularModuleReference(methodExpression = ((JSCallExpression)parent.getParent()).getMethodExpression());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<JSLiteralExpression> moduleDependencyPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JSLiteralExpression) {
                    JSExpression methodExpression;
                    PsiElement parent = ((PsiElement)element).getParent();
                    if (!(parent instanceof JSArrayLiteralExpression)) {
                        return false;
                    }
                    if ((parent = parent.getParent()) instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ((JSArgumentList)parent).getArguments().length > 1 && PsiTreeUtil.isAncestor((PsiElement)((JSArgumentList)parent).getArguments()[1], (PsiElement)((PsiElement)element), (boolean)false) && ((JSArgumentList)parent).getArguments()[1] instanceof JSArrayLiteralExpression && AngularJSReferencesContributor.looksLikeAngularModuleReference(methodExpression = ((JSCallExpression)parent.getParent()).getMethodExpression())) {
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    static boolean looksLikeAngularModuleReference(JSExpression methodExpression) {
        return methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() != null && "module".equals(((JSReferenceExpression)methodExpression).getReferenceName());
    }

    private static PsiElementPattern.Capture<JSLiteralExpression> literalInProperty(final String propertyName) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                PsiElement parent;
                JSLiteralExpression literal;
                if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral() && (parent = literal.getParent()) instanceof JSProperty && propertyName.equals(((JSProperty)parent).getName())) {
                    return AngularIndexUtil.hasAngularJS(literal.getProject()) || Angular2LangUtil.isAngular2Context(parent);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<PsiElement> uiViewPattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiElement.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (!(element instanceof PsiElement)) {
                    return false;
                }
                if (element instanceof JSLiteralExpression || element instanceof LeafPsiElement && ((LeafPsiElement)element).getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                    if (!(((PsiElement)element).getParent() instanceof JSProperty)) {
                        return false;
                    }
                    PsiElement current = this.moveUpChain((PsiElement)element, JSLiteralExpression.class, JSReferenceExpression.class, JSProperty.class);
                    if (!(current instanceof JSProperty) || !this.acceptablePropertyValue((JSProperty)current)) {
                        return false;
                    }
                    if ((current = current.getParent()) != null && this.checkParentViewsObject(current)) {
                        return AngularIndexUtil.hasAngularJS(current.getProject());
                    }
                }
                return false;
            }

            private boolean acceptablePropertyValue(JSProperty element) {
                return element.getNameIdentifier() != null && StringUtil.isQuotedString((String)element.getNameIdentifier().getText()) && (element.getValue() instanceof JSObjectLiteralExpression || element.getValue() instanceof JSReferenceExpression || element.getValue() == null);
            }

            private PsiElement moveUpChain(@Nullable PsiElement element, Class<? extends PsiElement> ... clazz) {
                if (clazz == null) {
                    6.$$$reportNull$$$0(0);
                }
                PsiElement current = element;
                for (Class<? extends PsiElement> aClass : clazz) {
                    current = current != null && aClass.isInstance(current.getParent()) ? current.getParent() : current;
                }
                return current;
            }

            private boolean checkParentViewsObject(PsiElement mustBeObject) {
                PsiElement viewsProperty;
                return mustBeObject instanceof JSObjectLiteralExpression && (viewsProperty = mustBeObject.getParent()) instanceof JSProperty && "views".equals(((JSProperty)viewsProperty).getName());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/angularjs/codeInsight/refs/AngularJSReferencesContributor$6", "moveUpChain"));
            }
        }));
    }

    private static PsiElementPattern.Capture<XmlAttributeValue> xmlAttributePattern(final @NotNull String attributeName) {
        if (attributeName == null) {
            AngularJSReferencesContributor.$$$reportNull$$$0(1);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(XmlAttributeValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                XmlAttributeValue attributeValue = (XmlAttributeValue)element;
                PsiElement parent = attributeValue.getParent();
                if (parent instanceof XmlAttribute && attributeName.equals(((XmlAttribute)parent).getName())) {
                    return AngularIndexUtil.hasAngularJS(attributeValue.getProject());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/refs/AngularJSReferencesContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "xmlAttributePattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

