/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.tags;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import com.intellij.xml.util.XmlUtil;
import icons.AngularJSIcons;
import java.util.List;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.tags.AngularJSTagDescriptor;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSTagDescriptorsProvider
implements XmlElementDescriptorProvider,
XmlTagNameProvider {
    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag xmlTag, String prefix) {
        if (xmlTag == null) {
            AngularJSTagDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (!(xmlTag instanceof HtmlTag) || !AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
            return;
        }
        Project project = xmlTag.getProject();
        Language language = xmlTag.getContainingFile().getLanguage();
        DirectiveUtil.processTagDirectives(project, (Processor<? super JSImplicitElement>)((Processor)directive -> {
            AngularJSTagDescriptorsProvider.addLookupItem(language, elements, directive);
            return true;
        }));
    }

    private static void addLookupItem(Language language, List<LookupElement> elements, JSImplicitElement directive) {
        LookupElementBuilder element = LookupElementBuilder.create((PsiNamedElement)directive).withIcon(AngularJSIcons.Angular2);
        if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            element = element.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        }
        elements.add((LookupElement)element);
    }

    @Nullable
    public XmlElementDescriptor getDescriptor(XmlTag xmlTag) {
        Project project = xmlTag.getProject();
        if (!(xmlTag instanceof HtmlTag) || !AngularIndexUtil.hasAngularJS(project)) {
            return null;
        }
        String tagName = xmlTag.getName();
        String directiveName = DirectiveUtil.normalizeAttributeName(tagName);
        if (XmlUtil.isTagDefinedByNamespace((XmlTag)xmlTag)) {
            return null;
        }
        JSImplicitElement directive = DirectiveUtil.getTagDirective(directiveName, project);
        if (DirectiveUtil.isAngular2Directive((PsiElement)directive) && !directive.getName().equals(tagName)) {
            directive = null;
        }
        return directive != null ? new AngularJSTagDescriptor(directiveName, directive) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "org/angularjs/codeInsight/tags/AngularJSTagDescriptorsProvider", "addTagNameVariants"));
    }
}

