/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.application.Topics;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.FileBasedSynchronizer;
import com.jetbrains.liveEdit.LiveEditBulkFileListener;
import com.jetbrains.liveEdit.LiveEditOptions;
import com.jetbrains.liveEdit.LiveLookupListener;
import com.jetbrains.liveEdit.PsiSynchronizer;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import com.jetbrains.liveEdit.update.UpdateConfiguration;
import com.jetbrains.liveEdit.update.UpdateConfigurationProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveEditManager
implements StartupActivity,
DumbAware {
    private static final Key<Disposable> LIVE_LISTENERS_DISPOSABLE_KEY = Key.create((String)"liveEditEventListenerDisposable");
    private static final Key<AtomicInteger> ACTIVE_DEBUG_PROCESS_COUNT = Key.create((String)"liveEditOperable");
    private static final ExtensionPointName<RangeValueSynchronizerFactory<RangeValueSynchronizer>> LOOKUP_SYNCHRONIZER_FACTORY_EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.lookupSynchronizerFactory");
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final SyncQueue syncQueue = new SyncQueue(this.alarm);
    private final Collection<VirtualFile> ignoredFiles = new WeakList();
    private final AtomicBoolean applicationWideListenersAdded = new AtomicBoolean();
    private volatile int applicationWideActiveDebugProcessCount;

    public static LiveEditManager getInstance() {
        return (LiveEditManager)StartupActivity.POST_STARTUP_ACTIVITY.findExtension(LiveEditManager.class);
    }

    @NotNull
    public Alarm getAlarm() {
        Alarm alarm = this.alarm;
        if (alarm == null) {
            LiveEditManager.$$$reportNull$$$0(0);
        }
        return alarm;
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(1);
        }
        if (project.isDefault()) {
            return;
        }
        project.getMessageBus().connect((Disposable)project).subscribe(XDebuggerManager.TOPIC, (Object)new XDebuggerManagerListener(){

            public void processStarted(@NotNull XDebugProcess debugProcess) {
                UpdatePolicy updatePolicy;
                if (debugProcess == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((updatePolicy = ApplicationInspector.getInstance().getUpdatePolicy(debugProcess, false)) != UpdatePolicy.DISABLED) {
                    LiveEditManager.this.start(debugProcess.getSession().getProject(), updatePolicy);
                }
            }

            public void processStopped(@NotNull XDebugProcess debugProcess) {
                if (debugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (LiveEditManager.this.applicationWideActiveDebugProcessCount > 0) {
                    LiveEditManager.this.end(debugProcess.getSession().getProject(), debugProcess);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "debugProcess";
                objectArray2[1] = "com/jetbrains/liveEdit/LiveEditManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStopped";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (LiveEditOptions.getInstance().isElementHighlighting()) {
            ElementHighlighter.getInstance().setEnabled(true);
        }
    }

    void startChrome(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(2);
        }
        this.start(project, LiveEditOptions.getInstance().isChromeUpdateOnChanges() ? UpdatePolicy.AUTO : UpdatePolicy.MANUAL);
    }

    void end(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(3);
        }
        this.end(project, null);
    }

    private void start(@NotNull Project project, @NotNull UpdatePolicy updatePolicy) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(4);
        }
        if (updatePolicy == null) {
            LiveEditManager.$$$reportNull$$$0(5);
        }
        ++this.applicationWideActiveDebugProcessCount;
        this.startTrackChanges(project, updatePolicy).incrementAndGet();
    }

    private void end(@NotNull Project project, @Nullable XDebugProcess debugProcess) {
        AtomicInteger activeDebugProcessCount;
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(6);
        }
        if ((activeDebugProcessCount = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project)) != null && (debugProcess == null || ApplicationInspector.getInstance().getUpdatePolicy(debugProcess, true) != UpdatePolicy.DISABLED)) {
            Disposable disposable;
            --this.applicationWideActiveDebugProcessCount;
            if (activeDebugProcessCount.decrementAndGet() == 0 && (disposable = (Disposable)LIVE_LISTENERS_DISPOSABLE_KEY.get((UserDataHolder)project)) != null) {
                LIVE_LISTENERS_DISPOSABLE_KEY.set((UserDataHolder)project, null);
                Disposer.dispose((Disposable)disposable);
            }
        }
    }

    @NotNull
    private AtomicInteger startTrackChanges(@NotNull Project project, @NotNull UpdatePolicy updatePolicy) {
        AtomicInteger activeDebugProcessCount;
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(7);
        }
        if (updatePolicy == null) {
            LiveEditManager.$$$reportNull$$$0(8);
        }
        if (this.applicationWideListenersAdded.compareAndSet(false, true)) {
            Topics.subscribe((Topic)VirtualFileManager.VFS_CHANGES, null, (Object)new LiveEditBulkFileListener(this));
        }
        if ((activeDebugProcessCount = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project)) == null) {
            activeDebugProcessCount = new AtomicInteger();
            ACTIVE_DEBUG_PROCESS_COUNT.set((UserDataHolder)project, (Object)activeDebugProcessCount);
            PomManager.getModel((Project)project).addModelListener((PomModelListener)new MyPomModelListener(project), (Disposable)project);
        }
        if (updatePolicy == UpdatePolicy.AUTO && !LIVE_LISTENERS_DISPOSABLE_KEY.isIn((UserDataHolder)project)) {
            Disposable disposable = Disposer.newDisposable();
            LIVE_LISTENERS_DISPOSABLE_KEY.set((UserDataHolder)project, (Object)disposable);
            Disposer.register((Disposable)project, (Disposable)disposable);
            LookupManager.getInstance((Project)project).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!"activeLookup".equals(event.getPropertyName())) {
                        return;
                    }
                    Lookup lookup = (Lookup)event.getNewValue();
                    if (lookup == null) {
                        return;
                    }
                    PsiElement element = lookup.getPsiElement();
                    if (element == null) {
                        return;
                    }
                    PsiFile file = lookup.getPsiFile();
                    if (file == null || !file.isPhysical()) {
                        return;
                    }
                    RangeValueSynchronizer synchronizer = (RangeValueSynchronizer)RangeValueSynchronizerFactory.find(element, file, LOOKUP_SYNCHRONIZER_FACTORY_EP_NAME);
                    if (synchronizer != null) {
                        lookup.addLookupListener((LookupListener)new LiveLookupListener(lookup, synchronizer));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/liveEdit/LiveEditManager$2", "propertyChange"));
                }
            }, disposable);
        }
        AtomicInteger atomicInteger = activeDebugProcessCount;
        if (atomicInteger == null) {
            LiveEditManager.$$$reportNull$$$0(9);
        }
        return atomicInteger;
    }

    public boolean isOperable() {
        return this.applicationWideActiveDebugProcessCount > 0 || ApplicationManager.getApplication().isUnitTestMode();
    }

    public boolean isOperable(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(10);
        }
        if (this.applicationWideActiveDebugProcessCount == 0) {
            return false;
        }
        AtomicInteger count = (AtomicInteger)ACTIVE_DEBUG_PROCESS_COUNT.get((UserDataHolder)project);
        return count != null && count.get() > 0;
    }

    public boolean isLiveOperable(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(11);
        }
        return LIVE_LISTENERS_DISPOSABLE_KEY.isIn((UserDataHolder)project);
    }

    public boolean isOperableForBrowser(@NotNull Project project) {
        if (project == null) {
            LiveEditManager.$$$reportNull$$$0(12);
        }
        return this.isOperable(project) && BrowserConnectionManager.getInstance().hasConnections() || ApplicationManager.getApplication().isUnitTestMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreFile(@NotNull VirtualFile file, boolean value) {
        if (file == null) {
            LiveEditManager.$$$reportNull$$$0(13);
        }
        Collection<VirtualFile> collection = this.ignoredFiles;
        synchronized (collection) {
            if (!value) {
                this.ignoredFiles.remove(file);
            } else if (!this.ignoredFiles.contains(file)) {
                this.ignoredFiles.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.syncQueue.lock;
        synchronized (object) {
            if (this.syncQueue.cancel()) {
                this.syncQueue.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<PsiElement> runImmediately() {
        Object object = this.syncQueue.lock;
        // MONITORENTER : object
        this.syncQueue.cancel();
        Set<PsiElement> set = this.syncQueue.runAndGetChangedElements();
        // MONITOREXIT : object
        if (set != null) return set;
        LiveEditManager.$$$reportNull$$$0(14);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(@NotNull Collection<PsiFile> psiFiles, Project project) {
        if (psiFiles == null) {
            LiveEditManager.$$$reportNull$$$0(15);
        }
        Object object = this.syncQueue.lock;
        synchronized (object) {
            boolean canceled = this.syncQueue.cancel();
            boolean scheduled = false;
            for (PsiFile psiFile : psiFiles) {
                if (!psiFile.isValid()) continue;
                FileBasedSynchronizer synchronizer = (FileBasedSynchronizer)PsiSynchronizer.get(psiFile.getFileType());
                assert (synchronizer != null);
                if (!synchronizer.scheduleFile(psiFile)) continue;
                scheduled = true;
            }
            if (scheduled || canceled) {
                this.syncQueue.request(project);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/LiveEditManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatePolicy";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlarm";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/LiveEditManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startTrackChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "runImmediately";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startChrome";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "end";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startTrackChanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOperable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLiveOperable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isOperableForBrowser";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ignoreFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "schedule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPomModelListener
    implements PomModelListener {
        private final Project project;

        private MyPomModelListener(Project project) {
            if (project == null) {
                MyPomModelListener.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        public void modelChanged(@NotNull PomModelEvent event) {
            if (event == null) {
                MyPomModelListener.$$$reportNull$$$0(1);
            }
            for (PomModelAspect aspect : event.getChangedAspects()) {
                if (!(aspect instanceof TreeAspect)) continue;
                this.update((TreeChangeEvent)event.getChangeSet(aspect));
                return;
            }
        }

        public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
            if (aspect == null) {
                MyPomModelListener.$$$reportNull$$$0(2);
            }
            return LiveEditManager.this.isOperable(this.project) && aspect instanceof TreeAspect;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(TreeChangeEvent changeSet) {
            PsiFile file = (PsiFile)changeSet.getRootElement().getPsi();
            if (file == null || !file.isPhysical()) {
                return;
            }
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                return;
            }
            Collection collection = LiveEditManager.this.ignoredFiles;
            synchronized (collection) {
                if (LiveEditManager.this.ignoredFiles.contains(virtualFile)) {
                    return;
                }
            }
            FileType virtualFileType = virtualFile.getFileType();
            if (ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile, (FileType)virtualFileType)) {
                return;
            }
            FileType fileType = file.getFileType();
            if (fileType != StdFileTypes.JSPX && virtualFileType != fileType) {
                return;
            }
            PsiSynchronizer synchronizer = PsiSynchronizer.get(fileType);
            if (synchronizer == null) {
                return;
            }
            Object object = ((LiveEditManager)LiveEditManager.this).syncQueue.lock;
            synchronized (object) {
                boolean canceled = LiveEditManager.this.syncQueue.cancel();
                boolean scheduled = false;
                for (ASTNode changedElement : changeSet.getChangedElements()) {
                    TreeChange changesByElement = changeSet.getChangesByElement(changedElement);
                    PsiElement psiParent = changedElement.getPsi();
                    if (psiParent == null) continue;
                    for (ASTNode treeElement : changesByElement.getAffectedChildren()) {
                        if (!synchronizer.schedule(changesByElement.getChangeByChild(treeElement).getChangeType(), treeElement.getPsi(), psiParent, file)) continue;
                        scheduled = true;
                    }
                }
                if (scheduled || canceled) {
                    LiveEditManager.this.syncQueue.request(this.project);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aspect";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/liveEdit/LiveEditManager$MyPomModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAspectChangeInteresting";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SyncQueue
    implements Runnable {
        private final Alarm alarm;
        private boolean alarmRequested;
        final Object lock;
        private final boolean isUnitTestMode;

        SyncQueue(@NotNull Alarm alarm) {
            if (alarm == null) {
                SyncQueue.$$$reportNull$$$0(0);
            }
            this.lock = new Object();
            this.alarm = alarm;
            this.isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        }

        public void request(Project project) {
            this.alarmRequested = true;
            if (this.isUnitTestMode) {
                this.run();
            } else {
                int delay = SyncQueue.getAutoDelay(project);
                if (delay >= 0) {
                    this.alarm.addRequest((Runnable)this, delay);
                }
            }
        }

        private static int getAutoDelay(@NotNull Project project) {
            if (project == null) {
                SyncQueue.$$$reportNull$$$0(1);
            }
            return SyncQueue.getActiveConfigurations(project).filter(configuration -> configuration.getPolicy() == UpdatePolicy.AUTO).map(UpdateConfiguration::getAutoDelay).min(Integer::compareTo).orElse(-1);
        }

        static Stream<UpdateConfiguration> getActiveConfigurations(@NotNull Project project) {
            if (project == null) {
                SyncQueue.$$$reportNull$$$0(2);
            }
            return Arrays.stream(XDebuggerManager.getInstance((Project)project).getDebugSessions()).map(XDebugSession::getDebugProcess).flatMap(process -> Arrays.stream(UpdateConfigurationProvider.EP_NAME.getExtensions()).map(provider -> provider.getConfiguration((XDebugProcess)process)).filter(configuration -> configuration != null));
        }

        public boolean cancel() {
            if (!this.alarmRequested) {
                return false;
            }
            this.alarm.cancelRequest((Runnable)this);
            this.alarmRequested = false;
            return true;
        }

        @Override
        public void run() {
            this.runAndGetChangedElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<PsiElement> runAndGetChangedElements() {
            List tasks = null;
            HashSet<PsiElement> result = new HashSet<PsiElement>();
            Iterator iterator = this.lock;
            synchronized (iterator) {
                this.alarmRequested = false;
                for (PsiSynchronizer synchronizer : PsiSynchronizer.EP_NAME.getExtensionList()) {
                    Supplier<Set<PsiElement>> task = synchronizer.flushSyncTask();
                    if (task == null) continue;
                    if (tasks == null) {
                        tasks = new SmartList();
                    }
                    tasks.add(task);
                }
            }
            if (tasks != null) {
                for (Supplier task : tasks) {
                    Set taskFiles = (Set)task.get();
                    if (taskFiles == null) continue;
                    result.addAll(taskFiles);
                }
            }
            HashSet<PsiElement> hashSet = result;
            if (hashSet == null) {
                SyncQueue.$$$reportNull$$$0(3);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alarm";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/liveEdit/LiveEditManager$SyncQueue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/liveEdit/LiveEditManager$SyncQueue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAndGetChangedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAutoDelay";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveConfigurations";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

