/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.javascript.debugger.execution.ILiveEditOptions;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.liveEdit.UpdatePolicy;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import org.jetbrains.annotations.NotNull;

@State(name="LiveEditOptions", storages={@Storage(value="editor.xml")})
public class LiveEditOptions
implements PersistentStateComponent<LiveEditOptions>,
ILiveEditOptions {
    static final int DEFAULT_AUTO_DELAY = 300;
    private boolean nodeUpdateOnChanges = false;
    private int nodeAutoDelay = 300;
    private boolean chromeUpdateOnChanges = true;
    private boolean chromeUpdateJSOnChanges = false;
    private int chromeAutoDelay = 300;
    private boolean elementHighlighting = false;
    private boolean restartIfHotSwapFailed;
    private boolean useJBChromeExtension = false;

    public static LiveEditOptions getInstance() {
        return (LiveEditOptions)ServiceManager.getService(ILiveEditOptions.class);
    }

    @Attribute
    @Deprecated
    public UpdatePolicy getUpdatePolicy() {
        return UpdatePolicy.MANUAL;
    }

    @Deprecated
    public void setUpdatePolicy(UpdatePolicy value) {
        if (value == UpdatePolicy.AUTO) {
            this.chromeUpdateOnChanges = true;
            this.useJBChromeExtension = true;
            this.nodeUpdateOnChanges = true;
        }
    }

    @Attribute
    @Deprecated
    public int getAutoDelay() {
        return 300;
    }

    @Deprecated
    public void setAutoDelay(int value) {
        if (value != 300) {
            this.nodeAutoDelay = this.chromeAutoDelay = value;
        }
    }

    @Deprecated
    public void setLiveEditing(boolean value) {
        this.nodeUpdateOnChanges = this.useJBChromeExtension = value;
    }

    @Attribute
    public boolean isNodeUpdateOnChanges() {
        return this.nodeUpdateOnChanges;
    }

    public void setNodeUpdateOnChanges(boolean nodeUpdateOnChanges) {
        this.nodeUpdateOnChanges = nodeUpdateOnChanges;
    }

    @Attribute
    public int getNodeAutoDelay() {
        return this.nodeAutoDelay;
    }

    public void setNodeAutoDelay(int nodeAutoDelay) {
        this.nodeAutoDelay = nodeAutoDelay;
    }

    @Attribute
    @Deprecated
    public boolean isChromeUpdateApp() {
        return false;
    }

    @Deprecated
    public void setChromeUpdateApp(boolean chromeUpdateApp) {
        this.useJBChromeExtension = chromeUpdateApp;
    }

    @Attribute
    public boolean isUseJBChromeExtension() {
        return this.useJBChromeExtension;
    }

    public void setUseJBChromeExtension(boolean useJBChromeExtension) {
        this.useJBChromeExtension = useJBChromeExtension;
    }

    @Attribute
    public boolean isChromeUpdateOnChanges() {
        return this.chromeUpdateOnChanges;
    }

    public void setChromeUpdateOnChanges(boolean chromeUpdateOnChanges) {
        this.chromeUpdateOnChanges = chromeUpdateOnChanges;
    }

    @Attribute
    public boolean isChromeUpdateJSOnChanges() {
        return this.chromeUpdateJSOnChanges;
    }

    public void setChromeUpdateJSOnChanges(boolean chromeUpdateJSOnChanges) {
        this.chromeUpdateJSOnChanges = chromeUpdateJSOnChanges;
    }

    @Attribute
    public int getChromeAutoDelay() {
        return this.chromeAutoDelay;
    }

    public void setChromeAutoDelay(int chromeAutoDelay) {
        this.chromeAutoDelay = chromeAutoDelay;
    }

    public void setElementHighlighting(boolean value) {
        this.setElementHighlighting(value, false);
    }

    public boolean isElementHighlighting() {
        return this.elementHighlighting;
    }

    public void setElementHighlighting(boolean value, boolean userInitiatedAction) {
        if (this.elementHighlighting == value) {
            return;
        }
        this.elementHighlighting = value;
        if (userInitiatedAction) {
            ElementHighlighter.getInstance().setEnabled(value);
        }
    }

    @Attribute
    public boolean isRestartIfHotSwapFailed() {
        return this.restartIfHotSwapFailed;
    }

    public void setRestartIfHotSwapFailed(boolean restartIfHotSwapFailed) {
        this.restartIfHotSwapFailed = restartIfHotSwapFailed;
    }

    public LiveEditOptions getState() {
        return this;
    }

    public void loadState(@NotNull LiveEditOptions state) {
        if (state == null) {
            LiveEditOptions.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        ElementHighlighter.getInstance().setEnabled(this.elementHighlighting);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/liveEdit/LiveEditOptions", "loadState"));
    }
}

