/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xml.util.UserColorLookup;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveLookupListener
implements LookupListener,
Runnable {
    private final SingleAlarm alarm;
    private final RangeValueSynchronizer lookupSynchronizer;
    private final Lookup lookup;
    private boolean syncScheduled;

    LiveLookupListener(@NotNull Lookup lookup, @NotNull RangeValueSynchronizer lookupSynchronizer) {
        if (lookup == null) {
            LiveLookupListener.$$$reportNull$$$0(0);
        }
        if (lookupSynchronizer == null) {
            LiveLookupListener.$$$reportNull$$$0(1);
        }
        this.alarm = new SingleAlarm((Runnable)this, 100);
        this.lookup = lookup;
        this.lookupSynchronizer = lookupSynchronizer;
        LiveEditManager liveEditManager = LiveEditManager.getInstance();
        liveEditManager.ignoreFile(lookup.getPsiFile().getOriginalFile().getViewProvider().getVirtualFile(), true);
        liveEditManager.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupClosed(@NotNull LookupEvent event, boolean selected) {
        if (event == null) {
            LiveLookupListener.$$$reportNull$$$0(2);
        }
        try {
            this.alarm.cancelRequest((Runnable)this);
            boolean wasScheduled = this.syncScheduled;
            this.syncScheduled = false;
            if (!selected) {
                this.lookupSynchronizer.revert();
            } else if (wasScheduled) {
                this.sync(event.getItem(), true);
            }
        }
        finally {
            LiveEditManager.getInstance().ignoreFile(this.lookup.getPsiFile().getOriginalFile().getViewProvider().getVirtualFile(), false);
        }
    }

    public void itemSelected(@NotNull LookupEvent event) {
        if (event == null) {
            LiveLookupListener.$$$reportNull$$$0(3);
        }
        this.lookupClosed(event, true);
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        if (event == null) {
            LiveLookupListener.$$$reportNull$$$0(4);
        }
        this.lookupClosed(event, false);
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        LookupElement item;
        if (event == null) {
            LiveLookupListener.$$$reportNull$$$0(5);
        }
        if (!LiveLookupListener.isApplicableItem(item = event.getItem())) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.lookupSynchronizer.sync(item, this.lookup, false);
            return;
        }
        this.alarm.cancelAndRequest();
        this.syncScheduled = true;
    }

    @Override
    public void run() {
        this.sync(this.lookup.getCurrentItem(), false);
    }

    private void sync(@Nullable LookupElement item, boolean closed) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (LiveLookupListener.isApplicableItem(item)) {
            this.syncScheduled = false;
            this.lookupSynchronizer.sync(item, this.lookup, closed);
        }
    }

    private static boolean isApplicableItem(@Nullable LookupElement item) {
        return item != null && !(item instanceof UserColorLookup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupSynchronizer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/LiveLookupListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupClosed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "itemSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupCanceled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "currentItemChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

