/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.elementsInspector;

import com.google.common.base.CharMatcher;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.impl.StructureViewSelectInTarget;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RunnerContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Url;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.liveEdit.WipDocumentModelManager;
import com.jetbrains.liveEdit.elementsInspector.ElementsView;
import com.jetbrains.liveEdit.elementsInspector.ElementsViewKt;
import com.jetbrains.liveEdit.elementsInspector.InspectorElementHighlightExecutor;
import com.jetbrains.liveEdit.elementsInspector.InspectorFileReferenceHelper;
import com.jetbrains.liveEdit.elementsInspector.InspectorStructureViewWrapper;
import com.jetbrains.liveEdit.elementsInspector.UpdateQueue;
import com.jetbrains.liveEdit.highlighting.ElementHighlighter;
import com.jetbrains.liveEdit.highlighting.ElementHighlighterOnCaretChangeBase;
import com.jetbrains.liveEdit.highlighting.LiveEditElementPreviewProvider;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.NodeIdentifiable;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.dom.AttributeModifiedEventData;
import org.jetbrains.wip.protocol.dom.AttributeRemovedEventData;
import org.jetbrains.wip.protocol.dom.CharacterDataModifiedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeCountUpdatedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeInsertedEventData;
import org.jetbrains.wip.protocol.dom.ChildNodeRemovedEventData;
import org.jetbrains.wip.protocol.dom.DOMKt;
import org.jetbrains.wip.protocol.dom.DocumentUpdatedEventData;
import org.jetbrains.wip.protocol.dom.GetDocumentResult;
import org.jetbrains.wip.protocol.dom.InlineStyleInvalidatedEventData;
import org.jetbrains.wip.protocol.dom.NodeValue;
import org.jetbrains.wip.protocol.dom.SetChildNodesEventData;
import org.jetbrains.wip.protocol.page.DomContentEventFiredEventData;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u0002cdB'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0010\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020AH\u0002J=\u0010B\u001a\u00020;2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020E0D2\n\u0010F\u001a\u00060Gj\u0002`H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0&2\u0006\u0010K\u001a\u00020LH\u0000\u00a2\u0006\u0002\bMJ2\u0010N\u001a\u00020;2\n\u0010F\u001a\u00060Gj\u0002`H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0&2\u0006\u0010O\u001a\u00020E2\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020;H\u0002J\u001e\u0010S\u001a\u00020;2\u0006\u0010T\u001a\u00020U2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0&H\u0002J#\u0010V\u001a\u00020;2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0&2\u0006\u0010W\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bXJ\b\u0010Y\u001a\u00020;H\u0016J\b\u0010Z\u001a\u00020;H\u0002J\u0010\u0010[\u001a\u00020;2\u0006\u0010\\\u001a\u00020LH\u0002J\u0006\u0010]\u001a\u00020;J\u0015\u0010^\u001a\u00020;2\u0006\u0010_\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b`J\u0010\u0010a\u001a\u00020;2\u0006\u0010b\u001a\u00020LH\u0002R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;", "Lcom/intellij/openapi/Disposable;", "connection", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "project", "Lcom/intellij/openapi/project/Project;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "(Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "getCommandProcessor$intellij_js_liveEdit", "()Lorg/jetbrains/wip/WipCommandProcessor;", "setCommandProcessor$intellij_js_liveEdit", "(Lorg/jetbrains/wip/WipCommandProcessor;)V", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument$intellij_js_liveEdit", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "newId", "", "documentId", "getDocumentId$intellij_js_liveEdit", "()I", "setDocumentId$intellij_js_liveEdit", "(I)V", "documentInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "documentModel", "Lcom/jetbrains/liveEdit/WipDocumentModelManager;", "getDocumentModel", "()Lcom/jetbrains/liveEdit/WipDocumentModelManager;", "editorWrapper", "Ljavax/swing/JPanel;", "inspectorStructureViewWrapper", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorStructureViewWrapper;", "nodeIdToRangeMarker", "Lgnu/trove/TIntObjectHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "getNodeIdToRangeMarker$intellij_js_liveEdit", "()Lgnu/trove/TIntObjectHashMap;", "getProject$intellij_js_liveEdit", "()Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/xml/XmlFile;", "getPsiFile$intellij_js_liveEdit", "()Lcom/intellij/psi/xml/XmlFile;", "setPsiFile$intellij_js_liveEdit", "(Lcom/intellij/psi/xml/XmlFile;)V", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getTextEditor$intellij_js_liveEdit", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setTextEditor$intellij_js_liveEdit", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "updateQueue", "Lcom/jetbrains/liveEdit/elementsInspector/UpdateQueue;", "addDomChangeListeners", "", "map", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "addElementHighlighter", "highlightExecutor", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "buildStringRepresentation", "nodes", "", "Lorg/jetbrains/wip/protocol/dom/NodeValue;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nodeIdToOffset", "Lcom/intellij/openapi/util/Segment;", "newLineBeforeTag", "", "buildStringRepresentation$intellij_js_liveEdit", "buildTag", "node", "nodeName", "", "clearQueueAndState", "createEditor", "charSequence", "", "createPointers", "insertionOffset", "createPointers$intellij_js_liveEdit", "dispose", "initAndLoadDocument", "loadDocument", "isAfterUpdate", "reloadDocument", "requestChildNodes", "id", "requestChildNodes$intellij_js_liveEdit", "setReadOnly", "value", "ActualDomElementHighlighterOnCaretChange", "ElementsRunnerContentProvider", "intellij.js.liveEdit"})
public final class ElementsView
implements Disposable {
    @Nullable
    private WipCommandProcessor commandProcessor;
    private final JPanel editorWrapper;
    @Nullable
    private volatile TextEditor textEditor;
    @Nullable
    private volatile XmlFile psiFile;
    private final UpdateQueue updateQueue;
    private final AtomicBoolean documentInitialized;
    private final InspectorStructureViewWrapper inspectorStructureViewWrapper;
    private VmConnection<Vm> connection;
    @NotNull
    private final Project project;
    private DebuggableFileFinder finder;

    @Nullable
    public final WipCommandProcessor getCommandProcessor$intellij_js_liveEdit() {
        return this.commandProcessor;
    }

    public final void setCommandProcessor$intellij_js_liveEdit(@Nullable WipCommandProcessor wipCommandProcessor) {
        this.commandProcessor = wipCommandProcessor;
    }

    @Nullable
    public final TextEditor getTextEditor$intellij_js_liveEdit() {
        return this.textEditor;
    }

    public final void setTextEditor$intellij_js_liveEdit(@Nullable TextEditor textEditor) {
        this.textEditor = textEditor;
    }

    @Nullable
    public final XmlFile getPsiFile$intellij_js_liveEdit() {
        return this.psiFile;
    }

    public final void setPsiFile$intellij_js_liveEdit(@Nullable XmlFile xmlFile) {
        this.psiFile = xmlFile;
    }

    @NotNull
    public final TIntObjectHashMap<RangeMarker> getNodeIdToRangeMarker$intellij_js_liveEdit() {
        TIntObjectHashMap tIntObjectHashMap = this.getDocumentModel();
        if (tIntObjectHashMap == null || (tIntObjectHashMap = tIntObjectHashMap.getNodeIdToRangeMarker$intellij_js_liveEdit()) == null) {
            tIntObjectHashMap = new TIntObjectHashMap();
        }
        return tIntObjectHashMap;
    }

    public final int getDocumentId$intellij_js_liveEdit() {
        WipDocumentModelManager wipDocumentModelManager = this.getDocumentModel();
        return wipDocumentModelManager != null ? wipDocumentModelManager.getDocumentId() : -1;
    }

    public final void setDocumentId$intellij_js_liveEdit(int newId) {
        block0: {
            WipDocumentModelManager wipDocumentModelManager = this.getDocumentModel();
            if (wipDocumentModelManager == null) break block0;
            wipDocumentModelManager.setDocumentId(newId);
        }
    }

    private final WipDocumentModelManager getDocumentModel() {
        WipDocumentModelManager wipDocumentModelManager;
        Vm vm = this.connection;
        if (vm != null && (vm = vm.getVm()) != null) {
            Vm vm2;
            Vm it;
            Vm vm3 = it = (vm2 = vm);
            if (vm3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
            }
            wipDocumentModelManager = WipDocumentModelManager.Companion.getForVm((WipVm)vm3);
        } else {
            wipDocumentModelManager = null;
        }
        return wipDocumentModelManager;
    }

    @NotNull
    public final DocumentEx getDocument$intellij_js_liveEdit() {
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        Editor editor = textEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor!!.editor");
        Document document = editor.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
        }
        return (DocumentEx)document;
    }

    private final void initAndLoadDocument() {
        if (this.documentInitialized.compareAndSet(false, true)) {
            WipCommandProcessor wipCommandProcessor = this.commandProcessor;
            if (wipCommandProcessor == null) {
                Intrinsics.throwNpe();
            }
            this.addDomChangeListeners((EventMap<ProtocolResponseReader>)wipCommandProcessor.getEventMap());
            this.loadDocument(false);
        }
    }

    private final void addDomChangeListeners(EventMap<ProtocolResponseReader> map) {
        map.add((EventType)DocumentUpdatedEventData.TYPE, (Function1)new Function1<DocumentUpdatedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@Nullable DocumentUpdatedEventData it) {
                this.this$0.reloadDocument();
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.addMulti(new EventType[]{(EventType)AttributeModifiedEventData.TYPE, (EventType)AttributeRemovedEventData.TYPE, (EventType)CharacterDataModifiedEventData.TYPE, (EventType)ChildNodeRemovedEventData.TYPE, (EventType)ChildNodeCountUpdatedEventData.TYPE}, (Function1)new Function1<NodeIdentifiable, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull NodeIdentifiable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).add(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)ChildNodeInsertedEventData.TYPE, (Function1)new Function1<ChildNodeInsertedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull ChildNodeInsertedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).childNodeInserted(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)InlineStyleInvalidatedEventData.TYPE, (Function1)new Function1<InlineStyleInvalidatedEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull InlineStyleInvalidatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).inlineStyleInvalidated(it.nodeIds());
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
        map.add((EventType)SetChildNodesEventData.TYPE, (Function1)new Function1<SetChildNodesEventData, Unit>(this){
            final /* synthetic */ ElementsView this$0;

            public final void invoke(@NotNull SetChildNodesEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ElementsView.access$getUpdateQueue$p(this.this$0).childNodesSet(it);
            }
            {
                this.this$0 = elementsView;
                super(1);
            }
        });
    }

    public final void reloadDocument() {
        this.clearQueueAndState();
        this.loadDocument(true);
    }

    private final void loadDocument(boolean isAfterUpdate) {
        block0: {
            Object object = this.getDocumentModel();
            if (object == null || (object = ((WipDocumentModelManager)object).loadDocument(isAfterUpdate)) == null) break block0;
            ((CompletableFuture)object).thenAccept(new Consumer<GetDocumentResult>(this){
                final /* synthetic */ ElementsView this$0;

                public final void accept(GetDocumentResult result) {
                    CharSequence charSequence = result.root().getDocumentURL();
                    if (charSequence == null || charSequence.length() == 0) {
                        return;
                    }
                    AppUIUtil.invokeLaterIfProjectAlive((Project)this.this$0.getProject$intellij_js_liveEdit(), (Runnable)new Runnable(this, result){
                        final /* synthetic */ loadDocument.1 this$0;
                        final /* synthetic */ GetDocumentResult $result;

                        public final void run() {
                            StringBuilder builder = new StringBuilder();
                            TIntObjectHashMap nodeIdToOffset = new TIntObjectHashMap();
                            ElementsView elementsView = this.this$0.this$0;
                            List list = this.$result.root().getChildren();
                            if (list == null) {
                                Intrinsics.throwNpe();
                            }
                            elementsView.buildStringRepresentation$intellij_js_liveEdit(list, builder, (TIntObjectHashMap<Segment>)nodeIdToOffset, false);
                            if (this.this$0.this$0.getTextEditor$intellij_js_liveEdit() == null) {
                                ElementsView.access$createEditor(this.this$0.this$0, builder, nodeIdToOffset);
                            } else {
                                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this, builder, nodeIdToOffset){
                                    final /* synthetic */ loadDocument.1 this$0;
                                    final /* synthetic */ StringBuilder $builder;
                                    final /* synthetic */ TIntObjectHashMap $nodeIdToOffset;

                                    public final void run() {
                                        DocumentEx document = this.this$0.this$0.this$0.getDocument$intellij_js_liveEdit();
                                        document.setText((CharSequence)this.$builder);
                                        this.this$0.this$0.this$0.createPointers$intellij_js_liveEdit((TIntObjectHashMap<Segment>)this.$nodeIdToOffset, 0);
                                        PsiDocumentManager.getInstance((Project)this.this$0.this$0.this$0.getProject$intellij_js_liveEdit()).commitDocument((Document)document);
                                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.this$0.this$0.this$0.getProject$intellij_js_liveEdit());
                                        XmlFile xmlFile = this.this$0.this$0.this$0.getPsiFile$intellij_js_liveEdit();
                                        if (xmlFile == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        codeStyleManager.reformat((PsiElement)xmlFile, true);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$builder = stringBuilder;
                                        this.$nodeIdToOffset = tIntObjectHashMap;
                                    }
                                });
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = getDocumentResult;
                        }
                    });
                }
                {
                    this.this$0 = elementsView;
                }
            });
        }
    }

    public final void buildStringRepresentation$intellij_js_liveEdit(@NotNull List<? extends NodeValue> nodes, @NotNull StringBuilder builder, @NotNull TIntObjectHashMap<Segment> nodeIdToOffset, boolean newLineBeforeTag) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(nodeIdToOffset, (String)"nodeIdToOffset");
        boolean newLineBeforeTag2 = newLineBeforeTag;
        block8: for (NodeValue nodeValue : nodes) {
            String nodeName = nodeValue.nodeName();
            if (!StringUtil.isEmpty((String)nodeName)) {
                Locale locale;
                String string = nodeName;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                nodeName = string3;
            }
            switch ((short)nodeValue.getNodeType()) {
                case 1: {
                    if (newLineBeforeTag2) {
                        if (!HtmlUtil.isPossiblyInlineTag((String)nodeName)) {
                            builder.append('\n');
                        }
                    } else {
                        newLineBeforeTag2 = true;
                    }
                    this.buildTag(builder, nodeIdToOffset, nodeValue, nodeName);
                    continue block8;
                }
                case 3: {
                    int start = builder.length();
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    nodeIdToOffset.put(nodeValue.getNodeId(), (Object)new TextRange(start, builder.length()));
                    continue block8;
                }
                case 2: {
                    builder.append(' ');
                    builder.append(nodeValue.getName());
                    ElementsViewKt.appendAttributeValue(nodeValue.getValue(), builder);
                    continue block8;
                }
                case 8: {
                    if (newLineBeforeTag2) {
                        builder.append('\n');
                    } else {
                        newLineBeforeTag2 = true;
                    }
                    builder.append("<!--");
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    builder.append("-->");
                    continue block8;
                }
                case 10: {
                    builder.append("<!DOCTYPE ").append(nodeName);
                    if (!StringUtil.isEmpty((String)nodeValue.getPublicId())) {
                        builder.append(" PUBLIC \"").append(nodeValue.getPublicId()).append('\"');
                        if (nodeValue.getSystemId() != null) {
                            builder.append(' ').append('\"').append(nodeValue.getSystemId()).append('\"');
                        }
                    } else if (!StringUtil.isEmpty((String)nodeValue.getSystemId())) {
                        builder.append(" SYSTEM \"").append(nodeValue.getPublicId()).append('\"');
                    }
                    if (!StringUtil.isEmpty((String)nodeValue.getInternalSubset())) {
                        builder.append(' ').append('[').append(nodeValue.getInternalSubset()).append(']');
                    }
                    builder.append('>');
                    continue block8;
                }
                case 4: {
                    builder.append("<![CDATA[");
                    ElementsViewKt.convertLineSeparators(nodeValue.nodeValue(), builder);
                    builder.append("]]>");
                    continue block8;
                }
            }
            builder.append(CharMatcher.whitespace().collapseFrom((CharSequence)nodeName, ' '));
        }
    }

    private final void buildTag(StringBuilder builder, TIntObjectHashMap<Segment> nodeIdToOffset, NodeValue node, String nodeName) {
        boolean hasAttributes;
        builder.append('<').append(nodeName);
        List attributes = node.getAttributes();
        boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            int i = 0;
            while (true) {
                List list = attributes;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (i >= list.size()) break;
                String name = (String)attributes.get(i);
                String value = StringUtil.nullize((String)((String)attributes.get(i + 1)));
                if (value == null && Intrinsics.areEqual((Object)"style", (Object)name)) {
                    i += 2;
                    continue;
                }
                builder.append(' ');
                builder.append(name);
                ElementsViewKt.appendAttributeValue(value, builder);
                i += 2;
            }
        }
        int start = builder.length();
        if (HtmlUtil.isSingleHtmlTag((String)nodeName)) {
            builder.append('/').append('>');
            nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
            return;
        }
        builder.append('>');
        if (node.getChildren() == null) {
            this.requestChildNodes$intellij_js_liveEdit(node.getNodeId());
        } else {
            List list = node.getChildren();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            if (!list.isEmpty()) {
                List list2 = node.getChildren();
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                this.buildStringRepresentation$intellij_js_liveEdit(list2, builder, nodeIdToOffset, true);
            }
        }
        builder.append('<').append('/').append(nodeName).append('>');
        nodeIdToOffset.put(node.getNodeId(), (Object)new TextRange(start, builder.length()));
    }

    public final void requestChildNodes$intellij_js_liveEdit(int id) {
        WipCommandProcessor wipCommandProcessor = this.commandProcessor;
        if (wipCommandProcessor == null) {
            Intrinsics.throwNpe();
        }
        wipCommandProcessor.send((Request)DOMKt.RequestChildNodes$default((int)id, (Integer)-1, null, (int)4, null));
    }

    public final void createPointers$intellij_js_liveEdit(@NotNull TIntObjectHashMap<Segment> nodeIdToOffset, int insertionOffset) {
        Intrinsics.checkParameterIsNotNull(nodeIdToOffset, (String)"nodeIdToOffset");
        DocumentEx document = this.getDocument$intellij_js_liveEdit();
        nodeIdToOffset.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Segment>(this, document, insertionOffset){
            final /* synthetic */ ElementsView this$0;
            final /* synthetic */ DocumentEx $document;
            final /* synthetic */ int $insertionOffset;

            public final boolean execute(int nodeId, Segment range) {
                TIntObjectHashMap<RangeMarker> tIntObjectHashMap = this.this$0.getNodeIdToRangeMarker$intellij_js_liveEdit();
                Segment segment = range;
                Intrinsics.checkExpressionValueIsNotNull((Object)segment, (String)"range");
                tIntObjectHashMap.put(nodeId, (Object)this.$document.createRangeMarker(this.$insertionOffset + segment.getStartOffset(), this.$insertionOffset + range.getEndOffset()));
                return true;
            }
            {
                this.this$0 = elementsView;
                this.$document = documentEx;
                this.$insertionOffset = n;
            }
        });
    }

    private final void createEditor(CharSequence charSequence, TIntObjectHashMap<Segment> nodeIdToOffset) {
        VirtualFile realFile;
        VirtualFile virtualFile;
        Vm vm;
        Url currentUrl;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("", (Language)HTMLLanguage.INSTANCE, charSequence, true, false);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        }
        XmlFile xmlFile = this.psiFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            Intrinsics.throwNpe();
        }
        FileViewProvider fileViewProvider = xmlFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile!!.viewProvider");
        VirtualFile virtualFile2 = fileViewProvider.getVirtualFile();
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, virtualFile2);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        this.textEditor = (TextEditor)fileEditor;
        this.createPointers$intellij_js_liveEdit(nodeIdToOffset, 0);
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        Url url = currentUrl = (vm = vmConnection.getVm()) == null ? null : ((WipVm)vm).getCurrentUrl();
        if (currentUrl == null) {
            virtualFile = null;
        } else {
            DebuggableFileFinder debuggableFileFinder = this.finder;
            if (debuggableFileFinder == null) {
                Intrinsics.throwNpe();
            }
            virtualFile = realFile = DebuggableFileFinder.DefaultImpls.findFile$default((DebuggableFileFinder)debuggableFileFinder, (Url)currentUrl, (Project)this.project, (boolean)false, null, null, (int)28, null);
        }
        if (realFile != null) {
            PsiFile originalFile;
            if (this.psiFile instanceof PsiFileImpl && (originalFile = PsiManager.getInstance((Project)this.project).findFile(realFile)) != null) {
                XmlFile xmlFile2 = this.psiFile;
                if (xmlFile2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                }
                ((PsiFileImpl)xmlFile2).setOriginalFile(originalFile);
            }
            InspectorFileReferenceHelper.registerFile(virtualFile2, realFile);
        }
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this){
            final /* synthetic */ ElementsView this$0;

            public final void run() {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.this$0.getProject$intellij_js_liveEdit());
                XmlFile xmlFile = this.this$0.getPsiFile$intellij_js_liveEdit();
                if (xmlFile == null) {
                    Intrinsics.throwNpe();
                }
                codeStyleManager.reformat((PsiElement)xmlFile, true);
            }
            {
                this.this$0 = elementsView;
            }
        });
        this.setReadOnly(true);
        XmlFile xmlFile3 = this.psiFile;
        if (xmlFile3 == null) {
            Intrinsics.throwNpe();
        }
        FileViewProvider fileViewProvider2 = xmlFile3.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider2, (String)"psiFile!!.viewProvider");
        StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)fileViewProvider2.getVirtualFile(), (Object)this.inspectorStructureViewWrapper);
        this.inspectorStructureViewWrapper.setTextEditor(this.textEditor);
        InspectorElementHighlightExecutor highlightExecutor = new InspectorElementHighlightExecutor(this);
        LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)this.psiFile, (Object)highlightExecutor);
        this.addElementHighlighter(highlightExecutor);
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        this.editorWrapper.add((Component)textEditor.getComponent(), "Center");
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ ElementsView this$0;

            public final void run() {
                ElementsView.access$getEditorWrapper$p(this.this$0).revalidate();
                ElementsView.access$getEditorWrapper$p(this.this$0).repaint();
            }
            {
                this.this$0 = elementsView;
            }
        });
    }

    private final void addElementHighlighter(InspectorElementHighlightExecutor highlightExecutor) {
        ActualDomElementHighlighterOnCaretChange listener = new ActualDomElementHighlighterOnCaretChange(highlightExecutor);
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        Editor editor = textEditor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor!!.editor");
        editor.getCaretModel().addCaretListener((CaretListener)listener);
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        Disposer.register((Disposable)((Disposable)vmConnection), (Disposable)new Disposable(this, listener){
            final /* synthetic */ ElementsView this$0;
            final /* synthetic */ ActualDomElementHighlighterOnCaretChange $listener;

            public void dispose() {
                if (this.this$0.getTextEditor$intellij_js_liveEdit() != null) {
                    TextEditor textEditor = this.this$0.getTextEditor$intellij_js_liveEdit();
                    if (textEditor == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$listener.dispose(textEditor.getEditor());
                }
            }
            {
                this.this$0 = $outer;
                this.$listener = $captured_local_variable$1;
            }
        });
    }

    private final void setReadOnly(boolean value) {
        TextEditor textEditor = this.textEditor;
        if (textEditor == null) {
            Intrinsics.throwNpe();
        }
        Editor editor = textEditor.getEditor();
        if (editor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        ((EditorEx)editor).setRendererMode(value);
    }

    public void dispose() {
        this.clearQueueAndState();
        TextEditor editor = this.textEditor;
        if (editor != null) {
            this.textEditor = null;
            XmlFile xmlFile = this.psiFile;
            if (xmlFile == null) {
                Intrinsics.throwNpe();
            }
            FileViewProvider fileViewProvider = xmlFile.getViewProvider();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile!!.viewProvider");
            StructureViewSelectInTarget.CUSTOM_STRUCTURE_VIEW_KEY.set((UserDataHolder)fileViewProvider.getVirtualFile(), null);
            LiveEditElementPreviewProvider.CUSTOM_HIGHLIGHT_EXECUTOR_KEY.set((UserDataHolder)this.psiFile, null);
            this.psiFile = null;
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, editor){
                final /* synthetic */ ElementsView this$0;
                final /* synthetic */ TextEditor $editor;

                public final void run() {
                    ElementsView.access$getEditorWrapper$p(this.this$0).removeAll();
                    TextEditorProvider.getInstance().disposeEditor((FileEditor)this.$editor);
                }
                {
                    this.this$0 = elementsView;
                    this.$editor = textEditor;
                }
            });
        }
    }

    private final void clearQueueAndState() {
        this.setDocumentId$intellij_js_liveEdit(-1);
        this.updateQueue.clear();
        this.getNodeIdToRangeMarker$intellij_js_liveEdit().clear();
    }

    @NotNull
    public final Project getProject$intellij_js_liveEdit() {
        return this.project;
    }

    public ElementsView(@Nullable VmConnection<Vm> connection, @NotNull Project project, @Nullable DebuggableFileFinder finder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.connection = connection;
        this.project = project;
        this.finder = finder;
        this.editorWrapper = new JPanel(new BorderLayout());
        this.documentInitialized = new AtomicBoolean();
        VmConnection<Vm> vmConnection = this.connection;
        if (vmConnection == null) {
            Intrinsics.throwNpe();
        }
        vmConnection.stateChanged((Function1)new Function1<ConnectionState, Unit>(){

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getStatus() == ConnectionStatus.CONNECTED) {
                    if (this.getCommandProcessor$intellij_js_liveEdit() == null) {
                        VmConnection vmConnection = connection;
                        if (vmConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        Vm vm = vmConnection.getVm();
                        if (vm == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
                        }
                        this.setCommandProcessor$intellij_js_liveEdit(((WipVm)vm).getCommandProcessor());
                        WipCommandProcessor wipCommandProcessor = this.getCommandProcessor$intellij_js_liveEdit();
                        if (wipCommandProcessor == null) {
                            Intrinsics.throwNpe();
                        }
                        wipCommandProcessor.getEventMap().add((EventType)DomContentEventFiredEventData.TYPE, (Function1)new Function1<DomContentEventFiredEventData, Unit>(){

                            public final void invoke(@NotNull DomContentEventFiredEventData it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                this.initAndLoadDocument();
                            }
                        });
                    }
                } else if (it.getStatus() != ConnectionStatus.WAITING_FOR_CONNECTION) {
                    connection = null;
                    finder = null;
                }
            }
        });
        VmConnection<Vm> vmConnection2 = this.connection;
        if (vmConnection2 == null) {
            Intrinsics.throwNpe();
        }
        if (vmConnection2.getState().getStatus() == ConnectionStatus.CONNECTED) {
            VmConnection<Vm> vmConnection3 = this.connection;
            if (vmConnection3 == null) {
                Intrinsics.throwNpe();
            }
            Vm vm = vmConnection3.getVm();
            if (vm == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipVm");
            }
            this.commandProcessor = ((WipVm)vm).getCommandProcessor();
            this.initAndLoadDocument();
        }
        this.editorWrapper.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){
            private final AtomicBoolean panelShown = new AtomicBoolean();

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (this.panelShown.compareAndSet(false, true)) {
                    editorWrapper.removeAncestorListener((AncestorListener)((Object)this));
                    this.initAndLoadDocument();
                }
            }
        });
        this.inspectorStructureViewWrapper = new InspectorStructureViewWrapper(this);
        this.updateQueue = new UpdateQueue(this, this.project);
    }

    @NotNull
    public static final /* synthetic */ UpdateQueue access$getUpdateQueue$p(ElementsView $this) {
        return $this.updateQueue;
    }

    public static final /* synthetic */ void access$createEditor(ElementsView $this, @NotNull CharSequence charSequence, @NotNull TIntObjectHashMap nodeIdToOffset) {
        $this.createEditor(charSequence, (TIntObjectHashMap<Segment>)nodeIdToOffset);
    }

    @Nullable
    public static final /* synthetic */ DebuggableFileFinder access$getFinder$p(ElementsView $this) {
        return $this.finder;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ElementsRunnerContentProvider;", "Lcom/intellij/javascript/debugger/RunnerContentProvider;", "()V", "registerContent", "", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "tabIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.js.liveEdit"})
    private static final class ElementsRunnerContentProvider
    implements RunnerContentProvider {
        public void registerContent(@NotNull RunnerLayoutUi ui, @NotNull JavaScriptDebugProcess<? extends VmConnection<Vm>> debugProcess, @NotNull AtomicInteger tabIdCounter) {
            Content elementsViewContent;
            Content structureViewContent;
            Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
            Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)tabIdCounter, (String)"tabIdCounter");
            if (!debugProcess.getElementsInspectorEnabled()) {
                return;
            }
            int tabId = tabIdCounter.incrementAndGet();
            LayoutStateDefaults layoutStateDefaults = ui.getDefaults();
            HtmlFileType htmlFileType = HtmlFileType.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)htmlFileType, (String)"HtmlFileType.INSTANCE");
            layoutStateDefaults.initTabDefaults(tabId, "Elements", htmlFileType.getIcon());
            VmConnection vmConnection = debugProcess.getConnection();
            XDebugSession xDebugSession = debugProcess.getSession();
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
            Project project = xDebugSession.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            ElementsView elementsView = new ElementsView((VmConnection<Vm>)vmConnection, project, debugProcess.getFinder());
            Disposer.register((Disposable)((Disposable)ui.getContentManager()), (Disposable)elementsView);
            String string = ElementsViewKt.access$getTEXT_CONTENT_ID$p();
            JComponent jComponent = elementsView.inspectorStructureViewWrapper.getComponent();
            HtmlFileType htmlFileType2 = HtmlFileType.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)htmlFileType2, (String)"HtmlFileType.INSTANCE");
            Content content = structureViewContent = ui.createContent(string, jComponent, "Structure", htmlFileType2.getIcon(), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"structureViewContent");
            content.setCloseable(false);
            ui.addContent(structureViewContent, tabId, PlaceInGrid.left, false);
            Content content2 = elementsViewContent = ui.createContent(ElementsViewKt.access$getSTRUCTURE_CONTENT_ID$p(), (JComponent)elementsView.editorWrapper, "Text", null, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"elementsViewContent");
            content2.setCloseable(false);
            ui.addContent(elementsViewContent, tabId, PlaceInGrid.center, false);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/liveEdit/elementsInspector/ElementsView$ActualDomElementHighlighterOnCaretChange;", "Lcom/jetbrains/liveEdit/highlighting/ElementHighlighterOnCaretChangeBase;", "highlightExecutor", "Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;", "(Lcom/jetbrains/liveEdit/elementsInspector/ElementsView;Lcom/jetbrains/liveEdit/elementsInspector/InspectorElementHighlightExecutor;)V", "run", "", "intellij.js.liveEdit"})
    private final class ActualDomElementHighlighterOnCaretChange
    extends ElementHighlighterOnCaretChangeBase {
        @Override
        public void run() {
            if (!ElementHighlighter.isHighlightingNeed()) {
                return;
            }
            TextEditor textEditor = ElementsView.this.getTextEditor$intellij_js_liveEdit();
            if (textEditor == null) {
                Intrinsics.throwNpe();
            }
            this.highlightExecutor.highlight(textEditor.getEditor(), ElementsView.this.getProject$intellij_js_liveEdit(), null);
        }

        public ActualDomElementHighlighterOnCaretChange(InspectorElementHighlightExecutor highlightExecutor) {
            Intrinsics.checkParameterIsNotNull((Object)highlightExecutor, (String)"highlightExecutor");
            super(highlightExecutor);
        }
    }
}

