/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.update.RemoteCssStyleSheet;
import com.jetbrains.liveEdit.update.SetSourceExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.SetStyleTextsResult;
import org.jetbrains.wip.protocol.css.SourceRange;
import org.jetbrains.wip.protocol.css.StyleDeclarationEdit;

public final class CssHelper {
    @NotNull
    public static SetSourceExecutor createSetSourceExecutor(final @NotNull List<RemoteCssStyleSheet> styleSheets, final @NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (styleSheets == null) {
            CssHelper.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            CssHelper.$$$reportNull$$$0(1);
        }
        SetSourceExecutor setSourceExecutor = new SetSourceExecutor(){

            @Override
            @NotNull
            public List<Promise<?>> execute(@NotNull VirtualFile file, @NotNull CharSequence source) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (source == null) {
                    1.$$$reportNull$$$0(1);
                }
                SmartList callbacks = null;
                for (RemoteCssStyleSheet styleSheet : styleSheets) {
                    if (!CssHelper.sourceEquals(file, styleSheet.url, styleSheet.project, debugProcess.getFinder())) continue;
                    if (callbacks == null) {
                        callbacks = new SmartList();
                    }
                    callbacks.add(styleSheet.commandProcessor.send((Request)CSSKt.SetStyleSheetText((CharSequence)styleSheet.descriptor.styleSheetId(), (CharSequence)source)));
                    styleSheet.removeIncrementalUpdates();
                }
                List<Object> list = callbacks == null ? Collections.emptyList() : callbacks;
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/liveEdit/update/CssHelper$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/liveEdit/update/CssHelper$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (setSourceExecutor == null) {
            CssHelper.$$$reportNull$$$0(2);
        }
        return setSourceExecutor;
    }

    private static boolean sourceEquals(@NotNull VirtualFile file, @NotNull Url remoteUrl, @NotNull Project project, @NotNull DebuggableFileFinder fileFinder) {
        if (file == null) {
            CssHelper.$$$reportNull$$$0(3);
        }
        if (remoteUrl == null) {
            CssHelper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            CssHelper.$$$reportNull$$$0(5);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(6);
        }
        return file.equals(fileFinder.findFile(remoteUrl, project, true, null, null)) || Urls.equalsIgnoreParameters((Url)remoteUrl, (Collection)fileFinder.getRemoteUrls(file), (boolean)SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    private static SourceRange getSourceRange(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            CssHelper.$$$reportNull$$$0(7);
        }
        if (element == null) {
            CssHelper.$$$reportNull$$$0(8);
        }
        int start = element.getNode().getStartOffset();
        int end = start + element.getNode().getTextLength();
        int startLine = document.getLineNumber(start);
        int startColumn = start - document.getLineStartOffset(startLine);
        int endLine = document.getLineNumber(end);
        int endColumn = end - document.getLineStartOffset(endLine);
        SourceRange sourceRange = new SourceRange(startLine, startColumn, endLine, endColumn + 1);
        if (sourceRange == null) {
            CssHelper.$$$reportNull$$$0(9);
        }
        return sourceRange;
    }

    private static boolean compareSelectorList(@Nullable CssSelectorList local, @Nullable CssSelectorList remote) {
        CssSelector[] remoteSelectors;
        if (local == null || remote == null) {
            return false;
        }
        CssSelector[] localSelectors = local.getSelectors();
        if (localSelectors.length != (remoteSelectors = remote.getSelectors()).length) {
            return false;
        }
        int n = remoteSelectors.length;
        for (int i = 0; i < n; ++i) {
            PsiElement[] remoteSelectorElements;
            CssSelector localSelector = localSelectors[i];
            CssSelector remoteSelector = remoteSelectors[i];
            if (localSelector.getSpecificity().compareTo((Object)remoteSelector.getSpecificity()) != 0) {
                return false;
            }
            PsiElement[] localSelectorElements = localSelector.getElements();
            if (localSelectorElements.length != (remoteSelectorElements = remoteSelector.getElements()).length) {
                return false;
            }
            for (int j = 0; j < localSelectorElements.length; ++j) {
                PsiElement localElement = localSelectorElements[j];
                if (localElement instanceof CssSimpleSelector && remoteSelectorElements[j] instanceof CssSimpleSelector) {
                    CssSimpleSelector localSelectorElement = (CssSimpleSelector)localElement;
                    CssSimpleSelector remoteSelectorElement = (CssSimpleSelector)localElement;
                    if (localSelectorElement.isUniversalSelector() == remoteSelectorElement.isUniversalSelector()) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Processor<RemoteCssStyleSheet> createSetCssPropertyProcessor(final @NotNull CssDeclaration localDeclaration, final @Nullable CharSequence value) {
        if (localDeclaration == null) {
            CssHelper.$$$reportNull$$$0(10);
        }
        Processor<RemoteCssStyleSheet> processor = new Processor<RemoteCssStyleSheet>(){

            public boolean process(RemoteCssStyleSheet styleSheet) {
                styleSheet.getFile().doWhenDone(remoteFile -> {
                    String newIdeaValue;
                    WipRequest message;
                    CssDeclaration remoteDeclaration;
                    if (localDeclaration == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    String styleSheetId = styleSheet.descriptor.styleSheetId();
                    AccessToken token = ReadAction.start();
                    try {
                        if (!localDeclaration.isValid()) {
                            return;
                        }
                        CssRuleset cssRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)localDeclaration, CssRuleset.class);
                        CssStylesheet cssStyleSheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)cssRuleset, CssStylesheet.class);
                        if (cssStyleSheet == null) {
                            return;
                        }
                        int sourceRulesetIndex = ArrayUtil.indexOf((Object[])cssStyleSheet.getRulesets(true), (Object)cssRuleset);
                        CssStylesheet remoteCssStylesheet = remoteFile.getStylesheet();
                        assert (remoteCssStylesheet != null);
                        CssRuleset[] remoteCssRulesets = remoteCssStylesheet.getRulesets(true);
                        if (sourceRulesetIndex >= remoteCssRulesets.length) {
                            return;
                        }
                        CssRuleset remoteRuleset = remoteCssRulesets[sourceRulesetIndex];
                        if (!CssHelper.compareSelectorList(cssRuleset.getSelectorList(), remoteRuleset.getSelectorList())) {
                            return;
                        }
                        String text = localDeclaration.getPropertyName() + ':' + (value == null ? "" : value) + ';';
                        Document document = styleSheet.document;
                        assert (document != null);
                        CssBlock remoteCssBlock = remoteRuleset.getBlock();
                        CssDeclaration cssDeclaration = remoteDeclaration = remoteCssBlock == null ? null : remoteCssBlock.findDeclaration(localDeclaration.getPropertyName(), false);
                        if (remoteDeclaration == null) {
                            if (remoteCssBlock == null) {
                                return;
                            }
                            int start = remoteCssBlock.getNode().getStartOffset();
                            int end = start + remoteCssBlock.getNode().getTextLength() - 1;
                            int endLine = document.getLineNumber(end);
                            int endColumn = end - document.getLineStartOffset(endLine);
                            StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, new SourceRange(endLine, endColumn, endLine, endColumn), (CharSequence)text);
                            message = CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit));
                        } else {
                            StyleDeclarationEdit styleDeclarationEdit = new StyleDeclarationEdit((CharSequence)styleSheetId, CssHelper.getSourceRange(document, (PsiElement)remoteDeclaration), (CharSequence)text);
                            message = CSSKt.SetStyleTexts(Collections.singletonList(styleDeclarationEdit));
                        }
                        CssTermList cssDeclarationValue = localDeclaration.getValue();
                        newIdeaValue = cssDeclarationValue == null ? null : cssDeclarationValue.getText();
                    }
                    finally {
                        token.finish();
                    }
                    this.doSendMessage((Request<SetStyleTextsResult>)message, newIdeaValue, remoteDeclaration, styleSheet);
                }).doWhenRejected(error -> ApplicationInspectorImplKt.getLOG().error("Cannot get PSI CSS file: " + (String)ObjectUtils.notNull((Object)error, (Object)"internal error")));
                return false;
            }

            private void doSendMessage(@NotNull Request<SetStyleTextsResult> message, @Nullable String newIdeaValue, @Nullable CssDeclaration remoteDeclaration, @NotNull RemoteCssStyleSheet styleSheet) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (styleSheet == null) {
                    2.$$$reportNull$$$0(1);
                }
                styleSheet.stopUpdates();
                styleSheet.commandProcessor.send(message).onSuccess(o -> {
                    if (styleSheet == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (RemoteCssStyleSheet.isNeedToGetTextAfterChange() || newIdeaValue == null || remoteDeclaration == null || !remoteDeclaration.isValid()) {
                        styleSheet.startUpdates(false);
                    } else {
                        styleSheet.addIncrementalUpdate(() -> remoteDeclaration.setValue(newIdeaValue));
                    }
                }).onError(throwable -> {
                    if (styleSheet == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    styleSheet.startUpdates(false);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "styleSheet";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localDeclaration";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/liveEdit/update/CssHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doSendMessage";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doSendMessage$4";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doSendMessage$3";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$process$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (processor == null) {
            CssHelper.$$$reportNull$$$0(11);
        }
        return processor;
    }

    @NotNull
    public static List<VirtualFile> collectEffective(@NotNull List<RemoteCssStyleSheet> list, @NotNull Collection<? extends VirtualFile> files, @NotNull Project project, @NotNull DebuggableFileFinder fileFinder) {
        if (list == null) {
            CssHelper.$$$reportNull$$$0(12);
        }
        if (files == null) {
            CssHelper.$$$reportNull$$$0(13);
        }
        if (project == null) {
            CssHelper.$$$reportNull$$$0(14);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(15);
        }
        List effectiveFiles = null;
        block0: for (VirtualFile virtualFile : files) {
            for (RemoteCssStyleSheet styleSheet : list) {
                if (!CssHelper.sourceEquals(virtualFile, styleSheet.url, project, fileFinder)) continue;
                if (effectiveFiles == null) {
                    effectiveFiles = new SmartList();
                }
                effectiveFiles.add(virtualFile);
                continue block0;
            }
        }
        List<Object> list2 = effectiveFiles == null ? Collections.emptyList() : effectiveFiles;
        if (list2 == null) {
            CssHelper.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public static void processStylesheets(@NotNull List<? extends RemoteCssStyleSheet> list, @NotNull VirtualFile file, @NotNull DebuggableFileFinder fileFinder, @NotNull Processor<? super RemoteCssStyleSheet> processor) {
        if (list == null) {
            CssHelper.$$$reportNull$$$0(17);
        }
        if (file == null) {
            CssHelper.$$$reportNull$$$0(18);
        }
        if (fileFinder == null) {
            CssHelper.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            CssHelper.$$$reportNull$$$0(20);
        }
        for (RemoteCssStyleSheet remoteCssStyleSheet : list) {
            if (!CssHelper.sourceEquals(file, remoteCssStyleSheet.url, remoteCssStyleSheet.project, fileFinder) || !processor.process((Object)remoteCssStyleSheet)) continue;
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleSheets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/update/CssHelper";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFinder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDeclaration";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/update/CssHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetSourceExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetCssPropertyProcessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectEffective";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSetSourceExecutor";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sourceEquals";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSetCssPropertyProcessor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectEffective";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processStylesheets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

