/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.webDeployment;

import com.intellij.javascript.debugger.browserConnection.PageService;
import com.intellij.util.PairProcessor;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentPageService
extends PageService {
    protected PairProcessor<String, String> createInspectablePredicate(@Nullable String projectId) {
        PairProcessor parentPredicate = super.createInspectablePredicate(projectId);
        List servers = GroupedServersConfigManagerImpl.getServersFromAllOpenProjects((boolean)false);
        if (servers.isEmpty()) {
            return parentPredicate;
        }
        URL[] urls = new URL[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            WebServerConfig server = (WebServerConfig)servers.get(i);
            try {
                urls[i] = server.validateUrl() == null ? new URL(server.getUrl()) : null;
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return (host, path) -> {
            for (URL url : urls) {
                if (url == null || !WebDeploymentPageService.compareHost(host, url.getHost()) || !url.getPath().isEmpty() && (path == null || !path.startsWith(url.getPath()))) continue;
                return true;
            }
            return parentPredicate.process(host, path);
        };
    }

    private static boolean compareHost(String host, String serverHost) {
        if (host.equalsIgnoreCase(serverHost)) {
            return true;
        }
        int lastDotIndex = host.length() - serverHost.length() - 1;
        return lastDotIndex > 0 && host.charAt(lastDotIndex) == '.' && host.endsWith(serverHost);
    }
}

