/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Tarjan;

public class Graph<T> {
    private static boolean m_verbose = false;
    private Map<T, Node<T>> m_nodes = Maps.newLinkedHashMap();
    private List<T> m_strictlySortedNodes = null;
    private final Comparator<Node<T>> comparator;
    private Map<T, Node<T>> m_independentNodes = null;

    public Graph(Comparator<Node<T>> comparator) {
        this.comparator = comparator;
    }

    public void addNode(T tm) {
        Graph.ppp("ADDING NODE " + tm + " " + tm.hashCode());
        this.m_nodes.put(tm, new Node<T>(tm));
    }

    public Set<T> getPredecessors(T node) {
        return this.findNode(node).getPredecessors().keySet();
    }

    public boolean isIndependent(T object) {
        return this.m_independentNodes.containsKey(object);
    }

    private Node<T> findNode(T object) {
        return this.m_nodes.get(object);
    }

    public void addPredecessor(T tm, T predecessor) {
        Node<T> node = this.findNode(tm);
        if (null == node) {
            throw new TestNGException("Non-existing node: " + tm);
        }
        node.addPredecessor(predecessor);
        this.addNeighbor(tm, predecessor);
        this.initializeIndependentNodes();
        this.m_independentNodes.remove(predecessor);
        this.m_independentNodes.remove(tm);
        Graph.ppp("  REMOVED " + predecessor + " FROM INDEPENDENT OBJECTS");
    }

    private void addNeighbor(T tm, T predecessor) {
        this.findNode(tm).addNeighbor(this.findNode(predecessor));
    }

    public Set<T> getNeighbors(T t) {
        HashSet<T> result = new HashSet<T>();
        for (Node<T> n : this.findNode(t).getNeighbors()) {
            result.add(n.getObject());
        }
        return result;
    }

    private Collection<Node<T>> getNodes() {
        return this.m_nodes.values();
    }

    public Collection<T> getNodeValues() {
        return this.m_nodes.keySet();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.ppp("================ SORTING");
        this.m_strictlySortedNodes = Lists.newArrayList();
        this.initializeIndependentNodes();
        List<Node<T>> nodes2 = Lists.newArrayList();
        for (Node<T> n : this.getNodes()) {
            if (!this.isIndependent(n.getObject())) {
                Graph.ppp("ADDING FOR SORT: " + n.getObject());
                nodes2.add((Node<T>)n.clone());
                continue;
            }
            Graph.ppp("SKIPPING INDEPENDENT NODE " + n);
        }
        Collections.sort(nodes2, this.comparator);
        while (!nodes2.isEmpty()) {
            Node<T> node = this.findNodeWithNoPredecessors(nodes2);
            if (null == node) {
                List<T> cycle = new Tarjan<T>(this, nodes2.get(0).getObject()).getCycle();
                StringBuilder sb = new StringBuilder();
                sb.append("The following methods have cyclic dependencies:\n");
                for (T m : cycle) {
                    sb.append(m).append("\n");
                }
                throw new TestNGException(sb.toString());
            }
            this.m_strictlySortedNodes.add(node.getObject());
            this.removeFromNodes(nodes2, node);
        }
        Graph.ppp("=============== DONE SORTING");
        if (m_verbose) {
            this.dumpSortedNodes();
        }
    }

    private void initializeIndependentNodes() {
        if (null == this.m_independentNodes) {
            List<Node<T>> list = Lists.newArrayList(this.m_nodes.values());
            Collections.sort(list, this.comparator);
            this.m_independentNodes = Maps.newLinkedHashMap();
            for (Node<T> node : list) {
                this.m_independentNodes.put(node.getObject(), node);
            }
        }
    }

    private void dumpSortedNodes() {
        System.out.println("====== SORTED NODES");
        for (T n : this.m_strictlySortedNodes) {
            System.out.println("              " + n);
        }
        System.out.println("====== END SORTED NODES");
    }

    private void removeFromNodes(List<Node<T>> nodes, Node<T> node) {
        nodes.remove(node);
        for (Node<T> n : nodes) {
            n.removePredecessor(node.getObject());
        }
    }

    private static void ppp(String s) {
        if (m_verbose) {
            System.out.println("[Graph] " + s);
        }
    }

    private Node<T> findNodeWithNoPredecessors(List<Node<T>> nodes) {
        for (Node<T> n : nodes) {
            if (n.hasPredecessors()) continue;
            return n;
        }
        return null;
    }

    public List<T> findPredecessors(T o) {
        Node<T> node = this.findNode(o);
        if (null == node) {
            return Lists.newArrayList();
        }
        LinkedList result = new LinkedList();
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        visited.add(o);
        queue.addLast(o);
        while (!queue.isEmpty()) {
            for (Object obj : this.getPredecessors(queue.removeFirst())) {
                if (visited.contains(obj)) continue;
                visited.add(obj);
                queue.addLast(obj);
                result.addFirst(obj);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Graph ");
        for (T node : this.m_nodes.keySet()) {
            result.append(this.findNode(node)).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static class Node<T> {
        private T m_object = null;
        private Map<T, T> m_predecessors = Maps.newHashMap();
        private Set<Node<T>> m_neighbors = new HashSet<Node<T>>();

        public Node(T tm) {
            this.m_object = tm;
        }

        public void addNeighbor(Node<T> neighbor) {
            this.m_neighbors.add(neighbor);
        }

        public Set<Node<T>> getNeighbors() {
            return this.m_neighbors;
        }

        public Node<T> clone() {
            Node<T> result = new Node<T>(this.m_object);
            for (T pred : this.m_predecessors.values()) {
                result.addPredecessor(pred);
            }
            return result;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T o) {
            boolean result = false;
            T pred = this.m_predecessors.get(o);
            if (null != pred) {
                boolean bl = result = null != this.m_predecessors.remove(o);
                if (result) {
                    Graph.ppp("  REMOVED PRED " + o + " FROM NODE " + this.m_object);
                } else {
                    Graph.ppp("  FAILED TO REMOVE PRED " + o + " FROM NODE " + this.m_object);
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[Node:" + this.m_object);
            sb.append("  pred:");
            for (T o : this.m_predecessors.values()) {
                sb.append(" ").append(o);
            }
            sb.append("]");
            String result = sb.toString();
            return result;
        }

        public void addPredecessor(T tm) {
            Graph.ppp("  ADDING PREDECESSOR FOR " + this.m_object + " ==> " + tm);
            this.m_predecessors.put(tm, tm);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }

        public boolean hasPredecessor(T m) {
            return this.m_predecessors.containsKey(m);
        }
    }
}

