/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Date;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class LazyPublishArtifact
implements PublishArtifact {
    private final Provider<?> provider;
    private final String version;
    private PublishArtifact delegate;

    public LazyPublishArtifact(Provider<?> provider) {
        this.provider = provider;
        this.version = null;
    }

    public LazyPublishArtifact(Provider<?> provider, String version) {
        this.provider = provider;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getExtension() {
        return this.getDelegate().getExtension();
    }

    @Override
    public String getType() {
        return this.getDelegate().getType();
    }

    @Override
    public String getClassifier() {
        return this.getDelegate().getClassifier();
    }

    @Override
    public File getFile() {
        return this.getDelegate().getFile();
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    private PublishArtifact getDelegate() {
        if (this.delegate == null) {
            Object value = this.provider.get();
            if (value instanceof FileSystemLocation) {
                FileSystemLocation location = (FileSystemLocation)value;
                this.delegate = this.fromFile(location.getAsFile());
            } else if (value instanceof File) {
                this.delegate = this.fromFile((File)value);
            } else if (value instanceof AbstractArchiveTask) {
                this.delegate = new ArchivePublishArtifact((AbstractArchiveTask)value);
            } else {
                throw new InvalidUserDataException(String.format("Cannot convert provided value (%s) to a file.", value));
            }
        }
        return this.delegate;
    }

    private DefaultPublishArtifact fromFile(File file) {
        ArtifactFile artifactFile = new ArtifactFile(file, this.version);
        return new DefaultPublishArtifact(artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Object[0]);
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                if (LazyPublishArtifact.this.provider instanceof TaskDependencyContainer) {
                    context.add(LazyPublishArtifact.this.provider);
                }
                if (LazyPublishArtifact.this.provider instanceof TaskProvider) {
                    context.add(LazyPublishArtifact.this.provider.get());
                }
            }
        };
    }
}

