/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Map;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryBlacklister;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;

public class ErrorHandlingModuleComponentRepository
implements ModuleComponentRepository {
    private final ModuleComponentRepository delegate;
    private final ErrorHandlingModuleComponentRepositoryAccess local;
    private final ErrorHandlingModuleComponentRepositoryAccess remote;

    public ErrorHandlingModuleComponentRepository(ModuleComponentRepository delegate, RepositoryBlacklister remoteRepositoryBlacklister) {
        this.delegate = delegate;
        this.local = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getLocalAccess(), this.getId(), RepositoryBlacklister.NoOpBlacklister.INSTANCE);
        this.remote = new ErrorHandlingModuleComponentRepositoryAccess(delegate.getRemoteAccess(), this.getId(), remoteRepositoryBlacklister);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ModuleComponentRepositoryAccess getLocalAccess() {
        return this.local;
    }

    @Override
    public ModuleComponentRepositoryAccess getRemoteAccess() {
        return this.remote;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        return this.delegate.getArtifactCache();
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private static final class ErrorHandlingModuleComponentRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        private static final String BLACKLISTED_REPOSITORY_ERROR_MESSAGE = "Skipped due to earlier error";
        private final ModuleComponentRepositoryAccess delegate;
        private final String repositoryId;
        private final RepositoryBlacklister repositoryBlacklister;

        private ErrorHandlingModuleComponentRepositoryAccess(ModuleComponentRepositoryAccess delegate, String repositoryId, RepositoryBlacklister repositoryBlacklister) {
            this.delegate = delegate;
            this.repositoryId = repositoryId;
            this.repositoryBlacklister = repositoryBlacklister;
        }

        public String toString() {
            return "error handling > " + this.delegate.toString();
        }

        @Override
        public void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed(new ModuleVersionResolveException((ComponentSelector)dependency.getSelector(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE));
                return;
            }
            try {
                this.delegate.listModuleVersions(dependency, result);
            }
            catch (Throwable throwable) {
                this.repositoryBlacklister.blacklistRepository(this.repositoryId, throwable);
                ModuleComponentSelector selector = dependency.getSelector();
                String message = "Failed to list versions for " + selector.getGroup() + ":" + selector.getModule() + ".";
                result.failed(new ModuleVersionResolveException(selector, message, throwable));
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed(new ModuleVersionResolveException(moduleComponentIdentifier, BLACKLISTED_REPOSITORY_ERROR_MESSAGE));
                return;
            }
            try {
                this.delegate.resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
            }
            catch (Throwable throwable) {
                this.repositoryBlacklister.blacklistRepository(this.repositoryId, throwable);
                result.failed(new ModuleVersionResolveException(moduleComponentIdentifier, throwable));
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed(new ArtifactResolveException(component.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE));
                return;
            }
            try {
                this.delegate.resolveArtifactsWithType(component, artifactType, result);
            }
            catch (Throwable throwable) {
                this.repositoryBlacklister.blacklistRepository(this.repositoryId, throwable);
                result.failed(new ArtifactResolveException(component.getId(), throwable));
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed(new ArtifactResolveException(component.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE));
                return;
            }
            try {
                this.delegate.resolveArtifacts(component, result);
            }
            catch (Throwable throwable) {
                this.repositoryBlacklister.blacklistRepository(this.repositoryId, throwable);
                result.failed(new ArtifactResolveException(component.getId(), throwable));
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            if (this.repositoryBlacklister.isBlacklisted(this.repositoryId)) {
                result.failed(new ArtifactResolveException(artifact.getId(), BLACKLISTED_REPOSITORY_ERROR_MESSAGE));
                return;
            }
            try {
                this.delegate.resolveArtifact(artifact, moduleSource, result);
            }
            catch (Throwable throwable) {
                this.repositoryBlacklister.blacklistRepository(this.repositoryId, throwable);
                result.failed(new ArtifactResolveException(artifact.getId(), throwable));
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return this.delegate.estimateMetadataFetchingCost(moduleComponentIdentifier);
        }
    }
}

