/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.io.File;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.BuildCommencedTimeProvider;

public class InMemoryModuleArtifactCache
implements ModuleArtifactCache {
    private final Map<ArtifactAtRepositoryKey, CachedArtifact> inMemoryCache = Maps.newConcurrentMap();
    private final BuildCommencedTimeProvider timeProvider;

    public InMemoryModuleArtifactCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public void store(ArtifactAtRepositoryKey key, File artifactFile, BigInteger moduleDescriptorHash) {
        this.inMemoryCache.put(key, new DefaultCachedArtifact(artifactFile, this.timeProvider.getCurrentTime(), moduleDescriptorHash));
    }

    @Override
    public void storeMissing(ArtifactAtRepositoryKey key, List<String> attemptedLocations, BigInteger descriptorHash) {
        this.inMemoryCache.put(key, new DefaultCachedArtifact(attemptedLocations, this.timeProvider.getCurrentTime(), descriptorHash));
    }

    @Override
    @Nullable
    public CachedArtifact lookup(ArtifactAtRepositoryKey key) {
        return this.inMemoryCache.get(key);
    }

    @Override
    public void clear(ArtifactAtRepositoryKey key) {
        this.inMemoryCache.remove(key);
    }
}

