/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

abstract class AttributeDesugaring {
    AttributeDesugaring() {
    }

    static ImmutableAttributes desugar(ImmutableAttributes attributes, ImmutableAttributesFactory attributesFactory) {
        if (attributes.isEmpty()) {
            return attributes;
        }
        AttributeContainerInternal mutable = attributesFactory.mutable();
        ImmutableSet<Attribute<?>> keySet = attributes.keySet();
        for (Attribute attribute : keySet) {
            Object value = attributes.getAttribute(attribute);
            Attribute desugared = (Attribute)Cast.uncheckedCast(attribute);
            if (attribute.getType() == Boolean.class || attribute.getType() == String.class) {
                mutable.attribute(desugared, value);
                continue;
            }
            desugared = (Attribute)Cast.uncheckedCast(Attribute.of(attribute.getName(), String.class));
            mutable.attribute(desugared, value.toString());
        }
        return mutable.asImmutable();
    }

    static ComponentSelector desugarSelector(ComponentSelector selector, ImmutableAttributesFactory attributesFactory) {
        ModuleComponentSelector module;
        AttributeContainer moduleAttributes;
        if (selector instanceof ModuleComponentSelector && !(moduleAttributes = (module = (ModuleComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)moduleAttributes).asImmutable();
            return DefaultModuleComponentSelector.newSelector(module.getModuleIdentifier(), module.getVersionConstraint(), AttributeDesugaring.desugar(attributes, attributesFactory));
        }
        return selector;
    }
}

