/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.api.internal.artifacts.transform.TransformInfo;
import org.gradle.api.internal.artifacts.transform.TransformInfoFactory;
import org.gradle.api.internal.artifacts.transform.UserCodeBackedTransformer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultTransformInfoFactory
implements TransformInfoFactory {
    private final Map<ArtifactTransformKey, TransformInfo> transformations = Maps.newConcurrentMap();

    @Override
    public Collection<TransformInfo> getOrCreate(ResolvedArtifactSet artifactSet, ArtifactTransformer transformer) {
        final List<UserCodeBackedTransformer> transformerChain = DefaultTransformInfoFactory.unpackTransformerChain(transformer);
        final ImmutableList.Builder builder = ImmutableList.builder();
        CompositeResolvedArtifactSet.visitHierarchy(artifactSet, new CompositeResolvedArtifactSet.ResolvedArtifactSetVisitor(){

            @Override
            public boolean visitArtifactSet(ResolvedArtifactSet set) {
                if (set instanceof CompositeResolvedArtifactSet) {
                    return true;
                }
                if (!(set instanceof BuildableSingleResolvedArtifactSet)) {
                    throw new IllegalStateException(String.format("Expecting a %s instead of a %s", BuildableSingleResolvedArtifactSet.class.getSimpleName(), set.getClass().getName()));
                }
                BuildableSingleResolvedArtifactSet singleArtifactSet = (BuildableSingleResolvedArtifactSet)set;
                TransformInfo transformInfo = DefaultTransformInfoFactory.this.getOrCreate(singleArtifactSet, transformerChain);
                builder.add((Object)transformInfo);
                return true;
            }
        });
        return builder.build();
    }

    private TransformInfo getOrCreate(BuildableSingleResolvedArtifactSet singleArtifactSet, List<UserCodeBackedTransformer> transformerChain) {
        ArtifactTransformKey key = new ArtifactTransformKey(singleArtifactSet.getArtifactId(), transformerChain);
        TransformInfo transformInfo = this.transformations.get(key);
        if (transformInfo == null) {
            if (transformerChain.size() == 1) {
                transformInfo = TransformInfo.initial(transformerChain.iterator().next(), singleArtifactSet);
            } else {
                TransformInfo previous = this.getOrCreate(singleArtifactSet, transformerChain.subList(0, transformerChain.size() - 1));
                transformInfo = TransformInfo.chained(transformerChain.get(transformerChain.size() - 1), previous, singleArtifactSet.getArtifactId());
            }
            this.transformations.put(key, transformInfo);
        }
        return transformInfo;
    }

    private static List<UserCodeBackedTransformer> unpackTransformerChain(ArtifactTransformer transformer) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        transformer.visitLeafTransformers((Action<? super ArtifactTransformer>)new Action<ArtifactTransformer>(){

            @Override
            public void execute(ArtifactTransformer transformer) {
                builder.add((Object)((UserCodeBackedTransformer)transformer));
            }
        });
        return builder.build();
    }

    private static class ArtifactTransformKey {
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final List<UserCodeBackedTransformer> transformers;

        private ArtifactTransformKey(ComponentArtifactIdentifier artifactIdentifier, List<UserCodeBackedTransformer> transformers) {
            this.artifactIdentifier = artifactIdentifier;
            this.transformers = transformers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactTransformKey that = (ArtifactTransformKey)o;
            if (!this.artifactIdentifier.equals(that.artifactIdentifier)) {
                return false;
            }
            return this.transformers.equals(that.transformers);
        }

        public int hashCode() {
            int result = this.artifactIdentifier.hashCode();
            result = 31 * result + this.transformers.hashCode();
            return result;
        }
    }
}

