/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

class TaskTypeTaskStateChanges
implements TaskStateChanges {
    private final TaskExecution previousExecution;
    private final TaskExecution currentExecution;
    private final TaskInternal task;

    public TaskTypeTaskStateChanges(TaskExecution previousExecution, TaskExecution currentExecution, TaskInternal task) {
        this.previousExecution = previousExecution;
        this.currentExecution = currentExecution;
        this.task = task;
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor) {
        ImplementationSnapshot prevImplementation = this.previousExecution.getTaskImplementation();
        ImplementationSnapshot taskImplementation = this.currentExecution.getTaskImplementation();
        if (!taskImplementation.getTypeName().equals(prevImplementation.getTypeName())) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' has changed type from '%s' to '%s'.", this.task.getIdentityPath(), prevImplementation.getTypeName(), taskImplementation.getTypeName()));
        }
        if (taskImplementation.hasUnknownClassLoader()) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' was loaded with an unknown classloader", this.task.getIdentityPath()));
        }
        if (prevImplementation.hasUnknownClassLoader()) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' was loaded with an unknown classloader during the previous execution", this.task.getIdentityPath()));
        }
        if (!taskImplementation.getClassLoaderHash().equals(prevImplementation.getClassLoaderHash())) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' class path has changed from %s to %s.", this.task.getIdentityPath(), prevImplementation.getClassLoaderHash(), taskImplementation.getClassLoaderHash()));
        }
        ImmutableList<ImplementationSnapshot> taskActionImplementations = this.currentExecution.getTaskActionImplementations();
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(taskActionImplementations)) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' has an additional action that was loaded with an unknown classloader", this.task.getIdentityPath()));
        }
        if (TaskTypeTaskStateChanges.hasAnyUnknownClassLoader(this.previousExecution.getTaskActionImplementations())) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' had an additional action that was loaded with an unknown classloader during the previous execution", this.task.getIdentityPath()));
        }
        if (!taskActionImplementations.equals(this.previousExecution.getTaskActionImplementations())) {
            return visitor.visitChange(new DescriptiveChange("Task '%s' has additional actions that have changed", this.task.getIdentityPath()));
        }
        return true;
    }

    private static boolean hasAnyUnknownClassLoader(Iterable<ImplementationSnapshot> implementations) {
        for (ImplementationSnapshot implementation : implementations) {
            if (!implementation.hasUnknownClassLoader()) continue;
            return true;
        }
        return false;
    }
}

