/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.internal.changedetection.state.ManagedNamedTypeSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;

public class IsolatedManagedNamedTypeSnapshot
extends ManagedNamedTypeSnapshot
implements Isolatable<Named> {
    private final Named value;
    private final NamedObjectInstantiator instantiator;

    public IsolatedManagedNamedTypeSnapshot(Named value, NamedObjectInstantiator instantiator) {
        super(value);
        this.value = value;
        this.instantiator = instantiator;
    }

    @Override
    public Named isolate() {
        return this.value;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        if (type.isAssignableFrom(this.value.getClass())) {
            return (Isolatable)Cast.uncheckedCast(this);
        }
        if (!Named.class.isAssignableFrom(type)) {
            return null;
        }
        for (Class<?> interfaceType : this.value.getClass().getInterfaces()) {
            if (!interfaceType.getName().equals(type.getName())) continue;
            return (Isolatable)Cast.uncheckedCast(new IsolatedManagedNamedTypeSnapshot((Named)this.instantiator.named(type, this.value.getName()), this.instantiator));
        }
        return null;
    }
}

