/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class CollectionFilter<T>
implements Spec<T> {
    private Class<? extends T> type;
    private Spec<? super T> spec;

    public CollectionFilter(Class<T> type) {
        this(type, Specs.satisfyAll());
    }

    public CollectionFilter(Class<? extends T> type, Spec<? super T> spec) {
        this.type = type;
        this.spec = spec;
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public T filter(Object object) {
        if (!this.type.isInstance(object)) {
            return null;
        }
        T t = this.type.cast(object);
        if (this.spec.isSatisfiedBy(t)) {
            return t;
        }
        return null;
    }

    @Override
    public boolean isSatisfiedBy(T element) {
        return this.filter(element) != null;
    }

    public <S extends T> CollectionFilter<S> and(CollectionFilter<S> other) {
        return new CollectionFilter<T>(other.type, Specs.intersect(this.spec, other.spec));
    }
}

