/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.util.GUtil;

public abstract class AbstractProvider<T>
implements ProviderInternal<T> {
    @Override
    public T get() {
        Object evaluatedValue = this.getOrNull();
        if (evaluatedValue == null) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }
        return evaluatedValue;
    }

    @Override
    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    @Override
    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), "?"));
    }
}

