/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.TaskDependencies;
import org.gradle.api.resources.internal.TextResourceInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.io.CharSource;
import org.gradle.internal.resource.ResourceExceptions;

public class CharSourceBackedTextResource
implements TextResourceInternal {
    private final String displayName;
    private final CharSource charSource;

    public CharSourceBackedTextResource(String displayName, CharSource charSource) {
        this.displayName = displayName;
        this.charSource = charSource;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String asString() {
        try {
            return this.charSource.read();
        }
        catch (IOException e) {
            throw ResourceExceptions.readFailed(this.displayName, (Throwable)e);
        }
    }

    @Override
    public Reader asReader() {
        try {
            return this.charSource.openStream();
        }
        catch (IOException e) {
            throw ResourceExceptions.readFailed(this.displayName, (Throwable)e);
        }
    }

    @Override
    public File asFile(String charset) {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    @Override
    public File asFile() {
        throw new UnsupportedOperationException("Cannot create file for char source " + this.charSource);
    }

    @Override
    public Object getInputProperties() {
        return null;
    }

    @Override
    public FileCollection getInputFiles() {
        return null;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return TaskDependencies.EMPTY;
    }
}

