/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public class CurrentCompilation {
    private final IncrementalTaskInputs inputs;
    private final JavaCompileSpec spec;
    private final ClasspathSnapshotProvider classpathSnapshotProvider;

    public CurrentCompilation(IncrementalTaskInputs inputs, JavaCompileSpec spec, ClasspathSnapshotProvider classpathSnapshotProvider) {
        this.inputs = inputs;
        this.spec = spec;
        this.classpathSnapshotProvider = classpathSnapshotProvider;
    }

    public ClasspathSnapshot getClasspathSnapshot() {
        return this.classpathSnapshotProvider.getClasspathSnapshot(Iterables.concat(this.spec.getCompileClasspath(), this.spec.getModulePath()));
    }

    public Collection<File> getAnnotationProcessorPath() {
        return this.spec.getAnnotationProcessorPath();
    }

    public void visitChanges(Action<InputFileDetails> action) {
        this.inputs.outOfDate(action);
        this.inputs.removed(action);
    }
}

