/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.internal.tasks.compile.processing.DefaultProcessorPath;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Splitter;
import org.gradle.util.DeprecationLogger;

public class AnnotationProcessorPathFactory {
    public static final String COMPILE_CLASSPATH_DEPRECATION_SUMMARY = "Annotation processors were detected on the compile classpath.";
    public static final String COMPILE_CLASSPATH_DEPRECATION_MESSAGE = "The following annotation processors were detected on the compile classpath:";
    public static final String PROCESSOR_PATH_DEPRECATION_MESSAGE = "Specifying the processor path in the CompilerOptions compilerArgs property";
    private final FileCollectionFactory fileCollectionFactory;
    private final AnnotationProcessorDetector annotationProcessorDetector;

    public AnnotationProcessorPathFactory(FileCollectionFactory fileCollectionFactory, AnnotationProcessorDetector annotationProcessorDetector) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.annotationProcessorDetector = annotationProcessorDetector;
    }

    public FileCollection getEffectiveAnnotationProcessorClasspath(CompileOptions compileOptions, FileCollection compileClasspath) {
        if (compileOptions.getAllCompilerArgs().contains("-proc:none")) {
            return this.fileCollectionFactory.empty("annotation processor path");
        }
        FileCollection annotationProcessorPath = compileOptions.getAnnotationProcessorPath();
        if (annotationProcessorPath != null && !(annotationProcessorPath instanceof DefaultProcessorPath)) {
            return annotationProcessorPath;
        }
        FileCollection processorPathFromCompilerArguments = this.getProcessorPathFromCompilerArguments(compileOptions);
        if (processorPathFromCompilerArguments != null) {
            return processorPathFromCompilerArguments;
        }
        if (compileClasspath == null) {
            return annotationProcessorPath;
        }
        return this.getProcessorPathWithCompileClasspathFallback(compileOptions, compileClasspath, annotationProcessorPath);
    }

    private FileCollection getProcessorPathFromCompilerArguments(CompileOptions compileOptions) {
        final FileCollection annotationProcessorPath = compileOptions.getAnnotationProcessorPath();
        List<String> compilerArgs = compileOptions.getAllCompilerArgs();
        int pos = compilerArgs.indexOf("-processorpath");
        if (pos < 0) {
            return null;
        }
        if (pos == compilerArgs.size() - 1) {
            throw new InvalidUserDataException("No path provided for compiler argument -processorpath in requested compiler args: " + Joiner.on((String)" ").join(compilerArgs));
        }
        final String processorpath = compilerArgs.get(pos + 1);
        if (annotationProcessorPath == null) {
            return this.fileCollectionFactory.fixed("annotation processor path", AnnotationProcessorPathFactory.extractProcessorPath(processorpath));
        }
        return this.fileCollectionFactory.create(new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(annotationProcessorPath);
            }
        }, new MinimalFileSet(){

            @Override
            public Set<File> getFiles() {
                if (!annotationProcessorPath.isEmpty()) {
                    return annotationProcessorPath.getFiles();
                }
                return AnnotationProcessorPathFactory.extractProcessorPath(processorpath);
            }

            @Override
            public final String getDisplayName() {
                return "annotation processor path";
            }
        });
    }

    private static Set<File> extractProcessorPath(String processorpath) {
        DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause(PROCESSOR_PATH_DEPRECATION_MESSAGE, "Instead, use the CompilerOptions.annotationProcessorPath property directly");
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String path : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)processorpath)) {
            files.add(new File(path));
        }
        return files;
    }

    private FileCollection getProcessorPathWithCompileClasspathFallback(CompileOptions compileOptions, final FileCollection compileClasspath, final FileCollection annotationProcessorPath) {
        final boolean hasExplicitProcessor = AnnotationProcessorPathFactory.checkExplicitProcessorOption(compileOptions);
        return this.fileCollectionFactory.create(new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                if (annotationProcessorPath != null) {
                    context.add(annotationProcessorPath);
                }
                context.add(compileClasspath);
            }
        }, new MinimalFileSet(){

            @Override
            public Set<File> getFiles() {
                if (annotationProcessorPath != null && !annotationProcessorPath.isEmpty()) {
                    return annotationProcessorPath.getFiles();
                }
                if (hasExplicitProcessor) {
                    return compileClasspath.getFiles();
                }
                Map<String, AnnotationProcessorDeclaration> processors = AnnotationProcessorPathFactory.this.annotationProcessorDetector.detectProcessors(compileClasspath);
                if (!processors.isEmpty()) {
                    DeprecationLogger.nagUserWithDeprecatedIndirectUserCodeCause("Detecting annotation processors on the compile classpath", "Gradle 5.0 will ignore annotation processors on the compile classpath.", "Please add them to the annotation processor path instead. If you did not intend to use annotation processors, you can use the '-proc:none' compiler argument to ignore them.", "The following annotation processors were detected on the compile classpath: '" + Joiner.on((String)"' and '").join(processors.keySet()) + "'. ");
                    return compileClasspath.getFiles();
                }
                return Collections.emptySet();
            }

            @Override
            public final String getDisplayName() {
                return "annotation processor path";
            }
        });
    }

    private static boolean checkExplicitProcessorOption(CompileOptions compileOptions) {
        boolean hasExplicitProcessor = false;
        List<String> compilerArgs = compileOptions.getAllCompilerArgs();
        int pos = compilerArgs.indexOf("-processor");
        if (pos >= 0) {
            if (pos == compilerArgs.size() - 1) {
                throw new InvalidUserDataException("No processor specified for compiler argument -processor in requested compiler args: " + Joiner.on((String)" ").join(compilerArgs));
            }
            hasExplicitProcessor = true;
        }
        return hasExplicitProcessor;
    }
}

