/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.io.File;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

@NonNullApi
public class GetOutputFilesVisitor
extends PropertyVisitor.Adapter {
    private final List<TaskOutputFilePropertySpec> specs = Lists.newArrayList();
    private ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties;
    private boolean hasDeclaredOutputs;

    @Override
    public void visitOutputFileProperty(TaskOutputFilePropertySpec outputFileProperty) {
        this.hasDeclaredOutputs = true;
        if (outputFileProperty instanceof CompositeTaskOutputPropertySpec) {
            Iterators.addAll(this.specs, ((CompositeTaskOutputPropertySpec)outputFileProperty).resolveToOutputProperties());
        } else {
            File outputFile;
            if (outputFileProperty instanceof CacheableTaskOutputFilePropertySpec && (outputFile = ((CacheableTaskOutputFilePropertySpec)outputFileProperty).getOutputFile()) == null) {
                return;
            }
            this.specs.add(outputFileProperty);
        }
    }

    public ImmutableSortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = TaskPropertyUtils.collectFileProperties("output", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasDeclaredOutputs() {
        return this.hasDeclaredOutputs;
    }
}

